comment !ON

Algo	: WG stream cipher by Yassir Nawaz and Guang Gong

Key	: 10/12/14/16 bytes ( 80/ 96/112/128 bits)
IV	:        4/ 8 bytes (         32/ 64 bits)


	push	_KeyLenBits		;80,96,112 or 128
	push	offset _Key		;Key ptr
	call	WG_SetKey

	push	_IVLenBits		;32/64
	push	offset _IV		;IV ptr
	call	WG_SetIV

	push	_InLenBytes
	push	offset _In		;source ptr
	push	offset _Out		;destination ptr
	call	WG_Crypt

	call	WG_Clear		;clear temporary data


Key	: 10/12/14/16 bytes ( 80/ 96/112/128 bits)
IV	: 10/12/14/16 bytes ( 80/ 96/112/128 bits)

	push	_KeyAndIVLenBits	;80,96,112 or 128
	push	offset _IV		;IV ptr
	push	offset _Key		;Key ptr
	call	WG_SetLongKeyIV

	push	_InLenBytes
	push	offset _In		;source ptr
	push	offset _Out		;destination ptr
	call	WG_Crypt

	call	WG_Clear		;clear temporary data


27.06.2005 WiteG (witeg@poczta.fm, www.witeg.prv.pl)

comment !OFF


ANDXOR_EBP	MACRO	_ROL_A, _ROL_B

	mov	edx, eax	;*
	shr	esi, (29-_ROL_A)
	shl	edx, _ROL_A
	mov	edi, ebx
	xor	edx, esi	;A[_ROL_A]
	shr	edi, (29-_ROL_B)
	mov	esi, ebx
	shl	esi, (_ROL_B)
	xor	edi, esi	;B[_ROL_B]
	xor	ebp, edi
	mov	esi, eax	;*
	and	ebp, edx
	xor	ecx, ebp

ENDM

ANDXOR_EDI	MACRO	_ROL_A, _ROL_B

	mov	edx, eax
	shr	esi, (29-_ROL_A)
	shl	edx, _ROL_A
	mov	ebp, ebx
	xor	edx, esi	;A[_ROL_A]
	shr	ebp, (29-_ROL_B)
	mov	esi, ebx
	shl	esi, (_ROL_B)
	xor	ebp, esi	;B[_ROL_B]
	xor	edi, ebp
	mov	esi, eax
	and	edi, edx
	xor	ecx, edi

ENDM

.data
S		dd 11 dup (?)
alpha_0		dd ?
alpha_1		dd ?
alpha_2		dd ?
alpha_3		dd ?
alpha_inv	dd ?
alpha_inv9	dd ?
temp1		dd ?
temp2		dd ?
counter		dd ?
outByte		dd ?

.code
OPTION PROLOGUE:NONE
OPTION EPILOGUE:NONE

WG_SetKey	proc	ptrKey:DWORD, lKey:DWORD

	pushad
	mov	edi, offset S
	mov	ecx, 11
	mov	esi, dword ptr [esp+20h+4]	;ptrKey
	mov	ebx, edi
	xor	eax, eax
	cld
	rep	stosd

	mov	edx, dword ptr [esp+20h+4+4]	;lKey
	mov	edi, edx
	and	edi, 7
	jnz	@invalidKeyLen
	shr	edx, 3
	mov	ecx, edx
	sub	edx, 10
	js	@invalidKeyLen
	jz	@F
	cmp	edx, 2
	jz	@F
	cmp	edx, 4
	jz	@F
	cmp	edx, 6
	jnz	@invalidKeyLen

@@:	shr	ecx, 1
@@:	mov	ax, word ptr [esi]
	xchg	al, ah
	inc	esi
	mov	word ptr [ebx+2], ax
	inc	esi
	add	ebx, 4
	dec	ecx
	jnz	@B

	mov	esi, dword ptr [esp+20h+4]	;ptrKey
	mov	ax, word ptr [esi]
	xchg	al, ah
	xor	word ptr [S+4*8+2], ax

	mov	ax, word ptr [esi+2]
	not	ax
	xchg	al, ah
	xor	word ptr [S+4*9+2], ax

	mov	ax, word ptr [esi+4]
	xchg	al, ah
	xor	word ptr [S+4*10+2], ax

@@:	mov	dword ptr [esp+28], ecx
	popad
	ret	8

@invalidKeyLen:
	or	ecx, -1
	jmp	@B

WG_SetKey	endp

WG_SetIV	proc	ptrIV:DWORD, lIV:DWORD

	pushad

	mov	ecx, dword ptr [esp+20h+4+4]	;lIV
	mov	esi, dword ptr [esp+20h+4]	;ptrIV
	mov	edx, ecx
	and	edx, 7
	jnz	@invalidIVLen

	shr	ecx, 3
	cmp	ecx, 4
	jz	@F
	cmp	ecx, 8
	jnz	@invalidIVLen

@@:	xor	ebx, ebx
@@:	mov	al, byte ptr [esi+ebx]
	mov	byte ptr [S+4*ebx+1], al
	inc	ebx
	cmp	ebx, ecx
	jnz	@B

	mov	dword ptr [counter], 22

@@:		mov	eax, dword ptr [S+4*10]
		not	eax
		and	eax, 0FFFFFFF8h
		mov	dword ptr [alpha_0], eax
		mov	ebx, eax
		mov	edx, eax
		shl	ebx, (29-9)
		shr	edx, 9
		mov	esi, eax
		xor	ebx, edx
		mov	edi, eax
		shl	esi, (29-10)
		and	ebx, 0FFFFFFF8h
		shr	edi, 10
		mov	dword ptr [alpha_1], ebx
		xor	esi, edi
		mov	ebx, eax
		mov	edx, eax
		shl	ebx, (29-19)
		shr	edx, 19
		and	esi, 0FFFFFFF8h
		xor	ebx, edx
		mov	dword ptr [alpha_2], esi
		and	ebx, 0FFFFFFF8h
		mov	dword ptr [alpha_3], ebx

		mov	ebx, eax		;ebx = alpha_inv = alpha[0];
		mov	edx, eax
		mov	ecx, ebx
		shl	edx, 16
		shl	ecx, 8
		shr	eax, (29-16)
		shr	ebx, (29-8)
		xor	eax, edx
		xor	ebx, ecx
		and	eax, 0FFFFFFF8h		;eax = alpha_inv = ROTL29(alpha_inv, 16);
		and	ebx, 0FFFFFFF8h
		call	GF29MULT
		mov	ebx, dword ptr [alpha_0]
		call	GF29MULT
						;*3*
		mov	ebx, eax
		shl	ebx, 8
		shr	eax, (29-8)
		xor	eax, ebx
		and	eax, 0FFFFFFF8h

		mov	ebx, eax
		mov	edx, eax
		shl	ebx, (29-4)
		shr	edx, 4
		xor	ebx, edx
		and	ebx, 0FFFFFFF8h
		call	GF29MULT
		
		mov	ebx, dword ptr [alpha_0]
		call	GF29MULT
						;*2*
		mov	ebx, eax
		shl	ebx, 4
		shr	eax, (29-4)
		xor	eax, ebx
		and	eax, 0FFFFFFF8h

		mov	ebx, eax
		mov	edx, eax
		shl	ebx, (29-2)
		shr	edx, 2
		xor	ebx, edx
		and	ebx, 0FFFFFFF8h
		call	GF29MULT
						;*1*
		mov	ebx, eax
		mov	edx, eax
		shl	ebx, (29-1)
		shr	edx, 1
		xor	ebx, edx
		and	ebx, 0FFFFFFF8h
		call	GF29MULT
						;eax = alpha^-1
		mov	dword ptr [alpha_inv], eax

		mov	ebx, eax
		shl	ebx, (29-9)
		shr	eax, 9
		xor	eax, ebx
		and	eax, 0FFFFFFF8h

		mov	dword ptr [alpha_inv9], eax


		mov	eax, dword ptr [alpha_2]
		mov	ebx, dword ptr [alpha_0]
		call	GF29MULT
		xor	eax, dword ptr [S+4*10]

		mov	dword ptr [temp1], eax

		mov	eax, dword ptr [alpha_3]
		mov	ebx, dword ptr [alpha_0]
		call	GF29MULT

		mov	dword ptr [temp2], eax
		mov	ebx, dword ptr [alpha_inv9]
		call	GF29MULT
		xor	dword ptr [temp1], eax

		mov	eax, dword ptr [temp2]
		mov	ebx, dword ptr [alpha_1]
		call	GF29MULT
		xor	dword ptr [temp1], eax

		mov	ebx, dword ptr [alpha_3]
		mov	eax, dword ptr [alpha_2]
		call	GF29MULT

		mov	ebx, dword ptr [alpha_inv]
		call	GF29MULT

		xor	dword ptr [temp1], eax

		mov	ebx, 7F3FC9B0h
		mov	eax, dword ptr [S+4*10]
		call	GF29MULT

		xor	eax, dword ptr [temp1]		;S10^q1^q2^q3^q4
		xor	eax, dword ptr [S+4*9]
		xor	eax, dword ptr [S+4*7]
		xor	eax, dword ptr [S+4*4]
		xor	eax, dword ptr [S+4*1]
		xor	eax, dword ptr [S+4*0]

		;eax = S[10]

		mov	ebx, dword ptr [S+4*9]
		mov	ecx, dword ptr [S+4*8]
		mov	edx, dword ptr [S+4*7]
		mov	dword ptr [S+4*10], ebx
		mov	dword ptr [S+4* 9], ecx
		mov	dword ptr [S+4* 8], edx
		mov	ebx, dword ptr [S+4*6]
		mov	ecx, dword ptr [S+4*5]
		mov	edx, dword ptr [S+4*4]
		mov	dword ptr [S+4* 7], ebx
		mov	dword ptr [S+4* 6], ecx
		mov	dword ptr [S+4* 5], edx
		mov	ebx, dword ptr [S+4*3]
		mov	ecx, dword ptr [S+4*2]
		mov	edx, dword ptr [S+4*1]
		mov	esi, dword ptr [S+4*0]
		mov	dword ptr [S+4* 4], ebx
		mov	dword ptr [S+4* 3], ecx
		mov	dword ptr [S+4* 2], edx
		mov	dword ptr [S+4* 1], esi
		mov	dword ptr [S+4* 0], eax

		dec	dword ptr [counter]
		jnz	@B

	xor	eax, eax

@@:	mov	dword ptr [esp+28], eax
	popad
	ret	8

@invalidIVLen:
	or	eax, -1
	jmp	@B
WG_SetIV	endp

WG_Crypt	proc	ptrOut:DWORD, ptrIn:DWORD, lenIn:DWORD

	pushad

	xor	ebx, ebx
	mov	ecx, dword ptr [esp+20h+4+8]	;lenIn
	mov	esi, dword ptr [esp+20h+4+4]	;ptrIn
	mov	edi, dword ptr [esp+20h+4]	;ptrOut

@@:	call	WG_KeyStream
	xor	al, byte ptr [esi+ebx]
	mov	byte ptr [edi+ebx], al
	inc	ebx
	cmp	ebx, ecx
	jnz	@B

	popad
	ret	12

WG_Crypt	endp

WG_KeyStream	proc

	pushad
	and	byte ptr [outByte], 0
	mov	dword ptr [counter], 8

@@:		mov	eax, 7F3FC9B0h
		mov	ebx, dword ptr [S+4*10]
		call	GF29MULT
						;eax = 
		xor	eax, dword ptr [S+4*9]
		xor	eax, dword ptr [S+4*7]
		xor	eax, dword ptr [S+4*4]
		xor	eax, dword ptr [S+4*1]
		xor	eax, dword ptr [S+4*0]

		;eax = S[10]

		mov	ebx, dword ptr [S+4*9]
		mov	ecx, dword ptr [S+4*8]
		mov	edx, dword ptr [S+4*7]
		mov	dword ptr [S+4*10], ebx
		mov	dword ptr [S+4* 9], ecx
		mov	dword ptr [S+4* 8], edx
		mov	ebx, dword ptr [S+4*6]
		mov	ecx, dword ptr [S+4*5]
		mov	edx, dword ptr [S+4*4]
		mov	dword ptr [S+4* 7], ebx
		mov	dword ptr [S+4* 6], ecx
		mov	dword ptr [S+4* 5], edx
		mov	ebx, dword ptr [S+4*3]
		mov	ecx, dword ptr [S+4*2]
		mov	edx, dword ptr [S+4*1]
		mov	esi, dword ptr [S+4*0]
		mov	dword ptr [S+4* 4], ebx
		mov	dword ptr [S+4* 3], ecx
		mov	dword ptr [S+4* 2], edx
		mov	dword ptr [S+4* 1], esi
		mov	dword ptr [S+4* 0], eax

		not	eax
		and	eax, 0FFFFFFF8h
		mov	dword ptr [alpha_0], eax
		mov	ebx, eax
		mov	edx, eax
		shl	ebx, (29-9)
		shr	edx, 9
		mov	esi, eax
		xor	ebx, edx
		mov	edi, eax
		shl	esi, (29-10)
		and	ebx, 0FFFFFFF8h
		shr	edi, 10
		mov	dword ptr [alpha_1], ebx
		xor	esi, edi
		mov	ebx, eax
		mov	edx, eax
		shl	ebx, (29-19)
		shr	edx, 19
		and	esi, 0FFFFFFF8h
		xor	ebx, edx
		mov	dword ptr [alpha_2], esi
		and	ebx, 0FFFFFFF8h
		mov	dword ptr [alpha_3], ebx

		mov	ebx, eax		;ebx = alpha_inv = alpha[0];
		mov	edx, eax
		mov	ecx, ebx
		shl	edx, 16
		shl	ecx, 8
		shr	eax, (29-16)
		shr	ebx, (29-8)
		xor	eax, edx
		xor	ebx, ecx
		and	eax, 0FFFFFFF8h		;eax = alpha_inv = ROTL29(alpha_inv, 16);
		and	ebx, 0FFFFFFF8h
		call	GF29MULT
		mov	ebx, dword ptr [alpha_0]
		call	GF29MULT
						;*3*
		mov	ebx, eax
		shl	ebx, 8
		shr	eax, (29-8)
		xor	eax, ebx
		and	eax, 0FFFFFFF8h

		mov	ebx, eax
		mov	edx, eax
		shl	ebx, (29-4)
		shr	edx, 4
		xor	ebx, edx
		and	ebx, 0FFFFFFF8h
		call	GF29MULT
		
		mov	ebx, dword ptr [alpha_0]
		call	GF29MULT
						;*2*
		mov	ebx, eax
		shl	ebx, 4
		shr	eax, (29-4)
		xor	eax, ebx
		and	eax, 0FFFFFFF8h

		mov	ebx, eax
		mov	edx, eax
		shl	ebx, (29-2)
		shr	edx, 2
		xor	ebx, edx
		and	ebx, 0FFFFFFF8h
		call	GF29MULT
						;*1*
		mov	ebx, eax
		mov	edx, eax
		shl	ebx, (29-1)
		shr	edx, 1
		xor	ebx, edx
		and	ebx, 0FFFFFFF8h
		call	GF29MULT
						;eax = alpha^-1
		mov	dword ptr [alpha_inv], eax

		mov	ebx, eax
		shl	ebx, (29-9)
		shr	eax, 9
		xor	eax, ebx
		and	eax, 0FFFFFFF8h

		mov	dword ptr [alpha_inv9], eax


		mov	eax, dword ptr [alpha_2]
		mov	ebx, dword ptr [alpha_0]
		call	GF29MULT

		mov	dword ptr [temp1], eax

		mov	eax, dword ptr [alpha_3]
		mov	ebx, dword ptr [alpha_0]
		call	GF29MULT

		mov	dword ptr [temp2], eax
		mov	ebx, dword ptr [alpha_inv9]
		call	GF29MULT
		xor	dword ptr [temp1], eax

		mov	eax, dword ptr [temp2]
		mov	ebx, dword ptr [alpha_1]
		call	GF29MULT
		xor	dword ptr [temp1], eax

		mov	ebx, dword ptr [alpha_3]
		mov	eax, dword ptr [alpha_2]
		call	GF29MULT

		mov	ebx, dword ptr [alpha_inv]
		call	GF29MULT

		xor	eax, dword ptr [temp1]
		xor	eax, dword ptr [alpha_0]
		not	eax
		and	eax, 0FFFFFFF8h

		mov	edx, eax
		shr	edx, 16
		xor	eax, edx
		mov	edx, eax
		shr	edx, 8
		xor	eax, edx
		mov	bl, byte ptr [outByte]
		setnp	al
		shl	bl, 1

		xor	bl, al
		mov	byte ptr [outByte], bl

		dec	dword ptr [counter]
		jnz	@B

	movzx	eax, byte ptr [outByte]
	mov	dword ptr [esp+28], eax
	popad
	ret
WG_KeyStream	endp

WG_Clear	proc
	push	eax
	push	ecx
	push	edi

	xor	eax, eax
	mov	ecx, 21
	mov	edi, offset S
	cld
	rep	stosd

	pop	edi
	pop	ecx
	pop	eax
	ret
WG_Clear	endp

WG_SetLongKeyIV	proc	ptrKey:DWORD, ptrIV:DWORD, lenKIV:DWORD

	pushad

	mov	esi, dword ptr [esp+20h+4]	;ptrKey
	mov	ebx, dword ptr [esp+20h+4+4]	;ptrIV
	mov	edi, offset S
	mov	ecx, dword ptr [esp+20h+4+8]	;lenKIV
	xor	edx, edx
	mov	eax, ecx
	and	eax, 7
	jnz	@invalidIVKeyLen
	shr	ecx, 3
	cmp	ecx, 10
	jz	@validIVKeyLen
	cmp	ecx, 12
	jz	@validIVKeyLen
	cmp	ecx, 14
	jz	@validIVKeyLen
	cmp	ecx, 16
	jnz	@invalidIVKeyLen

@validIVKeyLen:
	mov	ax, word ptr [esi]	;01
	xchg	al, ah
	shl	eax, 16
	mov	ah, byte ptr [ebx]	;I
	mov	dword ptr [edi], eax

	mov	ah, byte ptr [esi+2]	;2
	shl	eax, 8
	mov	ax, word ptr [ebx+1]	;JK
	xchg	al, ah
	shl	eax, 8
	mov	dword ptr [edi+4], eax

	mov	ax, word ptr [esi+3]	;34
	xchg	al, ah
	shl	eax, 16
	mov	ah, byte ptr [ebx+3]	;L
	mov	dword ptr [edi+8], eax

	mov	ah, byte ptr [esi+5]	;5
	shl	eax, 8
	mov	ax, word ptr [ebx+4]	;MN
	xchg	al, ah
	shl	eax, 8
	mov	dword ptr [edi+12], eax

	mov	ax, word ptr [esi+6]	;67
	xchg	al, ah
	shl	eax, 16
	mov	ah, byte ptr [ebx+6]	;O
	mov	dword ptr [edi+16], eax

	mov	ah, byte ptr [esi+8]	;8
	shl	eax, 8
	mov	ax, word ptr [ebx+7]	;PQ
	xchg	al, ah
	shl	eax, 8
	mov	dword ptr [edi+20], eax

	mov	al, byte ptr [esi+9]
	shl	eax, 24
	mov	ah, byte ptr [ebx+9]
	mov	dword ptr [edi+24], eax	;S[ 6]
	and	dword ptr [edi+28], 0	;S[ 7]
	and	dword ptr [edi+32], 0	;S[ 8]
	and	dword ptr [edi+36], 0	;S[ 9]
	and	dword ptr [edi+40], 0	;S[10]

	cmp	ecx, 10
	jz	@done

	movzx	eax, byte ptr [esi+10]
	shl	eax, 16
	or	dword ptr [edi+24], eax	;S[ 6]

	mov	ah, byte ptr [esi+11]
	shl	eax, 8
	mov	ax, word ptr [ebx+10]
	xchg	al, ah
	shl	eax, 8
	mov	dword ptr [edi+28], eax

	cmp	ecx, 12
	jz	@done

	mov	ax, word ptr [esi+12]
	xchg	al, ah
	shl	eax, 16
	mov	ah, byte ptr [ebx+12]
	mov	dword ptr [edi+32], eax

	movzx	eax, byte ptr [ebx+13]
	shl	eax, 16
	mov	dword ptr [edi+36], eax

	cmp	ecx, 14
	jz	@done
            	
 	mov	al, byte ptr [esi+14]
	shl	eax, 24
	mov	ah, byte ptr [ebx+14]
	or	dword ptr [edi+36], eax

	mov	ah, byte ptr [esi+15]
	mov	al, byte ptr [ebx+15]
	shl	eax, 16
	mov	dword ptr [edi+40], eax

@done:
	mov	dword ptr [counter], 22

@@:		mov	eax, dword ptr [S+4*10]
		not	eax
		and	eax, 0FFFFFFF8h
		mov	dword ptr [alpha_0], eax
		mov	ebx, eax
		mov	edx, eax
		shl	ebx, (29-9)
		shr	edx, 9
		mov	esi, eax
		xor	ebx, edx
		mov	edi, eax
		shl	esi, (29-10)
		and	ebx, 0FFFFFFF8h
		shr	edi, 10
		mov	dword ptr [alpha_1], ebx
		xor	esi, edi
		mov	ebx, eax
		mov	edx, eax
		shl	ebx, (29-19)
		shr	edx, 19
		and	esi, 0FFFFFFF8h
		xor	ebx, edx
		mov	dword ptr [alpha_2], esi
		and	ebx, 0FFFFFFF8h
		mov	dword ptr [alpha_3], ebx

		mov	ebx, eax		;ebx = alpha_inv = alpha[0];
		mov	edx, eax
		mov	ecx, ebx
		shl	edx, 16
		shl	ecx, 8
		shr	eax, (29-16)
		shr	ebx, (29-8)
		xor	eax, edx
		xor	ebx, ecx
		and	eax, 0FFFFFFF8h		;eax = alpha_inv = ROTL29(alpha_inv, 16);
		and	ebx, 0FFFFFFF8h
		call	GF29MULT
		mov	ebx, dword ptr [alpha_0]
		call	GF29MULT
						;*3*
		mov	ebx, eax
		shl	ebx, 8
		shr	eax, (29-8)
		xor	eax, ebx
		and	eax, 0FFFFFFF8h

		mov	ebx, eax
		mov	edx, eax
		shl	ebx, (29-4)
		shr	edx, 4
		xor	ebx, edx
		and	ebx, 0FFFFFFF8h
		call	GF29MULT
		
		mov	ebx, dword ptr [alpha_0]
		call	GF29MULT
						;*2*
		mov	ebx, eax
		shl	ebx, 4
		shr	eax, (29-4)
		xor	eax, ebx
		and	eax, 0FFFFFFF8h

		mov	ebx, eax
		mov	edx, eax
		shl	ebx, (29-2)
		shr	edx, 2
		xor	ebx, edx
		and	ebx, 0FFFFFFF8h
		call	GF29MULT
						;*1*
		mov	ebx, eax
		mov	edx, eax
		shl	ebx, (29-1)
		shr	edx, 1
		xor	ebx, edx
		and	ebx, 0FFFFFFF8h
		call	GF29MULT
						;eax = alpha^-1
		mov	dword ptr [alpha_inv], eax

		mov	ebx, eax
		shl	ebx, (29-9)
		shr	eax, 9
		xor	eax, ebx
		and	eax, 0FFFFFFF8h

		mov	dword ptr [alpha_inv9], eax


		mov	eax, dword ptr [alpha_2]
		mov	ebx, dword ptr [alpha_0]
		call	GF29MULT
		xor	eax, dword ptr [S+4*10]

		mov	dword ptr [temp1], eax

		mov	eax, dword ptr [alpha_3]
		mov	ebx, dword ptr [alpha_0]
		call	GF29MULT

		mov	dword ptr [temp2], eax
		mov	ebx, dword ptr [alpha_inv9]
		call	GF29MULT
		xor	dword ptr [temp1], eax

		mov	eax, dword ptr [temp2]
		mov	ebx, dword ptr [alpha_1]
		call	GF29MULT
		xor	dword ptr [temp1], eax

		mov	ebx, dword ptr [alpha_3]
		mov	eax, dword ptr [alpha_2]
		call	GF29MULT

		mov	ebx, dword ptr [alpha_inv]
		call	GF29MULT

		xor	dword ptr [temp1], eax

		mov	ebx, 7F3FC9B0h
		mov	eax, dword ptr [S+4*10]
		call	GF29MULT

		xor	eax, dword ptr [temp1]		;S10^q1^q2^q3^q4
		xor	eax, dword ptr [S+4*9]
		xor	eax, dword ptr [S+4*7]
		xor	eax, dword ptr [S+4*4]
		xor	eax, dword ptr [S+4*1]
		xor	eax, dword ptr [S+4*0]

		;eax = S[10]

		mov	ebx, dword ptr [S+4*9]
		mov	ecx, dword ptr [S+4*8]
		mov	edx, dword ptr [S+4*7]
		mov	dword ptr [S+4*10], ebx
		mov	dword ptr [S+4* 9], ecx
		mov	dword ptr [S+4* 8], edx
		mov	ebx, dword ptr [S+4*6]
		mov	ecx, dword ptr [S+4*5]
		mov	edx, dword ptr [S+4*4]
		mov	dword ptr [S+4* 7], ebx
		mov	dword ptr [S+4* 6], ecx
		mov	dword ptr [S+4* 5], edx
		mov	ebx, dword ptr [S+4*3]
		mov	ecx, dword ptr [S+4*2]
		mov	edx, dword ptr [S+4*1]
		mov	esi, dword ptr [S+4*0]
		mov	dword ptr [S+4* 4], ebx
		mov	dword ptr [S+4* 3], ecx
		mov	dword ptr [S+4* 2], edx
		mov	dword ptr [S+4* 1], esi
		mov	dword ptr [S+4* 0], eax

		dec	dword ptr [counter]
		jnz	@B

	xor	eax, eax

@@:	mov	dword ptr [esp+28], eax
	popad
	ret	12

@invalidIVKeyLen:
	or	eax, -1
	jmp	@B

WG_SetLongKeyIV	endp

GF29MULT:
	mov	edx, eax
	mov	ebp, ebx
	mov	esi, eax
	mov	edi, ebx

	shl	edx, 1
	shr	esi, (29-1)
	shl	ebp, 21
	xor	edx, esi
	shr	edi, (29-21)
	xor	ebp, edi
	mov	ecx, ebx
	xor	ecx, ebp
	mov	esi, eax	;*
	and	ecx, edx	;ecx = c= A[ 1] & (B[21] ^ B[0])
				;ebp = B[21]
	ANDXOR_EBP	 2, 6
	ANDXOR_EDI	22,18
	ANDXOR_EBP	 3,13
	ANDXOR_EDI	 7,25
	ANDXOR_EBP	23,16
	ANDXOR_EDI	19,27
	ANDXOR_EBP	 4,11
	ANDXOR_EDI	14, 9
	ANDXOR_EBP	 8,10
	ANDXOR_EDI	26,15
	ANDXOR_EBP	24,12
	ANDXOR_EDI	17, 5
	ANDXOR_EBP	20,28
	ANDXOR_EDI	28,20
	ANDXOR_EBP	 5,17
	ANDXOR_EDI	12,24
	ANDXOR_EBP	15,26
	ANDXOR_EDI	10, 8
	ANDXOR_EBP	 9,14
	ANDXOR_EDI	11, 4
	ANDXOR_EBP	27,19
	ANDXOR_EDI	16,23
	ANDXOR_EBP	25, 7
	ANDXOR_EDI	13, 3
	ANDXOR_EBP	18,22
	ANDXOR_EDI	 6, 2
	ANDXOR_EBP	21, 1

	and	eax, edi
	xor	eax, ecx
	and	eax, 0FFFFFFF8h
	ret

OPTION PROLOGUE:DEFAULT
OPTION EPILOGUE:DEFAULT