comment ~

TEA (Tiny Encryption Algorithm)

wielkosc bloku : 8 bajtow
dlugosc klucza : 16 bajtow

	invoke	TEA_encode, ADDR _data, ADDR _key
	invoke	TEA_decode, ADDR _data, ADDR _key

WiteG//xtreeme

~

TEA_encode	PROTO	:DWORD,:DWORD
TEA_decode	PROTO	:DWORD,:DWORD

.data?
internal_key	dd 4 dup(?)

.code
TEA_encode	PROC	ptrData:DWORD, ptrKey:DWORD
	pushad

	mov	esi, ptrKey	
	mov	eax, dword ptr [esi]
	mov	ebx, dword ptr [esi+4]
	mov	ecx, dword ptr [esi+8]
	mov	edx, dword ptr [esi+12]	
	mov	dword ptr [internal_key], eax
	mov	dword ptr [internal_key+4], ebx
	mov	dword ptr [internal_key+8], ecx
	mov	dword ptr [internal_key+12], edx

	push	ebp
	mov	ebx, ptrData
	xor	edx, edx			;suma
	mov	esi, dword ptr [ebx]
	mov	edi, dword ptr [ebx+4]
	mov	ebp, 32

_loop:
	add	edx, 9E3779B9h			;sum += DELTA;

	mov	eax, edi
	mov	ecx, eax
	mov	ebx, edi
	shl	eax, 4
	shr	ebx, 5
	add	eax, dword ptr [internal_key+ 0*4]
	add	ebx, dword ptr [internal_key+ 1*4]
	add	ecx, edx
	xor	ecx, eax
	xor	ecx, ebx

	add	esi, ecx			;esi = y	;y += (z << 4)+a ^ z+sum ^ (z >> 5)+b;

	mov	eax, esi
	mov	ebx, esi
	mov	ecx, esi

	shl	eax, 4
	shr	ebx, 5
	add	eax, dword ptr [internal_key+ 2*4]
	add	ebx, dword ptr [internal_key+ 3*4]
	add	ecx, edx
	xor	ecx, eax
	xor	ecx, ebx

	add	edi, ecx			;edi = z	;z += (y << 4)+c ^ y+sum ^ (y >> 5)+d;

	dec	ebp
	jnz	_loop

	mov	dword ptr [internal_key], ebp
	mov	dword ptr [internal_key+4], ebp
	mov	dword ptr [internal_key+8], ebp
	mov	dword ptr [internal_key+12], ebp
	
	pop	ebp
	mov	ebx, ptrData
	mov	dword ptr [ebx], esi
	mov	dword ptr [ebx+4], edi
	popad
	ret
TEA_encode	ENDP


TEA_decode	PROC	ptrData:DWORD, ptrKey:DWORD
	pushad
	
	mov	esi, ptrKey	
	mov	eax, dword ptr [esi]
	mov	ebx, dword ptr [esi+4]
	mov	ecx, dword ptr [esi+8]
	mov	edx, dword ptr [esi+12]	
	mov	dword ptr [internal_key], eax
	mov	dword ptr [internal_key+4], ebx
	mov	dword ptr [internal_key+8], ecx
	mov	dword ptr [internal_key+12], edx

	push	ebp
	mov	ebx, ptrData
	mov	edx, 0C6EF3720h
	mov	esi, dword ptr [ebx]
	mov	edi, dword ptr [ebx+4]
	mov	ebp, 32

_loop:
	mov	eax, esi
	mov	ebx, esi
	mov	ecx, esi
	shl	eax, 4
	add	eax, dword ptr [internal_key+ 2*4]
	shr	ebx, 5
	add	ebx, dword ptr [internal_key+ 3*4]
	add	ecx, edx
	xor	ecx, eax
	xor	ecx, ebx
	sub	edi, ecx			;edi = z	;z -= (y << 4)+c ^ y+sum ^ (y >> 5)+d;
	mov	eax, edi
	mov	ebx, eax
	mov	ecx, eax
	shl	eax, 4
	add	eax, dword ptr [internal_key+ 0*4]
	shr	ebx, 5
	add	ebx, dword ptr [internal_key+ 1*4]
	add	ecx, edx
	xor	ecx, eax
	xor	ecx, ebx
	sub	esi, ecx			;esi = y	;y -= (z << 4)+a ^ z+sum ^ (z >> 5)+b;
	sub	edx, 9E3779B9h			;sum -= DELTA;
	dec	ebp
	jnz	_loop

	mov	dword ptr [internal_key], ebp
	mov	dword ptr [internal_key+4], ebp
	mov	dword ptr [internal_key+8], ebp
	mov	dword ptr [internal_key+12], ebp
	
	pop	ebp
	mov	ebx, ptrData
	mov	dword ptr [ebx], esi
	mov	dword ptr [ebx+4], edi
	popad
	ret
TEA_decode	ENDP