comment ~

Algo	: Square by Joan Daemen and Vincent Rijmen
Block	: 16 bytes
Key	: 16 bytes (128b)

encryption:
	push	offset password
	call	Square_SetEncryptKey
	
	push	offset plaintext
	push	offset ciphertext
	call	Square_Encrypt

	call	Square_Clear

decryption:
	push	offset password
	call	Square_SetDecryptKey

	push	offset ciphertext
	push	offset plaintext
	call	Square_Decrypt
	
	call	Square_Clear

23.03.2002 WiteG//xtreeme (witeg@poczta.fm, www.witeg.prv.pl)

~
.code
phi		dd	000000000h, 003010102h, 006020204h, 005030306h, 00c040408h, 00f05050ah, 00a06060ch, 00907070eh
		dd	018080810h, 01b090912h, 01e0a0a14h, 01d0b0b16h, 0140c0c18h, 0170d0d1ah, 0120e0e1ch, 0110f0f1eh
		dd	030101020h, 033111122h, 036121224h, 035131326h, 03c141428h, 03f15152ah, 03a16162ch, 03917172eh
		dd	028181830h, 02b191932h, 02e1a1a34h, 02d1b1b36h, 0241c1c38h, 0271d1d3ah, 0221e1e3ch, 0211f1f3eh
		dd	060202040h, 063212142h, 066222244h, 065232346h, 06c242448h, 06f25254ah, 06a26264ch, 06927274eh
		dd	078282850h, 07b292952h, 07e2a2a54h, 07d2b2b56h, 0742c2c58h, 0772d2d5ah, 0722e2e5ch, 0712f2f5eh
		dd	050303060h, 053313162h, 056323264h, 055333366h, 05c343468h, 05f35356ah, 05a36366ch, 05937376eh
		dd	048383870h, 04b393972h, 04e3a3a74h, 04d3b3b76h, 0443c3c78h, 0473d3d7ah, 0423e3e7ch, 0413f3f7eh
		dd	0c0404080h, 0c3414182h, 0c6424284h, 0c5434386h, 0cc444488h, 0cf45458ah, 0ca46468ch, 0c947478eh
		dd	0d8484890h, 0db494992h, 0de4a4a94h, 0dd4b4b96h, 0d44c4c98h, 0d74d4d9ah, 0d24e4e9ch, 0d14f4f9eh
		dd	0f05050a0h, 0f35151a2h, 0f65252a4h, 0f55353a6h, 0fc5454a8h, 0ff5555aah, 0fa5656ach, 0f95757aeh
		dd	0e85858b0h, 0eb5959b2h, 0ee5a5ab4h, 0ed5b5bb6h, 0e45c5cb8h, 0e75d5dbah, 0e25e5ebch, 0e15f5fbeh
		dd	0a06060c0h, 0a36161c2h, 0a66262c4h, 0a56363c6h, 0ac6464c8h, 0af6565cah, 0aa6666cch, 0a96767ceh
		dd	0b86868d0h, 0bb6969d2h, 0be6a6ad4h, 0bd6b6bd6h, 0b46c6cd8h, 0b76d6ddah, 0b26e6edch, 0b16f6fdeh
		dd	0907070e0h, 0937171e2h, 0967272e4h, 0957373e6h, 09c7474e8h, 09f7575eah, 09a7676ech, 0997777eeh
		dd	0887878f0h, 08b7979f2h, 08e7a7af4h, 08d7b7bf6h, 0847c7cf8h, 0877d7dfah, 0827e7efch, 0817f7ffeh
		dd	0758080f5h, 0768181f7h, 0738282f1h, 0708383f3h, 0798484fdh, 07a8585ffh, 07f8686f9h, 07c8787fbh
		dd	06d8888e5h, 06e8989e7h, 06b8a8ae1h, 0688b8be3h, 0618c8cedh, 0628d8defh, 0678e8ee9h, 0648f8febh
		dd	0459090d5h, 0469191d7h, 0439292d1h, 0409393d3h, 0499494ddh, 04a9595dfh, 04f9696d9h, 04c9797dbh
		dd	05d9898c5h, 05e9999c7h, 05b9a9ac1h, 0589b9bc3h, 0519c9ccdh, 0529d9dcfh, 0579e9ec9h, 0549f9fcbh
		dd	015a0a0b5h, 016a1a1b7h, 013a2a2b1h, 010a3a3b3h, 019a4a4bdh, 01aa5a5bfh, 01fa6a6b9h, 01ca7a7bbh
		dd	00da8a8a5h, 00ea9a9a7h, 00baaaaa1h, 008ababa3h, 001acacadh, 002adadafh, 007aeaea9h, 004afafabh
		dd	025b0b095h, 026b1b197h, 023b2b291h, 020b3b393h, 029b4b49dh, 02ab5b59fh, 02fb6b699h, 02cb7b79bh
		dd	03db8b885h, 03eb9b987h, 03bbaba81h, 038bbbb83h, 031bcbc8dh, 032bdbd8fh, 037bebe89h, 034bfbf8bh
		dd	0b5c0c075h, 0b6c1c177h, 0b3c2c271h, 0b0c3c373h, 0b9c4c47dh, 0bac5c57fh, 0bfc6c679h, 0bcc7c77bh
		dd	0adc8c865h, 0aec9c967h, 0abcaca61h, 0a8cbcb63h, 0a1cccc6dh, 0a2cdcd6fh, 0a7cece69h, 0a4cfcf6bh
		dd	085d0d055h, 086d1d157h, 083d2d251h, 080d3d353h, 089d4d45dh, 08ad5d55fh, 08fd6d659h, 08cd7d75bh
		dd	09dd8d845h, 09ed9d947h, 09bdada41h, 098dbdb43h, 091dcdc4dh, 092dddd4fh, 097dede49h, 094dfdf4bh
		dd	0d5e0e035h, 0d6e1e137h, 0d3e2e231h, 0d0e3e333h, 0d9e4e43dh, 0dae5e53fh, 0dfe6e639h, 0dce7e73bh
		dd	0cde8e825h, 0cee9e927h, 0cbeaea21h, 0c8ebeb23h, 0c1ecec2dh, 0c2eded2fh, 0c7eeee29h, 0c4efef2bh
		dd	0e5f0f015h, 0e6f1f117h, 0e3f2f211h, 0e0f3f313h, 0e9f4f41dh, 0eaf5f51fh, 0eff6f619h, 0ecf7f71bh
		dd	0fdf8f805h, 0fef9f907h, 0fbfafa01h, 0f8fbfb03h, 0f1fcfc0dh, 0f2fdfd0fh, 0f7fefe09h, 0f4ffff0bh

Square_SetEncryptKey	proc	ptrPass:DWORD
	
	pushad
	mov	esi, ptrPass
	mov	edi, offset square_internal_pass

	mov	eax, dword ptr [esi + 0]
	mov	ebx, dword ptr [esi + 4]
	mov	ecx, dword ptr [esi + 8]
	mov	edx, dword ptr [esi +12]

	mov	ebp, 1
	mov	esi, 8

	mov	dword ptr [edi + 0], eax
	mov	dword ptr [edi + 4], ebx
	mov	dword ptr [edi + 8], ecx
	mov	dword ptr [edi +12], edx
@@:
	xor	eax, ebp
	ror	edx, 8
	add	edi, 16
	xor	eax, edx
	shl	ebp, 1
	xor	ebx, eax
	rol	edx, 8
	xor	ecx, ebx
	mov	dword ptr [edi + 0], eax
	xor	edx, ecx
	mov	dword ptr [edi + 4], ebx
	dec	esi
	mov	dword ptr [edi + 8], ecx
	mov	dword ptr [edi +12], edx
	jnz	@B

	xor	ecx, ecx
	xor	eax, eax
	mov	edi, offset square_internal_pass
	mov	esi, 8
@@squareTransform:
	shl	esi, 4
	or	esi, 0111b
@@:
	mov	al, byte ptr [edi+1]
	movzx	ebx, byte ptr [edi+2]
	mov	ebp, dword ptr [phi + 4*eax]
	mov	edx, dword ptr [phi + 4*ebx]
	rol	ebp, 8
	mov	cl, byte ptr [edi+3]
	rol	edx, 16
	mov	ebx, dword ptr [phi + 4*ecx]
	xor	ebp, edx
	mov	al, byte ptr [edi]
	rol	ebx, 24
	xor	ebp, dword ptr [phi + 4*eax]
	xor	ebp, ebx
	mov	dword ptr [edi], ebp
	add	edi, 4
	shr	esi, 1
	jc	@B
	
	dec	esi
	jnz	@@squareTransform
	
	popad
	ret
Square_SetEncryptKey	endp

Square_SetDecryptKey	proc	ptrPass:DWORD

	pushad
	mov	esi, ptrPass
	mov	edi, offset square_internal_pass + 80h

	mov	eax, dword ptr [esi + 0]
	mov	ebx, dword ptr [esi + 4]
	mov	ecx, dword ptr [esi + 8]
	mov	edx, dword ptr [esi +12]

	mov	ebp, 1
	mov	esi, 8

	mov	dword ptr [edi + 0], eax
	mov	dword ptr [edi + 4], ebx
	mov	dword ptr [edi + 8], ecx
	mov	dword ptr [edi +12], edx
@@:
	xor	eax, ebp
	ror	edx, 8
	sub	edi, 16
	xor	eax, edx
	shl	ebp, 1
	xor	ebx, eax
	rol	edx, 8
	xor	ecx, ebx
	mov	dword ptr [edi + 0], eax
	xor	edx, ecx
	mov	dword ptr [edi + 4], ebx
	dec	esi
	mov	dword ptr [edi + 8], ecx
	mov	dword ptr [edi +12], edx
	jnz	@B

	xor	ecx, ecx
	xor	eax, eax
	mov	edi, offset square_internal_pass+80h
	mov	esi, 4
@@:
	mov	al, byte ptr [edi+1]
	movzx	ebx, byte ptr [edi+2]
	mov	ebp, dword ptr [phi + 4*eax]
	mov	edx, dword ptr [phi + 4*ebx]
	rol	ebp, 8
	mov	cl, byte ptr [edi+3]
	rol	edx, 16
	mov	ebx, dword ptr [phi + 4*ecx]
	xor	ebp, edx
	mov	al, byte ptr [edi]
	rol	ebx, 24
	xor	ebp, dword ptr [phi + 4*eax]
	xor	ebp, ebx
	mov	dword ptr [edi], ebp
	add	edi, 4
	dec	esi
	jnz	@B
	
	popad
	ret

Square_SetDecryptKey	endp

Square_Encrypt		proc	ptrOut:DWORD, ptrIn:DWORD

	pushad

	mov	esi, ptrIn
	mov	edi, offset square_internal_pass
	mov	eax, dword ptr [esi + 0]
	mov	ebx, dword ptr [esi + 4]
	mov	ecx, dword ptr [esi + 8]
	mov	edx, dword ptr [esi +12]

	xor	eax, dword ptr [edi + 0]
	xor	ebx, dword ptr [edi + 4]
	xor	ecx, dword ptr [edi + 8]
	xor	edx, dword ptr [edi +12]

	mov	esi, ptrOut

	mov	dword ptr [esi + 0], eax
	mov	dword ptr [esi + 4], ebx
	mov	dword ptr [esi + 8], ecx
	mov	dword ptr [esi +12], edx

	xor	eax, eax
	xor	ebx, ebx
	mov	_old_esp, esp
	mov	_counter, 7
@@:
	add	edi, 16

	mov	ebp, dword ptr [edi]
	mov	al, byte ptr [esi]
	mov	bl, byte ptr [esi+4]
	xor	ebp, dword ptr [Te0 + 4*eax]
	xor	ebp, dword ptr [Te1 + 4*ebx]
	mov	al, byte ptr [esi+8]
	mov	bl, byte ptr [esi+12]
	xor	ebp, dword ptr [Te2 + 4*eax]
	xor	ebp, dword ptr [Te3 + 4*ebx]

	mov	ecx, dword ptr [edi+4]
	mov	al, byte ptr [esi+1]
	mov	bl, byte ptr [esi+5]
	xor	ecx, dword ptr [Te0 + 4*eax]
	xor	ecx, dword ptr [Te1 + 4*ebx]
	mov	al, byte ptr [esi+9]
	mov	bl, byte ptr [esi+13]
	xor	ecx, dword ptr [Te2 + 4*eax]
	xor	ecx, dword ptr [Te3 + 4*ebx]

	mov	edx, dword ptr [edi+8]
	mov	al, byte ptr [esi+2]
	mov	bl, byte ptr [esi+6]
	xor	edx, dword ptr [Te0 + 4*eax]
	xor	edx, dword ptr [Te1 + 4*ebx]
	mov	al, byte ptr [esi+10]
	mov	bl, byte ptr [esi+14]
	xor	edx, dword ptr [Te2 + 4*eax]
	xor	edx, dword ptr [Te3 + 4*ebx]

	mov	esp, dword ptr [edi+12]
	mov	al, byte ptr [esi+3]
	mov	bl, byte ptr [esi+7]
	xor	esp, dword ptr [Te0 + 4*eax]
	xor	esp, dword ptr [Te1 + 4*ebx]
	mov	al, byte ptr [esi+11]
	mov	bl, byte ptr [esi+15]
	xor	esp, dword ptr [Te2 + 4*eax]
	xor	esp, dword ptr [Te3 + 4*ebx]

	mov	dword ptr [esi + 0], ebp
	mov	dword ptr [esi + 4], ecx
	mov	dword ptr [esi + 8], edx
	mov	dword ptr [esi +12], esp
	
	dec	_counter
	jnz	@B

	add	edi, 16

	mov	ebp, dword ptr [edi]
	mov	al, byte ptr [esi+8]
	mov	bl, byte ptr [esi+12]
	mov	cl, byte ptr [Se + eax]
	mov	ch, byte ptr [Se + ebx]
	mov	al, byte ptr [esi]
	shl	ecx, 16
	mov	bl, byte ptr [esi+4]
	mov	cl, byte ptr [Se + eax]
	mov	ch, byte ptr [Se + ebx]
	xor	ebp, ecx

	mov	esp, dword ptr [edi+4]
	mov	al, byte ptr [esi+9]
	mov	bl, byte ptr [esi+13]
	mov	cl, byte ptr [Se + eax]
	mov	ch, byte ptr [Se + ebx]
	mov	al, byte ptr [esi+1]
	shl	ecx, 16
	mov	bl, byte ptr [esi+5]
	mov	cl, byte ptr [Se + eax]
	mov	ch, byte ptr [Se + ebx]
	xor	esp, ecx

	mov	edx, dword ptr [edi+8]
	mov	al, byte ptr [esi+10]
	mov	bl, byte ptr [esi+14]
	mov	cl, byte ptr [Se + eax]
	mov	ch, byte ptr [Se + ebx]
	mov	al, byte ptr [esi+2]
	shl	ecx, 16
	mov	bl, byte ptr [esi+6]
	mov	cl, byte ptr [Se + eax]
	mov	ch, byte ptr [Se + ebx]
	xor	edx, ecx

	mov	al, byte ptr [esi+11]
	mov	bl, byte ptr [esi+15]
	mov	cl, byte ptr [Se + eax]
	mov	ch, byte ptr [Se + ebx]
	mov	al, byte ptr [esi+3]
	shl	ecx, 16
	mov	bl, byte ptr [esi+7]
	mov	cl, byte ptr [Se + eax]
	mov	ch, byte ptr [Se + ebx]
	xor	ecx, dword ptr [edi+12]

	mov	dword ptr [esi + 0], ebp
	mov	dword ptr [esi + 4], esp
	mov	dword ptr [esi + 8], edx
	mov	dword ptr [esi +12], ecx
	
	mov	esp, _old_esp
	popad
	ret

Te0		dd	026b1b197h, 0a7cece69h, 0b0c3c373h, 04a9595dfh,	0ee5a5ab4h, 002adadafh, 0dce7e73bh, 006020204h
		dd	0d74d4d9ah, 0cc444488h, 0f8fbfb03h, 0469191d7h,	0140c0c18h, 07c8787fbh, 016a1a1b7h, 0f05050a0h
		dd	0a8cbcb63h, 0a96767ceh, 0fc5454a8h, 092dddd4fh, 0ca46468ch, 0648f8febh, 0d6e1e137h, 0d24e4e9ch
		dd	0e5f0f015h, 0f2fdfd0fh, 0f1fcfc0dh, 0c8ebeb23h,	0fef9f907h, 0b9c4c47dh, 02e1a1a34h, 0b26e6edch
		dd	0e25e5ebch, 0eaf5f51fh, 0a1cccc6dh, 0628d8defh,	0241c1c38h, 0fa5656ach, 0c5434386h, 0f7fefe09h
		dd	00907070eh, 0a36161c2h, 0fdf8f805h, 09f7575eah, 0eb5959b2h, 0f4ffff0bh, 005030306h, 066222244h
		dd	06b8a8ae1h, 086d1d157h, 035131326h, 0c7eeee29h, 06d8888e5h, 000000000h, 0120e0e1ch, 05c343468h
		dd	03f15152ah, 0758080f5h, 0499494ddh, 0d0e3e333h, 0c2eded2fh, 02ab5b59fh, 0f55353a6h, 065232346h
		dd	0dd4b4b96h, 0c947478eh, 03917172eh, 01ca7a7bbh, 0459090d5h, 05f35356ah, 008ababa3h, 09dd8d845h
		dd	03db8b885h, 094dfdf4bh, 0d14f4f9eh, 0f95757aeh, 05b9a9ac1h, 0439292d1h, 098dbdb43h, 02d1b1b36h
		dd	0443c3c78h, 0adc8c865h, 05e9999c7h, 00c040408h, 0678e8ee9h, 0d5e0e035h, 08cd7d75bh, 0877d7dfah
		dd	07a8585ffh, 038bbbb83h, 0c0404080h, 0742c2c58h, 04e3a3a74h, 0cf45458ah, 0e6f1f117h, 0c6424284h
		dd	0af6565cah, 060202040h, 0c3414182h, 028181830h, 0967272e4h, 06f25254ah, 0409393d3h, 0907070e0h
		dd	05a36366ch, 00f05050ah, 0e3f2f211h, 01d0b0b16h, 010a3a3b3h, 08b7979f2h, 0c1ecec2dh, 018080810h
		dd	06927274eh, 053313162h, 056323264h, 02fb6b699h, 0847c7cf8h, 025b0b095h, 01e0a0a14h, 0957373e6h
		dd	0ed5b5bb6h, 08d7b7bf6h, 02cb7b79bh, 0768181f7h, 083d2d251h, 0170d0d1ah, 0be6a6ad4h, 06a26264ch
		dd	0579e9ec9h, 0e85858b0h, 0519c9ccdh, 0708383f3h, 09c7474e8h, 020b3b393h, 001acacadh, 050303060h
		dd	08e7a7af4h, 0bb6969d2h, 0997777eeh, 0110f0f1eh, 007aeaea9h, 063212142h, 097dede49h, 085d0d055h
		dd	0722e2e5ch, 04c9797dbh, 030101020h, 019a4a4bdh, 05d9898c5h, 00da8a8a5h, 089d4d45dh, 0b86868d0h
		dd	0772d2d5ah, 0a66262c4h, 07b292952h, 0b76d6ddah, 03a16162ch, 0db494992h, 09a7676ech, 0bcc7c77bh
		dd	0cde8e825h, 0b6c1c177h, 04f9696d9h, 05937376eh, 0dae5e53fh, 0abcaca61h, 0e9f4f41dh, 0cee9e927h
		dd	0a56363c6h, 036121224h, 0b3c2c271h, 01fa6a6b9h, 03c141428h, 031bcbc8dh, 080d3d353h, 078282850h
		dd	004afafabh, 0712f2f5eh, 0dfe6e639h, 06c242448h, 0f65252a4h, 0bfc6c679h, 015a0a0b5h, 01b090912h
		dd	032bdbd8fh, 0618c8cedh, 0a4cfcf6bh, 0e75d5dbah, 033111122h, 0e15f5fbeh, 003010102h, 0bac5c57fh
		dd	0549f9fcbh, 0473d3d7ah, 013a2a2b1h, 0589b9bc3h, 0aec9c967h, 04d3b3b76h, 037bebe89h, 0f35151a2h
		dd	02b191932h, 0211f1f3eh, 0413f3f7eh, 0e45c5cb8h, 023b2b291h, 0c4efef2bh, 0de4a4a94h, 0a2cdcd6fh
		dd	034bfbf8bh, 03bbaba81h, 0b16f6fdeh, 0ac6464c8h, 09ed9d947h, 0e0f3f313h, 0423e3e7ch, 029b4b49dh
		dd	00baaaaa1h, 091dcdc4dh, 08ad5d55fh, 00a06060ch, 0b5c0c075h, 0827e7efch, 0eff6f619h, 0aa6666cch
		dd	0b46c6cd8h, 0798484fdh, 0937171e2h, 048383870h, 03eb9b987h, 0271d1d3ah, 0817f7ffeh, 0529d9dcfh
		dd	0d8484890h, 0688b8be3h, 07e2a2a54h, 09bdada41h, 01aa5a5bfh, 055333366h, 0738282f1h, 04b393972h
		dd	08fd6d659h, 0887878f0h, 07f8686f9h, 0fbfafa01h, 0d9e4e43dh, 07d2b2b56h, 00ea9a9a7h, 0221e1e3ch
		dd	06e8989e7h, 0a06060c0h, 0bd6b6bd6h, 0cbeaea21h, 0ff5555aah, 0d44c4c98h, 0ecf7f71bh, 0d3e2e231h

Te1		dd	0b1b19726h, 0cece69a7h, 0c3c373b0h, 09595df4ah, 05a5ab4eeh, 0adadaf02h, 0e7e73bdch, 002020406h
		dd	04d4d9ad7h, 0444488cch, 0fbfb03f8h, 09191d746h, 00c0c1814h, 08787fb7ch, 0a1a1b716h, 05050a0f0h
		dd	0cbcb63a8h, 06767cea9h, 05454a8fch, 0dddd4f92h, 046468ccah, 08f8feb64h, 0e1e137d6h, 04e4e9cd2h
		dd	0f0f015e5h, 0fdfd0ff2h, 0fcfc0df1h, 0ebeb23c8h, 0f9f907feh, 0c4c47db9h, 01a1a342eh, 06e6edcb2h
		dd	05e5ebce2h, 0f5f51feah, 0cccc6da1h, 08d8def62h, 01c1c3824h, 05656acfah, 0434386c5h, 0fefe09f7h
		dd	007070e09h, 06161c2a3h, 0f8f805fdh, 07575ea9fh, 05959b2ebh, 0ffff0bf4h, 003030605h, 022224466h
		dd	08a8ae16bh, 0d1d15786h, 013132635h, 0eeee29c7h, 08888e56dh, 000000000h, 00e0e1c12h, 03434685ch
		dd	015152a3fh, 08080f575h, 09494dd49h, 0e3e333d0h, 0eded2fc2h, 0b5b59f2ah, 05353a6f5h, 023234665h
		dd	04b4b96ddh, 047478ec9h, 017172e39h, 0a7a7bb1ch, 09090d545h, 035356a5fh, 0ababa308h, 0d8d8459dh
		dd	0b8b8853dh, 0dfdf4b94h, 04f4f9ed1h, 05757aef9h, 09a9ac15bh, 09292d143h, 0dbdb4398h, 01b1b362dh
		dd	03c3c7844h, 0c8c865adh, 09999c75eh, 00404080ch, 08e8ee967h, 0e0e035d5h, 0d7d75b8ch, 07d7dfa87h
		dd	08585ff7ah, 0bbbb8338h, 0404080c0h, 02c2c5874h, 03a3a744eh, 045458acfh, 0f1f117e6h, 0424284c6h
		dd	06565caafh, 020204060h, 0414182c3h, 018183028h, 07272e496h, 025254a6fh, 09393d340h, 07070e090h
		dd	036366c5ah, 005050a0fh, 0f2f211e3h, 00b0b161dh, 0a3a3b310h, 07979f28bh, 0ecec2dc1h, 008081018h
		dd	027274e69h, 031316253h, 032326456h, 0b6b6992fh, 07c7cf884h, 0b0b09525h, 00a0a141eh, 07373e695h
		dd	05b5bb6edh, 07b7bf68dh, 0b7b79b2ch, 08181f776h, 0d2d25183h, 00d0d1a17h, 06a6ad4beh, 026264c6ah
		dd	09e9ec957h, 05858b0e8h, 09c9ccd51h, 08383f370h, 07474e89ch, 0b3b39320h, 0acacad01h, 030306050h
		dd	07a7af48eh, 06969d2bbh, 07777ee99h, 00f0f1e11h, 0aeaea907h, 021214263h, 0dede4997h, 0d0d05585h
		dd	02e2e5c72h, 09797db4ch, 010102030h, 0a4a4bd19h, 09898c55dh, 0a8a8a50dh, 0d4d45d89h, 06868d0b8h
		dd	02d2d5a77h, 06262c4a6h, 02929527bh, 06d6ddab7h, 016162c3ah, 0494992dbh, 07676ec9ah, 0c7c77bbch
		dd	0e8e825cdh, 0c1c177b6h, 09696d94fh, 037376e59h, 0e5e53fdah, 0caca61abh, 0f4f41de9h, 0e9e927ceh
		dd	06363c6a5h, 012122436h, 0c2c271b3h, 0a6a6b91fh, 01414283ch, 0bcbc8d31h, 0d3d35380h, 028285078h
		dd	0afafab04h, 02f2f5e71h, 0e6e639dfh, 02424486ch, 05252a4f6h, 0c6c679bfh, 0a0a0b515h, 00909121bh
		dd	0bdbd8f32h, 08c8ced61h, 0cfcf6ba4h, 05d5dbae7h, 011112233h, 05f5fbee1h, 001010203h, 0c5c57fbah
		dd	09f9fcb54h, 03d3d7a47h, 0a2a2b113h, 09b9bc358h, 0c9c967aeh, 03b3b764dh, 0bebe8937h, 05151a2f3h
		dd	01919322bh, 01f1f3e21h, 03f3f7e41h, 05c5cb8e4h, 0b2b29123h, 0efef2bc4h, 04a4a94deh, 0cdcd6fa2h
		dd	0bfbf8b34h, 0baba813bh, 06f6fdeb1h, 06464c8ach, 0d9d9479eh, 0f3f313e0h, 03e3e7c42h, 0b4b49d29h
		dd	0aaaaa10bh, 0dcdc4d91h, 0d5d55f8ah, 006060c0ah, 0c0c075b5h, 07e7efc82h, 0f6f619efh, 06666ccaah
		dd	06c6cd8b4h, 08484fd79h, 07171e293h, 038387048h, 0b9b9873eh, 01d1d3a27h, 07f7ffe81h, 09d9dcf52h
		dd	0484890d8h, 08b8be368h, 02a2a547eh, 0dada419bh, 0a5a5bf1ah, 033336655h, 08282f173h, 03939724bh
		dd	0d6d6598fh, 07878f088h, 08686f97fh, 0fafa01fbh, 0e4e43dd9h, 02b2b567dh, 0a9a9a70eh, 01e1e3c22h
		dd	08989e76eh, 06060c0a0h, 06b6bd6bdh, 0eaea21cbh, 05555aaffh, 04c4c98d4h, 0f7f71bech, 0e2e231d3h

Te2		dd	0b19726b1h, 0ce69a7ceh, 0c373b0c3h, 095df4a95h, 05ab4ee5ah, 0adaf02adh, 0e73bdce7h, 002040602h
		dd	04d9ad74dh, 04488cc44h, 0fb03f8fbh, 091d74691h, 00c18140ch, 087fb7c87h, 0a1b716a1h, 050a0f050h
		dd	0cb63a8cbh, 067cea967h, 054a8fc54h, 0dd4f92ddh, 0468cca46h, 08feb648fh, 0e137d6e1h, 04e9cd24eh
		dd	0f015e5f0h, 0fd0ff2fdh, 0fc0df1fch, 0eb23c8ebh, 0f907fef9h, 0c47db9c4h, 01a342e1ah, 06edcb26eh
		dd	05ebce25eh, 0f51feaf5h, 0cc6da1cch, 08def628dh, 01c38241ch, 056acfa56h, 04386c543h, 0fe09f7feh
		dd	0070e0907h, 061c2a361h, 0f805fdf8h, 075ea9f75h, 059b2eb59h, 0ff0bf4ffh, 003060503h, 022446622h
		dd	08ae16b8ah, 0d15786d1h, 013263513h, 0ee29c7eeh, 088e56d88h, 000000000h, 00e1c120eh, 034685c34h
		dd	0152a3f15h, 080f57580h, 094dd4994h, 0e333d0e3h, 0ed2fc2edh, 0b59f2ab5h, 053a6f553h, 023466523h
		dd	04b96dd4bh, 0478ec947h, 0172e3917h, 0a7bb1ca7h, 090d54590h, 0356a5f35h, 0aba308abh, 0d8459dd8h
		dd	0b8853db8h, 0df4b94dfh, 04f9ed14fh, 057aef957h, 09ac15b9ah, 092d14392h, 0db4398dbh, 01b362d1bh
		dd	03c78443ch, 0c865adc8h, 099c75e99h, 004080c04h, 08ee9678eh, 0e035d5e0h, 0d75b8cd7h, 07dfa877dh
		dd	085ff7a85h, 0bb8338bbh, 04080c040h, 02c58742ch, 03a744e3ah, 0458acf45h, 0f117e6f1h, 04284c642h
		dd	065caaf65h, 020406020h, 04182c341h, 018302818h, 072e49672h, 0254a6f25h, 093d34093h, 070e09070h
		dd	0366c5a36h, 0050a0f05h, 0f211e3f2h, 00b161d0bh, 0a3b310a3h, 079f28b79h, 0ec2dc1ech, 008101808h
		dd	0274e6927h, 031625331h, 032645632h, 0b6992fb6h, 07cf8847ch, 0b09525b0h, 00a141e0ah, 073e69573h
		dd	05bb6ed5bh, 07bf68d7bh, 0b79b2cb7h, 081f77681h, 0d25183d2h, 00d1a170dh, 06ad4be6ah, 0264c6a26h
		dd	09ec9579eh, 058b0e858h, 09ccd519ch, 083f37083h, 074e89c74h, 0b39320b3h, 0acad01ach, 030605030h
		dd	07af48e7ah, 069d2bb69h, 077ee9977h, 00f1e110fh, 0aea907aeh, 021426321h, 0de4997deh, 0d05585d0h
		dd	02e5c722eh, 097db4c97h, 010203010h, 0a4bd19a4h, 098c55d98h, 0a8a50da8h, 0d45d89d4h, 068d0b868h
		dd	02d5a772dh, 062c4a662h, 029527b29h, 06ddab76dh, 0162c3a16h, 04992db49h, 076ec9a76h, 0c77bbcc7h
		dd	0e825cde8h, 0c177b6c1h, 096d94f96h, 0376e5937h, 0e53fdae5h, 0ca61abcah, 0f41de9f4h, 0e927cee9h
		dd	063c6a563h, 012243612h, 0c271b3c2h, 0a6b91fa6h, 014283c14h, 0bc8d31bch, 0d35380d3h, 028507828h
		dd	0afab04afh, 02f5e712fh, 0e639dfe6h, 024486c24h, 052a4f652h, 0c679bfc6h, 0a0b515a0h, 009121b09h
		dd	0bd8f32bdh, 08ced618ch, 0cf6ba4cfh, 05dbae75dh, 011223311h, 05fbee15fh, 001020301h, 0c57fbac5h
		dd	09fcb549fh, 03d7a473dh, 0a2b113a2h, 09bc3589bh, 0c967aec9h, 03b764d3bh, 0be8937beh, 051a2f351h
		dd	019322b19h, 01f3e211fh, 03f7e413fh, 05cb8e45ch, 0b29123b2h, 0ef2bc4efh, 04a94de4ah, 0cd6fa2cdh
		dd	0bf8b34bfh, 0ba813bbah, 06fdeb16fh, 064c8ac64h, 0d9479ed9h, 0f313e0f3h, 03e7c423eh, 0b49d29b4h
		dd	0aaa10baah, 0dc4d91dch, 0d55f8ad5h, 0060c0a06h, 0c075b5c0h, 07efc827eh, 0f619eff6h, 066ccaa66h
		dd	06cd8b46ch, 084fd7984h, 071e29371h, 038704838h, 0b9873eb9h, 01d3a271dh, 07ffe817fh, 09dcf529dh
		dd	04890d848h, 08be3688bh, 02a547e2ah, 0da419bdah, 0a5bf1aa5h, 033665533h, 082f17382h, 039724b39h
		dd	0d6598fd6h, 078f08878h, 086f97f86h, 0fa01fbfah, 0e43dd9e4h, 02b567d2bh, 0a9a70ea9h, 01e3c221eh
		dd	089e76e89h, 060c0a060h, 06bd6bd6bh, 0ea21cbeah, 055aaff55h, 04c98d44ch, 0f71becf7h, 0e231d3e2h

Te3		dd	09726b1b1h, 069a7ceceh, 073b0c3c3h, 0df4a9595h, 0b4ee5a5ah, 0af02adadh, 03bdce7e7h, 004060202h
		dd	09ad74d4dh, 088cc4444h, 003f8fbfbh, 0d7469191h, 018140c0ch, 0fb7c8787h, 0b716a1a1h, 0a0f05050h
		dd	063a8cbcbh, 0cea96767h, 0a8fc5454h, 04f92ddddh, 08cca4646h, 0eb648f8fh, 037d6e1e1h, 09cd24e4eh
		dd	015e5f0f0h, 00ff2fdfdh, 00df1fcfch, 023c8ebebh, 007fef9f9h, 07db9c4c4h, 0342e1a1ah, 0dcb26e6eh
		dd	0bce25e5eh, 01feaf5f5h, 06da1cccch, 0ef628d8dh, 038241c1ch, 0acfa5656h, 086c54343h, 009f7fefeh
		dd	00e090707h, 0c2a36161h, 005fdf8f8h, 0ea9f7575h, 0b2eb5959h, 00bf4ffffh, 006050303h, 044662222h
		dd	0e16b8a8ah, 05786d1d1h, 026351313h, 029c7eeeeh, 0e56d8888h, 000000000h, 01c120e0eh, 0685c3434h
		dd	02a3f1515h, 0f5758080h, 0dd499494h, 033d0e3e3h, 02fc2ededh, 09f2ab5b5h, 0a6f55353h, 046652323h
		dd	096dd4b4bh, 08ec94747h, 02e391717h, 0bb1ca7a7h, 0d5459090h, 06a5f3535h, 0a308ababh, 0459dd8d8h
		dd	0853db8b8h, 04b94dfdfh, 09ed14f4fh, 0aef95757h, 0c15b9a9ah, 0d1439292h, 04398dbdbh, 0362d1b1bh
		dd	078443c3ch, 065adc8c8h, 0c75e9999h, 0080c0404h, 0e9678e8eh, 035d5e0e0h, 05b8cd7d7h, 0fa877d7dh
		dd	0ff7a8585h, 08338bbbbh, 080c04040h, 058742c2ch, 0744e3a3ah, 08acf4545h, 017e6f1f1h, 084c64242h
		dd	0caaf6565h, 040602020h, 082c34141h, 030281818h, 0e4967272h, 04a6f2525h, 0d3409393h, 0e0907070h
		dd	06c5a3636h, 00a0f0505h, 011e3f2f2h, 0161d0b0bh, 0b310a3a3h, 0f28b7979h, 02dc1ecech, 010180808h
		dd	04e692727h, 062533131h, 064563232h, 0992fb6b6h, 0f8847c7ch, 09525b0b0h, 0141e0a0ah, 0e6957373h
		dd	0b6ed5b5bh, 0f68d7b7bh, 09b2cb7b7h, 0f7768181h, 05183d2d2h, 01a170d0dh, 0d4be6a6ah, 04c6a2626h
		dd	0c9579e9eh, 0b0e85858h, 0cd519c9ch, 0f3708383h, 0e89c7474h, 09320b3b3h, 0ad01acach, 060503030h
		dd	0f48e7a7ah, 0d2bb6969h, 0ee997777h, 01e110f0fh, 0a907aeaeh, 042632121h, 04997dedeh, 05585d0d0h
		dd	05c722e2eh, 0db4c9797h, 020301010h, 0bd19a4a4h, 0c55d9898h, 0a50da8a8h, 05d89d4d4h, 0d0b86868h
		dd	05a772d2dh, 0c4a66262h, 0527b2929h, 0dab76d6dh, 02c3a1616h, 092db4949h, 0ec9a7676h, 07bbcc7c7h
		dd	025cde8e8h, 077b6c1c1h, 0d94f9696h, 06e593737h, 03fdae5e5h, 061abcacah, 01de9f4f4h, 027cee9e9h
		dd	0c6a56363h, 024361212h, 071b3c2c2h, 0b91fa6a6h, 0283c1414h, 08d31bcbch, 05380d3d3h, 050782828h
		dd	0ab04afafh, 05e712f2fh, 039dfe6e6h, 0486c2424h, 0a4f65252h, 079bfc6c6h, 0b515a0a0h, 0121b0909h
		dd	08f32bdbdh, 0ed618c8ch, 06ba4cfcfh, 0bae75d5dh, 022331111h, 0bee15f5fh, 002030101h, 07fbac5c5h
		dd	0cb549f9fh, 07a473d3dh, 0b113a2a2h, 0c3589b9bh, 067aec9c9h, 0764d3b3bh, 08937bebeh, 0a2f35151h
		dd	0322b1919h, 03e211f1fh, 07e413f3fh, 0b8e45c5ch, 09123b2b2h, 02bc4efefh, 094de4a4ah, 06fa2cdcdh
		dd	08b34bfbfh, 0813bbabah, 0deb16f6fh, 0c8ac6464h, 0479ed9d9h, 013e0f3f3h, 07c423e3eh, 09d29b4b4h
		dd	0a10baaaah, 04d91dcdch, 05f8ad5d5h, 00c0a0606h, 075b5c0c0h, 0fc827e7eh, 019eff6f6h, 0ccaa6666h
		dd	0d8b46c6ch, 0fd798484h, 0e2937171h, 070483838h, 0873eb9b9h, 03a271d1dh, 0fe817f7fh, 0cf529d9dh
		dd	090d84848h, 0e3688b8bh, 0547e2a2ah, 0419bdadah, 0bf1aa5a5h, 066553333h, 0f1738282h, 0724b3939h
		dd	0598fd6d6h, 0f0887878h, 0f97f8686h, 001fbfafah, 03dd9e4e4h, 0567d2b2bh, 0a70ea9a9h, 03c221e1eh
		dd	0e76e8989h, 0c0a06060h, 0d6bd6b6bh, 021cbeaeah, 0aaff5555h, 098d44c4ch, 01becf7f7h, 031d3e2e2h

Se		db	177, 206, 195, 149,  90, 173, 231,   2,  77,  68, 251, 145,  12, 135, 161,  80
		db	203, 103,  84, 221,  70, 143, 225,  78, 240, 253, 252, 235, 249, 196,  26, 110
		db	 94, 245, 204, 141,  28,  86,  67, 254,   7,  97, 248, 117,  89, 255,   3,  34
		db	138, 209,  19, 238, 136,   0,  14,  52,  21, 128, 148, 227, 237, 181,  83,  35
		db	 75,  71,  23, 167, 144,  53, 171, 216, 184, 223,  79,  87, 154, 146, 219,  27
		db	 60, 200, 153,   4, 142, 224, 215, 125, 133, 187,  64,  44,  58,  69, 241,  66
		db	101,  32,  65,  24, 114,  37, 147, 112,  54,   5, 242,  11, 163, 121, 236,   8
		db	 39,  49,  50, 182, 124, 176,  10, 115,  91, 123, 183, 129, 210,  13, 106,  38
		db	158,  88, 156, 131, 116, 179, 172,  48, 122, 105, 119,  15, 174,  33, 222, 208
		db	 46, 151,  16, 164, 152, 168, 212, 104,  45,  98,  41, 109,  22,  73, 118, 199
		db	232, 193, 150,  55, 229, 202, 244, 233,  99,  18, 194, 166,  20, 188, 211,  40
		db	175,  47, 230,  36,  82, 198, 160,   9, 189, 140, 207,  93,  17,  95,   1, 197
		db	159,  61, 162, 155, 201,  59, 190,  81,  25,  31,  63,  92, 178, 239,  74, 205
		db	191, 186, 111, 100, 217, 243,  62, 180, 170, 220, 213,   6, 192, 126, 246, 102
		db	108, 132, 113,  56, 185,  29, 127, 157,  72, 139,  42, 218, 165,  51, 130,  57
		db	214, 120, 134, 250, 228,  43, 169,  30, 137,  96, 107, 234,  85,  76, 247, 226

Square_Encrypt		endp

Square_Decrypt		proc	ptrOut:DWORD, ptrIn:DWORD

	pushad

	mov	esi, ptrIn
	mov	edi, offset square_internal_pass
	mov	eax, dword ptr [esi + 0]
	mov	ebx, dword ptr [esi + 4]
	mov	ecx, dword ptr [esi + 8]
	mov	edx, dword ptr [esi +12]

	xor	eax, dword ptr [edi + 0]
	xor	ebx, dword ptr [edi + 4]
	xor	ecx, dword ptr [edi + 8]
	xor	edx, dword ptr [edi +12]

	mov	esi, ptrOut

	mov	dword ptr [esi + 0], eax
	mov	dword ptr [esi + 4], ebx
	mov	dword ptr [esi + 8], ecx
	mov	dword ptr [esi +12], edx

	xor	eax, eax
	xor	ebx, ebx
	mov	_old_esp, esp
	mov	_counter, 7
@@:
	add	edi, 16

	mov	ebp, dword ptr [edi]
	mov	al, byte ptr [esi]
	mov	bl, byte ptr [esi+4]
	xor	ebp, dword ptr [Td0 + 4*eax]
	xor	ebp, dword ptr [Td1 + 4*ebx]
	mov	al, byte ptr [esi+8]
	mov	bl, byte ptr [esi+12]
	xor	ebp, dword ptr [Td2 + 4*eax]
	xor	ebp, dword ptr [Td3 + 4*ebx]

	mov	ecx, dword ptr [edi+4]
	mov	al, byte ptr [esi+1]
	mov	bl, byte ptr [esi+5]
	xor	ecx, dword ptr [Td0 + 4*eax]
	xor	ecx, dword ptr [Td1 + 4*ebx]
	mov	al, byte ptr [esi+9]
	mov	bl, byte ptr [esi+13]
	xor	ecx, dword ptr [Td2 + 4*eax]
	xor	ecx, dword ptr [Td3 + 4*ebx]

	mov	edx, dword ptr [edi+8]
	mov	al, byte ptr [esi+2]
	mov	bl, byte ptr [esi+6]
	xor	edx, dword ptr [Td0 + 4*eax]
	xor	edx, dword ptr [Td1 + 4*ebx]
	mov	al, byte ptr [esi+10]
	mov	bl, byte ptr [esi+14]
	xor	edx, dword ptr [Td2 + 4*eax]
	xor	edx, dword ptr [Td3 + 4*ebx]

	mov	esp, dword ptr [edi+12]
	mov	al, byte ptr [esi+3]
	mov	bl, byte ptr [esi+7]
	xor	esp, dword ptr [Td0 + 4*eax]
	xor	esp, dword ptr [Td1 + 4*ebx]
	mov	al, byte ptr [esi+11]
	mov	bl, byte ptr [esi+15]
	xor	esp, dword ptr [Td2 + 4*eax]
	xor	esp, dword ptr [Td3 + 4*ebx]

	mov	dword ptr [esi + 0], ebp
	mov	dword ptr [esi + 4], ecx
	mov	dword ptr [esi + 8], edx
	mov	dword ptr [esi +12], esp
	
	dec	_counter
	jnz	@B

	add	edi, 16

	mov	ebp, dword ptr [edi]
	mov	al, byte ptr [esi+8]
	mov	bl, byte ptr [esi+12]
	mov	cl, byte ptr [Sd + eax]
	mov	ch, byte ptr [Sd + ebx]
	mov	al, byte ptr [esi]
	shl	ecx, 16
	mov	bl, byte ptr [esi+4]
	mov	cl, byte ptr [Sd + eax]
	mov	ch, byte ptr [Sd + ebx]
	xor	ebp, ecx

	mov	esp, dword ptr [edi+4]
	mov	al, byte ptr [esi+9]
	mov	bl, byte ptr [esi+13]
	mov	cl, byte ptr [Sd + eax]
	mov	ch, byte ptr [Sd + ebx]
	mov	al, byte ptr [esi+1]
	shl	ecx, 16
	mov	bl, byte ptr [esi+5]
	mov	cl, byte ptr [Sd + eax]
	mov	ch, byte ptr [Sd + ebx]
	xor	esp, ecx

	mov	edx, dword ptr [edi+8]
	mov	al, byte ptr [esi+10]
	mov	bl, byte ptr [esi+14]
	mov	cl, byte ptr [Sd + eax]
	mov	ch, byte ptr [Sd + ebx]
	mov	al, byte ptr [esi+2]
	shl	ecx, 16
	mov	bl, byte ptr [esi+6]
	mov	cl, byte ptr [Sd + eax]
	mov	ch, byte ptr [Sd + ebx]
	xor	edx, ecx

	mov	al, byte ptr [esi+11]
	mov	bl, byte ptr [esi+15]
	mov	cl, byte ptr [Sd + eax]
	mov	ch, byte ptr [Sd + ebx]
	mov	al, byte ptr [esi+3]
	shl	ecx, 16
	mov	bl, byte ptr [esi+7]
	mov	cl, byte ptr [Sd + eax]
	mov	ch, byte ptr [Sd + ebx]
	xor	ecx, dword ptr [edi+12]

	mov	dword ptr [esi + 0], ebp
	mov	dword ptr [esi + 4], esp
	mov	dword ptr [esi + 8], edx
	mov	dword ptr [esi +12], ecx
	
	mov	esp, _old_esp
	popad
	ret

Td0		dd	002bc68e3h, 00c628555h, 031233f2ah, 0f713ab61h, 0726dd498h, 0199acb21h, 061a4223ch, 0cd3d9d45h
		dd	023b4fd05h, 05f07c42bh, 0c0012c9bh, 00f80d93dh, 0745c6c48h, 0857e7ff9h, 01fab73f1h, 00edeedb6h
		dd	0ed6b3c28h, 01a789749h, 08d912a9fh, 0339f57c9h, 0aaa807a9h, 07ded0da5h, 08f2d427ch, 0c9b04d76h
		dd	057e8914dh, 0cc63a9ceh, 0d296eeb4h, 0b6e12830h, 0b961f10dh, 0266719bdh, 080ad9b41h, 0c76ea0c0h
		dd	041f28351h, 034f0db92h, 0fc1ea26fh, 04cce328fh, 07333e013h, 06dc6a769h, 093646de5h, 0fa2f1abfh
		dd	0b7bf1cbbh, 0b5037458h, 04f2c6ee7h, 096b7895dh, 02a059ce8h, 0a3196644h, 0fb712e34h, 06529f20fh
		dd	07a8281feh, 0f12213b1h, 0ec3508a3h, 07e0f51cdh, 014a67affh, 0f893725ch, 01297c22fh, 0c3e370f3h
		dd	01c492f99h, 0681543d1h, 01b26a3c2h, 0b332cc88h, 06f7acf8ah, 09f06e8b0h, 01ef5477ah, 0da79bbd2h
		dd	0210895e6h, 05ce59843h, 00631b8d0h, 0af7be311h, 05365417eh, 0102baacch, 09ce4b4d8h, 0d4a75664h
		dd	059367cfbh, 084204b72h, 0f64d9feah, 0dfaa5f6ah, 0cedfc12dh, 058684870h, 081f3afcah, 091d80506h
		dd	0694b775ah, 0a528de94h, 04210df39h, 047c33b81h, 0a6ca82fch, 0c5d2c823h, 0b26cf803h, 09ad50c08h
		dd	040acb7dah, 0e109b97dh, 02c342438h, 0a24752cfh, 0d174b2dch, 02b5ba863h, 09555d535h, 011759e47h
		dd	0e2ebe515h, 0c630944bh, 0a8146f4ah, 0869c2391h, 039cc6a4ch, 04aff8a5fh, 04d900604h, 0bbdd99eeh
		dd	0ca52111eh, 018c4ffaah, 0986964ebh, 0fffcfe07h, 0015e348bh, 0be0e7d56h, 0d99be7bah, 032c16342h
		dd	07bdcb575h, 017442697h, 066cbae67h, 0cb0c2595h, 067959aech, 0d02a8657h, 099375060h, 005d3e4b8h
		dd	0ba83ad65h, 035aeef19h, 013c9f6a4h, 0a94a5bc1h, 0d61b3e87h, 05e59f0a0h, 05b8a1418h, 03b7002afh
		dd	076e004abh, 0bf5049ddh, 063184adfh, 056b6a5c6h, 00a533d85h, 0371287fah, 0a794b677h, 07f516546h
		dd	009b161edh, 0e9e6ec1bh, 0258545d5h, 0523b75f5h, 03d41ba7fh, 08842ce27h, 0434eebb2h, 097e9bdd6h
		dd	0f39e7b52h, 0457f5362h, 0a0fb3a2ch, 070d1bc7bh, 06bf71fb9h, 01d171b12h, 0c8ee79fdh, 0f07c273ah
		dd	0d7450a0ch, 07960dd96h, 0abf63322h, 0891cfaach, 05dbbacc8h, 0307d0ba1h, 04ba1bed4h, 0940be1beh
		dd	0540acd25h, 062467e54h, 08211f3a2h, 03ea3e617h, 0e6663526h, 0750258c3h, 09b8b3883h, 0c2bd4478h
		dd	0dc480302h, 08ba0924fh, 07cb3392eh, 0e584694eh, 0718f88f0h, 027392d36h, 03ffdd29ch, 06e24fb01h
		dd	0dd163789h, 000000000h, 0e0578df6h, 06c9893e2h, 015f84e74h, 05ad42093h, 0e73801adh, 0b45d40d3h
		dd	087c2171ah, 02d6a10b3h, 02fd67850h, 03c1f8ef4h, 0a1a50ea7h, 0364cb371h, 0ae25d79ah, 024db715eh
		dd	050871d16h, 0d5f962efh, 09086318dh, 0161a121ch, 0cf81f5a6h, 0076f8c5bh, 0491dd637h, 0923a596eh
		dd	06477c684h, 0b83fc586h, 0f9cd46d7h, 0b0d090e0h, 0834fc729h, 0fd4096e4h, 00b0d090eh, 02056a16dh
		dd	022eac98eh, 02e884cdbh, 08e7376f7h, 0bcb215b5h, 0c15f1810h, 06aa92b32h, 0b18ea46bh, 05554f9aeh
		dd	0ee896040h, 008ef5566h, 0442167e9h, 0bdec213eh, 077be3020h, 0adc78bf2h, 029e7c080h, 08ccf1e14h
		dd	04843e2bch, 08afea6c4h, 0d8c5d331h, 060fa16b7h, 09dba8053h, 0f2c04fd9h, 0783ee91dh, 03a2e3624h
		dd	0def46be1h, 0efd754cbh, 0f4f1f709h, 0f5afc382h, 028b9f40bh, 051d9299dh, 038925ec7h, 0eb5a84f8h
		dd	0e8b8d890h, 00d3cb1deh, 0048dd033h, 003e25c68h, 0e4da5dc5h, 09e58dc3bh, 0469d0f0ah, 0d3c8da3fh
		dd	0db278f59h, 0c48cfca8h, 0ac99bf79h, 04e725a6ch, 0fea2ca8ch, 0e3b5d19eh, 0a476ea1fh, 0ea04b073h

Td1		dd	0bc68e302h, 06285550ch, 0233f2a31h, 013ab61f7h, 06dd49872h, 09acb2119h, 0a4223c61h, 03d9d45cdh
		dd	0b4fd0523h, 007c42b5fh, 0012c9bc0h, 080d93d0fh, 05c6c4874h, 07e7ff985h, 0ab73f11fh, 0deedb60eh
		dd	06b3c28edh, 07897491ah, 0912a9f8dh, 09f57c933h, 0a807a9aah, 0ed0da57dh, 02d427c8fh, 0b04d76c9h
		dd	0e8914d57h, 063a9cecch, 096eeb4d2h, 0e12830b6h, 061f10db9h, 06719bd26h, 0ad9b4180h, 06ea0c0c7h
		dd	0f2835141h, 0f0db9234h, 01ea26ffch, 0ce328f4ch, 033e01373h, 0c6a7696dh, 0646de593h, 02f1abffah
		dd	0bf1cbbb7h, 0037458b5h, 02c6ee74fh, 0b7895d96h, 0059ce82ah, 0196644a3h, 0712e34fbh, 029f20f65h
		dd	08281fe7ah, 02213b1f1h, 03508a3ech, 00f51cd7eh, 0a67aff14h, 093725cf8h, 097c22f12h, 0e370f3c3h
		dd	0492f991ch, 01543d168h, 026a3c21bh, 032cc88b3h, 07acf8a6fh, 006e8b09fh, 0f5477a1eh, 079bbd2dah
		dd	00895e621h, 0e598435ch, 031b8d006h, 07be311afh, 065417e53h, 02baacc10h, 0e4b4d89ch, 0a75664d4h
		dd	0367cfb59h, 0204b7284h, 04d9feaf6h, 0aa5f6adfh, 0dfc12dceh, 068487058h, 0f3afca81h, 0d8050691h
		dd	04b775a69h, 028de94a5h, 010df3942h, 0c33b8147h, 0ca82fca6h, 0d2c823c5h, 06cf803b2h, 0d50c089ah
		dd	0acb7da40h, 009b97de1h, 03424382ch, 04752cfa2h, 074b2dcd1h, 05ba8632bh, 055d53595h, 0759e4711h
		dd	0ebe515e2h, 030944bc6h, 0146f4aa8h, 09c239186h, 0cc6a4c39h, 0ff8a5f4ah, 09006044dh, 0dd99eebbh
		dd	052111ecah, 0c4ffaa18h, 06964eb98h, 0fcfe07ffh, 05e348b01h, 00e7d56beh, 09be7bad9h, 0c1634232h
		dd	0dcb5757bh, 044269717h, 0cbae6766h, 00c2595cbh, 0959aec67h, 02a8657d0h, 037506099h, 0d3e4b805h
		dd	083ad65bah, 0aeef1935h, 0c9f6a413h, 04a5bc1a9h, 01b3e87d6h, 059f0a05eh, 08a14185bh, 07002af3bh
		dd	0e004ab76h, 05049ddbfh, 0184adf63h, 0b6a5c656h, 0533d850ah, 01287fa37h, 094b677a7h, 05165467fh
		dd	0b161ed09h, 0e6ec1be9h, 08545d525h, 03b75f552h, 041ba7f3dh, 042ce2788h, 04eebb243h, 0e9bdd697h
		dd	09e7b52f3h, 07f536245h, 0fb3a2ca0h, 0d1bc7b70h, 0f71fb96bh, 0171b121dh, 0ee79fdc8h, 07c273af0h
		dd	0450a0cd7h, 060dd9679h, 0f63322abh, 01cfaac89h, 0bbacc85dh, 07d0ba130h, 0a1bed44bh, 00be1be94h
		dd	00acd2554h, 0467e5462h, 011f3a282h, 0a3e6173eh, 0663526e6h, 00258c375h, 08b38839bh, 0bd4478c2h
		dd	0480302dch, 0a0924f8bh, 0b3392e7ch, 084694ee5h, 08f88f071h, 0392d3627h, 0fdd29c3fh, 024fb016eh
		dd	0163789ddh, 000000000h, 0578df6e0h, 09893e26ch, 0f84e7415h, 0d420935ah, 03801ade7h, 05d40d3b4h
		dd	0c2171a87h, 06a10b32dh, 0d678502fh, 01f8ef43ch, 0a50ea7a1h, 04cb37136h, 025d79aaeh, 0db715e24h
		dd	0871d1650h, 0f962efd5h, 086318d90h, 01a121c16h, 081f5a6cfh, 06f8c5b07h, 01dd63749h, 03a596e92h
		dd	077c68464h, 03fc586b8h, 0cd46d7f9h, 0d090e0b0h, 04fc72983h, 04096e4fdh, 00d090e0bh, 056a16d20h
		dd	0eac98e22h, 0884cdb2eh, 07376f78eh, 0b215b5bch, 05f1810c1h, 0a92b326ah, 08ea46bb1h, 054f9ae55h
		dd	0896040eeh, 0ef556608h, 02167e944h, 0ec213ebdh, 0be302077h, 0c78bf2adh, 0e7c08029h, 0cf1e148ch
		dd	043e2bc48h, 0fea6c48ah, 0c5d331d8h, 0fa16b760h, 0ba80539dh, 0c04fd9f2h, 03ee91d78h, 02e36243ah
		dd	0f46be1deh, 0d754cbefh, 0f1f709f4h, 0afc382f5h, 0b9f40b28h, 0d9299d51h, 0925ec738h, 05a84f8ebh
		dd	0b8d890e8h, 03cb1de0dh, 08dd03304h, 0e25c6803h, 0da5dc5e4h, 058dc3b9eh, 09d0f0a46h, 0c8da3fd3h
		dd	0278f59dbh, 08cfca8c4h, 099bf79ach, 0725a6c4eh, 0a2ca8cfeh, 0b5d19ee3h, 076ea1fa4h, 004b073eah

Td2		dd	068e302bch, 085550c62h, 03f2a3123h, 0ab61f713h, 0d498726dh, 0cb21199ah, 0223c61a4h, 09d45cd3dh
		dd	0fd0523b4h, 0c42b5f07h, 02c9bc001h, 0d93d0f80h, 06c48745ch, 07ff9857eh, 073f11fabh, 0edb60edeh
		dd	03c28ed6bh, 097491a78h, 02a9f8d91h, 057c9339fh, 007a9aaa8h, 00da57dedh, 0427c8f2dh, 04d76c9b0h
		dd	0914d57e8h, 0a9cecc63h, 0eeb4d296h, 02830b6e1h, 0f10db961h, 019bd2667h, 09b4180adh, 0a0c0c76eh
		dd	0835141f2h, 0db9234f0h, 0a26ffc1eh, 0328f4cceh, 0e0137333h, 0a7696dc6h, 06de59364h, 01abffa2fh
		dd	01cbbb7bfh, 07458b503h, 06ee74f2ch, 0895d96b7h, 09ce82a05h, 06644a319h, 02e34fb71h, 0f20f6529h
		dd	081fe7a82h, 013b1f122h, 008a3ec35h, 051cd7e0fh, 07aff14a6h, 0725cf893h, 0c22f1297h, 070f3c3e3h
		dd	02f991c49h, 043d16815h, 0a3c21b26h, 0cc88b332h, 0cf8a6f7ah, 0e8b09f06h, 0477a1ef5h, 0bbd2da79h
		dd	095e62108h, 098435ce5h, 0b8d00631h, 0e311af7bh, 0417e5365h, 0aacc102bh, 0b4d89ce4h, 05664d4a7h
		dd	07cfb5936h, 04b728420h, 09feaf64dh, 05f6adfaah, 0c12dcedfh, 048705868h, 0afca81f3h, 0050691d8h
		dd	0775a694bh, 0de94a528h, 0df394210h, 03b8147c3h, 082fca6cah, 0c823c5d2h, 0f803b26ch, 00c089ad5h
		dd	0b7da40ach, 0b97de109h, 024382c34h, 052cfa247h, 0b2dcd174h, 0a8632b5bh, 0d5359555h, 09e471175h
		dd	0e515e2ebh, 0944bc630h, 06f4aa814h, 02391869ch, 06a4c39cch, 08a5f4affh, 006044d90h, 099eebbddh
		dd	0111eca52h, 0ffaa18c4h, 064eb9869h, 0fe07fffch, 0348b015eh, 07d56be0eh, 0e7bad99bh, 0634232c1h
		dd	0b5757bdch, 026971744h, 0ae6766cbh, 02595cb0ch, 09aec6795h, 08657d02ah, 050609937h, 0e4b805d3h
		dd	0ad65ba83h, 0ef1935aeh, 0f6a413c9h, 05bc1a94ah, 03e87d61bh, 0f0a05e59h, 014185b8ah, 002af3b70h
		dd	004ab76e0h, 049ddbf50h, 04adf6318h, 0a5c656b6h, 03d850a53h, 087fa3712h, 0b677a794h, 065467f51h
		dd	061ed09b1h, 0ec1be9e6h, 045d52585h, 075f5523bh, 0ba7f3d41h, 0ce278842h, 0ebb2434eh, 0bdd697e9h
		dd	07b52f39eh, 05362457fh, 03a2ca0fbh, 0bc7b70d1h, 01fb96bf7h, 01b121d17h, 079fdc8eeh, 0273af07ch
		dd	00a0cd745h, 0dd967960h, 03322abf6h, 0faac891ch, 0acc85dbbh, 00ba1307dh, 0bed44ba1h, 0e1be940bh
		dd	0cd25540ah, 07e546246h, 0f3a28211h, 0e6173ea3h, 03526e666h, 058c37502h, 038839b8bh, 04478c2bdh
		dd	00302dc48h, 0924f8ba0h, 0392e7cb3h, 0694ee584h, 088f0718fh, 02d362739h, 0d29c3ffdh, 0fb016e24h
		dd	03789dd16h, 000000000h, 08df6e057h, 093e26c98h, 04e7415f8h, 020935ad4h, 001ade738h, 040d3b45dh
		dd	0171a87c2h, 010b32d6ah, 078502fd6h, 08ef43c1fh, 00ea7a1a5h, 0b371364ch, 0d79aae25h, 0715e24dbh
		dd	01d165087h, 062efd5f9h, 0318d9086h, 0121c161ah, 0f5a6cf81h, 08c5b076fh, 0d637491dh, 0596e923ah
		dd	0c6846477h, 0c586b83fh, 046d7f9cdh, 090e0b0d0h, 0c729834fh, 096e4fd40h, 0090e0b0dh, 0a16d2056h
		dd	0c98e22eah, 04cdb2e88h, 076f78e73h, 015b5bcb2h, 01810c15fh, 02b326aa9h, 0a46bb18eh, 0f9ae5554h
		dd	06040ee89h, 0556608efh, 067e94421h, 0213ebdech, 0302077beh, 08bf2adc7h, 0c08029e7h, 01e148ccfh
		dd	0e2bc4843h, 0a6c48afeh, 0d331d8c5h, 016b760fah, 080539dbah, 04fd9f2c0h, 0e91d783eh, 036243a2eh
		dd	06be1def4h, 054cbefd7h, 0f709f4f1h, 0c382f5afh, 0f40b28b9h, 0299d51d9h, 05ec73892h, 084f8eb5ah
		dd	0d890e8b8h, 0b1de0d3ch, 0d033048dh, 05c6803e2h, 05dc5e4dah, 0dc3b9e58h, 00f0a469dh, 0da3fd3c8h
		dd	08f59db27h, 0fca8c48ch, 0bf79ac99h, 05a6c4e72h, 0ca8cfea2h, 0d19ee3b5h, 0ea1fa476h, 0b073ea04h

Td3		dd	0e302bc68h, 0550c6285h, 02a31233fh, 061f713abh, 098726dd4h, 021199acbh, 03c61a422h, 045cd3d9dh
		dd	00523b4fdh, 02b5f07c4h, 09bc0012ch, 03d0f80d9h, 048745c6ch, 0f9857e7fh, 0f11fab73h, 0b60edeedh
		dd	028ed6b3ch, 0491a7897h, 09f8d912ah, 0c9339f57h, 0a9aaa807h, 0a57ded0dh, 07c8f2d42h, 076c9b04dh
		dd	04d57e891h, 0cecc63a9h, 0b4d296eeh, 030b6e128h, 00db961f1h, 0bd266719h, 04180ad9bh, 0c0c76ea0h
		dd	05141f283h, 09234f0dbh, 06ffc1ea2h, 08f4cce32h, 0137333e0h, 0696dc6a7h, 0e593646dh, 0bffa2f1ah
		dd	0bbb7bf1ch, 058b50374h, 0e74f2c6eh, 05d96b789h, 0e82a059ch, 044a31966h, 034fb712eh, 00f6529f2h
		dd	0fe7a8281h, 0b1f12213h, 0a3ec3508h, 0cd7e0f51h, 0ff14a67ah, 05cf89372h, 02f1297c2h, 0f3c3e370h
		dd	0991c492fh, 0d1681543h, 0c21b26a3h, 088b332cch, 08a6f7acfh, 0b09f06e8h, 07a1ef547h, 0d2da79bbh
		dd	0e6210895h, 0435ce598h, 0d00631b8h, 011af7be3h, 07e536541h, 0cc102baah, 0d89ce4b4h, 064d4a756h
		dd	0fb59367ch, 07284204bh, 0eaf64d9fh, 06adfaa5fh, 02dcedfc1h, 070586848h, 0ca81f3afh, 00691d805h
		dd	05a694b77h, 094a528deh, 0394210dfh, 08147c33bh, 0fca6ca82h, 023c5d2c8h, 003b26cf8h, 0089ad50ch
		dd	0da40acb7h, 07de109b9h, 0382c3424h, 0cfa24752h, 0dcd174b2h, 0632b5ba8h, 0359555d5h, 04711759eh
		dd	015e2ebe5h, 04bc63094h, 04aa8146fh, 091869c23h, 04c39cc6ah, 05f4aff8ah, 0044d9006h, 0eebbdd99h
		dd	01eca5211h, 0aa18c4ffh, 0eb986964h, 007fffcfeh, 08b015e34h, 056be0e7dh, 0bad99be7h, 04232c163h
		dd	0757bdcb5h, 097174426h, 06766cbaeh, 095cb0c25h, 0ec67959ah, 057d02a86h, 060993750h, 0b805d3e4h
		dd	065ba83adh, 01935aeefh, 0a413c9f6h, 0c1a94a5bh, 087d61b3eh, 0a05e59f0h, 0185b8a14h, 0af3b7002h
		dd	0ab76e004h, 0ddbf5049h, 0df63184ah, 0c656b6a5h, 0850a533dh, 0fa371287h, 077a794b6h, 0467f5165h
		dd	0ed09b161h, 01be9e6ech, 0d5258545h, 0f5523b75h, 07f3d41bah, 0278842ceh, 0b2434eebh, 0d697e9bdh
		dd	052f39e7bh, 062457f53h, 02ca0fb3ah, 07b70d1bch, 0b96bf71fh, 0121d171bh, 0fdc8ee79h, 03af07c27h
		dd	00cd7450ah, 0967960ddh, 022abf633h, 0ac891cfah, 0c85dbbach, 0a1307d0bh, 0d44ba1beh, 0be940be1h
		dd	025540acdh, 05462467eh, 0a28211f3h, 0173ea3e6h, 026e66635h, 0c3750258h, 0839b8b38h, 078c2bd44h
		dd	002dc4803h, 04f8ba092h, 02e7cb339h, 04ee58469h, 0f0718f88h, 03627392dh, 09c3ffdd2h, 0016e24fbh
		dd	089dd1637h, 000000000h, 0f6e0578dh, 0e26c9893h, 07415f84eh, 0935ad420h, 0ade73801h, 0d3b45d40h
		dd	01a87c217h, 0b32d6a10h, 0502fd678h, 0f43c1f8eh, 0a7a1a50eh, 071364cb3h, 09aae25d7h, 05e24db71h
		dd	01650871dh, 0efd5f962h, 08d908631h, 01c161a12h, 0a6cf81f5h, 05b076f8ch, 037491dd6h, 06e923a59h
		dd	0846477c6h, 086b83fc5h, 0d7f9cd46h, 0e0b0d090h, 029834fc7h, 0e4fd4096h, 00e0b0d09h, 06d2056a1h
		dd	08e22eac9h, 0db2e884ch, 0f78e7376h, 0b5bcb215h, 010c15f18h, 0326aa92bh, 06bb18ea4h, 0ae5554f9h
		dd	040ee8960h, 06608ef55h, 0e9442167h, 03ebdec21h, 02077be30h, 0f2adc78bh, 08029e7c0h, 0148ccf1eh
		dd	0bc4843e2h, 0c48afea6h, 031d8c5d3h, 0b760fa16h, 0539dba80h, 0d9f2c04fh, 01d783ee9h, 0243a2e36h
		dd	0e1def46bh, 0cbefd754h, 009f4f1f7h, 082f5afc3h, 00b28b9f4h, 09d51d929h, 0c738925eh, 0f8eb5a84h
		dd	090e8b8d8h, 0de0d3cb1h, 033048dd0h, 06803e25ch, 0c5e4da5dh, 03b9e58dch, 00a469d0fh, 03fd3c8dah
		dd	059db278fh, 0a8c48cfch, 079ac99bfh, 06c4e725ah, 08cfea2cah, 09ee3b5d1h, 01fa476eah, 073ea04b0h

Sd		db	 53, 190,   7,  46,  83, 105, 219,  40, 111, 183, 118, 107,  12, 125,  54, 139
		db	146, 188, 169,  50, 172,  56, 156,  66,  99, 200,  30,  79,  36, 229, 247, 201
		db	 97, 141,  47,  63, 179, 101, 127, 112, 175, 154, 234, 245,  91, 152, 144, 177
		db	135, 113, 114, 237,  55,  69, 104, 163, 227, 239,  92, 197,  80, 193, 214, 202
		db	 90,  98,  95,  38,   9,  93,  20,  65, 232, 157, 206,  64, 253,   8,  23,  74
		db	 15, 199, 180,  62,  18, 252,  37,  75, 129,  44,   4, 120, 203, 187,  32, 189
		db	249,  41, 153, 168, 211,  96, 223,  17, 151, 137, 126, 250, 224, 155,  31, 210
		db	103, 226, 100, 119, 132,  43, 158, 138, 241, 109, 136, 121, 116,  87, 221, 230
		db	 57, 123, 238, 131, 225,  88, 242,  13,  52, 248,  48, 233, 185,  35,  84,  21
		db	 68,  11,  77, 102,  58,   3, 162, 145, 148,  82,  76, 195, 130, 231, 128, 192
		db	182,  14, 194, 108, 147, 236, 171,  67, 149, 246, 216,  70, 134,   5, 140, 176
		db	117,   0, 204, 133, 215,  61, 115, 122,  72, 228, 209,  89, 173, 184, 198, 208
		db	220, 161, 170,   2,  29, 191, 181, 159,  81, 196, 165,  16,  34, 207,   1, 186
		db	143,  49, 124, 174, 150, 218, 240,  86,  71, 212, 235,  78, 217,  19, 142,  73
		db	 85,  22, 255,  59, 244, 164, 178,   6, 160, 167, 251,  27, 110,  60,  51, 205
		db	 24,  94, 106, 213, 166,  33, 222, 254,  42,  28, 243,  10,  26,  25,  39,  45

Square_Decrypt		endp

Square_Clear		proc

	push	eax
	push	ecx
	push	edi

	xor	eax, eax
	mov	ecx, 98h/4
	mov	edi, offset square_internal_pass
	cld
	rep	stosd

	pop	edi
	pop	ecx
	pop	eax
	ret

Square_Clear		endp

.data?
square_internal_pass	db 90h dup (?)
_old_esp		dd	?
_counter		dd	?