comment %

Algo	: SPEED (by Yuliang Zheng)
Block	: 8, 16 or 32 bytes
Rounds	: as you wish
Key	: 48 - 256 bits


	push	offset password
	call	Speed_SetKey
	
	push	offset plain
	push	offset cipher
	call	Speed_Encrypt
	
	push	offset cipher
	push	offset decrypted_plain
	call	Speed_Decrypt
	
	call	Speed_Clear


Oryginal C implementation :

 *
 * The following three parameters 
 *      (1) SPEED_DATA_LEN
 *      (2) SPEED_KEY_LEN
 *      (3) SPEED_NO_OF_RND
 * may be modified.
 *
 * Suggested combinations for providing adequate security:
 *
 *  +--------------------------------------------------+
 *  | SPEED_DATA_LEN | SPEED_KEY_LEN | SPEED_NO_OF_RND |
 *  |==================================================|
 *  |       64       |     >= 64     |     >= 64       | 
 *  |--------------------------------------------------|
 *  |      128       |     >= 64     |     >= 48       | 
 *  |--------------------------------------------------|
 *  |      256       |     >= 64     |     >= 48       | 
 *  +--------------------------------------------------+
 *

"Cryptanalysis of SPEED (Extended Abstract)" Chris Hall, John Kelsey, Bruce Schneier, and David Wagner :

		"we would recommend against using SPEED for high security applications"


Test vectors	: (hex, reversed order !)

SPEED_DATA_LEN = 64, SPEED_KEY_LEN = 64, SPEED_NO_OF_RND = 64
key        = 00 00 00 00 00 00 00 00 
plaintext  = 00 00 00 00 00 00 00 00 
ciphertext = 2E 00 80 19 BC 26 85 6D 

SPEED_DATA_LEN = 128, SPEED_KEY_LEN = 128, SPEED_NO_OF_RND = 128
key        = FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF 
plaintext  = FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF 
ciphertext = 6C 13 E4 B9 C3 17 15 71 AB 54 D8 16 91 5B C4 E8 

SPEED_DATA_LEN = 256, SPEED_KEY_LEN = 256, SPEED_NO_OF_RND = 256
key        = 60 5F 5E 5D 5C 5B 5A 59 58 57 56 55 54 53 52 51 50 4F 4E 4D 4C 4B 4A 49 48 47 46 45 44 43 42 41 
plaintext  = 1F 1E 1D 1C 1B 1A 19 18 17 16 15 14 13 12 11 10 0F 0E 0D 0C 0B 0A 09 08 07 06 05 04 03 02 01 00 
ciphertext = 3D E1 6C FA 9A 62 68 47 43 4E 15 74 69 3F EC 1B 3F AA 55 8A 29 6B 61 D7 08 B1 31 CC BA 31 10 68 


Improvements:
/*
#define FF1(x6, x5, x4, x3, x2, x1, x0)	((x6) & (x3)) ^ ((x5) & (x1)) ^ ((x4) & (x2)) ^ ((x1) & (x0)) ^ (x0)
#define FF2(x6, x5, x4, x3, x2, x1, x0)	((x6) & (x4) & (x0)) ^ ((x4) & (x3) & (x0)) ^ ((x5) & (x2)) ^ ((x4) & (x3)) ^ ((x4) & (x1)) ^ ((x3) & (x0)) ^ (x1)
#define FF3(x6, x5, x4, x3, x2, x1, x0)	((x5) & (x4) & (x0)) ^ ((x6) & (x4)) ^ ((x5) & (x2)) ^ ((x3) & (x0)) ^ ((x1) & (x0)) ^ (x3) 
#define FF4(x6, x5, x4, x3, x2, x1, x0)	((x6) & (x4) & (x2) & (x0)) ^ ((x6) & (x5)) ^ ((x4) & (x3)) ^ ((x3) & (x2)) ^ ((x1) & (x0)) ^ (x2)
*/

// optimized by WiteG//xtreeme
#define FF1(x6, x5, x4, x3, x2, x1, x0)	((x1) & ((x0) ^ (x5))) ^ ((x4) & (x2)) ^ ((x6) & (x3)) ^ (x0)
#define FF2(x6, x5, x4, x3, x2, x1, x0)	((x4) & (((x6) & (x0)) ^ (x1))) ^ ((x3) & ((x0) | (x4))) ^ ((x5) & (x2)) ^ (x1)
#define FF3(x6, x5, x4, x3, x2, x1, x0)	((x0) & ((x1) ^ (x3))) ^ ((x4) & (((x0) & (x5)) ^ (x6))) ^ ((x5) & (x2)) ^ (x3)
#define FF4(x6, x5, x4, x3, x2, x1, x0)	((x6) & (((x4) & (x2) & (x0)) ^ (x5))) ^ ((x3) & ((x4) ^ (x2))) ^ ((x1) & (x0)) ^ (x2)


01.05.2002 WiteG//xtreeme (witeg@poczta.fm, www.witeg.prv.pl)
*
%

SPEED_KEY_LEN		equ	256	;48,64,80,96,112,128,144,160,176,192,208,224,240,256
SPEED_NO_OF_RND		equ	256	;32,36,40,44,48,52...
SPEED_DATA_LEN		equ	256	;64,128,256

include	speed.mac

.code
Speed_SetKey	proc	ptrPass:DWORD
	pushad
	mov	edi, ptrPass
	mov	esi, offset speed_internal_pass
	mov	ecx, SPEED_KEY_LEN/8-2
@@:
	mov	ax, word ptr [edi+ecx]
	mov	word ptr [esi+ecx], ax
	sub	ecx, 2
	jns	@B

	xor	edx, edx
	mov	bx, sqrt_0
	mov	bp, sqrt_1
	mov	di, sqrt_2
	mov	ax, bx
	mov	ecx, SPEED_KEY_LEN/16
@@:
	mov	dx, bp
	xor	ax, bp
	and	dx, bx
	and	ax, di
	xor	ax, dx
	rol	ax, 5
	
IF	SPEED_KEY_LEN eq 64
	mov	dx, cx
	add	ax, di
	and	dx, 3
ELSEIF	SPEED_KEY_LEN eq 128
	mov	dx, cx
	add	ax, di
	and	dx, 7
ELSEIF	SPEED_KEY_LEN eq 256
	mov	dx, cx
	add	ax, di
	and	dx, 15
ELSE
	push	eax
	mov	eax, ecx
	cdq
	div	dword ptr [_dzielnik]
	pop	eax
	add	ax, di
ENDIF

	add	ax, word ptr [esi+2*edx]
	mov	di, bp
	mov	word ptr [esi+2*ecx], ax
	mov	bp, bx
	inc	ecx
	mov	bx, ax
	cmp	ecx, KB_SIZE
	jnz	@B

	popad
	ret

IF	(SPEED_KEY_LEN ne 64) and (SPEED_KEY_LEN ne 128) and (SPEED_KEY_LEN ne 256)
	_dzielnik	dd SPEED_KEY_LEN/16
ENDIF
Speed_SetKey	endp

IF	SPEED_DATA_LEN eq 256
Speed_Encrypt	proc	ptrOut:DWORD, ptrIn:DWORD
	pushad
	mov	esi, ptrIn
	mov	edi, ptrOut
	mov	dword ptr [_esp], esp

	mov	ebx, dword ptr [esi +  4]
	mov	ebp, dword ptr [esi +  8]
	mov	edx, dword ptr [esi + 12]
	mov	dword ptr [edi +  4], ebx
	mov	dword ptr [edi + 12], edx
	mov	esp, dword ptr [esi + 16]
	mov	ebx, dword ptr [esi + 20]
	mov	ecx, dword ptr [esi + 24]
	mov	edx, dword ptr [esi + 28]
	mov	dword ptr [edi + 20], ebx
	mov	dword ptr [edi + 24], ecx
	mov	dword ptr [edi + 28], edx
	mov	esi, dword ptr [esi +  0]
	mov	ebx, offset speed_internal_pass

	mov	dword ptr [counter], SPEED_NO_OF_RND/4

@@:
	FF1	t6, t5, t4, t3, t2, t1, t0
	mov	ecx, eax
	mov	edx, t7
	shr	ecx, SPEED_DATA_LEN/16
	ror	edx, ((SPEED_DATA_LEN/16) - 1)
	add	cx, ax
	add	edx, dword ptr [ebx]
	shr	cx, V_SHIFT
	ror	eax, cl
	add	eax, edx

	mov	ecx, t6
	mov	edx, t5
	mov	t7, ecx
	mov	t6, edx
	mov	t5, t4
	mov	t4, t3
	mov	t3, t2
	mov	t2, t1
	mov	t1, t0
	mov	t0, eax
	add	ebx, 4
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4

@@:
	FF2	t6, t5, t4, t3, t2, t1, t0
	mov	ecx, eax
	mov	edx, t7
	shr	ecx, SPEED_DATA_LEN/16
	ror	edx, ((SPEED_DATA_LEN/16) - 1)
	add	cx, ax
	add	edx, dword ptr [ebx]
	shr	cx, V_SHIFT
	ror	eax, cl
	add	eax, edx

	mov	ecx, t6
	mov	edx, t5
	mov	t7, ecx
	mov	t6, edx
	mov	t5, t4
	mov	t4, t3
	mov	t3, t2
	mov	t2, t1
	mov	t1, t0
	mov	t0, eax
	add	ebx, 4
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4

@@:
	FF3	t6, t5, t4, t3, t2, t1, t0
	mov	ecx, eax
	mov	edx, t7
	shr	ecx, SPEED_DATA_LEN/16
	ror	edx, ((SPEED_DATA_LEN/16) - 1)
	add	cx, ax
	add	edx, dword ptr [ebx]
	shr	cx, V_SHIFT
	ror	eax, cl
	add	eax, edx

	mov	ecx, t6
	mov	edx, t5
	mov	t7, ecx
	mov	t6, edx
	mov	t5, t4
	mov	t4, t3
	mov	t3, t2
	mov	t2, t1
	mov	t1, t0
	mov	t0, eax
	add	ebx, 4
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4

@@:
	FF4	t6, t5, t4, t3, t2, t1, t0
	mov	ecx, eax
	mov	edx, t7
	shr	ecx, SPEED_DATA_LEN/16
	ror	edx, ((SPEED_DATA_LEN/16) - 1)
	add	cx, ax
	add	edx, dword ptr [ebx]
	shr	cx, V_SHIFT
	ror	eax, cl
	add	eax, edx

	mov	ecx, t6
	mov	edx, t5
	mov	t7, ecx
	mov	t6, edx
	mov	t5, t4
	mov	t4, t3
	mov	t3, t2
	mov	t2, t1
	mov	t1, t0
	mov	t0, eax
	add	ebx, 4
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [edi +  0], t0
	mov	dword ptr [edi +  8], t2
	mov	dword ptr [edi + 16], t4

	mov	esp, dword ptr [_esp]
	and	dword ptr [_esp], 0
	popad
	ret
Speed_Encrypt	endp

Speed_Decrypt	proc	ptrOut:DWORD, ptrIn:DWORD
	pushad
	mov	esi, ptrIn
	mov	edi, ptrOut
	mov	dword ptr [_esp], esp

	mov	ebx, dword ptr [esi +  4]
	mov	ebp, dword ptr [esi +  8]
	mov	edx, dword ptr [esi + 12]
	mov	dword ptr [edi +  4], ebx
	mov	dword ptr [edi + 12], edx
	mov	esp, dword ptr [esi + 16]
	mov	ebx, dword ptr [esi + 20]
	mov	ecx, dword ptr [esi + 24]
	mov	edx, dword ptr [esi + 28]
	mov	dword ptr [edi + 20], ebx
	mov	dword ptr [edi + 24], ecx
	mov	dword ptr [edi + 28], edx
	mov	esi, dword ptr [esi +  0]
	mov	ebx, offset speed_internal_pass + 4*(SPEED_NO_OF_RND - 1)

	mov	dword ptr [counter], SPEED_NO_OF_RND/4
@@:
	mov	dword ptr [_t_buffer], t0

	mov	t0, t1
	mov	t1, t2
	mov	t2, t3
	mov	t3, t4
	mov	t4, t5
	mov	ecx, t6
	mov	eax, t7
	mov	t5, ecx
	mov	t6, eax

	FF4	t6, t5, t4, t3, t2, t1, t0

	mov	ecx, eax
	mov	edx, dword ptr [_t_buffer]
	shr	ecx, SPEED_DATA_LEN/16
	add	cx, ax
	sub	edx, dword ptr [ebx]
	shr	cx, V_SHIFT
	ror	eax, cl
	sub	edx, eax
	rol	edx, ((SPEED_DATA_LEN/16) - 1)
	mov	t7, edx

	sub	ebx, 4
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4
@@:
	mov	dword ptr [_t_buffer], t0

	mov	t0, t1
	mov	t1, t2
	mov	t2, t3
	mov	t3, t4
	mov	t4, t5
	mov	ecx, t6
	mov	eax, t7
	mov	t5, ecx
	mov	t6, eax

	FF3	t6, t5, t4, t3, t2, t1, t0

	mov	ecx, eax
	mov	edx, dword ptr [_t_buffer]
	shr	ecx, SPEED_DATA_LEN/16
	add	cx, ax
	sub	edx, dword ptr [ebx]
	shr	cx, V_SHIFT
	ror	eax, cl
	sub	edx, eax
	rol	edx, ((SPEED_DATA_LEN/16) - 1)
	mov	t7, edx

	sub	ebx, 4
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4
@@:
	mov	dword ptr [_t_buffer], t0

	mov	t0, t1
	mov	t1, t2
	mov	t2, t3
	mov	t3, t4
	mov	t4, t5
	mov	ecx, t6
	mov	eax, t7
	mov	t5, ecx
	mov	t6, eax

	FF2	t6, t5, t4, t3, t2, t1, t0

	mov	ecx, eax
	mov	edx, dword ptr [_t_buffer]
	shr	ecx, SPEED_DATA_LEN/16
	add	cx, ax
	sub	edx, dword ptr [ebx]
	shr	cx, V_SHIFT
	ror	eax, cl
	sub	edx, eax
	rol	edx, ((SPEED_DATA_LEN/16) - 1)
	mov	t7, edx

	sub	ebx, 4
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4
@@:
	mov	dword ptr [_t_buffer], t0

	mov	t0, t1
	mov	t1, t2
	mov	t2, t3
	mov	t3, t4
	mov	t4, t5
	mov	ecx, t6
	mov	eax, t7
	mov	t5, ecx
	mov	t6, eax

	FF1	t6, t5, t4, t3, t2, t1, t0

	mov	ecx, eax
	mov	edx, dword ptr [_t_buffer]
	shr	ecx, SPEED_DATA_LEN/16
	add	cx, ax
	sub	edx, dword ptr [ebx]
	shr	cx, V_SHIFT
	ror	eax, cl
	sub	edx, eax
	rol	edx, ((SPEED_DATA_LEN/16) - 1)
	mov	t7, edx

	sub	ebx, 4
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [edi +  0], t0
	mov	dword ptr [edi +  8], t2
	mov	dword ptr [edi + 16], t4

	mov	esp, dword ptr [_esp]
	and	dword ptr [_esp], 0
	popad
	ret
Speed_Decrypt	endp

ELSEIF	SPEED_DATA_LEN eq 128
Speed_Encrypt	proc	ptrOut:DWORD, ptrIn:DWORD
	pushad

	mov	esi, ptrIn
	mov	edi, ptrOut
	mov	dword ptr [_esp], esp
	mov	ax, word ptr [esi +  6]
	mov	sp, word ptr [esi +  2]
	mov	dx, word ptr [esi +  8]
	mov	ecx, dword ptr [esi + 10]
	mov	word ptr [edi +  6], ax
	mov	dword ptr [edi + 10], ecx
	mov	ax, word ptr [esi + 14]
	mov	bp, word ptr [esi +  0]
	mov	word ptr [edi + 14], ax
	mov	si, word ptr [esi +  4]

	mov	ebx, offset speed_internal_pass

	mov	dword ptr [counter], SPEED_NO_OF_RND/4
@@:
	FF1	t6, t5, t4, t3, t2, t1, t0

	mov	cx, ax
	shr	cx, SPEED_DATA_LEN/16
	add	cl, al
	shr	cl, V_SHIFT
	ror	ax, cl
	add	ax, word ptr [ebx]
	mov	cx, t7
	ror	cx, ((SPEED_DATA_LEN/16) - 1)
	add	ax, cx

	mov	cx, t6
	mov	t7, cx
	mov	cx, t5
	mov	t6, cx
	mov	t5, t4
	mov	t4, t3
	mov	t3, t2
	mov	t2, t1
	mov	t1, t0
	mov	t0, ax

	add	ebx, 2
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4
@@:
	FF2	t6, t5, t4, t3, t2, t1, t0

	mov	cx, ax
	shr	cx, SPEED_DATA_LEN/16
	add	cl, al
	shr	cl, V_SHIFT
	ror	ax, cl
	add	ax, word ptr [ebx]
	mov	cx, t7
	ror	cx, ((SPEED_DATA_LEN/16) - 1)
	add	ax, cx

	mov	cx, t6
	mov	t7, cx
	mov	cx, t5
	mov	t6, cx
	mov	t5, t4
	mov	t4, t3
	mov	t3, t2
	mov	t2, t1
	mov	t1, t0
	mov	t0, ax

	add	ebx, 2
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4
@@:
	FF3	t6, t5, t4, t3, t2, t1, t0

	mov	cx, ax
	shr	cx, SPEED_DATA_LEN/16
	add	cl, al
	shr	cl, V_SHIFT
	ror	ax, cl
	add	ax, word ptr [ebx]
	mov	cx, t7
	ror	cx, ((SPEED_DATA_LEN/16) - 1)
	add	ax, cx

	mov	cx, t6
	mov	t7, cx
	mov	cx, t5
	mov	t6, cx
	mov	t5, t4
	mov	t4, t3
	mov	t3, t2
	mov	t2, t1
	mov	t1, t0
	mov	t0, ax

	add	ebx, 2
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4
@@:
	FF4	t6, t5, t4, t3, t2, t1, t0

	mov	cx, ax
	shr	cx, SPEED_DATA_LEN/16
	add	cl, al
	shr	cl, V_SHIFT
	ror	ax, cl
	add	ax, word ptr [ebx]
	mov	cx, t7
	ror	cx, ((SPEED_DATA_LEN/16) - 1)
	add	ax, cx

	mov	cx, t6
	mov	t7, cx
	mov	cx, t5
	mov	t6, cx
	mov	t5, t4
	mov	t4, t3
	mov	t3, t2
	mov	t2, t1
	mov	t1, t0
	mov	t0, ax

	add	ebx, 2
	dec	dword ptr [counter]
	jnz	@B

	mov	word ptr [edi +  0], bp
	mov	word ptr [edi +  2], sp
	mov	word ptr [edi +  4], si
	mov	esp, dword ptr [_esp]
	mov	word ptr [edi +  8], dx
	and	dword ptr [_esp], 0
	popad
	ret
Speed_Encrypt	endp

Speed_Decrypt	proc	ptrOut:DWORD, ptrIn:DWORD
	pushad

	mov	esi, ptrIn
	mov	edi, ptrOut
	mov	dword ptr [_esp], esp
	mov	ax, word ptr [esi +  6]
	mov	sp, word ptr [esi +  2]
	mov	dx, word ptr [esi +  8]
	mov	ecx, dword ptr [esi + 10]
	mov	word ptr [edi +  6], ax
	mov	dword ptr [edi + 10], ecx
	mov	ax, word ptr [esi + 14]
	mov	bp, word ptr [esi +  0]
	mov	word ptr [edi + 14], ax
	mov	si, word ptr [esi +  4]

	mov	ebx, offset speed_internal_pass + 2* (SPEED_NO_OF_RND - 1)
	mov	dword ptr [counter], SPEED_NO_OF_RND/4
@@:
	mov	word ptr [_t_buffer], t0

	mov	t0, t1
	mov	t1, t2
	mov	t2, t3
	mov	t3, t4
	mov	t4, t5
	mov	cx, t6
	mov	ax, t7
	mov	t5, cx
	mov	t6, ax

	FF4	t6, t5, t4, t3, t2, t1, t0

	mov	cx, ax
	shr	cx, SPEED_DATA_LEN/16
	add	cl, al
	shr	cl, V_SHIFT
	ror	ax, cl
	add	ax, word ptr [ebx]
	mov	cx, word ptr [_t_buffer]
	sub	cx, ax
	rol	cx, ((SPEED_DATA_LEN/16) - 1)
	mov	t7, cx

	sub	ebx, 2
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4
@@:
	mov	word ptr [_t_buffer], t0

	mov	t0, t1
	mov	t1, t2
	mov	t2, t3
	mov	t3, t4
	mov	t4, t5
	mov	cx, t6
	mov	ax, t7
	mov	t5, cx
	mov	t6, ax

	FF3	t6, t5, t4, t3, t2, t1, t0

	mov	cx, ax
	shr	cx, SPEED_DATA_LEN/16
	add	cl, al
	shr	cl, V_SHIFT
	ror	ax, cl
	add	ax, word ptr [ebx]
	mov	cx, word ptr [_t_buffer]
	sub	cx, ax
	rol	cx, ((SPEED_DATA_LEN/16) - 1)
	mov	t7, cx

	sub	ebx, 2
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4
@@:
	mov	word ptr [_t_buffer], t0

	mov	t0, t1
	mov	t1, t2
	mov	t2, t3
	mov	t3, t4
	mov	t4, t5
	mov	cx, t6
	mov	ax, t7
	mov	t5, cx
	mov	t6, ax

	FF2	t6, t5, t4, t3, t2, t1, t0

	mov	cx, ax
	shr	cx, SPEED_DATA_LEN/16
	add	cl, al
	shr	cl, V_SHIFT
	ror	ax, cl
	add	ax, word ptr [ebx]
	mov	cx, word ptr [_t_buffer]
	sub	cx, ax
	rol	cx, ((SPEED_DATA_LEN/16) - 1)
	mov	t7, cx

	sub	ebx, 2
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4
@@:
	mov	word ptr [_t_buffer], t0

	mov	t0, t1
	mov	t1, t2
	mov	t2, t3
	mov	t3, t4
	mov	t4, t5
	mov	cx, t6
	mov	ax, t7
	mov	t5, cx
	mov	t6, ax

	FF1	t6, t5, t4, t3, t2, t1, t0

	mov	cx, ax
	shr	cx, SPEED_DATA_LEN/16
	add	cl, al
	shr	cl, V_SHIFT
	ror	ax, cl
	add	ax, word ptr [ebx]
	mov	cx, word ptr [_t_buffer]
	sub	cx, ax
	rol	cx, ((SPEED_DATA_LEN/16) - 1)
	mov	t7, cx

	sub	ebx, 2
	dec	dword ptr [counter]
	jnz	@B

	mov	word ptr [edi +  0], bp
	mov	word ptr [edi +  2], sp
	mov	word ptr [edi +  4], si
	mov	esp, dword ptr [_esp]
	mov	word ptr [edi +  8], dx
	and	dword ptr [_esp], 0
	popad
	ret
Speed_Decrypt	endp

ELSEIF	SPEED_DATA_LEN eq 64
Speed_Encrypt	proc	ptrOut:DWORD, ptrIn:DWORD
	pushad
	mov	esi, ptrIn
	mov	edi, ptrOut
	mov	dx, word ptr [esi+6]
	add	edi, 6
	mov	ax, word ptr [esi]		;al = x0, ah = x1
	mov	word ptr [edi], dx
	mov	bx, word ptr [esi+2]		;bl = x2, bh = x3
	mov	dx, word ptr [esi+4]		;dl = x4, dh = x5
	
	mov	esi, offset speed_internal_pass
	mov	dword ptr [counter], SPEED_NO_OF_RND/4

@@:
	FF1	t6, t5, t4, t3, t2, t1, t0

	mov	ch, cl
	shr	cl, SPEED_DATA_LEN/16
	add	cl, ch
	and	cl, 0Fh
	shr	cl, V_SHIFT
	ror	ch, cl
	add	ch, byte ptr [esi]
	mov	cl, t7
	ror	cl, ((SPEED_DATA_LEN/16) - 1)
	add	ch, cl

	mov	cl, t6
	mov	t7, cl
	mov	t6, t5
	mov	t5, t4
	mov	t4, t3
	mov	t3, t2
	mov	t2, t1
	mov	t1, t0
	mov	t0, ch
	inc	esi
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4

@@:
	FF2	t6, t5, t4, t3, t2, t1, t0

	mov	ch, cl
	shr	cl, SPEED_DATA_LEN/16
	add	cl, ch
	and	cl, 0Fh
	shr	cl, V_SHIFT
	ror	ch, cl
	add	ch, byte ptr [esi]
	mov	cl, t7
	ror	cl, ((SPEED_DATA_LEN/16) - 1)
	add	ch, cl

	mov	cl, t6
	mov	t7, cl
	mov	t6, t5
	mov	t5, t4
	mov	t4, t3
	mov	t3, t2
	mov	t2, t1
	mov	t1, t0
	mov	t0, ch
	inc	esi

	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4

@@:
	FF3	t6, t5, t4, t3, t2, t1, t0

	mov	ch, cl
	shr	cl, SPEED_DATA_LEN/16
	add	cl, ch
	and	cl, 0Fh
	shr	cl, V_SHIFT
	ror	ch, cl
	add	ch, byte ptr [esi]
	mov	cl, t7
	ror	cl, ((SPEED_DATA_LEN/16) - 1)
	add	ch, cl

	mov	cl, t6
	mov	t7, cl
	mov	t6, t5
	mov	t5, t4
	mov	t4, t3
	mov	t3, t2
	mov	t2, t1
	mov	t1, t0
	mov	t0, ch
	inc	esi

	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4
@@:
	FF4	t6, t5, t4, t3, t2, t1, t0

	mov	ch, cl
	shr	cl, SPEED_DATA_LEN/16
	add	cl, ch
	and	cl, 0Fh
	shr	cl, V_SHIFT
	ror	ch, cl
	add	ch, byte ptr [esi]
	mov	cl, t7
	ror	cl, ((SPEED_DATA_LEN/16) - 1)
	add	ch, cl

	mov	cl, t6
	mov	t7, cl
	mov	t6, t5
	mov	t5, t4
	mov	t4, t3
	mov	t3, t2
	mov	t2, t1
	mov	t1, t0
	mov	t0, ch
	inc	esi

	dec	dword ptr [counter]
	jnz	@B

	mov	word ptr [edi-6], ax
	mov	word ptr [edi-4], bx
	mov	word ptr [edi-2], dx

	popad
	ret
Speed_Encrypt	endp

Speed_Decrypt	proc	ptrOut:DWORD, ptrIn:DWORD
	pushad
	mov	esi, ptrIn
	mov	edi, ptrOut
	mov	dx, word ptr [esi+6]
	add	edi, 6
	mov	ax, word ptr [esi]		;al = x0, ah = x1
	mov	word ptr [edi], dx
	mov	bx, word ptr [esi+2]		;bl = x2, bh = x3
	mov	dx, word ptr [esi+4]		;dl = x4, dh = x5
	
	mov	esi, offset speed_internal_pass + SPEED_NO_OF_RND - 1
	mov	dword ptr [counter], SPEED_NO_OF_RND/4
@@:
	mov	byte ptr [_t_buffer], t0

	mov	t0, t1
	mov	t1, t2
	mov	t2, t3
	mov	t3, t4
	mov	t4, t5
	mov	cl, t7
	mov	t5, t6
	mov	t6, cl

	FF4	t6, t5, t4, t3, t2, t1, t0

	mov	ch, cl
	shr	cl, SPEED_DATA_LEN/16
	add	cl, ch
	and	cl, 0Fh
	shr	cl, V_SHIFT
	ror	ch, cl
	add	ch, byte ptr [esi]
	mov	cl, byte ptr [_t_buffer]
	sub	cl, ch
	rol	cl, ((SPEED_DATA_LEN/16) - 1)
	mov	t7, cl

	dec	esi
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4
@@:
	mov	byte ptr [_t_buffer], t0

	mov	t0, t1
	mov	t1, t2
	mov	t2, t3
	mov	t3, t4
	mov	t4, t5
	mov	cl, t7
	mov	t5, t6
	mov	t6, cl

	FF3	t6, t5, t4, t3, t2, t1, t0

	mov	ch, cl
	shr	cl, SPEED_DATA_LEN/16
	add	cl, ch
	and	cl, 0Fh
	shr	cl, V_SHIFT
	ror	ch, cl
	add	ch, byte ptr [esi]
	mov	cl, byte ptr [_t_buffer]
	sub	cl, ch
	rol	cl, ((SPEED_DATA_LEN/16) - 1)
	mov	t7, cl

	dec	esi
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4
@@:
	mov	byte ptr [_t_buffer], t0

	mov	t0, t1
	mov	t1, t2
	mov	t2, t3
	mov	t3, t4
	mov	t4, t5
	mov	cl, t7
	mov	t5, t6
	mov	t6, cl

	FF2	t6, t5, t4, t3, t2, t1, t0

	mov	ch, cl
	shr	cl, SPEED_DATA_LEN/16
	add	cl, ch
	and	cl, 0Fh
	shr	cl, V_SHIFT
	ror	ch, cl
	add	ch, byte ptr [esi]
	mov	cl, byte ptr [_t_buffer]
	sub	cl, ch
	rol	cl, ((SPEED_DATA_LEN/16) - 1)
	mov	t7, cl

	dec	esi
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4
@@:
	mov	byte ptr [_t_buffer], t0

	mov	t0, t1
	mov	t1, t2
	mov	t2, t3
	mov	t3, t4
	mov	t4, t5
	mov	cl, t7
	mov	t5, t6
	mov	t6, cl

	FF1	t6, t5, t4, t3, t2, t1, t0

	mov	ch, cl
	shr	cl, SPEED_DATA_LEN/16
	add	cl, ch
	and	cl, 0Fh
	shr	cl, V_SHIFT
	ror	ch, cl
	add	ch, byte ptr [esi]
	mov	cl, byte ptr [_t_buffer]
	sub	cl, ch
	rol	cl, ((SPEED_DATA_LEN/16) - 1)
	mov	t7, cl

	dec	esi
	dec	dword ptr [counter]
	jnz	@B

	mov	word ptr [edi-6], ax
	mov	word ptr [edi-4], bx
	mov	word ptr [edi-2], dx

	popad
	ret
Speed_Decrypt	endp
ENDIF

Speed_Clear	proc
	pushad
	xor	eax, eax
	mov	ecx, KB_SIZE/2 + 2
	mov	edi, offset speed_internal_pass
	cld
	rep	stosd
	popad
	ret
Speed_Clear	endp

.data?
speed_internal_pass	dw KB_SIZE dup (?)
counter			dd ?
_t_buffer		db 4 dup (?)

IF	SPEED_DATA_LEN ne 64
_esp			dd ?
ENDIF