comment *

SKIPJACK Block Cipher (by U.S NSA)

Key length: 10 bytes
Block size: 8 bytes

	push	offset password		;10 bytes readed as password
	call	skipjack_setkey		;create internal key table

	push	offset plain
	push	offset cipher
	call	skipjack_encrypt

	push	offset cipher
	push	offset out
	call	skipjack_decrypt

	call	skipjack_clear		;destroy internal key table


01.02.2002 WiteG//xtreeme (witeg@poczta.fm, www.witeg.prv.pl)
*

skipjack_setkey		PROTO	:DWORD
skipjack_encrypt	PROTO	:DWORD, :DWORD
skipjack_decrypt	PROTO	:DWORD, :DWORD
skipjack_clear		PROTO

g_xor	macro		pass_1, pass_2, pass_3, pass_4 , wx, wy, nr_round

	xor	al, byte ptr [sjack_inter_key + edx + pass_1 * 100h]
	xor	dl, byte ptr [sjack_inter_key + eax + pass_2 * 100h]
	xor	al, byte ptr [sjack_inter_key + edx + pass_3 * 100h]
	xor	dl, byte ptr [sjack_inter_key + eax + pass_4 * 100h]

	mov	byte ptr [esi+ ((wx - 1) * 2)], al
	mov	byte ptr [esi+ ((wx - 1) * 2)+1], dl

	xor	dl, nr_round

	xor	al, byte ptr [esi+((wy - 1) * 2)]
	xor	dl, byte ptr [esi+((wy - 1) * 2)+1]
endm

h_xor	macro		pass_1, pass_2, pass_3, pass_4 , wx, wy, nr_round

	xor	dl, byte ptr [sjack_inter_key + eax + pass_1 * 100h]
	xor	al, byte ptr [sjack_inter_key + edx + pass_2 * 100h]
	xor	dl, byte ptr [sjack_inter_key + eax + pass_3 * 100h]
	xor	al, byte ptr [sjack_inter_key + edx + pass_4 * 100h]

	mov	byte ptr [esi+ ((wx - 1) * 2)], al
	mov	byte ptr [esi+ ((wx - 1) * 2)+1], dl

	xor	dl, nr_round

	xor	al, byte ptr [esi+((wy - 1) * 2)]
	xor	dl, byte ptr [esi+((wy - 1) * 2)+1]
endm

xor_h	macro		pass_1, pass_2, pass_3, pass_4 , wx, wy, nr_round

	mov	al, byte ptr [esi+((wy - 1) * 2)]
	mov	dl, byte ptr [esi+((wy - 1) * 2)+1]

	xor_h_core	pass_1, pass_2, pass_3, pass_4 , wx, wy, nr_round
endm

xor_g	macro		pass_1, pass_2, pass_3, pass_4 , wx, wy, nr_round

	mov	al, byte ptr [esi+((wy - 1) * 2)]
	mov	dl, byte ptr [esi+((wy - 1) * 2)+1]

	xor_g_core	pass_1, pass_2, pass_3, pass_4 , wx, wy, nr_round
endm

xor_h_core	macro	pass_1, pass_2, pass_3, pass_4 , wx, wy, nr_round

	xor	byte ptr [esi+((wx - 1) * 2)], al
	xor	byte ptr [esi+((wx - 1) * 2)+1], dl

	xor	byte ptr [esi+((wx - 1) * 2)+1], nr_round

	xor	dl, byte ptr [sjack_inter_key + eax + pass_1 * 100h]
	xor	al, byte ptr [sjack_inter_key + edx + pass_2 * 100h]
	xor	dl, byte ptr [sjack_inter_key + eax + pass_3 * 100h]
	xor	al, byte ptr [sjack_inter_key + edx + pass_4 * 100h]

	mov	byte ptr [esi+((wy - 1) * 2)], al
	mov	byte ptr [esi+((wy - 1) * 2)+1], dl
endm

xor_g_core	macro	pass_1, pass_2, pass_3, pass_4 , wx, wy, nr_round

	xor	byte ptr [esi+((wx - 1) * 2)], al
	xor	byte ptr [esi+((wx - 1) * 2)+1], dl

	xor	byte ptr [esi+((wx - 1) * 2)+1], nr_round

	xor	al, byte ptr [sjack_inter_key + edx + pass_1 * 100h]
	xor	dl, byte ptr [sjack_inter_key + eax + pass_2 * 100h]
	xor	al, byte ptr [sjack_inter_key + edx + pass_3 * 100h]
	xor	dl, byte ptr [sjack_inter_key + eax + pass_4 * 100h]

	mov	byte ptr [esi+((wy - 1) * 2)], al
	mov	byte ptr [esi+((wy - 1) * 2)+1], dl
endm

.data?
sjack_inter_key	db 10*256 dup (?)

.code
skipjack_setkey		proc	ptrPass :DWORD

	pushad
	xor	ecx, ecx	
	xor	edx, edx
	mov	esi, ptrPass
	mov	edi, offset sjack_inter_key
	mov	ebp, 10
@@main_key:
	mov	al, byte ptr [esi]
@@:
	mov	cl, al
	xor	cl, dl
	mov	bl, byte ptr [f_table+ecx]
	mov	byte ptr [edi+edx], bl
	inc	dl
	jnz	@B

	add	edi, 100h
	inc	esi
	dec	ebp
	jnz	@@main_key

	popad
	ret

f_table		db 0a3h,0d7h,009h,083h,0f8h,048h,0f6h,0f4h,0b3h,021h,015h,078h,099h,0b1h,0afh,0f9h
		db 0e7h,02dh,04dh,08ah,0ceh,04ch,0cah,02eh,052h,095h,0d9h,01eh,04eh,038h,044h,028h
		db 00ah,0dfh,002h,0a0h,017h,0f1h,060h,068h,012h,0b7h,07ah,0c3h,0e9h,0fah,03dh,053h
		db 096h,084h,06bh,0bah,0f2h,063h,09ah,019h,07ch,0aeh,0e5h,0f5h,0f7h,016h,06ah,0a2h
		db 039h,0b6h,07bh,00fh,0c1h,093h,081h,01bh,0eeh,0b4h,01ah,0eah,0d0h,091h,02fh,0b8h
		db 055h,0b9h,0dah,085h,03fh,041h,0bfh,0e0h,05ah,058h,080h,05fh,066h,00bh,0d8h,090h
		db 035h,0d5h,0c0h,0a7h,033h,006h,065h,069h,045h,000h,094h,056h,06dh,098h,09bh,076h
		db 097h,0fch,0b2h,0c2h,0b0h,0feh,0dbh,020h,0e1h,0ebh,0d6h,0e4h,0ddh,047h,04ah,01dh
		db 042h,0edh,09eh,06eh,049h,03ch,0cdh,043h,027h,0d2h,007h,0d4h,0deh,0c7h,067h,018h
		db 089h,0cbh,030h,01fh,08dh,0c6h,08fh,0aah,0c8h,074h,0dch,0c9h,05dh,05ch,031h,0a4h
		db 070h,088h,061h,02ch,09fh,00dh,02bh,087h,050h,082h,054h,064h,026h,07dh,003h,040h
		db 034h,04bh,01ch,073h,0d1h,0c4h,0fdh,03bh,0cch,0fbh,07fh,0abh,0e6h,03eh,05bh,0a5h
		db 0adh,004h,023h,09ch,014h,051h,022h,0f0h,029h,079h,071h,07eh,0ffh,08ch,00eh,0e2h
		db 00ch,0efh,0bch,072h,075h,06fh,037h,0a1h,0ech,0d3h,08eh,062h,08bh,086h,010h,0e8h
		db 008h,077h,011h,0beh,092h,04fh,024h,0c5h,032h,036h,09dh,0cfh,0f3h,0a6h,0bbh,0ach
		db 05eh,06ch,0a9h,013h,057h,025h,0b5h,0e3h,0bdh,0a8h,03ah,001h,005h,059h,02ah,046h
skipjack_setkey		endp

skipjack_clear		proc

	pushad	
	xor	eax, eax
	mov	ecx, 10*256/4
	mov	edi, offset sjack_inter_key
	cld
	rep	stosd
	popad
	ret

skipjack_clear		endp

skipjack_encrypt	proc	ptrOut :DWORD, ptrIn :DWORD
	pushad

	mov	edi, ptrIn
	mov	esi, ptrOut
	mov	eax, dword ptr [edi]
	mov	edx, dword ptr [edi+4]
	mov	dword ptr [esi], eax
	mov	dword ptr [esi+4], edx

	xor	eax, eax
	xor	edx, edx

	mov	al, byte ptr [esi]
	mov	dl, byte ptr [esi+1]

	g_xor	0,1,2,3, 1,4, 1
	g_xor	4,5,6,7, 4,3, 2
	g_xor	8,9,0,1, 3,2, 3
	g_xor	2,3,4,5, 2,1, 4
	g_xor	6,7,8,9, 1,4, 5
	g_xor	0,1,2,3, 4,3, 6
	g_xor	4,5,6,7, 3,2, 7
	g_xor	8,9,0,1, 2,1, 8

	mov	byte ptr [esi], al
	mov	byte ptr [esi+1], dl

	xor_g_core	2,3,4,5, 2,1, 9
	xor_g	6,7,8,9, 1,4, 10
	xor_g	0,1,2,3, 4,3, 11
	xor_g	4,5,6,7, 3,2, 12
	xor_g	8,9,0,1, 2,1, 13
	xor_g	2,3,4,5, 1,4, 14
	xor_g	6,7,8,9, 4,3, 15
	xor_g	0,1,2,3, 3,2, 16

	mov	al, byte ptr [esi]
	mov	dl, byte ptr [esi+1]

	g_xor	4,5,6,7, 1,4, 17
	g_xor	8,9,0,1, 4,3, 18
	g_xor	2,3,4,5, 3,2, 19
	g_xor	6,7,8,9, 2,1, 20
	g_xor	0,1,2,3, 1,4, 21
	g_xor	4,5,6,7, 4,3, 22
	g_xor	8,9,0,1, 3,2, 23
	g_xor	2,3,4,5, 2,1, 24

	mov	byte ptr [esi], al
	mov	byte ptr [esi+1], dl

	xor_g_core	6,7,8,9, 2,1, 25
	xor_g	0,1,2,3, 1,4, 26
	xor_g	4,5,6,7, 4,3, 27
	xor_g	8,9,0,1, 3,2, 28
	xor_g	2,3,4,5, 2,1, 29
	xor_g	6,7,8,9, 1,4, 30
	xor_g	0,1,2,3, 4,3, 31
	xor_g	4,5,6,7, 3,2, 32

	popad
	ret
skipjack_encrypt	endp

skipjack_decrypt	proc	ptrOut :DWORD, ptrIn :DWORD
	pushad

	mov	edi, ptrIn
	mov	esi, ptrOut
	mov	eax, dword ptr [edi]
	mov	edx, dword ptr [edi+4]
	mov	dword ptr [esi], eax
	mov	dword ptr [esi+4], edx

	xor	eax, eax
	xor	edx, edx

	mov	al, byte ptr [esi+2]
	mov	dl, byte ptr [esi+3]

	h_xor	7,6,5,4, 2,3, 32
	h_xor	3,2,1,0, 3,4, 31
	h_xor	9,8,7,6, 4,1, 30
	h_xor	5,4,3,2, 1,2, 29
	h_xor	1,0,9,8, 2,3, 28
	h_xor	7,6,5,4, 3,4, 27
	h_xor	3,2,1,0, 4,1, 26
	h_xor	9,8,7,6, 1,2, 25

	mov	byte ptr [esi+2], al
	mov	byte ptr [esi+3], dl

	xor_h_core	5,4,3,2, 1,2, 24
	xor_h	1,0,9,8, 2,3, 23
	xor_h	7,6,5,4, 3,4, 22
	xor_h	3,2,1,0, 4,1, 21
	xor_h	9,8,7,6, 1,2, 20
	xor_h	5,4,3,2, 2,3, 19
	xor_h	1,0,9,8, 3,4, 18
	xor_h	7,6,5,4, 4,1, 17

	mov	al, byte ptr [esi+2]
	mov	dl, byte ptr [esi+3]

	h_xor	3,2,1,0, 2,3, 16
	h_xor	9,8,7,6, 3,4, 15
	h_xor	5,4,3,2, 4,1, 14
	h_xor	1,0,9,8, 1,2, 13
	h_xor	7,6,5,4, 2,3, 12
	h_xor	3,2,1,0, 3,4, 11
	h_xor	9,8,7,6, 4,1, 10
	h_xor	5,4,3,2, 1,2, 9
	
	mov	byte ptr [esi+2], al
	mov	byte ptr [esi+3], dl

	xor_h_core	1,0,9,8, 1,2, 8
	xor_h	7,6,5,4, 2,3, 7
	xor_h	3,2,1,0, 3,4, 6
	xor_h	9,8,7,6, 4,1, 5
	xor_h	5,4,3,2, 1,2, 4
	xor_h	1,0,9,8, 2,3, 3
	xor_h	7,6,5,4, 3,4, 2
	xor_h	3,2,1,0, 4,1, 1

	popad
	ret
skipjack_decrypt	endp