comment ~

Algo	: SAFER-K128 & SAFER-SK128
Block	:  8 bytes
Rounds	: max. 13 (spec.)
Key	: 16 bytes

	push	offset Pass		;password ptr
	call	Safer_SetKey

	push	offset plain		;data to encrypt ptr
	push	offset encrypted_buf	;destination ptr
	call	Safer_Encrypt

	push	offset encrypted_buf	;data to decrypt ptr
	push	offset plain		;destination ptr
	call	Safer_Decrypt
	
	call	Safer_Clear		;clear internal data !

20.03.2002 WiteG//xtreeme (witeg@poczta.fm, www.witeg.prv.pl)
~

varSAFER_KEYLENGTH	equ	128

; ----------------------------------------------------------------------------
; You should set number of rounds (varSAFER_ROUNDS) and algorithm (varSAFER_SK)
; ----------------------------------------------------------------------------

varSAFER_ROUNDS		equ	10
varSAFER_SK		equ	1	;if varSAFER_SK = 0 then SAFER-K128
					;if varSAFER_SK = 1 then SAFER-SK128

.code
expTable	db	  1,  45, 226, 147, 190,  69,  21, 174, 120,   3, 135, 164, 184,  56, 207,  63
		db	  8, 103,   9, 148, 235,  38, 168, 107, 189,  24,  52,  27, 187, 191, 114, 247
		db	 64,  53,  72, 156,  81,  47,  59,  85, 227, 192, 159, 216, 211, 243, 141, 177
		db	255, 167,  62, 220, 134, 119, 215, 166,  17, 251, 244, 186, 146, 145, 100, 131
		db	241,  51, 239, 218,  44, 181, 178,  43, 136, 209, 153, 203, 140, 132,  29,  20
		db	129, 151, 113, 202,  95, 163, 139,  87,  60, 130, 196,  82,  92,  28, 232, 160
		db	  4, 180, 133,  74, 246,  19,  84, 182, 223,  12,  26, 142, 222, 224,  57, 252
		db	 32, 155,  36,  78, 169, 152, 158, 171, 242,  96, 208, 108, 234, 250, 199, 217
		db	  0, 212,  31, 110,  67, 188, 236,  83, 137, 254, 122,  93,  73, 201,  50, 194
		db	249, 154, 248, 109,  22, 219,  89, 150,  68, 233, 205, 230,  70,  66, 143,  10
		db	193, 204, 185, 101, 176, 210, 198, 172,  30,  65,  98,  41,  46,  14, 116,  80
		db	  2,  90, 195,  37, 123, 138,  42,  91, 240,   6,  13,  71, 111, 112, 157, 126
		db	 16, 206,  18,  39, 213,  76,  79, 214, 121,  48, 104,  54, 117, 125, 228, 237
		db	128, 106, 144,  55, 162,  94, 118, 170, 197, 127,  61, 175, 165, 229,  25,  97
		db	253,  77, 124, 183,  11, 238, 173,  75,  34, 245, 231, 115,  35,  33, 200,   5
		db	225, 102, 221, 179,  88, 105,  99,  86,  15, 161,  49, 149,  23,   7,  58,  40

logTable	db	128,   0, 176,   9,  96, 239, 185, 253,  16,  18, 159, 228, 105, 186, 173, 248
		db	192,  56, 194, 101,  79,   6, 148, 252,  25, 222, 106,  27,  93,  78, 168, 130
		db	112, 237, 232, 236, 114, 179,  21, 195, 255, 171, 182,  71,  68,   1, 172,  37
		db	201, 250, 142,  65,  26,  33, 203, 211,  13, 110, 254,  38,  88, 218,  50,  15
		db	 32, 169, 157, 132, 152,   5, 156, 187,  34, 140,  99, 231, 197, 225, 115, 198
		db	175,  36,  91, 135, 102,  39, 247,  87, 244, 150, 177, 183,  92, 139, 213,  84
		db	121, 223, 170, 246,  62, 163, 241,  17, 202, 245, 209,  23, 123, 147, 131, 188
		db	189,  82,  30, 235, 174, 204, 214,  53,   8, 200, 138, 180, 226, 205, 191, 217
		db	208,  80,  89,  63,  77,  98,  52,  10,  72, 136, 181,  86,  76,  46, 107, 158
		db	210,  61,  60,   3,  19, 251, 151,  81, 117,  74, 145, 113,  35, 190, 118,  42
		db	 95, 249, 212,  85,  11, 220,  55,  49,  22, 116, 215, 119, 167, 230,   7, 219
		db	164,  47,  70, 243,  97,  69, 103, 227,  12, 162,  59,  28, 133,  24,   4,  29
		db	 41, 160, 143, 178,  90, 216, 166, 126, 238, 141,  83,  75, 161, 154, 193,  14
		db	122,  73, 165,  44, 129, 196, 199,  54,  43, 127,  67, 149,  51, 242, 108, 104
		db	109, 240,   2,  40, 206, 221, 155, 234,  94, 153, 124,  20, 134, 207, 229,  66
		db	184,  64, 120,  45,  58, 233, 100,  31, 146, 144, 125,  57, 111, 224, 137,  48

Safer_SetKey	proc	szPass :DWORD

IFE	(varSAFER_KEYLENGTH - 128)
	IFE	(varSAFER_SK - 1)

		pushad

		mov	ebp, szPass
		mov	edi, offset temp_buffer
		mov	esi, offset SaferPass

		mov	eax, dword ptr [ebp +  0]
		mov	ebx, dword ptr [ebp +  4]
		mov	ecx, dword ptr [ebp +  8]
		mov	edx, dword ptr [ebp + 12]

		mov	dword ptr [edi +  0], eax
		mov	dword ptr [edi +  4], ebx
		mov	dword ptr [edi +  9], ecx
		mov	dword ptr [edi + 13], edx

		mov	dword ptr [esi], ecx
		mov	dword ptr [esi+4], edx

		xor	eax, ebx
		xor	ecx, edx
		xor	al, ah
		xor	cl, ch
		mov	bl, al
		mov	bh, cl
		shr	eax, 16
		shr	ecx, 16
		xor	al, ah
		xor	cl, ch
		xor	bl, al		;crc1
		xor	bh, cl		;crc2

		mov	byte ptr [edi +  8], bl
		mov	byte ptr [edi + 17], bh

		add	esi, 8
		mov	ecx, 8
	@@:
		rol	byte ptr [edi+ecx], 5
		dec	ecx
		jns	@B

		mov	ebp, 1				;licznik rund
		xor	ebx, ebx			;maly licznik

	@@key_loop:
		mov	ecx, 17
	@@:
		rol	byte ptr [edi+ecx], 6
		dec	ecx
		jns	@B

	@@:
		lea	eax, [2*ebp+ebx-1]
		cdq
		lea	ecx, [8*ebp+ebp]
		div	dword ptr [_const_9]
		lea	ecx, [2*ecx+ebx]
		mov	dl, byte ptr [edi+edx]
		mov	al, byte ptr [expTable+1+ecx]
		add	dl, byte ptr [expTable+eax]
		mov	byte ptr [esi], dl
		inc	ebx
		inc	esi
		and	ebx, 7
		jnz	@B

	@@:
		lea	eax, [2*ebp+ebx]
		cdq
		lea	ecx, [8*ebp+ebp]
		div	dword ptr [_const_9]
		lea	ecx, [2*ecx+ebx]
		mov	dl, byte ptr [edi+edx+9]
		mov	al, byte ptr [expTable+10+ecx]
		add	dl, byte ptr [expTable+eax]
		mov	byte ptr [esi], dl
		inc	ebx
		inc	esi
		and	ebx, 7
		jnz	@B

		inc	ebp
		cmp	ebp, varSAFER_ROUNDS
		jle	@@key_loop

		mov	dword ptr [edi +  0], ebx
		mov	dword ptr [edi +  4], ebx
		mov	dword ptr [edi +  8], ebx
		mov	dword ptr [edi + 12], ebx
		mov	word ptr [edi + 16], bx
		popad
		ret

_const_9	dd	9
	ENDIF

	IFE	(varSAFER_SK)

		pushad

		mov	ebp, szPass
		mov	edi, offset temp_buffer
		mov	esi, offset SaferPass

		mov	eax, dword ptr [ebp +  0]
		mov	ebx, dword ptr [ebp +  4]
		mov	ecx, dword ptr [ebp +  8]
		mov	edx, dword ptr [ebp + 12]

		mov	dword ptr [edi +  0], eax
		mov	dword ptr [edi +  4], ebx
		mov	dword ptr [edi +  8], ecx
		mov	dword ptr [edi + 12], edx

		mov	dword ptr [esi], ecx
		mov	dword ptr [esi+4], edx

		mov	ecx, 7
		add	esi, 8
	@@:
		rol	byte ptr [edi+ecx], 5
		dec	ecx
		jns	@B

		mov	ebp, 1				;licznik rund
		xor	ebx, ebx			;maly licznik

	@@key_loop:
		mov	ecx, 15
	@@:
		rol	byte ptr [edi+ecx], 6
		dec	ecx
		jns	@B

		lea	ecx, [8*ebp+ebp]
		xor	eax, eax
		shl	ecx, 1
	@@:
		mov	dl, byte ptr [edi+ebx]
		mov	dh, byte ptr [edi+ebx+8]

		mov	al, byte ptr [expTable+1+ecx]	
		add	dl, byte ptr [expTable+eax]
		mov	byte ptr [esi], dl

		mov	al, byte ptr [expTable+10+ecx]
		add	dh, byte ptr [expTable+eax]
		mov	byte ptr [esi+8], dh

		inc	ecx
		inc	ebx
		inc	esi
		and	ebx, 7
		jnz	@B

		inc	ebp
		add	esi, 8
		cmp	ebp, varSAFER_ROUNDS
		jle	@@key_loop

		mov	dword ptr [edi +  0], ebx
		mov	dword ptr [edi +  4], ebx
		mov	dword ptr [edi +  8], ebx
		mov	dword ptr [edi + 12], ebx

		popad
		ret
	ENDIF
ENDIF		;(varSAFER_KEYLENGTH - 128)
Safer_SetKey	endp

Safer_Encrypt	proc	ptrOut :DWORD, ptrIn :DWORD

	pushad
	
	mov	esi, ptrIn
	mov	edi, offset SaferPass

	mov	ebx, dword ptr [esi+ 0]
	mov	edx, dword ptr [esi+ 4]

	mov	esi, varSAFER_ROUNDS
@@:
	movzx	eax, bl
	xor	al, byte ptr [edi]
	mov	bl, byte ptr [expTable + eax]
	add	bl, byte ptr [edi+8]
		
	mov	al, bh
	add	al, byte ptr [edi+1]
	mov	bh, byte ptr [logTable + eax]
	xor	bh, byte ptr [edi+9]

	rol	ebx, 16

	mov	al, bl
	add	al, byte ptr [edi+2]
	mov	bl, byte ptr [logTable + eax]
	xor	bl, byte ptr [edi+10]

	mov	al, bh
	xor	al, byte ptr [edi+3]
	mov	bh, byte ptr [expTable + eax]
	add	bh, byte ptr [edi+11]

	mov	al, dl
	xor	al, byte ptr [edi+4]
	mov	dl, byte ptr [expTable + eax]
	add	dl, byte ptr [edi+12]

	mov	al, dh
	add	al, byte ptr [edi+5]
	mov	dh, byte ptr [logTable + eax]
	xor	dh, byte ptr [edi+13]

	rol	edx, 16

	mov	al, dl
	add	al, byte ptr [edi+6]
	mov	dl, byte ptr [logTable + eax]
	xor	dl, byte ptr [edi+14]

	mov	al, dh
	xor	al, byte ptr [edi+7]
	mov	dh, byte ptr [expTable + eax]
	add	dh, byte ptr [edi+15]

	mov	cx, bx		;cl = c, ch = d
	mov	ax, dx		;al = g, ah = h
	
	shr	ebx, 16		;bl = a, bh = b
	shr	edx, 16		;dl = e, dh = f

	add	bh, bl
	add	ch, cl
	add	bl, bh
	add	cl, ch
	add	dh, dl
	add	ah, al
	add	dl, dh
	add	al, ah
	add	cl, bl
	add	al, dl
	add	bl, cl
	add	dl, al
	add	ch, bh
	add	ah, dh
	add	bh, ch
	add	dh, ah
	add	dl, bl
	add	dh, bh
	add	bl, dl
	add	bh, dh
	add	al, cl
	add	ah, ch
	add	cl, al
	add	ch, ah
	xchg	bh, cl
	xchg	ch, al
	xchg	bh, dl
	xchg	ch, dh

	shl	eax, 16
	shl	ecx, 16

	or	edx, eax
	or	ebx, ecx

	add	edi, 16
	dec	esi
	jnz	@B

	shr	ecx, 16
	shr	eax, 16

	mov	esi, ptrOut

	xor	bl, byte ptr [edi]
	add	bh, byte ptr [edi+1]
	add	cl, byte ptr [edi+2]
	xor	ch, byte ptr [edi+3]
	xor	dl, byte ptr [edi+4]
	add	dh, byte ptr [edi+5]
	add	al, byte ptr [edi+6]
	xor	ah, byte ptr [edi+7]

	mov	word ptr [esi+0], bx
	mov	word ptr [esi+2], cx
	mov	word ptr [esi+4], dx
	mov	word ptr [esi+6], ax

	popad
	ret

Safer_Encrypt	endp

Safer_Decrypt	proc	ptrOut :DWORD, ptrIn :DWORD

	pushad

	mov	esi, ptrIn
	mov	edi, offset SaferPass + (8 * 2 * varSAFER_ROUNDS)

	mov	bx, word ptr [esi+0]
	mov	cx, word ptr [esi+2]
	mov	dx, word ptr [esi+4]
	mov	ax, word ptr [esi+6]

	xor	bl, byte ptr [edi]
	sub	bh, byte ptr [edi+1]
	sub	cl, byte ptr [edi+2]
	xor	ch, byte ptr [edi+3]
	xor	dl, byte ptr [edi+4]
	sub	dh, byte ptr [edi+5]
	sub	al, byte ptr [edi+6]
	xor	ah, byte ptr [edi+7]

	mov	esi, varSAFER_ROUNDS
	push	ebp
@@:

	xchg	ch, dh
	xchg	bh, dl
	xchg	ch, al
	xchg	bh, cl

	sub	ch, ah
	sub	cl, al
	sub	ah, ch
	sub	al, cl
	sub	bh, dh
	sub	bl, dl
	sub	dh, bh
	sub	dl, bl
	sub	dh, ah
	sub	bh, ch
	sub	ah, dh
	sub	ch, bh
	sub	dl, al
	sub	bl, cl
	sub	al, dl
	sub	cl, bl
	sub	al, ah
	sub	dl, dh
	sub	ah, al
	sub	dh, dl
	sub	cl, ch
	sub	bl, bh
	sub	ch, cl
	sub	bh, bl

;bl = a, bh = b, cl = c, ch = d, dl = e, dh = f, al = g, ah = h

	sub	ah, byte ptr [edi - 1]
	xor	al, byte ptr [edi - 2]
	xor	dh, byte ptr [edi - 3]
	sub	dl, byte ptr [edi - 4]
	sub	ch, byte ptr [edi - 5]
	xor	cl, byte ptr [edi - 6]
	xor	bh, byte ptr [edi - 7]
	sub	bl, byte ptr [edi - 8]

	movzx	ebp, ah
	mov	ah, byte ptr [logTable + ebp]
	movzx	ebp, al
	mov	al, byte ptr [expTable + ebp]
	movzx	ebp, dh
	mov	dh, byte ptr [expTable + ebp]
	movzx	ebp, dl
	mov	dl, byte ptr [logTable + ebp]
	movzx	ebp, ch
	mov	ch, byte ptr [logTable + ebp]
	movzx	ebp, cl
	mov	cl, byte ptr [expTable + ebp]
	movzx	ebp, bh
	mov	bh, byte ptr [expTable + ebp]
	movzx	ebp, bl
	mov	bl, byte ptr [logTable + ebp]

	xor	ah, byte ptr [edi -  9]
	sub	al, byte ptr [edi - 10]
	sub	dh, byte ptr [edi - 11]
	xor	dl, byte ptr [edi - 12]
	xor	ch, byte ptr [edi - 13]
	sub	cl, byte ptr [edi - 14]
	sub	bh, byte ptr [edi - 15]
	xor	bl, byte ptr [edi - 16]

	sub	edi, 16
	dec	esi
	jnz	@B

	pop	ebp
	mov	esi, ptrOut

	mov	word ptr [esi+0], bx
	mov	word ptr [esi+2], cx
	mov	word ptr [esi+4], dx
	mov	word ptr [esi+6], ax

	popad
	ret
Safer_Decrypt	endp

Safer_Clear	proc
	push	eax
	push	ecx
	push	edi

	mov	ecx, ((varSAFER_ROUNDS * 16) + 8)/4
	xor	eax, eax
	mov	edi, offset SaferPass
	cld
	rep	stosd

	pop	edi
	pop	ecx
	pop	eax
	ret
Safer_Clear	endp

.data?
temp_buffer	db (varSAFER_KEYLENGTH / 8) + (2 * varSAFER_SK)	dup (?)
SaferPass	db (varSAFER_ROUNDS * 16) + 8			dup (?)	