comment %

Algo	: RUBY Mark 5 by Michael Paul Johnson
Block	: 8 bytes
Rounds	: as you wish (default 8)
Key	: 8 bytes (64 b)


	push	offset password
	push	offset data
	call	Ruby_Crypt


There is no Ruby_Decrypt function ! The recommended way to use
the Ruby Block Cipher is cipher block chaining (CBC) mode.


Recomendation for using rounds number (STRENGTH param) from oryginal C source):

4   Minimum       -  speed is of the essence, security secondary.
8   Desk lock     -  reasonable compromise of speed vs security?
16  Dead bolt     -  probably good enough for most things.
20  Portable safe -  security is more important than speed.
32  Anchored safe -  speed isn't much of a concern.
40  Bank vault    -  your pentium has nothing better to do, anyway.
64  Fort Knox     -  If you are willing to wait this long, it would probably
                     make sense to double the block size, too.


02.05.2002 WiteG//xtreeme (witeg@poczta.fm, www.witeg.prv.pl)

%

STRENGTH	equ	8

	f1	macro	A, B, C, D
		mov	ecx, D
		mov	edi, A
		rol	edi, cl
		mov	esp, B
		mov	ecx, C
		shr	ecx, 27
		rol	esp, cl
		add	edi, esp
		mov	esp, D
		mov	ecx, A
		shr	ecx, 27
		rol	esp, cl
		mov	ecx, B
		mov	esi, C
		rol	esi, cl
		add	esi, esp
		xor	edi, esi
		mov	A, edi
	endm

	f2	macro	A, B, C, D
		mov	ecx, C
		mov	edi, A
		rol	edi, cl
		mov	esp, B
		mov	ecx, D
		shr	ecx, 27
		rol	esp, cl
		xor	edi, esp
		mov	ecx, A
		mov	esp, C
		rol	esp, cl
		add	edi, esp
		mov	esp, D
		mov	ecx, B
		shr	ecx, 27
		rol	esp, cl
		add	edi, esp
		mov	A, edi
	endm

FAMILY_KEY_1	equ	0456C6091h
FAMILY_KEY_2	equ	0AA7110C3h

.data?
_esp		dd	?
_rounds		dd	?

.code
Ruby_Crypt	proc	ptrData:DWORD, ptrPass:DWORD
	pushad

	mov	esi, ptrData
	mov	edi, ptrPass

	mov	dword ptr [_esp], esp

	mov	eax, dword ptr [esi]	;x[0]
	mov	ebx, dword ptr [esi+4]	;x[1]
	mov	edx, dword ptr [edi]	;x[2]
	mov	ebp, dword ptr [edi+4]	;x[3]
	mov	dword ptr [_rounds], STRENGTH

@@:
	f1	eax, ebx, edx, ebp

	add	eax, FAMILY_KEY_1

	xchg	eax, ebx
	xchg	ebx, edx
	xchg	edx, ebp

	f2	eax, ebx, edx, ebp

	imul	eax, FAMILY_KEY_2

	xchg	eax, ebx
	xchg	ebx, edx
	xchg	edx, ebp
	
	dec	dword ptr [_rounds]
	jnz	@B

	mov	ecx, ebp
	mov	esp, eax
	rol	esp, cl

	mov	ecx, edx
	shr	ecx, 27
	mov	esi, ebx
	rol	esi, cl
	
	add	esp, esi
    
	mov	ecx, eax
	shr	ecx, 27
	rol	edx, cl
	
	mov	ecx, ebx
	rol	ebp, cl
	xor	edx, ebp		;C1
	mov	eax, esp		;C0

	mov	esp, dword ptr [_esp]
	mov	ebp, dword ptr [esp+8]
	mov	esi, ptrData
	and	dword ptr [_esp], 0
	mov	dword ptr [esi], eax
	mov	dword ptr [esi+4], edx

	popad
	ret
Ruby_Crypt	endp