comment *

Algo	: RC5-32/12/16 (w/r/b)
Block	:  8 bytes
Key	: 16 bytes (128 b)


	push	offset password		;16 bytes readed as key
	call	rc5_setkey

	push	offset Data		; 8 bytes encrypted
	call	rc5_encrypt
	
	push	offset Data		; 8 bytes decrypted
	call	rc5_decrypt
	
	call	rc5_clear		;clear internal key buffer


07.02.2002 WiteG//xtreeme (witeg@poczta.fm, www.witeg.prv.pl)
*

.386
.model flat ,stdcall

P equ 0b7e15163h
Q equ 09e3779b9h

.code
rc5_setkey	proc	ptrPass :DWORD

	pushad

	mov	esi, offset rc5_padded_key
	mov	edi, ptrPass
	mov	ecx, 16
@@:
	mov	eax, dword ptr [edi+ecx-4]
	mov	dword ptr [esi+ecx-4], eax
	sub	ecx, 4
	jnz	@B

	mov	esi, offset rc5_s_table - 4
	mov	eax, P-Q
	mov	ecx, 26
@@:
	add	esi, 4
	add	eax, Q
	dec	ecx
	mov	dword ptr [esi], eax
	jnz	@B

	mov	edx, 78			;k

	push	ebp

	xor	eax, eax		;A
	xor	ebp, ebp		;B
	xor	edi, edi		;i
	xor	esi, esi		;j

@main_loop:
	add	eax, ebp
	
	cmp	edi, 26
	jb	@F

	xor	edi, edi
@@:
	mov	ecx, ebp
	add	eax, dword ptr [rc5_s_table+4*edi]
	
	cmp	esi, 4
	jb	@F

	xor	esi, esi	
@@:
	rol	eax, 3
	mov	ebp, dword ptr [rc5_padded_key+4*esi]
	add	ecx, eax
	inc	esi
	add	ebp, ecx
	inc	edi
	and	ecx, 31
	mov	dword ptr [rc5_s_table+4*edi-4], eax
	rol	ebp, cl
	dec	edx
	mov	dword ptr [rc5_padded_key+4*esi-4], ebp
	jnz	@main_loop

	pop	ebp

	mov	edi, offset rc5_padded_key
	mov	ecx, 16
@@:
	mov	dword ptr [edi+ecx-4], edx
	sub	ecx, 4
	jnz	@B
	
	popad
	ret
rc5_setkey	endp

rc5_encrypt	proc	ptrData :DWORD
	pushad

	mov	esi, ptrData
	mov	edi, offset rc5_s_table
	mov	eax, dword ptr [esi]
	mov	ebx, dword ptr [esi+4]
	add	eax, dword ptr [edi]
	add	ebx, dword ptr [edi+4]
	add	edi, 8

	mov	edx, 12
@mainloop:
	xor	eax, ebx
	mov	ecx, ebx
	and	ecx, 31
	rol	eax, cl
	add	eax, dword ptr [edi]
	add	edi, 4

	xor	ebx, eax
	mov	ecx, eax
	and	ecx, 31
	rol	ebx, cl
	add	ebx, dword ptr [edi]
	add	edi, 4

	dec	edx
	jnz	@mainloop

	mov	dword ptr [esi], eax
	mov	dword ptr [esi+4], ebx

	popad
	ret
rc5_encrypt	endp

rc5_decrypt	proc	ptrData :DWORD

	pushad

	mov	esi, ptrData
	mov	eax, dword ptr [esi]
	mov	ebx, dword ptr [esi+4]

	mov	edi, offset rc5_s_table+ 4*26
	mov	edx, 12
@mainloop:
	sub	edi, 4
	mov	ecx, eax
	sub	ebx, dword ptr [edi]
	and	ecx, 31
	ror	ebx, cl
	xor	ebx, eax

	sub	edi, 4
	mov	ecx, ebx
	sub	eax, dword ptr [edi]
	and	ecx, 31
	ror	eax, cl
	xor	eax, ebx

	dec	edx
	jnz	@mainloop

	sub	eax, dword ptr [rc5_s_table]
	sub	ebx, dword ptr [rc5_s_table+4]

	mov	dword ptr [esi], eax
	mov	dword ptr [esi+4], ebx

	popad
	ret
rc5_decrypt	endp

rc5_clear	proc
	pushad

	xor	eax, eax
	mov	ecx, 26
	mov	edi, offset rc5_s_table
	cld
	rep	stosd

	popad
	ret
rc5_clear	endp

.data?
rc5_padded_key	dd 4 dup (?)
rc5_s_table	dd 26 dup (?)
end start