comment *

RC2 Block Cipher (by Ron Rivest)

Key length: 1 - 128 bytes
Block size: 8 bytes

	push	lPass			;password length in bytes <1,128>
	push	offset Pass		;password ptr
	call	RC2_SetKey
	jc	_error			;C flag set if lPass = 0

	push	offset plain
	push	offset cipher
	call	RC2_Encrypt

	push	offset cipher
	push	offset out
	call	RC2_Decrypt
	
	call	RC2_Clear		;destroy internal key table


01.02.2002 WiteG//xtreeme (witeg@poczta.fm, www.witeg.prv.pl)
*

RC2encrypt	macro	x0, x1, x2, x3, round
	f_rc2	x0, x1, x2, x3, round, 0, 1
	f_rc2	x1, x2, x3, x0, round, 1, 2
	f_rc2	x2, x3, x0, x1, round, 2, 3
	f_rc2	x3, x0, x1, x2, round, 3, 5
endm
	
f_rc2	macro	arg_0, arg_1, arg_2, arg_3, round, pass_ptr, param_rol

	mov	si, arg_3
	mov	bp, arg_2
	not	si
	and	bp, arg_3
	and	si, arg_1
	add	arg_0, bp
	add	si, word ptr [_rc2key + 2*(4*round + pass_ptr)]
	add	arg_0, si
	rol	arg_0, param_rol
endm

RC2encsbox	macro	x0, x1, x2, x3
	mov	si, x3
	and	si, 63
	add	x0, word ptr [_rc2key + 2*esi]
	mov	bp, x0
	and	bp, 63
	add	x1, word ptr [_rc2key + 2*ebp]
	mov	si, x1
	and	si, 63
	add	x2, word ptr [_rc2key + 2*esi]
	mov	bp, x2
	and	bp, 63
	add	x3, word ptr [_rc2key + 2*ebp]
endm



RC2decrypt	macro	x0, x1, x2, x3, round
	g_rc2	x3, x0, x1, x2, round, 3, 5
	g_rc2	x2, x3, x0, x1, round, 2, 3
	g_rc2	x1, x2, x3, x0, round, 1, 2
	g_rc2	x0, x1, x2, x3, round, 0, 1
endm

g_rc2	macro	arg_0, arg_1, arg_2, arg_3, round, pass_ptr, param_rol

	ror	arg_0, param_rol
	mov	si, arg_3
	mov	bp, arg_2
	not	si
	and	bp, arg_3
	and	si, arg_1
	sub	arg_0, bp
	add	si, word ptr [_rc2key + 2*(4*round + pass_ptr)]
	sub	arg_0, si

endm

RC2decsbox	macro	x0, x1, x2, x3

	mov	bp, x2
	and	bp, 63
	sub	x3, word ptr [_rc2key + 2*ebp]
	mov	si, x1
	and	si, 63
	sub	x2, word ptr [_rc2key + 2*esi]
	mov	bp, x0
	and	bp, 63
	sub	x1, word ptr [_rc2key + 2*ebp]
	mov	si, x3
	and	si, 63
	sub	x0, word ptr [_rc2key + 2*esi]

endm

.data?
_rc2key		db 128 dup (?)

.code
RC2_SetKey	proc	ptrKey:DWORD, lKey:DWORD

	pushad
	mov	ecx, lKey
	mov	esi, ptrKey
	test	ecx, ecx
	jz	@@zeropass
	mov	edi, offset _rc2key
	cmp	ecx, 128
	jbe	@F
	
	mov	ecx, 128
@@:
	mov	edx, ecx
	cld
	rep	movsb

; edx == dlugosc hasla
	cmp	edx, 128
	jz	@@done

	xor	eax, eax
	xor	ebx, ebx
	neg	edx

	mov	al, byte ptr [edi-1]

@@key_loop:
	add	al, byte ptr [edi+edx]
	mov	al, byte ptr [sbox + eax]
	mov	byte ptr [edi], al

	inc	edi	
	cmp	edi, offset _rc2key+128
	jnz	@@key_loop
	
@@done:
	mov	al, byte ptr [_rc2key]
	mov	al, byte ptr [sbox + eax]
	mov	byte ptr [_rc2key], al
	clc
@@:
	popad
	ret

@@zeropass:
	stc
	jmp	@B

sbox	db	217,120,249,196, 25,221,181,237, 40,233,253,121, 74,160,216,157
	db	198,126, 55,131, 43,118, 83,142, 98, 76,100,136, 68,139,251,162
	db	 23,154, 89,245,135,179, 79, 19, 97, 69,109,141,  9,129,125, 50
	db	189,143, 64,235,134,183,123, 11,240,149, 33, 34, 92,107, 78,130
	db	 84,214,101,147,206, 96,178, 28,115, 86,192, 20,167,140,241,220
	db	 18,117,202, 31, 59,190,228,209, 66, 61,212, 48,163, 60,182, 38
	db	111,191, 14,218, 70,105,  7, 87, 39,242, 29,155,188,148, 67,  3
	db	248, 17,199,246,144,239, 62,231,  6,195,213, 47,200,102, 30,215
	db	  8,232,234,222,128, 82,238,247,132,170,114,172, 53, 77,106, 42
	db	150, 26,210,113, 90, 21, 73,116, 75,159,208, 94,  4, 24,164,236
	db	194,224, 65,110, 15, 81,203,204, 36,145,175, 80,161,244,112, 57
	db	153,124, 58,133, 35,184,180,122,252,  2, 54, 91, 37, 85,151, 49
	db	 45, 93,250,152,227,138,146,174,  5,223, 41, 16,103,108,186,201
	db	211,  0,230,207,225,158,168, 44, 99, 22,  1, 63, 88,226,137,169
	db	 13, 56, 52, 27,171, 51,255,176,187, 72, 12, 95,185,177,205, 46
	db	197,243,219, 71,229,165,156,119, 10,166, 32,104,254,127,193,173
RC2_SetKey	endp

RC2_Encrypt	proc	ptrOut :DWORD , ptrIn :DWORD

	pushad
	push	ebp

	mov	edi, ptrIn
	xor	esi, esi
	xor	ebp, ebp

	mov	ax, word ptr [edi]	;1
	mov	bx, word ptr [edi+2]	;2
	mov	cx, word ptr [edi+4]	;3
	mov	dx, word ptr [edi+6]	;4

	RC2encrypt	ax, bx, cx, dx, 0
	RC2encrypt	ax, bx, cx, dx, 1
	RC2encrypt	ax, bx, cx, dx, 2
	RC2encrypt	ax, bx, cx, dx, 3
	RC2encrypt	ax, bx, cx, dx, 4
	RC2encsbox	ax, bx, cx, dx
	RC2encrypt	ax, bx, cx, dx, 5
	RC2encrypt	ax, bx, cx, dx, 6
	RC2encrypt	ax, bx, cx, dx, 7
	RC2encrypt	ax, bx, cx, dx, 8
	RC2encrypt	ax, bx, cx, dx, 9
	RC2encrypt	ax, bx, cx, dx, 10
	RC2encsbox	ax, bx, cx, dx
	RC2encrypt	ax, bx, cx, dx, 11
	RC2encrypt	ax, bx, cx, dx, 12
	RC2encrypt	ax, bx, cx, dx, 13
	RC2encrypt	ax, bx, cx, dx, 14
	RC2encrypt	ax, bx, cx, dx, 15

	pop	ebp
	mov	edi, ptrOut
	mov	word ptr [edi+0],ax	;1
	mov	word ptr [edi+2],bx	;2
	mov	word ptr [edi+4],cx	;3
	mov	word ptr [edi+6],dx	;4
	popad
	ret
RC2_Encrypt	endp

RC2_Decrypt	proc	ptrOut :DWORD , ptrIn :DWORD

	pushad
	push	ebp

	mov	edi, ptrIn
	xor	esi, esi
	xor	ebp, ebp

	mov	ax, word ptr [edi]	;1
	mov	bx, word ptr [edi+2]	;2
	mov	cx, word ptr [edi+4]	;3
	mov	dx, word ptr [edi+6]	;4

	RC2decrypt	ax, bx, cx, dx, 15
	RC2decrypt	ax, bx, cx, dx, 14
	RC2decrypt	ax, bx, cx, dx, 13
	RC2decrypt	ax, bx, cx, dx, 12
	RC2decrypt	ax, bx, cx, dx, 11
	RC2decsbox	ax, bx, cx, dx
	RC2decrypt	ax, bx, cx, dx, 10
	RC2decrypt	ax, bx, cx, dx,  9
	RC2decrypt	ax, bx, cx, dx,  8
	RC2decrypt	ax, bx, cx, dx,  7
	RC2decrypt	ax, bx, cx, dx,  6
	RC2decrypt	ax, bx, cx, dx,  5
	RC2decsbox	ax, bx, cx, dx
	RC2decrypt	ax, bx, cx, dx,  4
	RC2decrypt	ax, bx, cx, dx,  3
	RC2decrypt	ax, bx, cx, dx,  2
	RC2decrypt	ax, bx, cx, dx,  1
	RC2decrypt	ax, bx, cx, dx,  0

	pop	ebp
	mov	edi, ptrOut
	mov	word ptr [edi+0],ax	;1
	mov	word ptr [edi+2],bx	;2
	mov	word ptr [edi+4],cx	;3
	mov	word ptr [edi+6],dx	;4
	popad
	ret
RC2_Decrypt	endp

RC2_Clear	proc
	pushad

	mov	edi, offset _rc2key
	mov	ecx, 128/4
	xor	eax, eax
	cld
	rep	stosd
	popad
	ret
RC2_Clear	endp