comment %

Algo	: NUSH (by LAN Crypto, Int.)
Block	: 16 bytes
Key	: 128 bits


 An assembler implementation of the NUSH algorithm. It processes two
 independent 128bit data blocks at a time using two independent keys !


	push	offset key_A		;ptr to 16 bytes key for block A
	call	NUSH_SetKey_A

	push	offset key_B		;ptr to 16 bytes key for block B
	call	NUSH_SetKey_B

	push	offset buffer_IN_A	;ptr to 16 bytes block (A) to encrypt
	push	offset buffer_IN_B	;ptr to 16 bytes block (B) to encrypt
	push	offset buffer_OUT_A	;ptr to 16 bytes block (A) for encrypted data
	push	offset buffer_OUT_B	;ptr to 16 bytes block (B) for encrypted data
	call	NUSH_Encrypt

	push	offset buffer_IN_A	;ptr to 16 bytes block (A) to decrypt
	push	offset buffer_IN_B	;ptr to 16 bytes block (B) to decrypt
	push	offset buffer_OUT_A	;ptr to 16 bytes block (A) for decrypted data
	push	offset buffer_OUT_B	;ptr to 16 bytes block (B) for decrypted data
	call	NUSH_Decrypt

	call	NUSH_Clear



NESSIE security report v1.0 :
" Nush has no security margin [313] and its performance is no better than
  MISTY1 or Khazad. Therefore it was not selected for Phase II of NESSIE."


14.06.2002 WiteG/xt+uCF (witeg@poczta.fm, www.witeg.prv.pl)
%


E_AND_ROUND	MACRO	ARG_a,ARG_b,ARG_c,ARG_d,i,s
	pxor	ARG_c, qword ptr [edi+32+8*i]
	paddd	ARG_c, ARG_b
	movq	mm4, ARG_d
	movq	mm5, ARG_c
	psrld	ARG_c, s
	pslld	mm5, 32-s
	pxor	ARG_c, mm5
	pand	mm4, ARG_c
	paddd	ARG_a, mm4
ENDM

E_OR__ROUND	MACRO	ARG_a,ARG_b,ARG_c,ARG_d,i,s
	pxor	ARG_c, qword ptr [edi+32+8*i]
	paddd	ARG_c, ARG_b
	movq	mm4, ARG_d
	movq	mm5, ARG_c
	psrld	ARG_c, s
	pslld	mm5, 32-s
	pxor	ARG_c, mm5
	por	mm4, ARG_c
	paddd	ARG_a, mm4
ENDM

D_AND_ROUND	MACRO	ARG_a,ARG_b,ARG_c,ARG_d,i,s
	movq	mm4, ARG_c
	pand	mm4, ARG_d
	movq	mm5, ARG_c
	psubd	ARG_a, mm4
	pslld	ARG_c, s
	psrld	mm5, 32-s
	pxor	ARG_c, mm5
	psubd	ARG_c, ARG_b
	pxor	ARG_c, qword ptr [edi+32+8*i]
ENDM

D_OR__ROUND	MACRO	ARG_a,ARG_b,ARG_c,ARG_d,i,s
	movq	mm4, ARG_c
	por	mm4, ARG_d
	movq	mm5, ARG_c
	psubd	ARG_a, mm4
	pslld	ARG_c, s
	psrld	mm5, 32-s
	pxor	ARG_c, mm5
	psubd	ARG_c, ARG_b
	pxor	ARG_c, qword ptr [edi+32+8*i]
ENDM

.code
OPTION PROLOGUE:None
OPTION EPILOGUE:None

NUSH_SetKey_A	proc	ptrKey:DWORD
	pushad

	mov	esi, dword ptr [esp+24h]
	mov	edi, offset NUSH_internal_key
	mov	eax, dword ptr [esi+ 0]
	mov	ebx, dword ptr [esi+ 4]
	mov	ecx, dword ptr [esi+ 8]
	mov	edx, dword ptr [esi+12]
	mov	dword ptr [edi+ 4*2], ecx
	mov	dword ptr [edi+ 0*2], edx
	mov	dword ptr [edi+ 8*2], ebx
	mov	dword ptr [edi+12*2], eax
	mov	dword ptr [edi+(18*16+ 0)*2], ebx
	mov	dword ptr [edi+(18*16+ 4)*2], eax
	mov	dword ptr [edi+(18*16+ 8)*2], edx
	mov	dword ptr [edi+(18*16+12)*2], ecx

	mov	ebp, 16*16
	add	edi, 16*2

@@:	add	eax, dword ptr [newKK+ebp]
	add	ebx, dword ptr [newKK+ebp+4]
	add	ecx, dword ptr [newKK+ebp+8]
	add	edx, dword ptr [newKK+ebp+12]
	mov	dword ptr [edi+2*ebp+ 0*2], eax
	mov	dword ptr [edi+2*ebp+ 4*2], ebx
	mov	dword ptr [edi+2*ebp+ 8*2], ecx
	mov	dword ptr [edi+2*ebp+12*2], edx
	sub	ebp, 16
	jns	@B

	popad
	ret	4

NUSH_SetKey_A	endp

NUSH_SetKey_B	proc	ptrKey:DWORD
	pushad

	mov	esi, dword ptr [esp+24h]
	mov	edi, offset NUSH_internal_key
	mov	eax, dword ptr [esi+ 0]
	mov	ebx, dword ptr [esi+ 4]
	mov	ecx, dword ptr [esi+ 8]
	mov	edx, dword ptr [esi+12]
	mov	dword ptr [edi+ 4*2+4], ecx
	mov	dword ptr [edi+ 0*2+4], edx
	mov	dword ptr [edi+ 8*2+4], ebx
	mov	dword ptr [edi+12*2+4], eax
	mov	dword ptr [edi+(18*16+ 0)*2+4], ebx
	mov	dword ptr [edi+(18*16+ 4)*2+4], eax
	mov	dword ptr [edi+(18*16+ 8)*2+4], edx
	mov	dword ptr [edi+(18*16+12)*2+4], ecx

	mov	ebp, 16*16
	add	edi, 16*2

@@:	add	eax, dword ptr [newKK+ebp]
	add	ebx, dword ptr [newKK+ebp+4]
	add	ecx, dword ptr [newKK+ebp+8]
	add	edx, dword ptr [newKK+ebp+12]
	mov	dword ptr [edi+2*ebp+ 0*2+4], eax
	mov	dword ptr [edi+2*ebp+ 4*2+4], ebx
	mov	dword ptr [edi+2*ebp+ 8*2+4], ecx
	mov	dword ptr [edi+2*ebp+12*2+4], edx
	sub	ebp, 16
	jns	@B

	popad
	ret	4

NUSH_SetKey_B	endp

NUSH_Encrypt	proc	ptrOutB:DWORD, ptrOutA:DWORD, ptrInB:DWORD, ptrInA:DWORD
	pushad
	mov	esi, dword ptr [esp+20h+4*4]
	mov	edx, dword ptr [esp+20h+3*4]
	mov	edi, offset NUSH_internal_key
	
	movd	mm0, dword ptr [esi+ 0]
	movd	mm1, dword ptr [esi+ 4]
	movd	mm2, dword ptr [esi+ 8]
	movd	mm3, dword ptr [esi+12]
	punpckldq	mm0,qword ptr [edx+ 0]
	punpckldq	mm1,qword ptr [edx+ 4]
	punpckldq	mm2,qword ptr [edx+ 8]
	punpckldq	mm3,qword ptr [edx+12]
	pxor	mm0, qword ptr [edi+ 0]
	pxor	mm1, qword ptr [edi+ 8]
	pxor	mm2, qword ptr [edi+16]
	pxor	mm3, qword ptr [edi+24]

	E_AND_ROUND mm0,mm1,mm2,mm3,00,07
	E_OR__ROUND mm1,mm2,mm3,mm0,01,05
	E_AND_ROUND mm2,mm3,mm0,mm1,02,15
	E_OR__ROUND mm3,mm0,mm1,mm2,03,14
	E_OR__ROUND mm0,mm1,mm2,mm3,04,03
	E_OR__ROUND mm1,mm2,mm3,mm0,05,30
	E_OR__ROUND mm2,mm3,mm0,mm1,06,04
	E_OR__ROUND mm3,mm0,mm1,mm2,07,23
	E_AND_ROUND mm0,mm1,mm2,mm3,08,13
	E_OR__ROUND mm1,mm2,mm3,mm0,09,12
	E_OR__ROUND mm2,mm3,mm0,mm1,10,26
	E_AND_ROUND mm3,mm0,mm1,mm2,11,16
	E_OR__ROUND mm0,mm1,mm2,mm3,12,09
	E_AND_ROUND mm1,mm2,mm3,mm0,13,28
	E_OR__ROUND mm2,mm3,mm0,mm1,14,08
	E_OR__ROUND mm3,mm0,mm1,mm2,15,18
	E_OR__ROUND mm0,mm1,mm2,mm3,16,23
	E_OR__ROUND mm1,mm2,mm3,mm0,17,08
	E_AND_ROUND mm2,mm3,mm0,mm1,18,26
	E_AND_ROUND mm3,mm0,mm1,mm2,19,04
	E_AND_ROUND mm0,mm1,mm2,mm3,20,29
	E_AND_ROUND mm1,mm2,mm3,mm0,21,16
	E_AND_ROUND mm2,mm3,mm0,mm1,22,02
	E_OR__ROUND mm3,mm0,mm1,mm2,23,22
	E_AND_ROUND mm0,mm1,mm2,mm3,24,23
	E_OR__ROUND mm1,mm2,mm3,mm0,25,11
	E_OR__ROUND mm2,mm3,mm0,mm1,26,26
	E_OR__ROUND mm3,mm0,mm1,mm2,27,13
	E_AND_ROUND mm0,mm1,mm2,mm3,28,20
	E_OR__ROUND mm1,mm2,mm3,mm0,29,05
	E_AND_ROUND mm2,mm3,mm0,mm1,30,28
	E_AND_ROUND mm3,mm0,mm1,mm2,31,17
 	E_OR__ROUND mm0,mm1,mm2,mm3,32,19
 	E_OR__ROUND mm1,mm2,mm3,mm0,33,22
 	E_AND_ROUND mm2,mm3,mm0,mm1,34,06
 	E_OR__ROUND mm3,mm0,mm1,mm2,35,25
 	E_OR__ROUND mm0,mm1,mm2,mm3,36,12
 	E_AND_ROUND mm1,mm2,mm3,mm0,37,24
 	E_OR__ROUND mm2,mm3,mm0,mm1,38,27
 	E_AND_ROUND mm3,mm0,mm1,mm2,39,10
 	E_OR__ROUND mm0,mm1,mm2,mm3,40,16
 	E_AND_ROUND mm1,mm2,mm3,mm0,41,24
 	E_AND_ROUND mm2,mm3,mm0,mm1,42,09
 	E_OR__ROUND mm3,mm0,mm1,mm2,43,13
 	E_OR__ROUND mm0,mm1,mm2,mm3,44,05
 	E_AND_ROUND mm1,mm2,mm3,mm0,45,10
 	E_AND_ROUND mm2,mm3,mm0,mm1,46,26
 	E_AND_ROUND mm3,mm0,mm1,mm2,47,30
	E_AND_ROUND mm0,mm1,mm2,mm3,48,09
	E_AND_ROUND mm1,mm2,mm3,mm0,49,16
	E_AND_ROUND mm2,mm3,mm0,mm1,50,28
	E_AND_ROUND mm3,mm0,mm1,mm2,51,24
	E_AND_ROUND mm0,mm1,mm2,mm3,52,27
	E_AND_ROUND mm1,mm2,mm3,mm0,53,06
	E_OR__ROUND mm2,mm3,mm0,mm1,54,07
	E_AND_ROUND mm3,mm0,mm1,mm2,55,15
	E_OR__ROUND mm0,mm1,mm2,mm3,56,01
	E_OR__ROUND mm1,mm2,mm3,mm0,57,13
	E_OR__ROUND mm2,mm3,mm0,mm1,58,15
	E_AND_ROUND mm3,mm0,mm1,mm2,59,01
	E_AND_ROUND mm0,mm1,mm2,mm3,60,23
	E_AND_ROUND mm1,mm2,mm3,mm0,61,28
	E_OR__ROUND mm2,mm3,mm0,mm1,62,12
	E_OR__ROUND mm3,mm0,mm1,mm2,63,02
	E_AND_ROUND mm0,mm1,mm2,mm3,64,28
	E_OR__ROUND mm1,mm2,mm3,mm0,65,14
	E_AND_ROUND mm2,mm3,mm0,mm1,66,15
	E_OR__ROUND mm3,mm0,mm1,mm2,67,12

	pxor	mm0, qword ptr [edi+ 0+ 18*16*2]
	pxor	mm1, qword ptr [edi+ 8+ 18*16*2]
	pxor	mm2, qword ptr [edi+16+ 18*16*2]
	pxor	mm3, qword ptr [edi+24+ 18*16*2]

	mov	esi, dword ptr [esp+20h+2*4]
	mov	edi, dword ptr [esp+20h+1*4]
	
	movd	dword ptr [esi+ 0], mm0
	movd	dword ptr [esi+ 4], mm1
	movd	dword ptr [esi+ 8], mm2
	movd	dword ptr [esi+12], mm3
	psrlq	mm0, 32
	psrlq	mm1, 32
	psrlq	mm2, 32
	psrlq	mm3, 32
	movd	dword ptr [edi+ 0], mm0
	movd	dword ptr [edi+ 4], mm1
	movd	dword ptr [edi+ 8], mm2
	movd	dword ptr [edi+12], mm3

	popad                 
	ret	4*4
NUSH_Encrypt	endp

NUSH_Decrypt	proc	ptrOutB:DWORD, ptrOutA:DWORD, ptrInB:DWORD, ptrInA:DWORD

	pushad
	mov	esi, dword ptr [esp+20h+4*4]
	mov	edx, dword ptr [esp+20h+3*4]
	mov	edi, offset NUSH_internal_key

	movd	mm0, dword ptr [esi+ 0]
	movd	mm1, dword ptr [esi+ 4]
	movd	mm2, dword ptr [esi+ 8]
	movd	mm3, dword ptr [esi+12]
	punpckldq	mm0,qword ptr [edx+ 0]
	punpckldq	mm1,qword ptr [edx+ 4]
	punpckldq	mm2,qword ptr [edx+ 8]
	punpckldq	mm3,qword ptr [edx+12]
	pxor	mm0, qword ptr [edi+ 0+ 18*16*2]
	pxor	mm1, qword ptr [edi+ 8+ 18*16*2]
	pxor	mm2, qword ptr [edi+16+ 18*16*2]
	pxor	mm3, qword ptr [edi+24+ 18*16*2]

	D_OR__ROUND mm3,mm0,mm1,mm2,67,12
	D_AND_ROUND mm2,mm3,mm0,mm1,66,15
	D_OR__ROUND mm1,mm2,mm3,mm0,65,14
	D_AND_ROUND mm0,mm1,mm2,mm3,64,28
	D_OR__ROUND mm3,mm0,mm1,mm2,63,02
	D_OR__ROUND mm2,mm3,mm0,mm1,62,12
	D_AND_ROUND mm1,mm2,mm3,mm0,61,28
	D_AND_ROUND mm0,mm1,mm2,mm3,60,23
	D_AND_ROUND mm3,mm0,mm1,mm2,59,01
	D_OR__ROUND mm2,mm3,mm0,mm1,58,15
	D_OR__ROUND mm1,mm2,mm3,mm0,57,13
	D_OR__ROUND mm0,mm1,mm2,mm3,56,01
	D_AND_ROUND mm3,mm0,mm1,mm2,55,15
	D_OR__ROUND mm2,mm3,mm0,mm1,54,07
	D_AND_ROUND mm1,mm2,mm3,mm0,53,06
	D_AND_ROUND mm0,mm1,mm2,mm3,52,27
	D_AND_ROUND mm3,mm0,mm1,mm2,51,24
	D_AND_ROUND mm2,mm3,mm0,mm1,50,28
	D_AND_ROUND mm1,mm2,mm3,mm0,49,16
	D_AND_ROUND mm0,mm1,mm2,mm3,48,09
	D_AND_ROUND mm3,mm0,mm1,mm2,47,30
	D_AND_ROUND mm2,mm3,mm0,mm1,46,26
	D_AND_ROUND mm1,mm2,mm3,mm0,45,10
	D_OR__ROUND mm0,mm1,mm2,mm3,44,05
	D_OR__ROUND mm3,mm0,mm1,mm2,43,13
	D_AND_ROUND mm2,mm3,mm0,mm1,42,09
	D_AND_ROUND mm1,mm2,mm3,mm0,41,24
	D_OR__ROUND mm0,mm1,mm2,mm3,40,16
	D_AND_ROUND mm3,mm0,mm1,mm2,39,10
	D_OR__ROUND mm2,mm3,mm0,mm1,38,27
	D_AND_ROUND mm1,mm2,mm3,mm0,37,24
	D_OR__ROUND mm0,mm1,mm2,mm3,36,12
	D_OR__ROUND mm3,mm0,mm1,mm2,35,25
	D_AND_ROUND mm2,mm3,mm0,mm1,34,06
	D_OR__ROUND mm1,mm2,mm3,mm0,33,22
	D_OR__ROUND mm0,mm1,mm2,mm3,32,19
	D_AND_ROUND mm3,mm0,mm1,mm2,31,17
	D_AND_ROUND mm2,mm3,mm0,mm1,30,28
	D_OR__ROUND mm1,mm2,mm3,mm0,29,05
	D_AND_ROUND mm0,mm1,mm2,mm3,28,20
	D_OR__ROUND mm3,mm0,mm1,mm2,27,13
	D_OR__ROUND mm2,mm3,mm0,mm1,26,26
	D_OR__ROUND mm1,mm2,mm3,mm0,25,11
	D_AND_ROUND mm0,mm1,mm2,mm3,24,23
	D_OR__ROUND mm3,mm0,mm1,mm2,23,22
	D_AND_ROUND mm2,mm3,mm0,mm1,22,02
	D_AND_ROUND mm1,mm2,mm3,mm0,21,16
	D_AND_ROUND mm0,mm1,mm2,mm3,20,29
	D_AND_ROUND mm3,mm0,mm1,mm2,19,04
	D_AND_ROUND mm2,mm3,mm0,mm1,18,26
	D_OR__ROUND mm1,mm2,mm3,mm0,17,08
	D_OR__ROUND mm0,mm1,mm2,mm3,16,23
	D_OR__ROUND mm3,mm0,mm1,mm2,15,18
	D_OR__ROUND mm2,mm3,mm0,mm1,14,08
	D_AND_ROUND mm1,mm2,mm3,mm0,13,28
	D_OR__ROUND mm0,mm1,mm2,mm3,12,09
	D_AND_ROUND mm3,mm0,mm1,mm2,11,16
	D_OR__ROUND mm2,mm3,mm0,mm1,10,26
	D_OR__ROUND mm1,mm2,mm3,mm0,09,12
	D_AND_ROUND mm0,mm1,mm2,mm3,08,13
	D_OR__ROUND mm3,mm0,mm1,mm2,07,23
	D_OR__ROUND mm2,mm3,mm0,mm1,06,04
	D_OR__ROUND mm1,mm2,mm3,mm0,05,30
	D_OR__ROUND mm0,mm1,mm2,mm3,04,03
	D_OR__ROUND mm3,mm0,mm1,mm2,03,14
	D_AND_ROUND mm2,mm3,mm0,mm1,02,15
	D_OR__ROUND mm1,mm2,mm3,mm0,01,05
	D_AND_ROUND mm0,mm1,mm2,mm3,00,07

	pxor	mm0, qword ptr [edi+ 0]
	pxor	mm1, qword ptr [edi+ 8]
	pxor	mm2, qword ptr [edi+16]
	pxor	mm3, qword ptr [edi+24]

	mov	esi, dword ptr [esp+20h+2*4]
	mov	edi, dword ptr [esp+20h+1*4]
	
	movd	dword ptr [esi+ 0], mm0
	movd	dword ptr [esi+ 4], mm1
	movd	dword ptr [esi+ 8], mm2
	movd	dword ptr [esi+12], mm3
	psrlq	mm0, 32
	psrlq	mm1, 32
	psrlq	mm2, 32
	psrlq	mm3, 32
	movd	dword ptr [edi+ 0], mm0
	movd	dword ptr [edi+ 4], mm1
	movd	dword ptr [edi+ 8], mm2
	movd	dword ptr [edi+12], mm3

	popad                 
	ret	4*4
NUSH_Decrypt	endp

NUSH_Clear	proc

	pushad
	xor	eax, eax
	mov	edi, offset NUSH_internal_key
	mov	ecx, 2*130h/4
	cld
	rep	stosd
	popad
	ret

NUSH_Clear	endp

OPTION EPILOGUE:EPILOGUEDEF
OPTION PROLOGUE:PROLOGUEDEF

.data
newKK	dd 08CF336DCh,0DE914BF7h,02EF0CB0Fh,06053702Dh
	dd 07BD183D0h,09F8700FDh,069356554h,0E082458Eh
	dd 09178AA82h,006F738C0h,0103E5AFAh,008BFB439h
	dd 033A01380h,0CF355B79h,09EE65EAEh,03548E156h
	dd 0D5FA839Bh,01CC23AB2h,08D37B352h,00DC10577h
	dd 05DA93FE2h,08B89050Bh,09867DC62h,056A1D15Ch
	dd 0EE50D46Ch,0FA8FCFCDh,078A9560Ah,02E5429CAh
	dd 0B0F30281h,0A44776A4h,0945C7A5Ch,0F2ABEE22h
	dd 04FE5AF2Bh,05C09A75Ah,0DDA94D2Fh,0B4BF9C31h
	dd 050E9706Dh,06B4666CCh,010A07D14h,05CBED817h
	dd 0ABB35398h,0B520A9AEh,0E72D9ACBh,08499CD1Ah
	dd 0F38F8E9Eh,063163DB8h,0501CD1BCh,03D24FE36h
	dd 0E927A561h,0111A7371h,035DB309Eh,022E0CA67h
	dd 039984BACh,08F9D4F1Dh,0CE6594B2h,0DE399242h
	dd 0EC183571h,04CDB3C05h,0013BFAF0h,08144118Bh
	dd 090AC823Fh,0402934E6h,0F8D50732h,0B0B7619Bh
	dd 01ACCE5D8h,0F53B24C1h,06DB89876h,05C965DA5h

.data?
NUSH_internal_key	db 2*130h dup(?)