comment %

Algo	: NUSH (by LAN Crypto, Int.)
Block	: 16 bytes
Key	: 128 bits


	push	offset key		;ptr to 16 bytes key
	call	NUSH_SetKey

	push	offset plaintext	;ptr to 16 bytes block to encrypt
	push	offset ciphertxt	;ptr to 16 bytes block for encrypted data
	call	NUSH_Encrypt

	push	offset ciphertxt	;ptr to 16 bytes block to decrypt
	push	offset decryptxt	;ptr to 16 bytes block for decrypted data
	call	NUSH_Decrypt

	call	NUSH_Clear


NESSIE security report v1.0 :
" Nush has no security margin [313] and its performance is no better than
  MISTY1 or Khazad. Therefore it was not selected for Phase II of NESSIE."


15.06.2002 WiteG/xt+uCF (witeg@poczta.fm, www.witeg.prv.pl)
%


E_AND_ROUND	MACRO	ARG_a,ARG_b,ARG_c,ARG_d,i,s
	xor	ARG_c, dword ptr [edi+16+4*i]
	add	ARG_c, ARG_b
	mov	esi, ARG_d
	ror	ARG_c, s
	and	esi, ARG_c
	add	ARG_a, esi
ENDM

E_OR__ROUND	MACRO	ARG_a,ARG_b,ARG_c,ARG_d,i,s
	xor	ARG_c, dword ptr [edi+16+4*i]
	add	ARG_c, ARG_b
	mov	esi, ARG_d
	ror	ARG_c, s
	or	esi, ARG_c
	add	ARG_a, esi
ENDM

D_AND_ROUND	MACRO	ARG_a,ARG_b,ARG_c,ARG_d,i,s
	mov	esi, ARG_c
	rol	ARG_c, s
	and	esi, ARG_d
	sub	ARG_c, ARG_b
	sub	ARG_a, esi
	xor	ARG_c, dword ptr [edi+16+4*i]
ENDM

D_OR__ROUND	MACRO	ARG_a,ARG_b,ARG_c,ARG_d,i,s
	mov	esi, ARG_c
	rol	ARG_c, s
	or	esi, ARG_d
	sub	ARG_c, ARG_b
	sub	ARG_a, esi
	xor	ARG_c, dword ptr [edi+16+4*i]
ENDM

.data
newKK	dd 08CF336DCh,0DE914BF7h,02EF0CB0Fh,06053702Dh
	dd 07BD183D0h,09F8700FDh,069356554h,0E082458Eh
	dd 09178AA82h,006F738C0h,0103E5AFAh,008BFB439h
	dd 033A01380h,0CF355B79h,09EE65EAEh,03548E156h
	dd 0D5FA839Bh,01CC23AB2h,08D37B352h,00DC10577h
	dd 05DA93FE2h,08B89050Bh,09867DC62h,056A1D15Ch
	dd 0EE50D46Ch,0FA8FCFCDh,078A9560Ah,02E5429CAh
	dd 0B0F30281h,0A44776A4h,0945C7A5Ch,0F2ABEE22h
	dd 04FE5AF2Bh,05C09A75Ah,0DDA94D2Fh,0B4BF9C31h
	dd 050E9706Dh,06B4666CCh,010A07D14h,05CBED817h
	dd 0ABB35398h,0B520A9AEh,0E72D9ACBh,08499CD1Ah
	dd 0F38F8E9Eh,063163DB8h,0501CD1BCh,03D24FE36h
	dd 0E927A561h,0111A7371h,035DB309Eh,022E0CA67h
	dd 039984BACh,08F9D4F1Dh,0CE6594B2h,0DE399242h
	dd 0EC183571h,04CDB3C05h,0013BFAF0h,08144118Bh
	dd 090AC823Fh,0402934E6h,0F8D50732h,0B0B7619Bh
	dd 01ACCE5D8h,0F53B24C1h,06DB89876h,05C965DA5h

.code
OPTION PROLOGUE:None
OPTION EPILOGUE:None

NUSH_SetKey	proc	ptrKey:DWORD
	pushad

	mov	esi, dword ptr [esp+24h]
	mov	edi, offset NUSH_internal_key

	mov	eax, dword ptr [esi+ 0]
	mov	ebx, dword ptr [esi+ 4]
	mov	ecx, dword ptr [esi+ 8]
	mov	edx, dword ptr [esi+12]
	mov	dword ptr [edi+ 4], ecx
	mov	dword ptr [edi+ 0], edx
	mov	dword ptr [edi+ 8], ebx
	mov	dword ptr [edi+12], eax
	mov	dword ptr [edi+18*16+ 0], ebx
	mov	dword ptr [edi+18*16+ 4], eax
	mov	dword ptr [edi+18*16+ 8], edx
	mov	dword ptr [edi+18*16+12], ecx

	mov	ebp, 16*16
	add	edi, 16

@@:	add	eax, dword ptr [newKK+ebp]
	add	ebx, dword ptr [newKK+ebp+4]
	add	ecx, dword ptr [newKK+ebp+8]
	add	edx, dword ptr [newKK+ebp+12]
	mov	dword ptr [edi+ebp+ 0], eax
	mov	dword ptr [edi+ebp+ 4], ebx
	mov	dword ptr [edi+ebp+ 8], ecx
	mov	dword ptr [edi+ebp+12], edx
	sub	ebp, 16
	jns	@B

	popad
	ret	4
NUSH_SetKey	endp

NUSH_Encrypt	proc	ptrOut:DWORD, ptrIn:DWORD
	pushad

	mov	esi, dword ptr [esp+28h]
	mov	edi, offset NUSH_internal_key
	mov	eax, dword ptr [esi+ 0]
	mov	ebx, dword ptr [esi+ 4]
	mov	ecx, dword ptr [esi+ 8]
	mov	edx, dword ptr [esi+12]
	xor	eax, dword ptr [edi+ 0]
	xor	ebx, dword ptr [edi+ 4]
	xor	ecx, dword ptr [edi+ 8]
	xor	edx, dword ptr [edi+12]

	E_AND_ROUND eax,ebx,ecx,edx,00,07
	E_OR__ROUND ebx,ecx,edx,eax,01,05
	E_AND_ROUND ecx,edx,eax,ebx,02,15
	E_OR__ROUND edx,eax,ebx,ecx,03,14
	E_OR__ROUND eax,ebx,ecx,edx,04,03
	E_OR__ROUND ebx,ecx,edx,eax,05,30
	E_OR__ROUND ecx,edx,eax,ebx,06,04
	E_OR__ROUND edx,eax,ebx,ecx,07,23
	E_AND_ROUND eax,ebx,ecx,edx,08,13
	E_OR__ROUND ebx,ecx,edx,eax,09,12
	E_OR__ROUND ecx,edx,eax,ebx,10,26
	E_AND_ROUND edx,eax,ebx,ecx,11,16
	E_OR__ROUND eax,ebx,ecx,edx,12,09
	E_AND_ROUND ebx,ecx,edx,eax,13,28
	E_OR__ROUND ecx,edx,eax,ebx,14,08
	E_OR__ROUND edx,eax,ebx,ecx,15,18
	E_OR__ROUND eax,ebx,ecx,edx,16,23
	E_OR__ROUND ebx,ecx,edx,eax,17,08
	E_AND_ROUND ecx,edx,eax,ebx,18,26
	E_AND_ROUND edx,eax,ebx,ecx,19,04
	E_AND_ROUND eax,ebx,ecx,edx,20,29
	E_AND_ROUND ebx,ecx,edx,eax,21,16
	E_AND_ROUND ecx,edx,eax,ebx,22,02
	E_OR__ROUND edx,eax,ebx,ecx,23,22
	E_AND_ROUND eax,ebx,ecx,edx,24,23
	E_OR__ROUND ebx,ecx,edx,eax,25,11
	E_OR__ROUND ecx,edx,eax,ebx,26,26
	E_OR__ROUND edx,eax,ebx,ecx,27,13
	E_AND_ROUND eax,ebx,ecx,edx,28,20
	E_OR__ROUND ebx,ecx,edx,eax,29,05
	E_AND_ROUND ecx,edx,eax,ebx,30,28
	E_AND_ROUND edx,eax,ebx,ecx,31,17
 	E_OR__ROUND eax,ebx,ecx,edx,32,19
 	E_OR__ROUND ebx,ecx,edx,eax,33,22
 	E_AND_ROUND ecx,edx,eax,ebx,34,06
 	E_OR__ROUND edx,eax,ebx,ecx,35,25
 	E_OR__ROUND eax,ebx,ecx,edx,36,12
 	E_AND_ROUND ebx,ecx,edx,eax,37,24
 	E_OR__ROUND ecx,edx,eax,ebx,38,27
 	E_AND_ROUND edx,eax,ebx,ecx,39,10
 	E_OR__ROUND eax,ebx,ecx,edx,40,16
 	E_AND_ROUND ebx,ecx,edx,eax,41,24
 	E_AND_ROUND ecx,edx,eax,ebx,42,09
 	E_OR__ROUND edx,eax,ebx,ecx,43,13
 	E_OR__ROUND eax,ebx,ecx,edx,44,05
 	E_AND_ROUND ebx,ecx,edx,eax,45,10
 	E_AND_ROUND ecx,edx,eax,ebx,46,26
 	E_AND_ROUND edx,eax,ebx,ecx,47,30
	E_AND_ROUND eax,ebx,ecx,edx,48,09
	E_AND_ROUND ebx,ecx,edx,eax,49,16
	E_AND_ROUND ecx,edx,eax,ebx,50,28
	E_AND_ROUND edx,eax,ebx,ecx,51,24
	E_AND_ROUND eax,ebx,ecx,edx,52,27
	E_AND_ROUND ebx,ecx,edx,eax,53,06
	E_OR__ROUND ecx,edx,eax,ebx,54,07
	E_AND_ROUND edx,eax,ebx,ecx,55,15
	E_OR__ROUND eax,ebx,ecx,edx,56,01
	E_OR__ROUND ebx,ecx,edx,eax,57,13
	E_OR__ROUND ecx,edx,eax,ebx,58,15
	E_AND_ROUND edx,eax,ebx,ecx,59,01
	E_AND_ROUND eax,ebx,ecx,edx,60,23
	E_AND_ROUND ebx,ecx,edx,eax,61,28
	E_OR__ROUND ecx,edx,eax,ebx,62,12
	E_OR__ROUND edx,eax,ebx,ecx,63,02
	E_AND_ROUND eax,ebx,ecx,edx,64,28
	E_OR__ROUND ebx,ecx,edx,eax,65,14
	E_AND_ROUND ecx,edx,eax,ebx,66,15
	E_OR__ROUND edx,eax,ebx,ecx,67,12

	mov	esi, dword ptr [esp+24h]

	xor	eax, dword ptr [edi+18*16+ 0]
	xor	ebx, dword ptr [edi+18*16+ 4]
	xor	ecx, dword ptr [edi+18*16+ 8]
	xor	edx, dword ptr [edi+18*16+12]

	mov	dword ptr [esi+ 0], eax
	mov	dword ptr [esi+ 4], ebx
	mov	dword ptr [esi+ 8], ecx
	mov	dword ptr [esi+12], edx

	popad                 
	ret	8
NUSH_Encrypt	endp

NUSH_Decrypt	proc	ptrOut:DWORD, ptrIn:DWORD
	pushad

	mov	esi, dword ptr [esp+28h]
	mov	edi, offset NUSH_internal_key
	mov	eax, dword ptr [esi+ 0]
	mov	ebx, dword ptr [esi+ 4]
	mov	ecx, dword ptr [esi+ 8]
	mov	edx, dword ptr [esi+12]

	xor	eax, dword ptr [edi+18*16+ 0]
	xor	ebx, dword ptr [edi+18*16+ 4]
	xor	ecx, dword ptr [edi+18*16+ 8]
	xor	edx, dword ptr [edi+18*16+12]

	D_OR__ROUND edx,eax,ebx,ecx,67,12
	D_AND_ROUND ecx,edx,eax,ebx,66,15
	D_OR__ROUND ebx,ecx,edx,eax,65,14
	D_AND_ROUND eax,ebx,ecx,edx,64,28
	D_OR__ROUND edx,eax,ebx,ecx,63,02
	D_OR__ROUND ecx,edx,eax,ebx,62,12
	D_AND_ROUND ebx,ecx,edx,eax,61,28
	D_AND_ROUND eax,ebx,ecx,edx,60,23
	D_AND_ROUND edx,eax,ebx,ecx,59,01
	D_OR__ROUND ecx,edx,eax,ebx,58,15
	D_OR__ROUND ebx,ecx,edx,eax,57,13
	D_OR__ROUND eax,ebx,ecx,edx,56,01
	D_AND_ROUND edx,eax,ebx,ecx,55,15
	D_OR__ROUND ecx,edx,eax,ebx,54,07
	D_AND_ROUND ebx,ecx,edx,eax,53,06
	D_AND_ROUND eax,ebx,ecx,edx,52,27
	D_AND_ROUND edx,eax,ebx,ecx,51,24
	D_AND_ROUND ecx,edx,eax,ebx,50,28
	D_AND_ROUND ebx,ecx,edx,eax,49,16
	D_AND_ROUND eax,ebx,ecx,edx,48,09
	D_AND_ROUND edx,eax,ebx,ecx,47,30
	D_AND_ROUND ecx,edx,eax,ebx,46,26
	D_AND_ROUND ebx,ecx,edx,eax,45,10
	D_OR__ROUND eax,ebx,ecx,edx,44,05
	D_OR__ROUND edx,eax,ebx,ecx,43,13
	D_AND_ROUND ecx,edx,eax,ebx,42,09
	D_AND_ROUND ebx,ecx,edx,eax,41,24
	D_OR__ROUND eax,ebx,ecx,edx,40,16
	D_AND_ROUND edx,eax,ebx,ecx,39,10
	D_OR__ROUND ecx,edx,eax,ebx,38,27
	D_AND_ROUND ebx,ecx,edx,eax,37,24
	D_OR__ROUND eax,ebx,ecx,edx,36,12
	D_OR__ROUND edx,eax,ebx,ecx,35,25
	D_AND_ROUND ecx,edx,eax,ebx,34,06
	D_OR__ROUND ebx,ecx,edx,eax,33,22
	D_OR__ROUND eax,ebx,ecx,edx,32,19
	D_AND_ROUND edx,eax,ebx,ecx,31,17
	D_AND_ROUND ecx,edx,eax,ebx,30,28
	D_OR__ROUND ebx,ecx,edx,eax,29,05
	D_AND_ROUND eax,ebx,ecx,edx,28,20
	D_OR__ROUND edx,eax,ebx,ecx,27,13
	D_OR__ROUND ecx,edx,eax,ebx,26,26
	D_OR__ROUND ebx,ecx,edx,eax,25,11
	D_AND_ROUND eax,ebx,ecx,edx,24,23
	D_OR__ROUND edx,eax,ebx,ecx,23,22
	D_AND_ROUND ecx,edx,eax,ebx,22,02
	D_AND_ROUND ebx,ecx,edx,eax,21,16
	D_AND_ROUND eax,ebx,ecx,edx,20,29
	D_AND_ROUND edx,eax,ebx,ecx,19,04
	D_AND_ROUND ecx,edx,eax,ebx,18,26
	D_OR__ROUND ebx,ecx,edx,eax,17,08
	D_OR__ROUND eax,ebx,ecx,edx,16,23
	D_OR__ROUND edx,eax,ebx,ecx,15,18
	D_OR__ROUND ecx,edx,eax,ebx,14,08
	D_AND_ROUND ebx,ecx,edx,eax,13,28
	D_OR__ROUND eax,ebx,ecx,edx,12,09
	D_AND_ROUND edx,eax,ebx,ecx,11,16
	D_OR__ROUND ecx,edx,eax,ebx,10,26
	D_OR__ROUND ebx,ecx,edx,eax,09,12
	D_AND_ROUND eax,ebx,ecx,edx,08,13
	D_OR__ROUND edx,eax,ebx,ecx,07,23
	D_OR__ROUND ecx,edx,eax,ebx,06,04
	D_OR__ROUND ebx,ecx,edx,eax,05,30
	D_OR__ROUND eax,ebx,ecx,edx,04,03
	D_OR__ROUND edx,eax,ebx,ecx,03,14
	D_AND_ROUND ecx,edx,eax,ebx,02,15
	D_OR__ROUND ebx,ecx,edx,eax,01,05
	D_AND_ROUND eax,ebx,ecx,edx,00,07

	mov	esi, dword ptr [esp+24h]

	xor	eax, dword ptr [edi+ 0]
	xor	ebx, dword ptr [edi+ 4]
	xor	ecx, dword ptr [edi+ 8]
	xor	edx, dword ptr [edi+12]

	mov	dword ptr [esi+ 0], eax
	mov	dword ptr [esi+ 4], ebx
	mov	dword ptr [esi+ 8], ecx
	mov	dword ptr [esi+12], edx

	popad
	ret	8
NUSH_Decrypt	endp

NUSH_Clear	proc
	pushad
	xor	eax, eax
	mov	edi, offset NUSH_internal_key
	mov	ecx, 130h/4
	cld
	rep	stosd
	popad
	ret
NUSH_Clear	endp

OPTION EPILOGUE:EPILOGUEDEF
OPTION PROLOGUE:PROLOGUEDEF

.data?
NUSH_internal_key	db 130h dup(?)