comment %

Algo	: Noekeon (by Joan Daemen, Michael Peeters, Vincent Rijmen, Gilles Van Assche)
Block	: 16 bytes
Key	: 128 bits


	push	offset password
	call	Noekeon_SetEncryptKey

	push	offset plain
	push	offset cipher
	call	Noekeon_Encrypt

	push	offset password
	call	Noekeon_SetDecryptKey

	push	offset cipher
	push	offset decrypted_plain
	call	Noekeon_Decrypt

	call	Noekeon_Clear


21.05.2002 WiteG//xtreeme (witeg@poczta.fm, www.witeg.prv.pl)
%

; ---------------------------------------------------------------------------
; You should set the key schedule mode (MODE) !
; ---------------------------------------------------------------------------

MODE		equ	INDIRECTKEY	;DIRECTKEY, INDIRECTKEY

; ---------------------------------------------------------------------------

.const
DIRECTKEY	equ	0
INDIRECTKEY	equ	1
NROUND		equ	16

.code
Noekeon_SetEncryptKey	proc	ptrPass:DWORD

	pushad
	cld
	mov	esi, ptrPass
	mov	edi, offset noekeon_int_key
	mov	ecx, 4

IF	MODE eq 1
	push	offset noekeon_temp
	push	edi

	xor	eax, eax
	rep	stosd

	mov	cl, 4
	rep	movsd

	call	Noekeon_Encrypt

	mov	esi, dword ptr [esp-8]
	mov	cl, 4
	mov	edi, esi
ENDIF

@@:
	lodsd
	bswap	eax
	stosd
	dec	ecx
	jnz	@B

	popad
	ret

Noekeon_SetEncryptKey	endp

Noekeon_Encrypt		proc	ptrOut:DWORD, ptrIn:DWORD

	pushad
	mov	dword ptr [noekeon_round], NROUND
	mov	dword ptr [noekeon_esp], esp

	mov	esi, ptrIn

	mov	eax, dword ptr [esi + 0]	;a0
	mov	ebx, dword ptr [esi + 4]	;a1
	mov	ecx, dword ptr [esi + 8]	;a2
	mov	edx, dword ptr [esi +12]	;a3

	bswap	eax
	bswap	ebx
	bswap	ecx
	bswap	edx

	mov	byte ptr [noekeon_param], 80h

@@main_loop:
	xor	al, byte ptr [noekeon_param]
	mov	esi, ecx
	xor	ebx, dword ptr [noekeon_int_key + 4]
	xor	esi, eax
	xor	ecx, dword ptr [noekeon_int_key + 8]
	mov	edi, esi
	xor	eax, dword ptr [noekeon_int_key + 0]
	rol	edi, 8
	xor	edx, dword ptr [noekeon_int_key +12]
	xor	esi, edi
	mov	ebp, ebx
	rol	edi, 16
	xor	ebp, edx
	xor	esi, edi
	mov	esp, ebp
	xor	ebx, esi
	rol	esp, 8
	xor	edx, esi
	xor	ebp, esp
	rol	ebx, 1
	rol	esp, 16
	rol	edx, 2	
	xor	ebp, esp
	not	ebx
	xor	ecx, ebp

	rol	ecx, 5

	mov	esi, ecx
	xor	eax, ebp
	or	esi, edx
	mov	ebp, ecx
	xor	ebx, esi
	xchg	eax, edx
	xor	ecx, ebx
	and	ebp, ebx
	xor	ecx, eax
	xor	edx, ebp
	
	xor	ecx, edx

	mov	esi, ecx
	not	ebx
	or	esi, edx
	mov	ebp, ecx
	xor	ebx, esi
	ror	ecx, 5
	and	ebp, ebx
	ror	edx, 2	
	ror	ebx, 1
	xor	eax, ebp
	
	shl	byte ptr [noekeon_param], 1
	jnc	@F
	xor	byte ptr [noekeon_param], 1Bh
@@:
	dec	dword ptr [noekeon_round]
	jnz	@@main_loop

	xor	al, byte ptr [noekeon_param]
	mov	esi, ecx
	xor	ebx, dword ptr [noekeon_int_key + 4]
	xor	esi, eax
	xor	ecx, dword ptr [noekeon_int_key + 8]
	mov	edi, esi
	xor	eax, dword ptr [noekeon_int_key + 0]
	rol	edi, 8
	xor	edx, dword ptr [noekeon_int_key +12]
	xor	esi, edi
	mov	ebp, ebx
	rol	edi, 16
	xor	ebp, edx
	xor	esi, edi
	mov	esp, ebp
	xor	ebx, esi
	rol	esp, 8
	xor	edx, esi
	xor	ebp, esp
	bswap	ebx
	rol	esp, 16
	bswap	edx
	xor	ebp, esp
	xor	eax, ebp
	mov	esp, dword ptr [noekeon_esp]
	xor	ecx, ebp
	bswap	eax
	mov	ebp, dword ptr [esp + 8]
	bswap	ecx
	mov	edi, ptrOut

	mov	dword ptr [edi + 0], eax
	mov	dword ptr [edi + 4], ebx
	mov	dword ptr [edi + 8], ecx
	mov	dword ptr [edi +12], edx
	popad
	ret

Noekeon_Encrypt		endp

Noekeon_Clear		proc
	pushad
	cld
	mov	edi, offset noekeon_int_key

IF	MODE eq 1
	mov	ecx, 11
ELSEIF	MODE eq 0
	mov	ecx, 7
ENDIF
	xor	eax, eax
	rep	stosd
	popad
	ret
Noekeon_Clear		endp

Noekeon_SetDecryptKey	proc	ptrPass:DWORD

	pushad
	cld
	mov	esi, ptrPass
	mov	edi, offset noekeon_int_key
	mov	ecx, 4

IF	MODE eq 1

	push	offset noekeon_temp
	push	edi

	xor	eax, eax
	rep	stosd

	mov	cl, 4
	rep	movsd

	call	Noekeon_Encrypt

	mov	esi, dword ptr [esp-8]

	mov	eax, dword ptr [esi + 0]	;a0
	mov	ebx, dword ptr [esi + 4]	;a1
	mov	ecx, dword ptr [esi + 8]	;a2
	mov	edx, dword ptr [esi +12]	;a3

	mov	dword ptr [noekeon_esp], esp

	bswap	ecx
	bswap	eax
	mov	esi, ecx
	bswap	edx
	xor	esi, eax
	bswap	ebx

ELSEIF	MODE eq 0

@@:
	lodsd
	bswap	eax
	stosd
	dec	ecx
	jnz	@B

	mov	esi, offset noekeon_int_key
	mov	eax, dword ptr [esi + 0]
	mov	ebx, dword ptr [esi + 4]
	mov	ecx, dword ptr [esi + 8]
	mov	edx, dword ptr [esi +12]

	mov	esi, ecx
	mov	dword ptr [noekeon_esp], esp
	xor	esi, eax

ENDIF

	mov	edi, esi
	mov	ebp, ebx	
	rol	edi, 8
	xor	ebp, edx
	xor	esi, edi
	mov	esp, ebp	
	rol	edi, 16
	rol	esp, 8
	xor	esi, edi
	xor	ebp, esp
	xor	ebx, esi
	rol	esp, 16
	xor	edx, esi
	xor	ebp, esp
	xor	eax, ebp
	mov	esp, dword ptr [noekeon_esp]
	xor	ecx, ebp

IF	MODE eq 1
	mov	edi, dword ptr [esp-8]
ELSEIF	MODE eq 0
	mov	edi, offset noekeon_int_key
ENDIF

	mov	dword ptr [edi + 0], eax
	mov	dword ptr [edi + 4], ebx
	mov	dword ptr [edi + 8], ecx
	mov	dword ptr [edi +12], edx

	popad
	ret
Noekeon_SetDecryptKey	endp

Noekeon_Decrypt		proc	ptrOut:DWORD, ptrIn:DWORD

	pushad
	mov	dword ptr [noekeon_round], NROUND
	mov	dword ptr [noekeon_esp], esp

	mov	esi, ptrIn

	mov	eax, dword ptr [esi + 0]	;a0
	mov	ebx, dword ptr [esi + 4]	;a1
	mov	ecx, dword ptr [esi + 8]	;a2
	mov	edx, dword ptr [esi +12]	;a3

	bswap	eax
	bswap	ebx
	bswap	ecx
	bswap	edx

	mov	byte ptr [noekeon_param], 0D4h

@@main_loop:
	mov	esi, ecx
	xor	ebx, dword ptr [noekeon_int_key + 4]
	xor	esi, eax
	xor	ecx, dword ptr [noekeon_int_key + 8]
	mov	edi, esi
	xor	eax, dword ptr [noekeon_int_key + 0]
	rol	edi, 8
	xor	edx, dword ptr [noekeon_int_key +12]
	xor	esi, edi
	mov	ebp, ebx
	rol	edi, 16
	xor	ebp, edx
	xor	esi, edi
	mov	esp, ebp
	xor	ebx, esi
	rol	esp, 8
	xor	edx, esi
	xor	ebp, esp
	rol	ebx, 1
	rol	esp, 16
	rol	edx, 2	
	xor	ebp, esp
	not	ebx
	xor	ecx, ebp

	xor	al, byte ptr [noekeon_param]
	rol	ecx, 5

	mov	esi, ecx
	xor	eax, ebp
	or	esi, edx
	mov	ebp, ecx
	xor	ebx, esi
	xchg	eax, edx
	xor	ecx, ebx
	and	ebp, ebx
	xor	ecx, eax
	xor	edx, ebp
	
	xor	ecx, edx

	mov	esi, ecx
	not	ebx
	or	esi, edx
	mov	ebp, ecx
	xor	ebx, esi
	ror	ecx, 5
	and	ebp, ebx
	ror	edx, 2	
	ror	ebx, 1
	xor	eax, ebp

	shr	byte ptr [noekeon_param], 1
	jnc	@F
	xor	byte ptr [noekeon_param], 8Dh
@@:
	dec	dword ptr [noekeon_round]
	jnz	@@main_loop

	mov	esi, ecx
	xor	ebx, dword ptr [noekeon_int_key + 4]
	xor	esi, eax
	xor	ecx, dword ptr [noekeon_int_key + 8]
	mov	edi, esi
	xor	eax, dword ptr [noekeon_int_key + 0]
	rol	edi, 8
	xor	edx, dword ptr [noekeon_int_key +12]
	xor	esi, edi
	mov	ebp, ebx
	rol	edi, 16
	xor	ebp, edx
	xor	esi, edi
	mov	esp, ebp
	xor	ebx, esi
	rol	esp, 8
	xor	edx, esi
	xor	ebp, esp
	bswap	ebx
	rol	esp, 16
	bswap	edx
	xor	ebp, esp
	xor	eax, ebp
	mov	esp, dword ptr [noekeon_esp]
	xor	al, byte ptr [noekeon_param]
	xor	ecx, ebp
	bswap	eax
	mov	ebp, dword ptr [esp + 8]
	bswap	ecx
	mov	edi, ptrOut

	mov	dword ptr [edi + 0], eax
	mov	dword ptr [edi + 4], ebx
	mov	dword ptr [edi + 8], ecx
	mov	dword ptr [edi +12], edx
	popad
	ret
Noekeon_Decrypt		endp

.data?
noekeon_int_key		dd 	4 dup (?)
IF MODE eq 1
noekeon_temp		dd	4 dup (?)
ENDIF
noekeon_round		dd	?
noekeon_esp		dd	?
noekeon_param		db	?
			db	3 dup (?)