comment %

Algo	: Nimbus (by Alexis Warner Machado)
Block	: 8 bytes
Key	: 128 bits


	push	offset key		;ptr to 16 bytes user key
	call	Nimbus_SetKey

	push	offset buffer_plain	;ptr to 8 bytes block to encrypt
	push	offset buffer_cipher	;ptr to 8 bytes block for encrypted data
	call	Nimbus_Encrypt

	push	offset buffer_cipher	;ptr to 8 bytes block for encrypted data
	push	offset buffer_decrpt	;ptr to 8 bytes block for decrypted data
	call	Nimbus_Decrypt

	call	Nimbus_Clear


NESSIE security report v1.0 :
" There is a very practical attack on Nimbus [44] and the justifications for its
  design are not sufficiently convincing for it to be worth considering a tweaked
  variant. Therefore it was not selected for Phase II of NESSIE."

21.06.2002 WiteG/xt+uCF (witeg@poczta.fm, www.witeg.prv.pl)
%

include nimbus.mac

.data
ALIGN 8
nimbus_fixedKey	dq 0243F6A8885A308D3h, 013198A2E03707345h
		dq 0A4093822299F31D1h, 0082EFA98EC4E6C89h
		dq 0452821E638D01377h, 0BE5466CF34E90C6Ch
		dq 0C0AC29B7C97C50DDh, 03F84D5B5B5470917h
		dq 09216D5D98979FB1Bh, 0D1310BA698DFB5ACh

mask_1		dq 0101010101010101010101010101010101010101010101010101010101010101b
mask_2		dq 0011001100110011001100110011001100110011001100110011001100110011b
mask_4		dq 0000111100001111000011110000111100001111000011110000111100001111b

.code
OPTION PROLOGUE:None
OPTION EPILOGUE:None

Nimbus_SetKey	proc	ptrKey:DWORD

	pushad
	mov	esi, offset nimbus_fixedKey
	mov	edi, offset nimbus_encKey
	mov	ecx, 10*2
	cld
	rep	movsd

	xor	eax, eax
	mov	edi, offset nimbus_decKey
	mov	ecx, 10*2
	cld
	rep	stosd

	mov	esi, dword ptr [esp+24h]
	mov	ebx, offset nimbus_tempSpace
	xor	ecx, ecx
@loop:
	push	esi
	push	ebx
	call	Nimbus_Encrypt
	
	movq	mm0, qword ptr [esi]
	pxor	mm0, qword ptr [ebx]
	movq	qword ptr [ebx], mm0
	
	mov	ebp, 10
	mov	edi, offset nimbus_decKey
		
	@@:	push	ebx
		push	ebx
		call	Nimbus_Encrypt
		
		mov	eax, dword ptr [ebx]
		mov	edx, dword ptr [ebx+4]
		add	dword ptr [edi], eax
		adc	dword ptr [edi+4], edx
	
		push	edi
		push	edi
		call	Nimbus_Encrypt
	
		movq	mm0, qword ptr [ebx]
		pxor	mm0, qword ptr [edi]
		movq	qword ptr [edi], mm0
	
		add	edi, 8
		dec	ebp
		jnz	@B

	add	esi, 8
	xor	ecx, 1
	jnz	@loop

	mov	esi, offset nimbus_decKey
	mov	edi, offset nimbus_encKey
	
	or	dword ptr [esi+8*0], 1
	or	dword ptr [esi+8*1], 1
	or	dword ptr [esi+8*2], 1
	or	dword ptr [esi+8*3], 1
	or	dword ptr [esi+8*4], 1

	mov	ecx, 10*2
	cld
	rep	movsd

	mov	esi, offset nimbus_decKey
	mov	ecx, 5

@@:	mov	edi, dword ptr [esi]
	mov	eax, edi
	mov	ebx, edi
	imul	edi
	neg	eax
	add	eax, 2
	imul	ebx
	mov	ebx, eax
	imul	edi
	neg	eax
	add	eax, 2
	imul	ebx
	mov	ebx, eax
	imul	edi
	neg	eax
	add	eax, 2
	imul	ebx
	mov	ebx, eax
	imul	edi
	neg	eax
	add	eax, 2
	imul	ebx, eax

	mov	eax, edi
	mul	ebx
	mov	edi, eax
	mov	ebp, edx
	mov	eax, dword ptr [esi+4]
	mul	ebx
	add	ebp, eax
	not	edi
	not	ebp
	add	edi, 3				;y = 2-x = NEG(x)+2 = (NOT(x)+1)+2
	adc	ebp, 0
	mov	eax, edi
	mul	ebx
	mov	dword ptr [esi], eax
	mov	edi, edx
	mov	eax, ebp
	mul	ebx
	add	eax, edi
	mov	dword ptr [esi+4], eax

	add	esi, 8
	dec	ecx
	jnz	@B

	popad
	ret	4

Nimbus_SetKey	endp

Nimbus_Encrypt	proc	ptrOut:DWORD, ptrIn:DWORD

	pushad
	mov	esi, offset nimbus_encKey
	mov	ecx, dword ptr [esp+28h]
	mov	edi, dword ptr [esp+24h]

	movq	mm2, qword ptr [mask_1]
	movq	mm3, qword ptr [mask_2]
	movq	mm4, qword ptr [mask_4]

	NIMBUS_E_ROUND	ecx, 0
	NIMBUS_E_ROUND	edi, 1
	NIMBUS_E_ROUND	edi, 2
	NIMBUS_E_ROUND	edi, 3
	NIMBUS_E_ROUND	edi, 4

	popad
	ret	8
Nimbus_Encrypt	endp

Nimbus_Decrypt	proc	ptrOut:DWORD, ptrIn:DWORD

	pushad
	mov	esi, offset nimbus_decKey
	mov	ecx, dword ptr [esp+28h]
	mov	edi, dword ptr [esp+24h]

	movq	mm2, qword ptr [mask_1]
	movq	mm3, qword ptr [mask_2]
	movq	mm4, qword ptr [mask_4]

	NIMBUS_D_ROUND	ecx, 4
	NIMBUS_D_ROUND	edi, 3
	NIMBUS_D_ROUND	edi, 2
	NIMBUS_D_ROUND	edi, 1
	NIMBUS_D_ROUND	edi, 0

	popad
	ret	8
Nimbus_Decrypt	endp

Nimbus_Clear	proc

	pushad
	xor	eax, eax
	mov	ecx, 21*2
	mov	edi, offset nimbus_encKey
	cld
	rep	stosd

	pxor	mm0, mm0
	pxor	mm1, mm1
	pxor	mm2, mm2
	pxor	mm3, mm3
	pxor	mm4, mm4

	popad
	ret

Nimbus_Clear	endp

OPTION EPILOGUE:EPILOGUEDEF
OPTION PROLOGUE:PROLOGUEDEF

.data?
nimbus_encKey		dq 10 dup (?)
nimbus_decKey		dq 10 dup (?)
nimbus_tempSpace	dq ?