comment !ON

Algo	: Mir-1 stream cipher by Alexander Maximov
Key	: 16 bytes (128 bits)
IV	:  8 bytes ( 64 bits)


	push	offset _Key	;Key ptr
	call	Mir_SetKey

	push	offset _IV	;IV ptr
	call	Mir_SetIV

	push	offset _In	;source ptr
	push	offset _Out	;destination ptr
	call	Mir_Crypt

	call	Mir_Clear	;clear temporary data


23.06.2005 WiteG (witeg@poczta.fm, www.witeg.prv.pl)

comment !OFF


;------------ SET VARS ------------
XLAT_SETKEY equ 0	;1 = short but slow Mir_SetKey code;
			;0 = longer but much faster Mir_SetKey code

XLAT_UPDATE equ 1	;0 or 1 - one of them may be a little faster on your cpu
;----------------------------------

MULT	MACRO	T_LO, T_HI, P_LO, P_HI, OUTPUT
	mov	eax, T_LO
	mul	P_LO
	xor	ecx, ecx
	add	dword ptr [OUTPUT], eax
	adc	ecx, edx
	mov	eax, T_HI
	mul	P_LO
	add	ecx, eax
	mov	eax, P_HI
	mul	T_LO
	add	ecx, eax
	add	dword ptr [OUTPUT+4], ecx	;x2+=m2
ENDM

.data?
sbox	db 256 dup (?)
_a	db 16 dup (?)
x0	dq ?
x1	dq ?
x2	dq ?
x3	dq ?
t0	dq ?
t1	dq ?
p0	dq ?
p1	dq ?
counter	dd ?

.data
SR	db 063h, 07Ch, 077h, 07Bh, 0F2h, 06Bh, 06Fh, 0C5h, 030h, 001h, 067h, 02Bh, 0FEh, 0D7h, 0ABh, 076h
	db 0CAh, 082h, 0C9h, 07Dh, 0FAh, 059h, 047h, 0F0h, 0ADh, 0D4h, 0A2h, 0AFh, 09Ch, 0A4h, 072h, 0C0h
	db 0B7h, 0FDh, 093h, 026h, 036h, 03Fh, 0F7h, 0CCh, 034h, 0A5h, 0E5h, 0F1h, 071h, 0D8h, 031h, 015h
	db 004h, 0C7h, 023h, 0C3h, 018h, 096h, 005h, 09Ah, 007h, 012h, 080h, 0E2h, 0EBh, 027h, 0B2h, 075h
	db 009h, 083h, 02Ch, 01Ah, 01Bh, 06Eh, 05Ah, 0A0h, 052h, 03Bh, 0D6h, 0B3h, 029h, 0E3h, 02Fh, 084h
	db 053h, 0D1h, 000h, 0EDh, 020h, 0FCh, 0B1h, 05Bh, 06Ah, 0CBh, 0BEh, 039h, 04Ah, 04Ch, 058h, 0CFh
	db 0D0h, 0EFh, 0AAh, 0FBh, 043h, 04Dh, 033h, 085h, 045h, 0F9h, 002h, 07Fh, 050h, 03Ch, 09Fh, 0A8h
	db 051h, 0A3h, 040h, 08Fh, 092h, 09Dh, 038h, 0F5h, 0BCh, 0B6h, 0DAh, 021h, 010h, 0FFh, 0F3h, 0D2h
	db 0CDh, 00Ch, 013h, 0ECh, 05Fh, 097h, 044h, 017h, 0C4h, 0A7h, 07Eh, 03Dh, 064h, 05Dh, 019h, 073h
	db 060h, 081h, 04Fh, 0DCh, 022h, 02Ah, 090h, 088h, 046h, 0EEh, 0B8h, 014h, 0DEh, 05Eh, 00Bh, 0DBh
	db 0E0h, 032h, 03Ah, 00Ah, 049h, 006h, 024h, 05Ch, 0C2h, 0D3h, 0ACh, 062h, 091h, 095h, 0E4h, 079h
	db 0E7h, 0C8h, 037h, 06Dh, 08Dh, 0D5h, 04Eh, 0A9h, 06Ch, 056h, 0F4h, 0EAh, 065h, 07Ah, 0AEh, 008h
	db 0BAh, 078h, 025h, 02Eh, 01Ch, 0A6h, 0B4h, 0C6h, 0E8h, 0DDh, 074h, 01Fh, 04Bh, 0BDh, 08Bh, 08Ah
	db 070h, 03Eh, 0B5h, 066h, 048h, 003h, 0F6h, 00Eh, 061h, 035h, 057h, 0B9h, 086h, 0C1h, 01Dh, 09Eh
	db 0E1h, 0F8h, 098h, 011h, 069h, 0D9h, 08Eh, 094h, 09Bh, 01Eh, 087h, 0E9h, 0CEh, 055h, 028h, 0DFh
	db 08Ch, 0A1h, 089h, 00Dh, 0BFh, 0E6h, 042h, 068h, 041h, 099h, 02Dh, 00Fh, 0B0h, 054h, 0BBh, 016h

.code
OPTION PROLOGUE:NONE
OPTION EPILOGUE:NONE

Mir_SetKey	proc	ptrKey:DWORD

	pushad

IF	(XLAT_SETKEY eq 1)

	mov	esi, dword ptr [esp+20h+4]	;ptrKey
	mov	ebx, offset SR

	xor	ecx, ecx
	xor	edx, edx
@sloop:	
	mov	al, dl

	@@:	xor	al, byte ptr [esi+ecx]
		xlatb
		inc	ecx
		and	ecx, 0Fh
		jnz	@B

	mov	byte ptr [sbox+edx], al
	inc	dl
	jnz	@sloop

ELSE

	mov	esi, dword ptr [esp+20h+4]	;ptrKey
	mov	edi, offset SR
	xor	ebp, ebp
	xor	eax, eax
	xor	ebx, ebx
@@:	mov	edx, dword ptr [counter]
	lea	ecx, [edx+1]
	movzx	ebp, byte ptr [esi]
	xor	edx, ebp
	xor	ecx, ebp
	mov	al, byte ptr [edi+edx]
	movzx	ebp, byte ptr [esi+1]
	mov	bl, byte ptr [edi+ecx]
	xor	eax, ebp
	xor	ebx, ebp
	mov	dl, byte ptr [edi+eax]
	movzx	ebp, byte ptr [esi+2]
	mov	cl, byte ptr [edi+ebx]
	xor	edx, ebp
	xor	ecx, ebp
	mov	al, byte ptr [edi+edx]
	movzx	ebp, byte ptr [esi+3]
	mov	bl, byte ptr [edi+ecx]
	xor	eax, ebp
	xor	ebx, ebp
	mov	dl, byte ptr [edi+eax]
	movzx	ebp, byte ptr [esi+4]
	mov	cl, byte ptr [edi+ebx]
	xor	edx, ebp
	xor	ecx, ebp
	mov	al, byte ptr [edi+edx]
	movzx	ebp, byte ptr [esi+5]
	mov	bl, byte ptr [edi+ecx]
	xor	eax, ebp
	xor	ebx, ebp
	mov	dl, byte ptr [edi+eax]
	movzx	ebp, byte ptr [esi+6]
	mov	cl, byte ptr [edi+ebx]
	xor	edx, ebp
	xor	ecx, ebp
	mov	al, byte ptr [edi+edx]
	movzx	ebp, byte ptr [esi+7]
	mov	bl, byte ptr [edi+ecx]
	xor	eax, ebp
	xor	ebx, ebp
	mov	dl, byte ptr [edi+eax]
	movzx	ebp, byte ptr [esi+8]
	mov	cl, byte ptr [edi+ebx]
	xor	edx, ebp
	xor	ecx, ebp
	mov	al, byte ptr [edi+edx]
	movzx	ebp, byte ptr [esi+9]
	mov	bl, byte ptr [edi+ecx]
	xor	eax, ebp
	xor	ebx, ebp
	mov	dl, byte ptr [edi+eax]
	movzx	ebp, byte ptr [esi+10]
	mov	cl, byte ptr [edi+ebx]
	xor	edx, ebp
	xor	ecx, ebp
	mov	al, byte ptr [edi+edx]
	movzx	ebp, byte ptr [esi+11]
	mov	bl, byte ptr [edi+ecx]
	xor	eax, ebp
	xor	ebx, ebp
	mov	dl, byte ptr [edi+eax]
	movzx	ebp, byte ptr [esi+12]
	mov	cl, byte ptr [edi+ebx]
	xor	edx, ebp
	xor	ecx, ebp
	mov	al, byte ptr [edi+edx]
	movzx	ebp, byte ptr [esi+13]
	mov	bl, byte ptr [edi+ecx]
	xor	eax, ebp
	xor	ebx, ebp
	mov	dl, byte ptr [edi+eax]
	movzx	ebp, byte ptr [esi+14]
	mov	cl, byte ptr [edi+ebx]
	xor	edx, ebp
	xor	ecx, ebp
	mov	al, byte ptr [edi+edx]
	movzx	ebp, byte ptr [esi+15]
	mov	bl, byte ptr [edi+ecx]
	xor	eax, ebp
	xor	ebx, ebp
	mov	dl, byte ptr [edi+eax]
	mov	ebp, dword ptr [counter]
	mov	cl, byte ptr [edi+ebx]
	mov	byte ptr [sbox+ebp], dl
	mov	byte ptr [sbox+ebp+1], cl
	add	byte ptr [counter], 2
	jnz	@B

ENDIF

	mov	eax, dword ptr [esi]
	mov	edx, dword ptr [esi+4]
	mov	dword ptr [_a], eax
	mov	dword ptr [_a+4], edx
	mov	dword ptr [x1], eax
	mov	dword ptr [x1+4], edx

	mov	dword ptr [x0], 12488421h
	mov	dword ptr [x0+4], 12488421h
	mov	dword ptr [x2], 12481248h
	mov	dword ptr [x2+4], 12481248h

	mov	eax, dword ptr [esi+8]
	mov	edx, dword ptr [esi+12]
	mov	dword ptr [_a+8], eax
	mov	dword ptr [_a+12], edx
	mov	dword ptr [x3], eax
	mov	dword ptr [x3+4], edx

	mov	dword ptr [counter], 8
@@:	call	Mir1_STUPD
	dec	dword ptr [counter]
	jnz	@B
	
	popad
	ret	4

Mir_SetKey	endp

Mir_SetIV	proc	ptrIV:DWORD

	pushad

	mov	esi, dword ptr [esp+20h+4]	;ptrIV
	mov	ebx, offset sbox

	mov	eax, dword ptr [esi]	;IV[3]:IV[2]:IV[1]:IV[0]
	xlatb
	mov	dl, al		;S[IV[0]]

	xor	byte ptr [x1+4], al
	xor	byte ptr [_a+0], al

	shr	eax, 8
	xlatb
	xor	dl, al		;dl = S[IV[0]]^S[IV[1]]

	xor	byte ptr [x2+0], dl
	xor	byte ptr [_a+4], al
	xor	byte ptr [_a+8+0], al

	shr	eax, 8
	xlatb
	xor	dl, al		;dl = S[IV[0]]^S[IV[1]]^S[IV[2]]
	mov	dh, al		;dh = S[IV[2]]
	xor	byte ptr [x0+4], dl
	xor	byte ptr [x2+4], dh

	shr	eax, 8
	xlatb
	mov	dl, al		;dl = S[IV[3]]

	xor	byte ptr [x1+4], al
	xor	byte ptr [x3+4], al

	mov	eax, dword ptr [esi+4]	;IV[7]:IV[6]:IV[5]:IV[4]
	xlatb
	xor	dh, al		;dh = S[IV[2]] ^ S[IV[4]]

	xor	byte ptr [x1+4], al
	xor	byte ptr [_a+8+0], al
	xor	byte ptr [x3+0], dh

	shr	eax, 8
	xlatb
	xor	dl, al		;dl = S[IV[3]] ^ S[IV[5]]
	mov	cl, al		;cl = S[IV[5]]
	xor	byte ptr [x2+4], al
	xor	byte ptr [x0+0], dl
	xor	byte ptr [_a+4], dl

	shr	eax, 8
	xlatb
	mov	dl, al		;dl = S[IV[6]]
	xor	dh, al		;dh = S[IV[2]] ^ S[IV[4]] ^ S[IV[6]]
	xor	cl, al		;cl = S[IV[5]] ^ S[IV[6]]

	xor	byte ptr [_a+8+4], dh
	xor	byte ptr [_a+0], cl

	shr	eax, 8
	xlatb
	xor	dl, al		;dl = S[IV[6]] & S[IV[7]]
	xor	byte ptr [x2+4], al
	xor	byte ptr [_a+8+0], al
	xor	byte ptr [x3+4], dl
	xor	byte ptr [x1+0], dl

	call	Mir1_STUPD
	call	Mir1_STUPD

	popad
	ret	4

Mir_SetIV	endp

Mir_Crypt	proc	ptrOut:DWORD, ptrIn:DWORD

	pushad

	call	Mir1_STUPD

	mov	esi, dword ptr [esp+20h+4+4]	;ptrIn
	mov	edi, dword ptr [esp+20h+4]	;ptrOut

	xor	eax, dword ptr [esi  ]
	xor	edx, dword ptr [esi+4]
	mov	dword ptr [edi  ], eax
	mov	dword ptr [edi+4], edx

	popad
	ret	8
Mir_Crypt	endp

Mir_Clear	proc
	push	eax
	push	edi
	
	xor	eax, eax
	mov	edi, offset sbox
	mov	ecx, ((offset counter+4) - (offset sbox))/4
	cld
	rep	stosd

	pop	edi
	pop	eax
	ret
Mir_Clear	endp

Mir1_STUPD:

IF	(XLAT_UPDATE eq 1)
	mov	eax, dword ptr [_a+ 8]
	mov	ebx, offset sbox
	mov	edx, dword ptr [_a+12]

	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xlatb
	xchg	eax, edx
	xlatb
	rol	eax, 8
	rol	edx, 8
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8

	xor	dword ptr [_a], edx
	xor	dword ptr [_a+4], eax
ELSE
	xor	eax, eax
	xor	edx, edx
	mov	ebx, offset sbox

	mov	al, byte ptr [_a+8+3]
	mov	dl, byte ptr [_a+8+2]
	mov	ch, byte ptr [ebx+eax]
	mov	cl, byte ptr [ebx+edx]
	mov	al, byte ptr [_a+8+1]
	rol	ecx, 16
	mov	dl, byte ptr [_a+8+0]
	mov	ch, byte ptr [ebx+eax]
	mov	cl, byte ptr [ebx+edx]
	xor	dword ptr [_a], ecx

	mov	al, byte ptr [_a+8+7]
	mov	dl, byte ptr [_a+8+6]
	mov	ch, byte ptr [ebx+eax]
	mov	cl, byte ptr [ebx+edx]
	mov	al, byte ptr [_a+8+5]
	rol	ecx, 16
	mov	dl, byte ptr [_a+8+4]
	mov	ch, byte ptr [ebx+eax]
	mov	cl, byte ptr [ebx+edx]
	xor	dword ptr [_a+4], ecx
ENDIF


;a.b.b0 ^= S[b.b.b0];a.b.b1 ^= S[b.b.b1];
;a.b.b2 ^= S[b.b.b2];a.b.b3 ^= S[b.b.b3];
;a.b.b4 ^= S[b.b.b4];a.b.b5 ^= S[b.b.b5];
;a.b.b6 ^= S[b.b.b6];a.b.b7 ^= S[b.b.b7];

	mov	edx, dword ptr [x0+4]
	mov	eax, dword ptr [x0  ]
	mov	edi, edx
	mov	esi, eax
	mov	ebx, dword ptr [x1  ]
	shld	edi, esi, 1
	mov	ebp, dword ptr [x1+4]
	mov	dword ptr [t0+4], edi
	shl	esi, 1			;edi:esi = x0<<1
	and	eax, ebx
	mov	dword ptr [t0], esi	;t0 = x0<<1
	or	ebx, 12481248h
	and	edx, ebp
	or	ebp, 12481248h
	mov	dword ptr [p0], ebx
	mov	dword ptr [p0+4], ebp	;p0 = x1 | C1
	mov	esi, dword ptr [x2]
	mov	edi, dword ptr [x2+4]
	mov	ebx, eax
	mov	ebp, edx
	and	eax, esi
	and	edx, edi
					;ebp:ebx = x0&x1
	shld	edi, esi, 1
	shl	esi, 1			;edi:esi = x2<<1

	mov	dword ptr [t1  ], esi	;t1=x2<<1
	mov	dword ptr [t1+4], edi
	mov	esi, dword ptr [x3  ]
	mov	edi, dword ptr [x3+4]
	and	eax, esi
	and	edx, edi
	or	esi, 48124812h
	or	edi, 48124812h
	mov	dword ptr [p1  ], esi	;p1=x3|C3
	mov	dword ptr [p1+4], edi
	
	mov	esi, eax
	mov	edi, edx		;edi:esi = x0&x1&x2&x3
	add	eax, 12488421h
	adc	edx, 12488421h
	xor	eax, esi
	xor	edx, edi		;edx:eax = ((x0&x1&x2&x3 + C0) ^ x0&x1&x2&x3)

	mov	esi, dword ptr [x0  ]
	mov	edi, dword ptr [x0+4]
	
	add	dword ptr [x0  ], eax
	adc	dword ptr [x0+4], edx	;x0' = x0 + ((x0&x1&x2&x3 + C0) ^ x0&x1&x2&x3)
	and	esi, eax
	and	edi, edx		;edx:eax = ((x0&x1&x2&x3 + C0) ^ x0&x1&x2&x3) & x0
	add	dword ptr [x1  ], esi
	adc	dword ptr [x1+4], edi	;x1' = x1 + ((x0&x1&x2&x3 + C0) ^ x0&x1&x2&x3) &x0
	and	ebx, eax
	and	ebp, edx		;ebp:ebx = ((x0&x1&x2&x3 + C0) ^ x0&x1&x2&x3) & x0&x1
	mov	eax, ebx
	mov	edx, ebp
	and	eax, dword ptr [x2  ]
	and	edx, dword ptr [x2+4]	;edx:eax = ((x0&x1&x2&x3 + C0) ^ x0&x1&x2&x3) & x0&x1&x2
	
	add	dword ptr [x2  ], ebx
	adc	dword ptr [x2+4], ebp	;x2' = x2 + ((x0&x1&x2&x3 + C0) ^ x0&x1&x2&x3) &x0&x1
	add	dword ptr [x3  ], eax
	adc	dword ptr [x3+4], edx	;x3' = x3 + ((x0&x1&x2&x3 + C0) ^ x0&x1&x2&x3) &x0&x1&x3

;	x3 = x3+ ((x0&x1&x2&x3 + C0) ^ x0&x1&x2&x3) &x0&x1&x2
;	x2 = x2+ ((x0&x1&x2&x3 + C0) ^ x0&x1&x2&x3) &x0&x1
;	x1 = x1+ ((x0&x1&x2&x3 + C0) ^ x0&x1&x2&x3) &x0
;	x0 = x0+ ((x0&x1&x2&x3 + C0) ^ x0&x1&x2&x3)

	mov	ebx, dword ptr [t0]
	mov	ebp, dword ptr [t1]
	mov	esi, dword ptr [p0]
	mov	edi, dword ptr [p1]

;	m0 = p0 * t1
;	m1 = p1 * t1
;	m2 = p1 * t0
;	m3 = p0 * t0

;	t0 = [t0+4]:ebx
;	t1 = [t1+4]:ebp
;	p0 = [p0+4]:esi
;	p1 = [p1+4]:edi

	MULT	ebp, dword ptr [t1+4], esi, dword ptr [p0+4], x0	;m0 = p0 * t1
	MULT	ebp, dword ptr [t1+4], edi, dword ptr [p1+4], x1	;m1 = p1 * t1
	MULT	ebx, dword ptr [t0+4], edi, dword ptr [p1+4], x2	;m2 = p1 * t0
	MULT	ebx, dword ptr [t0+4], esi, dword ptr [p0+4], x3	;m3 = p0 * t0

;	x3 += ((x0&x1&x2&x3 + C0) ^ x0&x1&x2&x3) &x0&x1&x2 + m3
;	x2 += ((x0&x1&x2&x3 + C0) ^ x0&x1&x2&x3) &x0&x1 + m2
;	x1 += ((x0&x1&x2&x3 + C0) ^ x0&x1&x2&x3) &x0 + m1
;	x0 += ((x0&x1&x2&x3 + C0) ^ x0&x1&x2&x3) + m0;


	mov	ebp, dword ptr [_a+12]
	mov	ebx, dword ptr [_a+8]
	mov	ecx, ebp
	mov	eax, dword ptr [_a]
	shld	ebp, ebx, 29
	shr	ecx, 3
	shl	ebx, 29
	mov	edx, dword ptr [_a+4]
	or	ebx, ecx
			;ebp:ebx = (b.v << 29)|(b.v >> 35)
	add	ebx, dword ptr [x1+4]
	adc	ebp, dword ptr [x3+4]
			;ebp:ebx = (b.v << 29)|(b.v >> 35) + x3_HI:x1_HI
	xor	eax, dword ptr [x0+4]
	xor	edx, dword ptr [x2+4]
			;edx:eax = a ^ x2_HI:x0_HI
	mov	dword ptr [_a+ 8], eax
	mov	dword ptr [_a+12], edx
			;b = a ^ x2_HI:x0_HI
	add	ebx, eax
	adc	ebp, edx
	mov	dword ptr [_a], ebx
	mov	dword ptr [_a+4], ebp
			;a = b + (a ^ x2_HI:x0_HI)
	ret

OPTION PROLOGUE:DEFAULT
OPTION EPILOGUE:DEFAULT