comment *

Algo	: MAGENTA by Deutche Telekom
Block	: 16 bytes
Key	: 16 / 24 / 32 bytes (128 / 192 / 256 bits)

	call	MAGENTA_InitSbox		;init sbox.. constant 256 bytes

	push	offset key
	call	MAGENTA_SetKey			;set the password

	push	offset plain			;offset of block of data to encrypt
	push	offset cipher			;offset of buffer for encrypted block
	call	MAGENTA_Encrypt

	push	offset cipher			;offset of block of encrypted data
	push	offset cipher			;offset of buffer for decrypted block
	call	MAGENTA_Decrypt

	call	MAGENTA_Clear			;clear internal data

	call	MAGENTA_DestroySbox		;clear sbox

18.03.2003 WiteG//xtreeme (witeg@poczta.fm, www.witeg.prv.pl)
*

; ---------------------------------------------------------------------------
; You should set key size (KEY_SIZE)
; ---------------------------------------------------------------------------

KEY_SIZE	equ	128		; 128, 192 or 256

; ---------------------------------------------------------------------------

MAGENTA_ROUND	MACRO	BLOCK_0, BLOCK_1, KEY

	mov	dword ptr [esi   ], ecx
	mov	dword ptr [esi+ 4], edx
	mov	ecx, dword ptr [MAGENTA_internalKey+8*KEY]
	mov	edx, dword ptr [MAGENTA_internalKey+8*KEY+4]
	mov	dword ptr [esi+ 8], ecx
	mov	dword ptr [esi+12], edx

	call	@pi_function
	xchg	esi, edi
	call	@pi_function
	xchg	esi, edi
	call	@pi_function
	xchg	esi, edi
	call	@pi_function
	xchg	esi, edi
	call	@permutate

	mov	ecx, dword ptr [edi]
	mov	edx, dword ptr [edi+4]
	xor	ecx, dword ptr [ebp+BLOCK_1*8]
	xor	edx, dword ptr [ebp+BLOCK_1*8+4]
	mov	dword ptr [esi], ecx
	mov	dword ptr [esi+4], edx

	mov	ecx, dword ptr [MAGENTA_internalKey+8*KEY]
	mov	edx, dword ptr [MAGENTA_internalKey+8*KEY+4]
	xor	ecx, dword ptr [edi+8]
	xor	edx, dword ptr [edi+12]
	mov	dword ptr [esi+8], ecx
	mov	dword ptr [esi+12], edx

	call	@pi_function
	xchg	esi, edi
	call	@pi_function
	xchg	esi, edi
	call	@pi_function
	xchg	esi, edi
	call	@pi_function
	xchg	esi, edi
	call	@permutate

	mov	ecx, dword ptr [edi]
	mov	edx, dword ptr [edi+4]
	xor	ecx, dword ptr [ebp+BLOCK_1*8]
	xor	edx, dword ptr [ebp+BLOCK_1*8+4]
	mov	dword ptr [esi], ecx
	mov	dword ptr [esi+4], edx

	mov	ecx, dword ptr [MAGENTA_internalKey+8*KEY]
	mov	edx, dword ptr [MAGENTA_internalKey+8*KEY+4]
	xor	ecx, dword ptr [edi+8]
	xor	edx, dword ptr [edi+12]
	mov	dword ptr [esi+8], ecx
	mov	dword ptr [esi+12], edx

	call	@pi_function
	xchg	esi, edi
	call	@pi_function
	xchg	esi, edi
	call	@pi_function
	xchg	esi, edi
	call	@pi_function
	xchg	esi, edi
	call	@half_permutate		;we don't need full permutation !

	mov	ecx, dword ptr [edi]
	mov	edx, dword ptr [edi+4]
	xor	ecx, dword ptr [ebp+BLOCK_0*8]
	xor	edx, dword ptr [ebp+BLOCK_0*8+4]
	mov	dword ptr [ebp+BLOCK_0*8], ecx
	mov	dword ptr [ebp+BLOCK_0*8+4], edx
ENDM

.code
OPTION PROLOGUE:None		;we don't want prologue
OPTION EPILOGUE:None		;and epilogue code this time

MAGENTA_InitSbox	proc
	push	eax
	push	edi
	cld
	xor	eax, eax
	inc	eax
	mov	edi, offset MAGENTA_Sbox
@loop:	stosb
	shl	al, 1
	jnc	@F
	xor	al, 65h
@@:	dec	ah
	jnz	@loop
	and	byte ptr [edi-1], 0

	pop	eax
	pop	edi
	ret
MAGENTA_InitSbox	endp

MAGENTA_DestroySbox	proc
	push	ecx
	mov	ecx, 256-4
@@:	and	dword ptr [MAGENTA_Sbox+ecx],0
	sub	ecx, 4
	jns	@B
	pop	ecx
	ret
MAGENTA_DestroySbox	endp

MAGENTA_Clear	proc
	push	ecx
	
IF	(KEY_SIZE eq 128) OR (KEY_SIZE eq 192)
	mov	ecx, (20-1)*4
ELSEIF	KEY_SIZE eq 256
	mov	ecx, (24-1)*4
ENDIF	
@@:	and	dword ptr [MAGENTA_internalKey+ecx],0
	sub	ecx, 4
	jns	@B
	pop	ecx
	ret
MAGENTA_Clear	endp

MAGENTA_SetKey	proc	arg1:DWORD
	pushad
	mov	esi, dword ptr [esp+ 24h]
	mov	edi, offset MAGENTA_internalKey

IF	KEY_SIZE eq 128

	mov	eax, dword ptr [esi   ]
	mov	ebx, dword ptr [esi+ 4]

	mov	dword ptr [edi   ], eax
	mov	dword ptr [edi+ 4], ebx
	mov	dword ptr [edi+ 8], eax
	mov	dword ptr [edi+12], ebx

	mov	dword ptr [edi+32], eax
	mov	dword ptr [edi+36], ebx
	mov	dword ptr [edi+40], eax
	mov	dword ptr [edi+44], ebx

	mov	eax, dword ptr [esi+ 8]
	mov	ebx, dword ptr [esi+12]

	mov	dword ptr [edi+16], eax
	mov	dword ptr [edi+20], ebx
	mov	dword ptr [edi+24], eax
	mov	dword ptr [edi+28], ebx

ELSEIF	KEY_SIZE eq 192

	mov	eax, dword ptr [esi   ]
	mov	ebx, dword ptr [esi+ 4]
	mov	ecx, dword ptr [esi+ 8]
	mov	edx, dword ptr [esi+12]

	mov	dword ptr [edi   ], eax
	mov	dword ptr [edi+ 4], ebx
	mov	dword ptr [edi+ 8], ecx
	mov	dword ptr [edi+12], edx

	mov	dword ptr [edi+32], ecx
	mov	dword ptr [edi+36], edx
	mov	dword ptr [edi+40], eax
	mov	dword ptr [edi+44], ebx

	mov	eax, dword ptr [esi+16]
	mov	ebx, dword ptr [esi+20]

	mov	dword ptr [edi+16], eax
	mov	dword ptr [edi+20], ebx
	mov	dword ptr [edi+24], eax
	mov	dword ptr [edi+28], ebx
            
ELSEIF	KEY_SIZE eq 256

	mov	eax, dword ptr [esi   ]
	mov	ebx, dword ptr [esi+ 4]
	mov	ecx, dword ptr [esi+ 8]
	mov	edx, dword ptr [esi+12]

	mov	dword ptr [edi   ], eax
	mov	dword ptr [edi+ 4], ebx
	mov	dword ptr [edi+ 8], ecx
	mov	dword ptr [edi+12], edx

	mov	dword ptr [edi+48], ecx
	mov	dword ptr [edi+52], edx
	mov	dword ptr [edi+56], eax
	mov	dword ptr [edi+60], ebx

	mov	eax, dword ptr [esi+16]
	mov	ebx, dword ptr [esi+20]
	mov	ecx, dword ptr [esi+24]
	mov	edx, dword ptr [esi+28]

	mov	dword ptr [edi+16], eax
	mov	dword ptr [edi+20], ebx
	mov	dword ptr [edi+24], ecx
	mov	dword ptr [edi+28], edx

	mov	dword ptr [edi+32], ecx
	mov	dword ptr [edi+36], edx
	mov	dword ptr [edi+40], eax
	mov	dword ptr [edi+44], ebx

ENDIF
	popad
	ret	4
MAGENTA_SetKey	endp

MAGENTA_Encrypt	proc	arg1:DWORD, arg2:DWORD

	pushad
	mov	esi, dword ptr [esp+ 28h]		; offset plain
	mov	edi, dword ptr [esp+ 24h]		; offset cipher

	mov	eax, dword ptr [esi   ]
	mov	ebx, dword ptr [esi+ 4]
	mov	ecx, dword ptr [esi+ 8]
	mov	edx, dword ptr [esi+12]

	mov	dword ptr [edi   ], eax
	mov	dword ptr [edi+ 4], ebx
	mov	dword ptr [edi+ 8], ecx
	mov	dword ptr [edi+12], edx

	call	@magenta_core

	popad
	ret	8
MAGENTA_Encrypt	endp

MAGENTA_Decrypt	proc	arg1:DWORD, arg2:DWORD

	pushad
	mov	esi, dword ptr [esp+ 28h]		; offset plain
	mov	edi, dword ptr [esp+ 24h]		; offset cipher

	mov	ecx, dword ptr [esi   ]
	mov	edx, dword ptr [esi+ 4]
	mov	eax, dword ptr [esi+ 8]
	mov	ebx, dword ptr [esi+12]

	mov	dword ptr [edi   ], eax
	mov	dword ptr [edi+ 4], ebx
	mov	dword ptr [edi+ 8], ecx
	mov	dword ptr [edi+12], edx

	call	@magenta_core

	mov	eax, dword ptr [ebp   ]
	mov	ebx, dword ptr [ebp+ 4]
	mov	ecx, dword ptr [ebp+ 8]
	mov	edx, dword ptr [ebp+12]

	mov	dword ptr [ebp   ], ecx
	mov	dword ptr [ebp+ 4], edx
	mov	dword ptr [ebp+ 8], eax
	mov	dword ptr [ebp+12], ebx

	popad
	ret	8
MAGENTA_Decrypt	endp

@magenta_core:
	mov	ebx, offset MAGENTA_Sbox
	mov	ebp, edi
	mov	esi, offset MAGENTA_tempData_1
	mov	edi, offset MAGENTA_tempData_2

	MAGENTA_ROUND	0,1,0
	MAGENTA_ROUND	1,0,1
	MAGENTA_ROUND	0,1,2
	MAGENTA_ROUND	1,0,3
	MAGENTA_ROUND	0,1,4
	MAGENTA_ROUND	1,0,5

IF	KEY_SIZE eq 256
	MAGENTA_ROUND	0,1,6
	MAGENTA_ROUND	1,0,7
ENDIF
	ret

@pi_function:

	mov	edx, dword ptr [esi]
	mov	ecx, dword ptr [esi+8]

	mov	al, dh
	xlatb
	xor	al, ch
	xlatb
	shl	eax, 8
	mov	al, ch
	xlatb
	xor	al, dh
	xlatb
	shl	eax, 8
	mov	al, dl
	xlatb
	xor	al, cl
	xlatb
	shl	eax, 8
	mov	al, cl
	xlatb
	xor	al, dl
	xlatb

	mov	dword ptr [edi], eax

	rol	ecx, 16
	rol	edx, 16

	mov	al, dh
	xlatb
	xor	al, ch
	xlatb
	shl	eax, 8
	mov	al, ch
	xlatb
	xor	al, dh
	xlatb
	shl	eax, 8
	mov	al, dl
	xlatb
	xor	al, cl
	xlatb
	shl	eax, 8
	mov	al, cl		
	xlatb
	xor	al, dl
	xlatb

	mov	dword ptr [edi+4], eax
	
	mov	edx, dword ptr [esi+4]
	mov	ecx, dword ptr [esi+12]

	mov	al, dh
	xlatb
	xor	al, ch
	xlatb
	shl	eax, 8
	mov	al, ch
	xlatb
	xor	al, dh
	xlatb
	shl	eax, 8
	mov	al, dl
	xlatb
	xor	al, cl
	xlatb
	shl	eax, 8
	mov	al, cl
	xlatb
	xor	al, dl
	xlatb

	mov	dword ptr [edi+8], eax

	rol	ecx, 16
	rol	edx, 16

	mov	al, dh
	xlatb
	xor	al, ch
	xlatb
	shl	eax, 8
	mov	al, ch
	xlatb
	xor	al, dh
	xlatb
	shl	eax, 8
	mov	al, dl
	xlatb
	xor	al, cl
	xlatb
	shl	eax, 8
	mov	al, cl		
	xlatb
	xor	al, dl
	xlatb

	mov	dword ptr [edi+12], eax
	ret

@permutate:
	mov	edx, dword ptr [esi]
	mov	ecx, dword ptr [esi+4]

	shld	eax, ecx, 16
	mov	al, ch
	shld	eax, edx, 16
	mov	al, dh

	mov	dword ptr [edi+8], eax

    	shl	edx, 8    
	shld	eax, ecx, 24
	mov	al, cl
	shld	eax, edx, 16
	mov	al, dh

	mov	dword ptr [edi], eax

	mov	edx, dword ptr [esi+8]
	mov	ecx, dword ptr [esi+12]
	
	shld	eax, ecx, 16
	mov	al, ch
	shld	eax, edx, 16
	mov	al, dh

	mov	dword ptr [edi+12], eax

    	shl	edx, 8    
	shld	eax, ecx, 24
	mov	al, cl
	shld	eax, edx, 16
	mov	al, dh

	mov	dword ptr [edi+4], eax
	ret

@half_permutate:
	mov	edx, dword ptr [esi]
	mov	ecx, dword ptr [esi+4]

    	shl	edx, 8    
	shld	eax, ecx, 24
	mov	al, cl
	shld	eax, edx, 16
	mov	al, dh

	mov	dword ptr [edi], eax

	mov	edx, dword ptr [esi+8]
	mov	ecx, dword ptr [esi+12]
	
    	shl	edx, 8    
	shld	eax, ecx, 24
	mov	al, cl
	shld	eax, edx, 16
	mov	al, dh

	mov	dword ptr [edi+4], eax
	ret

OPTION EPILOGUE:EPILOGUEDEF
OPTION PROLOGUE:PROLOGUEDEF	;but on exit set it to default

.data?
MAGENTA_Sbox	db 256 dup (?)

IF	(KEY_SIZE eq 128) OR (KEY_SIZE eq 192)
	MAGENTA_internalKey	dd 12 dup (?)
ELSEIF	KEY_SIZE eq 256
	MAGENTA_internalKey	dd 16 dup (?)
ENDIF	

MAGENTA_tempData_1	dd  4 dup (?)
MAGENTA_tempData_2	dd  4 dup (?)
