comment %

Algo	: LOKI89 (by Lawrence Brown)
Block	: 8 bytes
Key	: 8 bytes (64 bits)

	push	offset key
	push	offset plain
	push	offset cipher
	call	Loki_Encrypt

	push	offset key
	push	offset cipher
	push	offset cipher
	call	Loki_Decrypt


05.05.2002 WiteG//xtreeme (witeg@poczta.fm, www.witeg.prv.pl)

%

.data?
_rounds		dd ?
_esp		dd ?

.code
Loki_Encrypt	proc	ptrOut:DWORD, ptrIn:DWORD, ptrPass:DWORD
	pushad
	mov	dword ptr [_esp], esp
	mov	esi, ptrPass
	mov	edi, ptrIn
	mov	ebp, dword ptr [esi]		;KL
	mov	esp, dword ptr [esi+4]		;KR
	mov	ecx, dword ptr [edi]		;L
	mov	ebx, dword ptr [edi+4]		;R
	xor	ecx, ebp
	xor	ebx, esp
	cld
	mov	dword ptr [_rounds], 16

@@round:
	mov	eax, ebx
	xor	eax, ebp			;a = KL^R

	mov	edi, eax
	shr	edi, 16
	and	edi, 0FFFh
	rol	eax, 8
	mov	dl, byte ptr [loki_box+edi]
	mov	edi, eax
	and	edi, 0FFFh
	ror	eax, 8
	mov	dh, byte ptr [loki_box+edi]
	mov	edi, eax
	shl	edx, 16
	shr	edi, 8
	and	edi, 0FFFh
	and	eax, 0FFFh
	mov	dh, byte ptr [loki_box+edi]
	mov	dl, byte ptr [loki_box+eax]
	xor	edi, edi
	xor	eax, eax
	mov	esi, offset perm_order
@@:
	lodsb
	bt	edx, eax
	rcl	edi, 1
	test	al, al
	jnz	@B

	xor	ecx, edi
	rol	ebp, 12

	xchg	ebx, ecx
	xchg	ebp, esp

	dec	dword ptr [_rounds]
	jnz	@@round

	xor	ebx, esp
	xor	ecx, ebp
	mov	esp, dword ptr [_esp]
	mov	ebp, [esp + 8]
	mov	edi, ptrOut
	and	dword ptr [_esp], 0
	mov	dword ptr [edi], ebx
	mov	dword ptr [edi+4], ecx
	popad
	ret
Loki_Encrypt	endp

Loki_Decrypt	proc	ptrOut:DWORD, ptrIn:DWORD, ptrPass:DWORD

	pushad
	mov	dword ptr [_esp], esp
	mov	esi, ptrPass
	mov	edi, ptrIn
	mov	ebp, dword ptr [esi]		;KL
	mov	esp, dword ptr [esi+4]		;KR
	mov	ecx, dword ptr [edi]		;L
	mov	ebx, dword ptr [edi+4]		;R

	xor	ecx, esp			;L
	xor	ebx, ebp			;R
	cld
	mov	dword ptr [_rounds], 16

@@round:
	ror	esp, 12

	mov	eax, ebx
	xor	eax, esp			;a = KL^R

	mov	edi, eax
	shr	edi, 16
	and	edi, 0FFFh
	rol	eax, 8
	mov	dl, byte ptr [loki_box+edi]
	mov	edi, eax
	and	edi, 0FFFh
	ror	eax, 8
	mov	dh, byte ptr [loki_box+edi]
	mov	edi, eax
	shl	edx, 16
	shr	edi, 8
	and	edi, 0FFFh
	and	eax, 0FFFh
	mov	dh, byte ptr [loki_box+edi]
	mov	dl, byte ptr [loki_box+eax]
	xor	edi, edi
	xor	eax, eax
	mov	esi, offset perm_order
@@:
	lodsb
	bt	edx, eax
	rcl	edi, 1
	test	al, al
	jnz	@B

	xor	ecx, edi
	xchg	ebx, ecx
	xchg	ebp, esp
	dec	dword ptr [_rounds]
	jnz	@@round

	xor	ebx, ebp
	xor	ecx, esp

	mov	esp, dword ptr [_esp]
	mov	ebp, [esp + 8]
	mov	edi, ptrOut
	and	dword ptr [_esp], 0
	mov	dword ptr [edi], ebx
	mov	dword ptr [edi+4], ecx
	popad
	ret
Loki_Decrypt	endp

.data
loki_box	db 000h,001h,0cdh,009h,001h,000h,089h,00dh,01dh,0d5h,000h,001h,0c4h,0bfh,001h,000h
		db 026h,09eh,062h,0c3h,02dh,0e7h,02eh,065h,0e2h,007h,0f6h,041h,0beh,006h,03bh,051h
		db 077h,0ddh,01bh,0fah,02fh,07bh,052h,05bh,0b8h,0c1h,0edh,0f7h,0edh,008h,09fh,08bh
		db 095h,0abh,004h,0d4h,018h,00fh,086h,0edh,0dch,07ah,0e4h,0d1h,0cbh,0b0h,098h,044h
		db 0bfh,071h,0adh,03ah,0fah,076h,093h,022h,082h,013h,0a1h,058h,055h,012h,057h,0d3h
		db 092h,015h,05bh,075h,0f7h,014h,08fh,073h,02eh,036h,04ch,0b3h,0afh,024h,0c1h,0f9h
		db 02ah,09fh,047h,0e8h,029h,0a4h,03eh,027h,04fh,057h,018h,098h,034h,0c5h,019h,062h
		db 0adh,0aeh,0fch,01fh,06fh,043h,053h,01eh,059h,0e6h,03ah,08dh,07ah,0c9h,05ch,080h
		db 0c1h,0dah,0ach,0d6h,002h,0d7h,0d8h,0eeh,0dah,0dch,041h,0e7h,074h,067h,0d5h,03dh
		db 0deh,081h,0e3h,054h,033h,02dh,0b9h,089h,0bch,03ah,00fh,07ch,085h,092h,023h,031h
		db 079h,080h,0b8h,0e9h,0a6h,022h,069h,040h,05bh,0afh,0e0h,0f4h,042h,09dh,061h,064h
		db 09fh,01dh,045h,0b8h,0a0h,05ah,017h,094h,066h,0b5h,0e2h,00fh,091h,077h,0a2h,0bah
		db 0ebh,0b1h,051h,005h,00dh,061h,078h,014h,0cch,0bch,09ch,0fch,017h,0b7h,016h,067h
		db 0c9h,0edh,0ech,06ch,036h,02eh,08eh,0b9h,0eah,0feh,044h,061h,0efh,038h,04eh,008h
		db 05ch,048h,008h,0dch,021h,01ah,0ceh,0fdh,0f0h,0d9h,0d6h,0cbh,02ch,070h,003h,0ach
		db 020h,0ffh,096h,011h,007h,030h,012h,09bh,03eh,0e5h,084h,09ah,03fh,0c4h,02dh,096h
		db 08bh,0deh,06ah,045h,0feh,003h,0c4h,0f2h,03ah,026h,063h,099h,0b5h,0a2h,0a8h,0aah
		db 0e3h,0f5h,0e9h,0fbh,0c7h,040h,083h,004h,098h,02fh,0c2h,0c8h,0b2h,0adh,05eh,097h
		db 097h,0e8h,087h,0bfh,0a4h,0f1h,01ch,0f1h,0b9h,0e0h,09eh,071h,027h,084h,05ah,0f6h
		db 0e6h,08eh,0ddh,00ah,00fh,016h,0b0h,0b2h,08dh,050h,0f2h,010h,022h,069h,07eh,0c9h
		db 019h,08ch,034h,0bbh,037h,055h,005h,035h,093h,0c7h,022h,03ch,028h,03bh,0bdh,049h
		db 01ah,002h,040h,0eah,078h,0b2h,0f3h,0b4h,048h,035h,010h,02dh,0a7h,0cfh,06eh,056h
		db 0f8h,0fah,091h,082h,090h,099h,039h,04bh,0ddh,096h,03fh,01ah,099h,089h,08ah,025h
		db 005h,044h,002h,07fh,0d8h,068h,011h,03fh,05eh,017h,059h,088h,05fh,0f6h,038h,048h
		db 060h,097h,0cfh,078h,061h,04fh,082h,05dh,081h,08ah,07dh,0e3h,0ffh,0fch,050h,05eh
		db 00ah,082h,065h,0feh,011h,0f3h,0bch,039h,0f4h,0e9h,08bh,04ah,00ch,05dh,07bh,0e4h
		db 063h,058h,0fdh,020h,058h,04bh,04bh,070h,0d0h,06bh,094h,069h,072h,06ah,07ch,068h
		db 07dh,06dh,088h,08ah,0ceh,06ch,066h,021h,014h,087h,06ch,0a5h,012h,0f8h,06dh,032h
		db 049h,01eh,0d0h,0d2h,01bh,039h,0f0h,085h,024h,0ebh,0bah,042h,07bh,0b4h,08ch,0dbh
		db 008h,094h,026h,077h,0a1h,0d8h,080h,076h,0a5h,02ch,074h,0bch,0f6h,018h,075h,050h
		db 039h,079h,0d4h,0f3h,0e7h,078h,007h,00eh,053h,052h,0e1h,081h,080h,047h,05dh,052h
		db 038h,0efh,0f5h,06dh,04eh,091h,03ch,0ddh,025h,07fh,014h,006h,0eeh,07eh,0dah,003h
		db 02bh,07dh,0f8h,0afh,054h,0bah,0beh,019h,0aeh,021h,029h,013h,045h,0a8h,037h,0f5h
		db 04ch,00ch,04fh,036h,006h,06eh,0eeh,06fh,013h,0c6h,090h,0d5h,0a2h,05fh,055h,01bh
		db 088h,0beh,015h,038h,089h,0a0h,030h,092h,0c5h,075h,068h,0c7h,0f5h,056h,071h,05fh
		db 0abh,011h,00bh,0b5h,015h,0cah,033h,07eh,040h,054h,09bh,0cch,0d5h,0f4h,0b1h,034h
		db 010h,064h,02fh,0cfh,08ch,05ch,01fh,0a0h,0a9h,028h,060h,0a6h,094h,0dfh,0bfh,02fh
		db 08fh,01fh,0a6h,0ebh,0c6h,031h,08dh,01ch,06ah,09ah,031h,06eh,084h,0cbh,0dch,00ch
		db 0e1h,0b9h,042h,0cdh,0fbh,027h,0a4h,0d0h,0bbh,085h,0d7h,0d9h,0dbh,020h,06fh,09fh
		db 065h,0a5h,064h,066h,0aah,05bh,097h,072h,003h,062h,01eh,093h,032h,088h,0a9h,04dh
		db 052h,0f9h,0e7h,05ch,08ah,03dh,0c9h,0a7h,0cdh,066h,04ah,03bh,096h,025h,076h,033h
		db 064h,04ah,0f7h,08ch,05ah,0d6h,0f9h,028h,0d1h,0bbh,085h,0aeh,047h,02bh,0fah,0c2h
		db 075h,0ceh,0aah,060h,0ech,046h,0abh,07ah,004h,0dbh,0e8h,0a9h,03ch,005h,058h,0a8h
		db 09ah,0eah,01ah,087h,04ah,03fh,072h,0a3h,08eh,083h,0aeh,0b1h,00eh,0cdh,0d3h,063h
		db 0e0h,08fh,0b2h,007h,035h,0b8h,0b3h,0a2h,043h,00bh,021h,06bh,0a3h,0f2h,0b6h,012h
		db 0b0h,0e3h,006h,0b7h,041h,090h,077h,0b6h,0b6h,045h,0feh,053h,0b7h,01ch,067h,029h
		db 069h,072h,0cbh,037h,0cfh,0e4h,0c3h,0c4h,0d9h,009h,0ffh,04fh,01eh,0aah,0d9h,03eh
		db 073h,04dh,025h,02ah,067h,0ech,0bbh,0e6h,06eh,0c2h,01dh,0abh,0f3h,098h,035h,0b0h
		db 04bh,0b6h,046h,0e0h,057h,004h,0c8h,0c6h,056h,053h,092h,0c1h,09eh,0a3h,0cch,0c0h
		db 0f9h,0a1h,0c6h,043h,071h,0fdh,0c7h,0c5h,0b3h,095h,0ebh,0f0h,0cah,02ah,036h,0d7h
		db 0d2h,0bdh,0b5h,0ech,0c3h,059h,020h,024h,0bah,0d0h,07fh,084h,0c2h,03eh,073h,0e5h
		db 07ch,086h,02ah,0a4h,0c8h,029h,02ch,047h,09ch,037h,00eh,0dah,016h,060h,0a3h,09eh
		db 06ch,0c0h,05fh,06ah,01ch,00eh,0e5h,018h,03dh,074h,009h,05ah,01fh,09ch,028h,015h
		db 031h,0a9h,00ah,090h,03bh,0e1h,056h,02bh,0d6h,093h,049h,08fh,0d7h,05eh,032h,0adh
		db 06dh,09bh,07ah,0efh,062h,0eeh,081h,0beh,030h,01bh,0b7h,0e2h,07fh,051h,00ch,0e1h
		db 0d3h,0d2h,0deh,0dfh,051h,0f7h,0dfh,0deh,09dh,00dh,0afh,07dh,083h,08bh,04dh,026h
		db 087h,034h,095h,04eh,0ach,0d3h,079h,04ch,068h,0fbh,00dh,091h,0a8h,033h,0b4h,055h
		db 04dh,0c8h,0cah,079h,0b1h,049h,09ah,030h,023h,0f0h,09dh,074h,00bh,065h,043h,095h
		db 0e8h,0e2h,0e6h,0cah,0e9h,0a7h,027h,00bh,0c0h,023h,02bh,002h,0dfh,019h,0fbh,086h
		db 0b4h,0b3h,0dbh,09dh,07eh,03ch,099h,08eh,046h,063h,070h,023h,070h,04eh,013h,083h
		db 06bh,0d4h,0c5h,057h,0e5h,0cch,0d1h,0a1h,0fch,042h,0efh,0f8h,09bh,073h,0a5h,09ch
		db 0f2h,0a6h,0eah,0ffh,086h,010h,054h,016h,0e4h,041h,0a7h,059h,0bdh,08dh,024h,046h
		db 076h,04ch,0f4h,0bdh,044h,0ach,0a0h,02eh,0d4h,00ah,0d2h,01dh,05dh,06fh,0c0h,017h
		db 050h,032h,0f1h,0ceh,0f1h,0c3h,06bh,02ch,009h,0d1h,03dh,0d8h,0fdh,07ch,048h,07bh
		db 018h,0a4h,0efh,0f2h,0e7h,025h,0cdh,00eh,047h,0cfh,0c3h,03ch,05dh,067h,017h,059h
		db 000h,001h,0b7h,058h,001h,000h,044h,0a0h,0f9h,0bdh,000h,001h,02ah,0e3h,001h,000h
		db 0eah,046h,025h,068h,040h,0e1h,056h,048h,006h,078h,083h,06dh,051h,0beh,0beh,064h
		db 093h,091h,0a7h,074h,0b4h,083h,0b5h,042h,00ah,02eh,0a3h,0b9h,00bh,016h,07dh,0aeh
		db 00eh,0a8h,00eh,037h,0c7h,082h,06eh,009h,0f7h,0a2h,027h,021h,0dch,0c2h,04ah,054h
		db 0cdh,07ah,0a5h,006h,0c1h,0cch,042h,04ah,0fch,071h,01eh,0a6h,080h,0fch,0b6h,03dh
		db 081h,013h,0c6h,003h,0a3h,0ddh,048h,0c1h,089h,0bah,0e5h,022h,075h,07bh,067h,04bh
		db 07ch,079h,006h,01bh,079h,07ch,0edh,01ah,092h,052h,075h,084h,0c4h,0d0h,0f2h,04ch
		db 01fh,069h,01bh,05ch,0d2h,0bfh,089h,092h,0a9h,093h,0eah,0fch,025h,063h,0b9h,0a2h
		db 04dh,0a9h,074h,0cdh,007h,004h,00ch,0cbh,0c2h,023h,062h,0e8h,0e2h,022h,061h,0e2h
		db 0e8h,03ch,03bh,08ah,041h,014h,02ah,0fdh,056h,0dfh,086h,0a5h,0a1h,0fdh,02fh,056h
		db 0f0h,0b0h,069h,02bh,0e6h,02fh,0bch,02ah,043h,0c7h,028h,046h,072h,05fh,029h,083h
		db 034h,06dh,04eh,09bh,035h,024h,098h,0fah,0c5h,095h,0f4h,079h,0adh,00bh,02ch,05ah
		db 0b6h,017h,09bh,077h,098h,0c9h,0abh,0a8h,0b1h,09fh,0d7h,031h,0c3h,098h,01ch,030h
		db 021h,0edh,0a4h,0b4h,0b7h,0c1h,0e9h,049h,03eh,087h,02dh,0c0h,03fh,06fh,08fh,0ceh
		db 050h,0c8h,0feh,0ffh,0abh,08eh,0a2h,063h,066h,01ch,03ch,0bbh,09eh,0d3h,008h,002h
		db 044h,089h,04bh,093h,045h,08bh,051h,043h,00dh,07dh,060h,033h,0bah,068h,0c7h,0d1h
		db 0e4h,029h,00ah,0c3h,052h,0b2h,016h,012h,078h,08ah,070h,0b1h,012h,0bch,09ch,00dh
		db 068h,034h,0cah,05dh,023h,053h,095h,075h,04eh,0f3h,0ech,013h,04fh,0a5h,031h,07fh
		db 0ebh,0aah,045h,0abh,03bh,03eh,0c5h,02ch,0a6h,09ch,00dh,081h,0f8h,0f1h,0cch,0b0h
		db 014h,048h,0cbh,0b3h,097h,0a1h,022h,035h,046h,039h,078h,0cah,038h,045h,0b0h,095h
		db 090h,05eh,0aeh,0c2h,01bh,021h,05fh,02fh,0f3h,0c6h,019h,0dbh,0dfh,0cdh,082h,09ah
		db 0f1h,05dh,0d4h,088h,0c9h,05ch,024h,0cch,019h,059h,087h,0bfh,0dbh,0d7h,0ebh,08ch
		db 003h,007h,05ah,096h,004h,0dbh,05bh,082h,06bh,0f6h,0fbh,047h,091h,0f2h,007h,06ah
		db 0fbh,051h,06ch,0deh,0d3h,0e4h,0b3h,040h,0bdh,01fh,0e3h,039h,0deh,0ech,076h,0afh
		db 083h,036h,0afh,044h,0cbh,055h,0b2h,06fh,03ah,03ah,07eh,045h,0d6h,061h,005h,0cfh
		db 03ch,075h,099h,0fbh,07fh,041h,011h,029h,096h,00ch,050h,097h,08ah,04eh,0ddh,0beh
		db 055h,0b7h,020h,07dh,0ech,060h,0d2h,024h,0ach,054h,06fh,0f5h,0b5h,043h,06ah,0e7h
		db 05ah,09dh,0a9h,09fh,042h,09eh,0e8h,065h,0bbh,03dh,0d0h,011h,0f6h,020h,068h,07eh
		db 070h,05ah,072h,0c9h,071h,066h,073h,0a3h,017h,032h,0c4h,069h,027h,0b6h,01fh,0e9h
		db 05bh,03bh,077h,0f8h,0d1h,01ah,0d9h,067h,0a2h,07fh,05dh,03fh,057h,07eh,0e6h,0ebh
		db 0b0h,0f7h,03eh,008h,049h,0aeh,0d3h,06eh,07ah,0e6h,097h,0d7h,07bh,035h,036h,00ah
		db 048h,085h,010h,080h,0e3h,084h,026h,027h,09dh,030h,0bfh,076h,0f4h,0d4h,091h,0ach
		db 08ch,077h,0a0h,0a1h,03dh,094h,01dh,0bch,00fh,070h,059h,032h,06eh,0cah,0e7h,02dh
		db 076h,08fh,085h,0c5h,026h,012h,071h,0dfh,00ch,0b3h,0deh,03bh,0ddh,02ah,0aah,0f4h
		db 06ch,0eeh,09ah,0c4h,009h,037h,040h,086h,095h,0f9h,0bdh,0c8h,02bh,06eh,09eh,08bh
		db 061h,027h,057h,0eeh,0b8h,015h,0fdh,0e6h,0e1h,0c4h,058h,0f0h,0c8h,056h,013h,007h
		db 085h,0bbh,092h,0feh,08fh,0abh,093h,073h,05ch,096h,0fch,00fh,0afh,006h,04fh,01ch
		db 062h,088h,065h,02eh,054h,0f5h,033h,0d5h,09bh,0adh,066h,08dh,088h,04ch,0f5h,0a9h
		db 0aah,080h,038h,0b7h,04ch,0e8h,049h,00ch,0cfh,0efh,0f9h,08eh,0beh,009h,0d8h,0b6h
		db 016h,08dh,003h,0d3h,022h,0e7h,064h,087h,0d0h,0a7h,0e2h,0b8h,073h,0a6h,018h,04eh
		db 04bh,00eh,0c2h,0e0h,08bh,031h,0f7h,094h,015h,072h,021h,0d4h,04ah,042h,0f1h,089h
		db 013h,076h,0a6h,0f9h,0aeh,06ah,0e4h,055h,0dah,064h,0d1h,091h,0a0h,0a3h,09fh,014h
		db 01ch,06ch,080h,026h,0ffh,047h,0b1h,071h,033h,018h,02bh,0a7h,0e9h,0c0h,05ch,04dh
		db 02ch,0dah,03ah,0b5h,0a4h,0afh,054h,004h,0b2h,038h,08dh,0efh,08eh,01dh,0d6h,03ah
		db 086h,0ffh,043h,070h,0bch,065h,07ch,08fh,0feh,0b9h,05eh,0dah,0d8h,008h,06dh,028h
		db 06ah,08ch,052h,015h,0eeh,02ch,081h,025h,02eh,0e5h,004h,041h,01dh,04ah,0eeh,0e3h
		db 069h,0f4h,0bah,098h,032h,01bh,0bbh,0d8h,0b3h,0ebh,04ch,06ch,0f2h,0f8h,0dbh,05eh
		db 0a5h,06bh,04dh,0c7h,063h,00ah,0ach,0c6h,058h,04bh,055h,07bh,036h,019h,012h,0f3h
		db 02fh,05bh,08eh,020h,0d9h,003h,0b4h,066h,0cch,01eh,0dfh,0d0h,0bfh,050h,041h,0aah
		db 074h,0a0h,0fah,072h,065h,0d6h,030h,04fh,029h,033h,0f6h,017h,05eh,09ah,00bh,0bdh
		db 067h,092h,0adh,034h,0e5h,02dh,0f3h,099h,05fh,04dh,0c8h,07ch,09ch,0b1h,0c9h,09dh
		db 06fh,0dch,0f0h,09eh,064h,081h,03fh,05fh,005h,097h,06bh,051h,010h,0e0h,088h,0f1h
		db 077h,0ach,002h,01dh,0d7h,0e9h,09dh,07ah,0fdh,04fh,08ch,0adh,0e0h,0c5h,035h,0d6h
		db 0cah,010h,053h,060h,06dh,02bh,0ffh,01eh,0a7h,058h,02eh,0ddh,099h,049h,0b8h,0dch
		db 024h,0d9h,0c1h,0bah,02dh,0d8h,039h,0a4h,030h,062h,032h,09ch,0fah,0d1h,034h,078h
		db 09ah,03fh,023h,062h,0c6h,026h,014h,038h,031h,09bh,094h,0e1h,01eh,0e2h,015h,010h
		db 039h,0ceh,0d5h,0eah,07dh,002h,0dch,061h,0c0h,099h,0e0h,0d9h,059h,0f0h,0e1h,0b2h
		db 0f5h,044h,0c0h,0e4h,028h,0d2h,07ah,052h,011h,028h,0a1h,0edh,08dh,011h,084h,0ech
		db 07eh,0deh,0cfh,050h,060h,00fh,07fh,0e5h,0edh,00dh,03dh,085h,0a8h,0b5h,096h,016h
		db 037h,086h,047h,0f7h,0d5h,0eah,00fh,0f6h,0ceh,057h,009h,023h,082h,074h,037h,053h
		db 002h,040h,07bh,036h,0b9h,0b4h,063h,019h,01ah,0c3h,0a8h,03eh,094h,0feh,079h,01fh
		db 09fh,005h,0f8h,018h,053h,090h,090h,057h,008h,0b8h,01ah,0d2h,0d4h,073h,08bh,005h
		db 087h,0d5h,046h,06bh,084h,0cbh,08ah,00bh,020h,0fbh,0ceh,090h,0efh,0fah,0dah,05bh
		db 07ah,0cbh,063h,0d4h,084h,0bdh,06dh,0fdh,053h,017h,069h,037h,0dfh,0f2h,05ah,042h
		db 0d9h,0bbh,0d3h,0ceh,022h,0ebh,0c5h,07ch,026h,0bch,056h,0d9h,0b0h,07dh,072h,0cbh
		db 000h,001h,04bh,0dah,001h,000h,0cch,050h,0f7h,05dh,000h,001h,0a5h,073h,001h,000h
		db 02eh,020h,009h,0a1h,0c7h,047h,08bh,091h,0f6h,01ah,028h,0a8h,071h,0c0h,04ah,016h
		db 054h,012h,030h,09dh,01dh,06eh,058h,061h,009h,03ah,0abh,05ah,089h,04eh,002h,0ach
		db 0b7h,070h,05fh,08bh,093h,032h,0fah,073h,094h,09eh,01ch,006h,04ah,0aah,01dh,092h
		db 043h,033h,059h,056h,088h,0d9h,006h,0c8h,057h,05fh,0cah,018h,007h,09ch,029h,0dbh
		db 02fh,0f9h,025h,009h,0fbh,086h,00eh,06fh,0b5h,01dh,041h,059h,010h,09dh,032h,034h
		db 08dh,08dh,0d8h,0c9h,036h,025h,05bh,097h,05dh,0e4h,0a3h,0f7h,0c1h,0f1h,0aah,038h
		db 0ddh,077h,064h,0cfh,0e5h,02bh,080h,081h,02bh,078h,0d0h,028h,092h,099h,003h,00fh
		db 004h,035h,022h,01bh,012h,003h,023h,0bch,024h,031h,070h,0e3h,028h,01eh,0c3h,0c1h
		db 091h,08eh,079h,08dh,03ch,058h,048h,039h,016h,027h,084h,0e1h,03dh,026h,0e3h,05ch
		db 082h,0e5h,083h,03fh,0adh,06dh,0f3h,02fh,06ah,07bh,0c8h,0f9h,08ah,0d2h,042h,03bh
		db 07ch,080h,03eh,068h,01bh,044h,03fh,0d7h,03eh,062h,0fdh,03dh,03fh,0beh,053h,03ch
		db 039h,05bh,096h,065h,006h,0deh,09ah,067h,0afh,005h,0a7h,00ah,040h,09fh,0a1h,072h
		db 03ah,09ah,0cfh,0d3h,019h,02ch,082h,095h,0d3h,0e9h,04eh,01ch,048h,08fh,0edh,0f1h
		db 035h,0b7h,052h,085h,0abh,0c2h,06ah,007h,00eh,0dah,0fch,049h,049h,0c7h,0e8h,048h
		db 0cah,0efh,0f5h,094h,0bbh,065h,0d5h,0f8h,0f9h,029h,0f0h,0beh,08bh,016h,0a0h,036h
		db 0beh,0c3h,026h,030h,0d1h,095h,0dfh,0a7h,074h,040h,0a6h,078h,052h,089h,0eah,0ddh
		db 0e8h,0a8h,0a9h,0c5h,079h,00ch,03bh,04ch,09bh,037h,0e2h,0fch,07dh,0f8h,0b6h,01fh
		db 0eah,03ch,0ddh,0a0h,0e9h,085h,0feh,00bh,05ah,0afh,0c1h,051h,05bh,036h,039h,0aeh
		db 033h,079h,013h,093h,02dh,05ah,07fh,023h,09dh,0fch,073h,0eah,086h,030h,04fh,0a6h
		db 06dh,081h,0ech,058h,013h,0f0h,057h,045h,09ch,053h,0bah,0adh,0bch,052h,020h,066h
		db 003h,094h,012h,017h,067h,013h,0a8h,00ch,0b2h,041h,0dch,077h,090h,068h,00bh,0e4h
		db 0efh,092h,036h,0b8h,02ah,061h,07ch,033h,011h,071h,08ch,06eh,0b9h,0cfh,09eh,06ah
		db 0c6h,0d5h,085h,0e0h,04fh,0b4h,03dh,010h,061h,06bh,0d4h,0b0h,08fh,088h,0e9h,044h
		db 047h,0b8h,02ch,09bh,06bh,0e7h,0c4h,071h,0e1h,076h,055h,0dfh,056h,057h,0b2h,06ch
		db 064h,0bfh,0a2h,004h,065h,0cdh,051h,07eh,0ach,0b6h,050h,0c4h,0c0h,002h,06eh,0deh
		db 0a2h,0ffh,00fh,02bh,0e6h,028h,06fh,0b9h,04eh,08ch,00ch,024h,0fah,0b2h,0bch,0e9h
		db 051h,087h,061h,0b5h,00ch,04ch,087h,070h,0a6h,0f7h,02ah,04fh,0ffh,04dh,094h,09fh
		db 0b6h,008h,07eh,069h,098h,04bh,010h,0bbh,03bh,022h,0e6h,0c2h,08eh,01bh,062h,096h
		db 068h,075h,068h,0afh,0dbh,074h,097h,019h,07bh,009h,0ceh,075h,0a0h,0a5h,0a4h,074h
		db 0deh,07fh,024h,07ah,05fh,093h,01fh,064h,0ebh,011h,019h,079h,0feh,0a2h,02bh,0c3h
		db 0a7h,0d1h,08eh,008h,09ah,082h,08fh,052h,055h,034h,031h,00eh,0d0h,06fh,046h,025h
		db 0b8h,03eh,004h,0f2h,078h,0c9h,0b8h,01dh,099h,0ach,01eh,087h,01fh,07eh,043h,0eeh
		db 06fh,06ch,0eeh,0a3h,0cfh,023h,049h,0b7h,0d8h,019h,00dh,0f3h,0c9h,059h,06bh,053h
		db 0d7h,072h,067h,0b1h,025h,0a9h,095h,0bfh,0f1h,0f4h,0b5h,099h,04bh,01fh,0deh,098h
		db 002h,0e0h,065h,031h,023h,0eeh,02dh,014h,08ch,0b3h,011h,015h,0d4h,063h,098h,0ebh
		db 034h,05ch,092h,0cdh,0c3h,00dh,093h,0fah,0dah,02fh,047h,07bh,0edh,0ddh,09ch,0aah
		db 02ch,006h,017h,0e8h,0fch,00fh,0fbh,029h,096h,097h,044h,0a2h,097h,096h,09dh,07fh
		db 0a8h,0a6h,0c0h,054h,0a9h,0ech,0bbh,0b3h,0ech,00ah,033h,0f6h,050h,0bah,060h,0d8h
		db 0cbh,05eh,07ah,040h,0ceh,049h,08ah,012h,0c2h,0d4h,0ach,0c6h,06eh,02ah,0adh,05eh
		db 07eh,0adh,074h,084h,042h,060h,05dh,022h,083h,0fah,0d6h,00dh,05ch,0c1h,016h,08eh
		db 0b1h,054h,0e0h,08ah,076h,0c6h,027h,0c7h,0e7h,0e1h,07dh,0a5h,014h,0b5h,0e5h,0a4h
		db 0d5h,0a7h,0c7h,0f5h,021h,024h,0bdh,026h,0d2h,0d3h,07bh,0e5h,09eh,043h,01ah,003h
		db 046h,07ah,089h,0f0h,0a3h,08bh,045h,06bh,008h,0feh,0e7h,088h,07fh,0f3h,04ch,02ah
		db 081h,0b1h,018h,080h,059h,0b0h,066h,046h,029h,0e8h,0b0h,03ah,01ch,018h,0b1h,0d2h
		db 015h,067h,0d1h,0abh,0f8h,01ch,0c9h,02ch,0e2h,038h,078h,027h,0f0h,046h,0e4h,021h
		db 044h,0cch,0f8h,063h,04dh,00bh,0b9h,002h,0b3h,007h,0d2h,09ah,017h,03fh,05ch,01eh
		db 0cch,083h,099h,0a9h,0cdh,0e6h,0ebh,08fh,045h,0a4h,0f1h,089h,00ah,0aeh,0beh,032h
		db 0bah,0f5h,0cbh,03eh,027h,0fdh,05eh,04eh,09fh,015h,076h,0dch,0a1h,0dbh,035h,0ffh
		db 0e4h,0c5h,014h,0e6h,031h,0c4h,0efh,0bah,066h,0d6h,086h,0cah,0eeh,045h,040h,09ch
		db 0a4h,09bh,0d9h,02eh,062h,048h,005h,041h,077h,0fbh,02eh,0bdh,0f5h,090h,091h,0f4h
		db 00dh,039h,0f7h,07dh,04ch,050h,077h,057h,032h,04ah,0b7h,04dh,038h,0dch,03ch,06dh
		db 0c8h,0ceh,04dh,0b6h,01eh,0d8h,06ch,05fh,0c4h,069h,0e1h,0d1h,0bdh,02dh,0b4h,0d0h
		db 0dch,0eah,054h,005h,06ch,0edh,09bh,090h,0aeh,04fh,037h,0feh,058h,0a1h,015h,047h
		db 037h,03dh,088h,04bh,020h,0a3h,007h,013h,00bh,004h,09fh,083h,069h,0d0h,090h,043h
		db 0b4h,08ah,01bh,05dh,01ah,042h,008h,082h,0bfh,0d7h,081h,0edh,0d6h,091h,075h,0ech
		db 075h,0f6h,00ah,05bh,072h,02eh,0dah,02dh,00fh,0e3h,0f6h,086h,085h,0e2h,0dbh,0b4h
		db 018h,0c8h,03ah,062h,060h,00eh,0bfh,020h,0c5h,055h,0c2h,08ch,087h,014h,0f4h,060h
		db 070h,098h,0c6h,0efh,063h,0cah,071h,0d5h,073h,064h,0ffh,011h,030h,056h,034h,035h
		db 05eh,0abh,021h,04ah,005h,0b9h,038h,09eh,0e3h,0a0h,0d7h,01ah,095h,084h,0cdh,0cch
		db 0e0h,03bh,0afh,0e2h,0fdh,010h,0f9h,055h,0f2h,06ah,0f2h,0e7h,0f3h,066h,0a5h,0d6h
		db 080h,07ch,0b3h,076h,041h,0dfh,0aeh,0fbh,0aah,051h,02fh,0b2h,0f4h,021h,08dh,0c0h
		db 08bh,0b3h,0efh,0f2h,016h,046h,0fdh,08fh,0a7h,07bh,017h,084h,0d6h,0fah,03ah,049h
		db 0d7h,035h,098h,0bah,07ch,0ddh,053h,050h,094h,030h,078h,092h,0d0h,0b5h,0d4h,0beh
		db 033h,03ah,061h,0a8h,052h,0adh,0a2h,062h,0aah,076h,0c9h,045h,01dh,08eh,037h,054h
		db 000h,001h,0d6h,00bh,001h,000h,09bh,00eh,04fh,08fh,000h,001h,075h,0c8h,001h,000h
		db 02eh,00eh,07dh,0e1h,05ch,0f1h,079h,065h,06fh,01ah,047h,034h,012h,041h,0bbh,096h
		db 0c0h,059h,013h,0ffh,0e7h,0ebh,0b0h,0f4h,077h,0dah,07ah,019h,021h,0ech,0d1h,018h
		db 0f9h,085h,0cfh,075h,086h,03bh,0a9h,073h,01ah,0d9h,0fch,0dfh,0e5h,011h,0c3h,086h
		db 020h,057h,082h,02eh,0b5h,0f0h,076h,030h,0e4h,007h,07bh,0b9h,04ch,043h,0a0h,04bh
		db 09dh,0fch,0b9h,0b1h,06dh,0c7h,01bh,083h,0b8h,0f3h,0a5h,0c6h,07ah,06ah,0f6h,0a7h
		db 050h,01ch,0f8h,0e3h,0ffh,07dh,06eh,010h,065h,02bh,0abh,0e2h,0d4h,02ah,092h,0e8h
		db 0f7h,05ah,06dh,00fh,097h,0b9h,036h,067h,0e2h,02eh,00dh,06ch,039h,01fh,0eah,0d3h
		db 004h,0c4h,0a4h,082h,0e6h,055h,016h,061h,0b2h,006h,0e6h,014h,049h,02ch,0e1h,004h
		db 037h,024h,0adh,055h,0f4h,0f4h,04ch,097h,09ch,04fh,03bh,08dh,089h,0abh,0ddh,063h
		db 070h,0b0h,083h,0d2h,03eh,09dh,0b3h,0ebh,0e0h,0edh,028h,0d1h,078h,03eh,014h,008h
		db 034h,017h,0d5h,07dh,035h,029h,068h,023h,04bh,028h,0ech,0f1h,0f6h,0efh,064h,041h
		db 018h,03ch,0c2h,029h,023h,036h,005h,09eh,026h,005h,030h,0bdh,002h,012h,031h,090h
		db 082h,0e5h,04eh,0f0h,022h,0f9h,04fh,05ah,048h,038h,04ah,02ah,079h,020h,0bch,07fh
		db 024h,049h,007h,037h,0c4h,048h,0b6h,01dh,028h,095h,08bh,0fch,0fbh,097h,08eh,058h
		db 088h,013h,0ach,026h,0feh,06dh,0a1h,0d0h,046h,0e4h,032h,028h,047h,0d7h,04dh,05bh
		db 0ebh,002h,051h,095h,013h,061h,02ch,0d8h,069h,0eeh,05ah,042h,054h,0deh,0cdh,038h
		db 017h,0f2h,027h,0a4h,03dh,086h,046h,011h,091h,0a6h,0c8h,00ch,062h,0d0h,08ah,0deh
		db 0b7h,009h,02bh,076h,0adh,05bh,0c0h,08eh,0a9h,0c1h,0e4h,089h,0dah,026h,089h,0d5h
		db 0a8h,0d4h,0d7h,051h,0eah,0bah,0f3h,08bh,0f1h,047h,03dh,0c0h,055h,072h,0deh,0e0h
		db 00ah,079h,07ch,005h,0c3h,096h,069h,085h,025h,0e3h,0f2h,0a5h,087h,07ch,0f1h,0e9h
		db 0d8h,05dh,00ah,032h,0bfh,0ach,05ch,0f3h,06bh,067h,054h,0c8h,0f0h,0f7h,073h,021h
		db 0edh,091h,057h,033h,067h,03fh,041h,077h,0a2h,0d3h,0dah,069h,076h,010h,066h,068h
		db 071h,098h,040h,09bh,043h,042h,024h,04dh,09eh,06bh,02eh,04fh,0d2h,052h,067h,078h
		db 003h,0aah,045h,09ch,0dbh,0c6h,09ch,059h,0d5h,063h,093h,081h,0a1h,062h,019h,02ch
		db 0f8h,045h,07eh,06dh,05fh,00ah,07fh,0b0h,05eh,080h,02fh,002h,08fh,0cah,01dh,006h
		db 03ch,09fh,09fh,009h,080h,0cfh,026h,08ah,0f5h,05ch,0c5h,0feh,0deh,084h,08fh,047h
		db 01ch,0f6h,048h,0b6h,030h,02fh,060h,056h,00fh,0dbh,0dbh,0b8h,058h,0e1h,021h,0fbh
		db 00eh,07ah,0e7h,0d7h,0c8h,0cch,0e5h,044h,072h,0b6h,029h,071h,073h,069h,033h,070h
		db 07dh,0ffh,072h,080h,0b3h,054h,043h,017h,032h,08dh,0f9h,053h,045h,0c0h,095h,04ah
		db 011h,083h,0a8h,0cdh,02fh,099h,081h,043h,06ah,08bh,0d8h,087h,060h,08ah,055h,0e4h
		db 042h,022h,0bfh,016h,063h,075h,0a7h,01ah,0e1h,077h,084h,0d6h,0a6h,064h,085h,03ah
		db 0cch,09bh,0eeh,0b4h,0fah,0eah,004h,07ah,0d3h,004h,0d2h,039h,0c1h,04dh,075h,0a3h
		db 009h,066h,0e3h,022h,0a5h,01eh,09ah,079h,040h,0aeh,035h,072h,014h,0f8h,02ah,0eah
		db 08eh,073h,088h,05ch,03ah,074h,0e0h,05fh,09ah,0fbh,0a3h,040h,09bh,008h,003h,0efh
		db 005h,00dh,008h,003h,0bbh,068h,0b2h,0f9h,0ceh,033h,00bh,00dh,029h,025h,0d9h,0a6h
		db 0efh,0bdh,050h,0fdh,0bch,0d5h,0b8h,031h,0f3h,0d8h,010h,0e5h,056h,01dh,03ch,0f6h
		db 051h,090h,06bh,0bch,0bdh,060h,00ch,088h,0aeh,09ch,01fh,057h,0afh,023h,058h,0aeh
		db 015h,0e6h,002h,0abh,0b6h,0cdh,049h,0aah,083h,034h,018h,0ach,08ch,0d1h,044h,099h
		db 0a0h,050h,0dch,093h,00dh,05eh,05eh,036h,02ah,016h,0edh,09dh,007h,0dfh,038h,0fah
		db 09fh,0a1h,020h,052h,0fdh,0a0h,0e2h,0c9h,0c9h,051h,0bdh,0b7h,0c5h,00ch,0cch,0e7h
		db 05dh,0c5h,0feh,0f7h,0cdh,04bh,0b1h,0c7h,092h,06ch,0e9h,03eh,095h,0b1h,099h,0eeh
		db 038h,0d6h,0c6h,015h,068h,0afh,097h,048h,0a3h,0a5h,0aeh,06ah,0b4h,018h,05dh,01eh
		db 05ah,065h,065h,0d4h,0e3h,0c9h,0bah,091h,085h,070h,0b4h,09ah,0eeh,08ch,0b5h,098h
		db 02ch,00bh,05bh,0b3h,044h,05fh,04bh,0b2h,0b1h,02dh,011h,035h,059h,021h,03eh,07ch
		db 066h,056h,074h,0cbh,0c7h,07eh,056h,04eh,084h,0fdh,023h,02fh,0abh,04eh,009h,020h
		db 041h,0dch,0cah,0f5h,0ach,071h,0cbh,03ch,0d9h,014h,0f4h,0a9h,098h,09eh,09eh,0c5h
		db 0beh,0a9h,06ah,0dch,03fh,06fh,071h,064h,05bh,0a3h,063h,0ceh,04dh,0a7h,0ceh,0f8h
		db 0d1h,044h,06ch,0c3h,00ch,093h,052h,0c2h,0cah,0c3h,0aah,066h,093h,0c2h,01eh,07bh
		db 0dch,0feh,00fh,007h,0ddh,04ah,0d3h,0cfh,01eh,01bh,080h,012h,096h,03dh,062h,06bh
		db 01bh,087h,02dh,0dbh,061h,015h,01ah,0dah,02dh,09ah,0c4h,046h,053h,088h,0b7h,03dh
		db 08ah,07fh,0f5h,0ddh,081h,00fh,039h,0c1h,07bh,053h,059h,03fh,0f2h,0ceh,09dh,09fh
		db 0b9h,0b8h,01ch,05dh,057h,0e7h,08dh,02bh,036h,032h,094h,0afh,0cbh,0bfh,087h,025h
		db 03bh,0b7h,0c1h,0cah,0b0h,092h,0d0h,03bh,00bh,0a8h,0e8h,0cch,04eh,027h,006h,0a2h
		db 0e8h,0e9h,034h,00ah,0e9h,0e8h,015h,06fh,006h,039h,042h,094h,008h,082h,0afh,01bh
		db 090h,031h,0c7h,074h,099h,003h,05fh,060h,0dfh,0f5h,08ch,0ech,064h,0beh,0f0h,05eh
		db 074h,0bch,00eh,0a1h,0c2h,037h,091h,0bbh,019h,058h,0ffh,0e6h,08dh,089h,096h,0b5h
		db 07eh,019h,070h,08ch,0c6h,0e0h,0ebh,013h,02bh,0d2h,0a6h,0c4h,0a4h,078h,077h,01fh
		db 01fh,0b4h,0fah,0bfh,04ah,0a4h,0fbh,01ch,031h,0a2h,022h,06eh,06ch,06eh,0beh,024h
		db 0bah,0cbh,03fh,0d9h,0fch,0e2h,0dfh,07eh,06eh,0bbh,0f7h,027h,027h,040h,012h,0a0h
		db 0ech,04ch,086h,0edh,07fh,0b2h,06fh,02dh,010h,094h,025h,0adh,0cfh,081h,090h,04ch
perm_order	db  31, 23, 15,  7, 30, 22, 14,  6, 29, 21, 13,  5, 28, 20, 12,  4
		db  27, 19, 11,  3, 26, 18, 10,  2, 25, 17,  9,  1, 24, 16,  8,  0