comment %

Algo	: Khazad (by Vincent Rijmen & Paulo Barreto)
Block	: 8 bytes
Key	: 128 bits

	push	offset password
	call	Khazad_SetKey

	push	KHAZAD_ENCRYPT
	push	offset plain
	push	offset cipher
	call	Khazad_Crypt

	push	KHAZAD_DECRYPT
	push	offset cipher
	push	offset decrypted_plain
	call	Khazad_Crypt

	call	Khazad_Clear

This software implements the first and second ("tweaked") version of Khazad.

04.05.2002 WiteG//xtreeme (witeg@poczta.fm, www.witeg.prv.pl)
%


; ---------------------------------------------------------------------------
; You should set key algorithm version (KHAZAD_VER) !
; ---------------------------------------------------------------------------

KHAZAD_VER	equ	1		; 1 = first version 
					; 2 = "tweaked" version

; ---------------------------------------------------------------------------



KHAZAD_ENCRYPT	equ	0
KHAZAD_DECRYPT	equ	1

.code
Khazad_Crypt	proc	ptrOut:DWORD, ptrIn:DWORD, flag:DWORD
	pushad
	mov	dword ptr [_esp], esp

	mov	eax, flag
	mov	esi, ptrIn
	mov	esp, offset khazad_enc_key
	test	eax, eax
	jz	@F
	add	esp, 2*8*4
@@:
	mov	eax, dword ptr [esi]
	mov	ebx, dword ptr [esi+4]
	bswap	eax
	bswap	ebx
	xor	eax, dword ptr [esp]
	xor	ebx, dword ptr [esp+4]
	mov	esi, ptrOut

	xor	edx, edx
	xor	ecx, ecx
	mov	dword ptr [_round], 8-1
@@:
	add	esp, 8
	mov	cl, al
	mov	edi, dword ptr [esp]
	mov	dl, ah
	xor	edi, dword ptr [U3 + 4*ecx]
	rol	eax, 16
	xor	edi, dword ptr [U2 + 4*edx]
	mov	cl, al
	mov	dl, ah
	xor	edi, dword ptr [U1 + 4*ecx]
	rol	eax, 16
	xor	edi, dword ptr [U0 + 4*edx]
	mov	cl, bl
	mov	dl, bh
	xor	edi, dword ptr [V3 + 4*ecx]
	rol	ebx, 16
	xor	edi, dword ptr [V2 + 4*edx]
	mov	cl, bl
	mov	dl, bh
	xor	edi, dword ptr [V1 + 4*ecx]
	rol	ebx, 16
	xor	edi, dword ptr [V0 + 4*edx]	;K20 = roundKeyEnc[r][0]

	mov	ebp, dword ptr [esp + 4]
	mov	cl, al
	mov	dl, ah
	xor	ebp, dword ptr [V3 + 4*ecx]
	rol	eax, 16
	xor	ebp, dword ptr [V2 + 4*edx]
	mov	cl, al
	mov	dl, ah
	xor	ebp, dword ptr [V1 + 4*ecx]
	xor	ebp, dword ptr [V0 + 4*edx]
	mov	cl, bl
	mov	dl, bh
	xor	ebp, dword ptr [U3 + 4*ecx]
	rol	ebx, 16
	xor	ebp, dword ptr [U2 + 4*edx]
	mov	cl, bl
	mov	dl, bh
	xor	ebp, dword ptr [U1 + 4*ecx]
	xor	ebp, dword ptr [U0 + 4*edx]	;K21 = roundKeyEnc[r][1]

	mov	eax, edi
	dec	dword ptr [_round]
	mov	ebx, ebp
	jnz	@B

	add	esp, 8

	mov	cl, al
	mov	dl, ah
	mov	al, byte ptr [U3 + 4*ecx]
	mov	ah, byte ptr [U2 + 4*edx+1]
	mov	cl, bl
	rol	eax, 16
	mov	dl, bh
	mov	bl, byte ptr [U3 + 4*ecx]
	mov	bh, byte ptr [U2 + 4*edx+1]
	mov	cl, al
	mov	dl, ah
	mov	al, byte ptr [U1 + 4*ecx+2]
	mov	ah, byte ptr [U0 + 4*edx+3]
	rol	ebx, 16
	rol	eax, 16
	mov	cl, bl
	mov	dl, bh
	mov	bl, byte ptr [U1 + 4*ecx+2]
	mov	bh, byte ptr [U0 + 4*edx+3]
	xor	eax, dword ptr [esp]
	rol	ebx, 16
	xor	ebx, dword ptr [esp+4]

	bswap	eax
	bswap	ebx
	mov	esp, dword ptr [_esp]
	mov	dword ptr [esi], eax
	mov	dword ptr [esi+4], ebx
	and	dword ptr [_esp], 0
	popad
	ret
Khazad_Crypt	endp

Khazad_SetKey	proc	ptrPass:DWORD

	pushad
	mov	esi, ptrPass
	mov	dword ptr [_esp], esp
	mov	edi, dword ptr [esi+ 0]		;K20
	mov	ebp, dword ptr [esi+ 4]		;K21
	mov	eax, dword ptr [esi+ 8]		;K10
	mov	ebx, dword ptr [esi+12]		;K11
	bswap	edi
	bswap	ebp
	bswap	eax
	bswap	ebx
	xor	edx, edx
	xor	ecx, ecx
	mov	esi, offset khazad_enc_key
	mov	esp, offset C_const
@@:
	xor	edi, dword ptr [esp]
	mov	cl, al
	mov	dl, ah
	xor	edi, dword ptr [U3 + 4*ecx]
	rol	eax, 16
	xor	edi, dword ptr [U2 + 4*edx]
	mov	cl, al
	mov	dl, ah
	xor	edi, dword ptr [U1 + 4*ecx]
	rol	eax, 16
	xor	edi, dword ptr [U0 + 4*edx]
	mov	cl, bl
	mov	dl, bh
	xor	edi, dword ptr [V3 + 4*ecx]
	rol	ebx, 16
	xor	edi, dword ptr [V2 + 4*edx]
	mov	cl, bl
	mov	dl, bh
	xor	edi, dword ptr [V1 + 4*ecx]
	rol	ebx, 16
	xor	edi, dword ptr [V0 + 4*edx]	;K20 = roundKeyEnc[r][0]

	xor	ebp, dword ptr [esp + 4]
	mov	cl, al
	mov	dl, ah
	xor	ebp, dword ptr [V3 + 4*ecx]
	rol	eax, 16
	xor	ebp, dword ptr [V2 + 4*edx]
	mov	cl, al
	mov	dl, ah
	xor	ebp, dword ptr [V1 + 4*ecx]
	rol	eax, 16
	xor	ebp, dword ptr [V0 + 4*edx]
	mov	cl, bl
	mov	dl, bh
	xor	ebp, dword ptr [U3 + 4*ecx]
	rol	ebx, 16
	xor	ebp, dword ptr [U2 + 4*edx]
	mov	cl, bl
	mov	dl, bh
	xor	ebp, dword ptr [U1 + 4*ecx]
	rol	ebx, 16
	xor	ebp, dword ptr [U0 + 4*edx]	;K21 = roundKeyEnc[r][1]
	mov	dword ptr [esi], edi
	mov	dword ptr [esi + 4], ebp
	xchg	eax, edi
	xchg	ebx, ebp
	add	esi, 8
	add	esp, 8
	cmp	esi, offset khazad_enc_key + 8*9
	jnz	@B

	lea	esp, [esi-16]
	mov	edi, offset U3

@@:
	mov	eax, dword ptr [esp]		;K10
	mov	ebx, dword ptr [esp+4]		;K11

	mov	cl, al
	mov	dl, ah
	mov	cl, byte ptr [edi+4*ecx]
	mov	dl, byte ptr [edi+4*edx]
	mov	ebp, dword ptr [U3 + ecx*4]
	rol	eax, 16
	xor	ebp, dword ptr [U2 + edx*4]
	mov	cl, bl
	mov	dl, bh
	mov	cl, byte ptr [edi+4*ecx]
	mov	dl, byte ptr [edi+4*edx]
	xor	ebp, dword ptr [V3 + ecx*4]
	rol	ebx, 16
	xor	ebp, dword ptr [V2 + edx*4]
	mov	cl, al
	mov	dl, ah
	mov	cl, byte ptr [edi+4*ecx]
	mov	dl, byte ptr [edi+4*edx]
	xor	ebp, dword ptr [U1 + ecx*4]
	rol	eax, 16
	xor	ebp, dword ptr [U0 + edx*4]
	mov	cl, bl
	mov	dl, bh
	mov	cl, byte ptr [edi+4*ecx]
	mov	dl, byte ptr [edi+4*edx]
	xor	ebp, dword ptr [V1 + ecx*4]
	rol	ebx, 16
	xor	ebp, dword ptr [V0 + edx*4]

	mov	cl, al
	mov	dword ptr [esi], ebp
	mov	dl, ah
	mov	cl, byte ptr [edi+4*ecx]
	mov	dl, byte ptr [edi+4*edx]
	mov	ebp, dword ptr [V3 + ecx*4]
	rol	eax, 16
	xor	ebp, dword ptr [V2 + edx*4]
	mov	cl, bl
	mov	dl, bh
	mov	cl, byte ptr [edi+4*ecx]
	mov	dl, byte ptr [edi+4*edx]
	xor	ebp, dword ptr [U3 + ecx*4]
	rol	ebx, 16
	xor	ebp, dword ptr [U2 + edx*4]
	mov	cl, al
	mov	dl, ah
	mov	cl, byte ptr [edi+4*ecx]
	mov	dl, byte ptr [edi+4*edx]
	xor	ebp, dword ptr [V1 + ecx*4]
	xor	ebp, dword ptr [V0 + edx*4]
	mov	cl, bl
	mov	dl, bh
	mov	cl, byte ptr [edi+4*ecx]
	mov	dl, byte ptr [edi+4*edx]
	xor	ebp, dword ptr [U1 + ecx*4]
	xor	ebp, dword ptr [U0 + edx*4]
	sub	esp, 8
	mov	dword ptr [esi+4], ebp
	add	esi, 8
	cmp	esp, offset khazad_enc_key
	jnz	@B

	mov	eax, dword ptr [esp]
	mov	ebx, dword ptr [esp+4]
	mov	dword ptr [esi], eax
	mov	dword ptr [esi+4], ebx

	mov	esp, dword ptr [_esp]
	popad
	and	dword ptr [_esp], 0
	ret

Khazad_SetKey	endp

Khazad_Clear	proc
	pushad
	xor	eax, eax
	mov	ecx, 2*(8+9)+2
	mov	edi, offset khazad_enc_key
	cld
	rep	stosd
	popad
	ret
Khazad_Clear	endp

.data?
khazad_enc_key	dd 2*8 dup (?)
khazad_dec_key	dd 2*9 dup (?)
_esp		dd ?
_round		dd ?

.data
IF		KHAZAD_VER	eq	2
U0	dd	0bad3d268h, 054fc4d19h, 02f71bc93h, 0749ccdb9h, 053f55102h, 0d3686bb8h, 0d26b6fbdh, 04dd72964h
	dd	050f05d0dh, 0ace98a26h, 08d8a0e83h, 0bfdcc679h, 07090ddadh, 052f65507h, 09ab352c8h, 04cd42d61h
	dd	0ea238f65h, 0d56273a6h, 097a466f1h, 0d16e63b2h, 03355ccffh, 051f35908h, 05bed712ah, 0a6f7a204h
	dd	0de7f5f81h, 048d83d75h, 0a8e59a32h, 099b65ec7h, 0db704b90h, 03256c8fah, 0b7c4e651h, 0fc19d72bh
	dd	0e338ab48h, 09ebf42dch, 091ae7eefh, 09bb056cdh, 0e23baf4dh, 0bbd0d66dh, 041c31958h, 06eb2a5cbh
	dd	0a5f2ae0bh, 0cb400bc0h, 06bbdb1dah, 095a26efbh, 0a1febe1fh, 0f308eb18h, 0b1cefe4fh, 00206080ah
	dd	0cc4917dbh, 0c45137f3h, 01d277469h, 0143c5044h, 0c3582be8h, 063a591f2h, 0da734f95h, 05de76934h
	dd	05fe1613eh, 0dc79578bh, 07d87e994h, 0cd4a13deh, 07f81e19eh, 05aee752fh, 06cb4adc1h, 05ce46d31h
	dd	0f704fb0ch, 0266a98beh, 0ff1cdb24h, 0ed2a937eh, 0e825876fh, 09dba4ed3h, 06fb1a1ceh, 08e8f028ch
	dd	0192b647dh, 0a0fdba1ah, 0f00de717h, 089861e97h, 00f113c33h, 007091c1bh, 0afec8629h, 0fb10cb30h
	dd	008182028h, 0153f5441h, 00d173439h, 0040c1014h, 001030405h, 064ac8de9h, 0df7c5b84h, 0769ac5b3h
	dd	0798bf980h, 0dd7a538eh, 03d47f4c9h, 0163a584eh, 03f41fcc3h, 03759dcebh, 06db7a9c4h, 03848e0d8h
	dd	0b9d6de67h, 07395d1a2h, 0e926836ah, 0355fd4e1h, 055ff491ch, 07193d9a8h, 07b8df18ah, 08c890a86h
	dd	07296d5a7h, 088851a92h, 0f607ff09h, 02a7ea882h, 03e42f8c6h, 05ee2653bh, 027699cbbh, 046ca0543h
	dd	00c14303ch, 065af89ech, 068b8bdd5h, 061a399f8h, 003050c0fh, 0c15e23e2h, 057f94116h, 0d6677fa9h
	dd	0d976439ah, 058e87d25h, 0d875479fh, 066aa85e3h, 0d7647bach, 03a4ee8d2h, 0c84507cfh, 03c44f0cch
	dd	0fa13cf35h, 096a762f4h, 0a7f4a601h, 098b55ac2h, 0ec29977bh, 0b8d5da62h, 0c7543bfch, 0aeef822ch
	dd	069bbb9d0h, 04bdd317ah, 0abe0963dh, 0a9e69e37h, 067a981e6h, 00a1e2822h, 047c90146h, 0f20bef1dh
	dd	0b5c2ee5bh, 0226688aah, 0e532b356h, 0ee2f9f71h, 0bedfc27ch, 02b7dac87h, 0819e3ebfh, 01236485ah
	dd	0839836b5h, 01b2d6c77h, 00e123836h, 023658cafh, 0f502f306h, 045cf094ch, 0216384a5h, 0ce4f1fd1h
	dd	049db3970h, 02c74b09ch, 0f916c33ah, 0e637bf59h, 0b6c7e254h, 02878a088h, 017395c4bh, 0829b32b0h
	dd	01a2e6872h, 08b80169dh, 0fe1fdf21h, 08a831298h, 0091b242dh, 0c94603cah, 0879426a1h, 04ed2256bh
	dd	0e13ea342h, 02e72b896h, 0e431b753h, 0e03da747h, 0eb208b60h, 090ad7aeah, 0a4f1aa0eh, 01e227866h
	dd	085922eabh, 060a09dfdh, 000000000h, 0256f94b1h, 0f401f703h, 0f10ee312h, 094a16afeh, 00b1d2c27h
	dd	0e734bb5ch, 0759fc9bch, 0ef2c9b74h, 0345cd0e4h, 03153c4f5h, 0d46177a3h, 0d06d67b7h, 0869722a4h
	dd	07e82e59bh, 0adea8e23h, 0fd1ad32eh, 0297ba48dh, 03050c0f0h, 03b4decd7h, 09fbc46d9h, 0f815c73fh
	dd	0c6573ff9h, 013354c5fh, 0060a181eh, 0050f1411h, 0c55233f6h, 011334455h, 07799c1b6h, 07c84ed91h
	dd	07a8ef58fh, 07888fd85h, 0365ad8eeh, 01c24706ch, 0394be4ddh, 059eb7920h, 018286078h, 056fa4513h
	dd	0b3c8f645h, 0b0cdfa4ah, 0246c90b4h, 0206080a0h, 0b2cbf240h, 092ab72e0h, 0a3f8b615h, 0c05d27e7h
	dd	044cc0d49h, 062a695f7h, 010304050h, 0b4c1ea5eh, 084912aaeh, 043c51152h, 093a876e5h, 0c25b2fedh
	dd	04ade357fh, 0bddace73h, 08f8c0689h, 02d77b499h, 0bcd9ca76h, 09cb94ad6h, 06abeb5dfh, 040c01d5dh
	dd	0cf4c1bd4h, 0a2fbb210h, 0809d3abah, 04fd1216eh, 01f217c63h, 0ca430fc5h, 0aae39238h, 042c61557h

V0	dd	0bbb96a01h, 0e59a66b1h, 0e26514cdh, 025871b51h, 0f7a257a4h, 0d0d6be03h, 0d6deb504h, 0b35285feh
	dd	0fdba4aadh, 0cf09e063h, 0091c9684h, 0a5914d1ah, 03da7374dh, 0f1aa5ca3h, 07ba417e1h, 0b55a8ef9h
	dd	0460320ach, 0c4e68411h, 055cc68c2h, 0dcc6a80dh, 0aa85d099h, 0fbb241aah, 0c7e20f9ch, 0f359ae55h
	dd	0febec120h, 0ad7aa2e5h, 0d729cc7fh, 071bc0ae8h, 0e096e63bh, 0ac8ddb9eh, 095d11522h, 032b3aaceh
	dd	0704b7393h, 063843bfdh, 041fc52d0h, 07dac1ce6h, 076437894h, 0bdb16106h, 09b32f1dah, 07957e517h
	dd	0f941b35ch, 08016564bh, 0677fc20ch, 059dc7ecch, 0e1619f40h, 010cbc3e3h, 081e12f30h, 00c10160eh
	dd	0922e675eh, 0a26e3f66h, 04ee8cf53h, 078a09c6ch, 0b0560e73h, 0573f9a34h, 0e69eed3ch, 0d3d2358eh
	dd	0dfc22380h, 0f2aed72eh, 013cf486eh, 094266c59h, 01fdf5e60h, 0c1ea049bh, 07547f319h, 0d5da3e89h
	dd	008ebefffh, 0d42d47f2h, 038abb7c7h, 0543b11b9h, 04a1336a2h, 0699c26f4h, 07f5fee10h, 003048b8dh
	dd	056c8e34fh, 0e7699447h, 01ad3deeah, 0113cba98h, 02278692dh, 012383115h, 0c511fd6ah, 0208b9bdbh
	dd	030405838h, 07ea8976bh, 02e687f23h, 018202c1ch, 006080b07h, 04507ab21h, 0f8b6ca27h, 029970d5fh
	dd	00bef6472h, 0f4a6dc29h, 08ef5b2b3h, 074b08a62h, 082e5a4bdh, 0b2a5fc85h, 0734ff81eh, 090dd95a8h
	dd	0b1a17708h, 037bf2a44h, 04c1b3da5h, 0beb5ea8bh, 0e3926db6h, 03baf3c4ah, 007ff727ch, 00f149d83h
	dd	031b72143h, 01734b19fh, 00ee3e4f8h, 0fc4d33d6h, 084edafbah, 0d9ca2887h, 0d2254cf5h, 0890ac0cfh
	dd	028607424h, 0430fa026h, 06d67df05h, 05b2f8c3ah, 00a181d09h, 0bc46187dh, 0ef827bb8h, 0cefe9918h
	dd	0ec86f035h, 0cdfa1295h, 0ea8efb32h, 04917bd2fh, 0c8f6921fh, 09ccd83a6h, 08a0e4b42h, 088fdb9b4h
	dd	0268390dch, 053c463c5h, 0f551a552h, 077b401efh, 052331abeh, 0b7a97c0fh, 0a876226fh, 0c319f66dh
	dd	06b6fd402h, 0a762bfech, 0dd31d176h, 0d121c778h, 04f1fb628h, 03c504e36h, 08f02cbc8h, 016c3c8e4h
	dd	099c1032ch, 0cc0d6beeh, 0647b4981h, 05e230cb0h, 0a399461dh, 0fa4538d1h, 0217ce2a0h, 06c90a67eh
	dd	02d6cf4aeh, 05ad8f541h, 02470622ah, 0ca0560e9h, 004fbf9f1h, 08312ddc6h, 0c61576e7h, 09e3e7150h
	dd	0ab72a9e2h, 0e87d09c4h, 02c9b8dd5h, 06e635488h, 093d91e25h, 0f05d25d8h, 072b88165h, 02b64ffa9h
	dd	05cd0fe46h, 01d2cac96h, 03ea3bcc0h, 01b24a791h, 03648533fh, 08c064045h, 0354cd8b2h, 0b94a98f7h
	dd	07c5b659dh, 0e46d1fcah, 062734286h, 07a536e9ah, 0400b2babh, 047f459d7h, 0ff49b85bh, 044f0d25ah
	dd	0395ccebch, 05d27873dh, 000000000h, 0de355afbh, 002f3f2f6h, 01cdbd5edh, 05fd475cbh, 03a584531h
	dd	0686b5f8fh, 0238f1056h, 0582b07b7h, 0b8bde18ch, 0a695c697h, 0c2ee8f16h, 0dacea30ah, 03344d3b5h
	dd	019d75567h, 0c901eb64h, 034bba1c9h, 0f6552edfh, 0a09dcd90h, 09ac588a1h, 0658c30fah, 02a9386d2h
	dd	0ae7e2968h, 06a98ad79h, 014303a12h, 01e28271bh, 0a4663461h, 06688bb77h, 02f9f0658h, 015c74369h
	dd	001f7797bh, 00de76f75h, 0b4adf782h, 048e0c454h, 096d59eafh, 0cbf21992h, 050c0e848h, 0e98a70bfh
	dd	08df1393eh, 087e92437h, 0d83d51fch, 0c01d7de0h, 08bf93239h, 04be44fd9h, 0ed71894eh, 0ba4e137ah
	dd	0851ad6c1h, 051379133h, 06080b070h, 09fc9082bh, 03f54c5bbh, 09722e7d4h, 04dec44deh, 0b65e0574h
	dd	0a16ab4ebh, 0a9815b14h, 0050c808ah, 0ee7502c3h, 0af895013h, 06f942df3h, 06177c90bh, 09d3afaddh
	dd	098367a57h, 0eb798249h, 02774e9a7h, 0bf4293f0h, 042f8d95dh, 0861e5d4ch, 0db39da71h, 0912aecd3h

U1	dd	0d3ba68d2h, 0fc54194dh, 0712f93bch, 09c74b9cdh, 0f5530251h, 068d3b86bh, 06bd2bd6fh, 0d74d6429h
	dd	0f0500d5dh, 0e9ac268ah, 08a8d830eh, 0dcbf79c6h, 09070adddh, 0f6520755h, 0b39ac852h, 0d44c612dh
	dd	023ea658fh, 062d5a673h, 0a497f166h, 06ed1b263h, 05533ffcch, 0f3510859h, 0ed5b2a71h, 0f7a604a2h
	dd	07fde815fh, 0d848753dh, 0e5a8329ah, 0b699c75eh, 070db904bh, 05632fac8h, 0c4b751e6h, 019fc2bd7h
	dd	038e348abh, 0bf9edc42h, 0ae91ef7eh, 0b09bcd56h, 03be24dafh, 0d0bb6dd6h, 0c3415819h, 0b26ecba5h
	dd	0f2a50baeh, 040cbc00bh, 0bd6bdab1h, 0a295fb6eh, 0fea11fbeh, 008f318ebh, 0ceb14ffeh, 006020a08h
	dd	049ccdb17h, 051c4f337h, 0271d6974h, 03c144450h, 058c3e82bh, 0a563f291h, 073da954fh, 0e75d3469h
	dd	0e15f3e61h, 079dc8b57h, 0877d94e9h, 04acdde13h, 0817f9ee1h, 0ee5a2f75h, 0b46cc1adh, 0e45c316dh
	dd	004f70cfbh, 06a26be98h, 01cff24dbh, 02aed7e93h, 025e86f87h, 0ba9dd34eh, 0b16fcea1h, 08f8e8c02h
	dd	02b197d64h, 0fda01abah, 00df017e7h, 08689971eh, 0110f333ch, 009071b1ch, 0ecaf2986h, 010fb30cbh
	dd	018082820h, 03f154154h, 0170d3934h, 00c041410h, 003010504h, 0ac64e98dh, 07cdf845bh, 09a76b3c5h
	dd	08b7980f9h, 07add8e53h, 0473dc9f4h, 03a164e58h, 0413fc3fch, 05937ebdch, 0b76dc4a9h, 04838d8e0h
	dd	0d6b967deh, 09573a2d1h, 026e96a83h, 05f35e1d4h, 0ff551c49h, 09371a8d9h, 08d7b8af1h, 0898c860ah
	dd	09672a7d5h, 08588921ah, 007f609ffh, 07e2a82a8h, 0423ec6f8h, 0e25e3b65h, 06927bb9ch, 0ca464305h
	dd	0140c3c30h, 0af65ec89h, 0b868d5bdh, 0a361f899h, 005030f0ch, 05ec1e223h, 0f9571641h, 067d6a97fh
	dd	076d99a43h, 0e858257dh, 075d89f47h, 0aa66e385h, 064d7ac7bh, 04e3ad2e8h, 045c8cf07h, 0443cccf0h
	dd	013fa35cfh, 0a796f462h, 0f4a701a6h, 0b598c25ah, 029ec7b97h, 0d5b862dah, 054c7fc3bh, 0efae2c82h
	dd	0bb69d0b9h, 0dd4b7a31h, 0e0ab3d96h, 0e6a9379eh, 0a967e681h, 01e0a2228h, 0c9474601h, 00bf21defh
	dd	0c2b55beeh, 06622aa88h, 032e556b3h, 02fee719fh, 0dfbe7cc2h, 07d2b87ach, 09e81bf3eh, 036125a48h
	dd	09883b536h, 02d1b776ch, 0120e3638h, 06523af8ch, 002f506f3h, 0cf454c09h, 06321a584h, 04fced11fh
	dd	0db497039h, 0742c9cb0h, 016f93ac3h, 037e659bfh, 0c7b654e2h, 0782888a0h, 039174b5ch, 09b82b032h
	dd	02e1a7268h, 0808b9d16h, 01ffe21dfh, 0838a9812h, 01b092d24h, 046c9ca03h, 09487a126h, 0d24e6b25h
	dd	03ee142a3h, 0722e96b8h, 031e453b7h, 03de047a7h, 020eb608bh, 0ad90ea7ah, 0f1a40eaah, 0221e6678h
	dd	09285ab2eh, 0a060fd9dh, 000000000h, 06f25b194h, 001f403f7h, 00ef112e3h, 0a194fe6ah, 01d0b272ch
	dd	034e75cbbh, 09f75bcc9h, 02cef749bh, 05c34e4d0h, 05331f5c4h, 061d4a377h, 06dd0b767h, 09786a422h
	dd	0827e9be5h, 0eaad238eh, 01afd2ed3h, 07b298da4h, 05030f0c0h, 04d3bd7ech, 0bc9fd946h, 015f83fc7h
	dd	057c6f93fh, 035135f4ch, 00a061e18h, 00f051114h, 052c5f633h, 033115544h, 09977b6c1h, 0847c91edh
	dd	08e7a8ff5h, 0887885fdh, 05a36eed8h, 0241c6c70h, 04b39dde4h, 0eb592079h, 028187860h, 0fa561345h
	dd	0c8b345f6h, 0cdb04afah, 06c24b490h, 06020a080h, 0cbb240f2h, 0ab92e072h, 0f8a315b6h, 05dc0e727h
	dd	0cc44490dh, 0a662f795h, 030105040h, 0c1b45eeah, 09184ae2ah, 0c5435211h, 0a893e576h, 05bc2ed2fh
	dd	0de4a7f35h, 0dabd73ceh, 08c8f8906h, 0772d99b4h, 0d9bc76cah, 0b99cd64ah, 0be6adfb5h, 0c0405d1dh
	dd	04ccfd41bh, 0fba210b2h, 09d80ba3ah, 0d14f6e21h, 0211f637ch, 043cac50fh, 0e3aa3892h, 0c6425715h

V1	dd	0b9bb016ah, 09ae5b166h, 065e2cd14h, 08725511bh, 0a2f7a457h, 0d6d003beh, 0ded604b5h, 052b3fe85h
	dd	0bafdad4ah, 009cf63e0h, 01c098496h, 091a51a4dh, 0a73d4d37h, 0aaf1a35ch, 0a47be117h, 05ab5f98eh
	dd	00346ac20h, 0e6c41184h, 0cc55c268h, 0c6dc0da8h, 085aa99d0h, 0b2fbaa41h, 0e2c79c0fh, 059f355aeh
	dd	0befe20c1h, 07aade5a2h, 029d77fcch, 0bc71e80ah, 096e03be6h, 08dac9edbh, 0d1952215h, 0b332ceaah
	dd	04b709373h, 08463fd3bh, 0fc41d052h, 0ac7de61ch, 043769478h, 0b1bd0661h, 0329bdaf1h, 0577917e5h
	dd	041f95cb3h, 016804b56h, 07f670cc2h, 0dc59cc7eh, 061e1409fh, 0cb10e3c3h, 0e181302fh, 0100c0e16h
	dd	02e925e67h, 06ea2663fh, 0e84e53cfh, 0a0786c9ch, 056b0730eh, 03f57349ah, 09ee63cedh, 0d2d38e35h
	dd	0c2df8023h, 0aef22ed7h, 0cf136e48h, 02694596ch, 0df1f605eh, 0eac19b04h, 0477519f3h, 0dad5893eh
	dd	0eb08ffefh, 02dd4f247h, 0ab38c7b7h, 03b54b911h, 0134aa236h, 09c69f426h, 05f7f10eeh, 004038d8bh
	dd	0c8564fe3h, 069e74794h, 0d31aeadeh, 03c1198bah, 078222d69h, 038121531h, 011c56afdh, 08b20db9bh
	dd	040303858h, 0a87e6b97h, 0682e237fh, 020181c2ch, 00806070bh, 0074521abh, 0b6f827cah, 097295f0dh
	dd	0ef0b7264h, 0a6f429dch, 0f58eb3b2h, 0b074628ah, 0e582bda4h, 0a5b285fch, 04f731ef8h, 0dd90a895h
	dd	0a1b10877h, 0bf37442ah, 01b4ca53dh, 0b5be8beah, 092e3b66dh, 0af3b4a3ch, 0ff077c72h, 0140f839dh
	dd	0b7314321h, 034179fb1h, 0e30ef8e4h, 04dfcd633h, 0ed84baafh, 0cad98728h, 025d2f54ch, 00a89cfc0h
	dd	060282474h, 00f4326a0h, 0676d05dfh, 02f5b3a8ch, 0180a091dh, 046bc7d18h, 082efb87bh, 0fece1899h
	dd	086ec35f0h, 0facd9512h, 08eea32fbh, 017492fbdh, 0f6c81f92h, 0cd9ca683h, 00e8a424bh, 0fd88b4b9h
	dd	08326dc90h, 0c453c563h, 051f552a5h, 0b477ef01h, 03352be1ah, 0a9b70f7ch, 076a86f22h, 019c36df6h
	dd	06f6b02d4h, 062a7ecbfh, 031dd76d1h, 021d178c7h, 01f4f28b6h, 0503c364eh, 0028fc8cbh, 0c316e4c8h
	dd	0c1992c03h, 00dccee6bh, 07b648149h, 0235eb00ch, 099a31d46h, 045fad138h, 07c21a0e2h, 0906c7ea6h
	dd	06c2daef4h, 0d85a41f5h, 070242a62h, 005cae960h, 0fb04f1f9h, 01283c6ddh, 015c6e776h, 03e9e5071h
	dd	072abe2a9h, 07de8c409h, 09b2cd58dh, 0636e8854h, 0d993251eh, 05df0d825h, 0b8726581h, 0642ba9ffh
	dd	0d05c46feh, 02c1d96ach, 0a33ec0bch, 0241b91a7h, 048363f53h, 0068c4540h, 04c35b2d8h, 04ab9f798h
	dd	05b7c9d65h, 06de4ca1fh, 073628642h, 0537a9a6eh, 00b40ab2bh, 0f447d759h, 049ff5bb8h, 0f0445ad2h
	dd	05c39bcceh, 0275d3d87h, 000000000h, 035defb5ah, 0f302f6f2h, 0db1cedd5h, 0d45fcb75h, 0583a3145h
	dd	06b688f5fh, 08f235610h, 02b58b707h, 0bdb88ce1h, 095a697c6h, 0eec2168fh, 0ceda0aa3h, 04433b5d3h
	dd	0d7196755h, 001c964ebh, 0bb34c9a1h, 055f6df2eh, 09da090cdh, 0c59aa188h, 08c65fa30h, 0932ad286h
	dd	07eae6829h, 0986a79adh, 03014123ah, 0281e1b27h, 066a46134h, 0886677bbh, 09f2f5806h, 0c7156943h
	dd	0f7017b79h, 0e70d756fh, 0adb482f7h, 0e04854c4h, 0d596af9eh, 0f2cb9219h, 0c05048e8h, 08ae9bf70h
	dd	0f18d3e39h, 0e9873724h, 03dd8fc51h, 01dc0e07dh, 0f98b3932h, 0e44bd94fh, 071ed4e89h, 04eba7a13h
	dd	01a85c1d6h, 037513391h, 0806070b0h, 0c99f2b08h, 0543fbbc5h, 02297d4e7h, 0ec4dde44h, 05eb67405h
	dd	06aa1ebb4h, 081a9145bh, 00c058a80h, 075eec302h, 089af1350h, 0946ff32dh, 077610bc9h, 03a9dddfah
	dd	03698577ah, 079eb4982h, 07427a7e9h, 042bff093h, 0f8425dd9h, 01e864c5dh, 039db71dah, 02a91d3ech

U2	dd	0d268bad3h, 04d1954fch, 0bc932f71h, 0cdb9749ch, 0510253f5h, 06bb8d368h, 06fbdd26bh, 029644dd7h
	dd	05d0d50f0h, 08a26ace9h, 00e838d8ah, 0c679bfdch, 0ddad7090h, 0550752f6h, 052c89ab3h, 02d614cd4h
	dd	08f65ea23h, 073a6d562h, 066f197a4h, 063b2d16eh, 0ccff3355h, 0590851f3h, 0712a5bedh, 0a204a6f7h
	dd	05f81de7fh, 03d7548d8h, 09a32a8e5h, 05ec799b6h, 04b90db70h, 0c8fa3256h, 0e651b7c4h, 0d72bfc19h
	dd	0ab48e338h, 042dc9ebfh, 07eef91aeh, 056cd9bb0h, 0af4de23bh, 0d66dbbd0h, 0195841c3h, 0a5cb6eb2h
	dd	0ae0ba5f2h, 00bc0cb40h, 0b1da6bbdh, 06efb95a2h, 0be1fa1feh, 0eb18f308h, 0fe4fb1ceh, 0080a0206h
	dd	017dbcc49h, 037f3c451h, 074691d27h, 05044143ch, 02be8c358h, 091f263a5h, 04f95da73h, 069345de7h
	dd	0613e5fe1h, 0578bdc79h, 0e9947d87h, 013decd4ah, 0e19e7f81h, 0752f5aeeh, 0adc16cb4h, 06d315ce4h
	dd	0fb0cf704h, 098be266ah, 0db24ff1ch, 0937eed2ah, 0876fe825h, 04ed39dbah, 0a1ce6fb1h, 0028c8e8fh
	dd	0647d192bh, 0ba1aa0fdh, 0e717f00dh, 01e978986h, 03c330f11h, 01c1b0709h, 08629afech, 0cb30fb10h
	dd	020280818h, 05441153fh, 034390d17h, 01014040ch, 004050103h, 08de964ach, 05b84df7ch, 0c5b3769ah
	dd	0f980798bh, 0538edd7ah, 0f4c93d47h, 0584e163ah, 0fcc33f41h, 0dceb3759h, 0a9c46db7h, 0e0d83848h
	dd	0de67b9d6h, 0d1a27395h, 0836ae926h, 0d4e1355fh, 0491c55ffh, 0d9a87193h, 0f18a7b8dh, 00a868c89h
	dd	0d5a77296h, 01a928885h, 0ff09f607h, 0a8822a7eh, 0f8c63e42h, 0653b5ee2h, 09cbb2769h, 0054346cah
	dd	0303c0c14h, 089ec65afh, 0bdd568b8h, 099f861a3h, 00c0f0305h, 023e2c15eh, 0411657f9h, 07fa9d667h
	dd	0439ad976h, 07d2558e8h, 0479fd875h, 085e366aah, 07bacd764h, 0e8d23a4eh, 007cfc845h, 0f0cc3c44h
	dd	0cf35fa13h, 062f496a7h, 0a601a7f4h, 05ac298b5h, 0977bec29h, 0da62b8d5h, 03bfcc754h, 0822caeefh
	dd	0b9d069bbh, 0317a4bddh, 0963dabe0h, 09e37a9e6h, 081e667a9h, 028220a1eh, 0014647c9h, 0ef1df20bh
	dd	0ee5bb5c2h, 088aa2266h, 0b356e532h, 09f71ee2fh, 0c27cbedfh, 0ac872b7dh, 03ebf819eh, 0485a1236h
	dd	036b58398h, 06c771b2dh, 038360e12h, 08caf2365h, 0f306f502h, 0094c45cfh, 084a52163h, 01fd1ce4fh
	dd	0397049dbh, 0b09c2c74h, 0c33af916h, 0bf59e637h, 0e254b6c7h, 0a0882878h, 05c4b1739h, 032b0829bh
	dd	068721a2eh, 0169d8b80h, 0df21fe1fh, 012988a83h, 0242d091bh, 003cac946h, 026a18794h, 0256b4ed2h
	dd	0a342e13eh, 0b8962e72h, 0b753e431h, 0a747e03dh, 08b60eb20h, 07aea90adh, 0aa0ea4f1h, 078661e22h
	dd	02eab8592h, 09dfd60a0h, 000000000h, 094b1256fh, 0f703f401h, 0e312f10eh, 06afe94a1h, 02c270b1dh
	dd	0bb5ce734h, 0c9bc759fh, 09b74ef2ch, 0d0e4345ch, 0c4f53153h, 077a3d461h, 067b7d06dh, 022a48697h
	dd	0e59b7e82h, 08e23adeah, 0d32efd1ah, 0a48d297bh, 0c0f03050h, 0ecd73b4dh, 046d99fbch, 0c73ff815h
	dd	03ff9c657h, 04c5f1335h, 0181e060ah, 01411050fh, 033f6c552h, 044551133h, 0c1b67799h, 0ed917c84h
	dd	0f58f7a8eh, 0fd857888h, 0d8ee365ah, 0706c1c24h, 0e4dd394bh, 0792059ebh, 060781828h, 0451356fah
	dd	0f645b3c8h, 0fa4ab0cdh, 090b4246ch, 080a02060h, 0f240b2cbh, 072e092abh, 0b615a3f8h, 027e7c05dh
	dd	00d4944cch, 095f762a6h, 040501030h, 0ea5eb4c1h, 02aae8491h, 0115243c5h, 076e593a8h, 02fedc25bh
	dd	0357f4adeh, 0ce73bddah, 006898f8ch, 0b4992d77h, 0ca76bcd9h, 04ad69cb9h, 0b5df6abeh, 01d5d40c0h
	dd	01bd4cf4ch, 0b210a2fbh, 03aba809dh, 0216e4fd1h, 07c631f21h, 00fc5ca43h, 09238aae3h, 0155742c6h

V2	dd	06a01bbb9h, 066b1e59ah, 014cde265h, 01b512587h, 057a4f7a2h, 0be03d0d6h, 0b504d6deh, 085feb352h
	dd	04aadfdbah, 0e063cf09h, 09684091ch, 04d1aa591h, 0374d3da7h, 05ca3f1aah, 017e17ba4h, 08ef9b55ah
	dd	020ac4603h, 08411c4e6h, 068c255cch, 0a80ddcc6h, 0d099aa85h, 041aafbb2h, 00f9cc7e2h, 0ae55f359h
	dd	0c120febeh, 0a2e5ad7ah, 0cc7fd729h, 00ae871bch, 0e63be096h, 0db9eac8dh, 0152295d1h, 0aace32b3h
	dd	07393704bh, 03bfd6384h, 052d041fch, 01ce67dach, 078947643h, 06106bdb1h, 0f1da9b32h, 0e5177957h
	dd	0b35cf941h, 0564b8016h, 0c20c677fh, 07ecc59dch, 09f40e161h, 0c3e310cbh, 02f3081e1h, 0160e0c10h
	dd	0675e922eh, 03f66a26eh, 0cf534ee8h, 09c6c78a0h, 00e73b056h, 09a34573fh, 0ed3ce69eh, 0358ed3d2h
	dd	02380dfc2h, 0d72ef2aeh, 0486e13cfh, 06c599426h, 05e601fdfh, 0049bc1eah, 0f3197547h, 03e89d5dah
	dd	0efff08ebh, 047f2d42dh, 0b7c738abh, 011b9543bh, 036a24a13h, 026f4699ch, 0ee107f5fh, 08b8d0304h
	dd	0e34f56c8h, 09447e769h, 0deea1ad3h, 0ba98113ch, 0692d2278h, 031151238h, 0fd6ac511h, 09bdb208bh
	dd	058383040h, 0976b7ea8h, 07f232e68h, 02c1c1820h, 00b070608h, 0ab214507h, 0ca27f8b6h, 00d5f2997h
	dd	064720befh, 0dc29f4a6h, 0b2b38ef5h, 08a6274b0h, 0a4bd82e5h, 0fc85b2a5h, 0f81e734fh, 095a890ddh
	dd	07708b1a1h, 02a4437bfh, 03da54c1bh, 0ea8bbeb5h, 06db6e392h, 03c4a3bafh, 0727c07ffh, 09d830f14h
	dd	0214331b7h, 0b19f1734h, 0e4f80ee3h, 033d6fc4dh, 0afba84edh, 02887d9cah, 04cf5d225h, 0c0cf890ah
	dd	074242860h, 0a026430fh, 0df056d67h, 08c3a5b2fh, 01d090a18h, 0187dbc46h, 07bb8ef82h, 09918cefeh
	dd	0f035ec86h, 01295cdfah, 0fb32ea8eh, 0bd2f4917h, 0921fc8f6h, 083a69ccdh, 04b428a0eh, 0b9b488fdh
	dd	090dc2683h, 063c553c4h, 0a552f551h, 001ef77b4h, 01abe5233h, 07c0fb7a9h, 0226fa876h, 0f66dc319h
	dd	0d4026b6fh, 0bfeca762h, 0d176dd31h, 0c778d121h, 0b6284f1fh, 04e363c50h, 0cbc88f02h, 0c8e416c3h
	dd	0032c99c1h, 06beecc0dh, 04981647bh, 00cb05e23h, 0461da399h, 038d1fa45h, 0e2a0217ch, 0a67e6c90h
	dd	0f4ae2d6ch, 0f5415ad8h, 0622a2470h, 060e9ca05h, 0f9f104fbh, 0ddc68312h, 076e7c615h, 071509e3eh
	dd	0a9e2ab72h, 009c4e87dh, 08dd52c9bh, 054886e63h, 01e2593d9h, 025d8f05dh, 0816572b8h, 0ffa92b64h
	dd	0fe465cd0h, 0ac961d2ch, 0bcc03ea3h, 0a7911b24h, 0533f3648h, 040458c06h, 0d8b2354ch, 098f7b94ah
	dd	0659d7c5bh, 01fcae46dh, 042866273h, 06e9a7a53h, 02bab400bh, 059d747f4h, 0b85bff49h, 0d25a44f0h
	dd	0cebc395ch, 0873d5d27h, 000000000h, 05afbde35h, 0f2f602f3h, 0d5ed1cdbh, 075cb5fd4h, 045313a58h
	dd	05f8f686bh, 01056238fh, 007b7582bh, 0e18cb8bdh, 0c697a695h, 08f16c2eeh, 0a30adaceh, 0d3b53344h
	dd	0556719d7h, 0eb64c901h, 0a1c934bbh, 02edff655h, 0cd90a09dh, 088a19ac5h, 030fa658ch, 086d22a93h
	dd	02968ae7eh, 0ad796a98h, 03a121430h, 0271b1e28h, 03461a466h, 0bb776688h, 006582f9fh, 0436915c7h
	dd	0797b01f7h, 06f750de7h, 0f782b4adh, 0c45448e0h, 09eaf96d5h, 01992cbf2h, 0e84850c0h, 070bfe98ah
	dd	0393e8df1h, 0243787e9h, 051fcd83dh, 07de0c01dh, 032398bf9h, 04fd94be4h, 0894eed71h, 0137aba4eh
	dd	0d6c1851ah, 091335137h, 0b0706080h, 0082b9fc9h, 0c5bb3f54h, 0e7d49722h, 044de4dech, 00574b65eh
	dd	0b4eba16ah, 05b14a981h, 0808a050ch, 002c3ee75h, 05013af89h, 02df36f94h, 0c90b6177h, 0fadd9d3ah
	dd	07a579836h, 08249eb79h, 0e9a72774h, 093f0bf42h, 0d95d42f8h, 05d4c861eh, 0da71db39h, 0ecd3912ah

U3	dd	068d2d3bah, 0194dfc54h, 093bc712fh, 0b9cd9c74h, 00251f553h, 0b86b68d3h, 0bd6f6bd2h, 06429d74dh
	dd	00d5df050h, 0268ae9ach, 0830e8a8dh, 079c6dcbfh, 0addd9070h, 00755f652h, 0c852b39ah, 0612dd44ch
	dd	0658f23eah, 0a67362d5h, 0f166a497h, 0b2636ed1h, 0ffcc5533h, 00859f351h, 02a71ed5bh, 004a2f7a6h
	dd	0815f7fdeh, 0753dd848h, 0329ae5a8h, 0c75eb699h, 0904b70dbh, 0fac85632h, 051e6c4b7h, 02bd719fch
	dd	048ab38e3h, 0dc42bf9eh, 0ef7eae91h, 0cd56b09bh, 04daf3be2h, 06dd6d0bbh, 05819c341h, 0cba5b26eh
	dd	00baef2a5h, 0c00b40cbh, 0dab1bd6bh, 0fb6ea295h, 01fbefea1h, 018eb08f3h, 04ffeceb1h, 00a080602h
	dd	0db1749cch, 0f33751c4h, 06974271dh, 044503c14h, 0e82b58c3h, 0f291a563h, 0954f73dah, 03469e75dh
	dd	03e61e15fh, 08b5779dch, 094e9877dh, 0de134acdh, 09ee1817fh, 02f75ee5ah, 0c1adb46ch, 0316de45ch
	dd	00cfb04f7h, 0be986a26h, 024db1cffh, 07e932aedh, 06f8725e8h, 0d34eba9dh, 0cea1b16fh, 08c028f8eh
	dd	07d642b19h, 01abafda0h, 017e70df0h, 0971e8689h, 0333c110fh, 01b1c0907h, 02986ecafh, 030cb10fbh
	dd	028201808h, 041543f15h, 03934170dh, 014100c04h, 005040301h, 0e98dac64h, 0845b7cdfh, 0b3c59a76h
	dd	080f98b79h, 08e537addh, 0c9f4473dh, 04e583a16h, 0c3fc413fh, 0ebdc5937h, 0c4a9b76dh, 0d8e04838h
	dd	067ded6b9h, 0a2d19573h, 06a8326e9h, 0e1d45f35h, 01c49ff55h, 0a8d99371h, 08af18d7bh, 0860a898ch
	dd	0a7d59672h, 0921a8588h, 009ff07f6h, 082a87e2ah, 0c6f8423eh, 03b65e25eh, 0bb9c6927h, 04305ca46h
	dd	03c30140ch, 0ec89af65h, 0d5bdb868h, 0f899a361h, 00f0c0503h, 0e2235ec1h, 01641f957h, 0a97f67d6h
	dd	09a4376d9h, 0257de858h, 09f4775d8h, 0e385aa66h, 0ac7b64d7h, 0d2e84e3ah, 0cf0745c8h, 0ccf0443ch
	dd	035cf13fah, 0f462a796h, 001a6f4a7h, 0c25ab598h, 07b9729ech, 062dad5b8h, 0fc3b54c7h, 02c82efaeh
	dd	0d0b9bb69h, 07a31dd4bh, 03d96e0abh, 0379ee6a9h, 0e681a967h, 022281e0ah, 04601c947h, 01def0bf2h
	dd	05beec2b5h, 0aa886622h, 056b332e5h, 0719f2feeh, 07cc2dfbeh, 087ac7d2bh, 0bf3e9e81h, 05a483612h
	dd	0b5369883h, 0776c2d1bh, 03638120eh, 0af8c6523h, 006f302f5h, 04c09cf45h, 0a5846321h, 0d11f4fceh
	dd	07039db49h, 09cb0742ch, 03ac316f9h, 059bf37e6h, 054e2c7b6h, 088a07828h, 04b5c3917h, 0b0329b82h
	dd	072682e1ah, 09d16808bh, 021df1ffeh, 09812838ah, 02d241b09h, 0ca0346c9h, 0a1269487h, 06b25d24eh
	dd	042a33ee1h, 096b8722eh, 053b731e4h, 047a73de0h, 0608b20ebh, 0ea7aad90h, 00eaaf1a4h, 06678221eh
	dd	0ab2e9285h, 0fd9da060h, 000000000h, 0b1946f25h, 003f701f4h, 012e30ef1h, 0fe6aa194h, 0272c1d0bh
	dd	05cbb34e7h, 0bcc99f75h, 0749b2cefh, 0e4d05c34h, 0f5c45331h, 0a37761d4h, 0b7676dd0h, 0a4229786h
	dd	09be5827eh, 0238eeaadh, 02ed31afdh, 08da47b29h, 0f0c05030h, 0d7ec4d3bh, 0d946bc9fh, 03fc715f8h
	dd	0f93f57c6h, 05f4c3513h, 01e180a06h, 011140f05h, 0f63352c5h, 055443311h, 0b6c19977h, 091ed847ch
	dd	08ff58e7ah, 085fd8878h, 0eed85a36h, 06c70241ch, 0dde44b39h, 02079eb59h, 078602818h, 01345fa56h
	dd	045f6c8b3h, 04afacdb0h, 0b4906c24h, 0a0806020h, 040f2cbb2h, 0e072ab92h, 015b6f8a3h, 0e7275dc0h
	dd	0490dcc44h, 0f795a662h, 050403010h, 05eeac1b4h, 0ae2a9184h, 05211c543h, 0e576a893h, 0ed2f5bc2h
	dd	07f35de4ah, 073cedabdh, 089068c8fh, 099b4772dh, 076cad9bch, 0d64ab99ch, 0dfb5be6ah, 05d1dc040h
	dd	0d41b4ccfh, 010b2fba2h, 0ba3a9d80h, 06e21d14fh, 0637c211fh, 0c50f43cah, 03892e3aah, 05715c642h

V3	dd	0016ab9bbh, 0b1669ae5h, 0cd1465e2h, 0511b8725h, 0a457a2f7h, 003bed6d0h, 004b5ded6h, 0fe8552b3h
	dd	0ad4abafdh, 063e009cfh, 084961c09h, 01a4d91a5h, 04d37a73dh, 0a35caaf1h, 0e117a47bh, 0f98e5ab5h
	dd	0ac200346h, 01184e6c4h, 0c268cc55h, 00da8c6dch, 099d085aah, 0aa41b2fbh, 09c0fe2c7h, 055ae59f3h
	dd	020c1befeh, 0e5a27aadh, 07fcc29d7h, 0e80abc71h, 03be696e0h, 09edb8dach, 02215d195h, 0ceaab332h
	dd	093734b70h, 0fd3b8463h, 0d052fc41h, 0e61cac7dh, 094784376h, 00661b1bdh, 0daf1329bh, 017e55779h
	dd	05cb341f9h, 04b561680h, 00cc27f67h, 0cc7edc59h, 0409f61e1h, 0e3c3cb10h, 0302fe181h, 00e16100ch
	dd	05e672e92h, 0663f6ea2h, 053cfe84eh, 06c9ca078h, 0730e56b0h, 0349a3f57h, 03ced9ee6h, 08e35d2d3h
	dd	08023c2dfh, 02ed7aef2h, 06e48cf13h, 0596c2694h, 0605edf1fh, 09b04eac1h, 019f34775h, 0893edad5h
	dd	0ffefeb08h, 0f2472dd4h, 0c7b7ab38h, 0b9113b54h, 0a236134ah, 0f4269c69h, 010ee5f7fh, 08d8b0403h
	dd	04fe3c856h, 0479469e7h, 0eaded31ah, 098ba3c11h, 02d697822h, 015313812h, 06afd11c5h, 0db9b8b20h
	dd	038584030h, 06b97a87eh, 0237f682eh, 01c2c2018h, 0070b0806h, 021ab0745h, 027cab6f8h, 05f0d9729h
	dd	07264ef0bh, 029dca6f4h, 0b3b2f58eh, 0628ab074h, 0bda4e582h, 085fca5b2h, 01ef84f73h, 0a895dd90h
	dd	00877a1b1h, 0442abf37h, 0a53d1b4ch, 08beab5beh, 0b66d92e3h, 04a3caf3bh, 07c72ff07h, 0839d140fh
	dd	04321b731h, 09fb13417h, 0f8e4e30eh, 0d6334dfch, 0baafed84h, 08728cad9h, 0f54c25d2h, 0cfc00a89h
	dd	024746028h, 026a00f43h, 005df676dh, 03a8c2f5bh, 0091d180ah, 07d1846bch, 0b87b82efh, 01899feceh
	dd	035f086ech, 09512facdh, 032fb8eeah, 02fbd1749h, 01f92f6c8h, 0a683cd9ch, 0424b0e8ah, 0b4b9fd88h
	dd	0dc908326h, 0c563c453h, 052a551f5h, 0ef01b477h, 0be1a3352h, 00f7ca9b7h, 06f2276a8h, 06df619c3h
	dd	002d46f6bh, 0ecbf62a7h, 076d131ddh, 078c721d1h, 028b61f4fh, 0364e503ch, 0c8cb028fh, 0e4c8c316h
	dd	02c03c199h, 0ee6b0dcch, 081497b64h, 0b00c235eh, 01d4699a3h, 0d13845fah, 0a0e27c21h, 07ea6906ch
	dd	0aef46c2dh, 041f5d85ah, 02a627024h, 0e96005cah, 0f1f9fb04h, 0c6dd1283h, 0e77615c6h, 050713e9eh
	dd	0e2a972abh, 0c4097de8h, 0d58d9b2ch, 08854636eh, 0251ed993h, 0d8255df0h, 06581b872h, 0a9ff642bh
	dd	046fed05ch, 096ac2c1dh, 0c0bca33eh, 091a7241bh, 03f534836h, 04540068ch, 0b2d84c35h, 0f7984ab9h
	dd	09d655b7ch, 0ca1f6de4h, 086427362h, 09a6e537ah, 0ab2b0b40h, 0d759f447h, 05bb849ffh, 05ad2f044h
	dd	0bcce5c39h, 03d87275dh, 000000000h, 0fb5a35deh, 0f6f2f302h, 0edd5db1ch, 0cb75d45fh, 03145583ah
	dd	08f5f6b68h, 056108f23h, 0b7072b58h, 08ce1bdb8h, 097c695a6h, 0168feec2h, 00aa3cedah, 0b5d34433h
	dd	06755d719h, 064eb01c9h, 0c9a1bb34h, 0df2e55f6h, 090cd9da0h, 0a188c59ah, 0fa308c65h, 0d286932ah
	dd	068297eaeh, 079ad986ah, 0123a3014h, 01b27281eh, 0613466a4h, 077bb8866h, 058069f2fh, 06943c715h
	dd	07b79f701h, 0756fe70dh, 082f7adb4h, 054c4e048h, 0af9ed596h, 09219f2cbh, 048e8c050h, 0bf708ae9h
	dd	03e39f18dh, 03724e987h, 0fc513dd8h, 0e07d1dc0h, 03932f98bh, 0d94fe44bh, 04e8971edh, 07a134ebah
	dd	0c1d61a85h, 033913751h, 070b08060h, 02b08c99fh, 0bbc5543fh, 0d4e72297h, 0de44ec4dh, 074055eb6h
	dd	0ebb46aa1h, 0145b81a9h, 08a800c05h, 0c30275eeh, 0135089afh, 0f32d946fh, 00bc97761h, 0ddfa3a9dh
	dd	0577a3698h, 0498279ebh, 0a7e97427h, 0f09342bfh, 05dd9f842h, 04c5d1e86h, 071da39dbh, 0d3ec2a91h

C_const	dd	0ba542f74h, 053d3d24dh, 050ac8dbfh, 070529a4ch, 0ead597d1h, 033515ba6h, 0de48a899h, 0db32b7fch
	dd	0e39e919bh, 0e2bb416eh, 0a5cb6b95h, 0a1f3b102h, 0ccc41d14h, 0c363da5dh, 05fdc7dcdh, 07f5a6c5ch
	dd	0f726ffedh, 0e89d6f8eh

ELSEIF		KHAZAD_VER	eq	1
U0	dd	0a7f4a601h, 0d3686bb8h, 0e637bf59h, 07193d9a8h, 0d06d67b7h, 0ace98a26h, 04dd72964h, 0798bf980h
	dd	03a4ee8d2h, 0c94603cah, 091ae7eefh, 0fc19d72bh, 01e227866h, 047c90146h, 054fc4d19h, 0bddace73h 
	dd	08c890a86h, 0a5f2ae0bh, 07a8ef58fh, 0fb10cb30h, 063a591f2h, 0b8d5da62h, 0dd7a538eh, 0d46177a3h 
	dd	0e532b356h, 0b3c8f645h, 0c55233f6h, 0bedfc27ch, 0a9e69e37h, 088851a92h, 00c14303ch, 0a2fbb210h 
	dd	0394be4ddh, 0df7c5b84h, 0297ba48dh, 0da734f95h, 02b7dac87h, 0a8e59a32h, 0cb400bc0h, 04cd42d61h 
	dd	04bdd317ah, 0226688aah, 0aae39238h, 0246c90b4h, 041c31958h, 07090ddadh, 0a6f7a204h, 0f916c33ah 
	dd	05aee752fh, 0e23baf4dh, 0b0cdfa4ah, 0365ad8eeh, 07d87e994h, 0e431b753h, 03355ccffh, 0ff1cdb24h 
	dd	060a09dfdh, 0206080a0h, 008182028h, 08b80169dh, 05ee2653bh, 0abe0963dh, 07f81e19eh, 07888fd85h 
	dd	07c84ed91h, 02c74b09ch, 057f94116h, 0d26b6fbdh, 0dc79578bh, 06db7a9c4h, 07e82e59bh, 00d173439h 
	dd	053f55102h, 094a16afeh, 0c3582be8h, 02878a088h, 027699cbbh, 0060a181eh, 05fe1613eh, 0adea8e23h 
	dd	067a981e6h, 05ce46d31h, 055ff491ch, 048d83d75h, 00e123836h, 052f65507h, 0ea238f65h, 042c61557h 
	dd	05bed712ah, 05de76934h, 03050c0f0h, 058e87d25h, 051f35908h, 059eb7920h, 03c44f0cch, 04ed2256bh 
	dd	03848e0d8h, 08a831298h, 07296d5a7h, 0143c5044h, 0e734bb5ch, 0c6573ff9h, 0de7f5f81h, 050f05d0dh 
	dd	08e8f028ch, 092ab72e0h, 0d16e63b2h, 07799c1b6h, 093a876e5h, 045cf094ch, 09ab352c8h, 0ce4f1fd1h 
	dd	02d77b499h, 003050c0fh, 062a695f7h, 0b6c7e254h, 0b9d6de67h, 0bfdcc679h, 096a762f4h, 06bbdb1dah 
	dd	03f41fcc3h, 007091c1bh, 01236485ah, 0aeef822ch, 040c01d5dh, 0345cd0e4h, 046ca0543h, 03e42f8c6h 
	dd	0db704b90h, 0cf4c1bd4h, 0ec29977bh, 0cc4917dbh, 0c15e23e2h, 0a1febe1fh, 0c05d27e7h, 0d6677fa9h 
	dd	01d277469h, 0f401f703h, 061a399f8h, 03b4decd7h, 010304050h, 0d875479fh, 068b8bdd5h, 0a0fdba1ah 
	dd	0b1cefe4fh, 00a1e2822h, 069bbb9d0h, 06cb4adc1h, 049db3970h, 0fa13cf35h, 0769ac5b3h, 0c45137f3h 
	dd	09ebf42dch, 09bb056cdh, 06eb2a5cbh, 099b65ec7h, 0c25b2fedh, 0b7c4e651h, 098b55ac2h, 0bcd9ca76h 
	dd	08f8c0689h, 085922eabh, 01f217c63h, 0b4c1ea5eh, 0f815c73fh, 011334455h, 02e72b896h, 000000000h 
	dd	0256f94b1h, 01c24706ch, 02a7ea882h, 03d47f4c9h, 0050f1411h, 04fd1216eh, 07b8df18ah, 0b2cbf240h 
	dd	03256c8fah, 090ad7aeah, 0afec8629h, 0192b647dh, 0a3f8b615h, 0f704fb0ch, 07395d1a2h, 09dba4ed3h 
	dd	0153f5441h, 0749ccdb9h, 0ee2f9f71h, 0ca430fc5h, 09fbc46d9h, 00f113c33h, 01b2d6c77h, 0759fc9bch 
	dd	0869722a4h, 084912aaeh, 09cb94ad6h, 04ade357fh, 097a466f1h, 01a2e6872h, 065af89ech, 0f607ff09h 
	dd	0ed2a937eh, 0091b242dh, 0bbd0d66dh, 0266a98beh, 0839836b5h, 0eb208b60h, 06fb1a1ceh, 0819e3ebfh 
	dd	0040c1014h, 06abeb5dfh, 043c51152h, 001030405h, 017395c4bh, 0e13ea342h, 0879426a1h, 0f502f306h 
	dd	08d8a0e83h, 0e338ab48h, 023658cafh, 0809d3abah, 044cc0d49h, 0163a584eh, 066aa85e3h, 0216384a5h 
	dd	0fe1fdf21h, 0d56273a6h, 03153c4f5h, 0d976439ah, 0355fd4e1h, 018286078h, 00206080ah, 064ac8de9h 
	dd	0f20bef1dh, 0f10ee312h, 056fa4513h, 0cd4a13deh, 0829b32b0h, 0c84507cfh, 0bad3d268h, 0f00de717h 
	dd	0ef2c9b74h, 0e926836ah, 0e825876fh, 0fd1ad32eh, 089861e97h, 0d7647bach, 0c7543bfch, 0b5c2ee5bh 
	dd	0a4f1aa0eh, 02f71bc93h, 095a26efbh, 013354c5fh, 00b1d2c27h, 0f308eb18h, 0e03da747h, 03759dcebh 

U1	dd	0f4a701a6h, 068d3b86bh, 037e659bfh, 09371a8d9h, 06dd0b767h, 0e9ac268ah, 0d74d6429h, 08b7980f9h 
	dd	04e3ad2e8h, 046c9ca03h, 0ae91ef7eh, 019fc2bd7h, 0221e6678h, 0c9474601h, 0fc54194dh, 0dabd73ceh 
	dd	0898c860ah, 0f2a50baeh, 08e7a8ff5h, 010fb30cbh, 0a563f291h, 0d5b862dah, 07add8e53h, 061d4a377h 
	dd	032e556b3h, 0c8b345f6h, 052c5f633h, 0dfbe7cc2h, 0e6a9379eh, 08588921ah, 0140c3c30h, 0fba210b2h 
	dd	04b39dde4h, 07cdf845bh, 07b298da4h, 073da954fh, 07d2b87ach, 0e5a8329ah, 040cbc00bh, 0d44c612dh 
	dd	0dd4b7a31h, 06622aa88h, 0e3aa3892h, 06c24b490h, 0c3415819h, 09070adddh, 0f7a604a2h, 016f93ac3h 
	dd	0ee5a2f75h, 03be24dafh, 0cdb04afah, 05a36eed8h, 0877d94e9h, 031e453b7h, 05533ffcch, 01cff24dbh 
	dd	0a060fd9dh, 06020a080h, 018082820h, 0808b9d16h, 0e25e3b65h, 0e0ab3d96h, 0817f9ee1h, 0887885fdh 
	dd	0847c91edh, 0742c9cb0h, 0f9571641h, 06bd2bd6fh, 079dc8b57h, 0b76dc4a9h, 0827e9be5h, 0170d3934h 
	dd	0f5530251h, 0a194fe6ah, 058c3e82bh, 0782888a0h, 06927bb9ch, 00a061e18h, 0e15f3e61h, 0eaad238eh 
	dd	0a967e681h, 0e45c316dh, 0ff551c49h, 0d848753dh, 0120e3638h, 0f6520755h, 023ea658fh, 0c6425715h 
	dd	0ed5b2a71h, 0e75d3469h, 05030f0c0h, 0e858257dh, 0f3510859h, 0eb592079h, 0443cccf0h, 0d24e6b25h 
	dd	04838d8e0h, 0838a9812h, 09672a7d5h, 03c144450h, 034e75cbbh, 057c6f93fh, 07fde815fh, 0f0500d5dh 
	dd	08f8e8c02h, 0ab92e072h, 06ed1b263h, 09977b6c1h, 0a893e576h, 0cf454c09h, 0b39ac852h, 04fced11fh 
	dd	0772d99b4h, 005030f0ch, 0a662f795h, 0c7b654e2h, 0d6b967deh, 0dcbf79c6h, 0a796f462h, 0bd6bdab1h 
	dd	0413fc3fch, 009071b1ch, 036125a48h, 0efae2c82h, 0c0405d1dh, 05c34e4d0h, 0ca464305h, 0423ec6f8h 
	dd	070db904bh, 04ccfd41bh, 029ec7b97h, 049ccdb17h, 05ec1e223h, 0fea11fbeh, 05dc0e727h, 067d6a97fh 
	dd	0271d6974h, 001f403f7h, 0a361f899h, 04d3bd7ech, 030105040h, 075d89f47h, 0b868d5bdh, 0fda01abah 
	dd	0ceb14ffeh, 01e0a2228h, 0bb69d0b9h, 0b46cc1adh, 0db497039h, 013fa35cfh, 09a76b3c5h, 051c4f337h 
	dd	0bf9edc42h, 0b09bcd56h, 0b26ecba5h, 0b699c75eh, 05bc2ed2fh, 0c4b751e6h, 0b598c25ah, 0d9bc76cah 
	dd	08c8f8906h, 09285ab2eh, 0211f637ch, 0c1b45eeah, 015f83fc7h, 033115544h, 0722e96b8h, 000000000h 
	dd	06f25b194h, 0241c6c70h, 07e2a82a8h, 0473dc9f4h, 00f051114h, 0d14f6e21h, 08d7b8af1h, 0cbb240f2h 
	dd	05632fac8h, 0ad90ea7ah, 0ecaf2986h, 02b197d64h, 0f8a315b6h, 004f70cfbh, 09573a2d1h, 0ba9dd34eh 
	dd	03f154154h, 09c74b9cdh, 02fee719fh, 043cac50fh, 0bc9fd946h, 0110f333ch, 02d1b776ch, 09f75bcc9h 
	dd	09786a422h, 09184ae2ah, 0b99cd64ah, 0de4a7f35h, 0a497f166h, 02e1a7268h, 0af65ec89h, 007f609ffh 
	dd	02aed7e93h, 01b092d24h, 0d0bb6dd6h, 06a26be98h, 09883b536h, 020eb608bh, 0b16fcea1h, 09e81bf3eh 
	dd	00c041410h, 0be6adfb5h, 0c5435211h, 003010504h, 039174b5ch, 03ee142a3h, 09487a126h, 002f506f3h 
	dd	08a8d830eh, 038e348abh, 06523af8ch, 09d80ba3ah, 0cc44490dh, 03a164e58h, 0aa66e385h, 06321a584h 
	dd	01ffe21dfh, 062d5a673h, 05331f5c4h, 076d99a43h, 05f35e1d4h, 028187860h, 006020a08h, 0ac64e98dh 
	dd	00bf21defh, 00ef112e3h, 0fa561345h, 04acdde13h, 09b82b032h, 045c8cf07h, 0d3ba68d2h, 00df017e7h 
	dd	02cef749bh, 026e96a83h, 025e86f87h, 01afd2ed3h, 08689971eh, 064d7ac7bh, 054c7fc3bh, 0c2b55beeh 
	dd	0f1a40eaah, 0712f93bch, 0a295fb6eh, 035135f4ch, 01d0b272ch, 008f318ebh, 03de047a7h, 05937ebdch 

U2	dd	0a601a7f4h, 06bb8d368h, 0bf59e637h, 0d9a87193h, 067b7d06dh, 08a26ace9h, 029644dd7h, 0f980798bh 
	dd	0e8d23a4eh, 003cac946h, 07eef91aeh, 0d72bfc19h, 078661e22h, 0014647c9h, 04d1954fch, 0ce73bddah 
	dd	00a868c89h, 0ae0ba5f2h, 0f58f7a8eh, 0cb30fb10h, 091f263a5h, 0da62b8d5h, 0538edd7ah, 077a3d461h 
	dd	0b356e532h, 0f645b3c8h, 033f6c552h, 0c27cbedfh, 09e37a9e6h, 01a928885h, 0303c0c14h, 0b210a2fbh 
	dd	0e4dd394bh, 05b84df7ch, 0a48d297bh, 04f95da73h, 0ac872b7dh, 09a32a8e5h, 00bc0cb40h, 02d614cd4h 
	dd	0317a4bddh, 088aa2266h, 09238aae3h, 090b4246ch, 0195841c3h, 0ddad7090h, 0a204a6f7h, 0c33af916h 
	dd	0752f5aeeh, 0af4de23bh, 0fa4ab0cdh, 0d8ee365ah, 0e9947d87h, 0b753e431h, 0ccff3355h, 0db24ff1ch 
	dd	09dfd60a0h, 080a02060h, 020280818h, 0169d8b80h, 0653b5ee2h, 0963dabe0h, 0e19e7f81h, 0fd857888h 
	dd	0ed917c84h, 0b09c2c74h, 0411657f9h, 06fbdd26bh, 0578bdc79h, 0a9c46db7h, 0e59b7e82h, 034390d17h 
	dd	0510253f5h, 06afe94a1h, 02be8c358h, 0a0882878h, 09cbb2769h, 0181e060ah, 0613e5fe1h, 08e23adeah 
	dd	081e667a9h, 06d315ce4h, 0491c55ffh, 03d7548d8h, 038360e12h, 0550752f6h, 08f65ea23h, 0155742c6h 
	dd	0712a5bedh, 069345de7h, 0c0f03050h, 07d2558e8h, 0590851f3h, 0792059ebh, 0f0cc3c44h, 0256b4ed2h 
	dd	0e0d83848h, 012988a83h, 0d5a77296h, 05044143ch, 0bb5ce734h, 03ff9c657h, 05f81de7fh, 05d0d50f0h 
	dd	0028c8e8fh, 072e092abh, 063b2d16eh, 0c1b67799h, 076e593a8h, 0094c45cfh, 052c89ab3h, 01fd1ce4fh 
	dd	0b4992d77h, 00c0f0305h, 095f762a6h, 0e254b6c7h, 0de67b9d6h, 0c679bfdch, 062f496a7h, 0b1da6bbdh 
	dd	0fcc33f41h, 01c1b0709h, 0485a1236h, 0822caeefh, 01d5d40c0h, 0d0e4345ch, 0054346cah, 0f8c63e42h 
	dd	04b90db70h, 01bd4cf4ch, 0977bec29h, 017dbcc49h, 023e2c15eh, 0be1fa1feh, 027e7c05dh, 07fa9d667h 
	dd	074691d27h, 0f703f401h, 099f861a3h, 0ecd73b4dh, 040501030h, 0479fd875h, 0bdd568b8h, 0ba1aa0fdh 
	dd	0fe4fb1ceh, 028220a1eh, 0b9d069bbh, 0adc16cb4h, 0397049dbh, 0cf35fa13h, 0c5b3769ah, 037f3c451h 
	dd	042dc9ebfh, 056cd9bb0h, 0a5cb6eb2h, 05ec799b6h, 02fedc25bh, 0e651b7c4h, 05ac298b5h, 0ca76bcd9h 
	dd	006898f8ch, 02eab8592h, 07c631f21h, 0ea5eb4c1h, 0c73ff815h, 044551133h, 0b8962e72h, 000000000h 
	dd	094b1256fh, 0706c1c24h, 0a8822a7eh, 0f4c93d47h, 01411050fh, 0216e4fd1h, 0f18a7b8dh, 0f240b2cbh 
	dd	0c8fa3256h, 07aea90adh, 08629afech, 0647d192bh, 0b615a3f8h, 0fb0cf704h, 0d1a27395h, 04ed39dbah 
	dd	05441153fh, 0cdb9749ch, 09f71ee2fh, 00fc5ca43h, 046d99fbch, 03c330f11h, 06c771b2dh, 0c9bc759fh 
	dd	022a48697h, 02aae8491h, 04ad69cb9h, 0357f4adeh, 066f197a4h, 068721a2eh, 089ec65afh, 0ff09f607h 
	dd	0937eed2ah, 0242d091bh, 0d66dbbd0h, 098be266ah, 036b58398h, 08b60eb20h, 0a1ce6fb1h, 03ebf819eh 
	dd	01014040ch, 0b5df6abeh, 0115243c5h, 004050103h, 05c4b1739h, 0a342e13eh, 026a18794h, 0f306f502h 
	dd	00e838d8ah, 0ab48e338h, 08caf2365h, 03aba809dh, 00d4944cch, 0584e163ah, 085e366aah, 084a52163h 
	dd	0df21fe1fh, 073a6d562h, 0c4f53153h, 0439ad976h, 0d4e1355fh, 060781828h, 0080a0206h, 08de964ach 
	dd	0ef1df20bh, 0e312f10eh, 0451356fah, 013decd4ah, 032b0829bh, 007cfc845h, 0d268bad3h, 0e717f00dh 
	dd	09b74ef2ch, 0836ae926h, 0876fe825h, 0d32efd1ah, 01e978986h, 07bacd764h, 03bfcc754h, 0ee5bb5c2h 
	dd	0aa0ea4f1h, 0bc932f71h, 06efb95a2h, 04c5f1335h, 02c270b1dh, 0eb18f308h, 0a747e03dh, 0dceb3759h 

U3	dd	001a6f4a7h, 0b86b68d3h, 059bf37e6h, 0a8d99371h, 0b7676dd0h, 0268ae9ach, 06429d74dh, 080f98b79h 
	dd	0d2e84e3ah, 0ca0346c9h, 0ef7eae91h, 02bd719fch, 06678221eh, 04601c947h, 0194dfc54h, 073cedabdh 
	dd	0860a898ch, 00baef2a5h, 08ff58e7ah, 030cb10fbh, 0f291a563h, 062dad5b8h, 08e537addh, 0a37761d4h 
	dd	056b332e5h, 045f6c8b3h, 0f63352c5h, 07cc2dfbeh, 0379ee6a9h, 0921a8588h, 03c30140ch, 010b2fba2h 
	dd	0dde44b39h, 0845b7cdfh, 08da47b29h, 0954f73dah, 087ac7d2bh, 0329ae5a8h, 0c00b40cbh, 0612dd44ch 
	dd	07a31dd4bh, 0aa886622h, 03892e3aah, 0b4906c24h, 05819c341h, 0addd9070h, 004a2f7a6h, 03ac316f9h 
	dd	02f75ee5ah, 04daf3be2h, 04afacdb0h, 0eed85a36h, 094e9877dh, 053b731e4h, 0ffcc5533h, 024db1cffh 
	dd	0fd9da060h, 0a0806020h, 028201808h, 09d16808bh, 03b65e25eh, 03d96e0abh, 09ee1817fh, 085fd8878h 
	dd	091ed847ch, 09cb0742ch, 01641f957h, 0bd6f6bd2h, 08b5779dch, 0c4a9b76dh, 09be5827eh, 03934170dh 
	dd	00251f553h, 0fe6aa194h, 0e82b58c3h, 088a07828h, 0bb9c6927h, 01e180a06h, 03e61e15fh, 0238eeaadh 
	dd	0e681a967h, 0316de45ch, 01c49ff55h, 0753dd848h, 03638120eh, 00755f652h, 0658f23eah, 05715c642h 
	dd	02a71ed5bh, 03469e75dh, 0f0c05030h, 0257de858h, 00859f351h, 02079eb59h, 0ccf0443ch, 06b25d24eh 
	dd	0d8e04838h, 09812838ah, 0a7d59672h, 044503c14h, 05cbb34e7h, 0f93f57c6h, 0815f7fdeh, 00d5df050h 
	dd	08c028f8eh, 0e072ab92h, 0b2636ed1h, 0b6c19977h, 0e576a893h, 04c09cf45h, 0c852b39ah, 0d11f4fceh 
	dd	099b4772dh, 00f0c0503h, 0f795a662h, 054e2c7b6h, 067ded6b9h, 079c6dcbfh, 0f462a796h, 0dab1bd6bh 
	dd	0c3fc413fh, 01b1c0907h, 05a483612h, 02c82efaeh, 05d1dc040h, 0e4d05c34h, 04305ca46h, 0c6f8423eh 
	dd	0904b70dbh, 0d41b4ccfh, 07b9729ech, 0db1749cch, 0e2235ec1h, 01fbefea1h, 0e7275dc0h, 0a97f67d6h 
	dd	06974271dh, 003f701f4h, 0f899a361h, 0d7ec4d3bh, 050403010h, 09f4775d8h, 0d5bdb868h, 01abafda0h 
	dd	04ffeceb1h, 022281e0ah, 0d0b9bb69h, 0c1adb46ch, 07039db49h, 035cf13fah, 0b3c59a76h, 0f33751c4h 
	dd	0dc42bf9eh, 0cd56b09bh, 0cba5b26eh, 0c75eb699h, 0ed2f5bc2h, 051e6c4b7h, 0c25ab598h, 076cad9bch 
	dd	089068c8fh, 0ab2e9285h, 0637c211fh, 05eeac1b4h, 03fc715f8h, 055443311h, 096b8722eh, 000000000h 
	dd	0b1946f25h, 06c70241ch, 082a87e2ah, 0c9f4473dh, 011140f05h, 06e21d14fh, 08af18d7bh, 040f2cbb2h 
	dd	0fac85632h, 0ea7aad90h, 02986ecafh, 07d642b19h, 015b6f8a3h, 00cfb04f7h, 0a2d19573h, 0d34eba9dh 
	dd	041543f15h, 0b9cd9c74h, 0719f2feeh, 0c50f43cah, 0d946bc9fh, 0333c110fh, 0776c2d1bh, 0bcc99f75h 
	dd	0a4229786h, 0ae2a9184h, 0d64ab99ch, 07f35de4ah, 0f166a497h, 072682e1ah, 0ec89af65h, 009ff07f6h 
	dd	07e932aedh, 02d241b09h, 06dd6d0bbh, 0be986a26h, 0b5369883h, 0608b20ebh, 0cea1b16fh, 0bf3e9e81h 
	dd	014100c04h, 0dfb5be6ah, 05211c543h, 005040301h, 04b5c3917h, 042a33ee1h, 0a1269487h, 006f302f5h 
	dd	0830e8a8dh, 048ab38e3h, 0af8c6523h, 0ba3a9d80h, 0490dcc44h, 04e583a16h, 0e385aa66h, 0a5846321h 
	dd	021df1ffeh, 0a67362d5h, 0f5c45331h, 09a4376d9h, 0e1d45f35h, 078602818h, 00a080602h, 0e98dac64h 
	dd	01def0bf2h, 012e30ef1h, 01345fa56h, 0de134acdh, 0b0329b82h, 0cf0745c8h, 068d2d3bah, 017e70df0h 
	dd	0749b2cefh, 06a8326e9h, 06f8725e8h, 02ed31afdh, 0971e8689h, 0ac7b64d7h, 0fc3b54c7h, 05beec2b5h 
	dd	00eaaf1a4h, 093bc712fh, 0fb6ea295h, 05f4c3513h, 0272c1d0bh, 018eb08f3h, 047a73de0h, 0ebdc5937h 

V0	dd	0f551a552h, 0d0d6be03h, 06e635488h, 03baf3c4ah, 0dacea30ah, 0cf09e063h, 0b35285feh, 00bef6472h 
	dd	09ccd83a6h, 08c064045h, 041fc52d0h, 032b3aaceh, 044f0d25ah, 08f02cbc8h, 0e59a66b1h, 0a9815b14h 
	dd	00f149d83h, 0f941b35ch, 001f7797bh, 0208b9bdbh, 0573f9a34h, 0b7a97c0fh, 0f4a6dc29h, 0c2ee8f16h 
	dd	0647b4981h, 08df1393eh, 0a4663461h, 0a399461dh, 0d121c778h, 01734b19fh, 028607424h, 0eb798249h 
	dd	096d59eafh, 0f8b6ca27h, 0f6552edfh, 0e69eed3ch, 0fa4538d1h, 0d729cc7fh, 08016564bh, 0b55a8ef9h 
	dd	0a762bfech, 0cc0d6beeh, 0db39da71h, 0d83d51fch, 09b32f1dah, 03da7374dh, 0f359ae55h, 02c9b8dd5h 
	dd	0c1ea049bh, 076437894h, 087e92437h, 0b4adf782h, 013cf486eh, 062734286h, 0aa85d099h, 038abb7c7h 
	dd	05d27873dh, 0c01d7de0h, 030405838h, 01d2cac96h, 0d9ca2887h, 0dd31d176h, 01fdf5e60h, 00de76f75h 
	dd	015c74369h, 0e87d09c4h, 0ef827bb8h, 0d6deb504h, 0f2aed72eh, 0734ff81eh, 019d75567h, 02e687f23h 
	dd	0f7a257a4h, 05fd475cbh, 0b0560e73h, 0f05d25d8h, 0d2254cf5h, 014303a12h, 0dfc22380h, 0c901eb64h 
	dd	04f1fb628h, 0d5da3e89h, 0e3926db6h, 0ad7aa2e5h, 02470622ah, 0f1aa5ca3h, 0460320ach, 0912aecd3h 
	dd	0c7e20f9ch, 0d3d2358eh, 0a09dcd90h, 0cdfa1295h, 0fbb241aah, 0cbf21992h, 088fdb9b4h, 0b94a98f7h 
	dd	090dd95a8h, 01b24a791h, 031b72143h, 078a09c6ch, 0686b5f8fh, 0ae7e2968h, 0febec120h, 0fdba4aadh 
	dd	003048b8dh, 04be44fd9h, 0dcc6a80dh, 02f9f0658h, 04dec44deh, 08312ddc6h, 07ba417e1h, 09e3e7150h 
	dd	0ee7502c3h, 00a181d09h, 051379133h, 093d91e25h, 0b1a17708h, 0a5914d1ah, 053c463c5h, 0677fc20ch 
	dd	082e5a4bdh, 012383115h, 06c90a67eh, 0c319f66dh, 09d3afaddh, 0b8bde18ch, 0890ac0cfh, 084edafbah 
	dd	0e096e63bh, 098367a57h, 052331abeh, 0922e675eh, 0bc46187dh, 0e1619f40h, 0ba4e137ah, 0cefe9918h 
	dd	04ee8cf53h, 002f3f2f6h, 05b2f8c3ah, 09ac588a1h, 06080b070h, 0ea8efb32h, 06d67df05h, 0e7699447h 
	dd	081e12f30h, 03c504e36h, 06b6fd402h, 07547f319h, 0ab72a9e2h, 0268390dch, 029970d5fh, 0a26e3f66h 
	dd	063843bfdh, 07dac1ce6h, 07957e517h, 071bc0ae8h, 0b65e0574h, 095d11522h, 077b401efh, 0af895013h 
	dd	0050c808ah, 0395ccebch, 042f8d95dh, 09fc9082bh, 02a9386d2h, 06688bb77h, 0e46d1fcah, 000000000h 
	dd	0de355afbh, 048e0c454h, 0fc4d33d6h, 08ef5b2b3h, 01e28271bh, 0bf4293f0h, 007ff727ch, 08bf93239h 
	dd	0ac8ddb9eh, 047f459d7h, 0c511fd6ah, 056c8e34fh, 0ed71894eh, 008ebefffh, 037bf2a44h, 0699c26f4h 
	dd	07ea8976bh, 025871b51h, 05e230cb0h, 0861e5d4ch, 0658c30fah, 02278692dh, 05ad8f541h, 0238f1056h 
	dd	03344d3b5h, 03f54c5bbh, 06f942df3h, 0a16ab4ebh, 055cc68c2h, 05cd0fe46h, 0430fa026h, 00ee3e4f8h 
	dd	0543b11b9h, 03648533fh, 0bdb16106h, 0d42d47f2h, 02d6cf4aeh, 0400b2babh, 07f5fee10h, 0217ce2a0h 
	dd	018202c1ch, 06177c90bh, 09722e7d4h, 006080b07h, 072b88165h, 07c5b659dh, 0354cd8b2h, 004fbf9f1h 
	dd	0091c9684h, 0704b7393h, 0ca0560e9h, 02774e9a7h, 0851ad6c1h, 074b08a62h, 04917bd2fh, 0c61576e7h 
	dd	03ea3bcc0h, 0c4e68411h, 0a695c697h, 0ec86f035h, 0beb5ea8bh, 050c0e848h, 00c10160eh, 04507ab21h 
	dd	016c3c8e4h, 01cdbd5edh, 0e98a70bfh, 094266c59h, 02b64ffa9h, 08a0e4b42h, 0bbb96a01h, 01ad3deeah 
	dd	0582b07b7h, 04c1b3da5h, 04a1336a2h, 034bba1c9h, 0113cba98h, 0c8f6921fh, 0a876226fh, 099c1032ch 
	dd	0ff49b85bh, 0e26514cdh, 059dc7ecch, 06a98ad79h, 03a584531h, 010cbc3e3h, 07a536e9ah, 0b2a5fc85h 

V1	dd	051f552a5h, 0d6d003beh, 0636e8854h, 0af3b4a3ch, 0ceda0aa3h, 009cf63e0h, 052b3fe85h, 0ef0b7264h 
	dd	0cd9ca683h, 0068c4540h, 0fc41d052h, 0b332ceaah, 0f0445ad2h, 0028fc8cbh, 09ae5b166h, 081a9145bh 
	dd	0140f839dh, 041f95cb3h, 0f7017b79h, 08b20db9bh, 03f57349ah, 0a9b70f7ch, 0a6f429dch, 0eec2168fh 
	dd	07b648149h, 0f18d3e39h, 066a46134h, 099a31d46h, 021d178c7h, 034179fb1h, 060282474h, 079eb4982h 
	dd	0d596af9eh, 0b6f827cah, 055f6df2eh, 09ee63cedh, 045fad138h, 029d77fcch, 016804b56h, 05ab5f98eh 
	dd	062a7ecbfh, 00dccee6bh, 039db71dah, 03dd8fc51h, 0329bdaf1h, 0a73d4d37h, 059f355aeh, 09b2cd58dh 
	dd	0eac19b04h, 043769478h, 0e9873724h, 0adb482f7h, 0cf136e48h, 073628642h, 085aa99d0h, 0ab38c7b7h 
	dd	0275d3d87h, 01dc0e07dh, 040303858h, 02c1d96ach, 0cad98728h, 031dd76d1h, 0df1f605eh, 0e70d756fh 
	dd	0c7156943h, 07de8c409h, 082efb87bh, 0ded604b5h, 0aef22ed7h, 04f731ef8h, 0d7196755h, 0682e237fh 
	dd	0a2f7a457h, 0d45fcb75h, 056b0730eh, 05df0d825h, 025d2f54ch, 03014123ah, 0c2df8023h, 001c964ebh 
	dd	01f4f28b6h, 0dad5893eh, 092e3b66dh, 07aade5a2h, 070242a62h, 0aaf1a35ch, 00346ac20h, 02a91d3ech 
	dd	0e2c79c0fh, 0d2d38e35h, 09da090cdh, 0facd9512h, 0b2fbaa41h, 0f2cb9219h, 0fd88b4b9h, 04ab9f798h 
	dd	0dd90a895h, 0241b91a7h, 0b7314321h, 0a0786c9ch, 06b688f5fh, 07eae6829h, 0befe20c1h, 0bafdad4ah 
	dd	004038d8bh, 0e44bd94fh, 0c6dc0da8h, 09f2f5806h, 0ec4dde44h, 01283c6ddh, 0a47be117h, 03e9e5071h 
	dd	075eec302h, 0180a091dh, 037513391h, 0d993251eh, 0a1b10877h, 091a51a4dh, 0c453c563h, 07f670cc2h 
	dd	0e582bda4h, 038121531h, 0906c7ea6h, 019c36df6h, 03a9dddfah, 0bdb88ce1h, 00a89cfc0h, 0ed84baafh 
	dd	096e03be6h, 03698577ah, 03352be1ah, 02e925e67h, 046bc7d18h, 061e1409fh, 04eba7a13h, 0fece1899h 
	dd	0e84e53cfh, 0f302f6f2h, 02f5b3a8ch, 0c59aa188h, 0806070b0h, 08eea32fbh, 0676d05dfh, 069e74794h 
	dd	0e181302fh, 0503c364eh, 06f6b02d4h, 0477519f3h, 072abe2a9h, 08326dc90h, 097295f0dh, 06ea2663fh 
	dd	08463fd3bh, 0ac7de61ch, 0577917e5h, 0bc71e80ah, 05eb67405h, 0d1952215h, 0b477ef01h, 089af1350h 
	dd	00c058a80h, 05c39bcceh, 0f8425dd9h, 0c99f2b08h, 0932ad286h, 0886677bbh, 06de4ca1fh, 000000000h 
	dd	035defb5ah, 0e04854c4h, 04dfcd633h, 0f58eb3b2h, 0281e1b27h, 042bff093h, 0ff077c72h, 0f98b3932h 
	dd	08dac9edbh, 0f447d759h, 011c56afdh, 0c8564fe3h, 071ed4e89h, 0eb08ffefh, 0bf37442ah, 09c69f426h 
	dd	0a87e6b97h, 08725511bh, 0235eb00ch, 01e864c5dh, 08c65fa30h, 078222d69h, 0d85a41f5h, 08f235610h 
	dd	04433b5d3h, 0543fbbc5h, 0946ff32dh, 06aa1ebb4h, 0cc55c268h, 0d05c46feh, 00f4326a0h, 0e30ef8e4h 
	dd	03b54b911h, 048363f53h, 0b1bd0661h, 02dd4f247h, 06c2daef4h, 00b40ab2bh, 05f7f10eeh, 07c21a0e2h 
	dd	020181c2ch, 077610bc9h, 02297d4e7h, 00806070bh, 0b8726581h, 05b7c9d65h, 04c35b2d8h, 0fb04f1f9h 
	dd	01c098496h, 04b709373h, 005cae960h, 07427a7e9h, 01a85c1d6h, 0b074628ah, 017492fbdh, 015c6e776h 
	dd	0a33ec0bch, 0e6c41184h, 095a697c6h, 086ec35f0h, 0b5be8beah, 0c05048e8h, 0100c0e16h, 0074521abh 
	dd	0c316e4c8h, 0db1cedd5h, 08ae9bf70h, 02694596ch, 0642ba9ffh, 00e8a424bh, 0b9bb016ah, 0d31aeadeh 
	dd	02b58b707h, 01b4ca53dh, 0134aa236h, 0bb34c9a1h, 03c1198bah, 0f6c81f92h, 076a86f22h, 0c1992c03h 
	dd	049ff5bb8h, 065e2cd14h, 0dc59cc7eh, 0986a79adh, 0583a3145h, 0cb10e3c3h, 0537a9a6eh, 0a5b285fch 

V2	dd	0a552f551h, 0be03d0d6h, 054886e63h, 03c4a3bafh, 0a30adaceh, 0e063cf09h, 085feb352h, 064720befh 
	dd	083a69ccdh, 040458c06h, 052d041fch, 0aace32b3h, 0d25a44f0h, 0cbc88f02h, 066b1e59ah, 05b14a981h 
	dd	09d830f14h, 0b35cf941h, 0797b01f7h, 09bdb208bh, 09a34573fh, 07c0fb7a9h, 0dc29f4a6h, 08f16c2eeh 
	dd	04981647bh, 0393e8df1h, 03461a466h, 0461da399h, 0c778d121h, 0b19f1734h, 074242860h, 08249eb79h 
	dd	09eaf96d5h, 0ca27f8b6h, 02edff655h, 0ed3ce69eh, 038d1fa45h, 0cc7fd729h, 0564b8016h, 08ef9b55ah 
	dd	0bfeca762h, 06beecc0dh, 0da71db39h, 051fcd83dh, 0f1da9b32h, 0374d3da7h, 0ae55f359h, 08dd52c9bh 
	dd	0049bc1eah, 078947643h, 0243787e9h, 0f782b4adh, 0486e13cfh, 042866273h, 0d099aa85h, 0b7c738abh 
	dd	0873d5d27h, 07de0c01dh, 058383040h, 0ac961d2ch, 02887d9cah, 0d176dd31h, 05e601fdfh, 06f750de7h 
	dd	0436915c7h, 009c4e87dh, 07bb8ef82h, 0b504d6deh, 0d72ef2aeh, 0f81e734fh, 0556719d7h, 07f232e68h 
	dd	057a4f7a2h, 075cb5fd4h, 00e73b056h, 025d8f05dh, 04cf5d225h, 03a121430h, 02380dfc2h, 0eb64c901h 
	dd	0b6284f1fh, 03e89d5dah, 06db6e392h, 0a2e5ad7ah, 0622a2470h, 05ca3f1aah, 020ac4603h, 0ecd3912ah 
	dd	00f9cc7e2h, 0358ed3d2h, 0cd90a09dh, 01295cdfah, 041aafbb2h, 01992cbf2h, 0b9b488fdh, 098f7b94ah 
	dd	095a890ddh, 0a7911b24h, 0214331b7h, 09c6c78a0h, 05f8f686bh, 02968ae7eh, 0c120febeh, 04aadfdbah 
	dd	08b8d0304h, 04fd94be4h, 0a80ddcc6h, 006582f9fh, 044de4dech, 0ddc68312h, 017e17ba4h, 071509e3eh 
	dd	002c3ee75h, 01d090a18h, 091335137h, 01e2593d9h, 07708b1a1h, 04d1aa591h, 063c553c4h, 0c20c677fh 
	dd	0a4bd82e5h, 031151238h, 0a67e6c90h, 0f66dc319h, 0fadd9d3ah, 0e18cb8bdh, 0c0cf890ah, 0afba84edh 
	dd	0e63be096h, 07a579836h, 01abe5233h, 0675e922eh, 0187dbc46h, 09f40e161h, 0137aba4eh, 09918cefeh 
	dd	0cf534ee8h, 0f2f602f3h, 08c3a5b2fh, 088a19ac5h, 0b0706080h, 0fb32ea8eh, 0df056d67h, 09447e769h 
	dd	02f3081e1h, 04e363c50h, 0d4026b6fh, 0f3197547h, 0a9e2ab72h, 090dc2683h, 00d5f2997h, 03f66a26eh 
	dd	03bfd6384h, 01ce67dach, 0e5177957h, 00ae871bch, 00574b65eh, 0152295d1h, 001ef77b4h, 05013af89h 
	dd	0808a050ch, 0cebc395ch, 0d95d42f8h, 0082b9fc9h, 086d22a93h, 0bb776688h, 01fcae46dh, 000000000h 
	dd	05afbde35h, 0c45448e0h, 033d6fc4dh, 0b2b38ef5h, 0271b1e28h, 093f0bf42h, 0727c07ffh, 032398bf9h 
	dd	0db9eac8dh, 059d747f4h, 0fd6ac511h, 0e34f56c8h, 0894eed71h, 0efff08ebh, 02a4437bfh, 026f4699ch 
	dd	0976b7ea8h, 01b512587h, 00cb05e23h, 05d4c861eh, 030fa658ch, 0692d2278h, 0f5415ad8h, 01056238fh 
	dd	0d3b53344h, 0c5bb3f54h, 02df36f94h, 0b4eba16ah, 068c255cch, 0fe465cd0h, 0a026430fh, 0e4f80ee3h 
	dd	011b9543bh, 0533f3648h, 06106bdb1h, 047f2d42dh, 0f4ae2d6ch, 02bab400bh, 0ee107f5fh, 0e2a0217ch 
	dd	02c1c1820h, 0c90b6177h, 0e7d49722h, 00b070608h, 0816572b8h, 0659d7c5bh, 0d8b2354ch, 0f9f104fbh 
	dd	09684091ch, 07393704bh, 060e9ca05h, 0e9a72774h, 0d6c1851ah, 08a6274b0h, 0bd2f4917h, 076e7c615h 
	dd	0bcc03ea3h, 08411c4e6h, 0c697a695h, 0f035ec86h, 0ea8bbeb5h, 0e84850c0h, 0160e0c10h, 0ab214507h 
	dd	0c8e416c3h, 0d5ed1cdbh, 070bfe98ah, 06c599426h, 0ffa92b64h, 04b428a0eh, 06a01bbb9h, 0deea1ad3h 
	dd	007b7582bh, 03da54c1bh, 036a24a13h, 0a1c934bbh, 0ba98113ch, 0921fc8f6h, 0226fa876h, 0032c99c1h 
	dd	0b85bff49h, 014cde265h, 07ecc59dch, 0ad796a98h, 045313a58h, 0c3e310cbh, 06e9a7a53h, 0fc85b2a5h 

V3	dd	052a551f5h, 003bed6d0h, 08854636eh, 04a3caf3bh, 00aa3cedah, 063e009cfh, 0fe8552b3h, 07264ef0bh 
	dd	0a683cd9ch, 04540068ch, 0d052fc41h, 0ceaab332h, 05ad2f044h, 0c8cb028fh, 0b1669ae5h, 0145b81a9h 
	dd	0839d140fh, 05cb341f9h, 07b79f701h, 0db9b8b20h, 0349a3f57h, 00f7ca9b7h, 029dca6f4h, 0168feec2h 
	dd	081497b64h, 03e39f18dh, 0613466a4h, 01d4699a3h, 078c721d1h, 09fb13417h, 024746028h, 0498279ebh 
	dd	0af9ed596h, 027cab6f8h, 0df2e55f6h, 03ced9ee6h, 0d13845fah, 07fcc29d7h, 04b561680h, 0f98e5ab5h 
	dd	0ecbf62a7h, 0ee6b0dcch, 071da39dbh, 0fc513dd8h, 0daf1329bh, 04d37a73dh, 055ae59f3h, 0d58d9b2ch 
	dd	09b04eac1h, 094784376h, 03724e987h, 082f7adb4h, 06e48cf13h, 086427362h, 099d085aah, 0c7b7ab38h 
	dd	03d87275dh, 0e07d1dc0h, 038584030h, 096ac2c1dh, 08728cad9h, 076d131ddh, 0605edf1fh, 0756fe70dh 
	dd	06943c715h, 0c4097de8h, 0b87b82efh, 004b5ded6h, 02ed7aef2h, 01ef84f73h, 06755d719h, 0237f682eh 
	dd	0a457a2f7h, 0cb75d45fh, 0730e56b0h, 0d8255df0h, 0f54c25d2h, 0123a3014h, 08023c2dfh, 064eb01c9h 
	dd	028b61f4fh, 0893edad5h, 0b66d92e3h, 0e5a27aadh, 02a627024h, 0a35caaf1h, 0ac200346h, 0d3ec2a91h 
	dd	09c0fe2c7h, 08e35d2d3h, 090cd9da0h, 09512facdh, 0aa41b2fbh, 09219f2cbh, 0b4b9fd88h, 0f7984ab9h 
	dd	0a895dd90h, 091a7241bh, 04321b731h, 06c9ca078h, 08f5f6b68h, 068297eaeh, 020c1befeh, 0ad4abafdh 
	dd	08d8b0403h, 0d94fe44bh, 00da8c6dch, 058069f2fh, 0de44ec4dh, 0c6dd1283h, 0e117a47bh, 050713e9eh 
	dd	0c30275eeh, 0091d180ah, 033913751h, 0251ed993h, 00877a1b1h, 01a4d91a5h, 0c563c453h, 00cc27f67h 
	dd	0bda4e582h, 015313812h, 07ea6906ch, 06df619c3h, 0ddfa3a9dh, 08ce1bdb8h, 0cfc00a89h, 0baafed84h 
	dd	03be696e0h, 0577a3698h, 0be1a3352h, 05e672e92h, 07d1846bch, 0409f61e1h, 07a134ebah, 01899feceh 
	dd	053cfe84eh, 0f6f2f302h, 03a8c2f5bh, 0a188c59ah, 070b08060h, 032fb8eeah, 005df676dh, 0479469e7h 
	dd	0302fe181h, 0364e503ch, 002d46f6bh, 019f34775h, 0e2a972abh, 0dc908326h, 05f0d9729h, 0663f6ea2h 
	dd	0fd3b8463h, 0e61cac7dh, 017e55779h, 0e80abc71h, 074055eb6h, 02215d195h, 0ef01b477h, 0135089afh 
	dd	08a800c05h, 0bcce5c39h, 05dd9f842h, 02b08c99fh, 0d286932ah, 077bb8866h, 0ca1f6de4h, 000000000h 
	dd	0fb5a35deh, 054c4e048h, 0d6334dfch, 0b3b2f58eh, 01b27281eh, 0f09342bfh, 07c72ff07h, 03932f98bh 
	dd	09edb8dach, 0d759f447h, 06afd11c5h, 04fe3c856h, 04e8971edh, 0ffefeb08h, 0442abf37h, 0f4269c69h 
	dd	06b97a87eh, 0511b8725h, 0b00c235eh, 04c5d1e86h, 0fa308c65h, 02d697822h, 041f5d85ah, 056108f23h 
	dd	0b5d34433h, 0bbc5543fh, 0f32d946fh, 0ebb46aa1h, 0c268cc55h, 046fed05ch, 026a00f43h, 0f8e4e30eh 
	dd	0b9113b54h, 03f534836h, 00661b1bdh, 0f2472dd4h, 0aef46c2dh, 0ab2b0b40h, 010ee5f7fh, 0a0e27c21h 
	dd	01c2c2018h, 00bc97761h, 0d4e72297h, 0070b0806h, 06581b872h, 09d655b7ch, 0b2d84c35h, 0f1f9fb04h 
	dd	084961c09h, 093734b70h, 0e96005cah, 0a7e97427h, 0c1d61a85h, 0628ab074h, 02fbd1749h, 0e77615c6h 
	dd	0c0bca33eh, 01184e6c4h, 097c695a6h, 035f086ech, 08beab5beh, 048e8c050h, 00e16100ch, 021ab0745h 
	dd	0e4c8c316h, 0edd5db1ch, 0bf708ae9h, 0596c2694h, 0a9ff642bh, 0424b0e8ah, 0016ab9bbh, 0eaded31ah 
	dd	0b7072b58h, 0a53d1b4ch, 0a236134ah, 0c9a1bb34h, 098ba3c11h, 01f92f6c8h, 06f2276a8h, 02c03c199h 
	dd	05bb849ffh, 0cd1465e2h, 0cc7edc59h, 079ad986ah, 03145583ah, 0e3c3cb10h, 09a6e537ah, 085fca5b2h 

C_const	dd	0a7d3e671h, 0d0ac4d79h, 03ac991fch, 01e4754bdh, 08ca57afbh, 063b8ddd4h,	0e5b3c5beh, 0a9880ca2h
	dd	039df29dah, 02ba8cb4ch,	04b22aa24h, 04170a6f9h,	05ae2b036h, 07de433ffh,	06020088bh, 05eab7f78h
	dd	07c2c57d2h, 0dc6d7e0dh
ENDIF