comment *

Algo	: FEAL-N (Fast Data Encipherment Algorithm)
Block	: 8 bytes
Rounds	: N
Key	: 8 bytes (64 b)

N = 2^x ie. 2,4,8,16,32.. max. 256 in this implementation


	push	lPass			;password length in bytes
	push	offset Pass		;password ptr
	call	FealN_SetKey

	push	offset plain		;data to encrypt ptr
	push	offset encrypted_buf	;destination ptr
	call	FealN_Encrypt

	push	offset encrypted_buf	;data to decrypt ptr
	push	offset plain		;destination ptr
	call	FealN_Decrypt
	
	call	FealN_Clear		;clear temporary data !


Test vectors	:
key		: 0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF
plain		: 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
FEAL- 8 cipher	: 0xCE, 0xEF, 0x2C, 0x86, 0xF2, 0x49, 0x07, 0x52
FEAL-16 cipher	: 0x3A, 0xDE, 0x0D, 0x2A, 0xD8, 0x4D, 0x0B, 0x6F
FEAL-32 cipher	: 0x69, 0xB0, 0xFA, 0xE6, 0xDD, 0xED, 0x6B, 0x0B

FEAL is patented in the United States and has patents pending in
England, France, and Germany.


30.04.2002 WiteG//xtreeme (witeg@poczta.fm, www.witeg.prv.pl)
*


; ----------------------------------------------------------------------------
; You should set number of rounds !
; ----------------------------------------------------------------------------

FEAL_ROUND	equ	32




.code
FealN_SetKey	proc	ptrPass:DWORD

	pushad

	mov	edi, ptrPass
	mov	esi, offset temp_buffer

	push	dword ptr [edi]
	push	dword ptr [edi+4]
	pop	dword ptr [esi+4]
	pop	dword ptr [esi]

	mov	ebx, offset internal_pass
	xor	eax, eax
	xor	edx, edx
	xor	ebp, ebp
	mov	cl, FEAL_ROUND/2+4

@@:
	mov	ah, byte ptr [esi]
	mov	dl, byte ptr [esi+2]
	xor	ah, byte ptr [esi+1]
	xor	dl, byte ptr [esi+3]
	mov	ch, byte ptr [esi+4]
	inc	ah
	xor	ch, dl
	mov	al, byte ptr [esi+6]
	add	ah, ch
	mov	dh, byte ptr [esi+7]
	rol	ah, 2
	mov	ch, byte ptr [esi+5]
	xor	ch, ah
	add	dl, ch
	xor	al, ah
	rol	dl, 2
	add	al, byte ptr [esi]
	xor	dh, dl
	rol	al, 2
	add	dh, byte ptr [esi+3]
	mov	word ptr [ebx], ax
	inc	dh
	xor	ebp, dword ptr [esi+4]
	rol	dh, 2
	xchg	ebp, dword ptr [esi]
	mov	word ptr [ebx+2], dx
	mov	edi, ebp
	xor	edi, dword ptr [ebx]
	add	ebx, 4
	dec	cl
	mov	dword ptr [esi+4], edi
	jnz	@B
	
	and	dword ptr [esi], 0
	and	dword ptr [esi+4], 0
	popad
	ret
FealN_SetKey	endp

FealN_Encrypt	proc	ptrOut:DWORD, ptrIn:DWORD

	pushad

	mov	esi, ptrIn
	mov	edi, ptrOut
	mov	ebx, offset internal_pass
	
	mov	ebp, dword ptr [esi]
	mov	esi, dword ptr [esi+4]

	xor	ebp, dword ptr [ebx+FEAL_ROUND*2]
	xor	esi, dword ptr [ebx+FEAL_ROUND*2 +4]
	xor	esi, ebp
	mov	cl, FEAL_ROUND

@@:
	push	esi		;[esp] = temp buffer
	mov	ch, byte ptr [esp]
	mov	al, byte ptr [esp+2]
	xor	ch, byte ptr [esp+1]
	xor	al, byte ptr [ebx+1]
	xor	ch, byte ptr [ebx]
	xor	al, byte ptr [esp+3]
	mov	ah, byte ptr [esp+3]
	add	ch, al
	inc	ah
	inc	ch
	add	ebx, 2
	rol	ch, 2
	add	al, ch
	rol	al, 2
	add	ah, al
	rol	ah, 2
	shl	eax, 16
	xchg	ebp, esi
	mov	al, ch
	add	al, byte ptr [esp]
	mov	ah, ch
	rol	al, 2
	add	esp, 4
	xor	esi, eax
	dec	cl
	jnz	@B

	and	dword ptr [esp-4],0
	xor	ebp, esi
	xor	ebp, dword ptr [ebx+12]
	xor	esi, dword ptr [ebx+8]
	mov	dword ptr [edi+4], ebp
	mov	dword ptr [edi], esi	
	popad
	ret
FealN_Encrypt	endp

FealN_Decrypt	proc	ptrOut:DWORD, ptrIn:DWORD

	pushad

	mov	esi, ptrIn
	mov	edi, ptrOut
	mov	ebx, offset internal_pass + FEAL_ROUND*2 - 2
	
	mov	ebp, dword ptr [esi]
	mov	esi, dword ptr [esi+4]

	xor	ebp, dword ptr [ebx+10]
	xor	esi, dword ptr [ebx+14]
	xor	esi, ebp
	mov	cl, FEAL_ROUND

@@:
	push	esi		;[esp] = temp buffer
	mov	ch, byte ptr [esp]
	mov	al, byte ptr [esp+2]
	xor	ch, byte ptr [esp+1]
	xor	al, byte ptr [ebx+1]
	xor	ch, byte ptr [ebx]
	xor	al, byte ptr [esp+3]
	mov	ah, byte ptr [esp+3]
	add	ch, al
	inc	ah
	inc	ch
	sub	ebx, 2
	rol	ch, 2
	add	al, ch
	rol	al, 2
	add	ah, al
	rol	ah, 2
	shl	eax, 16
	xchg	ebp, esi
	mov	al, ch
	add	al, byte ptr [esp]
	mov	ah, ch
	rol	al, 2
	add	esp, 4
	xor	esi, eax
	dec	cl
	jnz	@B

	and	dword ptr [esp-4],0
	xor	ebp, esi
	xor	ebp, dword ptr [ebx+FEAL_ROUND*2+2+4]
	xor	esi, dword ptr [ebx+FEAL_ROUND*2+2]
	mov	dword ptr [edi+4], ebp
	mov	dword ptr [edi], esi	
	popad
	ret
FealN_Decrypt	endp

FealN_Clear	proc
	push	ecx
	mov	ecx, FEAL_ROUND*2 + 16 - 4
@@:
	and	dword ptr [internal_pass+ecx],0
	sub	ecx, 4
	jns	@B

	pop	ecx
	ret
FealN_Clear	endp

.data?
internal_pass	dd FEAL_ROUND/2+4 dup (?)
temp_buffer	db 8 dup (?)