comment *

Algo	: E2 by Nippon Telegraph and Telephone (NTT) Japan
Block	: 16 bytes
Key	: 16 / 24 / 32 bytes (128b / 192b / 256b)

	push	offset password
	call	E2_SetKey

	push	offset DataIn		;plaintext
	push	offset DataOut		;buffer for ciphertext
	call	E2_Encrypt

	push	offset DataOut		;ciphertext
	push	offset DataOut		;buffer for ciphertext
	call	E2_Decrypt

	call	E2_Clear

16.03.2003 WiteG//xtreeme (witeg@poczta.fm, www.witeg.prv.pl)
*

; ---------------------------------------------------------------------------
; You should set key size (KEY_SIZE)
; ---------------------------------------------------------------------------

KEY_SIZE	equ	128		; 128, 192 or 256

; ---------------------------------------------------------------------------

E2_SetKey	PROTO	:DWORD
E2_Encrypt	PROTO	:DWORD, :DWORD
E2_Decrypt	PROTO	:DWORD, :DWORD
E2_Clear	PROTO

.data?
e2_internalKey	dd 72 dup (?)
e2_subkey	dd  8 dup (?)		;lout
e2_tempkey	dd  8 dup (?)		;lk


.data		
e2_sbox		db  0e1h, 042h, 03eh, 081h, 04eh, 017h, 09eh, 0fdh, 0b4h, 03fh, 02ch, 0dah, 031h, 01eh, 0e0h, 041h
		db  0cch, 0f3h, 082h, 07dh, 07ch, 012h, 08eh, 0bbh, 0e4h, 058h, 015h, 0d5h, 06fh, 0e9h, 04ch, 04bh
		db  035h, 07bh, 05ah, 09ah, 090h, 045h, 0bch, 0f8h, 079h, 0d6h, 01bh, 088h, 002h, 0abh, 0cfh, 064h
		db  009h, 00ch, 0f0h, 001h, 0a4h, 0b0h, 0f6h, 093h, 043h, 063h, 086h, 0dch, 011h, 0a5h, 083h, 08bh
		db  0c9h, 0d0h, 019h, 095h, 06ah, 0a1h, 05ch, 024h, 06eh, 050h, 021h, 080h, 02fh, 0e7h, 053h, 00fh
		db  091h, 022h, 004h, 0edh, 0a6h, 048h, 049h, 067h, 0ech, 0f7h, 0c0h, 039h, 0ceh, 0f2h, 02dh, 0beh
		db  05dh, 01ch, 0e3h, 087h, 007h, 00dh, 07ah, 0f4h, 0fbh, 032h, 0f5h, 08ch, 0dbh, 08fh, 025h, 096h
		db  0a8h, 0eah, 0cdh, 033h, 065h, 054h, 006h, 08dh, 089h, 00ah, 05eh, 0d9h, 016h, 00eh, 071h, 06ch
		db  00bh, 0ffh, 060h, 0d2h, 02eh, 0d3h, 0c8h, 055h, 0c2h, 023h, 0b7h, 074h, 0e2h, 09bh, 0dfh, 077h
		db  02bh, 0b9h, 03ch, 062h, 013h, 0e5h, 094h, 034h, 0b1h, 027h, 084h, 09fh, 0d7h, 051h, 000h, 061h
		db  0adh, 085h, 073h, 003h, 008h, 040h, 0efh, 068h, 0feh, 097h, 01fh, 0deh, 0afh, 066h, 0e8h, 0b8h
		db  0aeh, 0bdh, 0b3h, 0ebh, 0c6h, 06bh, 047h, 0a9h, 0d8h, 0a7h, 072h, 0eeh, 01dh, 07eh, 0aah, 0b6h
		db  075h, 0cbh, 0d4h, 030h, 069h, 020h, 07fh, 037h, 05bh, 09dh, 078h, 0a3h, 0f1h, 076h, 0fah, 005h
		db  03dh, 03ah, 044h, 057h, 03bh, 0cah, 0c7h, 08ah, 018h, 046h, 09ch, 0bfh, 0bah, 038h, 056h, 01ah
		db  092h, 04dh, 026h, 029h, 0a2h, 098h, 010h, 099h, 070h, 0a0h, 0c5h, 028h, 0c1h, 06dh, 014h, 0ach
		db  0f9h, 05fh, 04fh, 0c4h, 0c3h, 0d1h, 0fch, 0ddh, 0b2h, 059h, 0e6h, 0b5h, 036h, 052h, 04ah, 02ah

.code
OPTION PROLOGUE:None		;we don't want prologue
OPTION EPILOGUE:None		;and epilogue code this time

E2_SetKey	proc	arg1:DWORD

	pushad
	mov	esi, dword ptr [esp+ 24h]	;offset password
	mov	edi, offset e2_tempkey
	mov	ebp, offset e2_subkey
	mov	ebx, offset e2_sbox

IF	KEY_SIZE eq 128

	xor	ecx, ecx
@@:	mov	eax, dword ptr [esi+ecx]
	bswap	eax
	mov	dword ptr [edi+ecx], eax
	add	ecx, 4
	and	ecx, 0Fh
	jnz	@B

;	cld / push 4 / pop ecx / @@: lodsd / bswap eax / stosd/ loop @B

	mov	dword ptr [edi+16], 582ED330h
	mov	dword ptr [edi+20], 84499EB8h
	mov	dword ptr [edi+24],0ECCF5709h
	mov	dword ptr [edi+28], 2E5000D8h

ELSEIF	KEY_SIZE eq 192

	mov	ecx, 6*4
@@:	mov	eax, dword ptr [esi+ecx-4]
	bswap	eax
	mov	dword ptr [edi+ecx-4], eax
	sub	ecx, 4
	jnz	@B

	mov	dword ptr [edi+24],0ECCF5709h
	mov	dword ptr [edi+28], 2E5000D8h

ELSEIF	KEY_SIZE eq 256

	xor	ecx, ecx
@@:	mov	eax, dword ptr [esi+ecx]
	bswap	eax
	mov	dword ptr [edi+ecx], eax
	add	ecx, 4
	and	ecx, 1Fh
	jnz	@B

ENDIF

	mov	dword ptr [ebp+24], 01234567h
	mov	dword ptr [ebp+28], 89ABCDEFh

	call	@G_function

	xor	esi, esi

@loop:
	call	@G_function
       
	mov	eax, esi
	mov	edx, 48
	shr	eax, 1
	sbb	edx, 0
	shl	eax, 1
	add	edx, eax
	shl	edx, 1

@@:	
	mov	al, byte ptr [ebp+ecx]
	mov	ah, byte ptr [ebp+ecx+16]
	mov	byte ptr [e2_internalKey+edx+3] , al
	mov	byte ptr [e2_internalKey+edx+2] , ah
	mov	al, byte ptr [ebp+ecx+8]
	mov	ah, byte ptr [ebp+ecx+24]
	mov	byte ptr [e2_internalKey+edx+19] , al
	mov	byte ptr [e2_internalKey+edx+18] , ah
	mov	al, byte ptr [ebp+ecx+4]
	mov	ah, byte ptr [ebp+ecx+20]
	mov	byte ptr [e2_internalKey+edx+131] , al
	mov	byte ptr [e2_internalKey+edx+130] , ah
	mov	al, byte ptr [ebp+ecx+12]
	mov	ah, byte ptr [ebp+ecx+28]
	mov	byte ptr [e2_internalKey+edx+147] , al
	mov	byte ptr [e2_internalKey+edx+146] , ah

	sub	edx, 32
	inc	ecx
	and	ecx, 3
	jnz	@B

	inc	esi
	and	esi, 7
	jnz	@loop

@@:
	mov	eax, dword ptr [e2_internalKey+ecx]
	mov	edx, dword ptr [e2_internalKey+ecx+16]
	xor	eax, dword ptr [e2_internalKey+ecx+4]
	xor	edx, dword ptr [e2_internalKey+ecx+20]
	and	eax, 00FF00FFh
	and	edx, 00FF00FFh
	xor	dword ptr [e2_internalKey+ecx], eax
	xor	dword ptr [e2_internalKey+ecx+16], edx
	xor	dword ptr [e2_internalKey+ecx+4], eax
	xor	dword ptr [e2_internalKey+ecx+20], edx
	add	ecx, 32
	cmp	ecx, 4*48
	jnz	@B

	add	ecx, 4*4
@@:	or	dword ptr [e2_internalKey+ecx], 1
	mov	eax, dword ptr [e2_internalKey+ecx]
	call	@modInv
	mov	dword ptr [e2_internalKey+ecx+12*4], eax
	add	ecx, 4
	cmp	ecx, 4*60
	jnz	@B

	popad
	ret	4

@G_function:
	mov	eax, dword ptr [edi+ecx]
	mov	edx, dword ptr [edi+ecx+4]

	call	@f_function

	mov	dword ptr [edi+ecx], eax
	mov	dword ptr [edi+ecx+4], edx
	add	ecx, 8
	and	ecx, 1Fh
	jnz	@G_function

	mov	eax, dword ptr [ebp+24]
	mov	edx, dword ptr [ebp+28]
@@:
	call	@f_function

	xor	eax, dword ptr [edi+ecx]
	xor	edx, dword ptr [edi+ecx+4]
	mov	dword ptr [ebp+ecx], eax
	mov	dword ptr [ebp+ecx+4], edx
	add	ecx, 8
	and	ecx, 1Fh
	jnz	@B
	ret

@f_function:
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xchg	eax, edx
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xchg	eax, edx
	xor	edx, eax
	rol	edx, 16
	xor	eax, edx
	rol	edx, 16
	ror	eax, 8
	xor	edx, eax
	rol	eax, 8
	xor	eax, edx
	ret

@modInv:
	pushad
	cmp	eax, 1
	jz	@q_inv

	mov	ebx, eax	;ebx =          x
	neg	eax		;eax =         -x
	xor	edx, edx
	div	ebx		;eax =       ((-x) / x)
	not	eax		;eax =      ~((-x) / x)
	mov	ebp, eax	;ebp = y1 = ~((-x) / x)

	mov	edi, 1		;edi = y2 = 1

	mov	ecx, ebx	;ecx = a = x

	mov	esi, ebp	;esi = y1
	imul	esi, ebx	;esi = b = y1 * x
	
@@:	mov	eax, ecx
	xor	edx, edx
	div	esi		;a/b
	test	edx, edx
	jz	@F
	
	mov	ecx, edx

	imul	ebp
	sub	edi, eax

	xchg	ecx, esi
	xchg	ebp, edi
	jmp	@B

@@:
	mov	eax, esi
	imul	eax, ebx
	dec	eax
	jnz	@F
	neg	ebp
@@:	mov	eax, ebp
@q_inv:	mov	dword ptr [esp+28], eax
	popad
	ret

E2_SetKey	endp

E2_Clear	proc
	push	ecx
	mov	ecx, (88-1)*4
@@:	and	dword ptr [e2_internalKey+ecx], 0
	sub	ecx, 4
	jns	@B
	pop	ecx
	ret
E2_Clear	endp

E2_Decrypt	proc	arg1:DWORD, arg2:DWORD

	pushad
	mov	esi, dword ptr [esp+ 28h]		; offset plain
	mov	ebp, dword ptr [esp+ 24h]		; offset cipher
	mov	edi, offset e2_internalKey+56*4
	mov	ebx, offset e2_sbox

	xor	ecx, ecx
@@:	mov	eax, dword ptr [esi+ecx]
	bswap	eax
	xor	eax, dword ptr [edi+ecx+16]
	imul	eax, dword ptr [edi+ecx]
	mov	dword ptr [ebp+ecx], eax
	add	ecx, 4
	and	ecx, 0Fh
	jnz	@B

	mov	eax, dword ptr [ebp]
	mov	edx, dword ptr [ebp+8]
	ror	eax, 8
	ror	edx, 8
	xchg	ax, dx
	rol	eax, 8
	rol	edx, 8
	mov	dword ptr [ebp], eax
	mov	dword ptr [ebp+8], edx
	mov	eax, dword ptr [ebp+4]
	mov	edx, dword ptr [ebp+12]
	xchg	ax, dx
	mov	dword ptr [ebp+4], eax
	mov	dword ptr [ebp+12], edx

	sub	edi, 12*4
	mov	esi, 12
	mov	ecx, 8
@mainloop:
	mov	edx, dword ptr [ebp+ecx]
	mov	eax, dword ptr [ebp+ecx+4]
	xor	edx, dword ptr [edi]
	xor	eax, dword ptr [edi+4]
	xlatb
	xchg	al, dl
	xlatb
	rol	eax, 8
	rol	edx, 8
	xlatb
	xchg	ax, dx
	xlatb
	rol	eax, 8
	rol	edx, 8
	xlatb
	xchg	eax, edx
	xlatb
	rol	eax, 8
	rol	edx, 8
	xlatb
	xchg	al, dl
	xlatb
	rol	eax, 8
	rol	edx, 8
	xor	eax, edx
	rol	eax, 16
	xor	edx, eax
	rol	eax, 16
	ror	edx, 8
	xor	eax, edx
	rol	edx, 8
	xor	edx, eax
	xor	ecx, 8
	xor	edx, dword ptr [edi+8]
	xor	eax, dword ptr [edi+12]
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xlatb
	xchg	eax, edx
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xlatb
	xchg	al, dl
	sub	edi, 16
	rol	eax, 16
	rol	edx, 16
	xor	dword ptr [ebp+ecx], eax
	xor	dword ptr [ebp+ecx+4], edx
	dec	esi
	jnz	@mainloop

	mov	eax, dword ptr [ebp]
	mov	edx, dword ptr [ebp+4]
	xor	eax, dword ptr [ebp+8]
	xor	edx, dword ptr [ebp+12]
	and	eax, 0FF0000FFh
	and	edx, 0FFFF0000h
	xor	dword ptr [ebp], eax
	xor	dword ptr [ebp+4], edx
	xor	dword ptr [ebp+8], eax
	xor	dword ptr [ebp+12], edx

	xor	ecx, ecx
	mov	edi, offset e2_internalKey+48*4
@@:	mov	eax, dword ptr [ebp+ecx]
	imul	eax, dword ptr [edi+16*4+ecx]
	xor	eax, dword ptr [edi+ecx]
	bswap	eax
	mov	dword ptr [ebp+ecx], eax
	add	ecx, 4
	and	ecx, 0Fh
	jnz	@B

	popad
	ret	8	
E2_Decrypt	endp

E2_Encrypt	proc	arg1:DWORD, arg2:DWORD

	pushad
	mov	esi, dword ptr [esp+ 28h]		; offset plain
	mov	ebp, dword ptr [esp+ 24h]		; offset cipher
	mov	edi, offset e2_internalKey+48*4
	mov	ebx, offset e2_sbox

	xor	ecx, ecx
@@:	mov	eax, dword ptr [esi+ecx]
	bswap	eax
	xor	eax, dword ptr [edi+ecx]
	imul	eax, dword ptr [edi+ecx+16]
	mov	dword ptr [ebp+ecx], eax
	add	ecx, 4
	and	ecx, 0Fh
	jnz	@B

	mov	eax, dword ptr [ebp]
	mov	edx, dword ptr [ebp+8]
	ror	eax, 8
	ror	edx, 8
	xchg	ax, dx
	rol	eax, 8
	rol	edx, 8
	mov	dword ptr [ebp], eax
	mov	dword ptr [ebp+8], edx
	mov	eax, dword ptr [ebp+4]
	mov	edx, dword ptr [ebp+12]
	xchg	ax, dx
	mov	dword ptr [ebp+4], eax
	mov	dword ptr [ebp+12], edx

	sub	edi, 0C0h
	mov	esi, 12
	mov	ecx, 8
@mainloop:
	mov	edx, dword ptr [ebp+ecx]
	mov	eax, dword ptr [ebp+ecx+4]
	xor	edx, dword ptr [edi]
	xor	eax, dword ptr [edi+4]
	xlatb
	xchg	al, dl
	xlatb
	rol	eax, 8
	rol	edx, 8
	xlatb
	xchg	ax, dx
	xlatb
	rol	eax, 8
	rol	edx, 8
	xlatb
	xchg	eax, edx
	xlatb
	rol	eax, 8
	rol	edx, 8
	xlatb
	xchg	al, dl
	xlatb
	rol	eax, 8
	rol	edx, 8
	xor	eax, edx
	rol	eax, 16
	xor	edx, eax
	rol	eax, 16
	ror	edx, 8
	xor	eax, edx
	rol	edx, 8
	xor	edx, eax
	xor	ecx, 8
	xor	edx, dword ptr [edi+8]
	xor	eax, dword ptr [edi+12]
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xlatb
	xchg	eax, edx
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xlatb
	xchg	al, dl
	add	edi, 16
	rol	eax, 16
	rol	edx, 16
	xor	dword ptr [ebp+ecx], eax
	xor	dword ptr [ebp+ecx+4], edx
	dec	esi
	jnz	@mainloop

	mov	eax, dword ptr [ebp]
	mov	edx, dword ptr [ebp+4]
	xor	eax, dword ptr [ebp+8]
	xor	edx, dword ptr [ebp+12]
	and	eax, 0FF0000FFh
	and	edx, 0FFFF0000h
	xor	dword ptr [ebp], eax
	xor	dword ptr [ebp+4], edx
	xor	dword ptr [ebp+8], eax
	xor	dword ptr [ebp+12], edx

	xor	ecx, ecx
	add	edi, 30h
@@:	mov	eax, dword ptr [ebp+ecx]
	imul	eax, dword ptr [edi+8*4+ecx]
	xor	eax, dword ptr [edi+ecx]
	bswap	eax
	mov	dword ptr [ebp+ecx], eax
	add	ecx, 4
	and	ecx, 0Fh
	jnz	@B

	popad
	ret	8

E2_Encrypt	endp

OPTION EPILOGUE:EPILOGUEDEF
OPTION PROLOGUE:PROLOGUEDEF	;but on exit set it to default