comment !ON

Algo	: CS^2 by Tom St Denis
Block	: 16 bytes (128b)
Key	: 16 bytes (128b)


	push	offset dbKey
	call	CS2_SetKey

	push	offset dbIn
	push	offset dbOut
	call	CS2_Encrypt

	call	CS2_Clear

30.10.2005 WiteG (witeg@poczta.fm, www.witeg.prv.pl)

" We note that no decryption routine is described. While the cipher
is a bijection a decryption routine was not deemed necessary since
many useful modes of operations such as CTR, OMAC and EAX only make
use of the forward direction of the cipher. "

Test Vectors:

KEY: 00 01 02 03 04 05 06 07 08 09 0a 0b 0c 0d 0e 0f
PT : 00 01 02 03 04 05 06 07 08 09 0a 0b 0c 0d 0e 0f
CT : 58 70 f4 0b d1 57 00 ff 1e 66 bb b7 0b c3 6e 50

KEY: 0f 0e 0d 0c 0b 0a 09 08 07 06 05 04 03 02 01 00
PT : 0f 0e 0d 0c 0b 0a 09 08 07 06 05 04 03 02 01 00
CT : ca f2 58 81 d8 da fa 5f 16 a1 8a 0e f5 92 e3 f8

comment !OFF


THETA	MACRO	x,y

	mov	al, byte ptr [esi+x]
	mov	dl, byte ptr [esi+y]
	xor	al, byte ptr [ebx]
	xor	dl, byte ptr [ebx+1]
	mov	al, byte ptr [gamma+eax]	;a
	mov	dl, byte ptr [gamma+edx]	;b
	mov	cl, byte ptr [xtime+eax]	;xtime[a]
	xor	al, dl
	xor	cl, dl
	mov	byte ptr [esi+y], al
	mov	byte ptr [esi+x], cl
	add	ebx, 2

ENDM

.const
_ARG_1		equ	24h
_ARG_2		equ	_ARG_1 + 4
_ARG_3		equ	_ARG_2 + 4
_ARG_4		equ	_ARG_3 + 4
_ARG_5		equ	_ARG_4 + 4
_ARG_6		equ	_ARG_5 + 4
_ARG_7		equ	_ARG_6 + 4
_EAX		equ	28

.code
OPTION PROLOGUE:NONE
OPTION EPILOGUE:NONE

CS2_SetKey	proc	szKey:DWORD

	pushad
	mov	edi, dword ptr [esp+_ARG_1]
	mov	esi, offset int_Tmp

	mov	eax, dword ptr [edi   ]
	mov	edx, dword ptr [edi+ 4]
	mov	dword ptr [esi   ], eax
	mov	dword ptr [esi+ 4], edx
	mov	eax, dword ptr [edi+ 8]
	mov	edx, dword ptr [edi+12]
	mov	dword ptr [esi+ 8], eax
	mov	dword ptr [esi+12], edx

	xor	eax, eax
	mov	ebx, offset sigma
	xor	edx, edx
	mov	edi, offset int_Key

@mainL:	THETA	0,1
	THETA	2,3
	THETA	4,5
	THETA	6,7
	THETA	8,9
	THETA	10,11
	THETA	12,13
	THETA	14,15

	mov	ebp, dword ptr [esi   ]
	mov	ecx, dword ptr [esi+ 4]
	mov	dword ptr [edi   ], ebp
	mov	dword ptr [edi+ 4], ecx
	mov	ebp, dword ptr [esi+ 8]
	mov	ecx, dword ptr [esi+12]
	mov	dword ptr [edi+ 8], ebp
	mov	dword ptr [edi+12], ecx

	THETA	0,2
	THETA	1,3
	THETA	4,6
	THETA	5,7
	THETA	8,10
	THETA	9,11
	THETA	12,14
	THETA	13,15

	mov	ebp, dword ptr [esi   ]
	mov	ecx, dword ptr [esi+ 4]
	mov	dword ptr [edi+16], ebp
	mov	dword ptr [edi+20], ecx
	mov	ebp, dword ptr [esi+ 8]
	mov	ecx, dword ptr [esi+12]
	mov	dword ptr [edi+24], ebp
	mov	dword ptr [edi+28], ecx

	THETA	0,4
	THETA	1,5
	THETA	2,6
	THETA	3,7
	THETA	8,12
	THETA	9,13
	THETA	10,14
	THETA	11,15

	mov	ebp, dword ptr [esi   ]
	mov	ecx, dword ptr [esi+ 4]
	mov	dword ptr [edi+32], ebp
	mov	dword ptr [edi+36], ecx
	mov	ebp, dword ptr [esi+ 8]
	mov	ecx, dword ptr [esi+12]
	mov	dword ptr [edi+40], ebp
	mov	dword ptr [edi+44], ecx

	THETA	0,8
	THETA	1,9
	THETA	2,10
	THETA	3,11
	THETA	4,12
	THETA	5,13
	THETA	6,14
	THETA	7,15

	mov	ebp, dword ptr [esi   ]
	mov	ecx, dword ptr [esi+ 4]
	mov	dword ptr [edi+48], ebp
	mov	dword ptr [edi+52], ecx
	mov	ebp, dword ptr [esi+ 8]
	mov	ecx, dword ptr [esi+12]
	mov	dword ptr [edi+56], ebp
	mov	dword ptr [edi+60], ecx

	add	edi, 64
	cmp	edi, offset int_Key+8*64
	jnz	@mainL


	xor	ecx, ecx
	mov	ebx, offset gamma
@@:	mov	eax, dword ptr [esi+ecx]
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	xlatb
	rol	eax, 8
	mov	dword ptr [edi+ecx], eax
	add	ecx, 4
	and	ecx, 0Fh
	jnz	@B

	popad
	ret	4
CS2_SetKey	endp

CS2_Encrypt	proc	ptrOut:DWORD, ptrIn:DWORD

	pushad

	mov	esi, offset int_Tmp
	mov	edi, dword ptr [esp+_ARG_2]	;ptrIn
	mov	ebx, offset int_Key

	mov	eax, dword ptr [edi   ]
	mov	edx, dword ptr [edi+ 4]
	mov	dword ptr [esi   ], eax
	mov	dword ptr [esi+ 4], edx
	mov	eax, dword ptr [edi+ 8]
	mov	edx, dword ptr [edi+12]
	mov	dword ptr [esi+ 8], eax
	mov	dword ptr [esi+12], edx

	xor	eax, eax
	mov	edi, 8
	xor	edx, edx

@@:
	THETA	0,1
	THETA	2,3
	THETA	4,5
	THETA	6,7
	THETA	8,9
	THETA	10,11
	THETA	12,13
	THETA	14,15

	THETA	0,2
	THETA	1,3
	THETA	4,6
	THETA	5,7
	THETA	8,10
	THETA	9,11
	THETA	12,14
	THETA	13,15

	THETA	0,4
	THETA	1,5
	THETA	2,6
	THETA	3,7
	THETA	8,12
	THETA	9,13
	THETA	10,14
	THETA	11,15

	THETA	0,8
	THETA	1,9
	THETA	2,10
	THETA	3,11
	THETA	4,12
	THETA	5,13
	THETA	6,14
	THETA	7,15

	dec	edi
	jnz	@B

	mov	edi, dword ptr [esp+_ARG_1]	;ptrOut
	mov	eax, dword ptr [ebx   ]
	mov	edx, dword ptr [ebx+ 4]
	xor	eax, dword ptr [esi   ]
	xor	edx, dword ptr [esi+ 4]
	mov	dword ptr [edi   ], eax
	mov	dword ptr [edi+ 4], edx

	mov	eax, dword ptr [ebx+ 8]
	mov	edx, dword ptr [ebx+12]
	xor	eax, dword ptr [esi+ 8]
	xor	edx, dword ptr [esi+12]
	mov	dword ptr [edi+ 8], eax
	mov	dword ptr [edi+12], edx

	popad
	ret	8
CS2_Encrypt	endp

CS2_Clear	proc

	push	eax
	push	ecx
	push	edi

	xor	eax, eax
	mov	ecx, (528+16)/4
	mov	edi, offset int_Key
	cld
	rep	stosd

	pop	edi
	pop	ecx
	pop	eax
	ret

CS2_Clear	endp

OPTION PROLOGUE:DEFAULT
OPTION EPILOGUE:DEFAULT

.data
sigma	db 064h, 0BEh, 0C5h, 0ADh, 019h, 007h, 046h, 0DAh, 070h, 05Ch, 0F3h, 082h, 028h, 03Fh, 091h, 0EBh
	db 043h, 0F6h, 0BDh, 07Ch, 005h, 0EAh, 021h, 0DBh, 089h, 0C7h, 012h, 06Fh, 034h, 0AEh, 098h, 050h
	db 02Ch, 0FAh, 090h, 071h, 085h, 009h, 04Bh, 0E6h, 0D3h, 0C2h, 03Dh, 06Eh, 017h, 0B4h, 058h, 0AFh
	db 0A4h, 087h, 04Ah, 015h, 09Ch, 06Dh, 002h, 0C9h, 0BFh, 03Eh, 051h, 020h, 0E3h, 078h, 0D6h, 0FBh
	db 0E2h, 0D9h, 02Eh, 030h, 0F7h, 08Bh, 045h, 07Fh, 01Ah, 003h, 0A1h, 0C6h, 06Ch, 0B8h, 09Dh, 054h
	db 0CFh, 01Eh, 0D8h, 0FCh, 040h, 09Bh, 053h, 02Ah, 0A2h, 08Dh, 0B9h, 076h, 004h, 0E1h, 035h, 067h
	db 08Fh, 0CDh, 0F8h, 0E0h, 032h, 0A5h, 00Eh, 0B7h, 096h, 069h, 023h, 0DCh, 05Ah, 07Bh, 041h, 014h
	db 02Bh, 037h, 0C4h, 00Fh, 0B2h, 01Dh, 0F0h, 08Eh, 0D1h, 056h, 0E8h, 04Ch, 0A9h, 065h, 073h, 09Ah
	db 062h, 0B5h, 026h, 07Ah, 01Fh, 00Dh, 084h, 039h, 0CEh, 0D0h, 093h, 0ECh, 0F1h, 048h, 0A7h, 05Bh
	db 063h, 0ABh, 029h, 057h, 04Fh, 092h, 0F4h, 0DEh, 036h, 0C0h, 0EDh, 00Ch, 075h, 0BAh, 018h, 081h
	db 06Bh, 0B6h, 03Ah, 08Ch, 010h, 001h, 0FDh, 0E4h, 025h, 097h, 0C8h, 0DFh, 0A3h, 052h, 04Eh, 079h
	db 074h, 0B1h, 05Fh, 0F5h, 02Dh, 09Eh, 0E9h, 006h, 0C3h, 08Ah, 0D2h, 047h, 0A8h, 03Ch, 01Bh, 060h
	db 01Ch, 04Dh, 059h, 0FEh, 0EFh, 0D4h, 06Ah, 095h, 0A6h, 03Bh, 072h, 027h, 0C1h, 080h, 008h, 0B3h
	db 016h, 049h, 0ACh, 0B0h, 038h, 0CAh, 061h, 094h, 0E7h, 07Eh, 02Fh, 05Dh, 083h, 00Bh, 0F2h, 0D5h
	db 024h, 0F9h, 0E5h, 042h, 0BCh, 031h, 07Dh, 09Fh, 0A0h, 05Eh, 013h, 086h, 00Ah, 068h, 0CBh, 0D7h
	db 066h, 000h, 033h, 022h, 088h, 0FFh, 0BBh, 0AAh, 011h, 0CCh, 044h, 0EEh, 0DDh, 055h, 099h, 077h
	db 09Eh, 02Dh, 006h, 0E9h, 0B1h, 074h, 0F5h, 05Fh, 03Ch, 0A8h, 060h, 01Bh, 08Ah, 0C3h, 047h, 0D2h
	db 0DEh, 0F4h, 092h, 04Fh, 057h, 029h, 0ABh, 063h, 081h, 018h, 0BAh, 075h, 00Ch, 0EDh, 0C0h, 036h
	db 0B3h, 008h, 080h, 0C1h, 027h, 072h, 03Bh, 0A6h, 095h, 06Ah, 0D4h, 0EFh, 0FEh, 059h, 04Dh, 01Ch
	db 0D7h, 0CBh, 068h, 00Ah, 086h, 013h, 05Eh, 0A0h, 09Fh, 07Dh, 031h, 0BCh, 042h, 0E5h, 0F9h, 024h
	db 0B5h, 062h, 07Ah, 026h, 00Dh, 01Fh, 039h, 084h, 0D0h, 0CEh, 0ECh, 093h, 048h, 0F1h, 05Bh, 0A7h
	db 0CDh, 08Fh, 0E0h, 0F8h, 0A5h, 032h, 0B7h, 00Eh, 069h, 096h, 0DCh, 023h, 07Bh, 05Ah, 014h, 041h
	db 035h, 067h, 004h, 0E1h, 0B9h, 076h, 0A2h, 08Dh, 053h, 02Ah, 040h, 09Bh, 0D8h, 0FCh, 0CFh, 01Eh
	db 079h, 04Eh, 052h, 0A3h, 0DFh, 0C8h, 097h, 025h, 0E4h, 0FDh, 001h, 010h, 08Ch, 03Ah, 0B6h, 06Bh
	db 09Dh, 054h, 06Ch, 0B8h, 0A1h, 0C6h, 01Ah, 003h, 045h, 07Fh, 0F7h, 08Bh, 02Eh, 030h, 0E2h, 0D9h
	db 0EAh, 005h, 0DBh, 021h, 0F6h, 043h, 07Ch, 0BDh, 0AEh, 034h, 050h, 098h, 0C7h, 089h, 06Fh, 012h
	db 037h, 02Bh, 00Fh, 0C4h, 01Dh, 0B2h, 08Eh, 0F0h, 056h, 0D1h, 04Ch, 0E8h, 065h, 0A9h, 09Ah, 073h
	db 0DAh, 046h, 007h, 019h, 0ADh, 0C5h, 0BEh, 064h, 0EBh, 091h, 03Fh, 028h, 082h, 0F3h, 05Ch, 070h
	db 017h, 0B4h, 058h, 0AFh, 0D3h, 0C2h, 03Dh, 06Eh, 085h, 009h, 04Bh, 0E6h, 02Ch, 0FAh, 090h, 071h
	db 077h, 099h, 055h, 0DDh, 0EEh, 044h, 0CCh, 011h, 0AAh, 0BBh, 0FFh, 088h, 022h, 033h, 000h, 066h
	db 0E3h, 078h, 0D6h, 0FBh, 0BFh, 03Eh, 051h, 020h, 09Ch, 06Dh, 002h, 0C9h, 0A4h, 087h, 04Ah, 015h
	db 049h, 016h, 0B0h, 0ACh, 0CAh, 038h, 094h, 061h, 07Eh, 0E7h, 05Dh, 02Fh, 00Bh, 083h, 0D5h, 0F2h

gamma	db 048h, 0F1h, 05Bh, 0A7h, 0D0h, 0CEh, 0ECh, 093h, 00Dh, 01Fh, 039h, 084h, 0B5h, 062h, 07Ah, 026h
	db 081h, 018h, 0BAh, 075h, 00Ch, 0EDh, 0C0h, 036h, 0DEh, 0F4h, 092h, 04Fh, 057h, 029h, 0ABh, 063h
	db 0BBh, 0AAh, 088h, 0FFh, 033h, 022h, 066h, 000h, 099h, 077h, 0DDh, 055h, 044h, 0EEh, 011h, 0CCh
	db 097h, 025h, 0DFh, 0C8h, 052h, 0A3h, 079h, 04Eh, 0B6h, 06Bh, 08Ch, 03Ah, 001h, 010h, 0E4h, 0FDh
	db 070h, 05Ch, 0F3h, 082h, 028h, 03Fh, 091h, 0EBh, 064h, 0BEh, 0C5h, 0ADh, 019h, 007h, 046h, 0DAh
	db 06Eh, 03Dh, 0C2h, 0D3h, 0AFh, 058h, 0B4h, 017h, 071h, 090h, 0FAh, 02Ch, 0E6h, 04Bh, 009h, 085h
	db 0ACh, 0B0h, 016h, 049h, 061h, 094h, 038h, 0CAh, 02Fh, 05Dh, 0E7h, 07Eh, 0F2h, 0D5h, 083h, 00Bh
	db 013h, 086h, 0A0h, 05Eh, 0CBh, 0D7h, 00Ah, 068h, 0E5h, 042h, 024h, 0F9h, 07Dh, 09Fh, 0BCh, 031h
	db 02Dh, 09Eh, 0E9h, 006h, 074h, 0B1h, 05Fh, 0F5h, 0A8h, 03Ch, 01Bh, 060h, 0C3h, 08Ah, 0D2h, 047h
	db 00Fh, 0C4h, 037h, 02Bh, 08Eh, 0F0h, 01Dh, 0B2h, 04Ch, 0E8h, 056h, 0D1h, 09Ah, 073h, 065h, 0A9h
	db 0C9h, 002h, 06Dh, 09Ch, 015h, 04Ah, 087h, 0A4h, 0FBh, 0D6h, 078h, 0E3h, 020h, 051h, 03Eh, 0BFh
	db 0D4h, 0EFh, 095h, 06Ah, 04Dh, 01Ch, 0FEh, 059h, 080h, 0C1h, 0B3h, 008h, 03Bh, 0A6h, 027h, 072h
	db 035h, 067h, 004h, 0E1h, 0B9h, 076h, 0A2h, 08Dh, 053h, 02Ah, 040h, 09Bh, 0D8h, 0FCh, 0CFh, 01Eh
	db 0E2h, 0D9h, 02Eh, 030h, 0F7h, 08Bh, 045h, 07Fh, 01Ah, 003h, 0A1h, 0C6h, 06Ch, 0B8h, 09Dh, 054h
	db 05Ah, 07Bh, 041h, 014h, 096h, 069h, 023h, 0DCh, 032h, 0A5h, 00Eh, 0B7h, 08Fh, 0CDh, 0F8h, 0E0h
	db 0F6h, 043h, 07Ch, 0BDh, 0EAh, 005h, 0DBh, 021h, 0C7h, 089h, 06Fh, 012h, 0AEh, 034h, 050h, 098h

xtime	db 000h, 002h, 004h, 006h, 008h, 00Ah, 00Ch, 00Eh, 010h, 012h, 014h, 016h, 018h, 01Ah, 01Ch, 01Eh
	db 020h, 022h, 024h, 026h, 028h, 02Ah, 02Ch, 02Eh, 030h, 032h, 034h, 036h, 038h, 03Ah, 03Ch, 03Eh
	db 040h, 042h, 044h, 046h, 048h, 04Ah, 04Ch, 04Eh, 050h, 052h, 054h, 056h, 058h, 05Ah, 05Ch, 05Eh
	db 060h, 062h, 064h, 066h, 068h, 06Ah, 06Ch, 06Eh, 070h, 072h, 074h, 076h, 078h, 07Ah, 07Ch, 07Eh
	db 080h, 082h, 084h, 086h, 088h, 08Ah, 08Ch, 08Eh, 090h, 092h, 094h, 096h, 098h, 09Ah, 09Ch, 09Eh
	db 0A0h, 0A2h, 0A4h, 0A6h, 0A8h, 0AAh, 0ACh, 0AEh, 0B0h, 0B2h, 0B4h, 0B6h, 0B8h, 0BAh, 0BCh, 0BEh
	db 0C0h, 0C2h, 0C4h, 0C6h, 0C8h, 0CAh, 0CCh, 0CEh, 0D0h, 0D2h, 0D4h, 0D6h, 0D8h, 0DAh, 0DCh, 0DEh
	db 0E0h, 0E2h, 0E4h, 0E6h, 0E8h, 0EAh, 0ECh, 0EEh, 0F0h, 0F2h, 0F4h, 0F6h, 0F8h, 0FAh, 0FCh, 0FEh
	db 01Bh, 019h, 01Fh, 01Dh, 013h, 011h, 017h, 015h, 00Bh, 009h, 00Fh, 00Dh, 003h, 001h, 007h, 005h
	db 03Bh, 039h, 03Fh, 03Dh, 033h, 031h, 037h, 035h, 02Bh, 029h, 02Fh, 02Dh, 023h, 021h, 027h, 025h
	db 05Bh, 059h, 05Fh, 05Dh, 053h, 051h, 057h, 055h, 04Bh, 049h, 04Fh, 04Dh, 043h, 041h, 047h, 045h
	db 07Bh, 079h, 07Fh, 07Dh, 073h, 071h, 077h, 075h, 06Bh, 069h, 06Fh, 06Dh, 063h, 061h, 067h, 065h
	db 09Bh, 099h, 09Fh, 09Dh, 093h, 091h, 097h, 095h, 08Bh, 089h, 08Fh, 08Dh, 083h, 081h, 087h, 085h
	db 0BBh, 0B9h, 0BFh, 0BDh, 0B3h, 0B1h, 0B7h, 0B5h, 0ABh, 0A9h, 0AFh, 0ADh, 0A3h, 0A1h, 0A7h, 0A5h
	db 0DBh, 0D9h, 0DFh, 0DDh, 0D3h, 0D1h, 0D7h, 0D5h, 0CBh, 0C9h, 0CFh, 0CDh, 0C3h, 0C1h, 0C7h, 0C5h
	db 0FBh, 0F9h, 0FFh, 0FDh, 0F3h, 0F1h, 0F7h, 0F5h, 0EBh, 0E9h, 0EFh, 0EDh, 0E3h, 0E1h, 0E7h, 0E5h

.data?
int_Key	db 528 dup (?)
int_Tmp	db  16 dup (?)