comment %

Algo	: Camellia (by Aoki,Ichikawa,Kanda,Matsui,Moriai,Nakajima,Tokita)
Block	: 16 bytes
Key	: 128/192/256 bits



	push	offset password
	call	Camellia_SetKey
	
	push	offset plain
	push	offset cipher
	call	Camellia_Encrypt

	push	offset cipher
	push	offset decrypted_plain
	call	Camellia_Decrypt

	call	Camellia_Clear



Test Data (hex):

128-bit key
key		: 01 23 45 67 89 AB CD EF FE DC BA 98 76 54 32 10
plaintext	: 01 23 45 67 89 AB CD EF FE DC BA 98 76 54 32 10
ciphertext	: 67 67 31 38 54 96 69 73 08 57 06 56 48 EA BE 43

192-bit key
key		: 01 23 45 67 89 AB CD EF FE DC BA 98 76 54 32 10 00 11 22 33 44 55 66 77
plaintext	: 01 23 45 67 89 AB CD EF FE DC BA 98 76 54 32 10
ciphertext	: B4 99 34 01 B3 E9 96 F8 4E E5 CE E7 D7 9B 09 B9

192-bit key
key		: 01 23 45 67 89 AB CD EF FE DC BA 98 76 54 32 10 00 11 22 33 44 55 66 77 88 99 AA BB CC DD EE FF
plaintext	: 01 23 45 67 89 AB CD EF FE DC BA 98 76 54 32 10
ciphertext	: 9A CC 23 7D FF 16 D7 6C 20 EF 7C 91 9E 3A 75 09


24.06.2002 WiteG//xtreeme (witeg@poczta.fm, www.witeg.prv.pl)

%

; ---------------------------------------------------------------------------
; You should set key size (KEY_SIZE)
; ---------------------------------------------------------------------------

KEY_SIZE	equ	256		; 128, 192 or 256

; ---------------------------------------------------------------------------


Camellia_FLlayer	macro	x0, x1, x2

	mov	eax, dword ptr [x0]
	mov	ecx, dword ptr [x2+ 4]
	and	eax, dword ptr [x1]
	or	ecx, dword ptr [x0+12]
	bswap	eax
	xor	ecx, dword ptr [x0+ 8]
	rol	eax, 1
	mov	dword ptr [x0+ 8], ecx
	bswap	eax
	and	ecx, dword ptr [x2]
	xor	eax, dword ptr [x0+ 4]
	bswap	ecx
	mov	dword ptr [x0+ 4], eax
	rol	ecx, 1
	or	eax, dword ptr [x1+ 4]
	bswap	ecx
	xor	dword ptr [x0], eax
	xor	dword ptr [x0+12], ecx

endm

.code
IF	KEY_SIZE eq 128

	Camellia_SetKey		proc	ptrPass:DWORD
	
		pushad
	
		mov	esi, ptrPass
		mov	edi, offset camelia_key_int
		mov	ecx, 4
		cld
		rep	movsd
		mov	esi, ptrPass
		mov	ecx, 4
		rep	movsd
	
		sub	edi, 8
		mov	ebp, offset SIGMA
		lea	esi, [edi-8]
		mov	ebx, offset SBOX
	
		call	Camellia_Feistel
	
		add	ebp, 8
		xchg	esi, edi
	
		call	Camellia_Feistel
	
		mov	eax, dword ptr [esi-24]
		mov	edx, dword ptr [esi-20]
		xor	dword ptr [edi], eax
		xor	dword ptr [edi+4], edx
		mov	eax, dword ptr [esi-16]
		mov	edx, dword ptr [esi-12]
		xor	dword ptr [edi+8], eax
		xor	dword ptr [edi+12], edx
	
		add	ebp, 8
		xchg	esi, edi
	
		call	Camellia_Feistel
	
		add	ebp, 8
		xchg	esi, edi
	
		call	Camellia_Feistel
	
		mov	esi, offset camelia_key_int
		mov	edi, offset temp_buffer
		mov	ecx, 8
	@@:
		lodsd
		bswap	eax
		stosd
		dec	ecx
		jnz	@B
	
		mov	edi, esi
		xor	ebx, ebx
	@@:
		movzx	esi, byte ptr [KIDX + ebx]
		movzx	edx, byte ptr [KSFT + ebx]
		add	esi, offset temp_buffer
		call	RotBlock
	
		add	edi, 8
	
		movzx	esi, byte ptr [KIDX + ebx + 1]
		movzx	edx, byte ptr [KSFT + ebx + 1]
		add	esi, offset temp_buffer
		call	RotBlock
	
		add	ebx, 2
		add	edi, 8
		cmp	ebx, 22
		jl	@B		
	
		xor	eax, eax
		mov	edi, offset temp_buffer
		mov	ecx, 8
		rep	stosd
	
		popad
		ret
	
	KSFT	db	15,79,15,79,30,94,45,109,45,124,60,124,77,13,94,30,94,30,111,47,111,47
	KIDX	db	0,0,16,16,16,16,0,0,16,0,16,16,0,0,0,0,16,16,0,0,16,16
	SIGMA	db	0a0h, 09eh, 066h, 07fh, 03bh, 0cch, 090h, 08bh
		db	0b6h, 07ah, 0e8h, 058h, 04ch, 0aah, 073h, 0b2h
		db	0c6h, 0efh, 037h, 02fh, 0e9h, 04fh, 082h, 0beh
		db	054h, 0ffh, 053h, 0a5h, 0f1h, 0d3h, 06fh, 01ch
	
	Camellia_SetKey		endp

ELSEIF	(KEY_SIZE eq 192) or (KEY_SIZE eq 256)

	Camellia_SetKey		proc	ptrPass:DWORD
	
		pushad
		mov	esi, ptrPass
		mov	edi, offset camelia_key_int
	
		IF	KEY_SIZE eq 256
		
			mov	ecx, 8
			cld
			rep	movsd
		
			mov	eax, dword ptr [edi-32]
			mov	ebx, dword ptr [edi-28]
			xor	eax, dword ptr [edi-16]
			xor	ebx, dword ptr [edi-12]
			mov	dword ptr [edi+ 0], eax
			mov	dword ptr [edi+ 4], ebx
			mov	eax, dword ptr [edi-24]
			mov	ebx, dword ptr [edi-20]
			xor	eax, dword ptr [edi-8]
			xor	ebx, dword ptr [edi-4]
			mov	dword ptr [edi+8], eax
			mov	dword ptr [edi+12], ebx
		
			mov	esi, edi
			mov	ebp, offset SIGMA
			add	edi, 8
			mov	ebx, offset SBOX
		
		ELSEIF	KEY_SIZE eq 192
		
			mov	ecx, 6
			cld
			rep	movsd
		
			mov	eax, dword ptr [edi-8]
			mov	ebx, dword ptr [edi-4]
			not	eax
			not	ebx
			mov	dword ptr [edi+ 0], eax
			mov	dword ptr [edi+ 4], ebx
			xor	eax, dword ptr [edi-16]
			xor	ebx, dword ptr [edi-12]
			mov	dword ptr [edi+16], eax
			mov	dword ptr [edi+20], ebx
			mov	eax, dword ptr [edi-24]
			mov	ebx, dword ptr [edi-20]
			xor	eax, dword ptr [edi- 8]
			xor	ebx, dword ptr [edi- 4]
			mov	dword ptr [edi+8], eax
			mov	dword ptr [edi+12], ebx
		
			lea	esi, [edi+8]
			mov	ebp, offset SIGMA
			add	edi, 16
			mov	ebx, offset SBOX
		
		ENDIF
	
		call	Camellia_Feistel
	
		add	ebp, 8
		xchg	esi, edi
	
		call	Camellia_Feistel
	
		mov	eax, dword ptr [edi-32]
		mov	edx, dword ptr [edi-28]
		xor	dword ptr [edi], eax
		xor	dword ptr [edi+4], edx
		mov	eax, dword ptr [edi-24]
		mov	edx, dword ptr [edi-20]
		xor	dword ptr [edi+8], eax
		xor	dword ptr [edi+12], edx
	
		add	ebp, 8
		xchg	esi, edi
	
		call	Camellia_Feistel
	
		add	ebp, 8
		xchg	esi, edi
	
		call	Camellia_Feistel
	
		mov	eax, dword ptr [edi]
		mov	edx, dword ptr [edi+4]
		xor	eax, dword ptr [edi-16]
		xor	edx, dword ptr [edi-12]
		mov	dword ptr [esi+8], eax
		mov	dword ptr [esi+12], edx
		mov	eax, dword ptr [edi+8]
		mov	edx, dword ptr [edi+12]
		xor	eax, dword ptr [edi-8]
		xor	edx, dword ptr [edi-4]
		mov	dword ptr [esi+16], eax
		mov	dword ptr [esi+20], edx
	
		add	ebp, 8
		add	esi, 8
		add	edi, 24
	
		call	Camellia_Feistel
	
		add	ebp, 8
		xchg	esi, edi
	
		call	Camellia_Feistel
	
		mov	esi, offset camelia_key_int
		mov	edi, offset temp_buffer
		mov	ecx, 16
	@@:
		lodsd
		bswap	eax
		stosd
		dec	ecx
		jnz	@B
	
		lea	edi, [esi-48]
		mov	ecx, 4
		sub	esi, 16
		rep	movsd
	
		xor	ebx, ebx
	@@:
		movzx	esi, byte ptr [KIDX + ebx]
		movzx	edx, byte ptr [KSFT + ebx]
		add	esi, offset temp_buffer
		call	RotBlock
	
		add	edi, 8
	
		movzx	esi, byte ptr [KIDX + ebx + 1]
		movzx	edx, byte ptr [KSFT + ebx + 1]
		add	esi, offset temp_buffer
		call	RotBlock
	
		add	ebx, 2
		add	edi, 8
		cmp	ebx, 30
		jl	@B
	
		xor	eax, eax
		mov	edi, offset temp_buffer
		mov	ecx, 16
		rep	stosd
	
		popad
		ret
	
	KSFT	db	15,79,15,79,30,94,30,94,45,109,45,109,60,124,60,124,60,124,77,13,77,13,94,30,94,30,111,47,111,47
	KIDX	db	16,16,32,32,16,16,48,48,0,0,32,32,0,0,16,16,48,48,0,0,32,32,16,16,32,32,0,0,48,48
	SIGMA	db	0a0h, 09eh, 066h, 07fh, 03bh, 0cch, 090h, 08bh
		db	0b6h, 07ah, 0e8h, 058h, 04ch, 0aah, 073h, 0b2h
		db	0c6h, 0efh, 037h, 02fh, 0e9h, 04fh, 082h, 0beh
		db	054h, 0ffh, 053h, 0a5h, 0f1h, 0d3h, 06fh, 01ch
		db	010h, 0e5h, 027h, 0fah, 0deh, 068h, 02dh, 01dh
		db	0b0h, 056h, 088h, 0c2h, 0b3h, 0e6h, 0c1h, 0fdh
	
	Camellia_SetKey		endp

ENDIF

Camellia_Encrypt	proc	ptrOut:DWORD, ptrIn:DWORD

	pushad

	cld
	mov	edi, ptrIn
	mov	esi, ptrOut
	mov	ebp, offset camelia_key_int

	mov	eax, dword ptr [edi + 0]
	mov	edx, dword ptr [edi + 4]
	xor	eax, dword ptr [ebp + 0]
	xor	edx, dword ptr [ebp + 4]
	mov	dword ptr [esi + 0], eax
	mov	dword ptr [esi + 4], edx
	mov	eax, dword ptr [edi + 8]
	mov	edx, dword ptr [edi +12]
	xor	eax, dword ptr [ebp + 8]
	xor	edx, dword ptr [ebp +12]
	mov	dword ptr [esi + 8], eax
	mov	dword ptr [esi +12], edx

	lea	edi, [esi+8]
	add	ebp, 16
	mov	ebx, offset SBOX

IF	KEY_SIZE eq 128
	mov	dh, 2
ELSEIF	(KEY_SIZE eq 192) or (KEY_SIZE eq 256)
	mov	dh, 3
ENDIF

@0:
	mov	dl, 3
@1:
	call	Camellia_Feistel

	add	ebp, 8
	xchg	esi, edi

	call	Camellia_Feistel

	add	ebp, 8
	xchg	esi, edi
	dec	dl
	jnz	@1

	Camellia_FLlayer	esi, ebp, ebp+8

	add	ebp, 16
	dec	dh
	jnz	@0

	mov	dl, 3
@@:
	call	Camellia_Feistel

	add	ebp, 8
	xchg	esi, edi

	call	Camellia_Feistel

	add	ebp, 8
	xchg	esi, edi

	dec	dl
	jnz	@B

	mov	eax, dword ptr [esi + 0]
	mov	ebx, dword ptr [esi + 4]
	mov	ecx, dword ptr [esi + 8]
	mov	edx, dword ptr [esi +12]
	xor	eax, dword ptr [ebp + 8]
	xor	ebx, dword ptr [ebp +12] 
	xor	ecx, dword ptr [ebp + 0]
	xor	edx, dword ptr [ebp + 4]
	mov	dword ptr [esi + 0], ecx
	mov	dword ptr [esi + 4], edx
	mov	dword ptr [esi + 8], eax
	mov	dword ptr [esi +12], ebx

	popad
	ret

Camellia_Encrypt	endp

Camellia_Decrypt	proc	ptrOut:DWORD, ptrIn:DWORD

	pushad

	cld
	mov	edi, ptrIn
	mov	esi, ptrOut

IF	KEY_SIZE eq 128
	mov	ebp, offset camelia_key_int + 192
ELSEIF	(KEY_SIZE eq 192) or (KEY_SIZE eq 256)
	mov	ebp, offset camelia_key_int + 256
ENDIF

	mov	eax, dword ptr [edi + 0]
	mov	edx, dword ptr [edi + 4]
	xor	eax, dword ptr [ebp + 0]
	xor	edx, dword ptr [ebp + 4]
	mov	dword ptr [esi + 0], eax
	mov	dword ptr [esi + 4], edx
	mov	eax, dword ptr [edi + 8]
	mov	edx, dword ptr [edi +12]
	xor	eax, dword ptr [ebp + 8]
	xor	edx, dword ptr [ebp +12]
	mov	dword ptr [esi + 8], eax
	mov	dword ptr [esi +12], edx

	lea	edi, [esi+8]
	sub	ebp, 8
	mov	ebx, offset SBOX

IF	KEY_SIZE eq 128
	mov	dh, 2
ELSEIF	(KEY_SIZE eq 192) or (KEY_SIZE eq 256)
	mov	dh, 3
ENDIF

@0:
	mov	dl, 3
@1:
	call	Camellia_Feistel

	sub	ebp, 8
	xchg	esi, edi

	call	Camellia_Feistel

	sub	ebp, 8
	xchg	esi, edi
	dec	dl
	jnz	@1

	Camellia_FLlayer	esi, ebp, ebp-8

	sub	ebp, 16
	dec	dh
	jnz	@0

	mov	dl, 3
@@:
	call	Camellia_Feistel

	sub	ebp, 8
	xchg	esi, edi

	call	Camellia_Feistel

	sub	ebp, 8
	xchg	esi, edi

	dec	dl
	jnz	@B

	mov	eax, dword ptr [esi + 0]
	mov	ebx, dword ptr [esi + 4]
	mov	ecx, dword ptr [esi + 8]
	mov	edx, dword ptr [esi +12]
	xor	eax, dword ptr [ebp + 0]
	xor	ebx, dword ptr [ebp + 4] 
	xor	ecx, dword ptr [ebp - 8]
	xor	edx, dword ptr [ebp - 4]
	mov	dword ptr [esi + 0], ecx
	mov	dword ptr [esi + 4], edx
	mov	dword ptr [esi + 8], eax
	mov	dword ptr [esi +12], ebx

	popad
	ret

Camellia_Decrypt	endp

Camellia_Clear		proc
	push	eax
	push	edi

	xor	eax, eax

IF	KEY_SIZE eq 128
	mov	ecx, 208/4
ELSEIF	(KEY_SIZE eq 192) or (KEY_SIZE eq 256)
	mov	ecx, 272/4
ENDIF

	mov	edi, offset camelia_key_int
	cld
	rep	stosd

	pop	edi
	pop	eax
	ret
Camellia_Clear		endp

Camellia_Feistel	proc

comment %

Oryginal table :

	y[0] ^= t[0]^t[2]^t[3]^t[5]^t[6]^t[7];
	y[1] ^= t[0]^t[1]^t[3]^t[4]^t[6]^t[7];
	y[2] ^= t[0]^t[1]^t[2]^t[4]^t[5]^t[7];
	y[3] ^= t[1]^t[2]^t[3]^t[4]^t[5]^t[6];
	y[4] ^= t[0]^t[1]^t[5]^t[6]^t[7];
	y[5] ^= t[1]^t[2]^t[4]^t[6]^t[7];
	y[6] ^= t[2]^t[3]^t[4]^t[5]^t[7];
	y[7] ^= t[0]^t[3]^t[4]^t[5]^t[6];

My proposition :

	let v = t[4]^t[5]^t[6]^t[7]

	y[0] ^= t[0]^t[2]^t[3]^v^t[4];
	y[1] ^= t[1]^t[3]^t[0]^v^t[5];
	y[2] ^= t[2]^t[0]^t[1]^v^t[6];
	y[3] ^= t[3]^t[1]^t[2]^v^t[7];
	y[4] ^= t[0]^t[1]^v^t[4];
	y[5] ^= t[1]^t[2]^v^t[5];
	y[6] ^= t[2]^t[3]^v^t[6];
	y[7] ^= t[3]^t[0]^v^t[7];

%

comment %	Camellia_Feistel(esi,ebp,edi)
		ebx = offset SBOX
		eax, ecx = temporary regs	%

		mov	eax, dword ptr [esi]
		xor	eax, dword ptr [ebp]
		xlatb
		ror	eax, 8
		xlatb
		rol	al, 1
		ror	eax, 8
		xlatb
		ror	al, 1
		rol	ah, 1
		ror	eax, 8
		xlatb		

		xor	dword ptr [edi+0], eax
		rol	eax, 8
		xor	dword ptr [edi+0], eax
		rol	eax, 8		
		xor	dword ptr [edi+4], eax
		rol	eax, 8
		xor	dword ptr [edi+0], eax
		xor	dword ptr [edi+4], eax

		mov	eax, dword ptr [esi+4]
		xor	eax, dword ptr [ebp+4]
		
		xlatb
		rol	al, 1
		ror	eax, 8
		xlatb
		ror	al, 1
		rol	ah, 1
		ror	eax, 8
		xlatb
		ror	eax, 8
		xlatb

		ror	eax, 8
		
		mov	cl, al	;t4
		xor	cl, ah	;t5
		ror	eax, 16
		xor	cl, al	;t6
		xor	cl, ah	;t7

		mov	ch, cl
		xor	ax, cx
		rol	eax, 16
		xor	ax, cx

		xor	dword ptr [edi+0], eax
		xor	dword ptr [edi+4], eax

		ret

SBOX	db	112,130, 44,236,179, 39,192,229,228,133, 87, 53,234, 12,174, 65
	db	 35,239,107,147, 69, 25,165, 33,237, 14, 79, 78, 29,101,146,189
	db	134,184,175,143,124,235, 31,206, 62, 48,220, 95, 94,197, 11, 26
	db	166,225, 57,202,213, 71, 93, 61,217,  1, 90,214, 81, 86,108, 77
	db	139, 13,154,102,251,204,176, 45,116, 18, 43, 32,240,177,132,153
	db	223, 76,203,194, 52,126,118,  5,109,183,169, 49,209, 23,  4,215
	db	 20, 88, 58, 97,222, 27, 17, 28, 50, 15,156, 22, 83, 24,242, 34
	db	254, 68,207,178,195,181,122,145, 36,  8,232,168, 96,252,105, 80
	db	170,208,160,125,161,137, 98,151, 84, 91, 30,149,224,255,100,210
	db	 16,196,  0, 72,163,247,117,219,138,  3,230,218,  9, 63,221,148
	db	135, 92,131,  2,205, 74,144, 51,115,103,246,243,157,127,191,226
	db	 82,155,216, 38,200, 55,198, 59,129,150,111, 75, 19,190, 99, 46
	db	233,121,167,140,159,110,188,142, 41,245,249,182, 47,253,180, 89
	db	120,152,  6,106,231, 70,113,186,212, 37,171, 66,136,162,141,250
	db	114,  7,185, 85,248,238,172, 10, 54, 73, 42,104, 60, 56,241,164
	db	 64, 40,211,123,187,201, 67,193, 21,227,173,244,119,199,128,158
Camellia_Feistel	endp

RotBlock	proc

	mov	ecx, edx
	and	ecx, 1Fh
	jz	@F

	shr	edx, 5
	mov	eax, edx
	and	eax, 3
	mov	eax, dword ptr [esi+4*eax]
	shl	eax, cl
	mov	dword ptr [edi], eax

	inc	edx
	mov	eax, edx
	and	eax, 3
	mov	eax, dword ptr [esi+4*eax]
	push	eax
	shl	eax, cl
	mov	dword ptr [edi+4], eax
	pop	eax

	neg	cl
	add	cl, 32
	shr	eax, cl
	xor	eax, dword ptr [edi]
	bswap	eax
	mov	dword ptr [edi], eax

	inc	edx
	and	edx, 3
	mov	eax, dword ptr [esi+4*edx]
	shr	eax, cl

	xor	eax, dword ptr [edi+4]
	bswap	eax
	mov	dword ptr [edi+4], eax
	jmp	@exit

@@:
	shr	edx, 5
	mov	ecx, edx
	and	ecx, 3
	mov	eax, dword ptr [esi+4*ecx]
	bswap	eax
	mov	dword ptr [edi], eax

	inc	edx
	and	edx, 3
	mov	eax, dword ptr [esi+4*edx]
	bswap	eax
	mov	dword ptr [edi+4], eax
@exit:
	ret
RotBlock	endp

.data?
IF	KEY_SIZE eq 128

	temp_buffer	db  32 dup (?)
	camelia_key_int	db 208 dup (?)

ELSEIF	(KEY_SIZE eq 192) or (KEY_SIZE eq 256)

	temp_buffer	db  64 dup (?)
	camelia_key_int	db 272 dup (?)

ENDIF
