comment !ON

Algo	: C2 [Cryptomeria Cipher] by 4C Entity, LLC
Block	: 8 bytes (64b)
Key	: 7 bytes (56b)

	push	offset dbKey
	call	C2_SetKey

	push	offset dbIn
	push	offset dbOut
	call	C2_Encrypt

	push	offset dbIn
	push	offset dbOut
	call	C2_Decrypt

	call	C2_Clear

31.10.2005 WiteG (witeg@poczta.fm, www.witeg.prv.pl)


Note that the Secret Constants (sbox) provided with this source code will not
work with standard CPRM/CPPM implementations. The secret constant is available
under license from the 4C Entity, LLC.

Test Data for C2 with Facsimile Sbox:

k = 5e 91 6a ef 34 1f a3
P = 89 06 7f 2b e2 a6 0d 6f
C = 8f e6 5f e4 f7 ba 80 05

!OFF

NROUND	equ 10

_ROL	MACRO X, Y
	LOCAL W

	W equ (((X SHL Y) AND 0FFh) OR ((X SHR (8-Y))))

	EXITM %W
ENDM

.const
_ARG_1		equ	24h
_ARG_2		equ	_ARG_1 + 4
_ARG_3		equ	_ARG_2 + 4
_ARG_4		equ	_ARG_3 + 4
_ARG_5		equ	_ARG_4 + 4
_ARG_6		equ	_ARG_5 + 4
_ARG_7		equ	_ARG_6 + 4
_EAX		equ	28

.data

; C2_Facsimile_S-Box !

C2_sbox	equ $
db 0B6h, 0AAh, 0EBh, 0B3h, 035h, 05Dh, 0EEh, 0B1h, 072h, 033h, 005h, 013h, 06Dh, 0C7h, 06Ch, 027h
db 025h, 054h, 0E9h, 04Ch, 0DEh, 0C3h, 021h, 039h, 0A9h, 0ABh, 0D6h, 0DFh, 0E8h, 071h, 094h, 0AEh
db 016h, 044h, 076h, 0CDh, 0B7h, 078h, 020h, 0F0h, 0C1h, 09Fh, 0CFh, 0AFh, 00Fh, 0CBh, 059h, 083h
db 03Ah, 05Eh, 0B8h, 0B5h, 0F3h, 047h, 080h, 0C2h, 0F6h, 014h, 0E6h, 069h, 0FCh, 017h, 0E0h, 0E5h
db 079h, 0F9h, 012h, 0BFh, 03Ch, 0B4h, 066h, 0ADh, 0F7h, 065h, 095h, 0F4h, 04Eh, 002h, 0A0h, 007h
db 04Dh, 02Fh, 00Dh, 07Eh, 0E4h, 0EFh, 0A1h, 08Ch, 06Eh, 0D2h, 0FDh, 019h, 01Ch, 082h, 042h, 0BBh
db 09Ah, 043h, 0C6h, 0E2h, 01Fh, 0F2h, 075h, 01Ah, 063h, 045h, 0D1h, 030h, 081h, 07Fh, 08Eh, 062h
db 03Bh, 0A4h, 0FBh, 01Eh, 05Fh, 0BCh, 0B0h, 040h, 08Bh, 074h, 038h, 08Ah, 0C4h, 073h, 09Ch, 009h
db 0D4h, 0EDh, 0D3h, 05Ah, 060h, 048h, 0C5h, 09Eh, 001h, 0CCh, 034h, 01Bh, 058h, 036h, 023h, 088h
db 07Ah, 090h, 09Bh, 08Fh, 0BDh, 03Fh, 0B9h, 057h, 0A2h, 03Eh, 004h, 0B2h, 049h, 037h, 05Ch, 07Dh
db 061h, 04Ah, 0A6h, 067h, 0ECh, 07Ch, 00Eh, 096h, 0DDh, 0E3h, 02Ch, 056h, 008h, 00Ch, 08Dh, 02Bh
db 06Ah, 0FEh, 0EAh, 0A3h, 0CAh, 03Dh, 091h, 0E7h, 0C9h, 0ACh, 003h, 0D5h, 089h, 086h, 0DCh, 010h
db 055h, 077h, 0C8h, 0D7h, 097h, 024h, 046h, 09Dh, 00Ah, 01Dh, 022h, 0D9h, 0FFh, 05Bh, 052h, 0D8h
db 000h, 0FAh, 053h, 026h, 029h, 02Eh, 02Ah, 011h, 0C0h, 06Fh, 04Fh, 07Bh, 028h, 099h, 041h, 092h
db 0DBh, 0F8h, 050h, 0A8h, 051h, 0A5h, 04Bh, 093h, 087h, 0DAh, 006h, 085h, 02Dh, 0BAh, 00Bh, 098h
db 070h, 06Bh, 0BEh, 0F1h, 018h, 0D0h, 031h, 068h, 015h, 084h, 064h, 0E1h, 0CEh, 0A7h, 0F5h, 032h

.data?
C2_sk	dd NROUND dup (?)

.code
OPTION PROLOGUE:NONE
OPTION EPILOGUE:NONE

C2_SetKey	proc	ptrPass:DWORD

	pushad
	mov	esi, dword ptr [esp+_ARG_1]	;ptrPass
	mov	eax, dword ptr [esi]
	mov	ebx, dword ptr [esi+3]
	bswap	eax
	bswap	ebx
	shr	eax, 8
	xor	ecx, ecx

@@:	and	eax, 00FFFFFFh
	movzx	edx, al
	xor	edx, ecx
	mov	edi, eax
	mov	dl, byte ptr [C2_sbox+edx]
	shld	eax, ebx, 17
	shl	edx, 4
	add	edx, ebx
	shr	edi, 24-17
	mov	dword ptr [C2_sk+4*ecx], edx
	shl	ebx, 17
	inc	ecx
	or	ebx, edi
	cmp	ecx, NROUND
	jnz	@B
	popad
	ret	4

C2_SetKey	endp

C2_Clear	proc

	push	eax
	push	ecx
	push	edi

	xor	eax, eax
	mov	ecx, NROUND
	mov	edi, offset C2_sk
	cld
	rep	stosd

	pop	edi
	pop	ecx
	pop	eax
	ret

C2_Clear	endp

C2_Encrypt	proc	ptrOut:DWORD, ptrIn:DWORD

	pushad

	mov	esi, dword ptr [esp+_ARG_2]	;ptrIn

	mov	edi, dword ptr [esi]
	mov	ecx, dword ptr [esi+4]

	bswap	edi
	bswap	ecx

	mov	esi, offset C2_sk
	mov	ebx, offset C2_sbox

@@:	mov	eax, ecx	
	add	eax, dword ptr [esi]
	xlatb

	mov	dh, al
	mov	dl, al
	rol	dh, 2
	rol	dl, 5
	xor	eax, (((_ROL(0C9h, 2)) SHL 24) OR ((_ROL(02Bh, 5)) SHL 16) OR ((_ROL(065h, 1)) SHL 8))
	shl	edx, 16
	mov	dh, al
	rol	dh, 1
	xor	eax, edx
	mov	edx, eax
	rol	edx, 9
	xor	eax, edx
	rol	edx, 22-9

	xor	eax, edx
	add	esi, 4
	add	edi, eax
	cmp	esi, offset C2_sk + NROUND*4
	xchg	edi, ecx
	jnz	@B

	mov	esi, dword ptr [esp+_ARG_1]	;ptrOut

	bswap	ecx
	bswap	edi

	mov	dword ptr [esi], ecx
	mov	dword ptr [esi+4], edi

	popad
	ret	8

C2_Encrypt	endp

C2_Decrypt	proc	ptrOut:DWORD, ptrIn:DWORD

	pushad

	mov	esi, dword ptr [esp+_ARG_2]	;ptrIn

	mov	edi, dword ptr [esi]
	mov	ecx, dword ptr [esi+4]

	bswap	edi
	bswap	ecx

	mov	esi, offset C2_sk+ (NROUND-1)*4
	mov	ebx, offset C2_sbox

@@:	mov	eax, ecx	
	add	eax, dword ptr [esi]
	xlatb

	mov	dh, al
	mov	dl, al
	rol	dh, 2
	rol	dl, 5
	xor	eax, (((_ROL(0C9h, 2)) SHL 24) OR ((_ROL(02Bh, 5)) SHL 16) OR ((_ROL(065h, 1)) SHL 8))
	shl	edx, 16
	mov	dh, al
	rol	dh, 1
	xor	eax, edx
	mov	edx, eax
	rol	edx, 9
	xor	eax, edx
	rol	edx, 22-9

	xor	eax, edx
	sub	esi, 4
	sub	edi, eax
	cmp	esi, offset C2_sk -4
	xchg	edi, ecx
	jnz	@B

	mov	esi, dword ptr [esp+_ARG_1]	;ptrOut

	bswap	ecx
	bswap	edi

	mov	dword ptr [esi], ecx
	mov	dword ptr [esi+4], edi

	popad
	ret	8

C2_Decrypt	endp

OPTION PROLOGUE:DEFAULT
OPTION EPILOGUE:DEFAULT