comment %

Algo	: Anubis (by Vincent Rijmen & Paulo Barreto)
Block	: 16 bytes
Key	: 128/160/192/224/256/288/320 bits

	push	offset password
	call	Anubis_SetKey

	push	ANUBIS_ENCRYPT
	push	offset plain
	push	offset cipher
	call	Anubis_Crypt

	push	ANUBIS_DECRYPT
	push	offset cipher
	push	offset decrypted_plain
	call	Anubis_Crypt

	call	Anubis_Clear


This software implements the first and second ("tweaked") version of Anubis.


03.05.2002 WiteG//xtreeme (witeg@poczta.fm, www.witeg.prv.pl)
%

; ---------------------------------------------------------------------------
; You should set key size (KEY_SIZE) and algorithm version (ANUBIS_VER) !
; ---------------------------------------------------------------------------

KEY_SIZE	equ	128
ANUBIS_VER	equ	2		; 1 = first version 
					; 2 = "tweaked" version

; ---------------------------------------------------------------------------

N		equ	KEY_SIZE/32
R		equ	8+N
ANUBIS_ENCRYPT	equ	0
ANUBIS_DECRYPT	equ	1


.code
Anubis_Crypt	proc	ptrOut:DWORD, ptrIn:DWORD, flag:DWORD
	pushad
	mov	dword ptr [_esp], esp

	mov	eax, flag
	mov	esi, ptrIn
	mov	edi, offset anubis_enc_key
	test	eax, eax
	jz	@F
	add	edi, 16*R
@@:
	mov	esp, ptrOut
	mov	ecx, 12
@@:
	mov	eax, dword ptr [esi+ecx]
	bswap	eax
	xor	eax, dword ptr [edi+ecx]
	mov	dword ptr [esp+ecx], eax
	sub	ecx, 4
	jns	@B

	add	edi, 16
	xor	eax, eax
	xor	ebx, ebx
	xor	ecx, ecx
	mov	esi, offset inter
	mov	dword ptr [_round], R-1
@@:
	mov	ebp, dword ptr [edi+4*ecx]
	mov	al, byte ptr [esp+3]
	mov	bl, byte ptr [esp+7]
	xor	ebp, dword ptr [T0+4*eax]
	xor	ebp, dword ptr [T1+4*ebx]
	mov	al, byte ptr [esp+11]
	mov	bl, byte ptr [esp+15]
	xor	ebp, dword ptr [T2+4*eax]
	dec	esp
	xor	ebp, dword ptr [T3+4*ebx]
	mov	dword ptr [esi+4*ecx], ebp
	inc	ecx
	and	ecx, 3
	jnz	@B

	add	esp, 4
	xchg	esi, esp
	add	edi, 16
	dec	dword ptr [_round]
	jnz	@B

	;wynik pod esp
	
@@:
	mov	al, byte ptr [esp+3]
	mov	bl, byte ptr [esp+7]
	mov	dh, byte ptr [T0+4*eax+3]
	mov	dl, byte ptr [T1+4*ebx+2]
	mov	al, byte ptr [esp+11]
	shl	edx, 16
	mov	bl, byte ptr [esp+15]
	mov	dh, byte ptr [T2+4*eax+1]
	mov	dl, byte ptr [T3+4*ebx+0]
	dec	esp
	xor	edx, dword ptr [edi+4*ecx]
	mov	dword ptr [esi+4*ecx], edx
	inc	ecx
	and	ecx, 3
	jnz	@B

IFE	(R and 1)		;parzyste

	mov	ecx, 12
@@:
	mov	eax, dword ptr [esi+ecx]
	bswap	eax
	mov	dword ptr [esi+ecx], eax
	sub	ecx, 4
	jns	@B

ELSE

	mov	ecx, 12
@@:
	mov	eax, dword ptr [esi+ecx]
	bswap	eax
	mov	dword ptr [esp+4+ecx], eax
	sub	ecx, 4
	jns	@B

ENDIF

	mov	esp, dword ptr [_esp]

	xor	eax, eax
	mov	ecx, 6+2*N
	mov	edi, offset _round
	cld
	rep	stosd

	popad
	ret
Anubis_Crypt	endp

Anubis_SetKey	proc	ptrPass:DWORD
	pushad

	mov	dword ptr [_esp], esp
	mov	edi, ptrPass
	mov	esi, offset kappa
	mov	esp, offset anubis_enc_key
	mov	ebp, offset K_struct

	mov	ecx, 4*(N-1)
@@:
	mov	eax, dword ptr [edi+ecx]
	bswap	eax
	mov	dword ptr [esi+ecx], eax
	sub	ecx, 4
	jns	@B

	mov	dword ptr [_round], R + 1
	jmp	_first_round

_next_round:
	xor	ecx, ecx
_inter:
	mov	edi, ecx

	mov	al, byte ptr [esi + 4*edi+3]
	mov	edx, dword ptr [T0 + 4*eax]

	dec	edi

	IF	N eq 4
		and	edi, 3
	ELSEIF	N eq 8
		and	edi, 7
	ELSE
		jns	@F
		add	edi, N
	@@:
	ENDIF

	mov	al, byte ptr [esi + 4*edi +2]
	xor	edx, dword ptr [T1 + 4*eax]

	dec	edi

	IF	N eq 4
		and	edi, 3
	ELSEIF	N eq 8
		and	edi, 7
	ELSE
		jns	@F
		add	edi, N
	@@:
	ENDIF

	mov	al, byte ptr [esi + 4*edi +1]
	xor	edx, dword ptr [T2 + 4*eax]

	dec	edi

	IF	N eq 4
		and	edi, 3
	ELSEIF	N eq 8
		and	edi, 7
	ELSE
		jns	@F
		add	edi, N
	@@:
	ENDIF

	mov	al, byte ptr [esi + 4*edi +0]
	xor	edx, dword ptr [T3 + 4*eax]

	mov	dword ptr [inter+4*ecx], edx

	inc	ecx
	cmp	ecx, N
	jnz	_inter

	mov	edi, 4*(N-1)
@@:
	mov	dword ptr [esi + edi], edx
	mov	edx, dword ptr [inter + edi - 4]
	sub	edi, 4
	jnz	@B

	mov	dword ptr [esi], edx
	mov	ecx, dword ptr [_round]
	xor	edx, dword ptr [rc + 4*ecx -4]
	mov	dword ptr [esi], edx

_first_round:
	movzx	eax, byte ptr [esi + 4*(N-1) + 3]
	movzx	ebx, byte ptr [esi + 4*(N-1) + 2]
	mov	ecx, dword ptr [T4 + 4*eax]
	mov	edx, dword ptr [T4 + 4*ebx]
	mov	dword ptr [ebp + 0*4], ecx
	mov	dword ptr [ebp + 1*4], edx
	mov	al, byte ptr [esi + 4*(N-1) + 1]
	mov	bl, byte ptr [esi + 4*(N-1) + 0]
	mov	ecx, dword ptr [T4 + 4*eax]
	mov	edx, dword ptr [T4 + 4*ebx]
	mov	dword ptr [ebp + 2*4], ecx
	mov	dword ptr [ebp + 3*4], edx

	mov	edi, N - 2
	xor	ecx, ecx
_next_subrnd:
	mov	al, byte ptr [ebp+3]
	mov	bl, byte ptr [ebp+2]
	mov	dh, byte ptr [T5+4*eax+3]
	mov	dl, byte ptr [T5+4*ebx+2]
	mov	al, byte ptr [ebp+1]
	shl	edx, 16
	mov	bl, byte ptr [ebp+0]
	mov	cl, byte ptr [esi+4*edi+3]
	mov	dh, byte ptr [T5+4*eax+1]
	mov	dl, byte ptr [T5+4*ebx+0]
	xor	edx, dword ptr [T4+4*ecx]
	mov	al, byte ptr [ebp+7]
	mov	dword ptr [ebp], edx
	mov	bl, byte ptr [ebp+6]
	mov	dh, byte ptr [T5+4*eax+3]
	mov	dl, byte ptr [T5+4*ebx+2]
	mov	al, byte ptr [ebp+5]
	shl	edx, 16
	mov	bl, byte ptr [ebp+4]
	mov	cl, byte ptr [esi+4*edi+2]
	mov	dh, byte ptr [T5+4*eax+1]
	mov	dl, byte ptr [T5+4*ebx+0]
	xor	edx, dword ptr [T4+4*ecx]
	mov	al, byte ptr [ebp+11]
	mov	dword ptr [ebp+4], edx
	mov	bl, byte ptr [ebp+10]
	mov	dh, byte ptr [T5+4*eax+3]
	mov	dl, byte ptr [T5+4*ebx+2]
	mov	al, byte ptr [ebp+9]
	shl	edx, 16
	mov	bl, byte ptr [ebp+8]
	mov	cl, byte ptr [esi+4*edi+1]
	mov	dh, byte ptr [T5+4*eax+1]
	mov	dl, byte ptr [T5+4*ebx+0]
	xor	edx, dword ptr [T4+4*ecx]
	mov	al, byte ptr [ebp+15]
	mov	dword ptr [ebp+8], edx
	mov	bl, byte ptr [ebp+14]
	mov	dh, byte ptr [T5+4*eax+3]
	mov	dl, byte ptr [T5+4*ebx+2]
	mov	al, byte ptr [ebp+13]
	shl	edx, 16
	mov	bl, byte ptr [ebp+12]
	mov	cl, byte ptr [esi+4*edi+0]
	mov	dh, byte ptr [T5+4*eax+1]
	mov	dl, byte ptr [T5+4*ebx+0]
	xor	edx, dword ptr [T4+4*ecx]
	dec	edi
	mov	dword ptr [ebp+12], edx
	jns	_next_subrnd

	mov	ecx, dword ptr [ebp+0]
	mov	dword ptr [esp+12], edx
	mov	dword ptr [esp+0], ecx
	mov	edx, dword ptr [ebp+4]
	mov	ecx, dword ptr [ebp+8]
	mov	dword ptr [esp+4], edx
	mov	dword ptr [esp+8], ecx

	inc	edi
	add	esp, 16
	dec	dword ptr [_round]
	jnz	_next_round

	xor	ecx, ecx
	xor	edx, edx
	lea	esi, [esp-32]
	mov	edi, offset T4

	mov	dword ptr [_round], R-1

@next_dec_round:
	mov	dword ptr [inter], 4
@@:
	mov	al, byte ptr [esi+3]
	mov	bl, byte ptr [esi+2]
	mov	cl, byte ptr [edi+4*eax]
	mov	dl, byte ptr [edi+4*ebx]
	mov	ebp, dword ptr [T0+4*ecx]
	mov	al, byte ptr [esi+1]
	xor	ebp, dword ptr [T1+4*edx]
	mov	bl, byte ptr [esi+0]
	mov	cl, byte ptr [edi+4*eax]
	mov	dl, byte ptr [edi+4*ebx]
	xor	ebp, dword ptr [T2+4*ecx]
	xor	ebp, dword ptr [T3+4*edx]
	mov	dword ptr [esp], ebp
	add	esp, 4
	add	esi, 4
	dec	dword ptr [inter]
	jnz	@B

	sub	esi, 32
	dec	dword ptr [_round]
	jnz	@next_dec_round

	mov	eax, dword ptr [esi]
	mov	ebx, dword ptr [esi+4]
	mov	ecx, dword ptr [esi+8]
	mov	edx, dword ptr [esi+12]
	mov	dword ptr [esp], eax
	mov	dword ptr [esp+4], ebx
	mov	dword ptr [esp+8], ecx
	mov	dword ptr [esp+12], edx

	mov	esp, dword ptr [_esp]
	xor	eax, eax
	mov	ecx, 2*N + 6
	mov	edi, offset _round
	cld
	rep	stosd

	popad
	ret
Anubis_SetKey	endp

Anubis_Clear	proc
	pushad
	xor	eax, eax
	mov	ecx, 4*(R+R+1)
	mov	edi, offset anubis_enc_key
	cld
	rep	stosd
	popad
	ret
Anubis_Clear	endp

.data

IF	ANUBIS_VER	eq	2

T0	dd	0ba69d2bbh, 054a84de5h, 02f5ebce2h, 074e8cd25h, 053a651f7h, 0d3bb6bd0h, 0d2b96fd6h, 04d9a29b3h
	dd	050a05dfdh, 0ac458acfh, 08d070e09h, 0bf63c6a5h, 070e0dd3dh, 052a455f1h, 09a29527bh, 04c982db5h
	dd	0eac98f46h, 0d5b773c4h, 097336655h, 0d1bf63dch, 03366ccaah, 051a259fbh, 05bb671c7h, 0a651a2f3h
	dd	0dea15ffeh, 048903dadh, 0a84d9ad7h, 0992f5e71h, 0dbab4be0h, 03264c8ach, 0b773e695h, 0fce5d732h
	dd	0e3dbab70h, 09e214263h, 0913f7e41h, 09b2b567dh, 0e2d9af76h, 0bb6bd6bdh, 04182199bh, 06edca579h
	dd	0a557aef9h, 0cb8b0b80h, 06bd6b167h, 095376e59h, 0a15fbee1h, 0f3fbeb10h, 0b17ffe81h, 00204080ch
	dd	0cc851792h, 0c49537a2h, 01d3a744eh, 014285078h, 0c39b2bb0h, 063c69157h, 0daa94fe6h, 05dba69d3h
	dd	05fbe61dfh, 0dca557f2h, 07dfae913h, 0cd871394h, 07ffee11fh, 05ab475c1h, 06cd8ad75h, 05cb86dd5h
	dd	0f7f3fb08h, 0264c98d4h, 0ffe3db38h, 0edc79354h, 0e8cd874ah, 09d274e69h, 06fdea17fh, 08e010203h
	dd	019326456h, 0a05dbae7h, 0f0fde71ah, 0890f1e11h, 00f1e3c22h, 0070e1c12h, 0af4386c5h, 0fbebcb20h
	dd	008102030h, 0152a547eh, 00d1a342eh, 004081018h, 001020406h, 064c88d45h, 0dfa35bf8h, 076ecc529h
	dd	079f2f90bh, 0dda753f4h, 03d7af48eh, 0162c5874h, 03f7efc82h, 0376edcb2h, 06ddaa973h, 03870e090h
	dd	0b96fdeb1h, 073e6d137h, 0e9cf834ch, 0356ad4beh, 055aa49e3h, 071e2d93bh, 07bf6f107h, 08c050a0fh
	dd	072e4d531h, 0880d1a17h, 0f6f1ff0eh, 02a54a8fch, 03e7cf884h, 05ebc65d9h, 0274e9cd2h, 0468c0589h
	dd	00c183028h, 065ca8943h, 068d0bd6dh, 061c2995bh, 003060c0ah, 0c19f23bch, 057ae41efh, 0d6b17fceh
	dd	0d9af43ech, 058b07dcdh, 0d8ad47eah, 066cc8549h, 0d7b37bc8h, 03a74e89ch, 0c88d078ah, 03c78f088h
	dd	0fae9cf26h, 096316253h, 0a753a6f5h, 0982d5a77h, 0ecc59752h, 0b86ddab7h, 0c7933ba8h, 0ae4182c3h
	dd	069d2b96bh, 04b9631a7h, 0ab4b96ddh, 0a94f9ed1h, 067ce814fh, 00a14283ch, 0478e018fh, 0f2f9ef16h
	dd	0b577ee99h, 0224488cch, 0e5d7b364h, 0eec19f5eh, 0be61c2a3h, 02b56acfah, 0811f3e21h, 01224486ch
	dd	0831b362dh, 01b366c5ah, 00e1c3824h, 023468ccah, 0f5f7f304h, 0458a0983h, 0214284c6h, 0ce811f9eh
	dd	0499239abh, 02c58b0e8h, 0f9efc32ch, 0e6d1bf6eh, 0b671e293h, 02850a0f0h, 0172e5c72h, 08219322bh
	dd	01a34685ch, 08b0b161dh, 0fee1df3eh, 08a09121bh, 009122436h, 0c98f038ch, 087132635h, 04e9c25b9h
	dd	0e1dfa37ch, 02e5cb8e4h, 0e4d5b762h, 0e0dda77ah, 0ebcb8b40h, 0903d7a47h, 0a455aaffh, 01e3c7844h
	dd	085172e39h, 060c09d5dh, 000000000h, 0254a94deh, 0f4f5f702h, 0f1ffe31ch, 094356a5fh, 00b162c3ah
	dd	0e7d3bb68h, 075eac923h, 0efc39b58h, 03468d0b8h, 03162c4a6h, 0d4b577c2h, 0d0bd67dah, 086112233h
	dd	07efce519h, 0ad478ec9h, 0fde7d334h, 02952a4f6h, 03060c0a0h, 03b76ec9ah, 09f234665h, 0f8edc72ah
	dd	0c6913faeh, 013264c6ah, 0060c1814h, 0050a141eh, 0c59733a4h, 011224466h, 077eec12fh, 07cf8ed15h
	dd	07af4f501h, 078f0fd0dh, 0366cd8b4h, 01c387048h, 03972e496h, 059b279cbh, 018306050h, 056ac45e9h
	dd	0b37bf68dh, 0b07dfa87h, 0244890d8h, 0204080c0h, 0b279f28bh, 09239724bh, 0a35bb6edh, 0c09d27bah
	dd	044880d85h, 062c49551h, 010204060h, 0b475ea9fh, 084152a3fh, 043861197h, 0933b764dh, 0c2992fb6h
	dd	04a9435a1h, 0bd67cea9h, 08f030605h, 02d5ab4eeh, 0bc65caafh, 09c254a6fh, 06ad4b561h, 040801d9dh
	dd	0cf831b98h, 0a259b2ebh, 0801d3a27h, 04f9e21bfh, 01f3e7c42h, 0ca890f86h, 0aa4992dbh, 042841591h

T1	dd	069babbd2h, 0a854e54dh, 05e2fe2bch, 0e87425cdh, 0a653f751h, 0bbd3d06bh, 0b9d2d66fh, 09a4db329h
	dd	0a050fd5dh, 045accf8ah, 0078d090eh, 063bfa5c6h, 0e0703dddh, 0a452f155h, 0299a7b52h, 0984cb52dh
	dd	0c9ea468fh, 0b7d5c473h, 033975566h, 0bfd1dc63h, 06633aacch, 0a251fb59h, 0b65bc771h, 051a6f3a2h
	dd	0a1defe5fh, 09048ad3dh, 04da8d79ah, 02f99715eh, 0abdbe04bh, 06432acc8h, 073b795e6h, 0e5fc32d7h
	dd	0dbe370abh, 0219e6342h, 03f91417eh, 02b9b7d56h, 0d9e276afh, 06bbbbdd6h, 082419b19h, 0dc6e79a5h
	dd	057a5f9aeh, 08bcb800bh, 0d66b67b1h, 03795596eh, 05fa1e1beh, 0fbf310ebh, 07fb181feh, 004020c08h
	dd	085cc9217h, 095c4a237h, 03a1d4e74h, 028147850h, 09bc3b02bh, 0c6635791h, 0a9dae64fh, 0ba5dd369h
	dd	0be5fdf61h, 0a5dcf257h, 0fa7d13e9h, 087cd9413h, 0fe7f1fe1h, 0b45ac175h, 0d86c75adh, 0b85cd56dh
	dd	0f3f708fbh, 04c26d498h, 0e3ff38dbh, 0c7ed5493h, 0cde84a87h, 0279d694eh, 0de6f7fa1h, 0018e0302h
	dd	032195664h, 05da0e7bah, 0fdf01ae7h, 00f89111eh, 01e0f223ch, 00e07121ch, 043afc586h, 0ebfb20cbh
	dd	010083020h, 02a157e54h, 01a0d2e34h, 008041810h, 002010604h, 0c864458dh, 0a3dff85bh, 0ec7629c5h
	dd	0f2790bf9h, 0a7ddf453h, 07a3d8ef4h, 02c167458h, 07e3f82fch, 06e37b2dch, 0da6d73a9h, 0703890e0h
	dd	06fb9b1deh, 0e67337d1h, 0cfe94c83h, 06a35bed4h, 0aa55e349h, 0e2713bd9h, 0f67b07f1h, 0058c0f0ah
	dd	0e47231d5h, 00d88171ah, 0f1f60effh, 0542afca8h, 07c3e84f8h, 0bc5ed965h, 04e27d29ch, 08c468905h
	dd	0180c2830h, 0ca654389h, 0d0686dbdh, 0c2615b99h, 006030a0ch, 09fc1bc23h, 0ae57ef41h, 0b1d6ce7fh
	dd	0afd9ec43h, 0b058cd7dh, 0add8ea47h, 0cc664985h, 0b3d7c87bh, 0743a9ce8h, 08dc88a07h, 0783c88f0h
	dd	0e9fa26cfh, 031965362h, 053a7f5a6h, 02d98775ah, 0c5ec5297h, 06db8b7dah, 093c7a83bh, 041aec382h
	dd	0d2696bb9h, 0964ba731h, 04babdd96h, 04fa9d19eh, 0ce674f81h, 0140a3c28h, 08e478f01h, 0f9f216efh
	dd	077b599eeh, 04422cc88h, 0d7e564b3h, 0c1ee5e9fh, 061bea3c2h, 0562bfaach, 01f81213eh, 024126c48h
	dd	01b832d36h, 0361b5a6ch, 01c0e2438h, 04623ca8ch, 0f7f504f3h, 08a458309h, 04221c684h, 081ce9e1fh
	dd	09249ab39h, 0582ce8b0h, 0eff92cc3h, 0d1e66ebfh, 071b693e2h, 05028f0a0h, 02e17725ch, 019822b32h
	dd	0341a5c68h, 00b8b1d16h, 0e1fe3edfh, 0098a1b12h, 012093624h, 08fc98c03h, 013873526h, 09c4eb925h
	dd	0dfe17ca3h, 05c2ee4b8h, 0d5e462b7h, 0dde07aa7h, 0cbeb408bh, 03d90477ah, 055a4ffaah, 03c1e4478h
	dd	01785392eh, 0c0605d9dh, 000000000h, 04a25de94h, 0f5f402f7h, 0fff11ce3h, 035945f6ah, 0160b3a2ch
	dd	0d3e768bbh, 0ea7523c9h, 0c3ef589bh, 06834b8d0h, 06231a6c4h, 0b5d4c277h, 0bdd0da67h, 011863322h
	dd	0fc7e19e5h, 047adc98eh, 0e7fd34d3h, 05229f6a4h, 06030a0c0h, 0763b9aech, 0239f6546h, 0edf82ac7h
	dd	091c6ae3fh, 026136a4ch, 00c061418h, 00a051e14h, 097c5a433h, 022116644h, 0ee772fc1h, 0f87c15edh
	dd	0f47a01f5h, 0f0780dfdh, 06c36b4d8h, 0381c4870h, 0723996e4h, 0b259cb79h, 030185060h, 0ac56e945h
	dd	07bb38df6h, 07db087fah, 04824d890h, 04020c080h, 079b28bf2h, 039924b72h, 05ba3edb6h, 09dc0ba27h
	dd	08844850dh, 0c4625195h, 020106040h, 075b49feah, 015843f2ah, 086439711h, 03b934d76h, 099c2b62fh
	dd	0944aa135h, 067bda9ceh, 0038f0506h, 05a2deeb4h, 065bcafcah, 0259c6f4ah, 0d46a61b5h, 080409d1dh
	dd	083cf981bh, 059a2ebb2h, 01d80273ah, 09e4fbf21h, 03e1f427ch, 089ca860fh, 049aadb92h, 084429115h

T2	dd	0d2bbba69h, 04de554a8h, 0bce22f5eh, 0cd2574e8h, 051f753a6h, 06bd0d3bbh, 06fd6d2b9h, 029b34d9ah
	dd	05dfd50a0h, 08acfac45h, 00e098d07h, 0c6a5bf63h, 0dd3d70e0h, 055f152a4h, 0527b9a29h, 02db54c98h
	dd	08f46eac9h, 073c4d5b7h, 066559733h, 063dcd1bfh, 0ccaa3366h, 059fb51a2h, 071c75bb6h, 0a2f3a651h
	dd	05ffedea1h, 03dad4890h, 09ad7a84dh, 05e71992fh, 04be0dbabh, 0c8ac3264h, 0e695b773h, 0d732fce5h
	dd	0ab70e3dbh, 042639e21h, 07e41913fh, 0567d9b2bh, 0af76e2d9h, 0d6bdbb6bh, 0199b4182h, 0a5796edch
	dd	0aef9a557h, 00b80cb8bh, 0b1676bd6h, 06e599537h, 0bee1a15fh, 0eb10f3fbh, 0fe81b17fh, 0080c0204h
	dd	01792cc85h, 037a2c495h, 0744e1d3ah, 050781428h, 02bb0c39bh, 0915763c6h, 04fe6daa9h, 069d35dbah
	dd	061df5fbeh, 057f2dca5h, 0e9137dfah, 01394cd87h, 0e11f7ffeh, 075c15ab4h, 0ad756cd8h, 06dd55cb8h
	dd	0fb08f7f3h, 098d4264ch, 0db38ffe3h, 09354edc7h, 0874ae8cdh, 04e699d27h, 0a17f6fdeh, 002038e01h
	dd	064561932h, 0bae7a05dh, 0e71af0fdh, 01e11890fh, 03c220f1eh, 01c12070eh, 086c5af43h, 0cb20fbebh
	dd	020300810h, 0547e152ah, 0342e0d1ah, 010180408h, 004060102h, 08d4564c8h, 05bf8dfa3h, 0c52976ech
	dd	0f90b79f2h, 053f4dda7h, 0f48e3d7ah, 05874162ch, 0fc823f7eh, 0dcb2376eh, 0a9736ddah, 0e0903870h
	dd	0deb1b96fh, 0d13773e6h, 0834ce9cfh, 0d4be356ah, 049e355aah, 0d93b71e2h, 0f1077bf6h, 00a0f8c05h
	dd	0d53172e4h, 01a17880dh, 0ff0ef6f1h, 0a8fc2a54h, 0f8843e7ch, 065d95ebch, 09cd2274eh, 00589468ch
	dd	030280c18h, 0894365cah, 0bd6d68d0h, 0995b61c2h, 00c0a0306h, 023bcc19fh, 041ef57aeh, 07fced6b1h
	dd	043ecd9afh, 07dcd58b0h, 047ead8adh, 0854966cch, 07bc8d7b3h, 0e89c3a74h, 0078ac88dh, 0f0883c78h
	dd	0cf26fae9h, 062539631h, 0a6f5a753h, 05a77982dh, 09752ecc5h, 0dab7b86dh, 03ba8c793h, 082c3ae41h
	dd	0b96b69d2h, 031a74b96h, 096ddab4bh, 09ed1a94fh, 0814f67ceh, 0283c0a14h, 0018f478eh, 0ef16f2f9h
	dd	0ee99b577h, 088cc2244h, 0b364e5d7h, 09f5eeec1h, 0c2a3be61h, 0acfa2b56h, 03e21811fh, 0486c1224h
	dd	0362d831bh, 06c5a1b36h, 038240e1ch, 08cca2346h, 0f304f5f7h, 00983458ah, 084c62142h, 01f9ece81h
	dd	039ab4992h, 0b0e82c58h, 0c32cf9efh, 0bf6ee6d1h, 0e293b671h, 0a0f02850h, 05c72172eh, 0322b8219h
	dd	0685c1a34h, 0161d8b0bh, 0df3efee1h, 0121b8a09h, 024360912h, 0038cc98fh, 026358713h, 025b94e9ch
	dd	0a37ce1dfh, 0b8e42e5ch, 0b762e4d5h, 0a77ae0ddh, 08b40ebcbh, 07a47903dh, 0aaffa455h, 078441e3ch
	dd	02e398517h, 09d5d60c0h, 000000000h, 094de254ah, 0f702f4f5h, 0e31cf1ffh, 06a5f9435h, 02c3a0b16h
	dd	0bb68e7d3h, 0c92375eah, 09b58efc3h, 0d0b83468h, 0c4a63162h, 077c2d4b5h, 067dad0bdh, 022338611h
	dd	0e5197efch, 08ec9ad47h, 0d334fde7h, 0a4f62952h, 0c0a03060h, 0ec9a3b76h, 046659f23h, 0c72af8edh
	dd	03faec691h, 04c6a1326h, 01814060ch, 0141e050ah, 033a4c597h, 044661122h, 0c12f77eeh, 0ed157cf8h
	dd	0f5017af4h, 0fd0d78f0h, 0d8b4366ch, 070481c38h, 0e4963972h, 079cb59b2h, 060501830h, 045e956ach
	dd	0f68db37bh, 0fa87b07dh, 090d82448h, 080c02040h, 0f28bb279h, 0724b9239h, 0b6eda35bh, 027bac09dh
	dd	00d854488h, 0955162c4h, 040601020h, 0ea9fb475h, 02a3f8415h, 011974386h, 0764d933bh, 02fb6c299h
	dd	035a14a94h, 0cea9bd67h, 006058f03h, 0b4ee2d5ah, 0caafbc65h, 04a6f9c25h, 0b5616ad4h, 01d9d4080h
	dd	01b98cf83h, 0b2eba259h, 03a27801dh, 021bf4f9eh, 07c421f3eh, 00f86ca89h, 092dbaa49h, 015914284h

T3	dd	0bbd269bah, 0e54da854h, 0e2bc5e2fh, 025cde874h, 0f751a653h, 0d06bbbd3h, 0d66fb9d2h, 0b3299a4dh
	dd	0fd5da050h, 0cf8a45ach, 0090e078dh, 0a5c663bfh, 03ddde070h, 0f155a452h, 07b52299ah, 0b52d984ch
	dd	0468fc9eah, 0c473b7d5h, 055663397h, 0dc63bfd1h, 0aacc6633h, 0fb59a251h, 0c771b65bh, 0f3a251a6h
	dd	0fe5fa1deh, 0ad3d9048h, 0d79a4da8h, 0715e2f99h, 0e04babdbh, 0acc86432h, 095e673b7h, 032d7e5fch
	dd	070abdbe3h, 06342219eh, 0417e3f91h, 07d562b9bh, 076afd9e2h, 0bdd66bbbh, 09b198241h, 079a5dc6eh
	dd	0f9ae57a5h, 0800b8bcbh, 067b1d66bh, 0596e3795h, 0e1be5fa1h, 010ebfbf3h, 081fe7fb1h, 00c080402h
	dd	0921785cch, 0a23795c4h, 04e743a1dh, 078502814h, 0b02b9bc3h, 05791c663h, 0e64fa9dah, 0d369ba5dh
	dd	0df61be5fh, 0f257a5dch, 013e9fa7dh, 0941387cdh, 01fe1fe7fh, 0c175b45ah, 075add86ch, 0d56db85ch
	dd	008fbf3f7h, 0d4984c26h, 038dbe3ffh, 05493c7edh, 04a87cde8h, 0694e279dh, 07fa1de6fh, 00302018eh
	dd	056643219h, 0e7ba5da0h, 01ae7fdf0h, 0111e0f89h, 0223c1e0fh, 0121c0e07h, 0c58643afh, 020cbebfbh
	dd	030201008h, 07e542a15h, 02e341a0dh, 018100804h, 006040201h, 0458dc864h, 0f85ba3dfh, 029c5ec76h
	dd	00bf9f279h, 0f453a7ddh, 08ef47a3dh, 074582c16h, 082fc7e3fh, 0b2dc6e37h, 073a9da6dh, 090e07038h
	dd	0b1de6fb9h, 037d1e673h, 04c83cfe9h, 0bed46a35h, 0e349aa55h, 03bd9e271h, 007f1f67bh, 00f0a058ch
	dd	031d5e472h, 0171a0d88h, 00efff1f6h, 0fca8542ah, 084f87c3eh, 0d965bc5eh, 0d29c4e27h, 089058c46h
	dd	02830180ch, 04389ca65h, 06dbdd068h, 05b99c261h, 00a0c0603h, 0bc239fc1h, 0ef41ae57h, 0ce7fb1d6h
	dd	0ec43afd9h, 0cd7db058h, 0ea47add8h, 04985cc66h, 0c87bb3d7h, 09ce8743ah, 08a078dc8h, 088f0783ch
	dd	026cfe9fah, 053623196h, 0f5a653a7h, 0775a2d98h, 05297c5ech, 0b7da6db8h, 0a83b93c7h, 0c38241aeh
	dd	06bb9d269h, 0a731964bh, 0dd964babh, 0d19e4fa9h, 04f81ce67h, 03c28140ah, 08f018e47h, 016eff9f2h
	dd	099ee77b5h, 0cc884422h, 064b3d7e5h, 05e9fc1eeh, 0a3c261beh, 0faac562bh, 0213e1f81h, 06c482412h
	dd	02d361b83h, 05a6c361bh, 024381c0eh, 0ca8c4623h, 004f3f7f5h, 083098a45h, 0c6844221h, 09e1f81ceh
	dd	0ab399249h, 0e8b0582ch, 02cc3eff9h, 06ebfd1e6h, 093e271b6h, 0f0a05028h, 0725c2e17h, 02b321982h
	dd	05c68341ah, 01d160b8bh, 03edfe1feh, 01b12098ah, 036241209h, 08c038fc9h, 035261387h, 0b9259c4eh
	dd	07ca3dfe1h, 0e4b85c2eh, 062b7d5e4h, 07aa7dde0h, 0408bcbebh, 0477a3d90h, 0ffaa55a4h, 044783c1eh
	dd	0392e1785h, 05d9dc060h, 000000000h, 0de944a25h, 002f7f5f4h, 01ce3fff1h, 05f6a3594h, 03a2c160bh
	dd	068bbd3e7h, 023c9ea75h, 0589bc3efh, 0b8d06834h, 0a6c46231h, 0c277b5d4h, 0da67bdd0h, 033221186h
	dd	019e5fc7eh, 0c98e47adh, 034d3e7fdh, 0f6a45229h, 0a0c06030h, 09aec763bh, 06546239fh, 02ac7edf8h
	dd	0ae3f91c6h, 06a4c2613h, 014180c06h, 01e140a05h, 0a43397c5h, 066442211h, 02fc1ee77h, 015edf87ch
	dd	001f5f47ah, 00dfdf078h, 0b4d86c36h, 04870381ch, 096e47239h, 0cb79b259h, 050603018h, 0e945ac56h
	dd	08df67bb3h, 087fa7db0h, 0d8904824h, 0c0804020h, 08bf279b2h, 04b723992h, 0edb65ba3h, 0ba279dc0h
	dd	0850d8844h, 05195c462h, 060402010h, 09fea75b4h, 03f2a1584h, 097118643h, 04d763b93h, 0b62f99c2h
	dd	0a135944ah, 0a9ce67bdh, 00506038fh, 0eeb45a2dh, 0afca65bch, 06f4a259ch, 061b5d46ah, 09d1d8040h
	dd	0981b83cfh, 0ebb259a2h, 0273a1d80h, 0bf219e4fh, 0427c3e1fh, 0860f89cah, 0db9249aah, 091158442h

T4	dd	0babababah, 054545454h, 02f2f2f2fh, 074747474h, 053535353h, 0d3d3d3d3h, 0d2d2d2d2h, 04d4d4d4dh
	dd	050505050h, 0acacacach, 08d8d8d8dh, 0bfbfbfbfh, 070707070h, 052525252h, 09a9a9a9ah, 04c4c4c4ch
	dd	0eaeaeaeah, 0d5d5d5d5h, 097979797h, 0d1d1d1d1h, 033333333h, 051515151h, 05b5b5b5bh, 0a6a6a6a6h
	dd	0dedededeh, 048484848h, 0a8a8a8a8h, 099999999h, 0dbdbdbdbh, 032323232h, 0b7b7b7b7h, 0fcfcfcfch
	dd	0e3e3e3e3h, 09e9e9e9eh, 091919191h, 09b9b9b9bh, 0e2e2e2e2h, 0bbbbbbbbh, 041414141h, 06e6e6e6eh
	dd	0a5a5a5a5h, 0cbcbcbcbh, 06b6b6b6bh, 095959595h, 0a1a1a1a1h, 0f3f3f3f3h, 0b1b1b1b1h, 002020202h
	dd	0cccccccch, 0c4c4c4c4h, 01d1d1d1dh, 014141414h, 0c3c3c3c3h, 063636363h, 0dadadadah, 05d5d5d5dh
	dd	05f5f5f5fh, 0dcdcdcdch, 07d7d7d7dh, 0cdcdcdcdh, 07f7f7f7fh, 05a5a5a5ah, 06c6c6c6ch, 05c5c5c5ch
	dd	0f7f7f7f7h, 026262626h, 0ffffffffh, 0ededededh, 0e8e8e8e8h, 09d9d9d9dh, 06f6f6f6fh, 08e8e8e8eh
	dd	019191919h, 0a0a0a0a0h, 0f0f0f0f0h, 089898989h, 00f0f0f0fh, 007070707h, 0afafafafh, 0fbfbfbfbh
	dd	008080808h, 015151515h, 00d0d0d0dh, 004040404h, 001010101h, 064646464h, 0dfdfdfdfh, 076767676h
	dd	079797979h, 0ddddddddh, 03d3d3d3dh, 016161616h, 03f3f3f3fh, 037373737h, 06d6d6d6dh, 038383838h
	dd	0b9b9b9b9h, 073737373h, 0e9e9e9e9h, 035353535h, 055555555h, 071717171h, 07b7b7b7bh, 08c8c8c8ch
	dd	072727272h, 088888888h, 0f6f6f6f6h, 02a2a2a2ah, 03e3e3e3eh, 05e5e5e5eh, 027272727h, 046464646h
	dd	00c0c0c0ch, 065656565h, 068686868h, 061616161h, 003030303h, 0c1c1c1c1h, 057575757h, 0d6d6d6d6h
	dd	0d9d9d9d9h, 058585858h, 0d8d8d8d8h, 066666666h, 0d7d7d7d7h, 03a3a3a3ah, 0c8c8c8c8h, 03c3c3c3ch
	dd	0fafafafah, 096969696h, 0a7a7a7a7h, 098989898h, 0ecececech, 0b8b8b8b8h, 0c7c7c7c7h, 0aeaeaeaeh
	dd	069696969h, 04b4b4b4bh, 0ababababh, 0a9a9a9a9h, 067676767h, 00a0a0a0ah, 047474747h, 0f2f2f2f2h
	dd	0b5b5b5b5h, 022222222h, 0e5e5e5e5h, 0eeeeeeeeh, 0bebebebeh, 02b2b2b2bh, 081818181h, 012121212h
	dd	083838383h, 01b1b1b1bh, 00e0e0e0eh, 023232323h, 0f5f5f5f5h, 045454545h, 021212121h, 0cecececeh
	dd	049494949h, 02c2c2c2ch, 0f9f9f9f9h, 0e6e6e6e6h, 0b6b6b6b6h, 028282828h, 017171717h, 082828282h
	dd	01a1a1a1ah, 08b8b8b8bh, 0fefefefeh, 08a8a8a8ah, 009090909h, 0c9c9c9c9h, 087878787h, 04e4e4e4eh
	dd	0e1e1e1e1h, 02e2e2e2eh, 0e4e4e4e4h, 0e0e0e0e0h, 0ebebebebh, 090909090h, 0a4a4a4a4h, 01e1e1e1eh
	dd	085858585h, 060606060h, 000000000h, 025252525h, 0f4f4f4f4h, 0f1f1f1f1h, 094949494h, 00b0b0b0bh
	dd	0e7e7e7e7h, 075757575h, 0efefefefh, 034343434h, 031313131h, 0d4d4d4d4h, 0d0d0d0d0h, 086868686h
	dd	07e7e7e7eh, 0adadadadh, 0fdfdfdfdh, 029292929h, 030303030h, 03b3b3b3bh, 09f9f9f9fh, 0f8f8f8f8h
	dd	0c6c6c6c6h, 013131313h, 006060606h, 005050505h, 0c5c5c5c5h, 011111111h, 077777777h, 07c7c7c7ch
	dd	07a7a7a7ah, 078787878h, 036363636h, 01c1c1c1ch, 039393939h, 059595959h, 018181818h, 056565656h
	dd	0b3b3b3b3h, 0b0b0b0b0h, 024242424h, 020202020h, 0b2b2b2b2h, 092929292h, 0a3a3a3a3h, 0c0c0c0c0h
	dd	044444444h, 062626262h, 010101010h, 0b4b4b4b4h, 084848484h, 043434343h, 093939393h, 0c2c2c2c2h
	dd	04a4a4a4ah, 0bdbdbdbdh, 08f8f8f8fh, 02d2d2d2dh, 0bcbcbcbch, 09c9c9c9ch, 06a6a6a6ah, 040404040h
	dd	0cfcfcfcfh, 0a2a2a2a2h, 080808080h, 04f4f4f4fh, 01f1f1f1fh, 0cacacacah, 0aaaaaaaah, 042424242h

T5	dd	000000000h, 001020608h, 002040c10h, 003060a18h, 004081820h, 0050a1e28h, 0060c1430h, 0070e1238h
	dd	008103040h, 009123648h, 00a143c50h, 00b163a58h, 00c182860h, 00d1a2e68h, 00e1c2470h, 00f1e2278h
	dd	010206080h, 011226688h, 012246c90h, 013266a98h, 0142878a0h, 0152a7ea8h, 0162c74b0h, 0172e72b8h
	dd	0183050c0h, 0193256c8h, 01a345cd0h, 01b365ad8h, 01c3848e0h, 01d3a4ee8h, 01e3c44f0h, 01f3e42f8h
	dd	02040c01dh, 02142c615h, 02244cc0dh, 02346ca05h, 02448d83dh, 0254ade35h, 0264cd42dh, 0274ed225h
	dd	02850f05dh, 02952f655h, 02a54fc4dh, 02b56fa45h, 02c58e87dh, 02d5aee75h, 02e5ce46dh, 02f5ee265h
	dd	03060a09dh, 03162a695h, 03264ac8dh, 03366aa85h, 03468b8bdh, 0356abeb5h, 0366cb4adh, 0376eb2a5h
	dd	0387090ddh, 0397296d5h, 03a749ccdh, 03b769ac5h, 03c7888fdh, 03d7a8ef5h, 03e7c84edh, 03f7e82e5h
	dd	040809d3ah, 041829b32h, 04284912ah, 043869722h, 04488851ah, 0458a8312h, 0468c890ah, 0478e8f02h
	dd	04890ad7ah, 04992ab72h, 04a94a16ah, 04b96a762h, 04c98b55ah, 04d9ab352h, 04e9cb94ah, 04f9ebf42h
	dd	050a0fdbah, 051a2fbb2h, 052a4f1aah, 053a6f7a2h, 054a8e59ah, 055aae392h, 056ace98ah, 057aeef82h
	dd	058b0cdfah, 059b2cbf2h, 05ab4c1eah, 05bb6c7e2h, 05cb8d5dah, 05dbad3d2h, 05ebcd9cah, 05fbedfc2h
	dd	060c05d27h, 061c25b2fh, 062c45137h, 063c6573fh, 064c84507h, 065ca430fh, 066cc4917h, 067ce4f1fh
	dd	068d06d67h, 069d26b6fh, 06ad46177h, 06bd6677fh, 06cd87547h, 06dda734fh, 06edc7957h, 06fde7f5fh
	dd	070e03da7h, 071e23bafh, 072e431b7h, 073e637bfh, 074e82587h, 075ea238fh, 076ec2997h, 077ee2f9fh
	dd	078f00de7h, 079f20befh, 07af401f7h, 07bf607ffh, 07cf815c7h, 07dfa13cfh, 07efc19d7h, 07ffe1fdfh
	dd	0801d2774h, 0811f217ch, 082192b64h, 0831b2d6ch, 084153f54h, 08517395ch, 086113344h, 08713354ch
	dd	0880d1734h, 0890f113ch, 08a091b24h, 08b0b1d2ch, 08c050f14h, 08d07091ch, 08e010304h, 08f03050ch
	dd	0903d47f4h, 0913f41fch, 092394be4h, 0933b4dech, 094355fd4h, 0953759dch, 0963153c4h, 0973355cch
	dd	0982d77b4h, 0992f71bch, 09a297ba4h, 09b2b7dach, 09c256f94h, 09d27699ch, 09e216384h, 09f23658ch
	dd	0a05de769h, 0a15fe161h, 0a259eb79h, 0a35bed71h, 0a455ff49h, 0a557f941h, 0a651f359h, 0a753f551h
	dd	0a84dd729h, 0a94fd121h, 0aa49db39h, 0ab4bdd31h, 0ac45cf09h, 0ad47c901h, 0ae41c319h, 0af43c511h
	dd	0b07d87e9h, 0b17f81e1h, 0b2798bf9h, 0b37b8df1h, 0b4759fc9h, 0b57799c1h, 0b67193d9h, 0b77395d1h
	dd	0b86db7a9h, 0b96fb1a1h, 0ba69bbb9h, 0bb6bbdb1h, 0bc65af89h, 0bd67a981h, 0be61a399h, 0bf63a591h
	dd	0c09dba4eh, 0c19fbc46h, 0c299b65eh, 0c39bb056h, 0c495a26eh, 0c597a466h, 0c691ae7eh, 0c793a876h
	dd	0c88d8a0eh, 0c98f8c06h, 0ca89861eh, 0cb8b8016h, 0cc85922eh, 0cd879426h, 0ce819e3eh, 0cf839836h
	dd	0d0bddaceh, 0d1bfdcc6h, 0d2b9d6deh, 0d3bbd0d6h, 0d4b5c2eeh, 0d5b7c4e6h, 0d6b1cefeh, 0d7b3c8f6h
	dd	0d8adea8eh, 0d9afec86h, 0daa9e69eh, 0dbabe096h, 0dca5f2aeh, 0dda7f4a6h, 0dea1febeh, 0dfa3f8b6h
	dd	0e0dd7a53h, 0e1df7c5bh, 0e2d97643h, 0e3db704bh, 0e4d56273h, 0e5d7647bh, 0e6d16e63h, 0e7d3686bh
	dd	0e8cd4a13h, 0e9cf4c1bh, 0eac94603h, 0ebcb400bh, 0ecc55233h, 0edc7543bh, 0eec15e23h, 0efc3582bh
	dd	0f0fd1ad3h, 0f1ff1cdbh, 0f2f916c3h, 0f3fb10cbh, 0f4f502f3h, 0f5f704fbh, 0f6f10ee3h, 0f7f308ebh
	dd	0f8ed2a93h, 0f9ef2c9bh, 0fae92683h, 0fbeb208bh, 0fce532b3h, 0fde734bbh, 0fee13ea3h, 0ffe338abh

comment %			reversed order needed for this implementation !
rc	dd	0ba542f74h, 053d3d24dh, 050ac8dbfh, 070529a4ch, 0ead597d1h, 033515ba6h, 0de48a899h, 0db32b7fch
	dd	0e39e919bh, 0e2bb416eh, 0a5cb6b95h, 0a1f3b102h, 0ccc41d14h, 0c363da5dh, 05fdc7dcdh, 07f5a6c5ch
	dd	0f726ffedh, 0e89d6f8eh, 019a0f089h
%

IF	R eq 12
rc	dd	0a1f3b102h, 0a5cb6b95h, 0e2bb416eh, 0e39e919bh, 0db32b7fch, 0de48a899h, 033515ba6h, 0ead597d1h
	dd	070529a4ch, 050ac8dbfh, 053d3d24dh, 0ba542f74h

ELSEIF	R eq 13
rc	dd	0ccc41d14h, 0a1f3b102h,	0a5cb6b95h, 0e2bb416eh, 0e39e919bh, 0db32b7fch, 0de48a899h, 033515ba6h
	dd	0ead597d1h, 070529a4ch, 050ac8dbfh, 053d3d24dh, 0ba542f74h

ELSEIF	R eq 14
rc	dd	0c363da5dh, 0ccc41d14h, 0a1f3b102h, 0a5cb6b95h, 0e2bb416eh, 0e39e919bh, 0db32b7fch, 0de48a899h
	dd	033515ba6h, 0ead597d1h, 070529a4ch, 050ac8dbfh, 053d3d24dh, 0ba542f74h

ELSEIF	R eq 15
rc	dd	05fdc7dcdh, 0c363da5dh, 0ccc41d14h, 0a1f3b102h, 0a5cb6b95h, 0e2bb416eh, 0e39e919bh, 0db32b7fch
	dd	0de48a899h, 033515ba6h, 0ead597d1h, 070529a4ch, 050ac8dbfh, 053d3d24dh, 0ba542f74h

ELSEIF	R eq 16
rc	dd	07f5a6c5ch, 05fdc7dcdh, 0c363da5dh, 0ccc41d14h, 0a1f3b102h, 0a5cb6b95h, 0e2bb416eh, 0e39e919bh
	dd	0db32b7fch, 0de48a899h, 033515ba6h, 0ead597d1h, 070529a4ch, 050ac8dbfh, 053d3d24dh, 0ba542f74h

ELSEIF	R eq 17
rc	dd	0f726ffedh, 07f5a6c5ch, 05fdc7dcdh, 0c363da5dh, 0ccc41d14h, 0a1f3b102h, 0a5cb6b95h, 0e2bb416eh
	dd	0e39e919bh, 0db32b7fch, 0de48a899h, 033515ba6h, 0ead597d1h, 070529a4ch, 050ac8dbfh, 053d3d24dh
	dd	0ba542f74h

ELSEIF	R eq 18
rc	dd	0e89d6f8eh, 0f726ffedh, 07f5a6c5ch, 05fdc7dcdh, 0c363da5dh, 0ccc41d14h, 0a1f3b102h, 0a5cb6b95h
	dd	0e2bb416eh, 0e39e919bh, 0db32b7fch, 0de48a899h, 033515ba6h, 0ead597d1h, 070529a4ch, 050ac8dbfh
	dd	053d3d24dh, 0ba542f74h
ENDIF

ELSEIF	ANUBIS_VER	eq	1

T0	dd	0a753a6f5h, 0d3bb6bd0h, 0e6d1bf6eh, 071e2d93bh, 0d0bd67dah, 0ac458acfh, 04d9a29b3h, 079f2f90bh 
	dd	03a74e89ch, 0c98f038ch, 0913f7e41h, 0fce5d732h, 01e3c7844h, 0478e018fh, 054a84de5h, 0bd67cea9h 
	dd	08c050a0fh, 0a557aef9h, 07af4f501h, 0fbebcb20h, 063c69157h, 0b86ddab7h, 0dda753f4h, 0d4b577c2h 
	dd	0e5d7b364h, 0b37bf68dh, 0c59733a4h, 0be61c2a3h, 0a94f9ed1h, 0880d1a17h, 00c183028h, 0a259b2ebh 
	dd	03972e496h, 0dfa35bf8h, 02952a4f6h, 0daa94fe6h, 02b56acfah, 0a84d9ad7h, 0cb8b0b80h, 04c982db5h 
	dd	04b9631a7h, 0224488cch, 0aa4992dbh, 0244890d8h, 04182199bh, 070e0dd3dh, 0a651a2f3h, 0f9efc32ch 
	dd	05ab475c1h, 0e2d9af76h, 0b07dfa87h, 0366cd8b4h, 07dfae913h, 0e4d5b762h, 03366ccaah, 0ffe3db38h 
	dd	060c09d5dh, 0204080c0h, 008102030h, 08b0b161dh, 05ebc65d9h, 0ab4b96ddh, 07ffee11fh, 078f0fd0dh 
	dd	07cf8ed15h, 02c58b0e8h, 057ae41efh, 0d2b96fd6h, 0dca557f2h, 06ddaa973h, 07efce519h, 00d1a342eh 
	dd	053a651f7h, 094356a5fh, 0c39b2bb0h, 02850a0f0h, 0274e9cd2h, 0060c1814h, 05fbe61dfh, 0ad478ec9h 
	dd	067ce814fh, 05cb86dd5h, 055aa49e3h, 048903dadh, 00e1c3824h, 052a455f1h, 0eac98f46h, 042841591h 
	dd	05bb671c7h, 05dba69d3h, 03060c0a0h, 058b07dcdh, 051a259fbh, 059b279cbh, 03c78f088h, 04e9c25b9h 
	dd	03870e090h, 08a09121bh, 072e4d531h, 014285078h, 0e7d3bb68h, 0c6913faeh, 0dea15ffeh, 050a05dfdh 
	dd	08e010203h, 09239724bh, 0d1bf63dch, 077eec12fh, 0933b764dh, 0458a0983h, 09a29527bh, 0ce811f9eh 
	dd	02d5ab4eeh, 003060c0ah, 062c49551h, 0b671e293h, 0b96fdeb1h, 0bf63c6a5h, 096316253h, 06bd6b167h 
	dd	03f7efc82h, 0070e1c12h, 01224486ch, 0ae4182c3h, 040801d9dh, 03468d0b8h, 0468c0589h, 03e7cf884h 
	dd	0dbab4be0h, 0cf831b98h, 0ecc59752h, 0cc851792h, 0c19f23bch, 0a15fbee1h, 0c09d27bah, 0d6b17fceh 
	dd	01d3a744eh, 0f4f5f702h, 061c2995bh, 03b76ec9ah, 010204060h, 0d8ad47eah, 068d0bd6dh, 0a05dbae7h 
	dd	0b17ffe81h, 00a14283ch, 069d2b96bh, 06cd8ad75h, 0499239abh, 0fae9cf26h, 076ecc529h, 0c49537a2h 
	dd	09e214263h, 09b2b567dh, 06edca579h, 0992f5e71h, 0c2992fb6h, 0b773e695h, 0982d5a77h, 0bc65caafh 
	dd	08f030605h, 085172e39h, 01f3e7c42h, 0b475ea9fh, 0f8edc72ah, 011224466h, 02e5cb8e4h, 000000000h 
	dd	0254a94deh, 01c387048h, 02a54a8fch, 03d7af48eh, 0050a141eh, 04f9e21bfh, 07bf6f107h, 0b279f28bh 
	dd	03264c8ach, 0903d7a47h, 0af4386c5h, 019326456h, 0a35bb6edh, 0f7f3fb08h, 073e6d137h, 09d274e69h 
	dd	0152a547eh, 074e8cd25h, 0eec19f5eh, 0ca890f86h, 09f234665h, 00f1e3c22h, 01b366c5ah, 075eac923h 
	dd	086112233h, 084152a3fh, 09c254a6fh, 04a9435a1h, 097336655h, 01a34685ch, 065ca8943h, 0f6f1ff0eh 
	dd	0edc79354h, 009122436h, 0bb6bd6bdh, 0264c98d4h, 0831b362dh, 0ebcb8b40h, 06fdea17fh, 0811f3e21h 
	dd	004081018h, 06ad4b561h, 043861197h, 001020406h, 0172e5c72h, 0e1dfa37ch, 087132635h, 0f5f7f304h 
	dd	08d070e09h, 0e3dbab70h, 023468ccah, 0801d3a27h, 044880d85h, 0162c5874h, 066cc8549h, 0214284c6h 
	dd	0fee1df3eh, 0d5b773c4h, 03162c4a6h, 0d9af43ech, 0356ad4beh, 018306050h, 00204080ch, 064c88d45h 
	dd	0f2f9ef16h, 0f1ffe31ch, 056ac45e9h, 0cd871394h, 08219322bh, 0c88d078ah, 0ba69d2bbh, 0f0fde71ah 
	dd	0efc39b58h, 0e9cf834ch, 0e8cd874ah, 0fde7d334h, 0890f1e11h, 0d7b37bc8h, 0c7933ba8h, 0b577ee99h 
	dd	0a455aaffh, 02f5ebce2h, 095376e59h, 013264c6ah, 00b162c3ah, 0f3fbeb10h, 0e0dda77ah, 0376edcb2h 

T1	dd	053a7f5a6h, 0bbd3d06bh, 0d1e66ebfh, 0e2713bd9h, 0bdd0da67h, 045accf8ah, 09a4db329h, 0f2790bf9h 
	dd	0743a9ce8h, 08fc98c03h, 03f91417eh, 0e5fc32d7h, 03c1e4478h, 08e478f01h, 0a854e54dh, 067bda9ceh 
	dd	0058c0f0ah, 057a5f9aeh, 0f47a01f5h, 0ebfb20cbh, 0c6635791h, 06db8b7dah, 0a7ddf453h, 0b5d4c277h 
	dd	0d7e564b3h, 07bb38df6h, 097c5a433h, 061bea3c2h, 04fa9d19eh, 00d88171ah, 0180c2830h, 059a2ebb2h 
	dd	0723996e4h, 0a3dff85bh, 05229f6a4h, 0a9dae64fh, 0562bfaach, 04da8d79ah, 08bcb800bh, 0984cb52dh 
	dd	0964ba731h, 04422cc88h, 049aadb92h, 04824d890h, 082419b19h, 0e0703dddh, 051a6f3a2h, 0eff92cc3h 
	dd	0b45ac175h, 0d9e276afh, 07db087fah, 06c36b4d8h, 0fa7d13e9h, 0d5e462b7h, 06633aacch, 0e3ff38dbh 
	dd	0c0605d9dh, 04020c080h, 010083020h, 00b8b1d16h, 0bc5ed965h, 04babdd96h, 0fe7f1fe1h, 0f0780dfdh 
	dd	0f87c15edh, 0582ce8b0h, 0ae57ef41h, 0b9d2d66fh, 0a5dcf257h, 0da6d73a9h, 0fc7e19e5h, 01a0d2e34h 
	dd	0a653f751h, 035945f6ah, 09bc3b02bh, 05028f0a0h, 04e27d29ch, 00c061418h, 0be5fdf61h, 047adc98eh 
	dd	0ce674f81h, 0b85cd56dh, 0aa55e349h, 09048ad3dh, 01c0e2438h, 0a452f155h, 0c9ea468fh, 084429115h 
	dd	0b65bc771h, 0ba5dd369h, 06030a0c0h, 0b058cd7dh, 0a251fb59h, 0b259cb79h, 0783c88f0h, 09c4eb925h 
	dd	0703890e0h, 0098a1b12h, 0e47231d5h, 028147850h, 0d3e768bbh, 091c6ae3fh, 0a1defe5fh, 0a050fd5dh 
	dd	0018e0302h, 039924b72h, 0bfd1dc63h, 0ee772fc1h, 03b934d76h, 08a458309h, 0299a7b52h, 081ce9e1fh 
	dd	05a2deeb4h, 006030a0ch, 0c4625195h, 071b693e2h, 06fb9b1deh, 063bfa5c6h, 031965362h, 0d66b67b1h 
	dd	07e3f82fch, 00e07121ch, 024126c48h, 041aec382h, 080409d1dh, 06834b8d0h, 08c468905h, 07c3e84f8h 
	dd	0abdbe04bh, 083cf981bh, 0c5ec5297h, 085cc9217h, 09fc1bc23h, 05fa1e1beh, 09dc0ba27h, 0b1d6ce7fh 
	dd	03a1d4e74h, 0f5f402f7h, 0c2615b99h, 0763b9aech, 020106040h, 0add8ea47h, 0d0686dbdh, 05da0e7bah 
	dd	07fb181feh, 0140a3c28h, 0d2696bb9h, 0d86c75adh, 09249ab39h, 0e9fa26cfh, 0ec7629c5h, 095c4a237h 
	dd	0219e6342h, 02b9b7d56h, 0dc6e79a5h, 02f99715eh, 099c2b62fh, 073b795e6h, 02d98775ah, 065bcafcah 
	dd	0038f0506h, 01785392eh, 03e1f427ch, 075b49feah, 0edf82ac7h, 022116644h, 05c2ee4b8h, 000000000h 
	dd	04a25de94h, 0381c4870h, 0542afca8h, 07a3d8ef4h, 00a051e14h, 09e4fbf21h, 0f67b07f1h, 079b28bf2h 
	dd	06432acc8h, 03d90477ah, 043afc586h, 032195664h, 05ba3edb6h, 0f3f708fbh, 0e67337d1h, 0279d694eh 
	dd	02a157e54h, 0e87425cdh, 0c1ee5e9fh, 089ca860fh, 0239f6546h, 01e0f223ch, 0361b5a6ch, 0ea7523c9h 
	dd	011863322h, 015843f2ah, 0259c6f4ah, 0944aa135h, 033975566h, 0341a5c68h, 0ca654389h, 0f1f60effh 
	dd	0c7ed5493h, 012093624h, 06bbbbdd6h, 04c26d498h, 01b832d36h, 0cbeb408bh, 0de6f7fa1h, 01f81213eh 
	dd	008041810h, 0d46a61b5h, 086439711h, 002010604h, 02e17725ch, 0dfe17ca3h, 013873526h, 0f7f504f3h 
	dd	0078d090eh, 0dbe370abh, 04623ca8ch, 01d80273ah, 08844850dh, 02c167458h, 0cc664985h, 04221c684h 
	dd	0e1fe3edfh, 0b7d5c473h, 06231a6c4h, 0afd9ec43h, 06a35bed4h, 030185060h, 004020c08h, 0c864458dh 
	dd	0f9f216efh, 0fff11ce3h, 0ac56e945h, 087cd9413h, 019822b32h, 08dc88a07h, 069babbd2h, 0fdf01ae7h 
	dd	0c3ef589bh, 0cfe94c83h, 0cde84a87h, 0e7fd34d3h, 00f89111eh, 0b3d7c87bh, 093c7a83bh, 077b599eeh 
	dd	055a4ffaah, 05e2fe2bch, 03795596eh, 026136a4ch, 0160b3a2ch, 0fbf310ebh, 0dde07aa7h, 06e37b2dch 

T2	dd	0a6f5a753h, 06bd0d3bbh, 0bf6ee6d1h, 0d93b71e2h, 067dad0bdh, 08acfac45h, 029b34d9ah, 0f90b79f2h 
	dd	0e89c3a74h, 0038cc98fh, 07e41913fh, 0d732fce5h, 078441e3ch, 0018f478eh, 04de554a8h, 0cea9bd67h 
	dd	00a0f8c05h, 0aef9a557h, 0f5017af4h, 0cb20fbebh, 0915763c6h, 0dab7b86dh, 053f4dda7h, 077c2d4b5h 
	dd	0b364e5d7h, 0f68db37bh, 033a4c597h, 0c2a3be61h, 09ed1a94fh, 01a17880dh, 030280c18h, 0b2eba259h 
	dd	0e4963972h, 05bf8dfa3h, 0a4f62952h, 04fe6daa9h, 0acfa2b56h, 09ad7a84dh, 00b80cb8bh, 02db54c98h 
	dd	031a74b96h, 088cc2244h, 092dbaa49h, 090d82448h, 0199b4182h, 0dd3d70e0h, 0a2f3a651h, 0c32cf9efh 
	dd	075c15ab4h, 0af76e2d9h, 0fa87b07dh, 0d8b4366ch, 0e9137dfah, 0b762e4d5h, 0ccaa3366h, 0db38ffe3h 
	dd	09d5d60c0h, 080c02040h, 020300810h, 0161d8b0bh, 065d95ebch, 096ddab4bh, 0e11f7ffeh, 0fd0d78f0h 
	dd	0ed157cf8h, 0b0e82c58h, 041ef57aeh, 06fd6d2b9h, 057f2dca5h, 0a9736ddah, 0e5197efch, 0342e0d1ah 
	dd	051f753a6h, 06a5f9435h, 02bb0c39bh, 0a0f02850h, 09cd2274eh, 01814060ch, 061df5fbeh, 08ec9ad47h 
	dd	0814f67ceh, 06dd55cb8h, 049e355aah, 03dad4890h, 038240e1ch, 055f152a4h, 08f46eac9h, 015914284h 
	dd	071c75bb6h, 069d35dbah, 0c0a03060h, 07dcd58b0h, 059fb51a2h, 079cb59b2h, 0f0883c78h, 025b94e9ch 
	dd	0e0903870h, 0121b8a09h, 0d53172e4h, 050781428h, 0bb68e7d3h, 03faec691h, 05ffedea1h, 05dfd50a0h 
	dd	002038e01h, 0724b9239h, 063dcd1bfh, 0c12f77eeh, 0764d933bh, 00983458ah, 0527b9a29h, 01f9ece81h 
	dd	0b4ee2d5ah, 00c0a0306h, 0955162c4h, 0e293b671h, 0deb1b96fh, 0c6a5bf63h, 062539631h, 0b1676bd6h 
	dd	0fc823f7eh, 01c12070eh, 0486c1224h, 082c3ae41h, 01d9d4080h, 0d0b83468h, 00589468ch, 0f8843e7ch 
	dd	04be0dbabh, 01b98cf83h, 09752ecc5h, 01792cc85h, 023bcc19fh, 0bee1a15fh, 027bac09dh, 07fced6b1h 
	dd	0744e1d3ah, 0f702f4f5h, 0995b61c2h, 0ec9a3b76h, 040601020h, 047ead8adh, 0bd6d68d0h, 0bae7a05dh 
	dd	0fe81b17fh, 0283c0a14h, 0b96b69d2h, 0ad756cd8h, 039ab4992h, 0cf26fae9h, 0c52976ech, 037a2c495h 
	dd	042639e21h, 0567d9b2bh, 0a5796edch, 05e71992fh, 02fb6c299h, 0e695b773h, 05a77982dh, 0caafbc65h 
	dd	006058f03h, 02e398517h, 07c421f3eh, 0ea9fb475h, 0c72af8edh, 044661122h, 0b8e42e5ch, 000000000h 
	dd	094de254ah, 070481c38h, 0a8fc2a54h, 0f48e3d7ah, 0141e050ah, 021bf4f9eh, 0f1077bf6h, 0f28bb279h 
	dd	0c8ac3264h, 07a47903dh, 086c5af43h, 064561932h, 0b6eda35bh, 0fb08f7f3h, 0d13773e6h, 04e699d27h 
	dd	0547e152ah, 0cd2574e8h, 09f5eeec1h, 00f86ca89h, 046659f23h, 03c220f1eh, 06c5a1b36h, 0c92375eah 
	dd	022338611h, 02a3f8415h, 04a6f9c25h, 035a14a94h, 066559733h, 0685c1a34h, 0894365cah, 0ff0ef6f1h 
	dd	09354edc7h, 024360912h, 0d6bdbb6bh, 098d4264ch, 0362d831bh, 08b40ebcbh, 0a17f6fdeh, 03e21811fh 
	dd	010180408h, 0b5616ad4h, 011974386h, 004060102h, 05c72172eh, 0a37ce1dfh, 026358713h, 0f304f5f7h 
	dd	00e098d07h, 0ab70e3dbh, 08cca2346h, 03a27801dh, 00d854488h, 05874162ch, 0854966cch, 084c62142h 
	dd	0df3efee1h, 073c4d5b7h, 0c4a63162h, 043ecd9afh, 0d4be356ah, 060501830h, 0080c0204h, 08d4564c8h 
	dd	0ef16f2f9h, 0e31cf1ffh, 045e956ach, 01394cd87h, 0322b8219h, 0078ac88dh, 0d2bbba69h, 0e71af0fdh 
	dd	09b58efc3h, 0834ce9cfh, 0874ae8cdh, 0d334fde7h, 01e11890fh, 07bc8d7b3h, 03ba8c793h, 0ee99b577h 
	dd	0aaffa455h, 0bce22f5eh, 06e599537h, 04c6a1326h, 02c3a0b16h, 0eb10f3fbh, 0a77ae0ddh, 0dcb2376eh 

T3	dd	0f5a653a7h, 0d06bbbd3h, 06ebfd1e6h, 03bd9e271h, 0da67bdd0h, 0cf8a45ach, 0b3299a4dh, 00bf9f279h 
	dd	09ce8743ah, 08c038fc9h, 0417e3f91h, 032d7e5fch, 044783c1eh, 08f018e47h, 0e54da854h, 0a9ce67bdh 
	dd	00f0a058ch, 0f9ae57a5h, 001f5f47ah, 020cbebfbh, 05791c663h, 0b7da6db8h, 0f453a7ddh, 0c277b5d4h 
	dd	064b3d7e5h, 08df67bb3h, 0a43397c5h, 0a3c261beh, 0d19e4fa9h, 0171a0d88h, 02830180ch, 0ebb259a2h 
	dd	096e47239h, 0f85ba3dfh, 0f6a45229h, 0e64fa9dah, 0faac562bh, 0d79a4da8h, 0800b8bcbh, 0b52d984ch 
	dd	0a731964bh, 0cc884422h, 0db9249aah, 0d8904824h, 09b198241h, 03ddde070h, 0f3a251a6h, 02cc3eff9h 
	dd	0c175b45ah, 076afd9e2h, 087fa7db0h, 0b4d86c36h, 013e9fa7dh, 062b7d5e4h, 0aacc6633h, 038dbe3ffh 
	dd	05d9dc060h, 0c0804020h, 030201008h, 01d160b8bh, 0d965bc5eh, 0dd964babh, 01fe1fe7fh, 00dfdf078h 
	dd	015edf87ch, 0e8b0582ch, 0ef41ae57h, 0d66fb9d2h, 0f257a5dch, 073a9da6dh, 019e5fc7eh, 02e341a0dh 
	dd	0f751a653h, 05f6a3594h, 0b02b9bc3h, 0f0a05028h, 0d29c4e27h, 014180c06h, 0df61be5fh, 0c98e47adh 
	dd	04f81ce67h, 0d56db85ch, 0e349aa55h, 0ad3d9048h, 024381c0eh, 0f155a452h, 0468fc9eah, 091158442h 
	dd	0c771b65bh, 0d369ba5dh, 0a0c06030h, 0cd7db058h, 0fb59a251h, 0cb79b259h, 088f0783ch, 0b9259c4eh 
	dd	090e07038h, 01b12098ah, 031d5e472h, 078502814h, 068bbd3e7h, 0ae3f91c6h, 0fe5fa1deh, 0fd5da050h 
	dd	00302018eh, 04b723992h, 0dc63bfd1h, 02fc1ee77h, 04d763b93h, 083098a45h, 07b52299ah, 09e1f81ceh 
	dd	0eeb45a2dh, 00a0c0603h, 05195c462h, 093e271b6h, 0b1de6fb9h, 0a5c663bfh, 053623196h, 067b1d66bh 
	dd	082fc7e3fh, 0121c0e07h, 06c482412h, 0c38241aeh, 09d1d8040h, 0b8d06834h, 089058c46h, 084f87c3eh 
	dd	0e04babdbh, 0981b83cfh, 05297c5ech, 0921785cch, 0bc239fc1h, 0e1be5fa1h, 0ba279dc0h, 0ce7fb1d6h 
	dd	04e743a1dh, 002f7f5f4h, 05b99c261h, 09aec763bh, 060402010h, 0ea47add8h, 06dbdd068h, 0e7ba5da0h 
	dd	081fe7fb1h, 03c28140ah, 06bb9d269h, 075add86ch, 0ab399249h, 026cfe9fah, 029c5ec76h, 0a23795c4h 
	dd	06342219eh, 07d562b9bh, 079a5dc6eh, 0715e2f99h, 0b62f99c2h, 095e673b7h, 0775a2d98h, 0afca65bch 
	dd	00506038fh, 0392e1785h, 0427c3e1fh, 09fea75b4h, 02ac7edf8h, 066442211h, 0e4b85c2eh, 000000000h 
	dd	0de944a25h, 04870381ch, 0fca8542ah, 08ef47a3dh, 01e140a05h, 0bf219e4fh, 007f1f67bh, 08bf279b2h 
	dd	0acc86432h, 0477a3d90h, 0c58643afh, 056643219h, 0edb65ba3h, 008fbf3f7h, 037d1e673h, 0694e279dh 
	dd	07e542a15h, 025cde874h, 05e9fc1eeh, 0860f89cah, 06546239fh, 0223c1e0fh, 05a6c361bh, 023c9ea75h 
	dd	033221186h, 03f2a1584h, 06f4a259ch, 0a135944ah, 055663397h, 05c68341ah, 04389ca65h, 00efff1f6h 
	dd	05493c7edh, 036241209h, 0bdd66bbbh, 0d4984c26h, 02d361b83h, 0408bcbebh, 07fa1de6fh, 0213e1f81h 
	dd	018100804h, 061b5d46ah, 097118643h, 006040201h, 0725c2e17h, 07ca3dfe1h, 035261387h, 004f3f7f5h 
	dd	0090e078dh, 070abdbe3h, 0ca8c4623h, 0273a1d80h, 0850d8844h, 074582c16h, 04985cc66h, 0c6844221h 
	dd	03edfe1feh, 0c473b7d5h, 0a6c46231h, 0ec43afd9h, 0bed46a35h, 050603018h, 00c080402h, 0458dc864h 
	dd	016eff9f2h, 01ce3fff1h, 0e945ac56h, 0941387cdh, 02b321982h, 08a078dc8h, 0bbd269bah, 01ae7fdf0h 
	dd	0589bc3efh, 04c83cfe9h, 04a87cde8h, 034d3e7fdh, 0111e0f89h, 0c87bb3d7h, 0a83b93c7h, 099ee77b5h 
	dd	0ffaa55a4h, 0e2bc5e2fh, 0596e3795h, 06a4c2613h, 03a2c160bh, 010ebfbf3h, 07aa7dde0h, 0b2dc6e37h 

T4	dd	0a7a7a7a7h, 0d3d3d3d3h, 0e6e6e6e6h, 071717171h, 0d0d0d0d0h, 0acacacach, 04d4d4d4dh, 079797979h 
	dd	03a3a3a3ah, 0c9c9c9c9h, 091919191h, 0fcfcfcfch, 01e1e1e1eh, 047474747h, 054545454h, 0bdbdbdbdh 
	dd	08c8c8c8ch, 0a5a5a5a5h, 07a7a7a7ah, 0fbfbfbfbh, 063636363h, 0b8b8b8b8h, 0ddddddddh, 0d4d4d4d4h 
	dd	0e5e5e5e5h, 0b3b3b3b3h, 0c5c5c5c5h, 0bebebebeh, 0a9a9a9a9h, 088888888h, 00c0c0c0ch, 0a2a2a2a2h 
	dd	039393939h, 0dfdfdfdfh, 029292929h, 0dadadadah, 02b2b2b2bh, 0a8a8a8a8h, 0cbcbcbcbh, 04c4c4c4ch 
	dd	04b4b4b4bh, 022222222h, 0aaaaaaaah, 024242424h, 041414141h, 070707070h, 0a6a6a6a6h, 0f9f9f9f9h 
	dd	05a5a5a5ah, 0e2e2e2e2h, 0b0b0b0b0h, 036363636h, 07d7d7d7dh, 0e4e4e4e4h, 033333333h, 0ffffffffh 
	dd	060606060h, 020202020h, 008080808h, 08b8b8b8bh, 05e5e5e5eh, 0ababababh, 07f7f7f7fh, 078787878h 
	dd	07c7c7c7ch, 02c2c2c2ch, 057575757h, 0d2d2d2d2h, 0dcdcdcdch, 06d6d6d6dh, 07e7e7e7eh, 00d0d0d0dh 
	dd	053535353h, 094949494h, 0c3c3c3c3h, 028282828h, 027272727h, 006060606h, 05f5f5f5fh, 0adadadadh 
	dd	067676767h, 05c5c5c5ch, 055555555h, 048484848h, 00e0e0e0eh, 052525252h, 0eaeaeaeah, 042424242h 
	dd	05b5b5b5bh, 05d5d5d5dh, 030303030h, 058585858h, 051515151h, 059595959h, 03c3c3c3ch, 04e4e4e4eh 
	dd	038383838h, 08a8a8a8ah, 072727272h, 014141414h, 0e7e7e7e7h, 0c6c6c6c6h, 0dedededeh, 050505050h 
	dd	08e8e8e8eh, 092929292h, 0d1d1d1d1h, 077777777h, 093939393h, 045454545h, 09a9a9a9ah, 0cecececeh 
	dd	02d2d2d2dh, 003030303h, 062626262h, 0b6b6b6b6h, 0b9b9b9b9h, 0bfbfbfbfh, 096969696h, 06b6b6b6bh 
	dd	03f3f3f3fh, 007070707h, 012121212h, 0aeaeaeaeh, 040404040h, 034343434h, 046464646h, 03e3e3e3eh 
	dd	0dbdbdbdbh, 0cfcfcfcfh, 0ecececech, 0cccccccch, 0c1c1c1c1h, 0a1a1a1a1h, 0c0c0c0c0h, 0d6d6d6d6h 
	dd	01d1d1d1dh, 0f4f4f4f4h, 061616161h, 03b3b3b3bh, 010101010h, 0d8d8d8d8h, 068686868h, 0a0a0a0a0h 
	dd	0b1b1b1b1h, 00a0a0a0ah, 069696969h, 06c6c6c6ch, 049494949h, 0fafafafah, 076767676h, 0c4c4c4c4h 
	dd	09e9e9e9eh, 09b9b9b9bh, 06e6e6e6eh, 099999999h, 0c2c2c2c2h, 0b7b7b7b7h, 098989898h, 0bcbcbcbch 
	dd	08f8f8f8fh, 085858585h, 01f1f1f1fh, 0b4b4b4b4h, 0f8f8f8f8h, 011111111h, 02e2e2e2eh, 000000000h 
	dd	025252525h, 01c1c1c1ch, 02a2a2a2ah, 03d3d3d3dh, 005050505h, 04f4f4f4fh, 07b7b7b7bh, 0b2b2b2b2h 
	dd	032323232h, 090909090h, 0afafafafh, 019191919h, 0a3a3a3a3h, 0f7f7f7f7h, 073737373h, 09d9d9d9dh 
	dd	015151515h, 074747474h, 0eeeeeeeeh, 0cacacacah, 09f9f9f9fh, 00f0f0f0fh, 01b1b1b1bh, 075757575h 
	dd	086868686h, 084848484h, 09c9c9c9ch, 04a4a4a4ah, 097979797h, 01a1a1a1ah, 065656565h, 0f6f6f6f6h 
	dd	0ededededh, 009090909h, 0bbbbbbbbh, 026262626h, 083838383h, 0ebebebebh, 06f6f6f6fh, 081818181h 
	dd	004040404h, 06a6a6a6ah, 043434343h, 001010101h, 017171717h, 0e1e1e1e1h, 087878787h, 0f5f5f5f5h 
	dd	08d8d8d8dh, 0e3e3e3e3h, 023232323h, 080808080h, 044444444h, 016161616h, 066666666h, 021212121h 
	dd	0fefefefeh, 0d5d5d5d5h, 031313131h, 0d9d9d9d9h, 035353535h, 018181818h, 002020202h, 064646464h 
	dd	0f2f2f2f2h, 0f1f1f1f1h, 056565656h, 0cdcdcdcdh, 082828282h, 0c8c8c8c8h, 0babababah, 0f0f0f0f0h 
	dd	0efefefefh, 0e9e9e9e9h, 0e8e8e8e8h, 0fdfdfdfdh, 089898989h, 0d7d7d7d7h, 0c7c7c7c7h, 0b5b5b5b5h 
	dd	0a4a4a4a4h, 02f2f2f2fh, 095959595h, 013131313h, 00b0b0b0bh, 0f3f3f3f3h, 0e0e0e0e0h, 037373737h 

T5	dd	000000000h, 001020608h, 002040c10h, 003060a18h, 004081820h, 0050a1e28h, 0060c1430h, 0070e1238h 
	dd	008103040h, 009123648h, 00a143c50h, 00b163a58h, 00c182860h, 00d1a2e68h, 00e1c2470h, 00f1e2278h 
	dd	010206080h, 011226688h, 012246c90h, 013266a98h, 0142878a0h, 0152a7ea8h, 0162c74b0h, 0172e72b8h 
	dd	0183050c0h, 0193256c8h, 01a345cd0h, 01b365ad8h, 01c3848e0h, 01d3a4ee8h, 01e3c44f0h, 01f3e42f8h 
	dd	02040c01dh, 02142c615h, 02244cc0dh, 02346ca05h, 02448d83dh, 0254ade35h, 0264cd42dh, 0274ed225h 
	dd	02850f05dh, 02952f655h, 02a54fc4dh, 02b56fa45h, 02c58e87dh, 02d5aee75h, 02e5ce46dh, 02f5ee265h 
	dd	03060a09dh, 03162a695h, 03264ac8dh, 03366aa85h, 03468b8bdh, 0356abeb5h, 0366cb4adh, 0376eb2a5h 
	dd	0387090ddh, 0397296d5h, 03a749ccdh, 03b769ac5h, 03c7888fdh, 03d7a8ef5h, 03e7c84edh, 03f7e82e5h 
	dd	040809d3ah, 041829b32h, 04284912ah, 043869722h, 04488851ah, 0458a8312h, 0468c890ah, 0478e8f02h 
	dd	04890ad7ah, 04992ab72h, 04a94a16ah, 04b96a762h, 04c98b55ah, 04d9ab352h, 04e9cb94ah, 04f9ebf42h 
	dd	050a0fdbah, 051a2fbb2h, 052a4f1aah, 053a6f7a2h, 054a8e59ah, 055aae392h, 056ace98ah, 057aeef82h 
	dd	058b0cdfah, 059b2cbf2h, 05ab4c1eah, 05bb6c7e2h, 05cb8d5dah, 05dbad3d2h, 05ebcd9cah, 05fbedfc2h 
	dd	060c05d27h, 061c25b2fh, 062c45137h, 063c6573fh, 064c84507h, 065ca430fh, 066cc4917h, 067ce4f1fh 
	dd	068d06d67h, 069d26b6fh, 06ad46177h, 06bd6677fh, 06cd87547h, 06dda734fh, 06edc7957h, 06fde7f5fh 
	dd	070e03da7h, 071e23bafh, 072e431b7h, 073e637bfh, 074e82587h, 075ea238fh, 076ec2997h, 077ee2f9fh 
	dd	078f00de7h, 079f20befh, 07af401f7h, 07bf607ffh, 07cf815c7h, 07dfa13cfh, 07efc19d7h, 07ffe1fdfh 
	dd	0801d2774h, 0811f217ch, 082192b64h, 0831b2d6ch, 084153f54h, 08517395ch, 086113344h, 08713354ch 
	dd	0880d1734h, 0890f113ch, 08a091b24h, 08b0b1d2ch, 08c050f14h, 08d07091ch, 08e010304h, 08f03050ch 
	dd	0903d47f4h, 0913f41fch, 092394be4h, 0933b4dech, 094355fd4h, 0953759dch, 0963153c4h, 0973355cch 
	dd	0982d77b4h, 0992f71bch, 09a297ba4h, 09b2b7dach, 09c256f94h, 09d27699ch, 09e216384h, 09f23658ch 
	dd	0a05de769h, 0a15fe161h, 0a259eb79h, 0a35bed71h, 0a455ff49h, 0a557f941h, 0a651f359h, 0a753f551h 
	dd	0a84dd729h, 0a94fd121h, 0aa49db39h, 0ab4bdd31h, 0ac45cf09h, 0ad47c901h, 0ae41c319h, 0af43c511h 
	dd	0b07d87e9h, 0b17f81e1h, 0b2798bf9h, 0b37b8df1h, 0b4759fc9h, 0b57799c1h, 0b67193d9h, 0b77395d1h 
	dd	0b86db7a9h, 0b96fb1a1h, 0ba69bbb9h, 0bb6bbdb1h, 0bc65af89h, 0bd67a981h, 0be61a399h, 0bf63a591h 
	dd	0c09dba4eh, 0c19fbc46h, 0c299b65eh, 0c39bb056h, 0c495a26eh, 0c597a466h, 0c691ae7eh, 0c793a876h 
	dd	0c88d8a0eh, 0c98f8c06h, 0ca89861eh, 0cb8b8016h, 0cc85922eh, 0cd879426h, 0ce819e3eh, 0cf839836h 
	dd	0d0bddaceh, 0d1bfdcc6h, 0d2b9d6deh, 0d3bbd0d6h, 0d4b5c2eeh, 0d5b7c4e6h, 0d6b1cefeh, 0d7b3c8f6h 
	dd	0d8adea8eh, 0d9afec86h, 0daa9e69eh, 0dbabe096h, 0dca5f2aeh, 0dda7f4a6h, 0dea1febeh, 0dfa3f8b6h 
	dd	0e0dd7a53h, 0e1df7c5bh, 0e2d97643h, 0e3db704bh, 0e4d56273h, 0e5d7647bh, 0e6d16e63h, 0e7d3686bh 
	dd	0e8cd4a13h, 0e9cf4c1bh, 0eac94603h, 0ebcb400bh, 0ecc55233h, 0edc7543bh, 0eec15e23h, 0efc3582bh 
	dd	0f0fd1ad3h, 0f1ff1cdbh, 0f2f916c3h, 0f3fb10cbh, 0f4f502f3h, 0f5f704fbh, 0f6f10ee3h, 0f7f308ebh 
	dd	0f8ed2a93h, 0f9ef2c9bh, 0fae92683h, 0fbeb208bh, 0fce532b3h, 0fde734bbh, 0fee13ea3h, 0ffe338abh 

comment %			reversed order needed for this implementation !
rc	dd	0a7d3e671h, 0d0ac4d79h, 03ac991fch, 01e4754bdh, 08ca57afbh, 063b8ddd4h, 0e5b3c5beh, 0a9880ca2h 
	dd	039df29dah, 02ba8cb4ch, 04b22aa24h, 04170a6f9h, 05ae2b036h, 07de433ffh, 06020088bh, 05eab7f78h 
	dd	07c2c57d2h, 0dc6d7e0dh, 05394c328h 
%

IF	R eq 12
rc	dd	04170a6f9h, 04b22aa24h, 02ba8cb4ch, 039df29dah, 0a9880ca2h, 0e5b3c5beh, 063b8ddd4h, 08ca57afbh
	dd	01e4754bdh, 03ac991fch, 0d0ac4d79h, 0a7d3e671h

ELSEIF	R eq 13
rc	dd	05ae2b036h, 04170a6f9h, 04b22aa24h, 02ba8cb4ch, 039df29dah, 0a9880ca2h, 0e5b3c5beh, 063b8ddd4h
	dd	08ca57afbh, 01e4754bdh, 03ac991fch, 0d0ac4d79h, 0a7d3e671h

ELSEIF	R eq 14
rc	dd	07de433ffh, 05ae2b036h, 04170a6f9h, 04b22aa24h, 02ba8cb4ch, 039df29dah, 0a9880ca2h, 0e5b3c5beh
	dd	063b8ddd4h, 08ca57afbh, 01e4754bdh, 03ac991fch, 0d0ac4d79h, 0a7d3e671h

ELSEIF	R eq 15
rc	dd	06020088bh, 07de433ffh, 05ae2b036h, 04170a6f9h, 04b22aa24h, 02ba8cb4ch, 039df29dah, 0a9880ca2h
	dd	0e5b3c5beh, 063b8ddd4h, 08ca57afbh, 01e4754bdh, 03ac991fch, 0d0ac4d79h, 0a7d3e671h

ELSEIF	R eq 16
rc	dd	05eab7f78h, 06020088bh, 07de433ffh, 05ae2b036h, 04170a6f9h, 04b22aa24h, 02ba8cb4ch, 039df29dah
	dd	0a9880ca2h, 0e5b3c5beh, 063b8ddd4h, 08ca57afbh, 01e4754bdh, 03ac991fch, 0d0ac4d79h, 0a7d3e671h

ELSEIF	R eq 17
rc	dd	07c2c57d2h, 05eab7f78h, 06020088bh, 07de433ffh, 05ae2b036h, 04170a6f9h, 04b22aa24h, 02ba8cb4ch
	dd	039df29dah, 0a9880ca2h, 0e5b3c5beh, 063b8ddd4h, 08ca57afbh, 01e4754bdh, 03ac991fch, 0d0ac4d79h
	dd	0a7d3e671h

ELSEIF	R eq 18
rc	dd	0dc6d7e0dh, 07c2c57d2h, 05eab7f78h, 06020088bh, 07de433ffh, 05ae2b036h, 04170a6f9h, 04b22aa24h
	dd	02ba8cb4ch, 039df29dah, 0a9880ca2h, 0e5b3c5beh, 063b8ddd4h, 08ca57afbh, 01e4754bdh, 03ac991fch
	dd	0d0ac4d79h, 0a7d3e671h
ENDIF

ENDIF

.data?
_round		dd ?
_esp		dd ?
kappa		dd  N dup (?)
K_struct	db 16 dup (?)
inter		dd  N dup (?)
	; 16 ostatnich bajtow enc_key = 16 pierwszych bajtow dec_key
	; dlugosc kazdego kluczy to 16*(R+1) !
anubis_enc_key	db 16*R	dup (?)
anubis_dec_key	db 16*(R+1) dup (?)