comment	~

Algo	: Rijndael aka AES by Joan Daemen
Block	: 16 bytes
Key	: 16/24/32 bytes (128b/192b/256b)


IF	(TABLES eq DYNAMIC)
	call	Rijndael_Init
ENDIF

IF ((ACTION eq ENC_ONLY) OR (ACTION eq ALL))
	push	offset password
	call	Rijndael_SetEncryptKey

	push	offset plaintext
	push	offset ciphertext
	call	Rijndael_Encrypt
ENDIF

IF ((ACTION eq DEC_ONLY) OR (ACTION eq ALL))
	push	offset password
	call	Rijndael_SetDecryptKey
	
	push	offset ciphertext
	push	offset plaintext
	call	Rijndael_Decrypt
ENDIF

30.01.2006 WiteG (witeg@poczta.fm, www.witeg.prv.pl)

~

DYNAMIC		equ 100
STATIC		equ 101
ALL		equ 200
ENC_ONLY	equ 201
DEC_ONLY	equ 202

; ---------------------------------------------------------------------------
; You should set variables !
; ---------------------------------------------------------------------------

KEY_SIZE	equ	256		; 128, 192 or 256
ACTION		equ	ALL		; ALL, ENC_ONLY, DEC_ONLY
TABLES		equ	DYNAMIC		; DYNAMIC, STATIC

; ---------------------------------------------------------------------------




ROUND		equ 10

IF	(TABLES	eq DYNAMIC)

	.data?

	IF ((ACTION eq ENC_ONLY) OR (ACTION eq ALL))
	Te0	dd 256 dup (?)
	Te1	dd 256 dup (?)
	Te2	dd 256 dup (?)
	Te3	dd 256 dup (?)
	ENDIF
	
	IF ((ACTION eq DEC_ONLY) OR (ACTION eq ALL))
	Td0	dd 256 dup (?)
	Td1	dd 256 dup (?)
	Td2	dd 256 dup (?)
	Td3	dd 256 dup (?)
	ENDIF
	
	IF ((ACTION eq DEC_ONLY) OR (ACTION eq ALL))
	iBox	db 256 dup (?)
	ENDIF

	sBox	db 256 dup (?)
	powTab	db 256 dup (?)
	logTab	db 256 dup (?)

ELSEIF	(TABLES eq STATIC)

	.data

	IF ((ACTION eq ENC_ONLY) OR (ACTION eq ALL))
	Te0	db 0c6h,063h,063h,0a5h,0f8h,07ch,07ch,084h,0eeh,077h,077h,099h,0f6h,07bh,07bh,08dh
		db 0ffh,0f2h,0f2h,00dh,0d6h,06bh,06bh,0bdh,0deh,06fh,06fh,0b1h,091h,0c5h,0c5h,054h
		db 060h,030h,030h,050h,002h,001h,001h,003h,0ceh,067h,067h,0a9h,056h,02bh,02bh,07dh
		db 0e7h,0feh,0feh,019h,0b5h,0d7h,0d7h,062h,04dh,0abh,0abh,0e6h,0ech,076h,076h,09ah
		db 08fh,0cah,0cah,045h,01fh,082h,082h,09dh,089h,0c9h,0c9h,040h,0fah,07dh,07dh,087h
		db 0efh,0fah,0fah,015h,0b2h,059h,059h,0ebh,08eh,047h,047h,0c9h,0fbh,0f0h,0f0h,00bh
		db 041h,0adh,0adh,0ech,0b3h,0d4h,0d4h,067h,05fh,0a2h,0a2h,0fdh,045h,0afh,0afh,0eah
		db 023h,09ch,09ch,0bfh,053h,0a4h,0a4h,0f7h,0e4h,072h,072h,096h,09bh,0c0h,0c0h,05bh
		db 075h,0b7h,0b7h,0c2h,0e1h,0fdh,0fdh,01ch,03dh,093h,093h,0aeh,04ch,026h,026h,06ah
		db 06ch,036h,036h,05ah,07eh,03fh,03fh,041h,0f5h,0f7h,0f7h,002h,083h,0cch,0cch,04fh
		db 068h,034h,034h,05ch,051h,0a5h,0a5h,0f4h,0d1h,0e5h,0e5h,034h,0f9h,0f1h,0f1h,008h
		db 0e2h,071h,071h,093h,0abh,0d8h,0d8h,073h,062h,031h,031h,053h,02ah,015h,015h,03fh
		db 008h,004h,004h,00ch,095h,0c7h,0c7h,052h,046h,023h,023h,065h,09dh,0c3h,0c3h,05eh
		db 030h,018h,018h,028h,037h,096h,096h,0a1h,00ah,005h,005h,00fh,02fh,09ah,09ah,0b5h
		db 00eh,007h,007h,009h,024h,012h,012h,036h,01bh,080h,080h,09bh,0dfh,0e2h,0e2h,03dh
		db 0cdh,0ebh,0ebh,026h,04eh,027h,027h,069h,07fh,0b2h,0b2h,0cdh,0eah,075h,075h,09fh
		db 012h,009h,009h,01bh,01dh,083h,083h,09eh,058h,02ch,02ch,074h,034h,01ah,01ah,02eh
		db 036h,01bh,01bh,02dh,0dch,06eh,06eh,0b2h,0b4h,05ah,05ah,0eeh,05bh,0a0h,0a0h,0fbh
		db 0a4h,052h,052h,0f6h,076h,03bh,03bh,04dh,0b7h,0d6h,0d6h,061h,07dh,0b3h,0b3h,0ceh
		db 052h,029h,029h,07bh,0ddh,0e3h,0e3h,03eh,05eh,02fh,02fh,071h,013h,084h,084h,097h
		db 0a6h,053h,053h,0f5h,0b9h,0d1h,0d1h,068h,000h,000h,000h,000h,0c1h,0edh,0edh,02ch
		db 040h,020h,020h,060h,0e3h,0fch,0fch,01fh,079h,0b1h,0b1h,0c8h,0b6h,05bh,05bh,0edh
		db 0d4h,06ah,06ah,0beh,08dh,0cbh,0cbh,046h,067h,0beh,0beh,0d9h,072h,039h,039h,04bh
		db 094h,04ah,04ah,0deh,098h,04ch,04ch,0d4h,0b0h,058h,058h,0e8h,085h,0cfh,0cfh,04ah
		db 0bbh,0d0h,0d0h,06bh,0c5h,0efh,0efh,02ah,04fh,0aah,0aah,0e5h,0edh,0fbh,0fbh,016h
		db 086h,043h,043h,0c5h,09ah,04dh,04dh,0d7h,066h,033h,033h,055h,011h,085h,085h,094h
		db 08ah,045h,045h,0cfh,0e9h,0f9h,0f9h,010h,004h,002h,002h,006h,0feh,07fh,07fh,081h
		db 0a0h,050h,050h,0f0h,078h,03ch,03ch,044h,025h,09fh,09fh,0bah,04bh,0a8h,0a8h,0e3h
		db 0a2h,051h,051h,0f3h,05dh,0a3h,0a3h,0feh,080h,040h,040h,0c0h,005h,08fh,08fh,08ah
		db 03fh,092h,092h,0adh,021h,09dh,09dh,0bch,070h,038h,038h,048h,0f1h,0f5h,0f5h,004h
		db 063h,0bch,0bch,0dfh,077h,0b6h,0b6h,0c1h,0afh,0dah,0dah,075h,042h,021h,021h,063h
		db 020h,010h,010h,030h,0e5h,0ffh,0ffh,01ah,0fdh,0f3h,0f3h,00eh,0bfh,0d2h,0d2h,06dh
		db 081h,0cdh,0cdh,04ch,018h,00ch,00ch,014h,026h,013h,013h,035h,0c3h,0ech,0ech,02fh
		db 0beh,05fh,05fh,0e1h,035h,097h,097h,0a2h,088h,044h,044h,0cch,02eh,017h,017h,039h
		db 093h,0c4h,0c4h,057h,055h,0a7h,0a7h,0f2h,0fch,07eh,07eh,082h,07ah,03dh,03dh,047h
		db 0c8h,064h,064h,0ach,0bah,05dh,05dh,0e7h,032h,019h,019h,02bh,0e6h,073h,073h,095h
		db 0c0h,060h,060h,0a0h,019h,081h,081h,098h,09eh,04fh,04fh,0d1h,0a3h,0dch,0dch,07fh
		db 044h,022h,022h,066h,054h,02ah,02ah,07eh,03bh,090h,090h,0abh,00bh,088h,088h,083h
		db 08ch,046h,046h,0cah,0c7h,0eeh,0eeh,029h,06bh,0b8h,0b8h,0d3h,028h,014h,014h,03ch
		db 0a7h,0deh,0deh,079h,0bch,05eh,05eh,0e2h,016h,00bh,00bh,01dh,0adh,0dbh,0dbh,076h
		db 0dbh,0e0h,0e0h,03bh,064h,032h,032h,056h,074h,03ah,03ah,04eh,014h,00ah,00ah,01eh
		db 092h,049h,049h,0dbh,00ch,006h,006h,00ah,048h,024h,024h,06ch,0b8h,05ch,05ch,0e4h
		db 09fh,0c2h,0c2h,05dh,0bdh,0d3h,0d3h,06eh,043h,0ach,0ach,0efh,0c4h,062h,062h,0a6h
		db 039h,091h,091h,0a8h,031h,095h,095h,0a4h,0d3h,0e4h,0e4h,037h,0f2h,079h,079h,08bh
		db 0d5h,0e7h,0e7h,032h,08bh,0c8h,0c8h,043h,06eh,037h,037h,059h,0dah,06dh,06dh,0b7h
		db 001h,08dh,08dh,08ch,0b1h,0d5h,0d5h,064h,09ch,04eh,04eh,0d2h,049h,0a9h,0a9h,0e0h
		db 0d8h,06ch,06ch,0b4h,0ach,056h,056h,0fah,0f3h,0f4h,0f4h,007h,0cfh,0eah,0eah,025h
		db 0cah,065h,065h,0afh,0f4h,07ah,07ah,08eh,047h,0aeh,0aeh,0e9h,010h,008h,008h,018h
		db 06fh,0bah,0bah,0d5h,0f0h,078h,078h,088h,04ah,025h,025h,06fh,05ch,02eh,02eh,072h
		db 038h,01ch,01ch,024h,057h,0a6h,0a6h,0f1h,073h,0b4h,0b4h,0c7h,097h,0c6h,0c6h,051h
		db 0cbh,0e8h,0e8h,023h,0a1h,0ddh,0ddh,07ch,0e8h,074h,074h,09ch,03eh,01fh,01fh,021h
		db 096h,04bh,04bh,0ddh,061h,0bdh,0bdh,0dch,00dh,08bh,08bh,086h,00fh,08ah,08ah,085h
		db 0e0h,070h,070h,090h,07ch,03eh,03eh,042h,071h,0b5h,0b5h,0c4h,0cch,066h,066h,0aah
		db 090h,048h,048h,0d8h,006h,003h,003h,005h,0f7h,0f6h,0f6h,001h,01ch,00eh,00eh,012h
		db 0c2h,061h,061h,0a3h,06ah,035h,035h,05fh,0aeh,057h,057h,0f9h,069h,0b9h,0b9h,0d0h
		db 017h,086h,086h,091h,099h,0c1h,0c1h,058h,03ah,01dh,01dh,027h,027h,09eh,09eh,0b9h
		db 0d9h,0e1h,0e1h,038h,0ebh,0f8h,0f8h,013h,02bh,098h,098h,0b3h,022h,011h,011h,033h
		db 0d2h,069h,069h,0bbh,0a9h,0d9h,0d9h,070h,007h,08eh,08eh,089h,033h,094h,094h,0a7h
		db 02dh,09bh,09bh,0b6h,03ch,01eh,01eh,022h,015h,087h,087h,092h,0c9h,0e9h,0e9h,020h
		db 087h,0ceh,0ceh,049h,0aah,055h,055h,0ffh,050h,028h,028h,078h,0a5h,0dfh,0dfh,07ah
		db 003h,08ch,08ch,08fh,059h,0a1h,0a1h,0f8h,009h,089h,089h,080h,01ah,00dh,00dh,017h
		db 065h,0bfh,0bfh,0dah,0d7h,0e6h,0e6h,031h,084h,042h,042h,0c6h,0d0h,068h,068h,0b8h
		db 082h,041h,041h,0c3h,029h,099h,099h,0b0h,05ah,02dh,02dh,077h,01eh,00fh,00fh,011h
		db 07bh,0b0h,0b0h,0cbh,0a8h,054h,054h,0fch,06dh,0bbh,0bbh,0d6h,02ch,016h,016h,03ah
	
	Te1	db 0a5h,0c6h,063h,063h,084h,0f8h,07ch,07ch,099h,0eeh,077h,077h,08dh,0f6h,07bh,07bh
		db 00dh,0ffh,0f2h,0f2h,0bdh,0d6h,06bh,06bh,0b1h,0deh,06fh,06fh,054h,091h,0c5h,0c5h
		db 050h,060h,030h,030h,003h,002h,001h,001h,0a9h,0ceh,067h,067h,07dh,056h,02bh,02bh
		db 019h,0e7h,0feh,0feh,062h,0b5h,0d7h,0d7h,0e6h,04dh,0abh,0abh,09ah,0ech,076h,076h
		db 045h,08fh,0cah,0cah,09dh,01fh,082h,082h,040h,089h,0c9h,0c9h,087h,0fah,07dh,07dh
		db 015h,0efh,0fah,0fah,0ebh,0b2h,059h,059h,0c9h,08eh,047h,047h,00bh,0fbh,0f0h,0f0h
		db 0ech,041h,0adh,0adh,067h,0b3h,0d4h,0d4h,0fdh,05fh,0a2h,0a2h,0eah,045h,0afh,0afh
		db 0bfh,023h,09ch,09ch,0f7h,053h,0a4h,0a4h,096h,0e4h,072h,072h,05bh,09bh,0c0h,0c0h
		db 0c2h,075h,0b7h,0b7h,01ch,0e1h,0fdh,0fdh,0aeh,03dh,093h,093h,06ah,04ch,026h,026h
		db 05ah,06ch,036h,036h,041h,07eh,03fh,03fh,002h,0f5h,0f7h,0f7h,04fh,083h,0cch,0cch
		db 05ch,068h,034h,034h,0f4h,051h,0a5h,0a5h,034h,0d1h,0e5h,0e5h,008h,0f9h,0f1h,0f1h
		db 093h,0e2h,071h,071h,073h,0abh,0d8h,0d8h,053h,062h,031h,031h,03fh,02ah,015h,015h
		db 00ch,008h,004h,004h,052h,095h,0c7h,0c7h,065h,046h,023h,023h,05eh,09dh,0c3h,0c3h
		db 028h,030h,018h,018h,0a1h,037h,096h,096h,00fh,00ah,005h,005h,0b5h,02fh,09ah,09ah
		db 009h,00eh,007h,007h,036h,024h,012h,012h,09bh,01bh,080h,080h,03dh,0dfh,0e2h,0e2h
		db 026h,0cdh,0ebh,0ebh,069h,04eh,027h,027h,0cdh,07fh,0b2h,0b2h,09fh,0eah,075h,075h
		db 01bh,012h,009h,009h,09eh,01dh,083h,083h,074h,058h,02ch,02ch,02eh,034h,01ah,01ah
		db 02dh,036h,01bh,01bh,0b2h,0dch,06eh,06eh,0eeh,0b4h,05ah,05ah,0fbh,05bh,0a0h,0a0h
		db 0f6h,0a4h,052h,052h,04dh,076h,03bh,03bh,061h,0b7h,0d6h,0d6h,0ceh,07dh,0b3h,0b3h
		db 07bh,052h,029h,029h,03eh,0ddh,0e3h,0e3h,071h,05eh,02fh,02fh,097h,013h,084h,084h
		db 0f5h,0a6h,053h,053h,068h,0b9h,0d1h,0d1h,000h,000h,000h,000h,02ch,0c1h,0edh,0edh
		db 060h,040h,020h,020h,01fh,0e3h,0fch,0fch,0c8h,079h,0b1h,0b1h,0edh,0b6h,05bh,05bh
		db 0beh,0d4h,06ah,06ah,046h,08dh,0cbh,0cbh,0d9h,067h,0beh,0beh,04bh,072h,039h,039h
		db 0deh,094h,04ah,04ah,0d4h,098h,04ch,04ch,0e8h,0b0h,058h,058h,04ah,085h,0cfh,0cfh
		db 06bh,0bbh,0d0h,0d0h,02ah,0c5h,0efh,0efh,0e5h,04fh,0aah,0aah,016h,0edh,0fbh,0fbh
		db 0c5h,086h,043h,043h,0d7h,09ah,04dh,04dh,055h,066h,033h,033h,094h,011h,085h,085h
		db 0cfh,08ah,045h,045h,010h,0e9h,0f9h,0f9h,006h,004h,002h,002h,081h,0feh,07fh,07fh
		db 0f0h,0a0h,050h,050h,044h,078h,03ch,03ch,0bah,025h,09fh,09fh,0e3h,04bh,0a8h,0a8h
		db 0f3h,0a2h,051h,051h,0feh,05dh,0a3h,0a3h,0c0h,080h,040h,040h,08ah,005h,08fh,08fh
		db 0adh,03fh,092h,092h,0bch,021h,09dh,09dh,048h,070h,038h,038h,004h,0f1h,0f5h,0f5h
		db 0dfh,063h,0bch,0bch,0c1h,077h,0b6h,0b6h,075h,0afh,0dah,0dah,063h,042h,021h,021h
		db 030h,020h,010h,010h,01ah,0e5h,0ffh,0ffh,00eh,0fdh,0f3h,0f3h,06dh,0bfh,0d2h,0d2h
		db 04ch,081h,0cdh,0cdh,014h,018h,00ch,00ch,035h,026h,013h,013h,02fh,0c3h,0ech,0ech
		db 0e1h,0beh,05fh,05fh,0a2h,035h,097h,097h,0cch,088h,044h,044h,039h,02eh,017h,017h
		db 057h,093h,0c4h,0c4h,0f2h,055h,0a7h,0a7h,082h,0fch,07eh,07eh,047h,07ah,03dh,03dh
		db 0ach,0c8h,064h,064h,0e7h,0bah,05dh,05dh,02bh,032h,019h,019h,095h,0e6h,073h,073h
		db 0a0h,0c0h,060h,060h,098h,019h,081h,081h,0d1h,09eh,04fh,04fh,07fh,0a3h,0dch,0dch
		db 066h,044h,022h,022h,07eh,054h,02ah,02ah,0abh,03bh,090h,090h,083h,00bh,088h,088h
		db 0cah,08ch,046h,046h,029h,0c7h,0eeh,0eeh,0d3h,06bh,0b8h,0b8h,03ch,028h,014h,014h
		db 079h,0a7h,0deh,0deh,0e2h,0bch,05eh,05eh,01dh,016h,00bh,00bh,076h,0adh,0dbh,0dbh
		db 03bh,0dbh,0e0h,0e0h,056h,064h,032h,032h,04eh,074h,03ah,03ah,01eh,014h,00ah,00ah
		db 0dbh,092h,049h,049h,00ah,00ch,006h,006h,06ch,048h,024h,024h,0e4h,0b8h,05ch,05ch
		db 05dh,09fh,0c2h,0c2h,06eh,0bdh,0d3h,0d3h,0efh,043h,0ach,0ach,0a6h,0c4h,062h,062h
		db 0a8h,039h,091h,091h,0a4h,031h,095h,095h,037h,0d3h,0e4h,0e4h,08bh,0f2h,079h,079h
		db 032h,0d5h,0e7h,0e7h,043h,08bh,0c8h,0c8h,059h,06eh,037h,037h,0b7h,0dah,06dh,06dh
		db 08ch,001h,08dh,08dh,064h,0b1h,0d5h,0d5h,0d2h,09ch,04eh,04eh,0e0h,049h,0a9h,0a9h
		db 0b4h,0d8h,06ch,06ch,0fah,0ach,056h,056h,007h,0f3h,0f4h,0f4h,025h,0cfh,0eah,0eah
		db 0afh,0cah,065h,065h,08eh,0f4h,07ah,07ah,0e9h,047h,0aeh,0aeh,018h,010h,008h,008h
		db 0d5h,06fh,0bah,0bah,088h,0f0h,078h,078h,06fh,04ah,025h,025h,072h,05ch,02eh,02eh
		db 024h,038h,01ch,01ch,0f1h,057h,0a6h,0a6h,0c7h,073h,0b4h,0b4h,051h,097h,0c6h,0c6h
		db 023h,0cbh,0e8h,0e8h,07ch,0a1h,0ddh,0ddh,09ch,0e8h,074h,074h,021h,03eh,01fh,01fh
		db 0ddh,096h,04bh,04bh,0dch,061h,0bdh,0bdh,086h,00dh,08bh,08bh,085h,00fh,08ah,08ah
		db 090h,0e0h,070h,070h,042h,07ch,03eh,03eh,0c4h,071h,0b5h,0b5h,0aah,0cch,066h,066h
		db 0d8h,090h,048h,048h,005h,006h,003h,003h,001h,0f7h,0f6h,0f6h,012h,01ch,00eh,00eh
		db 0a3h,0c2h,061h,061h,05fh,06ah,035h,035h,0f9h,0aeh,057h,057h,0d0h,069h,0b9h,0b9h
		db 091h,017h,086h,086h,058h,099h,0c1h,0c1h,027h,03ah,01dh,01dh,0b9h,027h,09eh,09eh
		db 038h,0d9h,0e1h,0e1h,013h,0ebh,0f8h,0f8h,0b3h,02bh,098h,098h,033h,022h,011h,011h
		db 0bbh,0d2h,069h,069h,070h,0a9h,0d9h,0d9h,089h,007h,08eh,08eh,0a7h,033h,094h,094h
		db 0b6h,02dh,09bh,09bh,022h,03ch,01eh,01eh,092h,015h,087h,087h,020h,0c9h,0e9h,0e9h
		db 049h,087h,0ceh,0ceh,0ffh,0aah,055h,055h,078h,050h,028h,028h,07ah,0a5h,0dfh,0dfh
		db 08fh,003h,08ch,08ch,0f8h,059h,0a1h,0a1h,080h,009h,089h,089h,017h,01ah,00dh,00dh
		db 0dah,065h,0bfh,0bfh,031h,0d7h,0e6h,0e6h,0c6h,084h,042h,042h,0b8h,0d0h,068h,068h
		db 0c3h,082h,041h,041h,0b0h,029h,099h,099h,077h,05ah,02dh,02dh,011h,01eh,00fh,00fh
		db 0cbh,07bh,0b0h,0b0h,0fch,0a8h,054h,054h,0d6h,06dh,0bbh,0bbh,03ah,02ch,016h,016h
	
	Te2	db 063h,0a5h,0c6h,063h,07ch,084h,0f8h,07ch,077h,099h,0eeh,077h,07bh,08dh,0f6h,07bh
		db 0f2h,00dh,0ffh,0f2h,06bh,0bdh,0d6h,06bh,06fh,0b1h,0deh,06fh,0c5h,054h,091h,0c5h
		db 030h,050h,060h,030h,001h,003h,002h,001h,067h,0a9h,0ceh,067h,02bh,07dh,056h,02bh
		db 0feh,019h,0e7h,0feh,0d7h,062h,0b5h,0d7h,0abh,0e6h,04dh,0abh,076h,09ah,0ech,076h
		db 0cah,045h,08fh,0cah,082h,09dh,01fh,082h,0c9h,040h,089h,0c9h,07dh,087h,0fah,07dh
		db 0fah,015h,0efh,0fah,059h,0ebh,0b2h,059h,047h,0c9h,08eh,047h,0f0h,00bh,0fbh,0f0h
		db 0adh,0ech,041h,0adh,0d4h,067h,0b3h,0d4h,0a2h,0fdh,05fh,0a2h,0afh,0eah,045h,0afh
		db 09ch,0bfh,023h,09ch,0a4h,0f7h,053h,0a4h,072h,096h,0e4h,072h,0c0h,05bh,09bh,0c0h
		db 0b7h,0c2h,075h,0b7h,0fdh,01ch,0e1h,0fdh,093h,0aeh,03dh,093h,026h,06ah,04ch,026h
		db 036h,05ah,06ch,036h,03fh,041h,07eh,03fh,0f7h,002h,0f5h,0f7h,0cch,04fh,083h,0cch
		db 034h,05ch,068h,034h,0a5h,0f4h,051h,0a5h,0e5h,034h,0d1h,0e5h,0f1h,008h,0f9h,0f1h
		db 071h,093h,0e2h,071h,0d8h,073h,0abh,0d8h,031h,053h,062h,031h,015h,03fh,02ah,015h
		db 004h,00ch,008h,004h,0c7h,052h,095h,0c7h,023h,065h,046h,023h,0c3h,05eh,09dh,0c3h
		db 018h,028h,030h,018h,096h,0a1h,037h,096h,005h,00fh,00ah,005h,09ah,0b5h,02fh,09ah
		db 007h,009h,00eh,007h,012h,036h,024h,012h,080h,09bh,01bh,080h,0e2h,03dh,0dfh,0e2h
		db 0ebh,026h,0cdh,0ebh,027h,069h,04eh,027h,0b2h,0cdh,07fh,0b2h,075h,09fh,0eah,075h
		db 009h,01bh,012h,009h,083h,09eh,01dh,083h,02ch,074h,058h,02ch,01ah,02eh,034h,01ah
		db 01bh,02dh,036h,01bh,06eh,0b2h,0dch,06eh,05ah,0eeh,0b4h,05ah,0a0h,0fbh,05bh,0a0h
		db 052h,0f6h,0a4h,052h,03bh,04dh,076h,03bh,0d6h,061h,0b7h,0d6h,0b3h,0ceh,07dh,0b3h
		db 029h,07bh,052h,029h,0e3h,03eh,0ddh,0e3h,02fh,071h,05eh,02fh,084h,097h,013h,084h
		db 053h,0f5h,0a6h,053h,0d1h,068h,0b9h,0d1h,000h,000h,000h,000h,0edh,02ch,0c1h,0edh
		db 020h,060h,040h,020h,0fch,01fh,0e3h,0fch,0b1h,0c8h,079h,0b1h,05bh,0edh,0b6h,05bh
		db 06ah,0beh,0d4h,06ah,0cbh,046h,08dh,0cbh,0beh,0d9h,067h,0beh,039h,04bh,072h,039h
		db 04ah,0deh,094h,04ah,04ch,0d4h,098h,04ch,058h,0e8h,0b0h,058h,0cfh,04ah,085h,0cfh
		db 0d0h,06bh,0bbh,0d0h,0efh,02ah,0c5h,0efh,0aah,0e5h,04fh,0aah,0fbh,016h,0edh,0fbh
		db 043h,0c5h,086h,043h,04dh,0d7h,09ah,04dh,033h,055h,066h,033h,085h,094h,011h,085h
		db 045h,0cfh,08ah,045h,0f9h,010h,0e9h,0f9h,002h,006h,004h,002h,07fh,081h,0feh,07fh
		db 050h,0f0h,0a0h,050h,03ch,044h,078h,03ch,09fh,0bah,025h,09fh,0a8h,0e3h,04bh,0a8h
		db 051h,0f3h,0a2h,051h,0a3h,0feh,05dh,0a3h,040h,0c0h,080h,040h,08fh,08ah,005h,08fh
		db 092h,0adh,03fh,092h,09dh,0bch,021h,09dh,038h,048h,070h,038h,0f5h,004h,0f1h,0f5h
		db 0bch,0dfh,063h,0bch,0b6h,0c1h,077h,0b6h,0dah,075h,0afh,0dah,021h,063h,042h,021h
		db 010h,030h,020h,010h,0ffh,01ah,0e5h,0ffh,0f3h,00eh,0fdh,0f3h,0d2h,06dh,0bfh,0d2h
		db 0cdh,04ch,081h,0cdh,00ch,014h,018h,00ch,013h,035h,026h,013h,0ech,02fh,0c3h,0ech
		db 05fh,0e1h,0beh,05fh,097h,0a2h,035h,097h,044h,0cch,088h,044h,017h,039h,02eh,017h
		db 0c4h,057h,093h,0c4h,0a7h,0f2h,055h,0a7h,07eh,082h,0fch,07eh,03dh,047h,07ah,03dh
		db 064h,0ach,0c8h,064h,05dh,0e7h,0bah,05dh,019h,02bh,032h,019h,073h,095h,0e6h,073h
		db 060h,0a0h,0c0h,060h,081h,098h,019h,081h,04fh,0d1h,09eh,04fh,0dch,07fh,0a3h,0dch
		db 022h,066h,044h,022h,02ah,07eh,054h,02ah,090h,0abh,03bh,090h,088h,083h,00bh,088h
		db 046h,0cah,08ch,046h,0eeh,029h,0c7h,0eeh,0b8h,0d3h,06bh,0b8h,014h,03ch,028h,014h
		db 0deh,079h,0a7h,0deh,05eh,0e2h,0bch,05eh,00bh,01dh,016h,00bh,0dbh,076h,0adh,0dbh
		db 0e0h,03bh,0dbh,0e0h,032h,056h,064h,032h,03ah,04eh,074h,03ah,00ah,01eh,014h,00ah
		db 049h,0dbh,092h,049h,006h,00ah,00ch,006h,024h,06ch,048h,024h,05ch,0e4h,0b8h,05ch
		db 0c2h,05dh,09fh,0c2h,0d3h,06eh,0bdh,0d3h,0ach,0efh,043h,0ach,062h,0a6h,0c4h,062h
		db 091h,0a8h,039h,091h,095h,0a4h,031h,095h,0e4h,037h,0d3h,0e4h,079h,08bh,0f2h,079h
		db 0e7h,032h,0d5h,0e7h,0c8h,043h,08bh,0c8h,037h,059h,06eh,037h,06dh,0b7h,0dah,06dh
		db 08dh,08ch,001h,08dh,0d5h,064h,0b1h,0d5h,04eh,0d2h,09ch,04eh,0a9h,0e0h,049h,0a9h
		db 06ch,0b4h,0d8h,06ch,056h,0fah,0ach,056h,0f4h,007h,0f3h,0f4h,0eah,025h,0cfh,0eah
		db 065h,0afh,0cah,065h,07ah,08eh,0f4h,07ah,0aeh,0e9h,047h,0aeh,008h,018h,010h,008h
		db 0bah,0d5h,06fh,0bah,078h,088h,0f0h,078h,025h,06fh,04ah,025h,02eh,072h,05ch,02eh
		db 01ch,024h,038h,01ch,0a6h,0f1h,057h,0a6h,0b4h,0c7h,073h,0b4h,0c6h,051h,097h,0c6h
		db 0e8h,023h,0cbh,0e8h,0ddh,07ch,0a1h,0ddh,074h,09ch,0e8h,074h,01fh,021h,03eh,01fh
		db 04bh,0ddh,096h,04bh,0bdh,0dch,061h,0bdh,08bh,086h,00dh,08bh,08ah,085h,00fh,08ah
		db 070h,090h,0e0h,070h,03eh,042h,07ch,03eh,0b5h,0c4h,071h,0b5h,066h,0aah,0cch,066h
		db 048h,0d8h,090h,048h,003h,005h,006h,003h,0f6h,001h,0f7h,0f6h,00eh,012h,01ch,00eh
		db 061h,0a3h,0c2h,061h,035h,05fh,06ah,035h,057h,0f9h,0aeh,057h,0b9h,0d0h,069h,0b9h
		db 086h,091h,017h,086h,0c1h,058h,099h,0c1h,01dh,027h,03ah,01dh,09eh,0b9h,027h,09eh
		db 0e1h,038h,0d9h,0e1h,0f8h,013h,0ebh,0f8h,098h,0b3h,02bh,098h,011h,033h,022h,011h
		db 069h,0bbh,0d2h,069h,0d9h,070h,0a9h,0d9h,08eh,089h,007h,08eh,094h,0a7h,033h,094h
		db 09bh,0b6h,02dh,09bh,01eh,022h,03ch,01eh,087h,092h,015h,087h,0e9h,020h,0c9h,0e9h
		db 0ceh,049h,087h,0ceh,055h,0ffh,0aah,055h,028h,078h,050h,028h,0dfh,07ah,0a5h,0dfh
		db 08ch,08fh,003h,08ch,0a1h,0f8h,059h,0a1h,089h,080h,009h,089h,00dh,017h,01ah,00dh
		db 0bfh,0dah,065h,0bfh,0e6h,031h,0d7h,0e6h,042h,0c6h,084h,042h,068h,0b8h,0d0h,068h
		db 041h,0c3h,082h,041h,099h,0b0h,029h,099h,02dh,077h,05ah,02dh,00fh,011h,01eh,00fh
		db 0b0h,0cbh,07bh,0b0h,054h,0fch,0a8h,054h,0bbh,0d6h,06dh,0bbh,016h,03ah,02ch,016h
	
	Te3	db 063h,063h,0a5h,0c6h,07ch,07ch,084h,0f8h,077h,077h,099h,0eeh,07bh,07bh,08dh,0f6h
		db 0f2h,0f2h,00dh,0ffh,06bh,06bh,0bdh,0d6h,06fh,06fh,0b1h,0deh,0c5h,0c5h,054h,091h
		db 030h,030h,050h,060h,001h,001h,003h,002h,067h,067h,0a9h,0ceh,02bh,02bh,07dh,056h
		db 0feh,0feh,019h,0e7h,0d7h,0d7h,062h,0b5h,0abh,0abh,0e6h,04dh,076h,076h,09ah,0ech
		db 0cah,0cah,045h,08fh,082h,082h,09dh,01fh,0c9h,0c9h,040h,089h,07dh,07dh,087h,0fah
		db 0fah,0fah,015h,0efh,059h,059h,0ebh,0b2h,047h,047h,0c9h,08eh,0f0h,0f0h,00bh,0fbh
		db 0adh,0adh,0ech,041h,0d4h,0d4h,067h,0b3h,0a2h,0a2h,0fdh,05fh,0afh,0afh,0eah,045h
		db 09ch,09ch,0bfh,023h,0a4h,0a4h,0f7h,053h,072h,072h,096h,0e4h,0c0h,0c0h,05bh,09bh
		db 0b7h,0b7h,0c2h,075h,0fdh,0fdh,01ch,0e1h,093h,093h,0aeh,03dh,026h,026h,06ah,04ch
		db 036h,036h,05ah,06ch,03fh,03fh,041h,07eh,0f7h,0f7h,002h,0f5h,0cch,0cch,04fh,083h
		db 034h,034h,05ch,068h,0a5h,0a5h,0f4h,051h,0e5h,0e5h,034h,0d1h,0f1h,0f1h,008h,0f9h
		db 071h,071h,093h,0e2h,0d8h,0d8h,073h,0abh,031h,031h,053h,062h,015h,015h,03fh,02ah
		db 004h,004h,00ch,008h,0c7h,0c7h,052h,095h,023h,023h,065h,046h,0c3h,0c3h,05eh,09dh
		db 018h,018h,028h,030h,096h,096h,0a1h,037h,005h,005h,00fh,00ah,09ah,09ah,0b5h,02fh
		db 007h,007h,009h,00eh,012h,012h,036h,024h,080h,080h,09bh,01bh,0e2h,0e2h,03dh,0dfh
		db 0ebh,0ebh,026h,0cdh,027h,027h,069h,04eh,0b2h,0b2h,0cdh,07fh,075h,075h,09fh,0eah
		db 009h,009h,01bh,012h,083h,083h,09eh,01dh,02ch,02ch,074h,058h,01ah,01ah,02eh,034h
		db 01bh,01bh,02dh,036h,06eh,06eh,0b2h,0dch,05ah,05ah,0eeh,0b4h,0a0h,0a0h,0fbh,05bh
		db 052h,052h,0f6h,0a4h,03bh,03bh,04dh,076h,0d6h,0d6h,061h,0b7h,0b3h,0b3h,0ceh,07dh
		db 029h,029h,07bh,052h,0e3h,0e3h,03eh,0ddh,02fh,02fh,071h,05eh,084h,084h,097h,013h
		db 053h,053h,0f5h,0a6h,0d1h,0d1h,068h,0b9h,000h,000h,000h,000h,0edh,0edh,02ch,0c1h
		db 020h,020h,060h,040h,0fch,0fch,01fh,0e3h,0b1h,0b1h,0c8h,079h,05bh,05bh,0edh,0b6h
		db 06ah,06ah,0beh,0d4h,0cbh,0cbh,046h,08dh,0beh,0beh,0d9h,067h,039h,039h,04bh,072h
		db 04ah,04ah,0deh,094h,04ch,04ch,0d4h,098h,058h,058h,0e8h,0b0h,0cfh,0cfh,04ah,085h
		db 0d0h,0d0h,06bh,0bbh,0efh,0efh,02ah,0c5h,0aah,0aah,0e5h,04fh,0fbh,0fbh,016h,0edh
		db 043h,043h,0c5h,086h,04dh,04dh,0d7h,09ah,033h,033h,055h,066h,085h,085h,094h,011h
		db 045h,045h,0cfh,08ah,0f9h,0f9h,010h,0e9h,002h,002h,006h,004h,07fh,07fh,081h,0feh
		db 050h,050h,0f0h,0a0h,03ch,03ch,044h,078h,09fh,09fh,0bah,025h,0a8h,0a8h,0e3h,04bh
		db 051h,051h,0f3h,0a2h,0a3h,0a3h,0feh,05dh,040h,040h,0c0h,080h,08fh,08fh,08ah,005h
		db 092h,092h,0adh,03fh,09dh,09dh,0bch,021h,038h,038h,048h,070h,0f5h,0f5h,004h,0f1h
		db 0bch,0bch,0dfh,063h,0b6h,0b6h,0c1h,077h,0dah,0dah,075h,0afh,021h,021h,063h,042h
		db 010h,010h,030h,020h,0ffh,0ffh,01ah,0e5h,0f3h,0f3h,00eh,0fdh,0d2h,0d2h,06dh,0bfh
		db 0cdh,0cdh,04ch,081h,00ch,00ch,014h,018h,013h,013h,035h,026h,0ech,0ech,02fh,0c3h
		db 05fh,05fh,0e1h,0beh,097h,097h,0a2h,035h,044h,044h,0cch,088h,017h,017h,039h,02eh
		db 0c4h,0c4h,057h,093h,0a7h,0a7h,0f2h,055h,07eh,07eh,082h,0fch,03dh,03dh,047h,07ah
		db 064h,064h,0ach,0c8h,05dh,05dh,0e7h,0bah,019h,019h,02bh,032h,073h,073h,095h,0e6h
		db 060h,060h,0a0h,0c0h,081h,081h,098h,019h,04fh,04fh,0d1h,09eh,0dch,0dch,07fh,0a3h
		db 022h,022h,066h,044h,02ah,02ah,07eh,054h,090h,090h,0abh,03bh,088h,088h,083h,00bh
		db 046h,046h,0cah,08ch,0eeh,0eeh,029h,0c7h,0b8h,0b8h,0d3h,06bh,014h,014h,03ch,028h
		db 0deh,0deh,079h,0a7h,05eh,05eh,0e2h,0bch,00bh,00bh,01dh,016h,0dbh,0dbh,076h,0adh
		db 0e0h,0e0h,03bh,0dbh,032h,032h,056h,064h,03ah,03ah,04eh,074h,00ah,00ah,01eh,014h
		db 049h,049h,0dbh,092h,006h,006h,00ah,00ch,024h,024h,06ch,048h,05ch,05ch,0e4h,0b8h
		db 0c2h,0c2h,05dh,09fh,0d3h,0d3h,06eh,0bdh,0ach,0ach,0efh,043h,062h,062h,0a6h,0c4h
		db 091h,091h,0a8h,039h,095h,095h,0a4h,031h,0e4h,0e4h,037h,0d3h,079h,079h,08bh,0f2h
		db 0e7h,0e7h,032h,0d5h,0c8h,0c8h,043h,08bh,037h,037h,059h,06eh,06dh,06dh,0b7h,0dah
		db 08dh,08dh,08ch,001h,0d5h,0d5h,064h,0b1h,04eh,04eh,0d2h,09ch,0a9h,0a9h,0e0h,049h
		db 06ch,06ch,0b4h,0d8h,056h,056h,0fah,0ach,0f4h,0f4h,007h,0f3h,0eah,0eah,025h,0cfh
		db 065h,065h,0afh,0cah,07ah,07ah,08eh,0f4h,0aeh,0aeh,0e9h,047h,008h,008h,018h,010h
		db 0bah,0bah,0d5h,06fh,078h,078h,088h,0f0h,025h,025h,06fh,04ah,02eh,02eh,072h,05ch
		db 01ch,01ch,024h,038h,0a6h,0a6h,0f1h,057h,0b4h,0b4h,0c7h,073h,0c6h,0c6h,051h,097h
		db 0e8h,0e8h,023h,0cbh,0ddh,0ddh,07ch,0a1h,074h,074h,09ch,0e8h,01fh,01fh,021h,03eh
		db 04bh,04bh,0ddh,096h,0bdh,0bdh,0dch,061h,08bh,08bh,086h,00dh,08ah,08ah,085h,00fh
		db 070h,070h,090h,0e0h,03eh,03eh,042h,07ch,0b5h,0b5h,0c4h,071h,066h,066h,0aah,0cch
		db 048h,048h,0d8h,090h,003h,003h,005h,006h,0f6h,0f6h,001h,0f7h,00eh,00eh,012h,01ch
		db 061h,061h,0a3h,0c2h,035h,035h,05fh,06ah,057h,057h,0f9h,0aeh,0b9h,0b9h,0d0h,069h
		db 086h,086h,091h,017h,0c1h,0c1h,058h,099h,01dh,01dh,027h,03ah,09eh,09eh,0b9h,027h
		db 0e1h,0e1h,038h,0d9h,0f8h,0f8h,013h,0ebh,098h,098h,0b3h,02bh,011h,011h,033h,022h
		db 069h,069h,0bbh,0d2h,0d9h,0d9h,070h,0a9h,08eh,08eh,089h,007h,094h,094h,0a7h,033h
		db 09bh,09bh,0b6h,02dh,01eh,01eh,022h,03ch,087h,087h,092h,015h,0e9h,0e9h,020h,0c9h
		db 0ceh,0ceh,049h,087h,055h,055h,0ffh,0aah,028h,028h,078h,050h,0dfh,0dfh,07ah,0a5h
		db 08ch,08ch,08fh,003h,0a1h,0a1h,0f8h,059h,089h,089h,080h,009h,00dh,00dh,017h,01ah
		db 0bfh,0bfh,0dah,065h,0e6h,0e6h,031h,0d7h,042h,042h,0c6h,084h,068h,068h,0b8h,0d0h
		db 041h,041h,0c3h,082h,099h,099h,0b0h,029h,02dh,02dh,077h,05ah,00fh,00fh,011h,01eh
		db 0b0h,0b0h,0cbh,07bh,054h,054h,0fch,0a8h,0bbh,0bbh,0d6h,06dh,016h,016h,03ah,02ch
	ENDIF
	
	IF ((ACTION eq DEC_ONLY) OR (ACTION eq ALL))
	Td0	db 051h,0f4h,0a7h,050h,07eh,041h,065h,053h,01ah,017h,0a4h,0c3h,03ah,027h,05eh,096h
		db 03bh,0abh,06bh,0cbh,01fh,09dh,045h,0f1h,0ach,0fah,058h,0abh,04bh,0e3h,003h,093h
		db 020h,030h,0fah,055h,0adh,076h,06dh,0f6h,088h,0cch,076h,091h,0f5h,002h,04ch,025h
		db 04fh,0e5h,0d7h,0fch,0c5h,02ah,0cbh,0d7h,026h,035h,044h,080h,0b5h,062h,0a3h,08fh
		db 0deh,0b1h,05ah,049h,025h,0bah,01bh,067h,045h,0eah,00eh,098h,05dh,0feh,0c0h,0e1h
		db 0c3h,02fh,075h,002h,081h,04ch,0f0h,012h,08dh,046h,097h,0a3h,06bh,0d3h,0f9h,0c6h
		db 003h,08fh,05fh,0e7h,015h,092h,09ch,095h,0bfh,06dh,07ah,0ebh,095h,052h,059h,0dah
		db 0d4h,0beh,083h,02dh,058h,074h,021h,0d3h,049h,0e0h,069h,029h,08eh,0c9h,0c8h,044h
		db 075h,0c2h,089h,06ah,0f4h,08eh,079h,078h,099h,058h,03eh,06bh,027h,0b9h,071h,0ddh
		db 0beh,0e1h,04fh,0b6h,0f0h,088h,0adh,017h,0c9h,020h,0ach,066h,07dh,0ceh,03ah,0b4h
		db 063h,0dfh,04ah,018h,0e5h,01ah,031h,082h,097h,051h,033h,060h,062h,053h,07fh,045h
		db 0b1h,064h,077h,0e0h,0bbh,06bh,0aeh,084h,0feh,081h,0a0h,01ch,0f9h,008h,02bh,094h
		db 070h,048h,068h,058h,08fh,045h,0fdh,019h,094h,0deh,06ch,087h,052h,07bh,0f8h,0b7h
		db 0abh,073h,0d3h,023h,072h,04bh,002h,0e2h,0e3h,01fh,08fh,057h,066h,055h,0abh,02ah
		db 0b2h,0ebh,028h,007h,02fh,0b5h,0c2h,003h,086h,0c5h,07bh,09ah,0d3h,037h,008h,0a5h
		db 030h,028h,087h,0f2h,023h,0bfh,0a5h,0b2h,002h,003h,06ah,0bah,0edh,016h,082h,05ch
		db 08ah,0cfh,01ch,02bh,0a7h,079h,0b4h,092h,0f3h,007h,0f2h,0f0h,04eh,069h,0e2h,0a1h
		db 065h,0dah,0f4h,0cdh,006h,005h,0beh,0d5h,0d1h,034h,062h,01fh,0c4h,0a6h,0feh,08ah
		db 034h,02eh,053h,09dh,0a2h,0f3h,055h,0a0h,005h,08ah,0e1h,032h,0a4h,0f6h,0ebh,075h
		db 00bh,083h,0ech,039h,040h,060h,0efh,0aah,05eh,071h,09fh,006h,0bdh,06eh,010h,051h
		db 03eh,021h,08ah,0f9h,096h,0ddh,006h,03dh,0ddh,03eh,005h,0aeh,04dh,0e6h,0bdh,046h
		db 091h,054h,08dh,0b5h,071h,0c4h,05dh,005h,004h,006h,0d4h,06fh,060h,050h,015h,0ffh
		db 019h,098h,0fbh,024h,0d6h,0bdh,0e9h,097h,089h,040h,043h,0cch,067h,0d9h,09eh,077h
		db 0b0h,0e8h,042h,0bdh,007h,089h,08bh,088h,0e7h,019h,05bh,038h,079h,0c8h,0eeh,0dbh
		db 0a1h,07ch,00ah,047h,07ch,042h,00fh,0e9h,0f8h,084h,01eh,0c9h,000h,000h,000h,000h
		db 009h,080h,086h,083h,032h,02bh,0edh,048h,01eh,011h,070h,0ach,06ch,05ah,072h,04eh
		db 0fdh,00eh,0ffh,0fbh,00fh,085h,038h,056h,03dh,0aeh,0d5h,01eh,036h,02dh,039h,027h
		db 00ah,00fh,0d9h,064h,068h,05ch,0a6h,021h,09bh,05bh,054h,0d1h,024h,036h,02eh,03ah
		db 00ch,00ah,067h,0b1h,093h,057h,0e7h,00fh,0b4h,0eeh,096h,0d2h,01bh,09bh,091h,09eh
		db 080h,0c0h,0c5h,04fh,061h,0dch,020h,0a2h,05ah,077h,04bh,069h,01ch,012h,01ah,016h
		db 0e2h,093h,0bah,00ah,0c0h,0a0h,02ah,0e5h,03ch,022h,0e0h,043h,012h,01bh,017h,01dh
		db 00eh,009h,00dh,00bh,0f2h,08bh,0c7h,0adh,02dh,0b6h,0a8h,0b9h,014h,01eh,0a9h,0c8h
		db 057h,0f1h,019h,085h,0afh,075h,007h,04ch,0eeh,099h,0ddh,0bbh,0a3h,07fh,060h,0fdh
		db 0f7h,001h,026h,09fh,05ch,072h,0f5h,0bch,044h,066h,03bh,0c5h,05bh,0fbh,07eh,034h
		db 08bh,043h,029h,076h,0cbh,023h,0c6h,0dch,0b6h,0edh,0fch,068h,0b8h,0e4h,0f1h,063h
		db 0d7h,031h,0dch,0cah,042h,063h,085h,010h,013h,097h,022h,040h,084h,0c6h,011h,020h
		db 085h,04ah,024h,07dh,0d2h,0bbh,03dh,0f8h,0aeh,0f9h,032h,011h,0c7h,029h,0a1h,06dh
		db 01dh,09eh,02fh,04bh,0dch,0b2h,030h,0f3h,00dh,086h,052h,0ech,077h,0c1h,0e3h,0d0h
		db 02bh,0b3h,016h,06ch,0a9h,070h,0b9h,099h,011h,094h,048h,0fah,047h,0e9h,064h,022h
		db 0a8h,0fch,08ch,0c4h,0a0h,0f0h,03fh,01ah,056h,07dh,02ch,0d8h,022h,033h,090h,0efh
		db 087h,049h,04eh,0c7h,0d9h,038h,0d1h,0c1h,08ch,0cah,0a2h,0feh,098h,0d4h,00bh,036h
		db 0a6h,0f5h,081h,0cfh,0a5h,07ah,0deh,028h,0dah,0b7h,08eh,026h,03fh,0adh,0bfh,0a4h
		db 02ch,03ah,09dh,0e4h,050h,078h,092h,00dh,06ah,05fh,0cch,09bh,054h,07eh,046h,062h
		db 0f6h,08dh,013h,0c2h,090h,0d8h,0b8h,0e8h,02eh,039h,0f7h,05eh,082h,0c3h,0afh,0f5h
		db 09fh,05dh,080h,0beh,069h,0d0h,093h,07ch,06fh,0d5h,02dh,0a9h,0cfh,025h,012h,0b3h
		db 0c8h,0ach,099h,03bh,010h,018h,07dh,0a7h,0e8h,09ch,063h,06eh,0dbh,03bh,0bbh,07bh
		db 0cdh,026h,078h,009h,06eh,059h,018h,0f4h,0ech,09ah,0b7h,001h,083h,04fh,09ah,0a8h
		db 0e6h,095h,06eh,065h,0aah,0ffh,0e6h,07eh,021h,0bch,0cfh,008h,0efh,015h,0e8h,0e6h
		db 0bah,0e7h,09bh,0d9h,04ah,06fh,036h,0ceh,0eah,09fh,009h,0d4h,029h,0b0h,07ch,0d6h
		db 031h,0a4h,0b2h,0afh,02ah,03fh,023h,031h,0c6h,0a5h,094h,030h,035h,0a2h,066h,0c0h
		db 074h,04eh,0bch,037h,0fch,082h,0cah,0a6h,0e0h,090h,0d0h,0b0h,033h,0a7h,0d8h,015h
		db 0f1h,004h,098h,04ah,041h,0ech,0dah,0f7h,07fh,0cdh,050h,00eh,017h,091h,0f6h,02fh
		db 076h,04dh,0d6h,08dh,043h,0efh,0b0h,04dh,0cch,0aah,04dh,054h,0e4h,096h,004h,0dfh
		db 09eh,0d1h,0b5h,0e3h,04ch,06ah,088h,01bh,0c1h,02ch,01fh,0b8h,046h,065h,051h,07fh
		db 09dh,05eh,0eah,004h,001h,08ch,035h,05dh,0fah,087h,074h,073h,0fbh,00bh,041h,02eh
		db 0b3h,067h,01dh,05ah,092h,0dbh,0d2h,052h,0e9h,010h,056h,033h,06dh,0d6h,047h,013h
		db 09ah,0d7h,061h,08ch,037h,0a1h,00ch,07ah,059h,0f8h,014h,08eh,0ebh,013h,03ch,089h
		db 0ceh,0a9h,027h,0eeh,0b7h,061h,0c9h,035h,0e1h,01ch,0e5h,0edh,07ah,047h,0b1h,03ch
		db 09ch,0d2h,0dfh,059h,055h,0f2h,073h,03fh,018h,014h,0ceh,079h,073h,0c7h,037h,0bfh
		db 053h,0f7h,0cdh,0eah,05fh,0fdh,0aah,05bh,0dfh,03dh,06fh,014h,078h,044h,0dbh,086h
		db 0cah,0afh,0f3h,081h,0b9h,068h,0c4h,03eh,038h,024h,034h,02ch,0c2h,0a3h,040h,05fh
		db 016h,01dh,0c3h,072h,0bch,0e2h,025h,00ch,028h,03ch,049h,08bh,0ffh,00dh,095h,041h
		db 039h,0a8h,001h,071h,008h,00ch,0b3h,0deh,0d8h,0b4h,0e4h,09ch,064h,056h,0c1h,090h
		db 07bh,0cbh,084h,061h,0d5h,032h,0b6h,070h,048h,06ch,05ch,074h,0d0h,0b8h,057h,042h
	
	Td1	db 050h,051h,0f4h,0a7h,053h,07eh,041h,065h,0c3h,01ah,017h,0a4h,096h,03ah,027h,05eh
		db 0cbh,03bh,0abh,06bh,0f1h,01fh,09dh,045h,0abh,0ach,0fah,058h,093h,04bh,0e3h,003h
		db 055h,020h,030h,0fah,0f6h,0adh,076h,06dh,091h,088h,0cch,076h,025h,0f5h,002h,04ch
		db 0fch,04fh,0e5h,0d7h,0d7h,0c5h,02ah,0cbh,080h,026h,035h,044h,08fh,0b5h,062h,0a3h
		db 049h,0deh,0b1h,05ah,067h,025h,0bah,01bh,098h,045h,0eah,00eh,0e1h,05dh,0feh,0c0h
		db 002h,0c3h,02fh,075h,012h,081h,04ch,0f0h,0a3h,08dh,046h,097h,0c6h,06bh,0d3h,0f9h
		db 0e7h,003h,08fh,05fh,095h,015h,092h,09ch,0ebh,0bfh,06dh,07ah,0dah,095h,052h,059h
		db 02dh,0d4h,0beh,083h,0d3h,058h,074h,021h,029h,049h,0e0h,069h,044h,08eh,0c9h,0c8h
		db 06ah,075h,0c2h,089h,078h,0f4h,08eh,079h,06bh,099h,058h,03eh,0ddh,027h,0b9h,071h
		db 0b6h,0beh,0e1h,04fh,017h,0f0h,088h,0adh,066h,0c9h,020h,0ach,0b4h,07dh,0ceh,03ah
		db 018h,063h,0dfh,04ah,082h,0e5h,01ah,031h,060h,097h,051h,033h,045h,062h,053h,07fh
		db 0e0h,0b1h,064h,077h,084h,0bbh,06bh,0aeh,01ch,0feh,081h,0a0h,094h,0f9h,008h,02bh
		db 058h,070h,048h,068h,019h,08fh,045h,0fdh,087h,094h,0deh,06ch,0b7h,052h,07bh,0f8h
		db 023h,0abh,073h,0d3h,0e2h,072h,04bh,002h,057h,0e3h,01fh,08fh,02ah,066h,055h,0abh
		db 007h,0b2h,0ebh,028h,003h,02fh,0b5h,0c2h,09ah,086h,0c5h,07bh,0a5h,0d3h,037h,008h
		db 0f2h,030h,028h,087h,0b2h,023h,0bfh,0a5h,0bah,002h,003h,06ah,05ch,0edh,016h,082h
		db 02bh,08ah,0cfh,01ch,092h,0a7h,079h,0b4h,0f0h,0f3h,007h,0f2h,0a1h,04eh,069h,0e2h
		db 0cdh,065h,0dah,0f4h,0d5h,006h,005h,0beh,01fh,0d1h,034h,062h,08ah,0c4h,0a6h,0feh
		db 09dh,034h,02eh,053h,0a0h,0a2h,0f3h,055h,032h,005h,08ah,0e1h,075h,0a4h,0f6h,0ebh
		db 039h,00bh,083h,0ech,0aah,040h,060h,0efh,006h,05eh,071h,09fh,051h,0bdh,06eh,010h
		db 0f9h,03eh,021h,08ah,03dh,096h,0ddh,006h,0aeh,0ddh,03eh,005h,046h,04dh,0e6h,0bdh
		db 0b5h,091h,054h,08dh,005h,071h,0c4h,05dh,06fh,004h,006h,0d4h,0ffh,060h,050h,015h
		db 024h,019h,098h,0fbh,097h,0d6h,0bdh,0e9h,0cch,089h,040h,043h,077h,067h,0d9h,09eh
		db 0bdh,0b0h,0e8h,042h,088h,007h,089h,08bh,038h,0e7h,019h,05bh,0dbh,079h,0c8h,0eeh
		db 047h,0a1h,07ch,00ah,0e9h,07ch,042h,00fh,0c9h,0f8h,084h,01eh,000h,000h,000h,000h
		db 083h,009h,080h,086h,048h,032h,02bh,0edh,0ach,01eh,011h,070h,04eh,06ch,05ah,072h
		db 0fbh,0fdh,00eh,0ffh,056h,00fh,085h,038h,01eh,03dh,0aeh,0d5h,027h,036h,02dh,039h
		db 064h,00ah,00fh,0d9h,021h,068h,05ch,0a6h,0d1h,09bh,05bh,054h,03ah,024h,036h,02eh
		db 0b1h,00ch,00ah,067h,00fh,093h,057h,0e7h,0d2h,0b4h,0eeh,096h,09eh,01bh,09bh,091h
		db 04fh,080h,0c0h,0c5h,0a2h,061h,0dch,020h,069h,05ah,077h,04bh,016h,01ch,012h,01ah
		db 00ah,0e2h,093h,0bah,0e5h,0c0h,0a0h,02ah,043h,03ch,022h,0e0h,01dh,012h,01bh,017h
		db 00bh,00eh,009h,00dh,0adh,0f2h,08bh,0c7h,0b9h,02dh,0b6h,0a8h,0c8h,014h,01eh,0a9h
		db 085h,057h,0f1h,019h,04ch,0afh,075h,007h,0bbh,0eeh,099h,0ddh,0fdh,0a3h,07fh,060h
		db 09fh,0f7h,001h,026h,0bch,05ch,072h,0f5h,0c5h,044h,066h,03bh,034h,05bh,0fbh,07eh
		db 076h,08bh,043h,029h,0dch,0cbh,023h,0c6h,068h,0b6h,0edh,0fch,063h,0b8h,0e4h,0f1h
		db 0cah,0d7h,031h,0dch,010h,042h,063h,085h,040h,013h,097h,022h,020h,084h,0c6h,011h
		db 07dh,085h,04ah,024h,0f8h,0d2h,0bbh,03dh,011h,0aeh,0f9h,032h,06dh,0c7h,029h,0a1h
		db 04bh,01dh,09eh,02fh,0f3h,0dch,0b2h,030h,0ech,00dh,086h,052h,0d0h,077h,0c1h,0e3h
		db 06ch,02bh,0b3h,016h,099h,0a9h,070h,0b9h,0fah,011h,094h,048h,022h,047h,0e9h,064h
		db 0c4h,0a8h,0fch,08ch,01ah,0a0h,0f0h,03fh,0d8h,056h,07dh,02ch,0efh,022h,033h,090h
		db 0c7h,087h,049h,04eh,0c1h,0d9h,038h,0d1h,0feh,08ch,0cah,0a2h,036h,098h,0d4h,00bh
		db 0cfh,0a6h,0f5h,081h,028h,0a5h,07ah,0deh,026h,0dah,0b7h,08eh,0a4h,03fh,0adh,0bfh
		db 0e4h,02ch,03ah,09dh,00dh,050h,078h,092h,09bh,06ah,05fh,0cch,062h,054h,07eh,046h
		db 0c2h,0f6h,08dh,013h,0e8h,090h,0d8h,0b8h,05eh,02eh,039h,0f7h,0f5h,082h,0c3h,0afh
		db 0beh,09fh,05dh,080h,07ch,069h,0d0h,093h,0a9h,06fh,0d5h,02dh,0b3h,0cfh,025h,012h
		db 03bh,0c8h,0ach,099h,0a7h,010h,018h,07dh,06eh,0e8h,09ch,063h,07bh,0dbh,03bh,0bbh
		db 009h,0cdh,026h,078h,0f4h,06eh,059h,018h,001h,0ech,09ah,0b7h,0a8h,083h,04fh,09ah
		db 065h,0e6h,095h,06eh,07eh,0aah,0ffh,0e6h,008h,021h,0bch,0cfh,0e6h,0efh,015h,0e8h
		db 0d9h,0bah,0e7h,09bh,0ceh,04ah,06fh,036h,0d4h,0eah,09fh,009h,0d6h,029h,0b0h,07ch
		db 0afh,031h,0a4h,0b2h,031h,02ah,03fh,023h,030h,0c6h,0a5h,094h,0c0h,035h,0a2h,066h
		db 037h,074h,04eh,0bch,0a6h,0fch,082h,0cah,0b0h,0e0h,090h,0d0h,015h,033h,0a7h,0d8h
		db 04ah,0f1h,004h,098h,0f7h,041h,0ech,0dah,00eh,07fh,0cdh,050h,02fh,017h,091h,0f6h
		db 08dh,076h,04dh,0d6h,04dh,043h,0efh,0b0h,054h,0cch,0aah,04dh,0dfh,0e4h,096h,004h
		db 0e3h,09eh,0d1h,0b5h,01bh,04ch,06ah,088h,0b8h,0c1h,02ch,01fh,07fh,046h,065h,051h
		db 004h,09dh,05eh,0eah,05dh,001h,08ch,035h,073h,0fah,087h,074h,02eh,0fbh,00bh,041h
		db 05ah,0b3h,067h,01dh,052h,092h,0dbh,0d2h,033h,0e9h,010h,056h,013h,06dh,0d6h,047h
		db 08ch,09ah,0d7h,061h,07ah,037h,0a1h,00ch,08eh,059h,0f8h,014h,089h,0ebh,013h,03ch
		db 0eeh,0ceh,0a9h,027h,035h,0b7h,061h,0c9h,0edh,0e1h,01ch,0e5h,03ch,07ah,047h,0b1h
		db 059h,09ch,0d2h,0dfh,03fh,055h,0f2h,073h,079h,018h,014h,0ceh,0bfh,073h,0c7h,037h
		db 0eah,053h,0f7h,0cdh,05bh,05fh,0fdh,0aah,014h,0dfh,03dh,06fh,086h,078h,044h,0dbh
		db 081h,0cah,0afh,0f3h,03eh,0b9h,068h,0c4h,02ch,038h,024h,034h,05fh,0c2h,0a3h,040h
		db 072h,016h,01dh,0c3h,00ch,0bch,0e2h,025h,08bh,028h,03ch,049h,041h,0ffh,00dh,095h
		db 071h,039h,0a8h,001h,0deh,008h,00ch,0b3h,09ch,0d8h,0b4h,0e4h,090h,064h,056h,0c1h
		db 061h,07bh,0cbh,084h,070h,0d5h,032h,0b6h,074h,048h,06ch,05ch,042h,0d0h,0b8h,057h
	
	Td2	db 0a7h,050h,051h,0f4h,065h,053h,07eh,041h,0a4h,0c3h,01ah,017h,05eh,096h,03ah,027h
		db 06bh,0cbh,03bh,0abh,045h,0f1h,01fh,09dh,058h,0abh,0ach,0fah,003h,093h,04bh,0e3h
		db 0fah,055h,020h,030h,06dh,0f6h,0adh,076h,076h,091h,088h,0cch,04ch,025h,0f5h,002h
		db 0d7h,0fch,04fh,0e5h,0cbh,0d7h,0c5h,02ah,044h,080h,026h,035h,0a3h,08fh,0b5h,062h
		db 05ah,049h,0deh,0b1h,01bh,067h,025h,0bah,00eh,098h,045h,0eah,0c0h,0e1h,05dh,0feh
		db 075h,002h,0c3h,02fh,0f0h,012h,081h,04ch,097h,0a3h,08dh,046h,0f9h,0c6h,06bh,0d3h
		db 05fh,0e7h,003h,08fh,09ch,095h,015h,092h,07ah,0ebh,0bfh,06dh,059h,0dah,095h,052h
		db 083h,02dh,0d4h,0beh,021h,0d3h,058h,074h,069h,029h,049h,0e0h,0c8h,044h,08eh,0c9h
		db 089h,06ah,075h,0c2h,079h,078h,0f4h,08eh,03eh,06bh,099h,058h,071h,0ddh,027h,0b9h
		db 04fh,0b6h,0beh,0e1h,0adh,017h,0f0h,088h,0ach,066h,0c9h,020h,03ah,0b4h,07dh,0ceh
		db 04ah,018h,063h,0dfh,031h,082h,0e5h,01ah,033h,060h,097h,051h,07fh,045h,062h,053h
		db 077h,0e0h,0b1h,064h,0aeh,084h,0bbh,06bh,0a0h,01ch,0feh,081h,02bh,094h,0f9h,008h
		db 068h,058h,070h,048h,0fdh,019h,08fh,045h,06ch,087h,094h,0deh,0f8h,0b7h,052h,07bh
		db 0d3h,023h,0abh,073h,002h,0e2h,072h,04bh,08fh,057h,0e3h,01fh,0abh,02ah,066h,055h
		db 028h,007h,0b2h,0ebh,0c2h,003h,02fh,0b5h,07bh,09ah,086h,0c5h,008h,0a5h,0d3h,037h
		db 087h,0f2h,030h,028h,0a5h,0b2h,023h,0bfh,06ah,0bah,002h,003h,082h,05ch,0edh,016h
		db 01ch,02bh,08ah,0cfh,0b4h,092h,0a7h,079h,0f2h,0f0h,0f3h,007h,0e2h,0a1h,04eh,069h
		db 0f4h,0cdh,065h,0dah,0beh,0d5h,006h,005h,062h,01fh,0d1h,034h,0feh,08ah,0c4h,0a6h
		db 053h,09dh,034h,02eh,055h,0a0h,0a2h,0f3h,0e1h,032h,005h,08ah,0ebh,075h,0a4h,0f6h
		db 0ech,039h,00bh,083h,0efh,0aah,040h,060h,09fh,006h,05eh,071h,010h,051h,0bdh,06eh
		db 08ah,0f9h,03eh,021h,006h,03dh,096h,0ddh,005h,0aeh,0ddh,03eh,0bdh,046h,04dh,0e6h
		db 08dh,0b5h,091h,054h,05dh,005h,071h,0c4h,0d4h,06fh,004h,006h,015h,0ffh,060h,050h
		db 0fbh,024h,019h,098h,0e9h,097h,0d6h,0bdh,043h,0cch,089h,040h,09eh,077h,067h,0d9h
		db 042h,0bdh,0b0h,0e8h,08bh,088h,007h,089h,05bh,038h,0e7h,019h,0eeh,0dbh,079h,0c8h
		db 00ah,047h,0a1h,07ch,00fh,0e9h,07ch,042h,01eh,0c9h,0f8h,084h,000h,000h,000h,000h
		db 086h,083h,009h,080h,0edh,048h,032h,02bh,070h,0ach,01eh,011h,072h,04eh,06ch,05ah
		db 0ffh,0fbh,0fdh,00eh,038h,056h,00fh,085h,0d5h,01eh,03dh,0aeh,039h,027h,036h,02dh
		db 0d9h,064h,00ah,00fh,0a6h,021h,068h,05ch,054h,0d1h,09bh,05bh,02eh,03ah,024h,036h
		db 067h,0b1h,00ch,00ah,0e7h,00fh,093h,057h,096h,0d2h,0b4h,0eeh,091h,09eh,01bh,09bh
		db 0c5h,04fh,080h,0c0h,020h,0a2h,061h,0dch,04bh,069h,05ah,077h,01ah,016h,01ch,012h
		db 0bah,00ah,0e2h,093h,02ah,0e5h,0c0h,0a0h,0e0h,043h,03ch,022h,017h,01dh,012h,01bh
		db 00dh,00bh,00eh,009h,0c7h,0adh,0f2h,08bh,0a8h,0b9h,02dh,0b6h,0a9h,0c8h,014h,01eh
		db 019h,085h,057h,0f1h,007h,04ch,0afh,075h,0ddh,0bbh,0eeh,099h,060h,0fdh,0a3h,07fh
		db 026h,09fh,0f7h,001h,0f5h,0bch,05ch,072h,03bh,0c5h,044h,066h,07eh,034h,05bh,0fbh
		db 029h,076h,08bh,043h,0c6h,0dch,0cbh,023h,0fch,068h,0b6h,0edh,0f1h,063h,0b8h,0e4h
		db 0dch,0cah,0d7h,031h,085h,010h,042h,063h,022h,040h,013h,097h,011h,020h,084h,0c6h
		db 024h,07dh,085h,04ah,03dh,0f8h,0d2h,0bbh,032h,011h,0aeh,0f9h,0a1h,06dh,0c7h,029h
		db 02fh,04bh,01dh,09eh,030h,0f3h,0dch,0b2h,052h,0ech,00dh,086h,0e3h,0d0h,077h,0c1h
		db 016h,06ch,02bh,0b3h,0b9h,099h,0a9h,070h,048h,0fah,011h,094h,064h,022h,047h,0e9h
		db 08ch,0c4h,0a8h,0fch,03fh,01ah,0a0h,0f0h,02ch,0d8h,056h,07dh,090h,0efh,022h,033h
		db 04eh,0c7h,087h,049h,0d1h,0c1h,0d9h,038h,0a2h,0feh,08ch,0cah,00bh,036h,098h,0d4h
		db 081h,0cfh,0a6h,0f5h,0deh,028h,0a5h,07ah,08eh,026h,0dah,0b7h,0bfh,0a4h,03fh,0adh
		db 09dh,0e4h,02ch,03ah,092h,00dh,050h,078h,0cch,09bh,06ah,05fh,046h,062h,054h,07eh
		db 013h,0c2h,0f6h,08dh,0b8h,0e8h,090h,0d8h,0f7h,05eh,02eh,039h,0afh,0f5h,082h,0c3h
		db 080h,0beh,09fh,05dh,093h,07ch,069h,0d0h,02dh,0a9h,06fh,0d5h,012h,0b3h,0cfh,025h
		db 099h,03bh,0c8h,0ach,07dh,0a7h,010h,018h,063h,06eh,0e8h,09ch,0bbh,07bh,0dbh,03bh
		db 078h,009h,0cdh,026h,018h,0f4h,06eh,059h,0b7h,001h,0ech,09ah,09ah,0a8h,083h,04fh
		db 06eh,065h,0e6h,095h,0e6h,07eh,0aah,0ffh,0cfh,008h,021h,0bch,0e8h,0e6h,0efh,015h
		db 09bh,0d9h,0bah,0e7h,036h,0ceh,04ah,06fh,009h,0d4h,0eah,09fh,07ch,0d6h,029h,0b0h
		db 0b2h,0afh,031h,0a4h,023h,031h,02ah,03fh,094h,030h,0c6h,0a5h,066h,0c0h,035h,0a2h
		db 0bch,037h,074h,04eh,0cah,0a6h,0fch,082h,0d0h,0b0h,0e0h,090h,0d8h,015h,033h,0a7h
		db 098h,04ah,0f1h,004h,0dah,0f7h,041h,0ech,050h,00eh,07fh,0cdh,0f6h,02fh,017h,091h
		db 0d6h,08dh,076h,04dh,0b0h,04dh,043h,0efh,04dh,054h,0cch,0aah,004h,0dfh,0e4h,096h
		db 0b5h,0e3h,09eh,0d1h,088h,01bh,04ch,06ah,01fh,0b8h,0c1h,02ch,051h,07fh,046h,065h
		db 0eah,004h,09dh,05eh,035h,05dh,001h,08ch,074h,073h,0fah,087h,041h,02eh,0fbh,00bh
		db 01dh,05ah,0b3h,067h,0d2h,052h,092h,0dbh,056h,033h,0e9h,010h,047h,013h,06dh,0d6h
		db 061h,08ch,09ah,0d7h,00ch,07ah,037h,0a1h,014h,08eh,059h,0f8h,03ch,089h,0ebh,013h
		db 027h,0eeh,0ceh,0a9h,0c9h,035h,0b7h,061h,0e5h,0edh,0e1h,01ch,0b1h,03ch,07ah,047h
		db 0dfh,059h,09ch,0d2h,073h,03fh,055h,0f2h,0ceh,079h,018h,014h,037h,0bfh,073h,0c7h
		db 0cdh,0eah,053h,0f7h,0aah,05bh,05fh,0fdh,06fh,014h,0dfh,03dh,0dbh,086h,078h,044h
		db 0f3h,081h,0cah,0afh,0c4h,03eh,0b9h,068h,034h,02ch,038h,024h,040h,05fh,0c2h,0a3h
		db 0c3h,072h,016h,01dh,025h,00ch,0bch,0e2h,049h,08bh,028h,03ch,095h,041h,0ffh,00dh
		db 001h,071h,039h,0a8h,0b3h,0deh,008h,00ch,0e4h,09ch,0d8h,0b4h,0c1h,090h,064h,056h
		db 084h,061h,07bh,0cbh,0b6h,070h,0d5h,032h,05ch,074h,048h,06ch,057h,042h,0d0h,0b8h
	
	Td3	db 0f4h,0a7h,050h,051h,041h,065h,053h,07eh,017h,0a4h,0c3h,01ah,027h,05eh,096h,03ah
		db 0abh,06bh,0cbh,03bh,09dh,045h,0f1h,01fh,0fah,058h,0abh,0ach,0e3h,003h,093h,04bh
		db 030h,0fah,055h,020h,076h,06dh,0f6h,0adh,0cch,076h,091h,088h,002h,04ch,025h,0f5h
		db 0e5h,0d7h,0fch,04fh,02ah,0cbh,0d7h,0c5h,035h,044h,080h,026h,062h,0a3h,08fh,0b5h
		db 0b1h,05ah,049h,0deh,0bah,01bh,067h,025h,0eah,00eh,098h,045h,0feh,0c0h,0e1h,05dh
		db 02fh,075h,002h,0c3h,04ch,0f0h,012h,081h,046h,097h,0a3h,08dh,0d3h,0f9h,0c6h,06bh
		db 08fh,05fh,0e7h,003h,092h,09ch,095h,015h,06dh,07ah,0ebh,0bfh,052h,059h,0dah,095h
		db 0beh,083h,02dh,0d4h,074h,021h,0d3h,058h,0e0h,069h,029h,049h,0c9h,0c8h,044h,08eh
		db 0c2h,089h,06ah,075h,08eh,079h,078h,0f4h,058h,03eh,06bh,099h,0b9h,071h,0ddh,027h
		db 0e1h,04fh,0b6h,0beh,088h,0adh,017h,0f0h,020h,0ach,066h,0c9h,0ceh,03ah,0b4h,07dh
		db 0dfh,04ah,018h,063h,01ah,031h,082h,0e5h,051h,033h,060h,097h,053h,07fh,045h,062h
		db 064h,077h,0e0h,0b1h,06bh,0aeh,084h,0bbh,081h,0a0h,01ch,0feh,008h,02bh,094h,0f9h
		db 048h,068h,058h,070h,045h,0fdh,019h,08fh,0deh,06ch,087h,094h,07bh,0f8h,0b7h,052h
		db 073h,0d3h,023h,0abh,04bh,002h,0e2h,072h,01fh,08fh,057h,0e3h,055h,0abh,02ah,066h
		db 0ebh,028h,007h,0b2h,0b5h,0c2h,003h,02fh,0c5h,07bh,09ah,086h,037h,008h,0a5h,0d3h
		db 028h,087h,0f2h,030h,0bfh,0a5h,0b2h,023h,003h,06ah,0bah,002h,016h,082h,05ch,0edh
		db 0cfh,01ch,02bh,08ah,079h,0b4h,092h,0a7h,007h,0f2h,0f0h,0f3h,069h,0e2h,0a1h,04eh
		db 0dah,0f4h,0cdh,065h,005h,0beh,0d5h,006h,034h,062h,01fh,0d1h,0a6h,0feh,08ah,0c4h
		db 02eh,053h,09dh,034h,0f3h,055h,0a0h,0a2h,08ah,0e1h,032h,005h,0f6h,0ebh,075h,0a4h
		db 083h,0ech,039h,00bh,060h,0efh,0aah,040h,071h,09fh,006h,05eh,06eh,010h,051h,0bdh
		db 021h,08ah,0f9h,03eh,0ddh,006h,03dh,096h,03eh,005h,0aeh,0ddh,0e6h,0bdh,046h,04dh
		db 054h,08dh,0b5h,091h,0c4h,05dh,005h,071h,006h,0d4h,06fh,004h,050h,015h,0ffh,060h
		db 098h,0fbh,024h,019h,0bdh,0e9h,097h,0d6h,040h,043h,0cch,089h,0d9h,09eh,077h,067h
		db 0e8h,042h,0bdh,0b0h,089h,08bh,088h,007h,019h,05bh,038h,0e7h,0c8h,0eeh,0dbh,079h
		db 07ch,00ah,047h,0a1h,042h,00fh,0e9h,07ch,084h,01eh,0c9h,0f8h,000h,000h,000h,000h
		db 080h,086h,083h,009h,02bh,0edh,048h,032h,011h,070h,0ach,01eh,05ah,072h,04eh,06ch
		db 00eh,0ffh,0fbh,0fdh,085h,038h,056h,00fh,0aeh,0d5h,01eh,03dh,02dh,039h,027h,036h
		db 00fh,0d9h,064h,00ah,05ch,0a6h,021h,068h,05bh,054h,0d1h,09bh,036h,02eh,03ah,024h
		db 00ah,067h,0b1h,00ch,057h,0e7h,00fh,093h,0eeh,096h,0d2h,0b4h,09bh,091h,09eh,01bh
		db 0c0h,0c5h,04fh,080h,0dch,020h,0a2h,061h,077h,04bh,069h,05ah,012h,01ah,016h,01ch
		db 093h,0bah,00ah,0e2h,0a0h,02ah,0e5h,0c0h,022h,0e0h,043h,03ch,01bh,017h,01dh,012h
		db 009h,00dh,00bh,00eh,08bh,0c7h,0adh,0f2h,0b6h,0a8h,0b9h,02dh,01eh,0a9h,0c8h,014h
		db 0f1h,019h,085h,057h,075h,007h,04ch,0afh,099h,0ddh,0bbh,0eeh,07fh,060h,0fdh,0a3h
		db 001h,026h,09fh,0f7h,072h,0f5h,0bch,05ch,066h,03bh,0c5h,044h,0fbh,07eh,034h,05bh
		db 043h,029h,076h,08bh,023h,0c6h,0dch,0cbh,0edh,0fch,068h,0b6h,0e4h,0f1h,063h,0b8h
		db 031h,0dch,0cah,0d7h,063h,085h,010h,042h,097h,022h,040h,013h,0c6h,011h,020h,084h
		db 04ah,024h,07dh,085h,0bbh,03dh,0f8h,0d2h,0f9h,032h,011h,0aeh,029h,0a1h,06dh,0c7h
		db 09eh,02fh,04bh,01dh,0b2h,030h,0f3h,0dch,086h,052h,0ech,00dh,0c1h,0e3h,0d0h,077h
		db 0b3h,016h,06ch,02bh,070h,0b9h,099h,0a9h,094h,048h,0fah,011h,0e9h,064h,022h,047h
		db 0fch,08ch,0c4h,0a8h,0f0h,03fh,01ah,0a0h,07dh,02ch,0d8h,056h,033h,090h,0efh,022h
		db 049h,04eh,0c7h,087h,038h,0d1h,0c1h,0d9h,0cah,0a2h,0feh,08ch,0d4h,00bh,036h,098h
		db 0f5h,081h,0cfh,0a6h,07ah,0deh,028h,0a5h,0b7h,08eh,026h,0dah,0adh,0bfh,0a4h,03fh
		db 03ah,09dh,0e4h,02ch,078h,092h,00dh,050h,05fh,0cch,09bh,06ah,07eh,046h,062h,054h
		db 08dh,013h,0c2h,0f6h,0d8h,0b8h,0e8h,090h,039h,0f7h,05eh,02eh,0c3h,0afh,0f5h,082h
		db 05dh,080h,0beh,09fh,0d0h,093h,07ch,069h,0d5h,02dh,0a9h,06fh,025h,012h,0b3h,0cfh
		db 0ach,099h,03bh,0c8h,018h,07dh,0a7h,010h,09ch,063h,06eh,0e8h,03bh,0bbh,07bh,0dbh
		db 026h,078h,009h,0cdh,059h,018h,0f4h,06eh,09ah,0b7h,001h,0ech,04fh,09ah,0a8h,083h
		db 095h,06eh,065h,0e6h,0ffh,0e6h,07eh,0aah,0bch,0cfh,008h,021h,015h,0e8h,0e6h,0efh
		db 0e7h,09bh,0d9h,0bah,06fh,036h,0ceh,04ah,09fh,009h,0d4h,0eah,0b0h,07ch,0d6h,029h
		db 0a4h,0b2h,0afh,031h,03fh,023h,031h,02ah,0a5h,094h,030h,0c6h,0a2h,066h,0c0h,035h
		db 04eh,0bch,037h,074h,082h,0cah,0a6h,0fch,090h,0d0h,0b0h,0e0h,0a7h,0d8h,015h,033h
		db 004h,098h,04ah,0f1h,0ech,0dah,0f7h,041h,0cdh,050h,00eh,07fh,091h,0f6h,02fh,017h
		db 04dh,0d6h,08dh,076h,0efh,0b0h,04dh,043h,0aah,04dh,054h,0cch,096h,004h,0dfh,0e4h
		db 0d1h,0b5h,0e3h,09eh,06ah,088h,01bh,04ch,02ch,01fh,0b8h,0c1h,065h,051h,07fh,046h
		db 05eh,0eah,004h,09dh,08ch,035h,05dh,001h,087h,074h,073h,0fah,00bh,041h,02eh,0fbh
		db 067h,01dh,05ah,0b3h,0dbh,0d2h,052h,092h,010h,056h,033h,0e9h,0d6h,047h,013h,06dh
		db 0d7h,061h,08ch,09ah,0a1h,00ch,07ah,037h,0f8h,014h,08eh,059h,013h,03ch,089h,0ebh
		db 0a9h,027h,0eeh,0ceh,061h,0c9h,035h,0b7h,01ch,0e5h,0edh,0e1h,047h,0b1h,03ch,07ah
		db 0d2h,0dfh,059h,09ch,0f2h,073h,03fh,055h,014h,0ceh,079h,018h,0c7h,037h,0bfh,073h
		db 0f7h,0cdh,0eah,053h,0fdh,0aah,05bh,05fh,03dh,06fh,014h,0dfh,044h,0dbh,086h,078h
		db 0afh,0f3h,081h,0cah,068h,0c4h,03eh,0b9h,024h,034h,02ch,038h,0a3h,040h,05fh,0c2h
		db 01dh,0c3h,072h,016h,0e2h,025h,00ch,0bch,03ch,049h,08bh,028h,00dh,095h,041h,0ffh
		db 0a8h,001h,071h,039h,00ch,0b3h,0deh,008h,0b4h,0e4h,09ch,0d8h,056h,0c1h,090h,064h
		db 0cbh,084h,061h,07bh,032h,0b6h,070h,0d5h,06ch,05ch,074h,048h,0b8h,057h,042h,0d0h
	ENDIF

	sBox	db 063h,07ch,077h,07bh,0f2h,06bh,06fh,0c5h,030h,001h,067h,02bh,0feh,0d7h,0abh,076h
		db 0cah,082h,0c9h,07dh,0fah,059h,047h,0f0h,0adh,0d4h,0a2h,0afh,09ch,0a4h,072h,0c0h
		db 0b7h,0fdh,093h,026h,036h,03fh,0f7h,0cch,034h,0a5h,0e5h,0f1h,071h,0d8h,031h,015h
		db 004h,0c7h,023h,0c3h,018h,096h,005h,09ah,007h,012h,080h,0e2h,0ebh,027h,0b2h,075h
		db 009h,083h,02ch,01ah,01bh,06eh,05ah,0a0h,052h,03bh,0d6h,0b3h,029h,0e3h,02fh,084h
		db 053h,0d1h,000h,0edh,020h,0fch,0b1h,05bh,06ah,0cbh,0beh,039h,04ah,04ch,058h,0cfh
		db 0d0h,0efh,0aah,0fbh,043h,04dh,033h,085h,045h,0f9h,002h,07fh,050h,03ch,09fh,0a8h
		db 051h,0a3h,040h,08fh,092h,09dh,038h,0f5h,0bch,0b6h,0dah,021h,010h,0ffh,0f3h,0d2h
		db 0cdh,00ch,013h,0ech,05fh,097h,044h,017h,0c4h,0a7h,07eh,03dh,064h,05dh,019h,073h
		db 060h,081h,04fh,0dch,022h,02ah,090h,088h,046h,0eeh,0b8h,014h,0deh,05eh,00bh,0dbh
		db 0e0h,032h,03ah,00ah,049h,006h,024h,05ch,0c2h,0d3h,0ach,062h,091h,095h,0e4h,079h
		db 0e7h,0c8h,037h,06dh,08dh,0d5h,04eh,0a9h,06ch,056h,0f4h,0eah,065h,07ah,0aeh,008h
		db 0bah,078h,025h,02eh,01ch,0a6h,0b4h,0c6h,0e8h,0ddh,074h,01fh,04bh,0bdh,08bh,08ah
		db 070h,03eh,0b5h,066h,048h,003h,0f6h,00eh,061h,035h,057h,0b9h,086h,0c1h,01dh,09eh
		db 0e1h,0f8h,098h,011h,069h,0d9h,08eh,094h,09bh,01eh,087h,0e9h,0ceh,055h,028h,0dfh
		db 08ch,0a1h,089h,00dh,0bfh,0e6h,042h,068h,041h,099h,02dh,00fh,0b0h,054h,0bbh,016h

	IF ((ACTION eq DEC_ONLY) OR (ACTION eq ALL))
	iBox	db 052h,009h,06ah,0d5h,030h,036h,0a5h,038h,0bfh,040h,0a3h,09eh,081h,0f3h,0d7h,0fbh
		db 07ch,0e3h,039h,082h,09bh,02fh,0ffh,087h,034h,08eh,043h,044h,0c4h,0deh,0e9h,0cbh
		db 054h,07bh,094h,032h,0a6h,0c2h,023h,03dh,0eeh,04ch,095h,00bh,042h,0fah,0c3h,04eh
		db 008h,02eh,0a1h,066h,028h,0d9h,024h,0b2h,076h,05bh,0a2h,049h,06dh,08bh,0d1h,025h
		db 072h,0f8h,0f6h,064h,086h,068h,098h,016h,0d4h,0a4h,05ch,0cch,05dh,065h,0b6h,092h
		db 06ch,070h,048h,050h,0fdh,0edh,0b9h,0dah,05eh,015h,046h,057h,0a7h,08dh,09dh,084h
		db 090h,0d8h,0abh,000h,08ch,0bch,0d3h,00ah,0f7h,0e4h,058h,005h,0b8h,0b3h,045h,006h
		db 0d0h,02ch,01eh,08fh,0cah,03fh,00fh,002h,0c1h,0afh,0bdh,003h,001h,013h,08ah,06bh
		db 03ah,091h,011h,041h,04fh,067h,0dch,0eah,097h,0f2h,0cfh,0ceh,0f0h,0b4h,0e6h,073h
		db 096h,0ach,074h,022h,0e7h,0adh,035h,085h,0e2h,0f9h,037h,0e8h,01ch,075h,0dfh,06eh
		db 047h,0f1h,01ah,071h,01dh,029h,0c5h,089h,06fh,0b7h,062h,00eh,0aah,018h,0beh,01bh
		db 0fch,056h,03eh,04bh,0c6h,0d2h,079h,020h,09ah,0dbh,0c0h,0feh,078h,0cdh,05ah,0f4h
		db 01fh,0ddh,0a8h,033h,088h,007h,0c7h,031h,0b1h,012h,010h,059h,027h,080h,0ech,05fh
		db 060h,051h,07fh,0a9h,019h,0b5h,04ah,00dh,02dh,0e5h,07ah,09fh,093h,0c9h,09ch,0efh
		db 0a0h,0e0h,03bh,04dh,0aeh,02ah,0f5h,0b0h,0c8h,0ebh,0bbh,03ch,083h,053h,099h,061h
		db 017h,02bh,004h,07eh,0bah,077h,0d6h,026h,0e1h,069h,014h,063h,055h,021h,00ch,07dh
	ENDIF
ENDIF

.code
OPTION PROLOGUE:None
OPTION EPILOGUE:None

IF	(TABLES	eq DYNAMIC)

	Rijndael_Init		proc
	
		pushad
	
		xor	eax, eax
		xor	ecx, ecx
		inc	al
		
	@loop:	mov	byte ptr [powTab+ecx], al
		mov	byte ptr [logTab+eax], cl
		mov	dl, al
		shl	dl, 1
		jnc	@F
		xor	al, 1Bh
	@@:	xor	al, dl
		inc	cl
		jnz	@loop
		and	byte ptr [logTab+1], 0
	
		xor	eax, eax
		jmp	@zero
	@@:	mov	al, byte ptr [logTab+ecx]
		not	al
		mov	al, byte ptr [powTab+eax]
	@zero:	mov	dl, al
		rol	dl, 1
		xor	al, dl
		rol	dl, 1
		xor	al, dl
		rol	dl, 1
		xor	al, dl
		rol	dl, 1
		xor	al, dl
		xor	al, 63h

		IF ((ACTION eq DEC_ONLY) OR (ACTION eq ALL))
		mov	byte ptr [iBox+eax], cl
		ENDIF
		
		mov	byte ptr [sBox+ecx], al
		inc	cl
		jnz	@B

		@bloop:

		IF ((ACTION eq ENC_ONLY) OR (ACTION eq ALL))
		;-boxes-for-encryption -> start

			movzx	edx, byte ptr [sBox+ecx]
			xor	ebx, ebx
			test	edx, edx
			jz	@F
			mov	dh, byte ptr [logTab+edx]
			mov	al, dh
			add	al, 19h
			adc	al, 0
			inc	al
			setnz	bh
			sub	al, bh
			mov	bh, byte ptr [powTab+eax]
		
			mov	al, dh
			add	al, 1
			adc	al, 0
			inc	al
			setnz	bl
			sub	al, bl
			mov	bl, byte ptr [powTab+eax]
		
			shl	ebx, 16
		@@:	mov	bh, dl
			mov	bl, dl
		
			mov	dword ptr [Te3+4*ecx], ebx
			ror	ebx, 8
			mov	dword ptr [Te2+4*ecx], ebx
			ror	ebx, 8
			mov	dword ptr [Te1+4*ecx], ebx
			ror	ebx, 8
			mov	dword ptr [Te0+4*ecx], ebx
		
		ENDIF
	
		IF ((ACTION eq DEC_ONLY) OR (ACTION eq ALL))
		;-boxes-for-decryption -> start
		
			movzx	edx, byte ptr [iBox+ecx]
			xor	ebx, ebx
			test	edx, edx
			jz	@F
			mov	dh, byte ptr [logTab+edx]
			mov	al, dh
			add	al, 0DFh
			adc	al, 0
			inc	al
			setnz	bh
			sub	al, bh
			mov	bh, byte ptr [powTab+eax]
		
			mov	al, dh
			add	al, 068h
			adc	al, 0
			inc	al
			setnz	bl
			sub	al, bl
			mov	bl, byte ptr [powTab+eax]
		
			shl	ebx, 16
		
			mov	al, dh
			add	al, 0EEh
			adc	al, 0
			inc	al
			setnz	bh
			sub	al, bh
			mov	bh, byte ptr [powTab+eax]

			mov	al, dh
			add	al, 0C7h
			adc	al, 0
			inc	al
			setnz	bl
			sub	al, bl
			mov	bl, byte ptr [powTab+eax]
		@@:
			mov	dword ptr [Td3+4*ecx], ebx
			ror	ebx, 8
			mov	dword ptr [Td2+4*ecx], ebx
			ror	ebx, 8
			mov	dword ptr [Td1+4*ecx], ebx
			ror	ebx, 8
			mov	dword ptr [Td0+4*ecx], ebx

		ENDIF

		inc	cl
		jnz	@bloop

		popad
		ret
	Rijndael_Init		endp

ENDIF

Rijndael_SetEncryptKey	proc	ptrKey:DWORD

	pushad

	mov	esi, dword ptr [esp+24h]
	mov	edi, offset internalRijndaelEncKey
	mov	ebx, offset sBox

IF	(KEY_SIZE eq 128)

	mov	ecx, dword ptr [esi+ 0]
	mov	edx, dword ptr [esi+ 4]
	mov	dword ptr [edi+ 0], ecx
	mov	dword ptr [edi+ 4], edx
	mov	ecx, dword ptr [esi+ 8]
	mov	eax, dword ptr [esi+12]
	mov	dword ptr [edi+ 8], ecx
	mov	dword ptr [edi+12], eax

	mov	edx, 1
	mov	ecx, 10

@loop:	add	edi, 16
	xlatb
	ror	eax, 8
	xlatb
	ror	eax, 8
	xlatb
	ror	eax, 8
	xlatb
	ror	eax, 16
	xor	eax, edx
	xor	eax, dword ptr [edi-16]
	shl	dl, 1
	mov	dword ptr [edi+ 0], eax
	jnc	@F
	xor	dl, 1Bh
@@:	xor	eax, dword ptr [edi-12]
	mov	dword ptr [edi+ 4], eax
	xor	eax, dword ptr [edi- 8]
	mov	dword ptr [edi+ 8], eax
	xor	eax, dword ptr [edi-4]
	dec	ecx
	mov	dword ptr [edi+12], eax
	jnz	@loop


ELSEIF	(KEY_SIZE eq 192)

	mov	ecx, dword ptr [esi+ 0]
	mov	edx, dword ptr [esi+ 4]
	mov	dword ptr [edi+ 0], ecx
	mov	dword ptr [edi+ 4], edx
	mov	ecx, dword ptr [esi+ 8]
	mov	edx, dword ptr [esi+12]
	mov	dword ptr [edi+ 8], ecx
	mov	dword ptr [edi+12], edx
	mov	ecx, dword ptr [esi+16]
	mov	eax, dword ptr [esi+20]
	mov	dword ptr [edi+16], ecx
	mov	dword ptr [edi+20], eax

	mov	edx, 1
	mov	ecx, 7

@loop:	add	edi, 24
	xlatb
	ror	eax, 8
	xlatb
	ror	eax, 8
	xlatb
	ror	eax, 8
	xlatb
	ror	eax, 16
	xor	eax, edx
	xor	eax, dword ptr [edi-24]
	shl	dl, 1
	mov	dword ptr [edi+ 0], eax
	jnc	@F
	xor	dl, 1Bh
@@:	xor	eax, dword ptr [edi-20]
	mov	dword ptr [edi+ 4], eax
	xor	eax, dword ptr [edi-16]
	mov	dword ptr [edi+ 8], eax
	xor	eax, dword ptr [edi-12]
	mov	dword ptr [edi+12], eax
	xor	eax, dword ptr [edi- 8]
	mov	dword ptr [edi+16], eax
	xor	eax, dword ptr [edi- 4]
	dec	ecx
	mov	dword ptr [edi+20], eax
	jnz	@loop

	xlatb
	ror	eax, 8
	xlatb
	ror	eax, 8
	xlatb
	ror	eax, 8
	xlatb
	ror	eax, 16
	xor	eax, edx
	xor	eax, dword ptr [edi]
	mov	dword ptr [edi+24], eax
	xor	eax, dword ptr [edi+4]
	mov	dword ptr [edi+28], eax
	xor	eax, dword ptr [edi+8]
	mov	dword ptr [edi+32], eax
	xor	eax, dword ptr [edi+12]
	mov	dword ptr [edi+36], eax

ELSEIF	(KEY_SIZE eq 256)

	mov	ecx, dword ptr [esi+ 0]
	mov	edx, dword ptr [esi+ 4]
	mov	dword ptr [edi+ 0], ecx
	mov	dword ptr [edi+ 4], edx
	mov	ecx, dword ptr [esi+ 8]
	mov	edx, dword ptr [esi+12]
	mov	dword ptr [edi+ 8], ecx
	mov	dword ptr [edi+12], edx
	mov	ecx, dword ptr [esi+16]
	mov	edx, dword ptr [esi+20]
	mov	dword ptr [edi+16], ecx
	mov	dword ptr [edi+20], edx
	mov	ecx, dword ptr [esi+24]
	mov	eax, dword ptr [esi+28]
	mov	dword ptr [edi+24], ecx
	mov	dword ptr [edi+28], eax

	mov	edx, 1
	mov	ecx, 6

@loop:	add	edi, 32
	xlatb
	ror	eax, 8
	xlatb
	ror	eax, 8
	xlatb
	ror	eax, 8
	xlatb
	ror	eax, 16
	xor	eax, edx
	xor	eax, dword ptr [edi-32]
	shl	dl, 1
	mov	dword ptr [edi+ 0], eax
	jnc	@F
	xor	dl, 1Bh
@@:	xor	eax, dword ptr [edi-28]
	mov	dword ptr [edi+ 4], eax
	xor	eax, dword ptr [edi-24]
	mov	dword ptr [edi+ 8], eax
	xor	eax, dword ptr [edi-20]
	mov	dword ptr [edi+12], eax

	xlatb
	ror	eax, 8
	xlatb
	ror	eax, 8
	xlatb
	ror	eax, 8
	xlatb
	ror	eax, 8

	xor	eax, dword ptr [edi-16]
	mov	dword ptr [edi+16], eax
	xor	eax, dword ptr [edi-12]
	mov	dword ptr [edi+20], eax
	xor	eax, dword ptr [edi- 8]
	mov	dword ptr [edi+24], eax
	xor	eax, dword ptr [edi- 4]
	dec	ecx
	mov	dword ptr [edi+28], eax
	jnz	@loop

	xlatb
	ror	eax, 8
	xlatb
	ror	eax, 8
	xlatb
	ror	eax, 8
	xlatb
	ror	eax, 16
	xor	eax, edx
	xor	eax, dword ptr [edi]
	mov	dword ptr [edi+32], eax
	xor	eax, dword ptr [edi+4]
	mov	dword ptr [edi+36], eax
	xor	eax, dword ptr [edi+8]
	mov	dword ptr [edi+40], eax
	xor	eax, dword ptr [edi+12]
	mov	dword ptr [edi+44], eax

ENDIF
	popad
	ret	4
Rijndael_SetEncryptKey	endp

IF ((ACTION eq DEC_ONLY) OR (ACTION eq ALL))

	Rijndael_SetDecryptKey	proc	ptrKey:DWORD
	
		pushad
	
		push	dword ptr [esp+24h]
		call	Rijndael_SetEncryptKey

		emms
		mov	esi, offset internalRijndaelEncKey
		mov	edi, offset internalRijndaelDecKey

		movq	mm0, qword ptr [esi+0]
		movq	mm1, qword ptr [esi+8]
		movq	qword ptr [edi+0], mm0
		movq	qword ptr [edi+8], mm1
		add	esi, 16
		add	edi, 16

		movq	mm7, qword ptr [x1B]
		movq	mm6, qword ptr [x7F]
		movq	mm5, qword ptr [x80]
		
		IF	(KEY_SIZE eq 128)
			mov	ecx, 18
		ELSEIF	(KEY_SIZE eq 192)
			mov	ecx, 22
		ELSEIF	(KEY_SIZE eq 256)
			mov	ecx, 26
		ENDIF
		
	@@:	movq	mm0, qword ptr [esi]
		movq	mm1, mm0
		pand	mm0, mm6
		pslld	mm0, 1
		pand	mm1, mm5
		pcmpeqb	mm1, mm5
		pand	mm1, mm7
		pxor	mm0, mm1	;u
	
		movq	mm2, mm0
		movq	mm1, mm0
		pand	mm2, mm6
		pslld	mm2, 1
		pand	mm1, mm5
		pcmpeqb	mm1, mm5
		pand	mm1, mm7
		pxor	mm2, mm1	;v
	
		movq	mm3, mm2
		movq	mm1, mm2
		pand	mm3, mm6
		pslld	mm3, 1
		pand	mm1, mm5
		pcmpeqb	mm1, mm5
		pand	mm1, mm7
		pxor	mm3, mm1	;w
	
		movq	mm4, mm0
		pxor	mm4, mm2
		pxor	mm4, mm3	;mm4 = y
					
		pxor	mm3, qword ptr [esi]	;t
		pxor	mm0, mm3	;u^t
		movq	mm1, mm0
		psrld	mm1, 8
		pslld	mm0, 24
		pxor	mm4, mm1
		pxor	mm4, mm0
	
		pxor	mm2, mm3	;v^t
		movq	mm1, mm2
		psrld	mm1, 16
		pslld	mm2, 16
		pxor	mm4, mm1
		pxor	mm4, mm2
	
		movq	mm1, mm3
		psrld	mm1, 24
		pslld	mm3, 8
		pxor	mm4, mm1
		pxor	mm4, mm3
	
		movq	qword ptr [edi], mm4
		add	esi, 8
		add	edi, 8
		dec	ecx
		jnz	@B

		pxor	mm0, mm0
		pxor	mm1, mm1
		pxor	mm2, mm2
		pxor	mm3, mm3
		pxor	mm4, mm4
		pxor	mm5, mm5
		pxor	mm6, mm6
		pxor	mm7, mm7
		
		popad
		ret	4

	x1B	db 8 dup (1Bh)
	x80	db 8 dup (80h)
	x7F	db 8 dup (7Fh)
	
	Rijndael_SetDecryptKey	endp

ENDIF

IF ((ACTION eq ENC_ONLY) OR (ACTION eq ALL))

	Rijndael_Encrypt	proc	ptrOut:DWORD, ptrIn:DWORD
	
		pushad
	
		mov	edx, dword ptr [esp + 28h]
		mov	esi, offset internalRijndaelSpace
		mov	edi, offset internalRijndaelEncKey
	
		mov	eax, dword ptr [edx+ 0]
		mov	ebx, dword ptr [edx+ 4]
		xor	eax, dword ptr [edi+ 0]
		xor	ebx, dword ptr [edi+ 4]
		mov	dword ptr [esi+ 0], eax
		mov	dword ptr [esi+ 4], ebx
		mov	eax, dword ptr [edx+ 8]
		mov	ebx, dword ptr [edx+12]
		xor	eax, dword ptr [edi+ 8]
		xor	ebx, dword ptr [edi+12]
		mov	dword ptr [esi+ 8], eax
		mov	dword ptr [esi+12], ebx
	
		xor	eax, eax
		xor	ebx, ebx
		
		IF	(KEY_SIZE eq 128)
			mov	ecx, 9
		ELSEIF	(KEY_SIZE eq 192)
			mov	ecx, 11
		ELSEIF	(KEY_SIZE eq 256)
			mov	ecx, 13
		ENDIF
		
		lea	edx, [esi+16]
		add	edi, 16
	@@:
		mov	al, byte ptr [esi+ 4*0 +0]
		mov	bl, byte ptr [esi+ 4*1 +1]
		mov	ebp, dword ptr [Te0+ 4*eax]
		xor	ebp, dword ptr [Te1+ 4*ebx]
		mov	al, byte ptr [esi+ 4*2 +2]
		mov	bl, byte ptr [esi+ 4*3 +3]
		xor	ebp, dword ptr [Te2+ 4*eax]
		xor	ebp, dword ptr [Te3+ 4*ebx]
		xor	ebp, dword ptr [edi+ 0]
	
		mov	dword ptr [edx+ 0], ebp
	
		mov	al, byte ptr [esi+ 4*1 +0]
		mov	bl, byte ptr [esi+ 4*2 +1]
		mov	ebp, dword ptr [Te0+ 4*eax]
		xor	ebp, dword ptr [Te1+ 4*ebx]
		mov	al, byte ptr [esi+ 4*3 +2]
		mov	bl, byte ptr [esi+ 4*0 +3]
		xor	ebp, dword ptr [Te2+ 4*eax]
		xor	ebp, dword ptr [Te3+ 4*ebx]
		xor	ebp, dword ptr [edi+ 4]
	
		mov	dword ptr [edx+ 4], ebp
	
		mov	al, byte ptr [esi+ 4*2 +0]
		mov	bl, byte ptr [esi+ 4*3 +1]
		mov	ebp, dword ptr [Te0+ 4*eax]
		xor	ebp, dword ptr [Te1+ 4*ebx]
		mov	al, byte ptr [esi+ 4*0 +2]
		mov	bl, byte ptr [esi+ 4*1 +3]
		xor	ebp, dword ptr [Te2+ 4*eax]
		xor	ebp, dword ptr [Te3+ 4*ebx]
		xor	ebp, dword ptr [edi+ 8]
	
		mov	dword ptr [edx+ 8], ebp
	
		mov	al, byte ptr [esi+ 4*3 +0]
		mov	bl, byte ptr [esi+ 4*0 +1]
		mov	ebp, dword ptr [Te0+ 4*eax]
		xor	ebp, dword ptr [Te1+ 4*ebx]
		mov	al, byte ptr [esi+ 4*1 +2]
		mov	bl, byte ptr [esi+ 4*2 +3]
		xor	ebp, dword ptr [Te2+ 4*eax]
		xor	ebp, dword ptr [Te3+ 4*ebx]
		xor	ebp, dword ptr [edi+12]
	
		mov	dword ptr [edx+12], ebp
		add	edi, 16
		xchg	edx, esi
		dec	ecx
		jnz	@B
	
		mov	edx, dword ptr [esp+24h]
		mov	ebx, offset sBox
	
		mov	al, byte ptr [esi+ 4*0 +0]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*1 +1]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*2 +2]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*3 +3]
		xlatb
		ror	eax, 8
		xor	eax, dword ptr [edi+ 0]
		mov	dword ptr [edx+ 0], eax
	
		mov	al, byte ptr [esi+ 4*1 +0]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*2 +1]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*3 +2]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*0 +3]
		xlatb
		ror	eax, 8
		xor	eax, dword ptr [edi+ 4]
		mov	dword ptr [edx+ 4], eax
	
		mov	al, byte ptr [esi+ 4*2 +0]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*3 +1]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*0 +2]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*1 +3]
		xlatb
		ror	eax, 8
		xor	eax, dword ptr [edi+ 8]
		mov	dword ptr [edx+ 8], eax
	
		mov	al, byte ptr [esi+ 4*3 +0]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*0 +1]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*1 +2]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*2 +3]
		xlatb
		ror	eax, 8
		xor	eax, dword ptr [edi+12]
		mov	dword ptr [edx+12], eax
	
		popad
		ret	2*4
	Rijndael_Encrypt	endp
ENDIF

IF ((ACTION eq DEC_ONLY) OR (ACTION eq ALL))

	Rijndael_Decrypt	proc	ptrOut:DWORD, ptrIn:DWORD
	
		pushad
	
		mov	edx, dword ptr [esp + 28h]
		mov	esi, offset internalRijndaelSpace
		
		IF	(KEY_SIZE eq 128)
		mov	edi, offset internalRijndaelEncKey+(10*16)
		ELSEIF	(KEY_SIZE eq 192)
		mov	edi, offset internalRijndaelEncKey+(12*16)
		ELSEIF	(KEY_SIZE eq 256)
		mov	edi, offset internalRijndaelEncKey+(14*16)
		ENDIF
	
		mov	eax, dword ptr [edx+ 0]
		mov	ebx, dword ptr [edx+ 4]
		xor	eax, dword ptr [edi+ 0]
		xor	ebx, dword ptr [edi+ 4]
		mov	dword ptr [esi+ 0], eax
		mov	dword ptr [esi+ 4], ebx
		mov	eax, dword ptr [edx+ 8]
		mov	ebx, dword ptr [edx+12]
		xor	eax, dword ptr [edi+ 8]
		xor	ebx, dword ptr [edi+12]
		mov	dword ptr [esi+ 8], eax
		mov	dword ptr [esi+12], ebx
	
		xor	eax, eax
		xor	ebx, ebx

		IF	(KEY_SIZE eq 128)
			mov	ecx, 9
			lea	edx, [esi+16]
			add	edi, 10*16
		ELSEIF	(KEY_SIZE eq 192)
			mov	ecx, 11
			lea	edx, [esi+16]
			add	edi, 12*16
		ELSEIF	(KEY_SIZE eq 256)
			mov	ecx, 13
			lea	edx, [esi+16]
			add	edi, 14*16
		ENDIF

	@@:
		mov	al, byte ptr [esi+ 4*0 +0]
		mov	bl, byte ptr [esi+ 4*3 +1]
		mov	ebp, dword ptr [Td0+ 4*eax]
		xor	ebp, dword ptr [Td1+ 4*ebx]
		mov	al, byte ptr [esi+ 4*2 +2]
		mov	bl, byte ptr [esi+ 4*1 +3]
		xor	ebp, dword ptr [Td2+ 4*eax]
		xor	ebp, dword ptr [Td3+ 4*ebx]
		xor	ebp, dword ptr [edi+ 0]
	
		mov	dword ptr [edx+ 0], ebp
	
		mov	al, byte ptr [esi+ 4*1 +0]
		mov	bl, byte ptr [esi+ 4*0 +1]
		mov	ebp, dword ptr [Td0+ 4*eax]
		xor	ebp, dword ptr [Td1+ 4*ebx]
		mov	al, byte ptr [esi+ 4*3 +2]
		mov	bl, byte ptr [esi+ 4*2 +3]
		xor	ebp, dword ptr [Td2+ 4*eax]
		xor	ebp, dword ptr [Td3+ 4*ebx]
		xor	ebp, dword ptr [edi+ 4]
	
		mov	dword ptr [edx+ 4], ebp
	
		mov	al, byte ptr [esi+ 4*2 +0]
		mov	bl, byte ptr [esi+ 4*1 +1]
		mov	ebp, dword ptr [Td0+ 4*eax]
		xor	ebp, dword ptr [Td1+ 4*ebx]
		mov	al, byte ptr [esi+ 4*0 +2]
		mov	bl, byte ptr [esi+ 4*3 +3]
		xor	ebp, dword ptr [Td2+ 4*eax]
		xor	ebp, dword ptr [Td3+ 4*ebx]
		xor	ebp, dword ptr [edi+ 8]
	
		mov	dword ptr [edx+ 8], ebp
	
		mov	al, byte ptr [esi+ 4*3 +0]
		mov	bl, byte ptr [esi+ 4*2 +1]
		mov	ebp, dword ptr [Td0+ 4*eax]
		xor	ebp, dword ptr [Td1+ 4*ebx]
		mov	al, byte ptr [esi+ 4*1 +2]
		mov	bl, byte ptr [esi+ 4*0 +3]
		xor	ebp, dword ptr [Td2+ 4*eax]
		xor	ebp, dword ptr [Td3+ 4*ebx]
		xor	ebp, dword ptr [edi+12]
	
		mov	dword ptr [edx+12], ebp
		sub	edi, 16
		xchg	edx, esi
		dec	ecx
		jnz	@B
	
		mov	edx, dword ptr [esp+24h]
		mov	ebx, offset iBox
	
		mov	al, byte ptr [esi+ 4*0 +0]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*3 +1]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*2 +2]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*1 +3]
		xlatb
		ror	eax, 8
		xor	eax, dword ptr [edi+ 0]
		mov	dword ptr [edx+ 0], eax
	
		mov	al, byte ptr [esi+ 4*1 +0]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*0 +1]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*3 +2]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*2 +3]
		xlatb
		ror	eax, 8
		xor	eax, dword ptr [edi+ 4]
		mov	dword ptr [edx+ 4], eax
	
		mov	al, byte ptr [esi+ 4*2 +0]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*1 +1]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*0 +2]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*3 +3]
		xlatb
		ror	eax, 8
		xor	eax, dword ptr [edi+ 8]
		mov	dword ptr [edx+ 8], eax
	
		mov	al, byte ptr [esi+ 4*3 +0]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*2 +1]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*1 +2]
		xlatb
		ror	eax, 8
		mov	al, byte ptr [esi+ 4*0 +3]
		xlatb
		ror	eax, 8
		xor	eax, dword ptr [edi+12]
		mov	dword ptr [edx+12], eax
	
		popad
		ret	2*4
	Rijndael_Decrypt	endp
ENDIF

OPTION EPILOGUE:EPILOGUEDEF
OPTION PROLOGUE:PROLOGUEDEF

.data?
	internalRijndaelSpace	db 32 dup (?)

IF	(KEY_SIZE eq 128)


	internalRijndaelEncKey	db 11*16 dup (?)

	IF	((ACTION eq DEC_ONLY) OR (ACTION eq ALL))

	internalRijndaelDecKey	db 10*16 dup (?)

	ENDIF

ELSEIF	(KEY_SIZE eq 192)

	internalRijndaelEncKey	db 13*16 dup (?)

	IF	((ACTION eq DEC_ONLY) OR (ACTION eq ALL))

	internalRijndaelDecKey	db 12*16 dup (?)

	ENDIF

ELSEIF	(KEY_SIZE eq 256)

	internalRijndaelEncKey	db 15*16 dup (?)

	IF	((ACTION eq DEC_ONLY) OR (ACTION eq ALL))

	internalRijndaelDecKey	db 14*16 dup (?)

	ENDIF
ENDIF