comment %

Algo	: RUBY Mark 5 by Michael Paul Johnson
Rounds	: as you wish (default 8)
MD size : 64 bits

	push	offset ptrData			;The address of the data to be hashed 
	push	nSize 				;The number of bytes of data to be hashed
	push	offset ptrBuffer		;The pointer to the buffer to receive message digest (8 bytes)
	call	Ruby_Hash

Recomendation for using rounds number (STRENGTH param) from oryginal C source):

4   Minimum       -  speed is of the essence, security secondary.
8   Desk lock     -  reasonable compromise of speed vs security?
16  Dead bolt     -  probably good enough for most things.
20  Portable safe -  security is more important than speed.
32  Anchored safe -  speed isn't much of a concern.
40  Bank vault    -  your pentium has nothing better to do, anyway.
64  Fort Knox     -  If you are willing to wait this long, it would probably
                     make sense to double the block size, too.

02.05.2002 WiteG//xtreeme (witeg@poczta.fm, www.witeg.prv.pl)

%

STRENGTH	equ	32



	f1	macro	A, B, C, D
		mov	ecx, D
		mov	edi, A
		rol	edi, cl
		mov	esp, B
		mov	ecx, C
		shr	ecx, 27
		rol	esp, cl
		add	edi, esp
		mov	esp, D
		mov	ecx, A
		shr	ecx, 27
		rol	esp, cl
		mov	ecx, B
		mov	esi, C
		rol	esi, cl
		add	esi, esp
		xor	edi, esi
		mov	A, edi
	endm

	f2	macro	A, B, C, D
		mov	ecx, C
		mov	edi, A
		rol	edi, cl
		mov	esp, B
		mov	ecx, D
		shr	ecx, 27
		rol	esp, cl
		xor	edi, esp
		mov	ecx, A
		mov	esp, C
		rol	esp, cl
		add	edi, esp
		mov	esp, D
		mov	ecx, B
		shr	ecx, 27
		rol	esp, cl
		add	edi, esp
		mov	A, edi
	endm

FAMILY_KEY_1	equ	0456C6091h
FAMILY_KEY_2	equ	0AA7110C3h

.code
Ruby_Hash	proc
	pushad

	mov	ecx, [esp+ 28h]	; dlugosc danych do hashowania w bajtach	_size
	mov	esi, [esp+ 2Ch]	; offset danych do hashowania			_addr_INPUT
	mov	dword ptr [_size] , ecx
	mov	byte ptr  [_flag] , 1		; umowna flaga...
	mov	dword ptr [_count], ecx
	mov	dword ptr [_esp], esp
	mov	dword ptr [_cur_ptr], esi
	xor	edx, edx		;x[2]
	xor	ebp, ebp		;x[3]

_ruby_loop:
	mov	esi, dword ptr [_cur_ptr]
	cmp	dword ptr [_count] , 8
	jb	_ruby_lipof

	mov	eax, dword ptr [esi]	;x[0]
	mov	ebx, dword ptr [esi+4]	;x[1]
	mov	dword ptr [_rounds], STRENGTH

_next_round:

	f1	eax, ebx, edx, ebp

	add	eax, FAMILY_KEY_1

	xchg	eax, ebx
	xchg	ebx, edx
	xchg	edx, ebp

	f2	eax, ebx, edx, ebp

	imul	eax, FAMILY_KEY_2

	xchg	eax, ebx
	xchg	ebx, edx
	xchg	edx, ebp
	
	dec	dword ptr [_rounds]
	jnz	_next_round

	mov	ecx, ebp
	mov	esp, eax
	rol	esp, cl

	mov	ecx, edx
	shr	ecx, 27
	mov	esi, ebx
	rol	esi, cl
	
	add	esp, esi
    
	mov	ecx, eax
	shr	ecx, 27
	rol	edx, cl
	
	mov	ecx, ebx
	rol	ebp, cl
	xor	ebp, edx
	
	mov	edx, esp

	sub	dword ptr [_count], 8
	add	dword ptr [_cur_ptr], 8
	jmp	_ruby_loop

_ruby_lipof:
	cmp	byte ptr [_flag], 0
	jz	_Finishing

	mov	ecx, dword ptr [_count]
	and	byte ptr  [_flag] , 0
	mov	dword ptr [_count], 8

	mov	eax, ecx
	mov	edi, offset _temp_bufor

	test	eax, eax
	jz	_save_size
	
@@:
	mov	bl, byte ptr [esi+ecx-1]
	mov	byte ptr [edi+ecx-1], bl
	dec	ecx
	jnz	@B

	add	edi, eax

_save_size:
	mov	ecx, dword ptr [_size]
	mov	dword ptr [edi], ecx
	mov	ecx, eax
	add	edi, 4

	sub	ecx, 4
	neg	ecx
	jz	_pad_done
	jns	@F

	add	dword ptr [_count], 8
	add	ecx, 8

@@:
	dec	ecx
	mov	byte ptr [edi+ecx], 0FFh
	jnz	@B

_pad_done:
	mov	dword ptr [_cur_ptr], offset _temp_bufor
	jmp	_ruby_loop

_Finishing:
	mov	esp, dword ptr [_esp]
	mov	eax, [esp+ 24h]
	mov	dword ptr [eax+0], edx
	mov	dword ptr [eax+4], ebp

	mov	edi, offset _size
	xor	eax, eax
	mov	ecx, 10
	cld
	rep	stosd

	popad
	ret	0Ch
Ruby_Hash	endp

.data?
_size		dd	?
_count		dd	?
_esp		dd	?
_rounds		dd	?
_temp_bufor	db	16 dup (?)
_cur_ptr	dd	?
_flag		dd	?