SPEED_KEY_LEN		equ	256	;48,64,80,96,112,128,144,160,176,192,208,224,240,256
SPEED_NO_OF_RND		equ	256	;32,36,40,44,48,52...
SPEED_DATA_LEN		equ	256	;64,128,256

include	speed.mac

.code
Speed_SetKey	proc	ptrPass:DWORD
	pushad
	mov	edi, ptrPass
	mov	esi, offset speed_internal_pass
	mov	ecx, SPEED_KEY_LEN/8-2
@@:
	mov	ax, word ptr [edi+ecx]
	mov	word ptr [esi+ecx], ax
	sub	ecx, 2
	jns	@B

	xor	edx, edx
	mov	bx, sqrt_0
	mov	bp, sqrt_1
	mov	di, sqrt_2
	mov	ax, bx
	mov	ecx, SPEED_KEY_LEN/16
@@:
	mov	dx, bp
	xor	ax, bp
	and	dx, bx
	and	ax, di
	xor	ax, dx
	rol	ax, 5
	
IF	SPEED_KEY_LEN eq 64
	mov	dx, cx
	add	ax, di
	and	dx, 3
ELSEIF	SPEED_KEY_LEN eq 128
	mov	dx, cx
	add	ax, di
	and	dx, 7
ELSEIF	SPEED_KEY_LEN eq 256
	mov	dx, cx
	add	ax, di
	and	dx, 15
ELSE
	push	eax
	mov	eax, ecx
	cdq
	div	dword ptr [_dzielnik]
	pop	eax
	add	ax, di
ENDIF

	add	ax, word ptr [esi+2*edx]
	mov	di, bp
	mov	word ptr [esi+2*ecx], ax
	mov	bp, bx
	inc	ecx
	mov	bx, ax
	cmp	ecx, KB_SIZE
	jnz	@B

	popad
	ret

IF	(SPEED_KEY_LEN ne 64) and (SPEED_KEY_LEN ne 128) and (SPEED_KEY_LEN ne 256)
	_dzielnik	dd SPEED_KEY_LEN/16
ENDIF
Speed_SetKey	endp

Speed_Encrypt	proc	ptrOut:DWORD, ptrIn:DWORD
	pushad
	mov	esi, ptrIn
	mov	edi, ptrOut
	mov	dword ptr [speed_esp], esp

	mov	ebx, dword ptr [esi +  4]
	mov	ebp, dword ptr [esi +  8]
	mov	edx, dword ptr [esi + 12]
	mov	dword ptr [edi +  4], ebx
	mov	dword ptr [edi + 12], edx
	mov	esp, dword ptr [esi + 16]
	mov	ebx, dword ptr [esi + 20]
	mov	ecx, dword ptr [esi + 24]
	mov	edx, dword ptr [esi + 28]
	mov	dword ptr [edi + 20], ebx
	mov	dword ptr [edi + 24], ecx
	mov	dword ptr [edi + 28], edx
	mov	esi, dword ptr [esi +  0]
	mov	ebx, offset speed_internal_pass

	mov	dword ptr [counter], SPEED_NO_OF_RND/4

@@:
	FF1	t6, t5, t4, t3, t2, t1, t0
	mov	ecx, eax
	mov	edx, t7
	shr	ecx, SPEED_DATA_LEN/16
	ror	edx, ((SPEED_DATA_LEN/16) - 1)
	add	cx, ax
	add	edx, dword ptr [ebx]
	shr	cx, V_SHIFT
	ror	eax, cl
	add	eax, edx

	mov	ecx, t6
	mov	edx, t5
	mov	t7, ecx
	mov	t6, edx
	mov	t5, t4
	mov	t4, t3
	mov	t3, t2
	mov	t2, t1
	mov	t1, t0
	mov	t0, eax
	add	ebx, 4
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4

@@:
	FF2	t6, t5, t4, t3, t2, t1, t0
	mov	ecx, eax
	mov	edx, t7
	shr	ecx, SPEED_DATA_LEN/16
	ror	edx, ((SPEED_DATA_LEN/16) - 1)
	add	cx, ax
	add	edx, dword ptr [ebx]
	shr	cx, V_SHIFT
	ror	eax, cl
	add	eax, edx

	mov	ecx, t6
	mov	edx, t5
	mov	t7, ecx
	mov	t6, edx
	mov	t5, t4
	mov	t4, t3
	mov	t3, t2
	mov	t2, t1
	mov	t1, t0
	mov	t0, eax
	add	ebx, 4
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4

@@:
	FF3	t6, t5, t4, t3, t2, t1, t0
	mov	ecx, eax
	mov	edx, t7
	shr	ecx, SPEED_DATA_LEN/16
	ror	edx, ((SPEED_DATA_LEN/16) - 1)
	add	cx, ax
	add	edx, dword ptr [ebx]
	shr	cx, V_SHIFT
	ror	eax, cl
	add	eax, edx

	mov	ecx, t6
	mov	edx, t5
	mov	t7, ecx
	mov	t6, edx
	mov	t5, t4
	mov	t4, t3
	mov	t3, t2
	mov	t2, t1
	mov	t1, t0
	mov	t0, eax
	add	ebx, 4
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [counter], SPEED_NO_OF_RND/4

@@:
	FF4	t6, t5, t4, t3, t2, t1, t0
	mov	ecx, eax
	mov	edx, t7
	shr	ecx, SPEED_DATA_LEN/16
	ror	edx, ((SPEED_DATA_LEN/16) - 1)
	add	cx, ax
	add	edx, dword ptr [ebx]
	shr	cx, V_SHIFT
	ror	eax, cl
	add	eax, edx

	mov	ecx, t6
	mov	edx, t5
	mov	t7, ecx
	mov	t6, edx
	mov	t5, t4
	mov	t4, t3
	mov	t3, t2
	mov	t2, t1
	mov	t1, t0
	mov	t0, eax
	add	ebx, 4
	dec	dword ptr [counter]
	jnz	@B

	mov	dword ptr [edi +  0], t0
	mov	dword ptr [edi +  8], t2
	mov	dword ptr [edi + 16], t4

	mov	esp, dword ptr [speed_esp]
	and	dword ptr [speed_esp], 0
	popad
	ret
Speed_Encrypt	endp

Hash	proc	ptrOut:DWORD, ptrIn:DWORD

	;zwraca 32 bajtowy hash z bufora dlugosci 32 bajtow

	pushad
	mov	esi, ptrIn
	mov	edi, ptrOut
	xor	ecx, ecx

	push	esi
	call	Speed_SetKey

	push	esi
	push	edi
	call	Speed_Encrypt

@@:
	push	edi
	call	Speed_SetKey
	
	push	edi
	push	edi
	call	Speed_Encrypt

	dec	cl
	jnz	@B

	popad
	ret
Hash	endp

.data?
speed_internal_pass	dw KB_SIZE dup (?)
counter			dd ?
_t_buffer		db 4 dup (?)
IF	SPEED_DATA_LEN ne 64
speed_esp			dd ?
ENDIF