ROUNDS	equ	16

.data?
_rounds		dd ?
loki91_subkeys	dd ROUNDS dup (?)

.code
Loki91_SetKey	proc	ptrPass:DWORD
	pushad
	mov	esi, ptrPass
	mov	edi, offset loki91_subkeys
	mov	eax, dword ptr [esi]
	mov	ebx, dword ptr [esi+4]

	mov	ecx, ROUNDS/2
@@:
	mov	dword ptr [edi], eax
	rol	eax, 12
	mov	dword ptr [edi+4], eax
	rol	eax, 13
	add	edi, 8
	xchg	eax, ebx
	dec	ecx
	jnz	@B

	popad
	ret
Loki91_SetKey	endp

Loki91_Encrypt	proc	ptrOut:DWORD, ptrIn:DWORD
	pushad

	mov	edi, ptrIn
	mov	ecx, offset loki91_subkeys
	mov	ebx, dword ptr [edi]		;L
	mov	edi, dword ptr [edi+4]		;R
	cld
	mov	dword ptr [_rounds], ROUNDS

@@round:
	mov	eax, edi
	xor	eax, dword ptr [ecx]			;a = KL^R

	mov	ebp, eax
	shr	ebp, 16
	and	ebp, 0FFFh
	rol	eax, 8
	mov	dl, byte ptr [loki_box+ebp]
	mov	ebp, eax
	and	ebp, 0FFFh
	ror	eax, 8
	mov	dh, byte ptr [loki_box+ebp]
	mov	ebp, eax
	shl	edx, 16
	shr	ebp, 8
	and	ebp, 0FFFh
	and	eax, 0FFFh
	mov	dh, byte ptr [loki_box+ebp]
	mov	dl, byte ptr [loki_box+eax]
	xor	ebp, ebp
	xor	eax, eax
	mov	esi, offset perm_order
@@:
	lodsb
	bt	edx, eax
	rcl	ebp, 1
	test	al, al
	jnz	@B

	xor	ebx, ebp
	add	ecx, 4
	xchg	ebx, edi

	dec	dword ptr [_rounds]
	jnz	@@round

	mov	ebp, [esp + 8]
	mov	esi, ptrOut
	mov	dword ptr [esi], edi
	mov	dword ptr [esi+4], ebx
	popad
	ret
Loki91_Encrypt	endp

.data
loki_box	db 0fdh,04eh,04dh,09eh,000h,063h,0deh,0dah,001h,0cch,0dfh,047h,01dh,0d4h,00dh,0a4h
		db 0c4h,073h,0b4h,015h,026h,042h,095h,05ah,02dh,010h,079h,018h,0e2h,0a6h,09dh,06ah
		db 0beh,08dh,043h,0adh,077h,041h,0cah,08fh,02fh,0ach,09ah,02bh,0b8h,04ch,02bh,090h
		db 0edh,06fh,0fbh,0e1h,095h,00ah,0e6h,0e2h,018h,0c3h,027h,0beh,0dch,032h,070h,0efh
		db 0cbh,07ch,013h,026h,0bfh,0d1h,0dbh,07dh,0fah,000h,099h,0deh,082h,001h,0efh,0dfh
		db 055h,0bfh,0a5h,055h,092h,0d5h,0c5h,091h,0f7h,0e7h,0d1h,04ch,02eh,09eh,0a7h,04eh
		db 0afh,006h,024h,095h,02ah,007h,0eah,074h,029h,07bh,054h,030h,04fh,0ddh,0d2h,079h
		db 034h,008h,0c0h,086h,0adh,0c1h,0f4h,002h,06fh,00fh,0a0h,00bh,059h,0abh,03dh,0cah
		db 07ah,0b0h,048h,083h,0c1h,07ah,0f1h,023h,002h,076h,06bh,08eh,0dah,071h,000h,09dh
		db 074h,012h,001h,09ch,0deh,013h,0cdh,0f8h,033h,014h,089h,0a1h,0bch,015h,0f6h,057h
		db 085h,024h,03bh,046h,079h,036h,062h,059h,0a6h,0a4h,02eh,016h,05bh,09fh,0edh,0ffh
		db 042h,0c5h,09fh,017h,09fh,057h,01bh,01dh,0a0h,043h,052h,02eh,066h,0aeh,0e4h,0bdh
		db 091h,0c9h,098h,07bh,0ebh,0e6h,004h,0d8h,00dh,0d7h,086h,02ch,0cch,0dah,0a1h,0ceh
		db 017h,067h,057h,000h,0c9h,0dch,0adh,001h,036h,02dh,093h,00dh,0eah,081h,04ch,009h
		db 0efh,092h,0c1h,051h,05ch,03ah,05bh,041h,021h,022h,08fh,065h,0f0h,080h,018h,0c3h
		db 02ch,09dh,019h,08bh,020h,0afh,047h,0f7h,007h,05ah,03eh,05bh,03eh,01dh,03ah,0fah
		db 03fh,077h,05ch,044h,08bh,0b5h,0fch,0d1h,0feh,061h,053h,0edh,03ah,0b1h,041h,0d4h
		db 0b5h,0b7h,0d5h,0d3h,0e3h,0bch,0ach,058h,0c7h,02eh,0d8h,022h,098h,0edh,00fh,03ah
		db 0b2h,038h,023h,0f9h,097h,0feh,0e3h,0b3h,0a4h,01ah,0b9h,073h,0b9h,048h,0e0h,075h
		db 027h,070h,061h,062h,0e6h,0d9h,0b8h,098h,00fh,030h,069h,027h,08dh,0ffh,0e2h,0e8h
		db 022h,0c4h,0a2h,080h,019h,0e5h,045h,08dh,037h,003h,017h,01eh,093h,0deh,09ch,01fh
		db 028h,0a2h,016h,03dh,01ah,026h,051h,0e7h,078h,040h,078h,0eeh,048h,0f5h,044h,0d6h
		db 0a7h,0adh,04eh,031h,0f8h,02fh,0ech,07ch,090h,0f1h,08eh,089h,0ddh,0e8h,0d6h,054h
		db 099h,084h,003h,064h,005h,0e0h,008h,0f4h,0d8h,016h,0ceh,040h,05eh,08eh,084h,0e9h
		db 05fh,069h,02dh,0bah,060h,050h,096h,00fh,061h,055h,012h,094h,081h,08ch,063h,0b8h
		db 0ffh,03bh,0a8h,067h,00ah,0c7h,06ah,0fch,011h,0b2h,0c4h,014h,0f4h,002h,0c2h,005h
		db 00ch,0cfh,05eh,008h,063h,035h,0e9h,061h,058h,099h,083h,0b9h,0d0h,0fah,09eh,06ch
		db 072h,089h,05ah,0ach,07dh,096h,087h,0cbh,0ceh,068h,01ch,0fdh,014h,044h,0f2h,0dch
		db 012h,0f6h,07eh,096h,049h,017h,0ddh,09ah,01bh,04fh,0b0h,09bh,024h,097h,022h,011h
		db 07bh,0fch,0bdh,0aah,008h,08ah,034h,099h,0a1h,0f3h,005h,0f2h,0a5h,082h,010h,045h
		db 0f6h,05dh,06eh,097h,039h,0e9h,040h,0c8h,0e7h,04bh,0f3h,004h,053h,058h,03fh,0fbh
		db 080h,06ah,08ah,0f6h,038h,06bh,091h,071h,04eh,06ch,039h,0f1h,025h,06dh,059h,0bfh
		db 0eeh,0f8h,038h,0c9h,02bh,087h,002h,010h,054h,039h,011h,0b2h,0aeh,01eh,07dh,00ah
		db 045h,0b4h,050h,049h,04ch,0ebh,0cfh,03ch,006h,0d8h,082h,035h,013h,094h,08bh,0bbh
		db 0a2h,018h,07bh,056h,088h,02ch,065h,02dh,089h,078h,0bch,0b4h,0c5h,079h,094h,0eah
		db 0f5h,047h,07ch,025h,0abh,052h,0fdh,01ah,015h,091h,04bh,04bh,040h,0efh,06ch,082h
		db 0d5h,07eh,06dh,048h,010h,07fh,088h,088h,08ch,0bah,066h,03fh,0a9h,07dh,0bah,07fh
		db 094h,0a8h,08ch,05eh,08fh,021h,0d0h,0e3h,0c6h,06eh,0f0h,05dh,06ah,00ch,074h,078h
		db 084h,05fh,075h,0e4h,0e1h,0c6h,026h,04ah,0fbh,0a0h,080h,039h,0bbh,0beh,0e1h,0feh
		db 0dbh,056h,05dh,068h,065h,075h,0d4h,069h,0aah,0cah,007h,070h,003h,011h,014h,020h
		db 032h,0f4h,0dah,032h,052h,054h,0f5h,0a5h,08ah,05ch,03ch,021h,0cdh,064h,029h,08ah
		db 096h,0dfh,037h,0dbh,064h,028h,0f8h,042h,05ah,031h,0beh,085h,0d1h,01fh,090h,0d2h
		db 047h,0cbh,055h,050h,075h,09ah,04fh,0bch,0ech,027h,0eeh,076h,004h,0b9h,068h,077h
		db 03ch,020h,071h,052h,09ah,085h,015h,081h,04ah,05bh,030h,00eh,08eh,0a5h,09bh,0f3h
		db 00eh,088h,0b1h,003h,0e0h,062h,00bh,006h,035h,03dh,033h,0ddh,043h,0f9h,060h,06dh
		db 0a3h,025h,0bfh,0f5h,0b0h,066h,02fh,013h,041h,0d6h,01fh,019h,0b6h,04ah,031h,0afh
		db 0b7h,02bh,0dch,01bh,069h,0bbh,0a6h,0d5h,0cfh,046h,08dh,06fh,0d9h,0ceh,0d7h,036h
		db 01eh,005h,06fh,05fh,073h,0dbh,042h,0c7h,067h,03fh,0a4h,092h,06eh,0eah,01eh,038h
		db 0f3h,0cdh,0a9h,034h,04bh,083h,064h,0cch,057h,0b8h,097h,07eh,056h,08fh,04ah,0b5h
		db 09eh,0f2h,076h,02fh,0f9h,00bh,0e7h,0a6h,071h,090h,0c9h,0a0h,0b3h,0e3h,085h,0cfh
		db 0cah,01ch,0fah,00ch,0d2h,045h,0f7h,06eh,0c3h,0e4h,0f9h,01ch,0bah,072h,0e8h,0ebh
		db 0c2h,0aah,058h,09fh,07ch,009h,0aah,0d9h,0c8h,0ech,0abh,0d0h,09ch,04dh,0aeh,0cdh
		db 016h,098h,0d3h,04dh,06ch,0c2h,01ah,093h,01ch,004h,072h,072h,03dh,0b6h,021h,066h
		db 01fh,0a3h,0b6h,033h,031h,053h,0b2h,03bh,03bh,0fdh,0b3h,0a7h,0d6h,0a1h,0feh,05ch
		db 0d7h,02ah,067h,0c2h,06dh,095h,006h,0aeh,062h,059h,077h,028h,030h,0bdh,0ffh,08ch
		db 07fh,03eh,0d9h,0a8h,0d3h,0d0h,0cbh,0a9h,051h,029h,0c3h,07ah,09dh,086h,01dh,060h
		db 083h,060h,035h,063h,087h,037h,025h,0b1h,0ach,00eh,0bbh,0a3h,068h,0c0h,092h,087h
		db 0a8h,09ch,0cch,012h,04dh,074h,046h,06bh,0b1h,0e1h,0c8h,0a2h,023h,0a9h,0ebh,007h
		db 00bh,05eh,036h,029h,0e8h,093h,0c6h,053h,0e9h,0eeh,0c7h,0b6h,0c0h,09bh,07fh,0b7h
		db 0dfh,051h,073h,03eh,0b4h,01bh,0b5h,04fh,07eh,0f7h,020h,0c4h,046h,0d2h,00eh,037h
		db 070h,08bh,0a3h,0b0h,06bh,00dh,02ah,0abh,0e5h,0d3h,02ch,0e6h,0fch,034h,009h,02ah
		db 09bh,033h,028h,0c0h,0f2h,0fbh,05fh,0c1h,086h,049h,0e5h,0c6h,0e4h,0c8h,049h,0e0h
		db 0bdh,065h,032h,0d7h,076h,0f0h,00ah,0f0h,044h,0a7h,056h,0c5h,0d4h,0e2h,0b7h,043h
		db 05dh,019h,00ch,0e5h,050h,023h,07ah,084h,0f1h,03ch,081h,024h,009h,0b3h,0afh,0ech
		db 0f2h,0c0h,0d8h,08bh,06ah,018h,038h,0c8h,0eeh,06ah,049h,086h,02eh,076h,066h,0c4h
		db 01dh,0a3h,0f5h,0f4h,02fh,064h,065h,03bh,0d9h,065h,033h,0dfh,0cch,0ffh,021h,0c5h
		db 0bfh,008h,0f1h,01ch,0a5h,0b9h,0c2h,00fh,063h,0afh,0f7h,073h,058h,0dah,0e2h,0feh
		db 036h,01dh,018h,007h,067h,038h,003h,0f0h,0e5h,01bh,064h,0e6h,05fh,0f4h,02bh,0eeh
		db 09ch,0f8h,05ch,0b6h,074h,0ebh,080h,08eh,065h,02ch,0b1h,00ch,029h,08ch,0d1h,0b7h
		db 05eh,04ah,09fh,0a9h,077h,0e5h,0a6h,08dh,0d7h,003h,0e4h,0d5h,0fdh,05bh,05eh,02eh
		db 0e0h,050h,06dh,089h,06fh,01eh,043h,0d4h,064h,00ah,07ch,094h,005h,06bh,08dh,0e0h
		db 010h,019h,0d6h,04eh,024h,04bh,03ah,0b8h,02dh,02dh,054h,087h,030h,092h,04ch,0d3h
		db 0fah,0b1h,0dbh,04dh,0cah,04dh,0bah,0a7h,06dh,0d6h,0bbh,071h,0a7h,0a0h,004h,026h
		db 099h,09ah,0eeh,014h,039h,033h,052h,091h,07dh,0e9h,081h,055h,0c0h,0ach,0dfh,0f9h
		db 059h,0c5h,041h,028h,09ah,04fh,08eh,0dah,0c6h,081h,0b4h,08fh,031h,0dch,055h,070h
		db 01eh,0e0h,012h,03ah,07eh,097h,04dh,0efh,060h,0d8h,0ach,004h,0edh,0d9h,0c8h,0b5h
		db 0a8h,0d1h,0c9h,05eh,0f5h,062h,0adh,06ch,028h,02bh,0f3h,0d8h,011h,010h,0f6h,098h
		db 08dh,049h,00bh,0e3h,002h,058h,0fah,041h,0b9h,002h,030h,025h,01ah,0ceh,08ch,015h
		db 094h,0f0h,035h,0aah,037h,099h,002h,0d0h,0d5h,026h,09dh,066h,0ceh,03fh,06bh,020h
		db 082h,0e2h,088h,0f3h,087h,09bh,0f0h,07bh,084h,00fh,03fh,0c6h,020h,0deh,032h,0c7h
		db 0efh,0b5h,034h,09dh,09fh,00dh,0c1h,07ch,053h,0d2h,039h,099h,008h,044h,02eh,034h
		db 0d4h,011h,0b8h,0bdh,000h,028h,053h,017h,001h,0b4h,0ffh,04fh,0f9h,040h,0e0h,072h
		db 02ah,0feh,0e1h,0d6h,018h,0c3h,0d5h,0adh,0e7h,0eah,0dch,07ah,047h,086h,094h,01dh
		db 05dh,074h,015h,0f1h,093h,057h,023h,051h,0b4h,0cbh,014h,05fh,00ah,0d5h,03dh,09eh
		db 00bh,0fah,096h,078h,0eah,0fbh,0cfh,09ch,040h,090h,07fh,0a4h,006h,005h,0a1h,0bah
		db 051h,073h,084h,0dch,0cdh,0b8h,0c0h,0ddh,0c1h,000h,07ah,01eh,0fch,001h,0a8h,060h
		db 080h,0e3h,079h,0b2h,00eh,0bdh,07bh,0d9h,0c7h,025h,063h,061h,0f7h,0a4h,009h,0eah
		db 0dch,067h,037h,010h,07ch,0cfh,047h,0e1h,079h,083h,00fh,038h,092h,091h,0ceh,062h
		db 0c4h,016h,0dah,016h,081h,02eh,046h,085h,0a3h,0e1h,08ah,0e5h,089h,046h,01ah,050h
		db 075h,0beh,08bh,0ech,04dh,078h,0f8h,0edh,007h,0cch,090h,052h,0c2h,07ah,000h,0e4h
		db 0e2h,0fch,001h,01fh,01fh,071h,0b7h,03eh,0d2h,082h,044h,019h,0a9h,0a8h,0c3h,036h
		db 025h,0c2h,017h,053h,0f0h,0a2h,0efh,023h,0e6h,07ch,0cdh,0f6h,043h,079h,0a3h,0f7h
		db 072h,0d0h,07dh,05bh,0e8h,052h,0a7h,090h,041h,0ddh,0b5h,00bh,056h,013h,083h,06bh
		db 0a1h,07bh,0beh,005h,0b6h,0bah,025h,0d2h,098h,004h,056h,057h,0b1h,0a9h,01eh,018h
		db 0c3h,022h,0b6h,000h,034h,023h,0a5h,001h,035h,0bfh,042h,0a0h,0c5h,069h,027h,058h
		db 0adh,063h,04ah,059h,050h,093h,00eh,03ch,0abh,02fh,06eh,00eh,066h,0b0h,075h,0f2h
		db 09eh,05fh,0f2h,0aeh,021h,0c7h,006h,0b9h,0b7h,014h,0edh,042h,03eh,03ch,0e5h,074h
		db 03fh,0fdh,067h,064h,0e4h,0dfh,0c6h,06dh,052h,0c9h,048h,048h,078h,017h,062h,068h
		db 012h,098h,061h,03dh,044h,09fh,074h,0a6h,045h,024h,00ch,04ah,00dh,06dh,0eah,006h
		db 0bah,00bh,0b9h,054h,0ebh,095h,01bh,021h,03bh,08eh,089h,009h,0a6h,0c8h,028h,037h
		db 0f8h,0d3h,029h,04ch,068h,01ch,069h,084h,023h,0c1h,0bch,01ah,04eh,0edh,086h,01bh
		db 04fh,06fh,02fh,04bh,090h,087h,03bh,022h,01bh,0b2h,02ah,0c1h,0f3h,029h,0d7h,003h
		db 0dfh,0bch,01ch,0e2h,014h,08ah,09bh,0e8h,097h,08bh,0abh,0cbh,046h,089h,0f4h,0cdh
		db 038h,068h,02ch,0a2h,003h,07dh,04eh,0fch,004h,03eh,098h,092h,06bh,0aah,03ch,05ch
		db 091h,0f1h,008h,083h,0f1h,09ch,0feh,046h,0c9h,053h,0a2h,02ah,019h,034h,02dh,02bh
		db 0dbh,0a5h,08fh,056h,083h,0f3h,0a4h,0a5h,0cbh,021h,0e9h,0fdh,03ah,05eh,070h,08ah
		db 0d6h,0cdh,09ch,030h,0fbh,0c6h,00ah,031h,0d3h,0a1h,016h,0a8h,0bdh,048h,060h,077h
		db 0deh,045h,0c7h,05ah,055h,039h,04bh,079h,0ech,0dbh,051h,0fah,0ach,007h,00dh,09bh
		db 0b5h,0f2h,0cch,002h,03ch,0f6h,045h,0bbh,07fh,05ch,0c5h,063h,096h,05dh,0ech,0ffh
		db 08ah,0d7h,031h,0ceh,070h,059h,0cah,0c0h,071h,055h,095h,049h,017h,036h,019h,0b4h
		db 027h,061h,082h,00dh,05ah,03ah,0aeh,0b1h,042h,0e4h,05fh,012h,0bbh,051h,078h,0c3h
		db 0f6h,0ech,0b0h,0d1h,0b0h,01fh,0cbh,033h,049h,060h,022h,043h,07ah,0b7h,0fbh,093h
		db 07bh,043h,007h,0b0h,05bh,054h,05ah,081h,0d1h,041h,05bh,02ch,0a2h,075h,087h,0abh
		db 057h,04eh,0ebh,07fh,08ch,00ch,0d4h,013h,03dh,066h,024h,075h,00fh,05ah,07eh,05dh
		db 06eh,0b6h,005h,09ah,048h,032h,0afh,0dbh,0e3h,09eh,0b2h,02fh,09dh,09dh,0e3h,0c2h
		db 0f4h,020h,076h,095h,06ch,03dh,06ch,0cah,009h,0aeh,0b3h,035h,095h,0f7h,06fh,0b3h
		db 02bh,035h,06ah,06ah,076h,0e6h,020h,047h,026h,01ah,0d2h,082h,00ch,03bh,050h,096h
		db 0ddh,07eh,0ddh,08ch,085h,07fh,099h,0bfh,08fh,094h,011h,0cch,05ch,077h,0c4h,088h
		db 0afh,0cah,01fh,0cfh,061h,070h,072h,045h,0b8h,084h,073h,06fh,0e1h,085h,0d0h,044h
		db 0c8h,0d4h,068h,0afh,0aah,030h,0a9h,039h,04ch,037h,0e8h,040h,0cfh,0eeh,097h,0deh
		db 0beh,06eh,036h,0e7h,062h,0f9h,03eh,0f5h,054h,012h,0d3h,024h,09bh,08fh,05dh,07dh
		db 088h,02ah,0e6h,0beh,04bh,0b3h,077h,097h,08bh,0abh,0d9h,029h,015h,0bbh,059h,0fbh
		db 04ah,006h,0e7h,0e9h,016h,096h,0a0h,069h,022h,015h,01dh,0a3h,0d0h,027h,0bfh,0c9h
		db 073h,056h,091h,07eh,01ch,0c4h,010h,011h,0ffh,0e8h,026h,065h,033h,080h,0bdh,09fh
		db 0e9h,009h,09eh,00ah,013h,0efh,09ah,0d7h,0aeh,0f5h,040h,06eh,0dah,088h,0deh,008h
		db 0a0h,04ch,0aah,0ebh,086h,0adh,085h,03fh,0bch,031h,071h,067h,0feh,00eh,0fch,0f8h
		db 0d8h,042h,04fh,02dh,02ch,072h,092h,032h,0a4h,0e7h,093h,0bch,0b2h,08dh,058h,0a1h
		db 08eh,0a6h,013h,0ach,069h,0a7h,057h,076h,032h,047h,0fdh,027h,0b3h,06ch,0f9h,080h
		db 0a0h,002h,00bh,01fh,0a2h,0b6h,012h,0fch,0e6h,061h,0a8h,04ch,04eh,092h,0c1h,0c5h
		db 0fah,0cfh,039h,048h,051h,071h,0ddh,049h,00ch,0b4h,0feh,007h,0a6h,0d5h,073h,085h
		db 0ffh,088h,04fh,036h,0b8h,06bh,013h,0beh,078h,04bh,07fh,0f8h,099h,008h,055h,094h
		db 01fh,01bh,0b2h,066h,06fh,022h,02ch,0adh,0cfh,074h,0c4h,045h,0d8h,075h,050h,058h
		db 0c9h,0a5h,06eh,0e4h,0deh,009h,0a2h,077h,05fh,028h,051h,00ch,0ebh,0ffh,08ch,017h
		db 0feh,0b2h,09eh,0aeh,0a7h,08ch,036h,051h,09ah,04ch,07ch,00bh,055h,087h,0d4h,0a0h
		db 0d0h,04dh,0e9h,0a6h,034h,0f7h,085h,0eah,0c3h,0c9h,03dh,023h,0dah,03eh,0e6h,093h
		db 0edh,07eh,062h,06ch,02ch,0ach,07eh,0dfh,0fch,023h,010h,071h,096h,06ch,0ceh,09bh
		db 097h,059h,0a4h,0deh,0d7h,019h,068h,0c4h,025h,093h,097h,07eh,0f1h,07fh,00ch,004h
		db 04bh,0a2h,0bch,06ah,002h,011h,00fh,06eh,023h,082h,06fh,033h,08ch,0d1h,02ah,0b8h
		db 0d4h,06fh,094h,044h,07eh,034h,061h,0b0h,042h,00dh,087h,010h,083h,05ch,01eh,0e0h
		db 05ch,0ddh,043h,096h,0b1h,02fh,004h,0c2h,076h,00fh,0b8h,0bbh,0e7h,006h,00dh,069h
		db 014h,096h,06bh,074h,0a8h,097h,0eeh,075h,0a9h,0a9h,049h,019h,0ech,072h,019h,0afh
		db 050h,01fh,02bh,0e9h,0cbh,0f4h,024h,024h,0ceh,0eeh,01fh,0b9h,0c2h,0e0h,031h,02bh
		db 06eh,063h,046h,09fh,081h,0b3h,08eh,04fh,059h,060h,08fh,070h,029h,0adh,047h,0b5h
		db 01ch,0c1h,09ch,0eeh,015h,0fah,092h,087h,0f8h,0c6h,093h,01dh,0e2h,054h,044h,0f2h
		db 0f0h,0b5h,09dh,053h,0d5h,0e1h,017h,0f3h,021h,0ech,0fbh,0b7h,0d2h,0a6h,0b5h,0a3h
		db 09eh,0bah,0deh,0c3h,046h,00ah,067h,079h,0a3h,049h,095h,064h,008h,05eh,011h,07ah
		db 07fh,02ah,098h,025h,0bah,0d4h,065h,00eh,027h,0b0h,02dh,052h,09fh,0b1h,0d6h,008h
		db 0a1h,018h,016h,0aah,0e4h,0e8h,074h,07bh,031h,01ch,05dh,0fah,066h,067h,07dh,0cdh
		db 0eeh,046h,0e5h,07fh,044h,038h,0e0h,0a2h,04dh,024h,027h,029h,0b3h,0a7h,033h,0e8h
		db 017h,043h,060h,098h,0cch,0d3h,0c0h,099h,0cdh,08bh,0bbh,0bfh,045h,07ah,0ach,0b1h
		db 00ah,0f3h,0adh,0ebh,0c8h,0feh,07ah,015h,01eh,0fdh,08ah,014h,0c4h,0f5h,0b0h,031h
		db 0bdh,0dbh,0b1h,08eh,0dch,015h,018h,00dh,06ch,0c4h,066h,022h,0aeh,0c5h,078h,084h
		db 058h,045h,0e4h,0a4h,0a4h,0d6h,0d1h,0a5h,062h,00bh,0c9h,0c7h,077h,0cch,07bh,08ah
		db 0f5h,03fh,01ah,0d8h,00dh,007h,0c7h,0f6h,04ch,0e6h,0bdh,0b3h,032h,083h,0e7h,054h
		db 038h,0aeh,04ch,05eh,075h,0a4h,089h,0c6h,072h,0d8h,045h,012h,00fh,0ceh,076h,040h
		db 085h,02dh,035h,0d2h,018h,069h,0cbh,03ah,060h,0edh,05eh,046h,0c5h,0eah,086h,080h
		db 087h,0a1h,040h,021h,037h,04fh,014h,027h,020h,048h,0efh,02ch,00bh,09bh,0d2h,0abh
		db 069h,090h,05ch,003h,0b4h,0fbh,0f8h,0e5h,01ah,050h,0b9h,026h,0bfh,039h,0f1h,0f5h
		db 0d6h,0dch,0beh,02ah,0e0h,04ah,099h,088h,0fdh,02eh,0ebh,06bh,0f2h,0f6h,0e1h,0f0h
		db 0f3h,0e2h,0b4h,0ffh,080h,0e3h,04dh,0dch,041h,00eh,06ch,04eh,0aah,0c8h,037h,03eh
		db 0f4h,014h,015h,09ch,070h,055h,054h,0cah,063h,0a3h,09bh,0bah,073h,03dh,02eh,0e6h
		db 030h,0d0h,091h,01eh,05eh,004h,0d9h,09ah,005h,042h,005h,002h,0e3h,08ah,0b7h,063h
		db 095h,091h,03ch,032h,000h,0d7h,0f7h,089h,001h,010h,077h,08fh,0f7h,03bh,0f6h,0a9h
		db 0a5h,066h,0dbh,0d0h,02eh,06ah,00ah,0d1h,0c7h,0dfh,0dah,05fh,0f6h,07ch,0c2h,0b6h
		db 071h,021h,0f4h,047h,07ah,051h,03ah,0feh,084h,0cah,0bfh,090h,053h,098h,09fh,005h
		db 0dfh,056h,090h,0f4h,0d9h,064h,088h,0bdh,022h,0b9h,007h,041h,026h,0abh,081h,02eh
		db 0b0h,084h,075h,06dh,043h,0a0h,01bh,04dh,088h,000h,008h,057h,057h,001h,0f2h,07dh
		db 007h,073h,0a5h,0b4h,02fh,05dh,0afh,086h,0fbh,047h,0f9h,02dh,0b5h,020h,02fh,05bh
		db 010h,0c0h,08dh,060h,054h,01ah,0b3h,08ch,01dh,0bdh,0aeh,020h,009h,0cbh,0ffh,062h
		db 089h,0f2h,034h,043h,0b7h,017h,0c6h,083h,093h,0ebh,071h,013h,094h,0bbh,0d7h,04bh
		db 04ah,07dh,0cdh,0ech,004h,0bch,021h,0edh,012h,0d9h,038h,082h,024h,033h,000h,05dh
		db 028h,09ch,001h,0d6h,091h,05fh,04bh,0e7h,03ch,086h,0cch,055h,016h,0f9h,028h,0e2h
		db 03dh,09dh,04ah,0c0h,08dh,01dh,009h,0b2h,036h,06eh,08bh,0fbh,05dh,012h,069h,076h
		db 0c1h,04eh,05ah,035h,0ddh,03ah,063h,011h,0e5h,032h,06dh,0d5h,02bh,070h,056h,0efh
		db 092h,0aah,072h,0cch,039h,09eh,0d3h,01ah,006h,003h,0c5h,09eh,0afh,035h,0cah,04ah
		db 040h,01eh,029h,000h,03ah,031h,059h,001h,019h,058h,006h,050h,0d3h,08eh,041h,0dah
		db 048h,026h,032h,016h,082h,027h,025h,0a8h,0adh,025h,00eh,091h,06ah,08dh,0abh,0a1h
		db 08ah,0f1h,002h,042h,07ch,0e4h,030h,037h,01bh,02bh,058h,0fdh,03eh,077h,01ch,0d4h
		db 03fh,099h,01dh,0cbh,0beh,078h,05fh,0d9h,0d1h,0deh,0fah,07ch,074h,05bh,070h,0ceh
		db 052h,09fh,0c3h,0dbh,0e8h,005h,022h,018h,079h,02ch,023h,0c8h,09bh,09ah,084h,056h
		db 07dh,08fh,0e3h,034h,035h,0e9h,079h,059h,0abh,06dh,048h,06fh,00eh,0e5h,0a3h,009h
		db 049h,0d2h,0aah,0ach,0cah,07bh,0d8h,05ah,0bbh,044h,05bh,061h,0f9h,080h,0d0h,09dh
		db 08bh,0beh,003h,092h,06dh,062h,064h,006h,013h,095h,080h,073h,09ch,0c3h,0a7h,08bh
		db 0bch,089h,0a1h,0c1h,003h,040h,096h,0e3h,067h,00ch,09ah,0bch,0b2h,0a8h,04eh,01bh
		db 090h,0f8h,0edh,05ch,0eah,037h,0cfh,0e1h,0e9h,0c2h,082h,039h,05ah,0b7h,0c8h,08dh
		db 05bh,0c7h,042h,038h,033h,0dah,083h,0f7h,02dh,065h,0f3h,097h,09dh,0efh,0fdh,0c9h
		db 086h,016h,053h,00fh,047h,029h,03eh,028h,06bh,0f0h,03fh,081h,0e1h,081h,0a6h,0cfh
		db 056h,052h,0eah,072h,064h,053h,026h,00ah,065h,013h,0dfh,067h,0ach,094h,0e2h,065h
		db 0c0h,068h,0b6h,0f1h,0efh,041h,0a9h,01ch,02ah,085h,03bh,095h,011h,03ch,0fch,0d3h
		db 0b9h,036h,0e8h,03bh,0c6h,0afh,052h,0f9h,04fh,05ah,06ah,02fh,061h,079h,0f0h,03fh
		db 08fh,030h,0a0h,03ch,0b6h,0fch,0f5h,03dh,098h,0e7h,0d5h,0d7h,03bh,0b8h,0bah,068h
		db 08eh,057h,020h,0ddh,068h,076h,0ech,078h,0dbh,0cdh,057h,0a7h,07bh,0bfh,0dch,030h
		db 002h,02ch,0a0h,000h,034h,006h,082h,001h,035h,0b9h,076h,00eh,04bh,05ah,0fch,00bh
		db 0f6h,01fh,0c3h,054h,070h,02eh,0cfh,045h,03eh,07dh,0a9h,062h,0e0h,01ch,07ah,0a8h
		db 078h,02ah,0d1h,0beh,037h,02bh,013h,092h,0f4h,0c7h,0b0h,050h,09ch,0fch,047h,0bah
		db 089h,06ah,0bbh,049h,0ebh,0f3h,07dh,084h,013h,036h,079h,08fh,069h,03ch,0e6h,0f2h
		db 054h,012h,0e1h,04bh,088h,005h,0a4h,0b9h,0feh,029h,016h,030h,046h,017h,00dh,02eh
		db 047h,0efh,0eah,086h,024h,028h,06dh,0dfh,0c4h,09dh,036h,073h,028h,0b0h,0abh,075h
		db 0fbh,03eh,092h,018h,082h,0edh,0f8h,019h,022h,0f4h,06eh,0f4h,048h,024h,0a5h,0ffh
		db 079h,0abh,0f6h,096h,00ah,04fh,0b9h,034h,0c3h,061h,01bh,065h,025h,002h,030h,0e1h
		db 087h,0deh,031h,004h,0a8h,0eeh,0c2h,014h,0eah,06dh,005h,061h,0f1h,013h,0ech,082h
		db 055h,0d7h,064h,0d3h,0b7h,0e4h,0d5h,06ch,0adh,048h,068h,067h,0a9h,049h,028h,00fh
		db 0dah,097h,014h,0e8h,017h,095h,083h,0e2h,03dh,0f9h,0b3h,010h,091h,0e5h,03bh,0e3h
		db 062h,020h,0ddh,0a7h,003h,038h,0adh,0c6h,0dbh,096h,04ch,083h,0d5h,079h,05ah,0b1h
		db 0a1h,07ch,0cdh,090h,071h,0e3h,051h,0bdh,043h,0bah,02ch,09eh,09eh,0d4h,032h,029h
		db 0d2h,072h,04dh,041h,0edh,047h,0ach,0f1h,067h,05bh,0a1h,023h,0a2h,009h,08bh,07dh
		db 076h,026h,08eh,008h,0d8h,0c1h,007h,0d1h,0bfh,086h,0b6h,0ebh,06bh,0f2h,04ah,0d2h
		db 0f0h,0d0h,0bch,063h,00eh,0a6h,04eh,08dh,0c8h,0c6h,04fh,097h,072h,0aah,0f2h,055h
		db 073h,062h,0f1h,038h,01ch,063h,07ch,042h,030h,042h,069h,0d8h,00fh,098h,03dh,095h
		db 058h,052h,0deh,05bh,03ch,06bh,0d7h,028h,080h,03fh,0f3h,0d0h,0f5h,091h,0e4h,026h
		db 0deh,010h,089h,058h,0f8h,0d3h,02bh,0fch,05fh,0ach,0c0h,01dh,05eh,05dh,0c8h,037h
		db 08fh,0f7h,08ah,07fh,0cch,067h,027h,02ah,0fah,0cch,046h,05ah,0d3h,07ah,093h,0f0h
		db 0c1h,069h,019h,0e9h,042h,0b6h,045h,0a5h,063h,02fh,09ch,085h,0e1h,0f6h,02eh,005h
		db 0a6h,0e1h,067h,0e0h,011h,0dbh,040h,0c0h,02fh,0cfh,024h,08bh,06ah,09fh,0dah,051h
		db 060h,084h,066h,0d5h,07dh,05ch,057h,089h,0b3h,00ah,041h,08eh,032h,045h,054h,076h
		db 045h,0cah,073h,0deh,0efh,080h,00ah,00ch,0bch,0eah,05ch,011h,0f3h,09bh,029h,0a4h
		db 056h,04dh,033h,02ch,005h,004h,0e7h,081h,0bbh,075h,0e5h,059h,0ceh,022h,0dbh,09ch
		db 029h,064h,021h,078h,08eh,077h,048h,04fh,03ah,099h,060h,04dh,09ah,083h,0c5h,09bh
		db 09bh,08ah,08fh,068h,009h,08bh,09fh,069h,0a5h,054h,026h,077h,040h,0ffh,02fh,033h
		db 014h,0c0h,01dh,021h,09fh,08dh,07eh,0c8h,0fdh,0d5h,07fh,0f3h,0c9h,0bdh,0d2h,032h
		db 0c5h,01dh,075h,070h,0a0h,0d8h,0eeh,071h,00dh,068h,004h,044h,02ah,00dh,084h,0d7h
		db 007h,025h,085h,0fbh,015h,033h,0bfh,0b8h,0b6h,074h,0a7h,056h,083h,073h,0d8h,0b6h
		db 08ch,008h,055h,047h,051h,0fbh,0a8h,0feh,0bdh,01eh,081h,08ah,0aeh,066h,0f9h,009h
		db 0afh,0f8h,095h,006h,02ch,0aeh,072h,002h,044h,0a0h,043h,0b0h,0b1h,0a1h,010h,06dh
		db 059h,00ch,03ch,0a3h,05ah,051h,050h,039h,0e3h,05eh,0b8h,07ah,085h,050h,00bh,0b4h
		db 0eeh,0dfh,0d9h,03ah,038h,016h,008h,0d6h,068h,0cdh,0b2h,01ah,0a3h,0e6h,0a3h,016h
		db 0b4h,0d1h,003h,0e4h,05dh,034h,088h,087h,0cdh,060h,0e0h,043h,092h,090h,035h,0cdh
		db 095h,023h,02ah,04ah,0d1h,09ch,0e3h,053h,00ch,05fh,09ah,017h,0cah,00bh,0bdh,080h
		db 093h,021h,0cch,0f6h,0beh,02dh,020h,0e5h,03fh,0c9h,0e2h,031h,05bh,065h,0edh,0fdh
		db 04dh,08ch,038h,0a6h,041h,070h,0dch,00dh,0ach,0afh,05eh,0f9h,0d9h,0d6h,018h,003h
		db 098h,018h,044h,0efh,066h,0a5h,002h,040h,0c7h,04bh,049h,05fh,084h,0c5h,01fh,05ch
		db 0abh,0b1h,058h,0eah,0b9h,06ch,06bh,072h,057h,093h,00ch,079h,036h,044h,011h,022h
		db 0cbh,0c2h,03eh,0e7h,08ah,0c3h,05bh,0b7h,081h,06fh,04bh,0c9h,07bh,0a9h,0b4h,052h
		db 0f2h,0a7h,0b5h,0fah,01bh,0a3h,065h,09dh,061h,071h,0bah,036h,02dh,0dch,0aeh,093h
		db 053h,09eh,05dh,099h,0dch,014h,0c6h,0ach,0ddh,07eh,097h,0aah,01eh,056h,0e9h,0abh
		db 096h,04eh,099h,0aeh,074h,0fdh,0feh,057h,0c2h,0e7h,0b1h,088h,019h,0b8h,0aah,0bch
		db 08dh,0bfh,01eh,07ch,090h,032h,06ch,035h,099h,00fh,052h,0b2h,0dfh,07fh,063h,0b3h
		db 064h,0ceh,0ceh,098h,0e8h,053h,06ah,09ah,0e9h,015h,071h,091h,006h,087h,0f4h,0d4h
		db 008h,088h,09eh,01eh,03bh,09ah,0cah,06ah,0b0h,04ah,0cbh,048h,00bh,0feh,023h,015h
		db 04eh,03dh,009h,0eeh,0ech,01bh,074h,03eh,07fh,037h,056h,0c7h,010h,0bch,094h,0f7h
		db 0cfh,089h,087h,07bh,0bah,058h,01ch,066h,0fch,003h,08dh,0c2h,06eh,031h,059h,0c3h
		db 027h,0beh,09dh,0f8h,01fh,0f5h,0f5h,0ceh,04ah,0e8h,039h,064h,031h,0e9h,0c4h,0dch
		db 06ch,082h,0b7h,0c5h,07eh,039h,02dh,0a9h,0c6h,092h,01ah,03ch,02bh,0b7h,080h,0f5h
		db 0a4h,027h,062h,020h,000h,0a8h,00fh,02fh,001h,0b2h,0d3h,04eh,04fh,04ch,0ffh,0cbh
		db 075h,081h,096h,025h,033h,094h,00eh,0afh,052h,0e2h,091h,02bh,0aah,0cbh,08ch,05dh
		db 01dh,040h,0f0h,09fh,0d7h,0bbh,0c7h,03fh,07ch,0a4h,05fh,0c1h,094h,0b4h,042h,0ddh
		db 0d0h,06eh,0afh,03dh,08bh,0a2h,034h,046h,016h,0e0h,015h,0dah,0a7h,019h,0e8h,0dbh
		db 0d6h,078h,006h,06bh,020h,0d2h,0c1h,012h,0b5h,000h,0d0h,0cfh,0e4h,001h,025h,007h
		db 04ch,0c8h,090h,0b5h,0f9h,08fh,086h,0e6h,086h,0adh,06fh,0bbh,01ah,03ah,0f7h,0a1h
		db 0e5h,08eh,012h,05eh,0c0h,076h,03fh,0ech,0e7h,0ddh,0dfh,060h,077h,035h,022h,074h
		db 021h,0b5h,0beh,01bh,02eh,030h,0fah,094h,05ch,046h,0fbh,06fh,06fh,0b3h,0a6h,00ah
		db 012h,0fah,077h,0a2h,004h,07bh,070h,0cch,0e6h,0f0h,0ebh,03bh,0b2h,057h,000h,0cah
		db 049h,043h,001h,04ch,0f7h,007h,0d6h,0adh,097h,03bh,09bh,02dh,0e2h,085h,0c9h,0edh
		db 039h,011h,037h,0a0h,050h,0d9h,061h,027h,0ffh,0ebh,0a2h,07eh,065h,059h,078h,0d9h
		db 0d4h,0ech,0d4h,024h,09dh,0dah,098h,06eh,06dh,0f1h,053h,01ch,0b8h,00eh,017h,0bfh
		db 07ah,041h,03ah,01fh,018h,01ah,0efh,0c4h,023h,055h,0fdh,013h,026h,0c4h,07bh,08ch
perm_order	db  31, 23, 15,  7, 30, 22, 14,  6, 29, 21, 13,  5, 28, 20, 12,  4
		db  27, 19, 11,  3, 26, 18, 10,  2, 25, 17,  9,  1, 24, 16,  8,  0