FEAL_ROUND	equ	64

.code
FealN_SetKey	proc	ptrPass:DWORD

	pushad

	mov	edi, ptrPass
	mov	esi, offset feal_temp_buffer

	push	dword ptr [edi]
	push	dword ptr [edi+4]
	pop	dword ptr [esi+4]
	pop	dword ptr [esi]

	mov	ebx, offset internal_pass
	xor	eax, eax
	xor	edx, edx
	xor	ebp, ebp
	mov	cl, FEAL_ROUND/2+4

@@:
	mov	ah, byte ptr [esi]
	mov	dl, byte ptr [esi+2]
	xor	ah, byte ptr [esi+1]
	xor	dl, byte ptr [esi+3]
	mov	ch, byte ptr [esi+4]
	inc	ah
	xor	ch, dl
	mov	al, byte ptr [esi+6]
	add	ah, ch
	mov	dh, byte ptr [esi+7]
	rol	ah, 2
	mov	ch, byte ptr [esi+5]
	xor	ch, ah
	add	dl, ch
	xor	al, ah
	rol	dl, 2
	add	al, byte ptr [esi]
	xor	dh, dl
	rol	al, 2
	add	dh, byte ptr [esi+3]
	mov	word ptr [ebx], ax
	inc	dh
	xor	ebp, dword ptr [esi+4]
	rol	dh, 2
	xchg	ebp, dword ptr [esi]
	mov	word ptr [ebx+2], dx
	mov	edi, ebp
	xor	edi, dword ptr [ebx]
	add	ebx, 4
	dec	cl
	mov	dword ptr [esi+4], edi
	jnz	@B
	
	and	dword ptr [esi], 0
	and	dword ptr [esi+4], 0
	popad
	ret
FealN_SetKey	endp

FealN_Encrypt	proc	ptrOut:DWORD, ptrIn:DWORD

	pushad

	mov	esi, ptrIn
	mov	edi, ptrOut
	mov	ebx, offset internal_pass
	
	mov	ebp, dword ptr [esi]
	mov	esi, dword ptr [esi+4]

	xor	ebp, dword ptr [ebx+FEAL_ROUND*2]
	xor	esi, dword ptr [ebx+FEAL_ROUND*2 +4]
	xor	esi, ebp
	mov	cl, FEAL_ROUND

@@:
	push	esi		;[esp] = temp buffer
	mov	ch, byte ptr [esp]
	mov	al, byte ptr [esp+2]
	xor	ch, byte ptr [esp+1]
	xor	al, byte ptr [ebx+1]
	xor	ch, byte ptr [ebx]
	xor	al, byte ptr [esp+3]
	mov	ah, byte ptr [esp+3]
	add	ch, al
	inc	ah
	inc	ch
	add	ebx, 2
	rol	ch, 2
	add	al, ch
	rol	al, 2
	add	ah, al
	rol	ah, 2
	shl	eax, 16
	xchg	ebp, esi
	mov	al, ch
	add	al, byte ptr [esp]
	mov	ah, ch
	rol	al, 2
	add	esp, 4
	xor	esi, eax
	dec	cl
	jnz	@B

	and	dword ptr [esp-4],0
	xor	ebp, esi
	xor	ebp, dword ptr [ebx+12]
	xor	esi, dword ptr [ebx+8]
	mov	dword ptr [edi+4], ebp
	mov	dword ptr [edi], esi	
	popad
	ret
FealN_Encrypt	endp

.data?
internal_pass		dd FEAL_ROUND/2+4 dup (?)
feal_temp_buffer	db 8 dup (?)