.386
option casemap:none

comment *

Algo	: 3-Way
Block	: 12 bytes
Key	: 12 bytes

	push	offset password		;password ptr
	push	offset data		;data to encrypt ptr
	call	threeway_en

	push	offset password		;password ptr
	push	offset data		;data to decrypt ptr
	call	threeway_de


09.01.2002 WiteG//xtreeme (witeg@poczta.fm, www.witeg.prv.pl)

*

_3way_core	macro		;ED
	mov	edi, eax
	rol	ebx, 16
	rol	ecx, 16
	xor	bl, bh
	rol	eax, 16
	xor	ebx, ecx
	xor	edi, eax
	ror	ecx, 8
	and	eax, 0FFFF00FFh
	xor	ebx, ecx
	ror	eax, 8
	ror	ecx, 8
	xor	edi, eax
	shr	ecx, 8
	xor	ebx, edi
	shl	eax, 16
	xor	ebx, ecx
	xor	ebx, eax
endm

.data?
ptr_pass	dd ?		;E
counter		dd ?		;ED
a0		dd ?		;ED
a1		dd ?		;ED
a2		dd ?		;ED
b0		dd ?		;ED
b1		dd ?		;ED
b2		dd ?		;ED

comment *
E - macro or data needed for encryption
D - macro or data needed for decryption
*

.code
threeway_en	proc	ptrData :DWORD, ptrPass :DWORD

	pushad
	push	ebp	
	mov	esi, ptrData
	mov	eax, ptrPass
	mov	ptr_pass, eax

	mov	ebp, offset const_en	
	mov	counter, 11
	mov	eax, dword ptr [esi]
	mov	ebx, dword ptr [esi+4]
	mov	ecx, dword ptr [esi+8]

@@big_loop:		;a0 = eax, a1 = ebx, a2 = ecx
	mov	edi, ptr_pass

	xor	eax, dword ptr [edi]
	xor	ecx, dword ptr [ebp+4]
	xor	ebx, dword ptr [edi+4]
	xor	eax, dword ptr [ebp]
	xor	ecx, dword ptr [edi+8]

;	***** THETA ***** start

	mov	a0, eax
	mov	a1, ebx
	mov	a2, ecx

	_3way_core

	mov	b0, ebx

	mov	eax, a1
	mov	ebx, a2
	mov	ecx, a0

	_3way_core

	mov	b1, ebx

	mov	eax, a2
	mov	ebx, a0
	mov	ecx, a1

	_3way_core

	mov	b2, ebx

	mov	eax, b0
	mov	ebx, b1
	mov	ecx, b2
	
;	***** THETA ***** end

;	***** PI_1  ***** start

	ror	eax, 10
	rol	ecx, 1
	
;	***** PI_1  ***** end

;	***** GAMMA ***** start

	mov	edx, ecx		;a[2]
	mov	esi, eax		;a[0]
	not	edx			;(~a[2])
	mov	edi, ebx		;a[1]
	not	esi			;(~a[0])
	or	edx, ebx		;(a[1]|(~a[2]))
	not	edi			;(~a[1])
	or	esi, ecx		;(a[2]|(~a[0]))
	xor	edx, eax		;b[0] = a[0] ^ (a[1]|(~a[2]))
	or	edi, eax		;(a[0]|(~a[1]))
	xor	esi, ebx		;b[1] = a[1] ^ (a[2]|(~a[0]))
	mov	eax, edx		;a[0] = b[0]
	xor	ecx, edi		;b[2] = a[2] ^ (a[0]|(~a[1]))
	mov	ebx, esi

;	***** GAMMA ***** end

;	***** PI_2  ***** start

	ror	ecx, 10
	rol	eax, 1
	
;	***** PI_2  ***** end

	add	ebp, 8
	dec	counter
	jnz	@@big_loop

	mov	edi, ptr_pass

	xor	eax, dword ptr [edi]
	xor	ecx, dword ptr [ebp+4]
	xor	ebx, dword ptr [edi+4]
	xor	eax, dword ptr [ebp]
	xor	ecx, dword ptr [edi+8]

;	***** THETA ***** start

	mov	a0, eax
	mov	a1, ebx
	mov	a2, ecx

	_3way_core

	mov	b0, ebx

	mov	eax, a1
	mov	ebx, a2
	mov	ecx, a0

	_3way_core

	mov	b1, ebx

	mov	eax, a2
	mov	ebx, a0
	mov	ecx, a1

	_3way_core

	mov	b2, ebx

	mov	eax, b0
	mov	ebx, b1
	mov	ecx, b2
	
;	***** THETA ***** end
	pop	ebp

	mov	esi, ptrData

	mov	edx, 8
	xor	edi, edi
@@:
	mov	dword ptr [ptr_pass+4*edx-4], edi
	dec	edx
	jnz	@B

	mov	dword ptr [esi], eax
	mov	dword ptr [esi+4], ebx
	mov	dword ptr [esi+8], ecx
	popad
	ret

const_en	dd 00B0B0000h,000000B0Bh,016160000h,000001616h,02C2C0000h,000002C2Ch,058580000h,000005858h,0B0B00000h,00000B0B0h,071710000h,000007171h
		dd 0E2E20000h,00000E2E2h,0D5D50000h,00000D5D5h,0BBBB0000h,00000BBBBh,067670000h,000006767h,0CECE0000h,00000CECEh,08D8D0000h,000008D8Dh

threeway_en	endp