include data.inc
include bigmul4096.inc
include bigdiv4096.inc
include bigsub4096.inc

.data?
	x	dd 128 dup (?)
	y	dd 128 dup (?)
	z	dd 128 dup (?)

.code
RSA	proc	ptrC :DWORD, ptrN :DWORD, ptrM :DWORD

	push	ptrM
	push	ptrM
	push	offset x		;x = SN^2
	call	BigMul

	push	offset x
	push	ptrN
	push	offset y		;y = SN^2/N
	call	BigDiv

	push	offset y
	push	ptrN
	push	offset z		;z = (SN^2/N)*N
	call	BigMul

	push	offset x
	push	offset z
	push	offset y		;y = SN^2 - (SN^2/N)*N
	call	BigSub

	push	ptrM
	push	offset y
	push	offset z		;z = y*SN
	call	BigMul

	push	offset z
	push	ptrN
	push	offset x		;x = (y*SN/N) = z/N
	call	BigDiv

	push	offset x
	push	ptrN
	push	offset y		;y = (z/N)*N
	call	BigMul

	push	offset z
	push	offset y
	push	ptrC			;(y*SN) - (y*SN/N)*N
	call	BigSub
	ret
RSA	endp