/*
 * Decompiled with CFR 0.152.
 */
package sdloader.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import sdloader.util.CollectionsUtil;
import sdloader.util.PathUtil;

public class WebUtil {
    private static final DateFormat HEADER_DATE_FORMAT = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'", Locale.UK);
    private static final DateFormat COOKIE_DATE_FORMAT = new SimpleDateFormat("E, d-MMM-yyyy HH:mm:ss 'GMT'", Locale.UK);
    public static final int PATTERN_NOMATCH = 0;
    public static final int PATTERN_DEFAULT_MATCH = 1;
    public static final int PATTERN_EXT_MATCH = 2;
    public static final int PATTERN_PATH_MATCH = 3;
    public static final int PATTERN_EXACT_MATCH = 4;

    private WebUtil() {
    }

    public static String parseCharsetFromContentType(String value) {
        String sepString = "charset=";
        int sep = value.indexOf("charset=");
        if (sep != -1) {
            int endIndex = value.length();
            int scIndex = value.indexOf(";", sep += "charset=".length());
            if (scIndex != -1) {
                endIndex = scIndex;
            }
            String charSet = value.substring(sep, endIndex);
            return charSet.trim();
        }
        return null;
    }

    public static void checkSupportedEndcoding(String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            throw new UnsupportedCharsetException("Charset is null.");
        }
        URLDecoder.decode("", encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parseHeaderDate(String date) throws ParseException {
        DateFormat dateFormat = HEADER_DATE_FORMAT;
        synchronized (dateFormat) {
            return HEADER_DATE_FORMAT.parse(date).getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parseCookieDate(String date) throws ParseException {
        DateFormat dateFormat = COOKIE_DATE_FORMAT;
        synchronized (dateFormat) {
            return COOKIE_DATE_FORMAT.parse(date).getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatHeaderDate(Date date) {
        DateFormat dateFormat = HEADER_DATE_FORMAT;
        synchronized (dateFormat) {
            return HEADER_DATE_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatCookieDate(Date date) {
        DateFormat dateFormat = COOKIE_DATE_FORMAT;
        synchronized (dateFormat) {
            return COOKIE_DATE_FORMAT.format(date);
        }
    }

    public static URL[] createClassPaths(String targetDir, FileFilter fileFilter, boolean recursive) {
        return WebUtil.createClassPaths(new File(targetDir), fileFilter, recursive);
    }

    public static URL[] createClassPaths(File targetDir, FileFilter fileFilter, boolean recursive) {
        File[] dirs;
        if (!targetDir.exists()) {
            return null;
        }
        ArrayList<URL> urlList = CollectionsUtil.newArrayList();
        File[] libs = targetDir.listFiles(fileFilter);
        if (libs != null) {
            for (int i = 0; i < libs.length; ++i) {
                urlList.add(PathUtil.file2URL(libs[i]));
            }
        }
        if (recursive && (dirs = targetDir.listFiles()) != null) {
            for (int i = 0; i < dirs.length; ++i) {
                URL[] urls;
                if (!dirs[i].isDirectory() || (urls = WebUtil.createClassPaths(dirs[i].getAbsolutePath(), fileFilter, recursive)) == null) continue;
                for (int j = 0; j < urls.length; ++j) {
                    urlList.add(urls[j]);
                }
            }
        }
        return urlList.toArray(new URL[0]);
    }

    public static String getResourcePath(String contextPath, String requestURI) {
        if (requestURI == null) {
            return null;
        }
        if (requestURI.equals("/")) {
            return "/";
        }
        if (contextPath.equals(requestURI)) {
            return null;
        }
        String servletPath = requestURI.substring(contextPath.length(), requestURI.length());
        return servletPath;
    }

    public static String getServletPath(String pattern, String resourcePath) {
        if (resourcePath == null) {
            return null;
        }
        int type = WebUtil.matchPattern(pattern, resourcePath);
        switch (type) {
            case 1: {
                return "";
            }
            case 2: 
            case 4: {
                return resourcePath;
            }
            case 3: {
                return pattern.substring(0, pattern.length() - "/*".length());
            }
        }
        throw new RuntimeException("PATTERN_NOMATCH pattern=" + pattern + " path=" + resourcePath);
    }

    public static String getPathInfo(String pattern, String resourcePath) {
        if (resourcePath == null) {
            return null;
        }
        int type = WebUtil.matchPattern(pattern, resourcePath);
        switch (type) {
            case 1: {
                return resourcePath;
            }
            case 2: 
            case 4: {
                return null;
            }
            case 3: {
                return resourcePath.substring(pattern.length() - "/*".length());
            }
        }
        throw new RuntimeException("PATTERN_NOMATCH pattern=" + pattern + " path=" + resourcePath);
    }

    public static int matchPattern(String pattern, String path) {
        int patternDot;
        String patternExt;
        String resourceExt;
        int resourceDot;
        if (pattern == null || path == null) {
            return 0;
        }
        if (pattern.equals(path)) {
            return 4;
        }
        if (pattern.equals("/*")) {
            return 1;
        }
        if (pattern.endsWith("/*")) {
            if (pattern.regionMatches(0, path, 0, pattern.length() - 2)) {
                if (path.length() == pattern.length() - 2) {
                    return 3;
                }
                if (path.charAt(pattern.length() - 2) == '/') {
                    return 3;
                }
            }
            return 0;
        }
        if (pattern.startsWith("*.") && (resourceDot = path.lastIndexOf(".")) >= 0 && (resourceExt = path.substring(resourceDot, path.length())).equals(patternExt = pattern.substring(patternDot = pattern.indexOf("."), pattern.length()))) {
            return 2;
        }
        return 0;
    }

    public static String stripQueryPart(String requestURI) {
        int queryIndex = requestURI.indexOf("?");
        if (queryIndex > 0) {
            return requestURI.substring(0, queryIndex);
        }
        return requestURI;
    }

    public static String getQueryPart(String requestURI) {
        int queryIndex = requestURI.indexOf("?");
        if (queryIndex > 0) {
            return requestURI.substring(queryIndex + 1, requestURI.length());
        }
        return null;
    }

    public static StringBuffer buildRequestURL(String scheme, String host, int port, String requestURI) {
        String portString = port == 80 && scheme.equals("http") ? "" : (port == 443 && scheme.equals("https") ? "" : ":" + port);
        requestURI = WebUtil.stripQueryPart(requestURI);
        return new StringBuffer(scheme + "://" + host + portString + requestURI);
    }

    public static StringBuffer buildRequestURL(String scheme, String host, String requestURI) {
        String portString;
        int portSep = host.indexOf(":");
        if (portSep != -1) {
            portString = host.substring(portSep + 1);
            host = host.substring(0, portSep);
        } else if (scheme.equals("http")) {
            portString = "";
        } else if (scheme.equals("https")) {
            portString = "";
        } else {
            throw new RuntimeException("schema:" + scheme + " not support.");
        }
        return WebUtil.buildRequestURL(scheme, host, Integer.parseInt(portString), requestURI);
    }

    public static void writeNotFoundPage(HttpServletResponse res) throws IOException {
        res.setStatus(404);
        res.setContentType("text/html;charset=UTF-8");
        PrintWriter writer = res.getWriter();
        writer.write("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">");
        writer.write("<html><head>");
        writer.write("<title>404 Not Found</title>");
        writer.write("<head><body>");
        writer.write("<h1>Not Found</h1>");
        writer.write("<p>The requested URL resource was not found on this SDLoader.</p>");
        writer.write("<body></html>");
        writer.flush();
    }
}

