/*
 * Decompiled with CFR 0.152.
 */
package sdloader.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import sdloader.log.SDLoaderLog;
import sdloader.log.SDLoaderLogFactory;
import sdloader.util.IOUtil;
import sdloader.util.ResourceUtil;

public class WarUtil {
    private static SDLoaderLog log = SDLoaderLogFactory.getLog(WarUtil.class);
    private static final String LAST_MODIFIED_FILE = ".warlastmodified";

    public static String getArchiveName(String warFileName) {
        return warFileName.substring(0, warFileName.length() - ".war".length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long readLastModifiled(File file) {
        if (file.exists()) {
            long l;
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                l = Long.valueOf(reader.readLine());
            }
            catch (Exception e) {
                try {
                    log.debug(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    IOUtil.closeNoException(reader);
                    throw throwable;
                }
                IOUtil.closeNoException(reader);
            }
            IOUtil.closeNoException(reader);
            return l;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLastModifiled(File file, long time) {
        BufferedWriter writer = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(Long.toString(time));
            writer.flush();
            IOUtil.closeNoException(writer);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), e);
        }
        finally {
            IOUtil.closeNoException(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractWar(File warFile, File directory) throws IOException {
        try {
            long timestamp = warFile.lastModified();
            File warModifiedTimeFile = new File(directory, LAST_MODIFIED_FILE);
            long lastModified = WarUtil.readLastModifiled(warModifiedTimeFile);
            if (timestamp == lastModified) {
                log.info("war file " + warFile.getName() + " not modified.");
                return;
            }
            if (directory.exists()) {
                IOUtil.forceRemoveDirectory(directory);
                directory.mkdir();
            }
            log.info("war extract start. warfile=" + warFile.getName());
            JarInputStream jin = new JarInputStream(new BufferedInputStream(new FileInputStream(warFile)));
            JarEntry entry = null;
            while ((entry = jin.getNextJarEntry()) != null) {
                File file = new File(directory, entry.getName());
                if (entry.isDirectory()) {
                    if (file.exists()) continue;
                    file.mkdirs();
                    continue;
                }
                File dir = new File(file.getParent());
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                OutputStream fout = null;
                try {
                    fout = new FileOutputStream(file);
                    ResourceUtil.copyStream(jin, fout);
                }
                finally {
                    fout.flush();
                    ((FileOutputStream)fout).close();
                    fout = null;
                }
                if (entry.getTime() < 0L) continue;
                file.setLastModified(entry.getTime());
            }
            WarUtil.writeLastModifiled(warModifiedTimeFile, timestamp);
            log.info("war extract success. lastmodified=" + timestamp);
        }
        catch (IOException ioe) {
            log.info("war extract fail.");
            throw ioe;
        }
    }
}

