/*
 * Decompiled with CFR 0.152.
 */
package sdloader.util;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextFormatUtil {
    private static final Pattern REPLACE_PATTERN = Pattern.compile("\\$\\{[^}]*\\}");

    public static String formatTextBySystemProperties(String text) {
        return TextFormatUtil.formatTextByProperties(text, System.getProperties());
    }

    public static String formatTextByProperties(String text, Properties prop) {
        Matcher m = REPLACE_PATTERN.matcher(text);
        StringBuffer buf = new StringBuffer();
        while (m.find()) {
            String key = TextFormatUtil.trimKey(m.group());
            String value = prop.getProperty(key);
            if (value == null) {
                throw new RuntimeException("Property not found.property key=" + key);
            }
            m.appendReplacement(buf, value);
        }
        m.appendTail(buf);
        return buf.toString();
    }

    private static String trimKey(String key) {
        String trimKey = key.substring(2);
        return trimKey.substring(0, trimKey.length() - 1);
    }
}

