/*
 * Decompiled with CFR 0.152.
 */
package sdloader.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil {
    public static String stripFirstProtocolPart(String path) {
        return path.substring(path.indexOf(":") + 1, path.length());
    }

    public static String stripExtension(String value) {
        int dot = value.lastIndexOf(".");
        if (dot >= 0) {
            value = value.substring(0, dot);
        }
        return value;
    }

    public static URL createURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL createURL(URL baseURL, String relativeURL) {
        try {
            String protocol = baseURL.getProtocol();
            relativeURL = relativeURL.replace("\\", "/");
            if (protocol.startsWith("file")) {
                if (relativeURL.startsWith("/")) {
                    relativeURL = relativeURL.substring(1, relativeURL.length());
                }
                return new URL(baseURL, relativeURL);
            }
            String baseArchivePath = baseURL.toExternalForm();
            if (baseArchivePath.endsWith("/")) {
                baseArchivePath = baseArchivePath.substring(0, baseArchivePath.length() - 1);
            }
            if (baseArchivePath.endsWith("!")) {
                baseArchivePath = baseArchivePath.substring(0, baseArchivePath.length() - 1);
            }
            if (!relativeURL.startsWith("/")) {
                relativeURL = "/" + relativeURL;
            }
            return new URL(baseArchivePath + "!" + relativeURL);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isAbsoluteURL(String url) {
        return url.indexOf(":/") != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isResourceExist(URL resource) {
        InputStream is = null;
        try {
            is = resource.openStream();
            boolean bl = is != null;
            return bl;
        }
        catch (Exception ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                    is = null;
                }
                catch (IOException ignore) {}
            }
        }
    }

    public static boolean isFileResource(URL resource) {
        return !resource.toExternalForm().endsWith("/");
    }

    public static boolean isDirectoryResource(URL resource) {
        return resource.toExternalForm().endsWith("/");
    }

    public static Properties loadProperties(String path, Class<?> caller) {
        InputStream is = ResourceUtil.getResourceAsStream(path, caller);
        if (is == null) {
            throw new RuntimeException("Properties not found.path=" + path);
        }
        Properties p = new Properties();
        try {
            p.load(is);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return p;
    }

    public static InputStream getResourceAsStream(String path, Class<?> caller) {
        String resource = path;
        if (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        InputStream is = null;
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        if (is == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        }
        if (is == null) {
            is = caller.getResourceAsStream(path);
        }
        if (is == null) {
            is = ClassLoader.class.getResourceAsStream(path);
        }
        if (is == null) {
            is = ClassLoader.getSystemResourceAsStream(resource);
        }
        return is;
    }

    public static final int copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[8196];
        int totalSize = 0;
        int size = 0;
        while ((size = in.read(buf)) != -1) {
            out.write(buf, 0, size);
            totalSize += size;
        }
        return totalSize;
    }
}

