/*
 * Decompiled with CFR 0.152.
 */
package sdloader.util;

import java.io.IOException;
import java.io.OutputStream;

public class QoSOutputStream
extends OutputStream {
    private static final int SEC_SLICE_NUM = 8;
    private static final int BIT_PER_BYTE = 8;
    private static final int SLEEP_MILLI_SEC = 125;
    private OutputStream out;
    private int bytePerSliceSec;
    private boolean qos;
    private int writeBytes;
    private long lastSleepTime;

    public QoSOutputStream(OutputStream out, int bps) {
        this.out = out;
        if (bps <= -1) {
            this.qos = false;
        } else {
            this.bytePerSliceSec = Math.max(1, bps / 8 / 8);
            this.qos = true;
        }
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        if (this.qos) {
            ++this.writeBytes;
            if (this.lastSleepTime == 0L) {
                this.lastSleepTime = System.currentTimeMillis();
            }
            if (this.writeBytes == this.bytePerSliceSec) {
                long now = System.currentTimeMillis();
                long sleepTime = 125L - (now - this.lastSleepTime);
                if (sleepTime > 0L) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                this.lastSleepTime = System.currentTimeMillis();
                this.writeBytes = 0;
            }
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }
}

