/*
 * Decompiled with CFR 0.152.
 */
package sdloader.util;

import java.io.IOException;
import java.io.InputStream;

public class QoSInputStream
extends InputStream {
    private static final int SEC_SLICE_NUM = 8;
    private static final int BIT_PER_BYTE = 8;
    private static final int SLEEP_MILLI_SEC = 125;
    private InputStream in;
    private int bytePerSliceSec;
    private boolean qos;
    private int readBytes;
    private long lastSleepTime;

    public QoSInputStream(InputStream in, int bps) {
        this.in = in;
        if (bps <= -1) {
            this.qos = false;
        } else {
            this.bytePerSliceSec = Math.max(100, bps / 8 / 8);
            this.qos = true;
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int read() throws IOException {
        int b = this.in.read();
        if (this.qos) {
            ++this.readBytes;
            if (this.lastSleepTime == 0L) {
                this.lastSleepTime = System.currentTimeMillis();
            }
            if (this.readBytes == this.bytePerSliceSec) {
                long now = System.currentTimeMillis();
                long sleepTime = 125L - (now - this.lastSleepTime);
                if (sleepTime > 0L) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                this.lastSleepTime = System.currentTimeMillis();
                this.readBytes = 0;
            }
        }
        return b;
    }
}

