/*
 * Decompiled with CFR 0.152.
 */
package sdloader.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class PathUtil {
    public static String computeRelativePath(String basePath, String path) {
        basePath = basePath.substring(0, basePath.lastIndexOf("/"));
        return PathUtil.jointPathWithSlash(basePath, path);
    }

    public static String jointPathWithSlash(String path1, String path2) {
        path1 = PathUtil.removeEndSlashIfNeed(path1);
        path2 = PathUtil.removeStartSlashIfNeed(path2);
        return path1 + "/" + path2;
    }

    public static String appendStartSlashIfNeed(String path) {
        if (path != null && !PathUtil.startsWithSlash(path)) {
            return "/" + path;
        }
        return path;
    }

    public static String appendEndSlashIfNeed(String path) {
        if (path != null && !PathUtil.endsWithSlash(path)) {
            return path + "/";
        }
        return path;
    }

    public static String removeStartSlashIfNeed(String path) {
        if (path != null && PathUtil.startsWithSlash(path)) {
            return path.substring(1, path.length());
        }
        return path;
    }

    public static String removeEndSlashIfNeed(String path) {
        if (path != null && path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static boolean startsWithSlash(String path) {
        if (PathUtil.isEmpty(path)) {
            return false;
        }
        return path.indexOf("/") == 0;
    }

    public static boolean endsWithSlash(String path) {
        if (PathUtil.isEmpty(path)) {
            return false;
        }
        return path.lastIndexOf("/") == path.length() - 1;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static final String replaceFileSeparator(String path) {
        return path.replace('\\', '/');
    }

    public static final String getExtension(String path) {
        if (path == null) {
            return path;
        }
        int dot = path.lastIndexOf(".");
        if (dot == -1) {
            return null;
        }
        return path.substring(dot + 1, path.length());
    }

    public static final boolean isAbsolutePath(String path) {
        String testPath = PathUtil.replaceFileSeparator(path);
        return testPath.startsWith("/") || testPath.indexOf(":") != -1;
    }

    public static URL file2URL(String filePath) {
        return PathUtil.file2URL(new File(filePath));
    }

    public static URL file2URL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static File url2File(String urlPath) {
        try {
            return new File(new URI(urlPath));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static File url2File(URL url) {
        try {
            return new File(new URI(url.toExternalForm()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

