/*
 * Decompiled with CFR 0.152.
 */
package sdloader.util;

import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sdloader.util.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeParseHandler
extends DefaultHandler {
    private Stack<String> nameStack = new Stack();
    private String extension;
    private String mimeType;
    private Map<String, String> mimeMap = CollectionsUtil.newHashMap();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.nameStack.push(qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        char[] c = new char[length];
        System.arraycopy(ch, start, c, 0, length);
        String value = new String(c);
        String name = this.nameStack.peek();
        if (name.equals("extension")) {
            this.extension = value.toLowerCase();
        } else if (name.equals("mime-type")) {
            this.mimeType = value;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String name = this.nameStack.pop();
        if (name.equals("mime-mapping")) {
            if (this.extension != null && this.mimeType != null) {
                this.mimeMap.put(this.extension, this.mimeType);
            }
            this.mimeType = null;
            this.extension = null;
        }
    }

    public Map<String, String> getMimeMap() {
        return this.mimeMap;
    }
}

