/*
 * Decompiled with CFR 0.152.
 */
package sdloader.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.Flushable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class IOUtil {
    public static FileFilter IGNORE_DIR_FILEFILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() && !file.getName().equals("CVS") && !file.getName().startsWith(".");
        }
    };
    public static FileFilter WAR_FILEFILETR = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().endsWith(".war");
        }
    };
    public static FileFilter XML_FILEFILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().endsWith(".xml");
        }
    };
    public static FileFilter JAR_ZIP_FILEFILTER = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".jar") || pathname.getName().endsWith(".zip");
        }
    };

    public static boolean forceRemoveDirectory(File directory) {
        if (!directory.exists()) {
            return true;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return directory.delete();
        }
        boolean result = true;
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                if (IOUtil.forceRemoveDirectory(file)) continue;
                result = false;
                continue;
            }
            if (file.delete()) continue;
            result = false;
        }
        if (!directory.delete()) {
            result = false;
        }
        return result;
    }

    public static void flushNoException(Flushable flushable) {
        if (flushable != null) {
            try {
                flushable.flush();
            }
            catch (IOException ioe) {
                return;
            }
        }
    }

    public static void closeNoException(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ioe) {
                return;
            }
        }
    }

    public static void closeServerSocketNoException(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeSocketNoException(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static ServerSocket createServerSocket(int bindPort, boolean useOutSidePort) throws IOException {
        ServerSocket socket = new ServerSocket();
        try {
            if (useOutSidePort) {
                socket.bind(new InetSocketAddress(bindPort));
            } else {
                socket.bind(new InetSocketAddress(InetAddress.getByName("localhost"), bindPort));
            }
            return socket;
        }
        catch (IOException ioe) {
            IOUtil.closeServerSocketNoException(socket);
            throw ioe;
        }
    }
}

