/*
 * Decompiled with CFR 0.152.
 */
package sdloader.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class FastByteArrayOutputStream
extends OutputStream {
    private static final int DEFAULT_BLOCK_SIZE = 8192;
    private LinkedList<byte[]> buffers;
    private byte[] buffer;
    private int index;
    private int size;
    private int blockSize;
    private boolean closed;

    public FastByteArrayOutputStream() {
        this(8192);
    }

    public FastByteArrayOutputStream(int blockSize) {
        this.blockSize = blockSize;
        this.buffer = new byte[this.blockSize];
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.buffers != null) {
            for (byte[] bytes : this.buffers) {
                out.write(bytes, 0, this.blockSize);
            }
        }
        out.write(this.buffer, 0, this.index);
    }

    public int getSize() {
        return this.size + this.index;
    }

    public byte[] toByteArray() {
        ByteBuffer data = ByteBuffer.allocate(this.getSize());
        if (this.buffers != null) {
            for (byte[] bytes : this.buffers) {
                data.put(bytes);
            }
        }
        data.put(this.buffer, 0, this.index);
        return data.array();
    }

    protected void addBuffer() {
        if (this.buffers == null) {
            this.buffers = new LinkedList();
        }
        this.buffers.addLast(this.buffer);
        this.buffer = new byte[this.blockSize];
        this.size += this.index;
        this.index = 0;
    }

    public void write(int datum) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.index == this.blockSize) {
            this.addBuffer();
        }
        this.buffer[this.index++] = (byte)datum;
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        if (data == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset + length > data.length || length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.index + length > this.blockSize) {
            int copyLength;
            do {
                if (this.index == this.blockSize) {
                    this.addBuffer();
                }
                if (length < (copyLength = this.blockSize - this.index)) {
                    copyLength = length;
                }
                System.arraycopy(data, offset, this.buffer, this.index, copyLength);
                offset += copyLength;
                this.index += copyLength;
            } while ((length -= copyLength) > 0);
        } else {
            System.arraycopy(data, offset, this.buffer, this.index, length);
            this.index += length;
        }
    }

    public void reset() {
        this.closed = false;
        this.buffers = null;
        this.buffer = new byte[this.blockSize];
        this.index = 0;
        this.size = 0;
    }

    public void close() {
        this.closed = true;
    }
}

