/*
 * Decompiled with CFR 0.152.
 */
package sdloader.util;

import java.util.LinkedList;
import sdloader.util.CollectionsUtil;

public final class DisposableUtil {
    private static boolean DEBUG = false;
    protected static final LinkedList<Disposable> disposables = CollectionsUtil.newLinkedList();

    public static synchronized void add(Disposable disposable) {
        disposables.add(disposable);
    }

    public static synchronized void remove(Disposable disposable) {
        disposables.remove(disposable);
    }

    public static synchronized void dispose() {
        if (DEBUG) {
            DisposableUtil.listDisposables();
        }
        while (!disposables.isEmpty()) {
            Disposable disposable = disposables.removeLast();
            try {
                disposable.dispose();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        disposables.clear();
    }

    private static void listDisposables() {
        for (Disposable disposable : disposables) {
            System.out.println("[Disposable] dipose : " + disposable.toString());
        }
    }

    public static interface Disposable {
        public void dispose();
    }
}

