/*
 * Decompiled with CFR 0.152.
 */
package sdloader.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sdloader.util.Assertion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    public static <T> Class<T> forName(String className) {
        String name = Assertion.notNull(className);
        ClassLoader loader = Assertion.notNull(Thread.currentThread().getContextClassLoader());
        return ClassUtil.forName(name, loader);
    }

    public static <T> Class<T> forName(String className, ClassLoader loader) {
        try {
            return Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Class<T> forNameNoException(String className) {
        String name = Assertion.notNull(className);
        ClassLoader loader = Assertion.notNull(Thread.currentThread().getContextClassLoader());
        return ClassUtil.forNameNoException(name, loader);
    }

    public static <T> Class<T> forNameNoException(String className, ClassLoader loader) {
        try {
            return Class.forName(className, true, loader);
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    public static <T> T newInstance(String clazzName) {
        return ClassUtil.newInstance(ClassUtil.forName(clazzName));
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isAssignableFrom(Class from, Class to) {
        boolean fromPrimitive = from.isPrimitive();
        if (to == Object.class && !fromPrimitive) {
            return true;
        }
        boolean toPrimitive = to.isPrimitive();
        if (!fromPrimitive && toPrimitive || fromPrimitive && !toPrimitive) {
            return false;
        }
        return to.isAssignableFrom(from);
    }

    public static boolean hasClass(String className) {
        if (className == null) {
            return false;
        }
        try {
            Class c = ClassUtil.forName(className);
            return c != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static Method getMethod(Class<?> target, String methodName, Class<?>[] params) {
        try {
            return target.getDeclaredMethod(methodName, params);
        }
        catch (Exception e) {
            target = target.getSuperclass();
            if (target != null) {
                return ClassUtil.getMethod(target, methodName, params);
            }
            throw new RuntimeException(e);
        }
    }

    public static Method getMethodNoException(Class<?> target, String methodName, Class<?>[] params) {
        try {
            return target.getDeclaredMethod(methodName, params);
        }
        catch (Exception e) {
            target = target.getSuperclass();
            if (target != null) {
                return ClassUtil.getMethodNoException(target, methodName, params);
            }
            return null;
        }
    }

    public static Object invoke(Object target, Method method, Object[] params) {
        try {
            method.setAccessible(true);
            return method.invoke(target, params);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

