/*
 * Decompiled with CFR 0.152.
 */
package sdloader.tool.helper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sdloader.util.IOUtil;
import sdloader.util.ResourceUtil;

public class ProjectTemplateHelper {
    public static void execute(String webContentDir, InputStream webXml, InputStream indexHtml, InputStream mainJavaTemplate) {
        try {
            File baseDir = new File(".");
            ProjectTemplateHelper.createProjectTemplate(baseDir, webContentDir, webXml, indexHtml);
            File classPathFile = ProjectTemplateHelper.getEclipseClassPathFile(baseDir);
            if (classPathFile != null) {
                ProjectTemplateHelper.modifyEclipseClassPath(baseDir, classPathFile, webContentDir);
            }
            ProjectTemplateHelper.createMainClass(baseDir, mainJavaTemplate);
            System.out.println("Create success.Reflesh the project.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createProjectTemplate(File baseDir, String webContentName, InputStream webXmlStream, InputStream indexHtmlStream) throws IOException {
        File webContent;
        if (webContentName == null) {
            webContent = baseDir;
        } else {
            webContent = new File(baseDir, webContentName);
            ProjectTemplateHelper.mkdir(webContentName, webContent);
        }
        File indexHtml = new File(webContent, "index.html");
        if (!indexHtml.exists()) {
            indexHtml.createNewFile();
            FileOutputStream fout = new FileOutputStream(indexHtml);
            ResourceUtil.copyStream(indexHtmlStream, fout);
            fout.flush();
            fout.close();
            System.out.println("Create index.html");
        }
        File webInf = new File(webContent, "WEB-INF");
        ProjectTemplateHelper.mkdir("WEB-INF", webInf);
        File lib = new File(webInf, "lib");
        ProjectTemplateHelper.mkdir("WEB-INF/lib", lib);
        File classes = new File(webInf, "classes");
        ProjectTemplateHelper.mkdir("WEB-INF/classes", classes);
        File webxml = new File(webInf, "web.xml");
        if (!webxml.exists()) {
            webxml.createNewFile();
            FileOutputStream fout = new FileOutputStream(webxml);
            ResourceUtil.copyStream(webXmlStream, fout);
            fout.flush();
            fout.close();
            System.out.println("Create WEB-INF/web.xml");
        }
    }

    private static void mkdir(String name, File dir) throws IOException {
        if (!dir.exists() && !dir.mkdir()) {
            throw new IOException(name + " create fail!");
        }
    }

    public static File getEclipseClassPathFile(File projectDir) {
        File classPathFile = new File(projectDir, ".classpath");
        return classPathFile.exists() ? classPathFile : null;
    }

    public static boolean modifyEclipseClassPath(File projectDir, File classPathFile, String WebContentPath) {
        try {
            String classesPath = "";
            if (WebContentPath != null) {
                classesPath = classesPath + WebContentPath + "/";
            }
            classesPath = classesPath + "WEB-INF/classes";
            Document classPathDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(classPathFile);
            NodeList entryList = classPathDocument.getFirstChild().getChildNodes();
            for (int i = 0; i < entryList.getLength(); ++i) {
                Node pathNode;
                String oldPath;
                Node kindNode;
                String kind;
                Node node = entryList.item(i);
                if (!(node instanceof Element) || !"output".equals(kind = (kindNode = node.getAttributes().getNamedItem("kind")).getNodeValue()) || (oldPath = (pathNode = node.getAttributes().getNamedItem("path")).getNodeValue()).equals(classesPath)) continue;
                pathNode.setNodeValue(classesPath);
                DOMSource source = new DOMSource(classPathDocument);
                FileOutputStream fout = new FileOutputStream(classPathFile);
                StreamResult result = new StreamResult(fout);
                TransformerFactory.newInstance().newTransformer().transform(source, result);
                IOUtil.forceRemoveDirectory(new File(projectDir, oldPath));
                System.out.println("Class file output folder modified.");
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void createMainClass(File projectDir, InputStream mainJavaTemplateStream) throws IOException {
        File mainFile;
        File srcDir = new File(projectDir, "src");
        if (srcDir.exists() && !(mainFile = new File(srcDir, "SDLoaderStartMain.java")).exists()) {
            mainFile.createNewFile();
            FileOutputStream fout = new FileOutputStream(mainFile);
            ResourceUtil.copyStream(mainJavaTemplateStream, fout);
            fout.flush();
            fout.close();
            System.out.println("Create SDLoaderStartMain.java file.");
        }
    }
}

