/*
 * Decompiled with CFR 0.152.
 */
package sdloader.log;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import sdloader.log.SDLoaderLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDLoaderLogSystemImpl
implements SDLoaderLog {
    private static final String DEBUG = "DEBUG";
    private static final String INFO = "INFO";
    private static final String WARN = "WARN";
    private static final String ERROR = "ERROR";
    private static final String FATAL = "FATAL";
    private String className;

    public SDLoaderLogSystemImpl(Class<?> c) {
        this.className = c.getName();
    }

    @Override
    public void debug(Object log) {
        this.debug(log, null);
    }

    @Override
    public void debug(Object log, Throwable t) {
        if (this.isDebugEnabled()) {
            this.log(DEBUG, log, t);
        }
    }

    @Override
    public void error(Object log) {
        this.error(log, null);
    }

    @Override
    public void error(Object log, Throwable t) {
        this.log(ERROR, this.className + " " + log, t);
    }

    @Override
    public void info(Object log) {
        this.info(log, null);
    }

    @Override
    public void info(Object log, Throwable t) {
        if (this.isInfoEnabled()) {
            this.log(INFO, log, null);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public void warn(Object log) {
        this.warn(log, null);
    }

    @Override
    public void warn(Object log, Throwable t) {
        if (this.isWarnEnabled()) {
            this.log(WARN, this.className + " " + log, t);
        }
    }

    @Override
    public void fatal(Object log) {
        this.fatal(log, null);
    }

    @Override
    public void fatal(Object log, Throwable t) {
        this.log(FATAL, this.className + " " + log, t);
    }

    private void log(String level, Object log, Throwable t) {
        PrintStream w;
        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
        String logtext = "[" + level + "] " + time + " : ";
        if (log != null) {
            logtext = logtext + log.toString() + " ";
        }
        boolean systemOut = level.equals(DEBUG) || level.equals(INFO);
        PrintStream printStream = w = systemOut ? System.out : System.err;
        if (t != null) {
            logtext = logtext + t.getMessage();
            w.println(logtext);
            t.printStackTrace();
        } else {
            w.println(logtext);
        }
    }

    @Override
    public void release() {
        this.log(INFO, "logger released.", null);
    }
}

