/*
 * Decompiled with CFR 0.152.
 */
package sdloader.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import sdloader.log.SDLoaderLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDLoaderLogJDKLoggerImpl
implements SDLoaderLog {
    private Logger logger;

    public SDLoaderLogJDKLoggerImpl(Class<?> c) {
        this.logger = Logger.getLogger(c.getName());
    }

    protected String format(Object log, Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stringWriter);
        if (log != null) {
            pw.print(log.toString());
        }
        if (t != null) {
            pw.println();
            t.printStackTrace(pw);
        }
        pw.flush();
        pw.close();
        return stringWriter.toString();
    }

    @Override
    public void debug(Object log) {
        this.logger.config(this.format(log, null));
    }

    @Override
    public void debug(Object log, Throwable t) {
        this.logger.config(this.format(log, t));
    }

    @Override
    public void info(Object log) {
        this.logger.info(this.format(log, null));
    }

    @Override
    public void info(Object log, Throwable t) {
        this.logger.info(this.format(log, t));
    }

    @Override
    public void warn(Object log) {
        this.logger.warning(this.format(log, null));
    }

    @Override
    public void warn(Object log, Throwable t) {
        this.logger.warning(this.format(log, t));
    }

    @Override
    public void error(Object log) {
        this.logger.severe(this.format(log, null));
    }

    @Override
    public void error(Object log, Throwable t) {
        this.logger.severe(this.format(log, t));
    }

    @Override
    public void fatal(Object log) {
        this.logger.severe(this.format(log, null));
    }

    @Override
    public void fatal(Object log, Throwable t) {
        this.logger.severe(this.format(log, t));
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.CONFIG);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void release() {
        this.logger = null;
    }
}

