/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee.webxml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sdloader.javaee.webxml.ContextParamTag;
import sdloader.javaee.webxml.ErrorPageTag;
import sdloader.javaee.webxml.FilterMappingTag;
import sdloader.javaee.webxml.FilterTag;
import sdloader.javaee.webxml.InitParamTag;
import sdloader.javaee.webxml.ListenerTag;
import sdloader.javaee.webxml.ServletMappingTag;
import sdloader.javaee.webxml.ServletTag;
import sdloader.javaee.webxml.WebAppTag;
import sdloader.javaee.webxml.WebXmlTagElement;
import sdloader.javaee.webxml.WelcomeFileListTag;
import sdloader.util.Assertion;
import sdloader.util.ClassUtil;
import sdloader.util.CollectionsUtil;

public class WebXmlParseHandler
extends DefaultHandler {
    private Map<String, Class<? extends WebXmlTagElement>> tag2classMap = CollectionsUtil.newHashMap();
    private Map<String, URL> resolveMap;
    private Map<String, WebXmlTagElement> tagInstanceMap;
    private Stack<String> tagNameStack;
    private String characters;
    private Object rootObject;

    public WebXmlParseHandler() {
        this.tag2classMap.put("web-app", WebAppTag.class);
        this.tag2classMap.put("context-param", ContextParamTag.class);
        this.tag2classMap.put("filter", FilterTag.class);
        this.tag2classMap.put("filter-mapping", FilterMappingTag.class);
        this.tag2classMap.put("listener", ListenerTag.class);
        this.tag2classMap.put("servlet", ServletTag.class);
        this.tag2classMap.put("servlet-mapping", ServletMappingTag.class);
        this.tag2classMap.put("init-param", InitParamTag.class);
        this.tag2classMap.put("welcome-file-list", WelcomeFileListTag.class);
        this.tag2classMap.put("error-page", ErrorPageTag.class);
        this.resolveMap = CollectionsUtil.newHashMap();
        this.tagInstanceMap = CollectionsUtil.newHashMap();
        this.tagNameStack = CollectionsUtil.newStack();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tagNameStack.push(Assertion.notNull(qName));
        this.characters = null;
        Class<? extends WebXmlTagElement> tagClass = this.tag2classMap.get(qName);
        if (tagClass != null) {
            WebXmlTagElement tag = ClassUtil.newInstance(tagClass);
            this.tagInstanceMap.put(qName, tag);
            if (this.rootObject == null) {
                this.rootObject = tag;
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        char[] c = new char[length];
        System.arraycopy(ch, start, c, 0, length);
        String value = new String(c).trim();
        this.characters = this.characters == null ? value : this.characters + value;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String methodName;
        WebXmlTagElement target;
        String valueTagName = this.tagNameStack.pop();
        if (this.tagNameStack.isEmpty()) {
            return;
        }
        Object o = this.tagInstanceMap.remove(valueTagName);
        if (o == null) {
            o = this.characters;
        }
        if (o != null && (target = this.tagInstanceMap.get(this.tagNameStack.peek())) != null && !this.invoke(methodName = "set" + this.toCamelCase(valueTagName), target, o)) {
            methodName = "add" + this.toCamelCase(valueTagName);
            this.invoke(methodName, target, o);
        }
    }

    public Object getRootObject() {
        return this.rootObject;
    }

    private String toCamelCase(String tagName) {
        char[] chars = tagName.toCharArray();
        String camelCase = "";
        boolean toUpper = false;
        for (int i = 0; i < chars.length; ++i) {
            String c = String.valueOf(chars[i]);
            if (i == 0 || toUpper) {
                camelCase = camelCase + c.toUpperCase();
                toUpper = false;
                continue;
            }
            if (c.equals("-")) {
                toUpper = true;
                continue;
            }
            camelCase = camelCase + c;
        }
        return camelCase;
    }

    private boolean invoke(String methodName, Object target, Object o) {
        Method setter = ClassUtil.getMethodNoException(target.getClass(), methodName, new Class[]{o.getClass()});
        if (setter != null) {
            ClassUtil.invoke(target, setter, new Object[]{o});
            return true;
        }
        Method[] methods = target.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != 1) continue;
            Class<?> paramType = method.getParameterTypes()[0];
            if (paramType == Integer.class || paramType == Integer.TYPE) {
                o = Integer.parseInt(((Object)o).toString());
            } else {
                if (paramType != Class.class) continue;
                o = ClassUtil.forName(((Object)o).toString());
            }
            ClassUtil.invoke(target, method, new Object[]{o});
            return true;
        }
        return false;
    }

    public void register(String id, URL resourceUrl) {
        this.resolveMap.put(id, resourceUrl);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        URL resourceUrl = this.resolveMap.get(publicId);
        if (resourceUrl == null) {
            resourceUrl = this.resolveMap.get(systemId);
        }
        if (resourceUrl != null) {
            InputStream is = resourceUrl.openStream();
            return new InputSource(is);
        }
        return super.resolveEntity(publicId, systemId);
    }
}

