/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee.webxml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import sdloader.exception.IORuntimeException;
import sdloader.javaee.webxml.WebAppTag;
import sdloader.javaee.webxml.WebXml;
import sdloader.javaee.webxml.WebXmlParseHandler;
import sdloader.log.SDLoaderLog;
import sdloader.log.SDLoaderLogFactory;
import sdloader.util.Assertion;
import sdloader.util.CollectionsUtil;
import sdloader.util.ResourceUtil;

public class WebXmlBuilder {
    private static SDLoaderLog log = SDLoaderLogFactory.getLog(WebXmlBuilder.class);
    private static Map<String, String> registrations = CollectionsUtil.newHashMap();

    public static WebXml build(String webXmlUrl) throws IORuntimeException {
        InputStream is = ResourceUtil.getResourceAsStream(webXmlUrl, WebXmlBuilder.class);
        if (is == null) {
            throw new IORuntimeException("Resource not found.path=" + webXmlUrl);
        }
        return WebXmlBuilder.build(is);
    }

    public static WebXml build(URL webXmlUrl) throws IORuntimeException {
        InputStream is = null;
        try {
            is = webXmlUrl.openStream();
        }
        catch (IOException ioe) {
            throw new IORuntimeException(ioe);
        }
        WebXml webxml = WebXmlBuilder.build(is);
        return webxml;
    }

    public static WebXml build(InputStream is) throws IORuntimeException {
        try {
            SAXParser sax = SAXParserFactory.newInstance().newSAXParser();
            WebXmlParseHandler handler = new WebXmlParseHandler();
            for (String key : registrations.keySet()) {
                String value = registrations.get(key);
                URL url = WebXml.class.getResource(value);
                if (url != null) {
                    handler.register(Assertion.notNull(key), Assertion.notNull(url));
                    continue;
                }
                log.warn("registration resource not found.key=" + key + " value=" + value);
            }
            sax.parse(is, (DefaultHandler)handler);
            WebXml webxml = new WebXml();
            WebAppTag webAppTag = (WebAppTag)handler.getRootObject();
            webxml.setWebApp(webAppTag);
            return webxml;
        }
        catch (Exception e) {
            throw new IORuntimeException(e);
        }
    }

    static {
        registrations.put("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "/sdloader/resource/web-app_2_2.dtd");
        registrations.put("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "/sdloader/resource/web-app_2_3.dtd");
    }
}

