/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sdloader.javaee.servlet.FileSavingServlet;
import sdloader.util.ResourceUtil;

public class InMemoryFileSavingServlet
extends FileSavingServlet {
    protected void doIt(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        int i;
        String uri = req.getPathInfo();
        if (uri == null) {
            this.processNotFound(res);
            return;
        }
        if (uri.startsWith("/WEB-INF/") || uri.endsWith("/WEB-INF")) {
            this.processNotFound(res);
            return;
        }
        if (!uri.endsWith("/")) {
            for (i = 0; i < this.docRootPath.length; ++i) {
                URL file = ResourceUtil.createURL(this.docRootPath[i], uri);
                if (!ResourceUtil.isResourceExist(file)) continue;
                this.processOutputResource(file, req, res);
                return;
            }
            uri = uri + "/";
        }
        for (i = 0; i < this.docRootPath.length; ++i) {
            URL dir = ResourceUtil.createURL(this.docRootPath[i], uri);
            if (!ResourceUtil.isResourceExist(dir) || this.welcomeFileListTag == null) continue;
            this.processWelcomeFile(dir, req, res);
            return;
        }
        this.processNotFound(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processOutputResource(URL resource, HttpServletRequest req, HttpServletResponse res) throws IOException {
        InputStream is = resource.openStream();
        ServletOutputStream sout = res.getOutputStream();
        try {
            int size = ResourceUtil.copyStream(is, sout);
            this.setContentType(res, resource.toExternalForm());
            res.setContentLength(size);
            res.setStatus(200);
        }
        finally {
            is.close();
            sout.flush();
            sout.close();
        }
    }
}

