/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sdloader.javaee.InternalWebApplication;
import sdloader.javaee.impl.ServletContextImpl;
import sdloader.javaee.webxml.ServletMappingTag;
import sdloader.javaee.webxml.WelcomeFileListTag;
import sdloader.util.PathUtil;
import sdloader.util.ResourceUtil;
import sdloader.util.WebUtil;

public class FileSavingServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_DOC_ROOT = "docRootPath";
    public static final String PARAM_IGNORE_LAST_MODIFIED = "ignoreLastModified";
    protected URL[] docRootPath;
    protected WelcomeFileListTag welcomeFileListTag;
    protected InternalWebApplication webApp;
    protected boolean ignoreLastModified;

    public void init() throws ServletException {
        String docRootStr = this.getInitParameter(PARAM_DOC_ROOT);
        if (docRootStr == null) {
            throw new ServletException("InitParameter [docRootPath] not found.");
        }
        String[] paths = docRootStr.split(",");
        this.docRootPath = new URL[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            this.docRootPath[i] = ResourceUtil.createURL(paths[i]);
        }
        ServletContextImpl servletContext = (ServletContextImpl)this.getServletContext();
        this.webApp = servletContext.getWebApplication();
        this.welcomeFileListTag = this.webApp.getWebXml().getWebApp().getWelcomeFileList();
        String ignoreLastModifiedParam = this.getInitParameter(PARAM_IGNORE_LAST_MODIFIED);
        if (ignoreLastModifiedParam != null) {
            this.ignoreLastModified = Boolean.parseBoolean(ignoreLastModifiedParam);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doIt(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doIt(req, res);
    }

    protected void doIt(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String uri = req.getPathInfo();
        if (uri == null) {
            this.processNotFound(res);
            return;
        }
        if (uri.startsWith("/WEB-INF/") || uri.endsWith("/WEB-INF")) {
            this.processNotFound(res);
            return;
        }
        File fileOrDir = null;
        for (int i = 0; i < this.docRootPath.length; ++i) {
            File testFile = PathUtil.url2File(this.docRootPath[i].toExternalForm() + uri);
            if (!testFile.exists()) continue;
            fileOrDir = testFile;
            break;
        }
        if (fileOrDir == null) {
            this.processNotFound(res);
            return;
        }
        if (fileOrDir.isFile()) {
            File file = fileOrDir;
            this.processOutputFile(file, req, res);
            return;
        }
        if (this.welcomeFileListTag != null) {
            File dir = fileOrDir;
            this.processWelcomeFile(dir.toURI().toURL(), req, res);
            return;
        }
        this.processNotFound(res);
    }

    protected void processWelcomeFile(URL dir, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String basePath = req.getPathInfo();
        basePath = PathUtil.appendEndSlashIfNeed(basePath);
        ServletContextImpl context = (ServletContextImpl)this.getServletContext();
        InternalWebApplication webapp = context.getWebApplication();
        List<String> welcomeFileList = this.welcomeFileListTag.getWelcomeFileList();
        List<ServletMappingTag> servletMappingList = webapp.getWebXml().getWebApp().getServletMapping();
        for (String welcomefileName : welcomeFileList) {
            String path = basePath + welcomefileName;
            for (ServletMappingTag mappingTag : servletMappingList) {
                int matchType = WebUtil.matchPattern(mappingTag.getUrlPattern(), path);
                if (matchType != 4) continue;
                context.getRequestDispatcher(path).forward(req, res);
                return;
            }
            URL welcomeFile = ResourceUtil.createURL(dir, welcomefileName);
            if (!ResourceUtil.isResourceExist(welcomeFile)) continue;
            context.getRequestDispatcher(path).forward(req, res);
            return;
        }
        this.processNotFound(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processOutputFile(File file, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!this.ignoreLastModified) {
            Date lastModifyDate = new Date(file.lastModified());
            res.setHeader("Last-Modified", WebUtil.formatHeaderDate(lastModifyDate));
            String ifModified = req.getHeader("If-Modified-Since");
            if (!this.isModifiedSince(lastModifyDate, ifModified)) {
                res.setStatus(304);
                return;
            }
        }
        FileInputStream fin = new FileInputStream(file);
        ServletOutputStream sout = res.getOutputStream();
        try {
            int size = ResourceUtil.copyStream(fin, sout);
            this.setContentType(res, file.getName());
            res.setContentLength(size);
            res.setStatus(200);
        }
        finally {
            fin.close();
            sout.flush();
            sout.close();
        }
    }

    protected void processNotFound(HttpServletResponse res) throws IOException {
        WebUtil.writeNotFoundPage(res);
    }

    protected boolean isModifiedSince(Date fileLastModify, String ifModifiedSince) {
        if (ifModifiedSince == null) {
            return true;
        }
        try {
            long ifModifiedTime = WebUtil.parseHeaderDate(ifModifiedSince.trim());
            long lastModifyTime = fileLastModify.getTime();
            return lastModifyTime > ifModifiedTime;
        }
        catch (NumberFormatException ne) {
            return true;
        }
        catch (ParseException e) {
            return true;
        }
    }

    protected void setContentType(HttpServletResponse res, String path) {
        int dotIndex = path.lastIndexOf(".");
        if (dotIndex >= 0) {
            ServletContext sc = this.getServletContext();
            try {
                String ext = path.substring(dotIndex + 1);
                String type = sc.getMimeType(ext);
                if (type == null) {
                    type = sc.getMimeType(ext.toLowerCase());
                }
                if (type == null) {
                    type = sc.getMimeType(ext.toUpperCase());
                }
                if (type != null) {
                    res.setContentType(type);
                    return;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        res.setContentType("text/html");
    }
}

