/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee.jasper;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;
import org.xml.sax.InputSource;
import sdloader.internal.resource.ArchiveTypeResource;
import sdloader.internal.resource.BranchTypeResource;
import sdloader.internal.resource.DirectoryTypeResource;
import sdloader.internal.resource.LeafTypeResource;
import sdloader.internal.resource.Resource;
import sdloader.javaee.classloader.InMemoryWebAppClassLoader;
import sdloader.log.SDLoaderLog;
import sdloader.log.SDLoaderLogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryTldLocationsCache
extends TldLocationsCache {
    private static SDLoaderLog log = SDLoaderLogFactory.getLog(InMemoryTldLocationsCache.class);
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String FILE_PROTOCOL = "file:";
    private static final String JAR_FILE_SUFFIX = ".jar";
    private Hashtable<String, String[]> mappings;
    private boolean initialized;
    private ServletContext ctxt;
    private Hashtable<String, TagLibraryInfo> tlds;

    public InMemoryTldLocationsCache(ServletContext ctxt) {
        this(ctxt, true);
    }

    public InMemoryTldLocationsCache(ServletContext ctxt, boolean redeployMode) {
        super(ctxt, redeployMode);
        this.ctxt = ctxt;
        this.mappings = new Hashtable();
        this.initialized = false;
    }

    @Override
    public String[] getLocation(String uri) throws JasperException {
        if (!this.initialized) {
            this.init();
        }
        return this.mappings.get(uri);
    }

    private void init() throws JasperException {
        if (this.initialized) {
            return;
        }
        try {
            this.processWebDotXml();
            this.scanWebInf();
            this.initialized = true;
        }
        catch (Exception ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.internal.tldinit", ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWebDotXml() throws Exception {
        InputStream is = null;
        try {
            String altDDName = (String)this.ctxt.getAttribute(Constants.ALT_DD_ATTR);
            URL uri = null;
            if (altDDName != null) {
                try {
                    uri = new URL(FILE_PROTOCOL + altDDName.replace('\\', '/'));
                }
                catch (MalformedURLException e) {
                    if (log.isWarnEnabled()) {
                        log.warn(Localizer.getMessage("jsp.error.internal.filenotfound", altDDName));
                    }
                }
            } else {
                uri = this.ctxt.getResource(WEB_XML);
                if (uri == null && log.isWarnEnabled()) {
                    log.warn(Localizer.getMessage("jsp.error.internal.filenotfound", WEB_XML));
                }
            }
            if (uri == null) {
                return;
            }
            is = uri.openStream();
            InputSource ip = new InputSource(is);
            ip.setSystemId(uri.toExternalForm());
            TreeNode webtld = null;
            webtld = altDDName != null ? new ParserUtils().parseXMLDocument(altDDName, ip) : new ParserUtils().parseXMLDocument(WEB_XML, ip);
            TreeNode jspConfig = webtld.findChild("jsp-config");
            if (jspConfig != null) {
                webtld = jspConfig;
            }
            Iterator taglibs = webtld.findChildren("taglib");
            while (taglibs.hasNext()) {
                TreeNode taglib = (TreeNode)taglibs.next();
                String tagUri = null;
                String tagLoc = null;
                TreeNode child = taglib.findChild("taglib-uri");
                if (child != null) {
                    tagUri = child.getBody();
                }
                if ((child = taglib.findChild("taglib-location")) != null) {
                    tagLoc = child.getBody();
                }
                if (tagLoc == null) continue;
                if (InMemoryTldLocationsCache.uriType(tagLoc) == 2) {
                    tagLoc = "/WEB-INF/" + tagLoc;
                }
                String tagLoc2 = null;
                if (tagLoc.endsWith(JAR_FILE_SUFFIX)) {
                    tagLoc = this.ctxt.getResource(tagLoc).toString();
                    tagLoc2 = "META-INF/taglib.tld";
                }
                this.mappings.put(tagUri, new String[]{tagLoc, tagLoc2});
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private void scanWebInf() throws Exception {
        InMemoryWebAppClassLoader webAppClassLoader = (InMemoryWebAppClassLoader)Thread.currentThread().getContextClassLoader();
        Map<URL, Resource> resourceMap = webAppClassLoader.getResources();
        for (URL key : resourceMap.keySet()) {
            Resource resource = resourceMap.get(key);
            String resourceName = resource.getOriginalPath();
            if (resource instanceof ArchiveTypeResource && ((ArchiveTypeResource)resource).isRuntimeNeeded()) {
                this.scanJar((ArchiveTypeResource)resource, true);
                continue;
            }
            if (!(resource instanceof ArchiveTypeResource) || !resourceName.startsWith("/WEB-INF") || !resourceName.endsWith(".tld")) continue;
            this.mappingTldResource(resource);
        }
    }

    private void scanJar(ArchiveTypeResource archive, boolean ignore) throws JasperException {
        block3: {
            try {
                BranchTypeResource metainf = (BranchTypeResource)archive.getArchiveResource("/META-INF/");
                if (metainf != null) {
                    List<Resource> resources = metainf.getResources();
                    this.scanList(resources);
                }
            }
            catch (Exception ex) {
                if (ignore) break block3;
                throw new JasperException(ex);
            }
        }
    }

    private void scanList(List<Resource> resources) throws Exception {
        if (resources == null) {
            return;
        }
        for (Resource res : resources) {
            if (res instanceof LeafTypeResource && res.getPath().endsWith(".tld")) {
                this.mappingTldResource(res);
                continue;
            }
            if (!(res instanceof DirectoryTypeResource)) continue;
            this.scanList(((DirectoryTypeResource)res).getResources());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mappingTldResource(Resource res) throws Exception {
        InputStream stream = res.getResourceAsInputStream();
        String resourcePath = res.getURL().toExternalForm();
        String name = res.getOriginalPath();
        try {
            String uri = this.getUriFromTld(resourcePath, stream);
            if (uri != null && this.mappings.get(uri) == null) {
                this.mappings.put(uri, new String[]{resourcePath, name});
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private String getUriFromTld(String resourcePath, InputStream in) throws JasperException {
        String body;
        TreeNode tld = new ParserUtils().parseXMLDocument(resourcePath, in);
        TreeNode uri = tld.findChild("uri");
        if (uri != null && (body = uri.getBody()) != null) {
            return body;
        }
        return null;
    }

    public TagLibraryInfo getTagLibraryInfo(String uri) {
        if (!this.initialized) {
            try {
                this.init();
            }
            catch (JasperException e) {
                throw new RuntimeException(e);
            }
        }
        return this.tlds.get(uri);
    }

    public void addTagLibraryInfo(String uri, TagLibraryInfo tld) {
        if (!this.initialized) {
            try {
                this.init();
            }
            catch (JasperException e) {
                throw new RuntimeException(e);
            }
        }
        this.tlds.put(uri, tld);
    }
}

